<?php
isset($_SESSION) or session_start();

//error_reporting(0);//desactivo errores
ini_set('display_errors', 1);
// Motrar todos los errores de PHP
error_reporting(E_ALL);//muestro errores
//evita el error Fatal error: Allowed memory size of X bytes exhausted (tried to allocate Y bytes)...
ini_set('memory_limit', '-1'); 
// es lo mismo que set_time_limit(300) ;
ini_set('max_execution_time', 3800); 
//error_log("display_errors", 3, "error_log.log");

date_default_timezone_set('America/Santiago');

require_once __DIR__ . '/classconexion.php';
/* Clase principal de PHPMailer */
require_once __DIR__ . '/PHPMailer/PHPMailer.php';
/* Clase SMTP, necesaria si quieres usar SMTP */
require_once __DIR__ . '/PHPMailer/SMTP.php';
/* Clase Exception */
require_once __DIR__ . '/PHPMailer/Exception.php';
require_once __DIR__ . '/lioren.php';
require_once __DIR__ . '/pusher.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

use Core\sentry\Sentry;
use Illuminate\Database\Capsule\Manager as Capsule;

Sentry::init();

################################## CLASE LOGIN ###################################
class Login extends Db{	

public $carpeta;
private $dbh;
private $p = [];
public function __construct() {
   // Inicializar la propiedad con el nombre de la carpeta base
   $this->carpeta = 'ventascl';
   // Obtener la única instancia de PDO a través del Singleton
   try {
      $this->dbh = Db::getInstance();
   } catch (Exception $e) {
      // Manejar el error de conexión si ocurre
      error_log("Error en Login al obtener conexión DB: " . $e->getMessage());
      // Podrías lanzar una excepción o simplemente no continuar con la lógica
      // que requiere la base de datos.
      die("Error interno del sistema. Intente más tarde."); // O una respuesta más amigable
   }
}

###################### FUNCION PARA EXPIRAR SESSION POR INACTIVIDAD ####################
function ExpiraSession($tiempoInactividad = 1800, $paginaDestino = 'logout.php') {
    try {
        if (!isset($_SESSION['usuario'])) {
            header("Location: $paginaDestino");
            exit;
        }
        $tiempoActual = time();
        //$ultimoAcceso = $_SESSION['ultimo_acceso'];
        $ultimoAcceso = (isset($_SESSION['time']) ? $_SESSION['time'] : strtotime(date("Y-m-d H:i:s")));
        $inactividad  = $tiempoActual - $ultimoAcceso;

        if ($inactividad >= $tiempoInactividad) {
            // Opción 1: Redirigir directamente
            header("Location: $paginaDestino");
            exit;
        } else {
            $_SESSION['ultimo_acceso'] = $tiempoActual;
        }
    } catch (Exception $e) {
        error_log("Error al expirar sesión: " . $e->getMessage());
    }
}
###################### FUNCION PARA EXPIRAR SESSION POR INACTIVIDAD ####################


#################### FUNCION PARA ACCEDER AL SISTEMA ####################
public function Logueo()
{
	$this->p = [];
	if(empty($_POST["usuario"]) or empty($_POST["password"]))
	{
		echo "1";
		exit;
	}
	$Usuario   = limpiar($_POST['usuario']);
	$Password  = limpiar($_POST['password']);
	$sql = "SELECT
	usu.*,
	suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.id_ciudad, suc.id_comuna, 
	suc.direcsucursal, suc.correosucursal, suc.tlfsucursal, suc.iniciofactura, suc.nroactividadsucursal, 
	suc.fechaautorsucursal, suc.llevacontabilidad, suc.documencargado, suc.dniencargado, suc.nomencargado,
	suc.tlfencargado, suc.descsucursal, suc.porcentaje, suc.estado,
	ciud.ciudad, com.comuna, 
    doc.documento, doc2.documento AS documento2,
	tm.moneda, tm.siglas, tm.simbolo,
    tm2.moneda AS moneda2, tm2.siglas AS siglas2, tm2.simbolo AS simbolo2
	FROM 
	    usuarios usu LEFT JOIN sucursales suc ON usu.codsucursal = suc.codsucursal
	LEFT JOIN 
	    documentos doc ON suc.documsucursal = doc.coddocumento
	LEFT JOIN 
	    documentos AS doc2 ON suc.documencargado = doc2.coddocumento
    LEFT JOIN 
        ciudades ciud ON suc.id_ciudad = ciud.id_ciudad 
    LEFT JOIN 
        comunas com ON suc.id_comuna = com.id_comuna
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
	LEFT JOIN 
        tiposmoneda tm2 ON suc.codmoneda2 = tm2.codmoneda
	WHERE usu.usuario = :Usuario";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(':Usuario', $Usuario);
    $stmt->execute();
	$num = $stmt->rowCount();
	if($num == 0)
	{
		echo "2";
		exit;
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$p[]=$row;
		}
		if (limpiar($row['nivel']) != "ADMINISTRADOR(A) GENERAL" && limpiar($row['estado']) == 0)
		{  
			echo "3";
			exit; 
	    } 
	    elseif (limpiar($row['status']) == 0) 
		{  
			echo "4";
			exit;
		} 
		elseif (password_verify($Password, $row['password'])) {
		
		######### DATOS DEL USUARIO ###########
		$_SESSION["codigo"]    = $p[0]["codigo"];
		$_SESSION["dni"]       = $p[0]["dni"];
		$_SESSION["nombres"]   = $p[0]["nombres"];
		$_SESSION["sexo"]      = $p[0]["sexo"];
		$_SESSION["direccion"] = $p[0]["direccion"];
		$_SESSION["telefono"]  = $p[0]["telefono"];
		$_SESSION["email"]     = $p[0]["email"];
		$_SESSION["usuario"]   = $p[0]["usuario"];
		$_SESSION["password"]  = $p[0]["password"];
		$_SESSION["nivel"]     = $p[0]["nivel"];
		$_SESSION["status"]    = $p[0]["status"];
		$_SESSION["ingreso"]   = limpiar(date("d-m-Y H:i:s A"));
		######### DATOS DEL USUARIO ###########

        ######### DATOS DE LA SUCURSAL ###########
		$_SESSION["codsucursal"]     = $p[0]["codsucursal"];
		$_SESSION["documsucursal"]   = $p[0]["documsucursal"];
		$_SESSION["cuitsucursal"]    = $p[0]["cuitsucursal"];
		$_SESSION["nomsucursal"]     = $p[0]["nomsucursal"];
		$_SESSION["tlfsucursal"]     = $p[0]["tlfsucursal"];
		$_SESSION["id_ciudad"]       = $p[0]["id_ciudad"];
		$_SESSION["ciudad"]          = $p[0]["ciudad"];
		$_SESSION["id_comuna"]       = $p[0]["id_comuna"];
		$_SESSION["comuna"]          = $p[0]["comuna"];
		$_SESSION["direcsucursal"]   = $p[0]["direcsucursal"];
		$_SESSION["correosucursal"]  = $p[0]["correosucursal"];
		$_SESSION["nomencargado"]    = $p[0]["nomencargado"];
		$_SESSION["descsucursal"]    = $p[0]["descsucursal"];
		$_SESSION["porcentaje"]      = $p[0]["porcentaje"];
		$_SESSION["documento"]       = $p[0]["documento"];
		$_SESSION["documento2"]      = $p[0]["documento2"];
		$_SESSION["simbolo"]         = $p[0]["simbolo"];
		$_SESSION["simbolo2"]        = $p[0]["simbolo2"];/**/
		######### DATOS DE LA SUCURSAL ###########

		######### DATOS DE ACCESO ###########
		$query = "INSERT INTO log VALUES (null, ?, ?, ?, ?, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1,$a);
		$stmt->bindParam(2,$b);
		$stmt->bindParam(3,$c);
		$stmt->bindParam(4,$d);
		$stmt->bindParam(5,$e);
		$stmt->bindParam(6,$f);

		$a = limpiar($_SERVER['REMOTE_ADDR']);
		$b = limpiar(date("Y-m-d H:i:s"));
		$c = limpiar($_SERVER['HTTP_USER_AGENT']);
		$d = limpiar($_SERVER['PHP_SELF']);
		$e = limpiar($_POST["usuario"]);
		$f = limpiar($_SESSION["nivel"]== "administradorG" ? "0" : $_SESSION["codsucursal"]);
		$stmt->execute();
		######### DATOS DE ACCESO ###########

		$redirect = '/logout';
        switch($_SESSION["nivel"])
		{
			case 'ADMINISTRADOR(A) GENERAL':
			$_SESSION["acceso"] = 'administradorG';
			$redirect           = 'panel';
			break;
			case 'ADMINISTRADOR(A) SUCURSAL':
			$_SESSION["acceso"] = 'administradorS';
			$redirect           = 'panel';
			break;
			case 'SECRETARIA':
			$_SESSION["acceso"] = 'secretaria';
		    $redirect           = 'panel';
			break;
			case 'CAJERO(A)':
			$_SESSION["acceso"] = 'cajero';
			$redirect           = 'panel';
			break;
			case 'VENDEDOR(A)':
			$_SESSION["acceso"] = 'vendedor';
			$redirect           = 'panel';
			break;
		    }//end switch
            die($redirect);
		   
	    } else {

  	      echo "5";
  	      exit;
	    }
    } 
}
#################### FUNCION PARA ACCEDER AL SISTEMA ####################

############################ FUNCION DATOS SESSION ID #################################
public function SessionPorId()
{
	$this->p = [];
	$codUsuario = limpiar($_SESSION["codigo"]);
	$sql = "SELECT 
	usu.*,
	suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.id_ciudad, suc.id_comuna,
	suc.direcsucursal, suc.correosucursal, suc.tlfsucursal, suc.iniciofactura, suc.nroactividadsucursal,
	suc.fechaautorsucursal, suc.llevacontabilidad, suc.documencargado, suc.dniencargado, suc.nomencargado,
	suc.tlfencargado, suc.descsucursal, suc.porcentaje, suc.estado,
    ciud.ciudad, com.comuna, 
    doc.documento, doc2.documento AS documento2,
	tm.moneda, tm.siglas, tm.simbolo,
    tm2.moneda AS moneda2, tm2.siglas AS siglas2, tm2.simbolo AS simbolo2
	FROM 
	    usuarios usu LEFT JOIN sucursales suc ON usu.codsucursal = suc.codsucursal
	LEFT JOIN 
	    documentos doc ON suc.documsucursal = doc.coddocumento
	LEFT JOIN 
	    documentos AS doc2 ON suc.documencargado = doc2.coddocumento
    LEFT JOIN 
        ciudades ciud ON suc.id_ciudad = ciud.id_ciudad 
    LEFT JOIN 
        comunas com ON suc.id_comuna = com.id_comuna
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
	LEFT JOIN 
        tiposmoneda tm2 ON suc.codmoneda2 = tm2.codmoneda
	WHERE usu.codigo = :codUsuario";
	try {
        $stmt = $this->dbh->prepare($sql);
        // Asignamos los parámetros a los marcadores de posición con nombre
        $stmt->bindParam(':codUsuario', $codUsuario);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        if (!$row) {
            echo "<div class='alert alert-danger'>";
            echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
            echo "<center><span class='fa fa-info-circle'></span> USUARIO NO ENCONTRADO.</center>";
            echo "</div>";
            exit();
        } else {
            $this->p[] = $row;
            return $this->p;
        }
    } catch (PDOException $e) {
        error_log("Error en SessionPorId: " . $e->getMessage());
        echo "<div class='alert alert-danger'>";
        echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
        echo "<center><span class='fa fa-exclamation-triangle'></span> OCURRIÓ UN ERROR AL CONSULTAR EL USUARIO EN SESION.</center>";
        echo "</div>";
        return [];
    }
}
############################ FUNCION DATOS SESSION ID #################################

########################### CLASE LOGUEO ###############################

















######################## FUNCION RECUPERAR Y ACTUALIZAR PASSWORD #######################

########################### FUNCION PARA RECUPERAR CLAVE #############################
public function RecuperarPassword()
{
	$this->p = [];
	if(empty($_POST["email"]))
	{
		echo "1";
		exit;
	}
	################## DATOS DE CONFIGURACION #####################
	$sql = "SELECT * FROM configuracion";
	foreach ($this->dbh->query($sql) as $row)
	{
	   $this->p[] = $row;
	}
    $cuitsucursal   = $row['cuit'];
    $nomsucursal    = $row['nomsucursal'];
    $correosucursal = $row['correosucursal'];
    ################## DATOS DE CONFIGURACION #####################

	################# OBTENGO DATOS DEL USUARIO #################
	$sql = " SELECT * FROM usuarios WHERE email = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["email"]));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "2";
		exit;
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$pa[] = $row;
		}
		$id      = $pa[0]["codigo"];
		$nombres = $pa[0]["nombres"];
		$email   = $pa[0]["email"];
		$pass    = strtoupper(generar_clave(10));
	}
	################# OBTENGO DATOS DEL USUARIO #################

	#################### VALIDACION DE ENVIO DE CORREO CON PHPMAILER ####################
    //Create a new PHPMailer instance
    $mail = new PHPMailer(TRUE);

    $mail->isSMTP();// Set mailer to use SMTP
	$mail->CharSet     = 'UTF-8';
	$mail->SMTPAuth    = true;// Enable SMTP authentication
	$mail->SMTPSecure  = PHPMailer::ENCRYPTION_STARTTLS;// Enable TLS encryption, `ssl` also accepted

	$mail->Host        = 'restaurante.setecchilepos.com';// Specify main and backup SMTP servers
	$mail->Port        = 587;// TCP port to connect to
	$mail->SMTPDebug   = 0;
	$mail->SMTPOptions = array(
	    'ssl' => array(
	        'verify_peer' => false,
	        'verify_peer_name' => false,
	        'allow_self_signed' => true
	    )
	);
	$mail->isHTML(true);// Set email format to HTML

	$mail->Username = 'pos@setecchilepos.com';// SMTP username
	$mail->Password = 'VF2sL!O_x6EF';// SMTP password

	$mail->setFrom('pos@setecchilepos.com', $nomsucursal);//Your application NAME and EMAIL
	$mail->AddReplyTo('no-reply@mycomp.com','no-reply');
	$mail->Subject  = 'Nueva Clave de Acceso';//Message subject

	# establecemos un limite de caracteres de anchura
	$mail->WordWrap   = 50; // set word wrap

	# NOTA: Los correos es conveniente enviarlos en formato HTML y Texto para que
	# cualquier programa de correo pueda leerlo.

	# Definimos el contenido HTML del correo
	$contenidoHTML="<head>";
	$contenidoHTML.="<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">";
	$contenidoHTML.="</head><body>";
	$contenidoHTML.="<b>Recuperación de Contraseña</b>";
	$contenidoHTML.="<p>$nombres</p>";
	$contenidoHTML.="<p>Su Nueva Contraseña de Acceso es: <b>$pass</b></p>";
	$contenidoHTML.="</body>\n";

	# Definimos el contenido en formato Texto del correo
	$contenidoTexto= " Recuperación de Contraseña";
	$contenidoTexto.="\n\n";
	
	# Indicamos el contenido
	$mail->AltBody=$contenidoTexto; //Text Body
	$mail->MsgHTML($contenidoHTML); //Text body HTML

	$mail->addAddress($email,str_replace(" ", "_",$nombres));// Target email
    $mail->AddAttachment("fotos/logo_principal.png", "img.png");

	if(!$mail->send()) {

	   //Mensaje no pudo ser enviado
	   echo "3";
		exit;

	} else {

		################# ACTUALIZO CLAVE DE USUARIO #################
		$sql = " UPDATE usuarios set "
		." password = ? "
		." WHERE "
		." codigo = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $password);
		$stmt->bindParam(2, $codigo);

		$codigo = $id;
		$password = password_hash($pass, PASSWORD_DEFAULT);
		$stmt->execute();
		################# ACTUALIZO CLAVE DE USUARIO #################

	    echo "<span class='fa fa-check-square-o'></span> SU NUEVA CLAVE DE ACCESO LE FUE ENVIADA A SU CORREO ELECTRONICO EXITOSAMENTE";
	    exit;
    }
    #################### VALIDACION DE ENVIO DE CORREO CON PHPMAILER ####################
}	
############################# FUNCION PARA RECUPERAR CLAVE ############################

########################## FUNCION PARA ACTUALIZAR PASSWORD ############################
public function ActualizarPassword()
{
	$this->p = [];
	if(empty($_POST["codigo"]) or empty($_POST["clave"]) or empty($_POST["password"]) or empty($_POST["password2"]))
	{
		echo "1";
		exit;
	}
	elseif (password_verify($_POST["password"], $_SESSION['password']))
	{
		echo "2";
		exit;
	}
		
	$sql = " UPDATE usuarios set "
	." usuario = ?, "
	." password = ? "
	." WHERE "
	." codigo = ?;
	";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $usuario);
	$stmt->bindParam(2, $password);
	$stmt->bindParam(3, $codigo);	

	$usuario = limpiar($_POST["usuario"]);
	$password = password_hash($_POST["password"], PASSWORD_DEFAULT);
	$codigo = limpiar($_POST["codigo"]);
	$stmt->execute();
	
	echo "<span class='fa fa-check-square-o'></span> SU CLAVE DE ACCESO FUE ACTUALIZADA EXITOSAMENTE, SER&Aacute; EXPULSADO DE SU SESI&Oacute;N Y DEBER&Aacute; DE ACCEDER NUEVAMENTE";
	?>
	<script>
		function redireccionar(){location.href="logout.php";}
		setTimeout ("redireccionar()", 3000);
	</script>
	<?php
	exit;
}
########################## FUNCION PARA ACTUALIZAR PASSWORD  ############################

####################### FUNCION RECUPERAR Y ACTUALIZAR PASSWORD ########################


























########################## FUNCION CONFIGURACION DEL SISTEMA ########################

######################## FUNCION ID CONFIGURACION DEL SISTEMA ########################
public function ConfiguracionPorId()
{
	$this->p = [];
	$codConfiguracion = limpiar("1");
	$sql = " SELECT 
	conf.*,
    doc.documento, doc2.documento AS documento2,
	ciud.ciudad, com.comuna 
	FROM 
	    configuracion conf
	LEFT JOIN 
	    documentos doc ON conf.documsucursal = doc.coddocumento
	LEFT JOIN 
	    documentos AS doc2 ON conf.documencargado = doc2.coddocumento
    LEFT JOIN 
        ciudades ciud ON conf.id_ciudad = ciud.id_ciudad 
    LEFT JOIN 
        comunas com ON conf.id_comuna = com.id_comuna
    WHERE conf.id = :codConfiguracion";
	try {
        $stmt = $this->dbh->prepare($sql);
        // Asignamos los parámetros a los marcadores de posición con nombre
        $stmt->bindParam(':codConfiguracion', $codConfiguracion);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        if (!$row) {
            echo "<div class='alert alert-danger'>";
            echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
            echo "<center><span class='fa fa-info-circle'></span> CONFIGURACION NO ENCONTRADA.</center>";
            echo "</div>";
            exit();
        } else {
            $this->p[] = $row;
            return $this->p;
        }
    } catch (PDOException $e) {
        error_log("Error en ConfiguracionPorId: " . $e->getMessage());
        echo "<div class='alert alert-danger'>";
        echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
        echo "<center><span class='fa fa-exclamation-triangle'></span> OCURRIÓ UN ERROR AL CONSULTAR LA CONFIGURACION.</center>";
        echo "</div>";
        return [];
    }
}
######################## FUNCION ID CONFIGURACION DEL SISTEMA #########################

######################## FUNCION  ACTUALIZAR CONFIGURACION #########################
public function ActualizarConfiguracion()
{
	$this->p = [];
	if(empty($_POST["cuit"]) or empty($_POST["nomsucursal"]) or empty($_POST["tlfsucursal"]))
	{
		echo "1";
		exit;
	}
	//llamada de la funcion
	/*elseif (!valida_rut($_POST["cuit"]))
	{
		echo "2";
		exit;
	}
	//llamada de la funcion
	elseif (!valida_rut($_POST["dniencargado"]))
	{
		echo "3";
		exit;
	}*/
	$sql = " UPDATE configuracion set "
	." documsucursal = ?, "
	." cuit = ?, "
	." nomsucursal = ?, "
	." tlfsucursal = ?, "
	." correosucursal = ?, "
	." id_ciudad = ?, "
	." id_comuna = ?, "
	." direcsucursal = ?, "
	." documencargado = ?, "
	." dniencargado = ?, "
	." nomencargado = ?, "
	." url1 = ?, "
	." url2 = ? "
	." WHERE "
	." id = ?;
	";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $documsucursal);
	$stmt->bindParam(2, $cuit);
	$stmt->bindParam(3, $nomsucursal);
	$stmt->bindParam(4, $tlfsucursal);
	$stmt->bindParam(5, $correosucursal);
	$stmt->bindParam(6, $id_ciudad);
	$stmt->bindParam(7, $id_comuna);
	$stmt->bindParam(8, $direcsucursal);
	$stmt->bindParam(9, $documencargado);
	$stmt->bindParam(10, $dniencargado);
	$stmt->bindParam(11, $nomencargado);
	$stmt->bindParam(12, $url1);
	$stmt->bindParam(13, $url2);
	$stmt->bindParam(14, $id);

	$documsucursal = limpiar($_POST['documsucursal'] == '' ? "0" : $_POST['documsucursal']);
	$cuit = limpiar($_POST["cuit"]);
	$nomsucursal = limpiar($_POST["nomsucursal"]);
	$tlfsucursal = limpiar($_POST["tlfsucursal"]);
	$correosucursal = limpiar($_POST["correosucursal"]);
	$id_ciudad = limpiar($_POST['id_ciudad'] == '' ? "0" : $_POST['id_ciudad']);
	$id_comuna = limpiar($_POST['id_comuna'] == '' ? "0" : $_POST['id_comuna']);
	$direcsucursal = limpiar($_POST["direcsucursal"]);
	$documencargado = limpiar($_POST["documencargado"]);
	$dniencargado = limpiar($_POST["dniencargado"]);
	$nomencargado = limpiar($_POST["nomencargado"]);
	$url1 = limpiar($_POST["url1"]);
	$url2 = limpiar($_POST["url2"]);
	$id = limpiar($_POST["id"]);
	$stmt->execute();

	############################## SUBIR LOGO PRINCIPAL #1 ##############################
   //datos del arhivo
   $nombre_archivo = limpiar(isset($_FILES['imagen']['name']) ? $_FILES['imagen']['name'] : "");
	$tipo_archivo = limpiar(isset($_FILES['imagen']['type']) ? $_FILES['imagen']['type'] : "");
	$tamano_archivo = limpiar(isset($_FILES['imagen']['size']) ? $_FILES['imagen']['size'] : "");
   //compruebo si las características del archivo son las que deseo  
	if ((strpos($tipo_archivo,'image/png')!==false)&&$tamano_archivo<200000) {  
		if (move_uploaded_file($_FILES['imagen']['tmp_name'], "fotos/".$nombre_archivo) && rename("fotos/".$nombre_archivo,"fotos/logo_principal.png"))
		{ 
		## se puede dar un aviso
		} 
		## se puede dar otro aviso 
	}
	############################## SUBIR LOGO PRINCIPAL #1 ##############################

	############################## SUBIR LOGO PDF #1 ##############################
   //datos del arhivo
   $nombre_archivo2 = limpiar(isset($_FILES['imagen2']['name']) ? $_FILES['imagen2']['name'] : "");
	$tipo_archivo2 = limpiar(isset($_FILES['imagen2']['type']) ? $_FILES['imagen2']['type'] : "");
	$tamano_archivo2 = limpiar(isset($_FILES['imagen2']['size']) ? $_FILES['imagen2']['size'] : "");
   //compruebo si las características del archivo son las que deseo  
	if ((strpos($tipo_archivo2,'image/png')!==false)&&$tamano_archivo2<8000000)//1MB 
	{  
		if (move_uploaded_file($_FILES['imagen']['tmp_name'], "fotos/".$nombre_archivo2) && rename("fotos/".$nombre_archivo2,"fotos/logo_pdf.png"))
		{ 
		## se puede dar un aviso
		} 
		## se puede dar otro aviso 
	}
	############################## SUBIR LOGO PDF #1 ##############################

	############################## SUBIR LOGO PDF #2 ##############################
   //datos del arhivo
   $nombre_archivo3 = limpiar(isset($_FILES['imagen3']['name']) ? $_FILES['imagen3']['name'] : "");
	$tipo_archivo3 = limpiar(isset($_FILES['imagen3']['type']) ? $_FILES['imagen3']['type'] : "");
	$tamano_archivo3 = limpiar(isset($_FILES['imagen3']['size']) ? $_FILES['imagen3']['size'] : "");
   //compruebo si las características del archivo son las que deseo  
	if ((strpos($tipo_archivo3,'image/png')!==false)&&$tamano_archivo3<8000000)//1MB 
	{  
		if (move_uploaded_file($_FILES['imagen']['tmp_name'], "fotos/".$nombre_archivo3) && rename("fotos/".$nombre_archivo3,"fotos/logo_pdf2.png"))
		{ 
		## se puede dar un aviso
		} 
		## se puede dar otro aviso 
	}
	############################## SUBIR LOGO PDF #2 ##############################

	############################## SUBIR IMAGEN URL 1 ##############################
   //datos del arhivo
   $nombre_archivo4 = limpiar(isset($_FILES['imagen4']['name']) ? $_FILES['imagen4']['name'] : "");
	$tipo_archivo4 = limpiar(isset($_FILES['imagen4']['type']) ? $_FILES['imagen4']['type'] : "");
	$tamano_archivo4 = limpiar(isset($_FILES['imagen4']['size']) ? $_FILES['imagen4']['size'] : ""); 
   //compruebo si las características del archivo son las que deseo  
	if ((strpos($tipo_archivo4,'image/png')!==false)&&$tamano_archivo4<200000) {  
		if (move_uploaded_file($_FILES['imagen4']['tmp_name'], "fotos/".$nombre_archivo4) && rename("fotos/".$nombre_archivo4,"fotos/imagen1.png"))
		{ 
		## se puede dar un aviso
		} 
		## se puede dar otro aviso 
	}
	############################## SUBIR IMAGEN URL 1 ##############################

	############################## SUBIR IMAGEN URL 2 ##############################
   //datos del arhivo
   $nombre_archivo5 = limpiar(isset($_FILES['imagen5']['name']) ? $_FILES['imagen5']['name'] : "");
	$tipo_archivo5 = limpiar(isset($_FILES['imagen5']['type']) ? $_FILES['imagen5']['type'] : "");
	$tamano_archivo5 = limpiar(isset($_FILES['imagen5']['size']) ? $_FILES['imagen5']['size'] : ""); 
   //compruebo si las características del archivo son las que deseo  
	if ((strpos($tipo_archivo5,'image/png')!==false)&&$tamano_archivo5<200000) {  
		if (move_uploaded_file($_FILES['imagen5']['tmp_name'], "fotos/".$nombre_archivo5) && rename("fotos/".$nombre_archivo5,"fotos/imagen2.png"))
		{ 
		## se puede dar un aviso
		} 
		## se puede dar otro aviso 
	}
	############################## SUBIR IMAGEN URL 2 ##############################

	echo "<span class='fa fa-check-square-o'></span> LOS DATOS DE CONFIGURACI&Oacute;N FUERON ACTUALIZADOS EXITOSAMENTE";
	exit;
}
######################## FUNCION  ACTUALIZAR CONFIGURACION #########################

###################### FIN DE FUNCION CONFIGURACION DEL SISTEMA #######################


























################################## CLASE USUARIOS #####################################

############################## FUNCION REGISTRAR USUARIOS ##############################
public function RegistrarUsuarios()
{
	$this->p = [];
	if(empty($_POST["nombres"]) or empty($_POST["usuario"]) or empty($_POST["password"]))
	{
		echo "1";
		exit;
	}
	if($_POST["nivel"]=="ADMINISTRADOR(A) GENERAL" && decrypt($_POST["codsucursal"])!="0")
	{
		echo "2";
		exit;
	}
	elseif($_POST["nivel"]!="ADMINISTRADOR(A) GENERAL" && decrypt($_POST["codsucursal"])=="0")
	{
		echo "3";
		exit;
	}
	//llamada de la funcion
	/*elseif (!valida_rut($_POST["dni"]))
	{
		echo "4";
		exit;
	}*/
	$sql = " SELECT dni FROM usuarios WHERE dni = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["dni"]));
	$num = $stmt->rowCount();
	if($num > 0)
	{
		echo "5";
		exit;
	}
	$sql = " SELECT email FROM usuarios WHERE email = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["email"]));
	$num = $stmt->rowCount();
	if($num > 0)
	{
		echo "6";
		exit;
	}
	$sql = " SELECT usuario FROM usuarios WHERE usuario = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["usuario"]));
	$num = $stmt->rowCount();
	if($num == 0)
	{
	    ############## OBTENGO DATOS DE SUCURSALES ASOCIADAS #################
		$rs = "SELECT gruposid FROM usuarios
		WHERE codsucursal = '".decrypt($_POST["codsucursal"])."' AND nivel = 'ADMINISTRADOR(A) SUCURSAL'";
		foreach ($this->dbh->query($rs) as $row) {
           $p[] = $row;
        }
		$valores = (empty($p[0]['gruposid']) ? "0" : $p[0]['gruposid']);
		############## OBTENGO DATOS DE SUCURSALES ASOCIADAS #################

		############## REGISTRO USUARIO #################
		$query = " INSERT INTO usuarios values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $dni);
		$stmt->bindParam(2, $nombres);
		$stmt->bindParam(3, $sexo);
		$stmt->bindParam(4, $direccion);
		$stmt->bindParam(5, $telefono);
		$stmt->bindParam(6, $email);
		$stmt->bindParam(7, $usuario);
		$stmt->bindParam(8, $password);
		$stmt->bindParam(9, $nivel);
		$stmt->bindParam(10, $status);
		$stmt->bindParam(11, $comision);
		$stmt->bindParam(12, $codsucursal);
		$stmt->bindParam(13, $gruposid);

		$dni = limpiar($_POST["dni"]);
		$nombres = limpiar($_POST["nombres"]);
		$sexo = limpiar($_POST["sexo"]);
		$direccion = limpiar($_POST["direccion"]);
		$telefono = limpiar($_POST["telefono"]);
		$email = limpiar($_POST["email"]);
		$usuario = limpiar($_POST["usuario"]);
		$password = password_hash($_POST["password"], PASSWORD_DEFAULT);
		$nivel = limpiar($_POST["nivel"]);
		$status = limpiar($_POST["status"]);
		$comision = limpiar($_POST["comision"]);
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		if($_SESSION['acceso'] == "administradorG"){
			if($_POST["nivel"] == "ADMINISTRADOR(A) SUCURSAL"){
				$gruposid = limpiar(empty($_POST['gruposid']) ? "0" : implode(",",$_POST['gruposid']));
			} else {
				$gruposid = limpiar($valores);
			}
	   } else {
	   $gruposid = limpiar($valores);
		}
		$stmt->execute();
		############## REGISTRO USUARIO #################

	   ########################## SUBIR FOTO DE USUARIOS ##########################
	   //datos del arhivo  
		$nombre_archivo = limpiar(isset($_FILES['imagen']['name']) ? $_FILES['imagen']['name'] : "");
		$tipo_archivo = limpiar(isset($_FILES['imagen']['type']) ? $_FILES['imagen']['type'] : "");
		$tamano_archivo = limpiar(isset($_FILES['imagen']['size']) ? $_FILES['imagen']['size'] : "");
	   //compruebo si las características del archivo son las que deseo  
		if ((strpos($tipo_archivo,'image/jpeg')!==false)&&$tamano_archivo<50000) 
		{  
			if (move_uploaded_file($_FILES['imagen']['tmp_name'], "fotos/".$nombre_archivo) && rename("fotos/".$nombre_archivo,"fotos/".$_POST["dni"].".jpg"))
			{ 
	      ## se puede dar un aviso
			} 
	      ## se puede dar otro aviso 
		}
	   ########################## SUBIR FOTO DE USUARIOS ##########################

		echo "<span class='fa fa-check-square-o'></span> EL USUARIO HA SIDO REGISTRADO EXITOSAMENTE";
		exit;
   }
	else
	{
	   echo "7";
		exit;	
	}
}
############################# FUNCION REGISTRAR USUARIOS ###############################

############################# FUNCION LISTAR USUARIOS ################################
public function ListarUsuarios()
{
	$this->p = [];
	$tipoAcceso      = isset($_SESSION["acceso"]) ? limpiar($_SESSION["acceso"]) : '';
	$codSucursal     = ($tipoAcceso === 'administradorG') ? "0" : limpiar($_SESSION["codsucursal"]);	
    $whereConditions = [];
    $params          = [];

    // Lógica de filtro basada en el tipo de acceso
    if ($tipoAcceso === 'administradorS') { // Acceso Administrador de Sucursal
        $whereConditions[] = "usu.codsucursal = ?";
        $params[]          = $codSucursal;
    }
    $whereClause = "";
    if (!empty($whereConditions)) {
      $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $sqlBase = "SELECT
        usu.*,
        suc.cuitsucursal,
		suc.nomsucursal
	FROM 
	    usuarios usu LEFT JOIN sucursales suc ON usu.codsucursal = suc.codsucursal";
    $sql = $sqlBase . $whereClause . " ORDER BY usu.codigo ASC";
    try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($results)) {
            return [];
        } else {
            return $results;
        }
    } catch (PDOException $e) {
        error_log("Error en ListarUsuarios: " . $e->getMessage());
        return [];
    }
}
############################## FUNCION LISTAR USUARIOS ################################

########################## FUNCION BUSQUEDA DE LOGS DE USUARIOS ###############################
public function BusquedaLogs()
{
	$this->p = [];
	$tipoAcceso      = isset($_SESSION["acceso"]) ? limpiar($_SESSION["acceso"]) : '';
	$codSucursal     = ($tipoAcceso === 'administradorG') ? "0" : limpiar($_SESSION["codsucursal"]);	
	$searchCriterio  = isset($_POST['b']) ? limpiar($_POST['b']) : '';
    $whereConditions = [];
    $params          = [];

    // Lógica de filtro basada en el tipo de acceso
    if ($tipoAcceso === 'administradorS') { // Acceso Administrador de Sucursal
        $whereConditions[] = "l.codsucursal = ?";
        $params[]          = $codSucursal;
    }

    $whereConditions[] = "CONCAT(l.ip, ' ',l.tiempo, ' ',l.detalles, ' ',l.usuario) LIKE ?";
    $params[] = '%' . $searchCriterio . '%';

    $whereClause = "";
    if (!empty($whereConditions)) {
      $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $sqlBase = "SELECT
        l.*,
        suc.cuitsucursal,
		suc.nomsucursal
	FROM 
	    log l LEFT JOIN sucursales suc ON l.codsucursal = suc.codsucursal";
    $sql = $sqlBase . $whereClause . " ORDER BY l.tiempo ASC";
    try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($results)) {
            return [];
        } else {
            return $results;
        }
    } catch (PDOException $e) {
        error_log("Error en BusquedaLogs: " . $e->getMessage());
        echo "<div class='alert alert-danger'>";
        echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
        echo "<center><span class='fa fa-exclamation-triangle'></span> OCURRIÓ UN ERROR AL PROCESAR LA BÚSQUEDA. POR FAVOR, INTENTALO MAS TARDE.</center>";
        echo "</div>";
        return [];
    }
}
########################## FUNCION BUSQUEDA DE LOGS DE USUARIOS ###############################

########################### FUNCION LISTAR LOGS DE USUARIOS ###########################
public function ListarLogs()
{
	$this->p = [];
	$sql = "SELECT * FROM log";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
}
########################### FUNCION LISTAR LOGS DE USUARIOS ###########################

############################ FUNCION ID USUARIOS #################################
public function UsuariosPorId()
{
	$this->p = [];
	$sql = "SELECT * FROM usuarios  
	LEFT JOIN sucursales ON usuarios.codsucursal = sucursales.codsucursal 
	WHERE usuarios.codigo = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codigo"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
	}
}
############################ FUNCION ID USUARIOS #################################

############################ FUNCION ACTUALIZAR USUARIOS ############################
public function ActualizarUsuarios()
{
	$this->p = [];
	if(empty($_POST["dni"]) or empty($_POST["nombres"]) or empty($_POST["usuario"]) or empty($_POST["password"]))
	{
		echo "1";
		exit;
	}

	if($_POST["nivel"]=="ADMINISTRADOR(A) GENERAL" && decrypt($_POST["codsucursal"])!="0")
	{
		echo "2";
		exit;
	}
	elseif($_POST["nivel"]!="ADMINISTRADOR(A) GENERAL" && decrypt($_POST["codsucursal"])=="0")
	{
		echo "3";
		exit;
	}
	//llamada de la funcion
	/*elseif (!valida_rut($_POST["dni"]))
	{
		echo "4";
		exit;
	}*/
	$sql = "SELECT * FROM usuarios WHERE codigo != ? AND dni = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["codigo"],$_POST["dni"]));
	$num = $stmt->rowCount();
	if($num > 0)
	{
		echo "5";
		exit;
	}
	$sql = " SELECT email FROM usuarios WHERE codigo != ? AND email = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["codigo"],$_POST["email"]));
	$num = $stmt->rowCount();
	if($num > 0)
	{
		echo "6";
		exit;
	}
	$sql = " SELECT usuario FROM usuarios WHERE codigo != ? AND usuario = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["codigo"],$_POST["usuario"]));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		############## OBTENGO DATOS DE SUCURSALES ASOCIADAS #################
		$rs = "SELECT gruposid FROM usuarios
		WHERE codsucursal = '".decrypt($_POST["codsucursal"])."' AND nivel = 'ADMINISTRADOR(A) SUCURSAL'";
		foreach ($this->dbh->query($rs) as $row) {
         $p[] = $row;
      }
		$valores = (empty($p[0]['gruposid']) ? "0" : $p[0]['gruposid']);
		############## OBTENGO DATOS DE SUCURSALES ASOCIADAS #################

		############## ACTUALIZO USUARIO #################
		$sql = " UPDATE usuarios set "
		." dni = ?, "
		." nombres = ?, "
		." sexo = ?, "
		." direccion = ?, "
		." telefono = ?, "
		." email = ?, "
		." usuario = ?, "
		." password = ?, "
		." nivel = ?, "
		." status = ?, "
		." comision = ?, "
		." codsucursal = ?, "
		." gruposid = ? "
		." WHERE "
		." codigo = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $dni);
		$stmt->bindParam(2, $nombres);
		$stmt->bindParam(3, $sexo);
		$stmt->bindParam(4, $direccion);
		$stmt->bindParam(5, $telefono);
		$stmt->bindParam(6, $email);
		$stmt->bindParam(7, $usuario);
		$stmt->bindParam(8, $password);
		$stmt->bindParam(9, $nivel);
		$stmt->bindParam(10, $status);
		$stmt->bindParam(11, $comision);
		$stmt->bindParam(12, $codsucursal);
		$stmt->bindParam(13, $gruposid);
		$stmt->bindParam(14, $codigo);

		$dni = limpiar($_POST["dni"]);
		$nombres = limpiar($_POST["nombres"]);
		$sexo = limpiar($_POST["sexo"]);
		$direccion = limpiar($_POST["direccion"]);
		$telefono = limpiar($_POST["telefono"]);
		$email = limpiar($_POST["email"]);
		$usuario = limpiar($_POST["usuario"]);
		$password = password_hash($_POST["password"], PASSWORD_DEFAULT);
		$nivel = limpiar($_POST["nivel"]);
		$status = limpiar($_POST["status"]);
		$comision = limpiar($_POST["comision"]);
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		if($_SESSION['acceso'] == "administradorG"){
			if($_POST["nivel"] == "ADMINISTRADOR(A) SUCURSAL"){
				$gruposid = limpiar(empty($_POST['gruposid']) ? "0" : implode(",",$_POST['gruposid']));
			} else {
				$gruposid = limpiar($valores);
			}
	   } else {
	   $gruposid = limpiar($valores);
		}
		$codigo = limpiar($_POST["codigo"]);
		$stmt->execute();
		############## ACTUALIZO USUARIO #################

		########################## SUBIR FOTO DE USUARIOS ##########################
	   //datos del arhivo  
		$nombre_archivo = limpiar(isset($_FILES['imagen']['name']) ? $_FILES['imagen']['name'] : "");
		$tipo_archivo = limpiar(isset($_FILES['imagen']['type']) ? $_FILES['imagen']['type'] : "");
		$tamano_archivo = limpiar(isset($_FILES['imagen']['size']) ? $_FILES['imagen']['size'] : "");
	   //compruebo si las características del archivo son las que deseo  
		if ((strpos($tipo_archivo,'image/jpeg')!==false)&&$tamano_archivo<50000) 
		{  
			if (move_uploaded_file($_FILES['imagen']['tmp_name'], "fotos/".$nombre_archivo) && rename("fotos/".$nombre_archivo,"fotos/".$_POST["dni"].".jpg"))
			{ 
	      ## se puede dar un aviso
			} 
	      ## se puede dar otro aviso 
		}
	   ########################## SUBIR FOTO DE USUARIOS ##########################

		echo "<span class='fa fa-check-square-o'></span> EL USUARIO HA SIDO ACTUALIZADO EXITOSAMENTE";
		exit;
	}
	else
	{
		echo "7";
		exit;
	}
}
############################ FUNCION ACTUALIZAR USUARIOS ############################

############################# FUNCION CAMBIAR STATUS USUARIOS ################################
public function EstadoUsuarios()
{
	$this->p = [];
	###################### ACTUALIZO STATUS DE USUARIO ######################
	$sql = "UPDATE usuarios set "
	." status = ? "
	." WHERE "
	." codigo = ?;
	";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $status);
	$stmt->bindParam(2, $codigo);

	$status = limpiar(decrypt($_GET['status']) == 1 ? 0 : 1);
	$codigo = limpiar(decrypt($_GET["codigo"]));
	$stmt->execute();
	###################### ACTUALIZO STATUS DE USUARIO ######################

	echo "1";
	exit;	
}
############################## FUNCION CAMBIAR STATUS USUARIOS ##############################

############################# FUNCION ELIMINAR USUARIOS ################################
public function EliminarUsuarios()
{
	$this->p = [];
	if ($_SESSION['acceso'] == "administradorG" || $_SESSION["acceso"]=="administradorS") {

	$sql = "SELECT codigo FROM ventas WHERE codigo = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codigo"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = " DELETE FROM usuarios WHERE codigo = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codigo);
		$codigo = decrypt($_GET["codigo"]);
		$stmt->execute();

		$dni = decrypt($_GET["dni"]);
		if (file_exists("fotos/".$dni.".jpg")){
	    //funcion para eliminar una carpeta con contenido
		$archivos = "fotos/".$dni.".jpg";		
		unlink($archivos);
		}

		echo "1";
		exit;

	} else {
		   
		echo "2";
		exit;
	} 
			
	} else {
		
		echo "3";
		exit;
	}	
}
############################## FUNCION ELIMINAR USUARIOS ##############################

######################## FUNCION BUSCAR USUARIOS POR SUCURSAL ##########################
public function BuscarUsuariosxSucursal() 
{
	$this->p = [];
	$sql = " SELECT * FROM usuarios 
	INNER JOIN sucursales ON usuarios.codsucursal = sucursales.codsucursal 
	WHERE usuarios.codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "<option value=''> -- SIN RESULTADOS -- </option>";
		exit;
	}
	else
	{
	   while($row = $stmt->fetch())
		{
			$this->p[]=$row;
		}
		return $this->p;
	}
}
######################### FUNCION BUSCAR USUARIOS POR SUCURSAL ##########################

################### FUNCION SELECCIONA USUARIO POR CODIGO Y SUCURSAL ###################
public function BuscarUsuariosxCodigo() 
{
	$this->p = [];
	$sql = " SELECT * FROM usuarios WHERE codigo = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_GET["codigo"],decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "<option value=''> -- SIN RESULTADOS -- </option>";
		exit;
	}
	else
	{
		while($row = $stmt->fetch())
		{
			$this->p[]=$row;
		}
		return $this->p;
	}
}
################### FUNCION SELECCIONA USUARIO POR CODIGO Y SUCURSAL ##################

############################ FIN DE CLASE USUARIOS ################################


























################################ CLASE CIUDADES ##################################

########################## FUNCION REGISTRAR CIUDADES ###############################
public function RegistrarCiudades()
{
	$this->p = [];
	if(empty($_POST["ciudad"]))
	{
		echo "1";
		exit;
	}
	$sql = " SELECT ciudad FROM ciudades WHERE ciudad = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["ciudad"]));
	$num = $stmt->rowCount();
	if($num == 0)
	{
	   $query = " INSERT INTO ciudades values (null, ?, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codciudad);
		$stmt->bindParam(2, $ciudad);
		$stmt->bindParam(3, $id_region);

		$codciudad = limpiar($_POST['codciudad']);
		$ciudad = limpiar($_POST["ciudad"]);
		$id_region = limpiar($_POST['id_region']);
		$stmt->execute();

	   echo "<span class='fa fa-check-square-o'></span> LA CIUDAD HA SIDO REGISTRADA EXITOSAMENTE";
		exit;

	} else {

		echo "2";
		exit;
	}		
}
############################ FUNCION REGISTRAR CIUDADES ############################

############################ FUNCION LISTAR CIUDADES ################################
public function ListarCiudades()
{
	$this->p = [];
	$sql = "SELECT * FROM ciudades ORDER BY codciudad ASC";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
}
########################### FUNCION LISTAR CIUDADES ################################

########################### FUNCION ID CIUDADES #################################
public function CiudadesPorId()
{
	$this->p = [];
	$sql = "SELECT * FROM ciudad WHERE id_ciudad = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["id_ciudad"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
	}
}
############################ FUNCION ID CIUDADES #################################

############################ FUNCION ACTUALIZAR CIUDADES ############################
public function ActualizarCiudades()
{

	$this->p = [];
	if(empty($_POST["id_ciudad"]) or empty($_POST["ciudad"]))
	{
		echo "1";
		exit;
	}
	$sql = " SELECT ciudad FROM ciudades WHERE id_ciudad != ? AND ciudad = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["id_ciudad"],$_POST["ciudad"]));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = " UPDATE ciudades set "
		." codciudad = ?, "
		." ciudad = ?, "
		." id_region = ? "
		." where "
		." id_ciudad = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $codciudad);
		$stmt->bindParam(2, $ciudad);
		$stmt->bindParam(3, $id_region);
		$stmt->bindParam(4, $id_ciudad);

		$codciudad = limpiar($_POST['codciudad']);
		$ciudad = limpiar($_POST["ciudad"]);
		$id_region = limpiar($_POST['id_region']);
		$id_ciudad = limpiar($_POST['id_ciudad']);
		$stmt->execute();

		echo "<span class='fa fa-check-square-o'></span> LA CIUDAD HA SIDO ACTUALIZADA EXITOSAMENTE";
		exit;

	} else {

		echo "2";
		exit;
	}		
}
############################ FUNCION ACTUALIZAR CIUDADES ############################

############################ FUNCION ELIMINAR CIUDADES ############################
public function EliminarCiudades()
{
	$this->p = [];
	if($_SESSION['acceso'] == "administradorG" || $_SESSION["acceso"]=="administradorS") {

	$sql = "SELECT id_ciudad FROM clientes WHERE id_ciudad = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["id_ciudad"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = "DELETE FROM ciudades WHERE id_ciudad = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$id_ciudad);
		$id_ciudad = decrypt($_GET["id_ciudad"]);
		$stmt->execute();

		echo "1";
		exit;

	} else {
		   
		echo "2";
		exit;
	} 
			
	} else {
		
		echo "3";
		exit;
	}	
}
############################ FUNCION ELIMINAR CIUDADES ##############################

############################## FIN DE CLASE CIUDADES ################################


















############################### CLASE COMUNAS ################################

############################# FUNCION REGISTRAR COMUNAS ###########################
public function RegistrarComunas()
{
	$this->p = [];
	if(empty($_POST["comuna"]))
	{
		echo "1";
		exit;
	}
			
	$sql = " SELECT comuna FROM comunas WHERE comuna = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["comuna"]));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$query = " INSERT INTO comunas values (null, ?, ?, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codcomuna);
		$stmt->bindParam(2, $comuna);
		$stmt->bindParam(3, $numero);
		$stmt->bindParam(4, $id_region);

		$codcomuna = limpiar($_POST['codcomuna']);
		$comuna = limpiar($_POST['comuna']);
		$numero = limpiar($_POST['numero']);
		$id_region = limpiar($_POST['id_region']);
		$stmt->execute();

		echo "<span class='fa fa-check-square-o'></span> LA COMUNA HA SIDO REGISTRADA EXITOSAMENTE";
		exit;

	} else {

		echo "2";
		exit;
	}	
}
########################### FUNCION REGISTRAR COMUNAS ########################

########################## FUNCION PARA LISTAR COMUNAS ##########################
public function ListarComunas()
{
	$this->p = [];
	$sql = "SELECT * FROM comunas ORDER BY codcomuna ASC";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
}
######################### FUNCION PARA LISTAR COMUNAS ##########################

############################ FUNCION ID COMUNAS #################################
public function ComunasPorId()
{
	$this->p = [];
	$sql = "SELECT * FROM comunas WHERE id_comuna = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["id_comuna"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
	}
}
############################ FUNCION ID COMUNAS #################################

######################## FUNCION ACTUALIZAR COMUNAS ############################
public function ActualizarComunas()
{
	$this->p = [];
	if(empty($_POST["id_comuna"]) or empty($_POST["comuna"]))
	{
		echo "1";
		exit;
	}
	$sql = " SELECT comuna FROM comunas WHERE id_comuna != ? AND comuna = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["id_comuna"],$_POST["comuna"]));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = " UPDATE comunas set "
		." codcomuna = ?, "
		." comuna = ?, "
		." numero = ?, "
		." id_region = ? "
		." where "
		." id_comuna = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $codcomuna);
		$stmt->bindParam(2, $comuna);
		$stmt->bindParam(3, $numero);
		$stmt->bindParam(4, $id_region);
		$stmt->bindParam(5, $id_comuna);

		$codcomuna = limpiar($_POST['codcomuna']);
		$comuna = limpiar($_POST['comuna']);
		$numero = limpiar($_POST['numero']);
		$id_region = limpiar($_POST['id_region']);
		$id_comuna = limpiar($_POST['id_comuna']);
		$stmt->execute();

		echo "<span class='fa fa-check-square-o'></span> LA COMUNA HA SIDO ACTUALIZADA EXITOSAMENTE";
		exit;

	} else {

		echo "3";
		exit;
	}		
}
############################ FUNCION ACTUALIZAR COMUNAS #######################

############################ FUNCION ELIMINAR COMUNAS ###########################
public function EliminarComunas()
{
	$this->p = [];
	if($_SESSION['acceso'] == "administradorG" || $_SESSION["acceso"]=="administradorS") {

	$sql = "SELECT id_comuna FROM clientes WHERE id_comuna = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["id_comuna"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = "DELETE FROM comunas WHERE id_comuna = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$id_comuna);
		$id_comuna = decrypt($_GET["id_comuna"]);
		$stmt->execute();

		echo "1";
		exit;

	} else {
		   
		echo "2";
		exit;
	} 
			
	} else {
		
		echo "3";
		exit;
	}	
}
########################### FUNCION ELIMINAR COMUNAS ############################

###################### FUNCION LISTAR COMUNAS POR CIUDADES #####################
public function ListarComunasxCiudad() 
{
	$this->p = [];
	$sql = "SELECT * FROM comunas WHERE id_ciudad = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_GET["id_ciudad"]));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "<option value='0' selected> -- SIN RESULTADOS -- </option>";
		exit;
	}
	else
	{
	   while($row = $stmt->fetch())
		{
			$this->p[]=$row;
		}
		return $this->p;
	}
}
##################### FUNCION LISTAR COMUNAS POR CIUDADES ######################

################# FUNCION PARA SELECCIONAR COMUNAS POR CIUDAD #################
public function SeleccionaComuna()
{
	$this->p = [];
	$sql = "SELECT * FROM comunas WHERE id_ciudad = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_GET["id_ciudad"]));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "<option value=''> -- SIN RESULTADOS -- </option>";
		exit;
	}
	else
	{
		while($row = $stmt->fetch())
		{
			$this->p[]=$row;
		}
		return $this->p;
	}
}
################# FUNCION PARA SELECCIONAR COMUNAS POR CIUDAD ################

############################## FIN DE CLASE COMUNAS ##############################



















################################ CLASE TIPOS DE DOCUMENTOS ##############################

########################### FUNCION REGISTRAR TIPO DE DOCUMENTOS ########################
public function RegistrarDocumentos()
{
	$this->p = [];
	if(empty($_POST["documento"]) or empty($_POST["descripcion"]))
	{
		echo "1";
		exit;
	}
	$sql = " SELECT * FROM documentos WHERE documento = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["documento"]));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$query = " INSERT INTO documentos values (null, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $documento);
		$stmt->bindParam(2, $descripcion);

		$documento = limpiar($_POST["documento"]);
		$descripcion = limpiar($_POST["descripcion"]);
		$stmt->execute();

		echo "<span class='fa fa-check-square-o'></span> EL TIPO DE DOCUMENTO HA SIDO REGISTRADO EXITOSAMENTE";
		exit;

	} else {

		echo "2";
		exit;
	}
}
############################ FUNCION REGISTRAR TIPO DE MONEDA ########################

########################## FUNCION LISTAR TIPO DE MONEDA ################################
public function ListarDocumentos()
{
	$this->p = [];
	$sql = "SELECT * FROM documentos ORDER BY documento ASC";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
}
######################### FUNCION LISTAR TIPO DE DOCUMENTOS ##########################

######################### FUNCION ID TIPO DE DOCUMENTOS ###############################
public function DocumentoPorId()
{
	$this->p = [];
	$sql = "SELECT * FROM documentos WHERE coddocumento = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["coddocumento"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
	}
}
########################## FUNCION ID TIPO DE DOCUMENTOS #########################

######################### FUNCION ACTUALIZAR TIPO DE DOCUMENTOS ########################
public function ActualizarDocumentos()
{
	$this->p = [];
	if(empty($_POST["coddocumento"]) or empty($_POST["documento"]) or empty($_POST["descripcion"]))
	{
		echo "1";
		exit;
	}

	$sql = " SELECT documento FROM documentos WHERE coddocumento != ? AND documento = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["coddocumento"],$_POST["documento"]));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = " UPDATE documentos set "
		." documento = ?, "
		." descripcion = ? "
		." WHERE "
		." coddocumento = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $documento);
		$stmt->bindParam(2, $descripcion);
		$stmt->bindParam(3, $coddocumento);

		$documento = limpiar($_POST["documento"]);
		$descripcion = limpiar($_POST["descripcion"]);
		$coddocumento = limpiar($_POST["coddocumento"]);
		$stmt->execute();

		echo "<span class='fa fa-check-square-o'></span> EL TIPO DE DOCUMENTO HA SIDO ACTUALIZADO EXITOSAMENTE";
		exit;

	} else {

		echo "2";
		exit;
	}
}
####################### FUNCION ACTUALIZAR TIPO DE DOCUMENTOS #######################

######################### FUNCION ELIMINAR TIPO DE DOCUMENTOS #########################
public function EliminarDocumentos()
{
	$this->p = [];
	if ($_SESSION['acceso'] == "administradorG" || $_SESSION["acceso"]=="administradorS") {

	$sql = "SELECT documsucursal FROM sucursales WHERE documsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["coddocumento"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = "DELETE FROM documentos WHERE coddocumento = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$coddocumento);
		$coddocumento = decrypt($_GET["coddocumento"]);
		$stmt->execute();

		echo "1";
		exit;

	} else {
		   
		echo "2";
		exit;
	} 
			
	} else {
		
		echo "3";
		exit;
	}	
}
######################## FUNCION ELIMINAR TIPOS DE DOCUMENTOS ###########################

########################### FIN DE CLASE TIPOS DE DOCUMENTOS ###########################



























############################### CLASE TIPOS DE MONEDAS ##############################

############################ FUNCION REGISTRAR TIPO DE MONEDA ##########################
public function RegistrarTipoMoneda()
{
	$this->p = [];
	if(empty($_POST["moneda"]) or empty($_POST["siglas"]) or empty($_POST["simbolo"]))
	{
		echo "1";
		exit;
	}
	$sql = " SELECT * FROM tiposmoneda WHERE moneda = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["moneda"]));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$query = " INSERT INTO tiposmoneda values (null, ?, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $moneda);
		$stmt->bindParam(2, $siglas);
		$stmt->bindParam(3, $simbolo);

		$moneda = limpiar($_POST["moneda"]);
		$siglas = limpiar($_POST["siglas"]);
		$simbolo = limpiar($_POST["simbolo"]);
		$stmt->execute();

		echo "<span class='fa fa-check-square-o'></span> EL TIPO DE MONEDA HA SIDO REGISTRADO EXITOSAMENTE";
		exit;

	} else {

		echo "2";
		exit;
   }
}
######################### FUNCION REGISTRAR TIPO DE MONEDA #######################

########################## FUNCION LISTAR TIPO DE MONEDA ################################
public function ListarTipoMoneda()
{
	$this->p = [];
	$sql = "SELECT * FROM tiposmoneda";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
}
########################### FUNCION LISTAR TIPO DE MONEDA #########################

############################ FUNCION ID TIPO DE MONEDA #################################
public function TipoMonedaPorId()
{
	$this->p = [];
	$sql = "SELECT * FROM tiposmoneda WHERE codmoneda = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codmoneda"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
	}
}
############################ FUNCION ID TIPO DE MONEDA #################################

####################### FUNCION ACTUALIZAR TIPO DE MONEDA ###########################
public function ActualizarTipoMoneda()
{
	$this->p = [];
	if(empty($_POST["codmoneda"]) or empty($_POST["moneda"]) or empty($_POST["siglas"]) or empty($_POST["simbolo"]))
	{
		echo "1";
		exit;
	}

	$sql = " SELECT moneda FROM tiposmoneda WHERE codmoneda != ? AND moneda = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["codmoneda"],$_POST["moneda"]));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = " UPDATE tiposmoneda set "
		." moneda = ?, "
		." siglas = ?, "
		." simbolo = ? "
		." WHERE "
		." codmoneda = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $moneda);
		$stmt->bindParam(2, $siglas);
		$stmt->bindParam(3, $simbolo);
		$stmt->bindParam(4, $codmoneda);

		$moneda = limpiar($_POST["moneda"]);
		$siglas = limpiar($_POST["siglas"]);
		$simbolo = limpiar($_POST["simbolo"]);
		$codmoneda = limpiar($_POST["codmoneda"]);
		$stmt->execute();

		echo "<span class='fa fa-check-square-o'></span> EL TIPO DE MONEDA HA SIDO ACTUALIZADO EXITOSAMENTE";
		exit;

	} else {

		echo "2";
		exit;
	}
}
######################## FUNCION ACTUALIZAR TIPO DE MONEDA ############################

######################### FUNCION ELIMINAR TIPO DE MONEDA ###########################
public function EliminarTipoMoneda()
{
	$this->p = [];
	if ($_SESSION['acceso'] == "administradorG" || $_SESSION["acceso"]=="administradorS") {

	$sql = "SELECT codmoneda FROM tiposcambio WHERE codmoneda = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codmoneda"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = "DELETE FROM tiposmoneda WHERE codmoneda = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codmoneda);
		$codmoneda = decrypt($_GET["codmoneda"]);
		$stmt->execute();

		echo "1";
		exit;

	} else {
		   
		echo "2";
		exit;
	} 
			
	} else {
		
		echo "3";
		exit;
	}	
}
########################### FUNCION ELIMINAR TIPOS DE MONEDAS ########################

##################### FUNCION BUSCAR TIPOS DE CAMBIOS POR MONEDA #######################
public function BuscarTiposCambios()
{
	$this->p = [];
	$sql = "SELECT * FROM tiposmoneda 
	INNER JOIN tiposcambio ON tiposmoneda.codmoneda = tiposcambio.codmoneda 
	WHERE tiposcambio.codmoneda = ? 
	ORDER BY tiposcambio.codcambio 
	DESC LIMIT 1";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codmoneda"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "<center><div class='alert alert-danger'>";
		echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
		echo "<span class='fa fa-info-circle'></span> NO SE ENCONTRARON TIPOS DE CAMBIO PARA LA MONEDA SELECCIONADA</div></center>";
		exit;
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
	}
}
##################### FUNCION BUSCAR TIPOS DE CAMBIOS POR MONEDA #####################

############################# FIN DE CLASE TIPOS DE MONEDAS #############################
























############################## CLASE TIPOS DE CAMBIOS ################################

########################## FUNCION REGISTRAR TIPO DE CAMBIO #########################
public function RegistrarTipoCambio()
{
	$this->p = [];
	if(empty($_POST["descripcioncambio"]) or empty($_POST["montocambio"]) or empty($_POST["codmoneda"]) or empty($_POST["fechacambio"]) or empty($_POST["codsucursal"]))
	{
		echo "1";
		exit;
	}
			
	$sql = "SELECT codmoneda, fechacambio 
	FROM tiposcambio WHERE codmoneda = ? AND fechacambio = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["codmoneda"],date("Y-m-d",strtotime($_POST['fechacambio'])),decrypt($_POST["codsucursal"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$query = "INSERT INTO tiposcambio values (null, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $descripcioncambio);
		$stmt->bindParam(2, $montocambio);
		$stmt->bindParam(3, $codmoneda);
		$stmt->bindParam(4, $fechacambio);
		$stmt->bindParam(5, $codsucursal);

		$descripcioncambio = limpiar($_POST["descripcioncambio"]);
		$montocambio = number_format($_POST["montocambio"], 3, '.', '');
		$codmoneda = limpiar(decrypt($_POST["codmoneda"]));
		$fechacambio = limpiar(date("Y-m-d",strtotime($_POST['fechacambio'])));
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();

		echo "<span class='fa fa-check-square-o'></span> EL TIPO DE CAMBIO HA SIDO REGISTRADO EXITOSAMENTE";
		exit;

	} else {

		echo "2";
		exit;
   }
}
######################### FUNCION REGISTRAR TIPO DE CAMBIO ########################

########################### FUNCION LISTAR TIPO DE CAMBIO ########################
public function ListarTipoCambio() 
{
	$this->p = [];
	$tipoAcceso  = isset($_SESSION["acceso"]) ? limpiar($_SESSION["acceso"]) : '';
    $codSucursal = ($tipoAcceso === 'administradorG') ? limpiar(decrypt($_GET["codsucursal"])) : limpiar($_SESSION["codsucursal"]);
    // Preparamos los parámetros de forma segura para la consulta
    $whereConditions = [];
    $params          = [];

    $whereConditions[] = "tc.codsucursal = ?";
    $params[]          = $codSucursal;

    $whereClause = "";
    if (!empty($whereConditions)) {
      $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $sqlBase = "SELECT
    tc.*,
    tm.moneda, tm.siglas, tm.simbolo,
	suc.documsucursal, suc.cuitsucursal, suc.nomsucursal,
	suc.documencargado, suc.dniencargado, suc.nomencargado,
	doc.documento
	FROM 
	   tiposcambio tc 
	INNER JOIN tiposmoneda tm ON tc.codmoneda = tm.codmoneda
	LEFT JOIN sucursales suc ON tc.codsucursal = suc.codsucursal
	LEFT JOIN documentos doc ON suc.documencargado = doc.coddocumento";
    $sql = $sqlBase . $whereClause . " ORDER BY tc.fechacambio ASC";
    try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($results)) {
            return [];
        } else {
            return $results;
        }
    } catch (PDOException $e) {
        error_log("Error en ListarTipoCambio: " . $e->getMessage());
        return [];
    }
}
######################### FUNCION LISTAR TIPO DE CAMBIO ################################

######################## FUNCION ID TIPO DE CAMBIO #################################
public function TipoCambioPorId()
{
	$this->p = [];
	$codCambio = limpiar(decrypt($_GET["codcambio"]));
	$sql = "SELECT 
	    tc.*,
	    tm.moneda, tm.siglas, tm.simbolo,
		suc.documsucursal, suc.cuitsucursal, suc.nomsucursal,
		suc.documencargado, suc.dniencargado, suc.nomencargado,
		doc.documento
	FROM 
	   tiposcambio tc 
	INNER JOIN tiposmoneda tm ON tc.codmoneda = tm.codmoneda
	LEFT JOIN sucursales suc ON tc.codsucursal = suc.codsucursal
	LEFT JOIN documentos doc ON suc.documencargado = doc.coddocumento
	WHERE tc.codcambio = :codCambio";
	try {
        $stmt = $this->dbh->prepare($sql);
        // Asignamos los parámetros a los marcadores de posición con nombre
        $stmt->bindParam(':codCambio', $codCambio);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        if (!$row) {
            echo "<div class='alert alert-danger'>";
            echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
            echo "<center><span class='fa fa-info-circle'></span> TIPO DE CAMBIO NO ENCONTRADO.</center>";
            echo "</div>";
            exit();
        } else {
            $this->p[] = $row;
            return $this->p;
        }
    } catch (PDOException $e) {
        error_log("Error en TipoCambioPorId: " . $e->getMessage());
        echo "<div class='alert alert-danger'>";
        echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
        echo "<center><span class='fa fa-exclamation-triangle'></span> OCURRIÓ UN ERROR AL CONSULTAR EL TIPO DE CAMBIO.</center>";
        echo "</div>";
        return [];
    }
}
############################ FUNCION ID TIPO DE CAMBIO #################################

####################### FUNCION ACTUALIZAR TIPO DE CAMBIO ############################
public function ActualizarTipoCambio()
{
	$this->p = [];
	if(empty($_POST["codcambio"])or empty($_POST["descripcioncambio"]) or empty($_POST["montocambio"]) or empty($_POST["codmoneda"]) or empty($_POST["fechacambio"]) or empty($_POST["codsucursal"]))
	{
		echo "1";
		exit;
	}
			
	$sql = "SELECT codmoneda, fechacambio 
	FROM tiposcambio WHERE codcambio != ? AND codmoneda = ? AND fechacambio = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_POST["codcambio"]),$_POST["codmoneda"],date("Y-m-d",strtotime($_POST['fechacambio'])),decrypt($_POST["codsucursal"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = "UPDATE tiposcambio set "
		." descripcioncambio = ?, "
		." montocambio = ?, "
		." codmoneda = ?, "
		." fechacambio = ?, "
		." codsucursal = ? "
		." WHERE "
		." codcambio = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $descripcioncambio);
		$stmt->bindParam(2, $montocambio);
		$stmt->bindParam(3, $codmoneda);
		$stmt->bindParam(4, $fechacambio);
		$stmt->bindParam(5, $codsucursal);
		$stmt->bindParam(6, $codcambio);

		$descripcioncambio = limpiar($_POST["descripcioncambio"]);
		$montocambio = number_format($_POST["montocambio"], 3, '.', '');
		$codmoneda = limpiar(decrypt($_POST["codmoneda"]));
		$fechacambio = limpiar(date("Y-m-d",strtotime($_POST['fechacambio'])));
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$codcambio = limpiar(decrypt($_POST["codcambio"]));
		$stmt->execute();

		echo "<span class='fa fa-check-square-o'></span> EL TIPO DE CAMBIO HA SIDO ACTUALIZADO EXITOSAMENTE";
		exit;

	} else {

		echo "2";
		exit;
   }
}
###################### FUNCION ACTUALIZAR TIPO DE CAMBIO ############################

########################## FUNCION ELIMINAR TIPO DE CAMBIO ###########################
public function EliminarTipoCambio()
{
	$this->p = [];
	if ($_SESSION['acceso'] == "administradorG" || $_SESSION["acceso"]=="administradorS") {

	   $sql = "DELETE FROM tiposcambio WHERE codcambio = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codcambio);
		$codcambio = decrypt($_GET["codcambio"]);
		$stmt->execute();

		echo "1";
		exit;

	} else {
	   
		echo "2";
		exit;
	} 
}
########################### FUNCION ELIMINAR TIPO DE CAMBIO ###########################

######################## FUNCION BUSCAR PRODUCTOS POR MONEDA ###########################
public function MonedaProductoId() 
{
	$this->p = [];
	$tipoAcceso  = isset($_SESSION["acceso"]) ? limpiar($_SESSION["acceso"]) : '';
    $codSucursal = ($tipoAcceso === 'administradorG') ? limpiar(decrypt($_GET["codsucursal"])) : limpiar($_SESSION["codsucursal"]);
    // Preparamos los parámetros de forma segura para la consulta
    $whereConditions = [];
    $params          = [];

    $whereConditions[] = "suc.codsucursal = ?";
    $params[]          = $codSucursal;

    $whereClause = "";
    if (!empty($whereConditions)) {
      $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $sqlBase = "SELECT
        suc.codmoneda, suc.codmoneda2,
		tm.moneda, tm.siglas, tm.simbolo,
		tm2.moneda AS moneda2, tm2.siglas AS siglas2, tm2.simbolo AS simbolo2,
		tc.montocambio 
	FROM sucursales suc
	INNER JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
	LEFT JOIN 
	    tiposmoneda tm2 ON suc.codmoneda2 = tm2.codmoneda
	INNER JOIN 
	    tiposcambio tc ON tm2.codmoneda = tc.codmoneda";
    $sql = $sqlBase . $whereClause . " ORDER BY tc.codcambio DESC LIMIT 1";
    try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($results)) {
            return [];
        } else {
            return $results;
        }
    } catch (PDOException $e) {
        error_log("Error en MonedaProductoId: " . $e->getMessage());
        return [];
    }
}
###################### FUNCION BUSCAR PRODUCTOS POR MONEDA ##########################

############################ FIN DE CLASE TIPOS DE CAMBIOS #############################














################################# CLASE MEDIOS DE PAGOS ################################

########################### FUNCION REGISTRAR MEDIOS DE PAGOS ###########################
public function RegistrarMediosPagos()
{
	$this->p = [];
	if(empty($_POST["mediopago"]) or empty($_POST["codsucursal"]))
	{
		echo "1";
		exit;
	}
	$sql = " SELECT mediopago FROM mediospagos WHERE mediopago = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["mediopago"],decrypt($_POST["codsucursal"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$query = " INSERT INTO mediospagos values (null, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $mediopago);
		$stmt->bindParam(2, $codsucursal);

		$mediopago = limpiar($_POST["mediopago"]);
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();

		echo "<span class='fa fa-check-square-o'></span> EL MEDIO DE PAGO HA SIDO REGISTRADO EXITOSAMENTE";
		exit;

	} else {

		echo "2";
		exit;
   }
}
############################ FUNCION REGISTRAR MEDIOS DE PAGOS ##########################

########################## FUNCION LISTAR MEDIOS DE PAGOS ##########################
public function ListarMediosPagos() 
{
	$this->p = [];
	$tipoAcceso  = isset($_SESSION["acceso"]) ? limpiar($_SESSION["acceso"]) : '';
    $codSucursal = ($tipoAcceso === 'administradorG') ? limpiar(decrypt($_GET["codsucursal"])) : limpiar($_SESSION["codsucursal"]);
    // Preparamos los parámetros de forma segura para la consulta
    $whereConditions = [];
    $params          = [];

    $whereConditions[] = "mp.codsucursal = ?";
    $params[]          = $codSucursal;

    $whereClause = "";
    if (!empty($whereConditions)) {
      $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $sqlBase = "SELECT
    mp.*,
	suc.documsucursal, suc.cuitsucursal, suc.nomsucursal,
	suc.documencargado, suc.dniencargado, suc.nomencargado,
	doc.documento
	FROM mediospagos mp
	LEFT JOIN sucursales suc ON mp.codsucursal = suc.codsucursal
	LEFT JOIN documentos doc ON suc.documencargado = doc.coddocumento";
    $sql = $sqlBase . $whereClause . " ORDER BY mp.mediopago ASC";
    try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($results)) {
            return [];
        } else {
            return $results;
        }
    } catch (PDOException $e) {
        error_log("Error en ListarMediosPagos: " . $e->getMessage());
        return [];
    }
}
########################### FUNCION LISTAR MEDIOS DE PAGOS ##########################

############################ FUNCION ID MEDIOS DE PAGOS #################################
public function MediosPagosPorId()
{
	$this->p = [];
	$sql = "SELECT * FROM mediospagos WHERE codmediopago = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codmediopago"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
	}
}
############################ FUNCION ID MEDIOS DE PAGOS #################################

##################### FUNCION ACTUALIZAR MEDIOS DE PAGOS ############################
public function ActualizarMediosPagos()
{
	$this->p = [];
	if(empty($_POST["codmediopago"]) or empty($_POST["mediopago"]) or empty($_POST["codsucursal"]))
	{
		echo "1";
		exit;
	}
	$sql = " SELECT mediopago FROM mediospagos WHERE codmediopago != ? AND mediopago = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_POST["codmediopago"]),$_POST["mediopago"],decrypt($_POST["codsucursal"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = " UPDATE mediospagos set "
		." mediopago = ?, "
		." codsucursal = ? "
		." WHERE "
		." codmediopago = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $mediopago);
		$stmt->bindParam(2, $codsucursal);
		$stmt->bindParam(3, $codmediopago);

		$mediopago = limpiar($_POST["mediopago"]);
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$codmediopago = limpiar(decrypt($_POST["codmediopago"]));
		$stmt->execute();

		echo "<span class='fa fa-check-square-o'></span> EL MEDIO DE PAGO HA SIDO ACTUALIZADO EXITOSAMENTE";
		exit;

		} else {

		echo "2";
		exit;
	}
}
##################### FUNCION ACTUALIZAR MEDIOS DE PAGOS ############################

########################## FUNCION ELIMINAR MEDIOS DE PAGOS #########################
public function EliminarMediosPagos()
{
	$this->p = [];
	if ($_SESSION['acceso'] == "administradorG" || $_SESSION["acceso"]=="administradorS") {

	$sql = "SELECT codmediopago FROM mediospagoxventas WHERE codmediopago = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codmediopago"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = "DELETE FROM mediospagos WHERE codmediopago = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codmediopago);
		$codmediopago = decrypt($_GET["codmediopago"]);
		$stmt->execute();

		echo "1";
		exit;

	} else {
		   
		echo "2";
		exit;
	} 
			
	} else {
		
		echo "3";
		exit;
	}	
}
########################## FUNCION ELIMINAR MEDIOS DE PAGOS ###########################

############################ FIN DE CLASE MEDIOS DE PAGOS ##############################



















############################### CLASE IMPUESTOS ####################################

############################ FUNCION REGISTRAR IMPUESTOS ###############################
public function RegistrarImpuestos()
{
	$this->p = [];
	if(empty($_POST["nomimpuesto"]) or empty($_POST["valorimpuesto"]) or empty($_POST["statusimpuesto"]) or empty($_POST["codsucursal"]))
	{
		echo "1";
		exit;
	}
	$sql = " SELECT statusimpuesto FROM impuestos WHERE nomimpuesto != ? AND statusimpuesto = ? AND codsucursal = ? AND statusimpuesto = 1";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["nomimpuesto"],$_POST["statusimpuesto"],decrypt($_POST["codsucursal"])));
	$num = $stmt->rowCount();
	if($num>0)
	{
		echo "2";
		exit;
	}
	$sql = " SELECT nomimpuesto FROM impuestos WHERE nomimpuesto = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["nomimpuesto"],decrypt($_POST["codsucursal"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$query = " INSERT INTO impuestos values (null, ?, ?, ?, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $nomimpuesto);
		$stmt->bindParam(2, $valorimpuesto);
		$stmt->bindParam(3, $statusimpuesto);
		$stmt->bindParam(4, $fechaimpuesto);
		$stmt->bindParam(5, $codsucursal);

		$nomimpuesto = limpiar($_POST["nomimpuesto"]);
		$valorimpuesto = limpiar($_POST["valorimpuesto"]);
		$statusimpuesto = limpiar($_POST["statusimpuesto"]);
		$fechaimpuesto = limpiar(date("Y-m-d",strtotime($_POST['fechaimpuesto'])));
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();

		echo "<span class='fa fa-check-square-o'></span> EL IMPUESTO HA SIDO REGISTRADO  EXITOSAMENTE";
		exit;

	} else {

		echo "3";
		exit;
	}
}
############################ FUNCION REGISTRAR IMPUESTOS ###############################

############################# FUNCION LISTAR IMPUESTOS ################################
public function ListarImpuestos() 
{
	$this->p = [];
	$tipoAcceso  = isset($_SESSION["acceso"]) ? limpiar($_SESSION["acceso"]) : '';
    $codSucursal = ($tipoAcceso === 'administradorG') ? limpiar(decrypt($_GET["codsucursal"])) : limpiar($_SESSION["codsucursal"]);
    // Preparamos los parámetros de forma segura para la consulta
    $whereConditions = [];
    $params          = [];

    $whereConditions[] = "imp.codsucursal = ?";
    $params[]          = $codSucursal;

    $whereClause = "";
    if (!empty($whereConditions)) {
      $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $sqlBase = "SELECT
    imp.*,
	suc.documsucursal, suc.cuitsucursal, suc.nomsucursal,
	suc.documencargado, suc.dniencargado, suc.nomencargado,
	doc.documento
	FROM 
	   impuestos imp 
	LEFT JOIN sucursales suc ON imp.codsucursal = suc.codsucursal
	LEFT JOIN documentos doc ON suc.documencargado = doc.coddocumento";
    $sql = $sqlBase . $whereClause . " ORDER BY imp.nomimpuesto ASC";
    try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($results)) {
            return [];
        } else {
            return $results;
        }
    } catch (PDOException $e) {
        error_log("Error en ListarImpuestos: " . $e->getMessage());
        return [];
    }
}
############################# FUNCION LISTAR IMPUESTOS ################################

############################ FUNCION ID IMPUESTOS #################################
public function ImpuestosPorId() {
   $this->p = [];
   $codSucursal = null;
   if (isset($_SESSION["acceso"])) {
      if ($_SESSION['acceso'] == "administradorG") {
         if (isset($_GET["codsucursal"])) {
            $codSucursal = decrypt($_GET["codsucursal"]);
         }
      } else {
         $codSucursal = limpiar($_SESSION["codsucursal"]);
      }
   } elseif (isset($_GET["valor2"])) {
      $codSucursal = decrypt($_GET["valor2"]);
   }
   if (empty($codSucursal)) {
      return $this->p;
   }
   $sql = "SELECT
      i.codimpuesto,
      i.nomimpuesto,
      i.valorimpuesto,
      i.statusimpuesto,
      i.fechaimpuesto,
      i.codsucursal
   FROM impuestos i
   LEFT JOIN sucursales s ON i.codsucursal = s.codsucursal
   WHERE i.codsucursal = :codsucursal
   ORDER BY i.nomimpuesto ASC";
   try {
      $stmt = $this->dbh->prepare($sql);
      $stmt->bindParam(':codsucursal', $codSucursal, PDO::PARAM_STR);
      $stmt->execute();
      $this->p = $stmt->fetchAll(PDO::FETCH_ASSOC);
   } catch (PDOException $e) {
      error_log("Error al Listar Impuestos: " . $e->getMessage());
      return [];
   }
   return $this->p;
}
############################ FUNCION ID IMPUESTOS #################################

############################ FUNCION ACTUALIZAR IMPUESTOS ############################
public function ActualizarImpuestos()
{
	$this->p = [];
	if(empty($_POST["codimpuesto"]) or empty($_POST["nomimpuesto"]) or empty($_POST["valorimpuesto"]) or empty($_POST["statusimpuesto"]) or empty($_POST["codsucursal"]))
	{
		echo "1";
		exit;
	}
	$sql = " SELECT statusimpuesto FROM impuestos WHERE codimpuesto != ? AND statusimpuesto = ? AND codsucursal = ? AND statusimpuesto = 1";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_POST["codimpuesto"]),$_POST["statusimpuesto"],decrypt($_POST["codsucursal"])));
	$num = $stmt->rowCount();
	if($num>0)
	{
		echo "2";
		exit;
	}
	$sql = "SELECT nomimpuesto FROM impuestos WHERE codimpuesto != ? AND nomimpuesto = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_POST["codimpuesto"]),$_POST["nomimpuesto"],decrypt($_POST["codsucursal"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = " UPDATE impuestos set "
		." nomimpuesto = ?, "
		." valorimpuesto = ?, "
		." statusimpuesto = ?, "
		." codsucursal = ? "
		." WHERE "
		." codimpuesto = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $nomimpuesto);
		$stmt->bindParam(2, $valorimpuesto);
		$stmt->bindParam(3, $statusimpuesto);
		$stmt->bindParam(4, $codsucursal);
		$stmt->bindParam(5, $codimpuesto);

		$nomimpuesto = limpiar($_POST["nomimpuesto"]);
		$valorimpuesto = limpiar($_POST["valorimpuesto"]);
		$statusimpuesto = limpiar($_POST["statusimpuesto"]);
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$codimpuesto = limpiar(decrypt($_POST["codimpuesto"]));
		$stmt->execute();

		echo "<span class='fa fa-check-square-o'></span> EL IMPUESTO HA SIDO ACTUALIZADO EXITOSAMENTE";
		exit;

	} else {

		echo "3";
		exit;
	}
}
############################ FUNCION ACTUALIZAR IMPUESTOS ############################

######################### FUNCION ELIMINAR IMPUESTOS #########################
public function EliminarImpuestos()
{
	$this->p = [];
	if ($_SESSION['acceso'] == "administradorG" || $_SESSION["acceso"]=="administradorS") {

	$sql = "SELECT * FROM impuestos WHERE codimpuesto = ? AND statusimpuesto = 1";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codimpuesto"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = "DELETE FROM impuestos WHERE codimpuesto = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codimpuesto);
		$codimpuesto = decrypt($_GET["codimpuesto"]);
		$stmt->execute();

		echo "1";
		exit;

	} else {
		   
		echo "2";
		exit;
	} 
			
   } else {
		
		echo "3";
		exit;
	}	
}
######################## FUNCION ELIMINAR IMPUESTOS ###########################

############################ FIN DE CLASE IMPUESTOS ################################



















################################# CLASE BANCOS ################################

########################### FUNCION REGISTRAR BANCOS ###########################
public function RegistrarBancos()
{
	$this->p = [];
	if(empty($_POST["nombanco"]) or empty($_POST["codsucursal"]))
	{
		echo "1";
		exit;
	}
	$sql = " SELECT nombanco FROM bancos WHERE nombanco = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["nombanco"],decrypt($_POST["codsucursal"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$query = " INSERT INTO bancos values (null, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $nombanco);
		$stmt->bindParam(2, $codsucursal);

		$nombanco = limpiar($_POST["nombanco"]);
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();

		echo "<span class='fa fa-check-square-o'></span> EL BANCO HA SIDO REGISTRADO EXITOSAMENTE";
		exit;

	} else {

		echo "2";
		exit;
   }
}
############################ FUNCION REGISTRAR BANCOS ##########################

########################## FUNCION LISTAR BANCOS ##########################
public function ListarBancos() 
{
	$this->p = [];
	$tipoAcceso  = isset($_SESSION["acceso"]) ? limpiar($_SESSION["acceso"]) : '';
    $codSucursal = ($tipoAcceso === 'administradorG') ? limpiar(decrypt($_GET["codsucursal"])) : limpiar($_SESSION["codsucursal"]);
    // Preparamos los parámetros de forma segura para la consulta
    $whereConditions = [];
    $params          = [];

    $whereConditions[] = "ban.codsucursal = ?";
    $params[]          = $codSucursal;

    $whereClause = "";
    if (!empty($whereConditions)) {
      $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $sqlBase = "SELECT
    ban.*,
	suc.documsucursal, suc.cuitsucursal, suc.nomsucursal,
	suc.documencargado, suc.dniencargado, suc.nomencargado,
	doc.documento
	FROM 
	   bancos ban 
	LEFT JOIN sucursales suc ON ban.codsucursal = suc.codsucursal
	LEFT JOIN documentos doc ON suc.documencargado = doc.coddocumento";
    $sql = $sqlBase . $whereClause . " ORDER BY ban.nombanco ASC";
    try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($results)) {
            return [];
        } else {
            return $results;
        }
    } catch (PDOException $e) {
        error_log("Error en ListarBancos: " . $e->getMessage());
        return [];
    }
}
########################### FUNCION LISTAR BANCOS ##########################

############################ FUNCION ID BANCOS #################################
public function BancosPorId()
{
	$this->p = [];
	$sql = "SELECT * FROM bancos WHERE codbanco = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codbanco"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
	}
}
############################ FUNCION ID BANCOS #################################

##################### FUNCION ACTUALIZAR BANCOS ############################
public function ActualizarBancos()
{
	$this->p = [];
	if(empty($_POST["codbanco"]) or empty($_POST["nombanco"]) or empty($_POST["codsucursal"]))
	{
		echo "1";
		exit;
	}
	$sql = " SELECT nombanco FROM bancos WHERE codbanco != ? AND nombanco = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_POST["codbanco"]),$_POST["nombanco"],decrypt($_POST["codsucursal"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = " UPDATE bancos set "
		." nombanco = ?, "
		." codsucursal = ? "
		." WHERE "
		." codbanco = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $nombanco);
		$stmt->bindParam(2, $codsucursal);
		$stmt->bindParam(3, $codbanco);

		$nombanco = limpiar($_POST["nombanco"]);
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$codbanco = limpiar(decrypt($_POST["codbanco"]));
		$stmt->execute();

		echo "<span class='fa fa-check-square-o'></span> EL BANCO HA SIDO ACTUALIZADO EXITOSAMENTE";
		exit;

	} else {

		echo "2";
		exit;
	}
}
##################### FUNCION ACTUALIZAR BANCOS ############################

########################## FUNCION ELIMINAR BANCOS #########################
public function EliminarBancos()
{
	$this->p = [];
	if ($_SESSION['acceso'] == "administradorG" || $_SESSION["acceso"]=="administradorS") {

	$sql = "SELECT codbanco FROM abonoscreditoscompras WHERE codbanco = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codbanco"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = "DELETE FROM bancos WHERE codbanco = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codbanco);
		$codbanco = decrypt($_GET["codbanco"]);
		$stmt->execute();

		echo "1";
		exit;

	} else {
		   
		echo "2";
		exit;
	} 
			
	} else {
		
		echo "3";
		exit;
	}	
}
########################## FUNCION ELIMINAR BANCOS ###########################

############################ FIN DE CLASE BANCOS ##############################
















############################# CLASE SUCURSALES ##################################

############################ FUNCION REGISTRAR SUCURSALES ##########################
public function RegistrarSucursales()
{
	$this->p = [];
	if(empty($_POST["dniencargado"]) or empty($_POST["nomencargado"]) or empty($_POST["cuitsucursal"]) or empty($_POST["nomsucursal"]))
	{
		echo "1";
		exit;
	}
	//llamada de la funcion
	/*elseif (!valida_rut($_POST["cuitsucursal"]))
	{
		echo "2";
		exit;
	}
	//llamada de la funcion
	elseif (!valida_rut($_POST["dniencargado"]))
	{
		echo "3";
		exit;
	}
	$sql = " SELECT correosucursal FROM sucursales WHERE correosucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["correosucursal"]));
	$num = $stmt->rowCount();
	if($num > 0)
	{
		echo "4";
		exit;
	}*/

	$sql = "SELECT cuitsucursal, nomsucursal FROM sucursales WHERE cuitsucursal = ? AND nomsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["cuitsucursal"],$_POST["nomsucursal"]));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		############################ REGISTRO DE SUCURSAL ############################
		$query = " INSERT INTO sucursales values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $documsucursal);
		$stmt->bindParam(2, $cuitsucursal);
		$stmt->bindParam(3, $nomsucursal);
        $stmt->bindParam(4, $codgiro);
        $stmt->bindParam(5, $girosucursal);
		$stmt->bindParam(6, $id_ciudad);
		$stmt->bindParam(7, $id_comuna);
		$stmt->bindParam(8, $direcsucursal);
		$stmt->bindParam(9, $correosucursal);
		$stmt->bindParam(10, $tlfsucursal);
		$stmt->bindParam(11, $nroactividadsucursal);
		$stmt->bindParam(12, $inicioboleta);
		$stmt->bindParam(13, $iniciofactura);
		$stmt->bindParam(14, $inicioguia);
		$stmt->bindParam(15, $inicionotaventa);
		$stmt->bindParam(16, $inicionotacredito);
		$stmt->bindParam(17, $fechaautorsucursal);
		$stmt->bindParam(18, $llevacontabilidad);
		$stmt->bindParam(19, $documencargado);
		$stmt->bindParam(20, $dniencargado);
		$stmt->bindParam(21, $nomencargado);
		$stmt->bindParam(22, $tlfencargado);
		$stmt->bindParam(23, $descsucursal);
		$stmt->bindParam(24, $porcentaje);
		$stmt->bindParam(25, $codmoneda);
		$stmt->bindParam(26, $codmoneda2);
		$stmt->bindParam(27, $membrete);
		$stmt->bindParam(28, $estado);
		$stmt->bindParam(29, $mostrar_pos);
		$stmt->bindParam(30, $lioren_token);

		$documsucursal        = limpiar($_POST['documsucursal'] == '' ? "0" : decrypt($_POST['documsucursal']));
		$cuitsucursal         = limpiar($_POST["cuitsucursal"]);
		$nomsucursal          = limpiar($_POST["nomsucursal"]);
        $codgiro              = limpiar($_POST["codgiro"]);
        $girosucursal         = limpiar($_POST["girosucursal"]);
		$id_ciudad            = limpiar($_POST['id_ciudad'] == '' ? "0" : $_POST['id_ciudad']);
		$id_comuna            = limpiar($_POST['id_comuna'] == '' ? "0" : $_POST['id_comuna']);
		$direcsucursal        = limpiar($_POST["direcsucursal"]);
		$correosucursal       = limpiar($_POST["correosucursal"]);
		$tlfsucursal          = limpiar($_POST["tlfsucursal"]);
		$nroactividadsucursal = limpiar($_POST["nroactividadsucursal"]);
		$inicioboleta         = limpiar($_POST["inicioboleta"]);
		$iniciofactura        = limpiar($_POST["iniciofactura"]);
		$inicioguia           = limpiar($_POST["inicioguia"]);
		$inicionotaventa      = limpiar($_POST["inicionotaventa"]);
		$inicionotacredito    = limpiar($_POST["inicionotacredito"]);
		$fechaautorsucursal   = limpiar($_POST['fechaautorsucursal'] == '' ? "0000-00-00" : date("Y-m-d",strtotime($_POST['fechaautorsucursal'])));
		$llevacontabilidad    = limpiar($_POST["llevacontabilidad"]);
		$documencargado       = limpiar($_POST['documencargado'] == '' ? "0" : decrypt($_POST['documencargado']));
		$dniencargado         = limpiar($_POST["dniencargado"]);
		$nomencargado         = limpiar($_POST["nomencargado"]);
		$tlfencargado         = limpiar($_POST["tlfencargado"]);
		$descsucursal         = limpiar($_POST["descsucursal"]);
		$porcentaje           = limpiar($_POST["porcentaje"]);
		$codmoneda            = limpiar(decrypt($_POST["codmoneda"]));
		$codmoneda2           = limpiar($_POST['codmoneda2'] == '' ? "0" : decrypt($_POST['codmoneda2']));
		$membrete             = limpiar($_POST["membrete"]);
		$estado               = limpiar("1");
		$mostrar_pos          = limpiar(isset($_POST['mostrar_pos']) ? $_POST['mostrar_pos'] : "");
		$lioren_token         = limpiar(isset($_POST['lioren_token']) ? $_POST['lioren_token'] : "");
		$stmt->execute();
		############################ REGISTRO DE SUCURSAL ############################

		############################ OBTENGO EL ULTIMO ID DE SUCURSAL ############################
	    $lastIdSucursal = $this->dbh->lastInsertId();
	    ############################ OBTENGO EL ULTIMO ID DE SUCURSAL ############################ 

        ############################ SUBIR LOGO DE SUCURSAL ############################
	    //datos de carpetas
	    $dirmake_producto = limpiar(is_dir('fotos/productos/'.$lastIdSucursal) ? "" : mkdir('fotos/productos/'.$lastIdSucursal, 0777));//creo carpeta en productos
	    $dirmake_combo    = limpiar(is_dir('fotos/combos/'.$lastIdSucursal) ? "" : mkdir('fotos/combos/'.$lastIdSucursal, 0777));//creo carpeta en productos
	    $dirmake_sii      = limpiar(is_dir('sii/'.$lastIdSucursal) ? "" : mkdir('sii/'.$lastIdSucursal, 0777));//creo carpeta en sii

	    //datos del arhivo
	    $nombre_archivo   = limpiar(isset($_FILES['imagen']['name']) ? $_FILES['imagen']['name'] : "");
		$tipo_archivo     = limpiar(isset($_FILES['imagen']['type']) ? $_FILES['imagen']['type'] : "");
		$tamano_archivo   = limpiar(isset($_FILES['imagen']['size']) ? $_FILES['imagen']['size'] : "");

	    //compruebo si las características del archivo son las que deseo  
        if (!empty($_FILES["imagen"]) && (strpos($tipo_archivo,'image/png')!==false)&&$tamano_archivo<2097152)// 2MB 
        {  
		   if (move_uploaded_file($_FILES['imagen']['tmp_name'], "fotos/sucursales/".$nombre_archivo) && rename("fotos/sucursales/".$nombre_archivo,"fotos/sucursales/".$_POST["cuitsucursal"].".png"))
		   { 
	       ## se puede dar un aviso
		   } 
	       ## se puede dar otro aviso 
	    }
	    ############################ SUBIR LOGO DE SUCURSAL ############################ 

		echo "<span class='fa fa-check-square-o'></span> LA SUCURSAL HA SIDO REGISTRADA EXITOSAMENTE";
		exit;
	}
	else
	{
		echo "5";
		exit;
	}
}
######################### FUNCION REGISTRAR SUCURSALES ###############################

######################## FUNCION LISTAR SUCURSALES ###############################
public function ListarSucursales()
{
	$this->p = [];
	$tipoAcceso      = isset($_SESSION["acceso"]) ? limpiar($_SESSION["acceso"]) : '';
	$codSucursal     = ($tipoAcceso === 'administradorG') ? "0" : limpiar($_SESSION["codsucursal"]);
    $whereConditions = [];
    $params          = [];

    // Lógica de filtro basada en el tipo de acceso
    if ($tipoAcceso === 'administradorS') { // Acceso Administrador de Sucursal
        $whereConditions[] = "suc.codsucursal = ?";
        $params[]          = $codSucursal;
    }
   
    $whereClause = "";
    if (!empty($whereConditions)) {
      $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $sqlBase = "SELECT
        suc.*,
        ciud.ciudad, com.comuna, 
		doc.documento, doc2.documento AS documento2,
		tm.moneda, tm.siglas, tm.simbolo,
        tm2.moneda AS moneda2, tm2.siglas AS siglas2, tm2.simbolo AS simbolo2
	FROM 
        (sucursales suc LEFT JOIN documentos doc ON suc.documsucursal = doc.coddocumento)
	LEFT JOIN 
	    documentos AS doc2 ON suc.documencargado = doc2.coddocumento
    LEFT JOIN 
        ciudades ciud ON suc.id_ciudad = ciud.id_ciudad 
    LEFT JOIN 
        comunas com ON suc.id_comuna = com.id_comuna
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
	LEFT JOIN 
        tiposmoneda tm2 ON suc.codmoneda2 = tm2.codmoneda";
    $sql = $sqlBase . $whereClause . " ORDER BY suc.codsucursal ASC";
    try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($results)) {
            return [];
        } else {
            return $results;
        }
    } catch (PDOException $e) {
        error_log("Error en ListarSucursales: " . $e->getMessage());
        return [];
    }
}
########################## FUNCION LISTAR SUCURSALES ##########################

######################## FUNCION LISTAR SUCURSALES DIFERENTES A SESSION ###############################
public function ListarSucursalesDiferentes($gruposid)
{
	$this->p = [];
    $whereConditions = [];
    $params          = [];

    // Lógica de filtro basada en el tipo de acceso
    $whereConditions[] = "suc.codsucursal IN ($gruposid)";
    //$params[]          = $gruposid;
   
    $whereClause = "";
    if (!empty($whereConditions)) {
      $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $sqlBase = "SELECT
        suc.*,
        ciud.ciudad, com.comuna, 
		doc.documento, doc2.documento AS documento2,
		tm.moneda, tm.siglas, tm.simbolo,
        tm2.moneda AS moneda2, tm2.siglas AS siglas2, tm2.simbolo AS simbolo2
	FROM 
        (sucursales suc LEFT JOIN documentos doc ON suc.documsucursal = doc.coddocumento)
	LEFT JOIN 
	    documentos AS doc2 ON suc.documencargado = doc2.coddocumento
    LEFT JOIN 
        ciudades ciud ON suc.id_ciudad = ciud.id_ciudad 
    LEFT JOIN 
        comunas com ON suc.id_comuna = com.id_comuna
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
	LEFT JOIN 
        tiposmoneda tm2 ON suc.codmoneda2 = tm2.codmoneda";
    $sql = $sqlBase . $whereClause . " ORDER BY suc.codsucursal ASC";
    try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($results)) {
            return [];
        } else {
            return $results;
        }
    } catch (PDOException $e) {
        error_log("Error en ListarSucursalesDiferentes: " . $e->getMessage());
        return [];
    }
}
########################## FUNCION LISTAR SUCURSALES DIFERENTES A SESSION ########################## 

############################ FUNCION ID SUCURSALES #################################
public function SucursalesPorId()
{
	$this->p = [];
	$codSucursal = limpiar(decrypt($_GET["codsucursal"]));
	$sql = "SELECT 
	    suc.*,
	    ciud.codciudad, ciud.ciudad, com.codcomuna, com.comuna,
		doc.documento, doc2.documento AS documento2,
		tm.moneda, tm.siglas, tm.simbolo,
        tm2.moneda AS moneda2, tm2.siglas AS siglas2, tm2.simbolo AS simbolo2
	FROM 
        (sucursales suc LEFT JOIN documentos doc ON suc.documsucursal = doc.coddocumento)
	LEFT JOIN 
	    documentos AS doc2 ON suc.documencargado = doc2.coddocumento
    LEFT JOIN 
        ciudades ciud ON suc.id_ciudad = ciud.id_ciudad 
    LEFT JOIN 
        comunas com ON suc.id_comuna = com.id_comuna
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
	LEFT JOIN 
        tiposmoneda tm2 ON suc.codmoneda2 = tm2.codmoneda
	WHERE suc.codsucursal = :codSucursal";
	try {
        $stmt = $this->dbh->prepare($sql);
        // Asignamos los parámetros a los marcadores de posición con nombre
        $stmt->bindParam(':codSucursal', $codSucursal);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        if (!$row) {
            echo "";
        } else {
            $this->p[] = $row;
            return $this->p;
        }
    } catch (PDOException $e) {
        error_log("Error en SucursalesPorId: " . $e->getMessage());
        echo "<div class='alert alert-danger'>";
        echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
        echo "<center><span class='fa fa-exclamation-triangle'></span> OCURRIÓ UN ERROR AL CONSULTAR LA SUCURSAL.</center>";
        echo "</div>";
        return [];
    }
}
############################ FUNCION ID SUCURSALES #################################

############################ FUNCION ID SESSION SUCURSALES #################################
public function SucursalesSessionPorId()
{
    $codUsuario  = limpiar($_SESSION["codigo"]);
    $codSucursal = limpiar($_SESSION["codsucursal"]);
    $sql = "SELECT
        suc.*,
        ciud.ciudad, com.comuna,
        doc.documento, doc2.documento AS documento2,
        tm.moneda, tm.siglas, tm.simbolo,
        tm2.moneda AS moneda2, tm2.siglas AS siglas2, tm2.simbolo AS simbolo2,
        valor_cambio.montocambio,
        usu.codigo, usu.dni, usu.nombres, usu.sexo, usu.direccion, usu.telefono,
        usu.email, usu.comision, usu.gruposid,
        pag.codcaja, pag.nrocaja, pag.nomcaja, pag.codigo
    FROM
        (usuarios usu LEFT JOIN sucursales suc ON usu.codsucursal = suc.codsucursal)
    LEFT JOIN
        documentos doc ON suc.documsucursal = doc.coddocumento
    LEFT JOIN
        documentos AS doc2 ON suc.documencargado = doc2.coddocumento
    LEFT JOIN
        ciudades ciud ON suc.id_ciudad = ciud.id_ciudad
    LEFT JOIN
        comunas com ON suc.id_comuna = com.id_comuna
    LEFT JOIN
        tiposmoneda tm ON suc.codmoneda = tm.codmoneda
    LEFT JOIN
        tiposmoneda tm2 ON suc.codmoneda2 = tm2.codmoneda

    LEFT JOIN
        (SELECT
            ca.codcaja, ca.nrocaja, ca.nomcaja, ca.codigo
        FROM
            cajas ca
        WHERE
            ca.codsucursal = :codSucursal1) pag ON pag.codigo = usu.codigo
    
    LEFT JOIN
       (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = suc.codmoneda2
    WHERE usu.codigo = :codUsuario AND usu.codsucursal = :codSucursal2";
    try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->bindParam(':codUsuario', $codUsuario);
        $stmt->bindParam(':codSucursal1', $codSucursal);
        $stmt->bindParam(':codSucursal2', $codSucursal);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if (!$row) {
            echo ""; // Es mejor manejar esto fuera de la función o devolver un valor
        } else {
            $this->p[] = $row;
            return $this->p;
            //return [$row]; // Devuelve un array con el resultado, manteniendo consistencia
        }
    } catch (PDOException $e) {
        error_log("Error en SucursalesSessionPorId: " . $e->getMessage());
        return [];
    }
}
############################ FUNCION ID SESSION SUCURSALES #################################

############################ FUNCION ACTUALIZAR SUCURSALES ############################
public function ActualizarSucursales()
{
	$this->p = [];
	if(empty($_POST["codsucursal"]) or empty($_POST["dniencargado"]) or empty($_POST["nomencargado"]) or empty($_POST["cuitsucursal"]) or empty($_POST["nomsucursal"]))
	{
		echo "1";
		exit;
	}
	//llamada de la funcion
	/*elseif (!valida_rut($_POST["cuitsucursal"]))
	{
		echo "2";
		exit;
	}
	//llamada de la funcion
	elseif (!valida_rut($_POST["dniencargado"]))
	{
		echo "3";
		exit;
	}*/
	$sql = " SELECT correosucursal FROM sucursales WHERE codsucursal != ? AND correosucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_POST["codsucursal"]),$_POST["correosucursal"]));
	$num = $stmt->rowCount();
	if($num > 0)
	{
		echo "4";
		exit;
	}
	$sql = " SELECT cuitsucursal, nomsucursal FROM sucursales WHERE codsucursal != ? AND cuitsucursal = ? AND nomsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_POST["codsucursal"]),$_POST["cuitsucursal"],$_POST["nomsucursal"]));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		############################ ACTUALIZACION DE SUCURSAL ############################
		$sql = " UPDATE sucursales SET"
		." documsucursal = ?, "
		." cuitsucursal = ?, "
		." nomsucursal = ?, "
	    ." codgiro = ?, "
	    ." girosucursal = ?, "
		." id_ciudad = ?, "
		." id_comuna = ?, "
		." direcsucursal = ?, "
		." correosucursal = ?, "
		." tlfsucursal = ?, "
		." inicioboleta = ?, "
		." iniciofactura = ?, "
		." inicioguia = ?, "
		." inicionotaventa = ?, "
		." inicionotacredito = ?, "
		." nroactividadsucursal = ?, "
		." fechaautorsucursal = ?, "
		." llevacontabilidad = ?, "
		." documencargado = ?, "
		." dniencargado = ?, "
		." nomencargado = ?, "
		." tlfencargado = ?, "
		." descsucursal = ?, "
		." porcentaje = ?, "
		." codmoneda = ?, "
		." codmoneda2 = ?, "
		." membrete = ?, "
		." mostrar_pos = ?, "
		." lioren_token = ? "
		." WHERE "
		." codsucursal = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $documsucursal);
		$stmt->bindParam(2, $cuitsucursal);
		$stmt->bindParam(3, $nomsucursal);
	    $stmt->bindParam(4, $codgiro);
	    $stmt->bindParam(5, $girosucursal);
		$stmt->bindParam(6, $id_ciudad);
		$stmt->bindParam(7, $id_comuna);
		$stmt->bindParam(8, $direcsucursal);
		$stmt->bindParam(9, $correosucursal);
		$stmt->bindParam(10, $tlfsucursal);
		$stmt->bindParam(11, $inicioboleta);
		$stmt->bindParam(12, $iniciofactura);
		$stmt->bindParam(13, $inicioguia);
		$stmt->bindParam(14, $inicionotaventa);
		$stmt->bindParam(15, $inicionotacredito);
		$stmt->bindParam(16, $nroactividadsucursal);
		$stmt->bindParam(17, $fechaautorsucursal);
		$stmt->bindParam(18, $llevacontabilidad);
		$stmt->bindParam(19, $documencargado);
		$stmt->bindParam(20, $dniencargado);
		$stmt->bindParam(21, $nomencargado);
		$stmt->bindParam(22, $tlfencargado);
		$stmt->bindParam(23, $descsucursal);
		$stmt->bindParam(24, $porcentaje);
		$stmt->bindParam(25, $codmoneda);
		$stmt->bindParam(26, $codmoneda2);
		$stmt->bindParam(27, $membrete);
		$stmt->bindParam(28, $mostrar_pos);
		$stmt->bindParam(29, $lioren_token);
		$stmt->bindParam(30, $codsucursal);

		$documsucursal        = limpiar($_POST['documsucursal'] == '' ? "0" : decrypt($_POST['documsucursal']));
		$cuitsucursal         = limpiar($_POST["cuitsucursal"]);
		$nomsucursal          = limpiar($_POST["nomsucursal"]);
	    $codgiro              = limpiar($_POST["codgiro"]);
	    $girosucursal         = limpiar($_POST["girosucursal"]);
		$id_ciudad            = limpiar($_POST['id_ciudad'] == '' ? "0" : $_POST['id_ciudad']);
		$id_comuna            = limpiar($_POST['id_comuna'] == '' ? "0" : $_POST['id_comuna']);
		$direcsucursal        = limpiar($_POST["direcsucursal"]);
		$correosucursal       = limpiar($_POST["correosucursal"]);
		$tlfsucursal          = limpiar($_POST["tlfsucursal"]);
		$nroactividadsucursal = limpiar($_POST["nroactividadsucursal"]);
		$inicioboleta         = limpiar($_POST["inicioboleta"]);
		$iniciofactura        = limpiar($_POST["iniciofactura"]);
		$inicioguia           = limpiar($_POST["inicioguia"]);
		$inicionotaventa      = limpiar($_POST["inicionotaventa"]);
		$inicionotacredito    = limpiar($_POST["inicionotacredito"]);
		$fechaautorsucursal   = limpiar($_POST['fechaautorsucursal'] == '' ? "0000-00-00" : date("Y-m-d",strtotime($_POST['fechaautorsucursal'])));
		$llevacontabilidad    = limpiar($_POST["llevacontabilidad"]);
		$documencargado       = limpiar($_POST['documencargado'] == '' ? "0" : decrypt($_POST['documencargado']));
		$dniencargado         = limpiar($_POST["dniencargado"]);
		$nomencargado         = limpiar($_POST["nomencargado"]);
		$tlfencargado         = limpiar($_POST["tlfencargado"]);
		$descsucursal         = limpiar($_POST["descsucursal"]);
		$porcentaje           = limpiar($_POST["porcentaje"]);
		$codmoneda            = limpiar(decrypt($_POST["codmoneda"]));
		$codmoneda2           = limpiar($_POST['codmoneda2'] == '' ? "0" : decrypt($_POST['codmoneda2']));
		$membrete             = limpiar($_POST["membrete"]);
		$mostrar_pos          = limpiar(isset($_POST['mostrar_pos']) ? $_POST['mostrar_pos'] : "");
		$lioren_token         = limpiar(isset($_POST['lioren_token']) ? $_POST['lioren_token'] : "");
		$codsucursal          = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();
		############################ ACTUALIZACION DE SUCURSAL ############################

		############################ SUBIR LOGO DE SUCURSAL ############################
	    //datos de carpetas
	    $dirmake_producto = limpiar(is_dir('fotos/productos/'.$codsucursal) ? "" : mkdir('fotos/productos/'.$codsucursal, 0777));//creo carpeta en productos
	    $dirmake_combo    = limpiar(is_dir('fotos/combos/'.$codsucursal) ? "" : mkdir('fotos/combos/'.$codsucursal, 0777));//creo carpeta en productos
	    $dirmake_sii      = limpiar(is_dir('sii/'.$codsucursal) ? "" : mkdir('sii/'.$codsucursal, 0777));//creo carpeta en sii

	    //datos del arhivo  
	    $nombre_archivo   = limpiar(isset($_FILES['imagen']['name']) ? $_FILES['imagen']['name'] : "");
		$tipo_archivo     = limpiar(isset($_FILES['imagen']['type']) ? $_FILES['imagen']['type'] : "");
		$tamano_archivo   = limpiar(isset($_FILES['imagen']['size']) ? $_FILES['imagen']['size'] : "");

	    //compruebo si las características del archivo son las que deseo  
        if (!empty($_FILES["imagen"]) && (strpos($tipo_archivo,'image/png')!==false)&&$tamano_archivo<2097152)// 2MB 
        {  
		   if (move_uploaded_file($_FILES['imagen']['tmp_name'], "fotos/sucursales/".$nombre_archivo) && rename("fotos/sucursales/".$nombre_archivo,"fotos/sucursales/".$_POST["cuitsucursal"].".png"))
		   { 
	       ## se puede dar un aviso
		   } 
	       ## se puede dar otro aviso 
	    }
	    ############################ SUBIR LOGO DE SUCURSAL ############################

		echo "<span class='fa fa-check-square-o'></span> LA SUCURSAL HA SIDO ACTUALIZADA EXITOSAMENTE";
		exit;
	}
	else
	{
		echo "5";
		exit;
	}
}
############################ FUNCION ACTUALIZAR SUCURSALES ############################

############################# FUNCION CAMBIAR STATUS SUCURSALES ################################
public function EstadoSucursales()
{
	$this->p = [];
	###################### ACTUALIZO STATUS DE SUCURSAL ######################
	$sql = "UPDATE sucursales SET"
	." estado = ? "
	." WHERE "
	." codsucursal = ?;
	";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $estado);
	$stmt->bindParam(2, $codsucursal);

	$estado = limpiar(decrypt($_GET['estado']) == 1 ? 0 : 1);
	$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
	$stmt->execute();
	###################### ACTUALIZO STATUS DE SUCURSAL ######################

	echo "1";
	exit;	
}
############################## FUNCION CAMBIAR STATUS SUCURSALES ##############################

########################## FUNCION ELIMINAR SUCURSALES ########################
public function EliminarSucursales()
{
   $this->p = [];
   if($_SESSION['acceso'] == "administradorG") {

	/*$sql = "SELECT codsucursal FROM productos WHERE codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{*/
		################### ELIMINO SUCURSAL ###################
		$sql = "DELETE FROM sucursales WHERE codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codsucursal);
		$codsucursal = decrypt($_GET["codsucursal"]);
		$stmt->execute();
		################### ELIMINO SUCURSAL ###################

		################### ELIMINO TRASPASOS ###################
		$sql = "DELETE FROM traspasos WHERE sucursal_envia = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codsucursal);
		$codsucursal = decrypt($_GET["codsucursal"]);
		$stmt->execute();
		################### ELIMINO TRASPASOS ###################

		################### ELIMINO CAJAS/APERTURAS ###################
		$sql = "DELETE cajas, arqueocaja, mediospagoxventas 
		FROM cajas 
		LEFT JOIN arqueocaja ON cajas.codcaja = arqueocaja.codcaja
		LEFT JOIN mediospagoxventas ON cajas.codcaja = mediospagoxventas.codcaja
	    WHERE cajas.codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codsucursal);
		$codsucursal = decrypt($_GET["codsucursal"]);
		$stmt->execute();
		################### ELIMINO CAJAS/APERTURAS ###################

		################### ELIMINO REGISTROS EN TABLAS ###################
		$tablas = ['abonoscreditoscompras','abonoscreditosventas','bancos','clientes','colores','combos','combosxproductos','compras',
		           'cotizaciones','creditosxclientes','despachos','detallecompras','detallecotizaciones','detalledespachos','detallenotas','detallepedidos',
		           'detallepreventas','detalletraspasos','detalleventas','familias','impuestos','kardex','marcas','mediospagos','modelos',
		           'movimientoscajas','notascredito','origenes','pedidos','presentaciones','preventas','productos','proveedores','subfamilias','tiposcambio',
		           'usuarios','ventas'];
		$this->dbh->beginTransaction();
		foreach($tablas as $tabla){

			$sql = "DELETE FROM $tabla WHERE codsucursal = ?";
			$stmt = $this->dbh->prepare($sql);
			$stmt->bindParam(1,$codsucursal);
			$codsucursal = decrypt($_GET["codsucursal"]);
			$stmt->execute();
		}
		$this->dbh->commit();
		################### ELIMINO REGISTROS EN TABLAS ###################

		echo "1";
		exit;

	/*} else {
		   
		echo "2";
		exit;
	}*/ 
			
	} else {
		
		echo "3";
		exit;
	}	
}
############################ FUNCION ELIMINAR SUCURSALES #######################

############################# FIN DE CLASE SUCURSALES ################################



















################################ CLASE FAMILIAS ######################################

############################# FUNCION REGISTRAR FAMILIAS ###############################
public function RegistrarFamilias()
{
	$this->p = [];
	if(empty($_POST["nomfamilia"]) or empty($_POST["codsucursal"]))
	{
		echo "1";
		exit;
	}
	$sql = " SELECT nomfamilia FROM familias WHERE nomfamilia = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["nomfamilia"],decrypt($_POST["codsucursal"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$query = " INSERT INTO familias values (null, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $nomfamilia);
		$stmt->bindParam(2, $codsucursal);

		$nomfamilia = limpiar($_POST["nomfamilia"]);
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();

		echo "<span class='fa fa-check-square-o'></span> LA FAMILIA HA SIDO REGISTRADA EXITOSAMENTE";
		exit;

	} else {

		echo "2";
		exit;
   }
}
########################### FUNCION REGISTRAR FAMILIAS ###############################

########################### FUNCION LISTAR FAMILIAS ################################
public function ListarFamilias() 
{
	$this->p = [];
	$tipoAcceso  = isset($_SESSION["acceso"]) ? limpiar($_SESSION["acceso"]) : '';
    $codSucursal = ($tipoAcceso === 'administradorG') ? limpiar(decrypt($_GET["codsucursal"])) : limpiar($_SESSION["codsucursal"]);
    // Preparamos los parámetros de forma segura para la consulta
    $whereConditions = [];
    $params          = [];

    $whereConditions[] = "fa.codsucursal = ?";
    $params[]          = $codSucursal;

    $whereClause = "";
    if (!empty($whereConditions)) {
      $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $sqlBase = "SELECT
    fa.*,
	suc.documsucursal, suc.cuitsucursal, suc.nomsucursal,
	suc.documencargado, suc.dniencargado, suc.nomencargado,
	doc.documento
	FROM familias fa
	LEFT JOIN sucursales suc ON fa.codsucursal = suc.codsucursal
	LEFT JOIN documentos doc ON suc.documencargado = doc.coddocumento";
    $sql = $sqlBase . $whereClause . " ORDER BY fa.nomfamilia ASC";
    try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($results)) {
            return [];
        } else {
            return $results;
        }
    } catch (PDOException $e) {
        error_log("Error en ListarFamilias: " . $e->getMessage());
        return [];
    }
}
############################ FUNCION LISTAR FAMILIAS ################################

############################ FUNCION ID FAMILIAS #################################
public function FamiliasPorId()
{
	$this->p = [];
	$sql = "SELECT * FROM familias WHERE codfamilia = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codfamilia"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
	}
}
############################ FUNCION ID FAMILIAS #################################

############################ FUNCION ACTUALIZAR FAMILIAS ############################
public function ActualizarFamilias()
{
	$this->p = [];
	if(empty($_POST["codfamilia"]) or empty($_POST["nomfamilia"]) or empty($_POST["codsucursal"]))
	{
		echo "1";
		exit;
	}
	$sql = " SELECT nomfamilia FROM familias WHERE codfamilia != ? AND nomfamilia = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_POST["codfamilia"]),$_POST["nomfamilia"],decrypt($_POST["codsucursal"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = " UPDATE familias set "
		." nomfamilia = ?, "
		." codsucursal = ? "
		." WHERE "
		." codfamilia = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $nomfamilia);
		$stmt->bindParam(2, $codsucursal);
		$stmt->bindParam(3, $codfamilia);

		$nomfamilia = limpiar($_POST["nomfamilia"]);
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$codfamilia = limpiar(decrypt($_POST["codfamilia"]));
		$stmt->execute();

		echo "<span class='fa fa-check-square-o'></span> LA FAMILIA HA SIDO ACTUALIZADA EXITOSAMENTE";
		exit;

	} else {

		echo "2";
		exit;
	}
}
############################ FUNCION ACTUALIZAR FAMILIAS ############################

########################### FUNCION ELIMINAR FAMILIAS #################################
public function EliminarFamilias()
{
	$this->p = [];
	if ($_SESSION['acceso'] == "administradorG" || $_SESSION["acceso"]=="administradorS") {

	$sql = "SELECT codfamilia FROM subfamilias WHERE codfamilia = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codfamilia"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = "DELETE FROM familias WHERE codfamilia = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codfamilia);
		$codfamilia = decrypt($_GET["codfamilia"]);
		$stmt->execute();

		echo "1";
		exit;

	} else {
		   
		echo "2";
		exit;
	} 
			
	} else {
		
		echo "3";
		exit;
	}	
}
########################## FUNCION ELIMINAR FAMILIAS #################################

############################# FIN DE CLASE FAMILIAS #################################


























################################# CLASE SUBFAMILIAS ####################################

########################### FUNCION REGISTRAR SUBFAMILIAS #########################
public function RegistrarSubfamilias()
{
	$this->p = [];
	if(empty($_POST["nomsubfamilia"]) or empty($_POST["codfamilia"]) or empty($_POST["codsucursal"]))
	{
		echo "1";
		exit;
	}
	$sql = " SELECT nomsubfamilia FROM subfamilias WHERE nomsubfamilia = ? AND codfamilia = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["nomsubfamilia"],decrypt($_POST["codfamilia"]),decrypt($_POST["codsucursal"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$query = " INSERT INTO subfamilias values (null, ?, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $nomsubfamilia);
		$stmt->bindParam(2, $codfamilia);
		$stmt->bindParam(3, $codsucursal);

		$nomsubfamilia = limpiar($_POST["nomsubfamilia"]);
		$codfamilia = limpiar(decrypt($_POST["codfamilia"]));
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();

	   echo "<span class='fa fa-check-square-o'></span> LA SUBFAMILIA HA SIDO REGISTRADA EXITOSAMENTE";
		exit;

	} else {

		echo "2";
		exit;
   }
}
########################## FUNCION REGISTRAR SUBFAMILIAS ###############################

######################### FUNCION LISTAR SUBFAMILIAS ################################
public function ListarSubfamilias() 
{
	$this->p = [];
	$tipoAcceso  = isset($_SESSION["acceso"]) ? limpiar($_SESSION["acceso"]) : '';
    $codSucursal = ($tipoAcceso === 'administradorG') ? limpiar(decrypt($_GET["codsucursal"])) : limpiar($_SESSION["codsucursal"]);
    // Preparamos los parámetros de forma segura para la consulta
    $whereConditions = [];
    $params          = [];

    $whereConditions[] = "subfa.codsucursal = ?";
    $params[]          = $codSucursal;

    $whereClause = "";
    if (!empty($whereConditions)) {
      $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $sqlBase = "SELECT
    subfa.*,
    fa.nomfamilia,
	suc.documsucursal, suc.cuitsucursal, suc.nomsucursal,
	suc.documencargado, suc.dniencargado, suc.nomencargado,
	doc.documento
	FROM subfamilias subfa 
	LEFT JOIN familias fa ON subfa.codfamilia = fa.codfamilia
	LEFT JOIN sucursales suc ON subfa.codsucursal = suc.codsucursal
	LEFT JOIN documentos doc ON suc.documencargado = doc.coddocumento";
    $sql = $sqlBase . $whereClause . " ORDER BY subfa.nomsubfamilia ASC";
    try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($results)) {
            return [];
        } else {
            return $results;
        }
    } catch (PDOException $e) {
        error_log("Error en ListarSubfamilias: " . $e->getMessage());
        return [];
    }
}
########################### FUNCION LISTAR SUBFAMILIAS ################################

####################### FUNCION LISTAR SUBFAMILIAS POR FAMILIAS ######################
public function ListarSubfamilias2() 
{
	$this->p = [];
	$sql = "SELECT * FROM subfamilias WHERE codfamilia = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codfamilia"])));
	$num = $stmt->rowCount();
	    if($num==0)
	{
		echo "<option value='' selected> -- SIN RESULTADOS -- </option>";
		exit;
	}
	else
	{
	    while($row = $stmt->fetch())
		{
			$this->p[]=$row;
		}
		return $this->p;
	}
}
####################### FUNCION LISTAR SUBFAMILIAS POR FAMILIAS #########################

########################## FUNCION PARA LISTAR SUBFAMILIAS DE FAMILIA ##########################
public function ListarSubfamiliasAsignados($codfamilia)
{
	$this->p = [];
	$sql = "SELECT * FROM subfamilias LEFT JOIN familias ON subfamilias.codfamilia = familias.codfamilia
	WHERE subfamilias.codfamilia = '".limpiar($codfamilia)."' ORDER BY subfamilias.nomsubfamilia ASC";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
}
######################### FUNCION PARA LISTAR SUBFAMILIAS DE FAMILIA ##########################

############################ FUNCION ID SUBFAMILIAS #################################
public function SubfamiliasPorId()
{
	$this->p = [];
	$sql = "SELECT * FROM subfamilias LEFT JOIN familias ON familias.codfamilia = subfamilias.codfamilia 
	WHERE subfamilias.codsubfamilia = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codsubfamilia"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
	}
}
############################ FUNCION ID SUBFAMILIAS #################################

############################ FUNCION ACTUALIZAR SUBFAMILIAS ############################
public function ActualizarSubfamilias()
{
	$this->p = [];
	if(empty($_POST["codsubfamilia"]) or empty($_POST["nomsubfamilia"]) or empty($_POST["codfamilia"]) or empty($_POST["codsucursal"]))
	{
		echo "1";
		exit;
	}
	$sql = "SELECT nomsubfamilia FROM subfamilias 
	WHERE codsubfamilia != ? AND nomsubfamilia = ? AND codfamilia = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_POST["codsubfamilia"]),$_POST["nomsubfamilia"],decrypt($_POST["codfamilia"]),decrypt($_POST["codsucursal"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = " UPDATE subfamilias set "
		." nomsubfamilia = ?, "
		." codfamilia = ?, "
		." codsucursal = ? "
		." WHERE "
		." codsubfamilia = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $nomsubfamilia);
		$stmt->bindParam(2, $codfamilia);
		$stmt->bindParam(3, $codsucursal);
		$stmt->bindParam(4, $codsubfamilia);

		$nomsubfamilia = limpiar($_POST["nomsubfamilia"]);
		$codfamilia = limpiar(decrypt($_POST["codfamilia"]));
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$codsubfamilia = limpiar(decrypt($_POST["codsubfamilia"]));
		$stmt->execute();

	   echo "<span class='fa fa-check-square-o'></span> LA SUBFAMILIA HA SIDO ACTUALIZADA EXITOSAMENTE";
		exit;

	} else {

		echo "2";
		exit;
	}
}
############################ FUNCION ACTUALIZAR SUBFAMILIAS ############################

############################ FUNCION ELIMINAR SUBFAMILIAS ##########################
public function EliminarSubfamilias()
{
	$this->p = [];
	if ($_SESSION['acceso'] == "administradorG" || $_SESSION["acceso"]=="administradorS") {

	$sql = "SELECT codsubfamilia FROM productos WHERE codsubfamilia = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codsubfamilia"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = "DELETE FROM subfamilias WHERE codsubfamilia = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codsubfamilia);
		$codsubfamilia = decrypt($_GET["codsubfamilia"]);
		$stmt->execute();

		echo "1";
		exit;

	} else {
		   
		echo "2";
		exit;
	} 
			
	} else {
		
		echo "3";
		exit;
	}	
}
############################ FUNCION ELIMINAR SUBFAMILIAS ##########################

############################## FIN DE CLASE SUBFAMILIAS ##############################













################################## CLASE MARCAS ######################################

############################ FUNCION REGISTRAR MARCAS ###############################
public function RegistrarMarcas()
{
	$this->p = [];
	if(empty($_POST["nommarca"]) or empty($_POST["codsucursal"]))
	{
		echo "1";
		exit;
	}
	$sql = " SELECT nommarca FROM marcas WHERE nommarca = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["nommarca"],decrypt($_POST["codsucursal"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$query = " INSERT INTO marcas values (null, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $nommarca);
		$stmt->bindParam(2, $codsucursal);

		$nommarca = limpiar($_POST["nommarca"]);
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();

		echo "<span class='fa fa-check-square-o'></span> LA MARCA HA SIDO REGISTRADA EXITOSAMENTE";
		exit;

	} else {

		echo "2";
		exit;
   }
}
############################ FUNCION REGISTRAR MARCAS ###############################

############################## FUNCION LISTAR MARCAS ################################
public function ListarMarcas() 
{
	$this->p = [];
	$tipoAcceso  = isset($_SESSION["acceso"]) ? limpiar($_SESSION["acceso"]) : '';
    $codSucursal = ($tipoAcceso === 'administradorG') ? limpiar(decrypt($_GET["codsucursal"])) : limpiar($_SESSION["codsucursal"]);
    // Preparamos los parámetros de forma segura para la consulta
    $whereConditions = [];
    $params          = [];

    $whereConditions[] = "ma.codsucursal = ?";
    $params[]          = $codSucursal;

    $whereClause = "";
    if (!empty($whereConditions)) {
      $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $sqlBase = "SELECT
    ma.*,
	suc.documsucursal, suc.cuitsucursal, suc.nomsucursal,
	suc.documencargado, suc.dniencargado, suc.nomencargado,
	doc.documento
	FROM marcas ma
	LEFT JOIN sucursales suc ON ma.codsucursal = suc.codsucursal
	LEFT JOIN documentos doc ON suc.documencargado = doc.coddocumento";
    $sql = $sqlBase . $whereClause . " ORDER BY ma.nommarca ASC";
    try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($results)) {
            return [];
        } else {
            return $results;
        }
    } catch (PDOException $e) {
        error_log("Error en ListarMarcas: " . $e->getMessage());
        return [];
    }
}
################################## FUNCION LISTAR MARCAS ################################

############################ FUNCION ID MARCAS #################################
public function MarcasPorId()
{
	$this->p = [];
	$sql = "SELECT * FROM marcas WHERE codmarca = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codmarca"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
	}
}
############################ FUNCION ID MARCAS #################################

############################ FUNCION ACTUALIZAR MARCAS ############################
public function ActualizarMarcas()
{
	$this->p = [];
	if(empty($_POST["codmarca"]) or empty($_POST["nommarca"]) or empty($_POST["codsucursal"]))
	{
		echo "1";
		exit;
	}
	$sql = " SELECT nommarca FROM marcas WHERE codmarca != ? AND nommarca = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_POST["codmarca"]),$_POST["nommarca"],decrypt($_POST["codsucursal"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = " UPDATE marcas set "
		." nommarca = ?, "
		." codsucursal = ? "
		." WHERE "
		." codmarca = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $nommarca);
		$stmt->bindParam(2, $codsucursal);
		$stmt->bindParam(3, $codmarca);

		$nommarca = limpiar($_POST["nommarca"]);
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$codmarca = limpiar(decrypt($_POST["codmarca"]));
		$stmt->execute();

		echo "<span class='fa fa-check-square-o'></span> LA MARCA HA SIDO ACTUALIZADA EXITOSAMENTE";
		exit;

	} else {

		echo "2";
		exit;
	}
}
############################ FUNCION ACTUALIZAR MARCAS ############################

########################### FUNCION ELIMINAR MARCAS #################################
public function EliminarMarcas()
{
	$this->p = [];
	if ($_SESSION['acceso'] == "administradorG" || $_SESSION["acceso"]=="administradorS") {

	$sql = "SELECT codmarca FROM modelos WHERE codmarca = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codmarca"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = "DELETE FROM marcas WHERE codmarca = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codmarca);
		$codmarca = decrypt($_GET["codmarca"]);
		$stmt->execute();

		echo "1";
		exit;

	} else {
		   
		echo "2";
		exit;
	} 
			
	} else {
		
		echo "3";
		exit;
	}	
}
########################### FUNCION ELIMINAR MARCAS #################################

############################## FIN DE CLASE MARCAS ###################################














################################# CLASE MODELOS ######################################

########################### FUNCION REGISTRAR MODELOS ###############################
public function RegistrarModelos()
{
	$this->p = [];
	if(empty($_POST["nommodelo"]) or empty($_POST["codmarca"]) or empty($_POST["codsucursal"]))
	{
		echo "1";
		exit;
	}
	$sql = " SELECT nommodelo FROM modelos WHERE nommodelo = ? AND codmarca = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["nommodelo"],decrypt($_POST["codmarca"]),decrypt($_POST["codsucursal"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$query = " INSERT INTO modelos values (null, ?, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $nommodelo);
		$stmt->bindParam(2, $codmarca);
		$stmt->bindParam(3, $codsucursal);

		$nommodelo = limpiar($_POST["nommodelo"]);
		$codmarca = limpiar(decrypt($_POST["codmarca"]));
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();

		echo "<span class='fa fa-check-square-o'></span> EL MODELO HA SIDO REGISTRADO EXITOSAMENTE";
		exit;

	} else {

		echo "2";
		exit;
	}
}
########################### FUNCION REGISTRAR MODELOS ###############################

############################ FUNCION LISTAR MODELOS ################################
public function ListarModelos() 
{
	$this->p = [];
	$tipoAcceso  = isset($_SESSION["acceso"]) ? limpiar($_SESSION["acceso"]) : '';
    $codSucursal = ($tipoAcceso === 'administradorG') ? limpiar(decrypt($_GET["codsucursal"])) : limpiar($_SESSION["codsucursal"]);
    // Preparamos los parámetros de forma segura para la consulta
    $whereConditions = [];
    $params          = [];

    $whereConditions[] = "mo.codsucursal = ?";
    $params[]          = $codSucursal;

    $whereClause = "";
    if (!empty($whereConditions)) {
      $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $sqlBase = "SELECT
    mo.*,
    ma.nommarca,
	suc.documsucursal, suc.cuitsucursal, suc.nomsucursal,
	suc.documencargado, suc.dniencargado, suc.nomencargado,
	doc.documento
	FROM modelos mo 
	LEFT JOIN marcas ma ON mo.codmarca = ma.codmarca
	LEFT JOIN sucursales suc ON mo.codsucursal = suc.codsucursal
	LEFT JOIN documentos doc ON suc.documencargado = doc.coddocumento";
    $sql = $sqlBase . $whereClause . " ORDER BY mo.nommodelo ASC";
    try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($results)) {
            return [];
        } else {
            return $results;
        }
    } catch (PDOException $e) {
        error_log("Error en ListarModelos: " . $e->getMessage());
        return [];
    }
}
############################## FUNCION LISTAR MODELOS ################################

########################## FUNCION PARA LISTAR MODELOS DE MARCA ##########################
public function ListarModelosAsignados($codmarca)
{
	$this->p = [];
	$sql = "SELECT * FROM modelos LEFT JOIN marcas ON modelos.codmarca = marcas.codmarca
	WHERE modelos.codmarca = '".limpiar($codmarca)."' ORDER BY modelos.nommodelo ASC";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
}
######################### FUNCION PARA LISTAR MODELOS DE MARCA ##########################

############################ FUNCION ID MODELOS #################################
public function ModelosPorId()
{
	$this->p = [];
	$sql = "SELECT * FROM modelos LEFT JOIN marcas ON marcas.codmarca = modelos.codmarca WHERE modelos.codmodelo = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codmodelo"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
	}
}
############################ FUNCION ID MODELOS #################################

############################ FUNCION ACTUALIZAR MODELOS ############################
public function ActualizarModelos()
{
	$this->p = [];
	if(empty($_POST["codmodelo"]) or empty($_POST["nommodelo"]) or empty($_POST["codmarca"]) or empty($_POST["codsucursal"]))
	{
		echo "1";
		exit;
	}

	$sql = "SELECT nommodelo FROM modelos WHERE codmodelo != ? AND nommodelo = ? AND codmarca = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_POST["codmodelo"]),$_POST["nommodelo"],decrypt($_POST["codmarca"]),decrypt($_POST["codsucursal"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = " UPDATE modelos set "
		." nommodelo = ?, "
		." codmarca = ?, "
		." codsucursal = ? "
		." WHERE "
		." codmodelo = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $nommodelo);
		$stmt->bindParam(2, $codmarca);
		$stmt->bindParam(3, $codsucursal);
		$stmt->bindParam(4, $codmodelo);

		$nommodelo = limpiar($_POST["nommodelo"]);
		$codmarca = limpiar(decrypt($_POST["codmarca"]));
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$codmodelo = limpiar(decrypt($_POST["codmodelo"]));
		$stmt->execute();

		echo "<span class='fa fa-check-square-o'></span> EL MODELO HA SIDO ACTUALIZADO EXITOSAMENTE";
		exit;

	} else {

		echo "2";
		exit;
	}
}
############################ FUNCION ACTUALIZAR MODELOS ############################

############################ FUNCION ELIMINAR MODELOS ############################
public function EliminarModelos()
{
	$this->p = [];
	if ($_SESSION['acceso'] == "administradorG" || $_SESSION["acceso"]=="administradorS") {

	$sql = "SELECT codmodelo FROM productos WHERE codmodelo = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codmodelo"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = "DELETE FROM modelos WHERE codmodelo = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codmodelo);
		$codmodelo = decrypt($_GET["codmodelo"]);
		$stmt->execute();

		echo "1";
		exit;

	} else {
		   
		echo "2";
		exit;
	} 
			
	} else {
		
		echo "3";
		exit;
	}	
}
############################ FUNCION ELIMINAR MODELOS ############################

########################## FUNCION LISTAR MODELOS POR MARCAS ##########################
public function ListarModelosxMarcas() 
{
	$this->p = [];
	$sql = "SELECT * FROM modelos WHERE codmarca = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codmarca"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
      echo "<option value='' selected> -- SIN RESULTADOS -- </option>";
		exit;
	}
	else
	{
	   while($row = $stmt->fetch())
		{
			$this->p[]=$row;
		}
		return $this->p;
	}
}
############################# FUNCION LISTAR MODELOS POR MARCAS #########################

########################## FUNCION LISTAR MODELOS #2 POR MARCAS ##########################
public function ListarModelos2xMarcas() 
{
	$this->p = [];
	$sql = "SELECT * FROM modelos WHERE codmarca = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codmarca2"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
      echo "<option value='' selected> -- SIN RESULTADOS -- </option>";
		exit;
	}
	else
	{
	   while($row = $stmt->fetch())
		{
			$this->p[]=$row;
		}
		return $this->p;
	}
}
############################# FUNCION LISTAR MODELOS #2 POR MARCAS #########################

############################## FIN DE CLASE MODELOS #################################















################################# CLASE PRESENTACIONES ################################

########################### FUNCION REGISTRAR PRESENTACIONES ##########################
public function RegistrarPresentaciones()
{
	$this->p = [];
	if(empty($_POST["nompresentacion"]) or empty($_POST["codsucursal"]))
	{
		echo "1";
		exit;
	}
	$sql = " SELECT nompresentacion FROM presentaciones WHERE nompresentacion = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["nompresentacion"],decrypt($_POST["codsucursal"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$query = " INSERT INTO presentaciones values (null, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $nompresentacion);
		$stmt->bindParam(2, $codsucursal);

		$nompresentacion = limpiar($_POST["nompresentacion"]);
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();

		echo "<span class='fa fa-check-square-o'></span> LA PRESENTACI&Oacute;N HA SIDO REGISTRADA EXITOSAMENTE";
		exit;

	} else {

		echo "2";
		exit;
   }
}
########################### FUNCION REGISTRAR PRESENTACIONES #########################

########################### FUNCION LISTAR PRESENTACIONES ############################
public function ListarPresentaciones() 
{
	$this->p = [];
	$tipoAcceso  = isset($_SESSION["acceso"]) ? limpiar($_SESSION["acceso"]) : '';
    $codSucursal = ($tipoAcceso === 'administradorG') ? limpiar(decrypt($_GET["codsucursal"])) : limpiar($_SESSION["codsucursal"]);
    // Preparamos los parámetros de forma segura para la consulta
    $whereConditions = [];
    $params          = [];

    $whereConditions[] = "pres.codsucursal = ?";
    $params[]          = $codSucursal;

    $whereClause = "";
    if (!empty($whereConditions)) {
      $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $sqlBase = "SELECT
    pres.*,
	suc.documsucursal, suc.cuitsucursal, suc.nomsucursal,
	suc.documencargado, suc.dniencargado, suc.nomencargado,
	doc.documento
	FROM presentaciones pres
	LEFT JOIN sucursales suc ON pres.codsucursal = suc.codsucursal
	LEFT JOIN documentos doc ON suc.documencargado = doc.coddocumento";
    $sql = $sqlBase . $whereClause . " ORDER BY pres.nompresentacion ASC";
    try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($results)) {
            return [];
        } else {
            return $results;
        }
    } catch (PDOException $e) {
        error_log("Error en ListarPresentaciones: " . $e->getMessage());
        return [];
    }
}
########################### FUNCION LISTAR PRESENTACIONES #########################

############################ FUNCION ID PRESENTACIONES #################################
public function PresentacionesPorId()
{
	$this->p = [];
	$sql = "SELECT * FROM presentaciones WHERE codpresentacion = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codpresentacion"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
	}
}
############################ FUNCION ID PRESENTACIONES #################################

######################### FUNCION ACTUALIZAR PRESENTACIONES #######################
public function ActualizarPresentaciones()
{
	$this->p = [];
	if(empty($_POST["codpresentacion"]) or empty($_POST["nompresentacion"]) or empty($_POST["codsucursal"]))
	{
		echo "1";
		exit;
	}
	$sql = " SELECT nompresentacion FROM presentaciones WHERE codpresentacion != ? AND nompresentacion = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_POST["codpresentacion"]),$_POST["nompresentacion"],decrypt($_POST["codsucursal"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = " UPDATE presentaciones set "
		." nompresentacion = ?, "
		." codsucursal = ? "
		." WHERE "
		." codpresentacion = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $nompresentacion);
		$stmt->bindParam(2, $codsucursal);
		$stmt->bindParam(3, $codpresentacion);

		$nompresentacion = limpiar($_POST["nompresentacion"]);
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$codpresentacion = limpiar(decrypt($_POST["codpresentacion"]));
		$stmt->execute();

		echo "<span class='fa fa-check-square-o'></span> LA PRESENTACI&Oacute;N HA SIDO ACTUALIZADA EXITOSAMENTE";
		exit;

	} else {

		echo "2";
		exit;
	}
}
######################## FUNCION ACTUALIZAR PRESENTACIONES #######################

########################### FUNCION ELIMINAR PRESENTACIONES ############################
public function EliminarPresentaciones()
{
	$this->p = [];
	if ($_SESSION['acceso'] == "administradorG" || $_SESSION["acceso"]=="administradorS") {

	$sql = "SELECT codpresentacion FROM productos WHERE codpresentacion = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codpresentacion"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = "DELETE FROM presentaciones WHERE codpresentacion = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codpresentacion);
		$codpresentacion = decrypt($_GET["codpresentacion"]);
		$stmt->execute();

		echo "1";
		exit;

	} else {
		   
		echo "2";
		exit;
	} 
			
	} else {
		
		echo "3";
		exit;
	}	
}
########################### FUNCION ELIMINAR PRESENTACIONES ###########################

########################### FIN DE CLASE PRESENTACIONES ###############################



















################################## CLASE COLORES ######################################

########################### FUNCION REGISTRAR COLORES ###############################
public function RegistrarColores()
{
	$this->p = [];
	if(empty($_POST["nomcolor"]) or empty($_POST["codsucursal"]))
	{
		echo "1";
		exit;
	}
	$sql = " SELECT nomcolor FROM colores WHERE nomcolor = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["nomcolor"],decrypt($_POST["codsucursal"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$query = " INSERT INTO colores values (null, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $nomcolor);
		$stmt->bindParam(2, $codsucursal);

		$nomcolor = limpiar($_POST["nomcolor"]);
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();

		echo "<span class='fa fa-check-square-o'></span> EL COLOR HA SIDO REGISTRADO EXITOSAMENTE";
		exit;

	} else {

		echo "2";
		exit;
	}
}
########################## FUNCION REGISTRAR COLORES ###############################

########################## FUNCION LISTAR COLORES ################################
public function ListarColores() 
{
	$this->p = [];
	$tipoAcceso  = isset($_SESSION["acceso"]) ? limpiar($_SESSION["acceso"]) : '';
    $codSucursal = ($tipoAcceso === 'administradorG') ? limpiar(decrypt($_GET["codsucursal"])) : limpiar($_SESSION["codsucursal"]);
    // Preparamos los parámetros de forma segura para la consulta
    $whereConditions = [];
    $params          = [];

    $whereConditions[] = "col.codsucursal = ?";
    $params[]          = $codSucursal;

    $whereClause = "";
    if (!empty($whereConditions)) {
      $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $sqlBase = "SELECT
    col.*,
	suc.documsucursal, suc.cuitsucursal, suc.nomsucursal,
	suc.documencargado, suc.dniencargado, suc.nomencargado,
	doc.documento
	FROM colores col
	LEFT JOIN sucursales suc ON col.codsucursal = suc.codsucursal
	LEFT JOIN documentos doc ON suc.documencargado = doc.coddocumento";
    $sql = $sqlBase . $whereClause . " ORDER BY col.nomcolor ASC";
    try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($results)) {
            return [];
        } else {
            return $results;
        }
    } catch (PDOException $e) {
        error_log("Error en ListarColores: " . $e->getMessage());
        return [];
    }
}
########################### FUNCION LISTAR COLORES ################################

############################ FUNCION ID COLORES #################################
public function ColoresPorId()
{
	$this->p = [];
	$sql = "SELECT * FROM colores WHERE codcolor = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codcolor"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
	}
}
############################ FUNCION ID COLORES #################################

############################ FUNCION ACTUALIZAR COLORES ############################
public function ActualizarColores()
{
	$this->p = [];
	if(empty($_POST["codcolor"]) or empty($_POST["nomcolor"]) or empty($_POST["codsucursal"]))
	{
		echo "1";
		exit;
	}
	$sql = " SELECT nomcolor FROM colores WHERE codcolor != ? AND nomcolor = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_POST["codcolor"]),$_POST["nomcolor"],decrypt($_POST["codsucursal"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = " UPDATE colores set "
		." nomcolor = ?, "
		." codsucursal = ? "
		." WHERE "
		." codcolor = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $nomcolor);
		$stmt->bindParam(2, $codsucursal);
		$stmt->bindParam(3, $codcolor);

		$nomcolor = limpiar($_POST["nomcolor"]);
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$codcolor = limpiar(decrypt($_POST["codcolor"]));
		$stmt->execute();

		echo "<span class='fa fa-check-square-o'></span> EL COLOR HA SIDO ACTUALIZADO EXITOSAMENTE";
		exit;

	} else {

		echo "2";
		exit;
	}
}
############################ FUNCION ACTUALIZAR COLORES ############################

########################### FUNCION ELIMINAR COLORES ###########################
public function EliminarColores()
{
	$this->p = [];
	if ($_SESSION['acceso'] == "administradorG" || $_SESSION["acceso"]=="administradorS") {

	$sql = "SELECT codcolor FROM productos WHERE codcolor = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codcolor"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = "DELETE FROM colores WHERE codcolor = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codcolor);
		$codcolor = decrypt($_GET["codcolor"]);
		$stmt->execute();

		echo "1";
		exit;

	} else {
		   
		echo "2";
		exit;
	} 
			
	} else {
		
		echo "3";
		exit;
	}	
}
########################### FUNCION ELIMINAR COLORES #################################

############################ FIN DE CLASE COLORES ##################################


























################################### CLASE ORIGENES ####################################

########################## FUNCION REGISTRAR ORIGENES ###############################
public function RegistrarOrigenes()
{
	$this->p = [];
	if(empty($_POST["nomorigen"]) or empty($_POST["codsucursal"]))
	{
		echo "1";
		exit;
	}
	$sql = " SELECT nomorigen FROM origenes WHERE nomorigen = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["nomorigen"],decrypt($_POST["codsucursal"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$query = " INSERT INTO origenes values (null, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $nomorigen);
		$stmt->bindParam(2, $codsucursal);

		$nomorigen = limpiar($_POST["nomorigen"]);
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();

		echo "<span class='fa fa-check-square-o'></span> EL ORIGEN HA SIDO REGISTRADO EXITOSAMENTE";
		exit;

	} else {

		echo "2";
		exit;
	}
}
############################# FUNCION REGISTRAR ORIGENES ###############################

############################ FUNCION LISTAR ORIGENES ################################
public function ListarOrigenes() 
{
	$this->p = [];
	$tipoAcceso  = isset($_SESSION["acceso"]) ? limpiar($_SESSION["acceso"]) : '';
    $codSucursal = ($tipoAcceso === 'administradorG') ? limpiar(decrypt($_GET["codsucursal"])) : limpiar($_SESSION["codsucursal"]);
    // Preparamos los parámetros de forma segura para la consulta
    $whereConditions = [];
    $params          = [];

    $whereConditions[] = "orig.codsucursal = ?";
    $params[]          = $codSucursal;

    $whereClause = "";
    if (!empty($whereConditions)) {
      $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $sqlBase = "SELECT
    orig.*,
	suc.documsucursal, suc.cuitsucursal, suc.nomsucursal,
	suc.documencargado, suc.dniencargado, suc.nomencargado,
	doc.documento
	FROM origenes orig
	LEFT JOIN sucursales suc ON orig.codsucursal = suc.codsucursal
	LEFT JOIN documentos doc ON suc.documencargado = doc.coddocumento";
    $sql = $sqlBase . $whereClause . " ORDER BY orig.nomorigen ASC";
    try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($results)) {
            return [];
        } else {
            return $results;
        }
    } catch (PDOException $e) {
        error_log("Error en ListarOrigenes: " . $e->getMessage());
        return [];
    }
}
############################ FUNCION LISTAR ORIGENES ################################

############################ FUNCION ID ORIGENES #################################
public function OrigenesPorId()
{
	$this->p = [];
	$sql = "SELECT * FROM origenes WHERE codorigen = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codorigen"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
	}
}
############################ FUNCION ID ORIGENES #################################

############################ FUNCION ACTUALIZAR ORIGENES ############################
public function ActualizarOrigenes()
{
	$this->p = [];
	if(empty($_POST["codorigen"]) or empty($_POST["nomorigen"]) or empty($_POST["codsucursal"]))
	{
		echo "1";
		exit;
	}
	$sql = " SELECT nomorigen FROM origenes WHERE codorigen != ? AND nomorigen = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_POST["codorigen"]),$_POST["nomorigen"],decrypt($_POST["codsucursal"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = " UPDATE origenes set "
		." nomorigen = ?, "
		." codsucursal = ? "
		." WHERE "
		." codorigen = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $nomorigen);
		$stmt->bindParam(2, $codsucursal);
		$stmt->bindParam(3, $codorigen);

		$nomorigen = limpiar($_POST["nomorigen"]);
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$codorigen = limpiar(decrypt($_POST["codorigen"]));
		$stmt->execute();

		echo "<span class='fa fa-check-square-o'></span> EL ORIGEN HA SIDO ACTUALIZADO EXITOSAMENTE";
		exit;

	} else {

		echo "2";
		exit;
	}
}
############################ FUNCION ACTUALIZAR ORIGENES ############################

########################### FUNCION ELIMINAR ORIGENES ##############################
public function EliminarOrigenes()
{
	$this->p = [];
	if ($_SESSION['acceso'] == "administradorG" || $_SESSION["acceso"]=="administradorS") {

	$sql = "SELECT codorigen FROM productos WHERE codorigen = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codorigen"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = "DELETE FROM origenes WHERE codorigen = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codorigen);
		$codorigen = decrypt($_GET["codorigen"]);
		$stmt->execute();

		echo "1";
		exit;

	} else {
		   
		echo "2";
		exit;
	} 
			
	} else {
		
		echo "3";
		exit;
	}	
}
########################### FUNCION ELIMINAR ORIGENES #################################

############################ FIN DE CLASE ORIGENES #################################




















################################## CLASE CLIENTES ##################################

############################### FUNCION CARGAR CLIENTES ##############################
public function CargarClientes()
{
	$this->p = [];
	if(empty($_FILES["sel_file"]) or empty($_POST["codsucursal"]))
	{
		echo "1";
		exit;
	}
    //Aquí es donde seleccionamos nuestro csv
    $fname = $_FILES['sel_file']['name'];
    //echo 'Cargando nombre del archivo: '.$fname.' ';
    $chk_ext = explode(".",$fname);
     
    if(strtolower(end($chk_ext)) == "csv"){

    //si es correcto, entonces damos permisos de lectura para subir
    $filename = $_FILES['sel_file']['tmp_name'];
    $handle = fopen($filename, "r");
    $this->dbh->beginTransaction();
    
    $primera = true;
    while (($data = fgetcsv($handle, 1000, ";")) !== FALSE) {
    // Evitamos la primer línea
    if ($primera){
      $primera = false;
      continue;
    }
	    ############## CREO CODIGO DE CLIENTE #################
		$sql = "SELECT codcliente
		FROM clientes
		ORDER BY idcliente DESC LIMIT 1";
		foreach ($this->dbh->query($sql) as $row){

			$cliente = $row["codcliente"];
		}
		$codcliente = limpiar(empty($cliente) ? "1" : $cliente+1);
		############## CREO CODIGO DE CLIENTE #################

	   //Insertamos los datos con los valores...  
		$query = "INSERT INTO clientes values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codcliente);
		$stmt->bindParam(2, $tipocliente);
		$stmt->bindParam(3, $documcliente);
		$stmt->bindParam(4, $dnicliente);
		$stmt->bindParam(5, $nomcliente);
		$stmt->bindParam(6, $razoncliente);
		$stmt->bindParam(7, $girocliente);
		$stmt->bindParam(8, $tlfcliente);
		$stmt->bindParam(9, $id_ciudad);
		$stmt->bindParam(10, $id_comuna);
		$stmt->bindParam(11, $direccliente);
		$stmt->bindParam(12, $emailcliente);
		$stmt->bindParam(13, $limitecredito);
		$stmt->bindParam(14, $fechaingreso);
		$stmt->bindParam(15, $codsucursal);

		$tipocliente = limpiar($data[0]);
		$documcliente = limpiar($data[1]);
		$dnicliente = limpiar($data[2]);
		$nomcliente = utf8_encode($data[3]);
		$razoncliente = utf8_encode($data[4]);
		$girocliente = utf8_encode($data[5]);
		$tlfcliente = limpiar($data[6]);
		$id_ciudad = limpiar($data[7]);
		$id_comuna = limpiar($data[8]);
		$direccliente = utf8_encode($data[9]);
		$emailcliente = limpiar($data[10]);
		$limitecredito = limpiar($data[11]);
		$fechaingreso = limpiar(date("Y-m-d"));
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();

		$codcliente++;
   }
   $this->dbh->commit();
   //cerramos la lectura del archivo "abrir archivo" con un "cerrar archivo"
   fclose($handle);
	        
	   echo "<span class='fa fa-check-square-o'></span> LA CARGA MASIVA DE CLIENTES FUE REALIZADA EXITOSAMENTE";
	   exit;
             
   } else {
   //si aparece esto es posible que el archivo no tenga el formato adecuado, inclusive cuando es cvs, revisarlo para ver si esta separado por " , "
      echo "2";
		exit;
   }  
}
################################# FUNCION CARGAR CLIENTES ###############################

############################ FUNCION REGISTRAR CLIENTES ###############################
public function RegistrarClientes()
{
	$this->p = [];
	if(empty($_POST["tipocliente"]) or empty($_POST["dnicliente"]) or empty($_POST["direccliente"]) or empty($_POST["codsucursal"]))
	{
		echo "1";
		exit;
	}
	//llamada de la funcion
	/*elseif (!valida_rut($_POST["dnicliente"]))
	{
		echo "2";
		exit;
	}*/

	############## CREO CODIGO DE CLIENTE #################
	$sql = "SELECT codcliente
	FROM clientes
	ORDER BY idcliente DESC LIMIT 1";
	foreach ($this->dbh->query($sql) as $row){

		$cliente = $row["codcliente"];
	}
	$codcliente = limpiar(empty($cliente) ? "1" : $cliente + 1);
	############## CREO CODIGO DE CLIENTE #################

	$sql = "SELECT dnicliente FROM clientes WHERE dnicliente = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["dnicliente"],decrypt($_POST["codsucursal"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$query = "INSERT INTO clientes values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codcliente);
		$stmt->bindParam(2, $tipocliente);
		$stmt->bindParam(3, $documcliente);
		$stmt->bindParam(4, $dnicliente);
		$stmt->bindParam(5, $nomcliente);
		$stmt->bindParam(6, $razoncliente);
		$stmt->bindParam(7, $girocliente);
		$stmt->bindParam(8, $tlfcliente);
		$stmt->bindParam(9, $id_ciudad);
		$stmt->bindParam(10, $id_comuna);
		$stmt->bindParam(11, $direccliente);
		$stmt->bindParam(12, $emailcliente);
		$stmt->bindParam(13, $limitecredito);
		$stmt->bindParam(14, $fechaingreso);
		$stmt->bindParam(15, $codsucursal);
		
		$tipocliente = limpiar($_POST["tipocliente"]);
		$documcliente = limpiar($_POST['documcliente'] == '' ? "0" : $_POST['documcliente']);
		$dnicliente = limpiar($_POST["dnicliente"]);
		$nomcliente = limpiar($_POST['tipocliente'] == 'JURIDICO' ? "" : $_POST["nomcliente"]);
		$razoncliente = limpiar($_POST['tipocliente'] == 'NATURAL' ? "" : $_POST["razoncliente"]);
		$girocliente = limpiar($_POST['tipocliente'] == 'NATURAL' ? "" : $_POST["girocliente"]);
		$tlfcliente = limpiar($_POST["tlfcliente"]);
		$id_ciudad = limpiar($_POST['id_ciudad'] == '' ? "0" : $_POST['id_ciudad']);
		$id_comuna = limpiar($_POST['id_comuna'] == '' ? "0" : $_POST['id_comuna']);
		$direccliente = limpiar($_POST["direccliente"]);
		$emailcliente = limpiar($_POST["emailcliente"]);
		$limitecredito = limpiar($_POST["limitecredito"]);
	    $fechaingreso = limpiar(date("Y-m-d"));
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();

		echo "<span class='fa fa-check-square-o'></span> EL CLIENTE HA SIDO REGISTRADO EXITOSAMENTE";
		exit;

	} else {

		echo "3";
		exit;
	}
}
######################## FUNCION REGISTRAR CLIENTES ###############################

########################## FUNCION BUSQUEDA DE CLIENTES ###############################
public function BusquedaClientes() 
{
	$this->p = [];
	$this->p = [];
	$tipoAcceso      = isset($_SESSION["acceso"]) ? limpiar($_SESSION["acceso"]) : '';
    $codSucursal     = ($tipoAcceso === 'administradorG') ? limpiar(decrypt($_GET["codsucursal"])) : limpiar($_SESSION["codsucursal"]);
    $tipoBusqueda    = isset($_GET['tipobusqueda']) ? limpiar($_GET['tipobusqueda']) : '';
    $searchCriterio  = isset($_GET['search_criterio']) ? limpiar($_GET['search_criterio']) : '';
    
    // Preparamos los parámetros de forma segura para la consulta
    $whereConditions = [];
    $params          = [];

    // Lógica de filtro basada en el tipo de acceso
    $whereConditions[] = "cl.codsucursal = ?";
    $params[]          = $codSucursal;

    // Lógica de filtro basada en el tipo de búsqueda (tipobusqueda)
    if ($tipoBusqueda == 2) {//Busqueda por Criterio
      $whereConditions[] = "CONCAT(cl.dnicliente, ' ',cl.nomcliente, '',IFNULL(cl.razoncliente,'0'), '',IFNULL(cl.girocliente,'0'), '',cl.direccliente, '',IFNULL(cl.emailcliente,'0')) LIKE ?";
        $params[] = '%' . $searchCriterio . '%';
    }
    $whereClause = "";
    if (!empty($whereConditions)) {
      $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $sqlBase = "SELECT
    cl.codcliente, cl.tipocliente, cl.documcliente, cl.dnicliente, cl.nomcliente,
	cl.razoncliente, cl.girocliente, cl.tlfcliente, cl.id_ciudad, cl.id_comuna,
	cl.direccliente, cl.emailcliente, cl.limitecredito, cl.codsucursal, cl.fechaingreso,
	ciud.ciudad, com.comuna,
	suc.documsucursal, suc.cuitsucursal, suc.nomsucursal,
	suc.documencargado, suc.dniencargado, suc.nomencargado,
	doc.documento, doc2.documento AS documento2
	FROM clientes cl
	LEFT JOIN documentos doc ON cl.documcliente = doc.coddocumento
	LEFT JOIN ciudades ciud ON cl.id_ciudad = ciud.id_ciudad 
	LEFT JOIN comunas com ON cl.id_comuna = com.id_comuna
	LEFT JOIN sucursales suc ON cl.codsucursal = suc.codsucursal
	LEFT JOIN documentos AS doc2 ON suc.documencargado = doc2.coddocumento";
    $sql = $sqlBase . $whereClause . " ORDER BY cl.nomcliente, cl.razoncliente ASC";
    if ($tipoBusqueda == 2 || $tipoBusqueda == 3) {
        $sql .= " LIMIT 0,3000";
    }
    try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($results)) {
            return [];
        } else {
            return $results;
        }
    } catch (PDOException $e) {
        error_log("Error en BusquedaClientes: " . $e->getMessage());
        echo "<div class='alert alert-danger'>";
        echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
        echo "<center><span class='fa fa-exclamation-triangle'></span> OCURRIÓ UN ERROR AL PROCESAR LA BÚSQUEDA. POR FAVOR, INTENTALO MAS TARDE.</center>";
        echo "</div>";
        return [];
    }
}
########################## FUNCION BUSQUEDA DE CLIENTES ###############################

############################ FUNCION LISTAR CLIENTES ################################
public function ListarClientes() 
{
	$this->p = [];
	$tipoAcceso  = isset($_SESSION["acceso"]) ? limpiar($_SESSION["acceso"]) : '';
    $codSucursal = ($tipoAcceso === 'administradorG') ? limpiar(decrypt($_GET["codsucursal"])) : limpiar($_SESSION["codsucursal"]);
    $whereConditions   = [];
    $params            = [];

    $whereConditions[] = "cl.codsucursal = ?";
    $params[]          = $codSucursal;

    $whereClause = "";
    if (!empty($whereConditions)) {
      $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $sqlBase = "SELECT
    cl.codcliente, cl.tipocliente, cl.documcliente, cl.dnicliente, cl.nomcliente,
	cl.razoncliente, cl.girocliente, cl.tlfcliente, cl.id_ciudad, cl.id_comuna,
	cl.direccliente, cl.emailcliente, cl.limitecredito, cl.codsucursal, cl.fechaingreso,
	ciud.ciudad, com.comuna,
	suc.documsucursal, suc.cuitsucursal, suc.nomsucursal,
	suc.documencargado, suc.dniencargado, suc.nomencargado,
	doc.documento, doc2.documento AS documento2
	FROM clientes cl
	LEFT JOIN documentos doc ON cl.documcliente = doc.coddocumento
	LEFT JOIN ciudades ciud ON cl.id_ciudad = ciud.id_ciudad 
	LEFT JOIN comunas com ON cl.id_comuna = com.id_comuna
	LEFT JOIN sucursales suc ON cl.codsucursal = suc.codsucursal
	LEFT JOIN documentos AS doc2 ON suc.documencargado = doc2.coddocumento";
    $sql = $sqlBase . $whereClause . " ORDER BY cl.nomcliente, cl.razoncliente ASC";
    try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($results)) {
            return [];
        } else {
            return $results;
        }
    } catch (PDOException $e) {
        error_log("Error en ListarClientes: " . $e->getMessage());
        return [];
    }
}
######################### FUNCION LISTAR CLIENTES ################################

############################ FUNCION LISTAR CLIENTES ################################
public function ListarClientesxCreditosActivos()
{
    $this->p = [];
    $tipoAcceso  = isset($_SESSION["acceso"]) ? limpiar($_SESSION["acceso"]) : '';
    $codSucursal = ($tipoAcceso === 'administradorG') ? limpiar(decrypt($_GET["codsucursal"])) : limpiar($_SESSION["codsucursal"]);
    // Obtener la fecha actual para la validación de créditos vencidos
    $fechaActual = date("Y-m-d");
    // Preparamos los parámetros de forma segura para la consulta
    $params      = [$codSucursal, $codSucursal, $fechaActual];

    $sql = "SELECT
        cl.codcliente, cl.tipocliente, cl.documcliente, cl.dnicliente,
        CONCAT(IF(cl.tipocliente='NATURAL', cl.nomcliente, cl.razoncliente)) AS nomcliente,
        cl.girocliente, cl.tlfcliente, cl.id_ciudad, cl.id_comuna, cl.direccliente,
        cl.emailcliente, cl.limitecredito, cl.codsucursal, cl.fechaingreso,
        ciud.ciudad, com.comuna,
        suc.documsucursal, suc.cuitsucursal, suc.nomsucursal,
        suc.documencargado, suc.dniencargado, suc.nomencargado,
        doc.documento, doc2.documento AS documento2,
        tm.moneda, tm.siglas, tm.simbolo,
        SUM(v.totalpago - v.creditopagado) AS TotalCredito,
        pag.CreditoVencido
    FROM clientes cl
    LEFT JOIN ventas v ON cl.codcliente = v.codcliente AND v.codsucursal = ? AND v.tipopago = 'CREDITO' AND v.statusventa = 'PENDIENTE'
    LEFT JOIN documentos doc ON cl.documcliente = doc.coddocumento
    LEFT JOIN ciudades ciud ON cl.id_ciudad = ciud.id_ciudad 
	LEFT JOIN comunas com ON cl.id_comuna = com.id_comuna
    LEFT JOIN sucursales suc ON cl.codsucursal = suc.codsucursal
    LEFT JOIN documentos AS doc2 ON suc.documencargado = doc2.coddocumento
    LEFT JOIN tiposmoneda tm ON suc.codmoneda = tm.codmoneda

    LEFT JOIN (
        SELECT 
            codcliente,
            SUM(totalpago - creditopagado) AS CreditoVencido
        FROM ventas 
        WHERE 
            codsucursal = ?
            AND DATE_FORMAT(fechavencecredito, '%Y-%m-%d') < ?
            AND tipopago = 'CREDITO' 
            AND statusventa = 'PENDIENTE'
        GROUP BY codcliente
    ) pag ON pag.codcliente = cl.codcliente
    
    GROUP BY
        cl.codcliente, cl.tipocliente, cl.documcliente, cl.dnicliente,
        cl.tipocliente, cl.nomcliente, cl.razoncliente, cl.girocliente,
        cl.tlfcliente, cl.id_ciudad, cl.id_comuna, cl.direccliente,
        cl.emailcliente, cl.limitecredito, cl.codsucursal, cl.fechaingreso,
        ciud.ciudad, com.comuna,
        suc.documsucursal, suc.cuitsucursal, suc.nomsucursal,
        suc.documencargado, suc.dniencargado, suc.nomencargado,
        doc.documento, doc2.documento,
        tm.moneda, tm.siglas, tm.simbolo,
        pag.CreditoVencido
    HAVING SUM(v.totalpago - v.creditopagado) > 0
    ORDER BY cl.nomcliente, cl.razoncliente ASC";
    try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        return $results ? : [];
    } catch (PDOException $e) {
        error_log("Error en ListarClientesxCreditosActivos: " . $e->getMessage());
        return [];
    }
}
######################### FUNCION LISTAR CLIENTES ################################

######################### FUNCION ID CLIENTES #################################
public function ClientesPorId()
{
	$this->p = [];
	$sql = "SELECT
	cl.codcliente, cl.tipocliente, cl.documcliente, cl.dnicliente,
	CONCAT(if(cl.tipocliente='NATURAL',cl.nomcliente,cl.razoncliente)) as nomcliente,
	cl.girocliente, cl.tlfcliente, cl.id_ciudad, cl.id_comuna, cl.direccliente,
	cl.emailcliente, cl.limitecredito, cl.fechaingreso,
	ciud.ciudad, com.comuna,
	suc.documsucursal, suc.cuitsucursal, suc.nomsucursal,
	suc.documencargado, suc.dniencargado, suc.nomencargado,
	doc.documento, doc2.documento AS documento2,
	IFNULL(v.codcliente,'0.00') AS cantidad,
	IFNULL(v.totalpago,'0.00') AS totalcompras
	FROM clientes cl
	LEFT JOIN ventas v ON cl.codcliente = v.codcliente
	LEFT JOIN documentos doc ON cl.documcliente = doc.coddocumento
	LEFT JOIN ciudades ciud ON cl.id_ciudad = ciud.id_ciudad 
	LEFT JOIN comunas com ON cl.id_comuna = com.id_comuna
	LEFT JOIN sucursales suc ON cl.codsucursal = suc.codsucursal
	LEFT JOIN documentos AS doc2 ON suc.documencargado = doc2.coddocumento
	WHERE cl.codcliente = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codcliente"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
	}
}
############################ FUNCION ID CLIENTES #################################
	
############################ FUNCION ACTUALIZAR CLIENTES ############################
public function ActualizarClientes()
{
	$this->p = [];
	if(empty($_POST["codcliente"]) or empty($_POST["tipocliente"]) or empty($_POST["dnicliente"]) or empty($_POST["direccliente"]) or empty($_POST["codsucursal"]))
	{
		echo "1";
		exit;
	}
	//llamada de la funcion
	/*elseif (!valida_rut($_POST["dnicliente"]))
	{
		echo "2";
		exit;
	}*/
	$sql = " SELECT dnicliente FROM clientes WHERE codcliente != ? AND dnicliente = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_POST["codcliente"]),$_POST["dnicliente"],decrypt($_POST["codsucursal"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = "UPDATE clientes set "
		." tipocliente = ?, "
		." documcliente = ?, "
		." dnicliente = ?, "
		." nomcliente = ?, "
		." razoncliente = ?, "
		." girocliente = ?, "
		." tlfcliente = ?, "
		." id_ciudad = ?, "
		." id_comuna = ?, "
		." direccliente = ?, "
		." emailcliente = ?, "
		." limitecredito = ?, "
		." codsucursal = ? "
		." WHERE "
		." codcliente = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $tipocliente);
	   $stmt->bindParam(2, $documcliente);
		$stmt->bindParam(3, $dnicliente);
		$stmt->bindParam(4, $nomcliente);
		$stmt->bindParam(5, $razoncliente);
		$stmt->bindParam(6, $girocliente);
		$stmt->bindParam(7, $tlfcliente);
		$stmt->bindParam(8, $id_ciudad);
		$stmt->bindParam(9, $id_comuna);
		$stmt->bindParam(10, $direccliente);
		$stmt->bindParam(11, $emailcliente);
		$stmt->bindParam(12, $limitecredito);
		$stmt->bindParam(13, $codsucursal);
		$stmt->bindParam(14, $codcliente);
		
		$documcliente = limpiar($_POST['documcliente'] == '' ? "0" : $_POST['documcliente']);
		$dnicliente = limpiar($_POST["dnicliente"]);
		$nomcliente = limpiar($_POST['tipocliente'] == 'JURIDICO' ? "" : $_POST["nomcliente"]);
		$razoncliente = limpiar($_POST['tipocliente'] == 'NATURAL' ? "" : $_POST["razoncliente"]);
		$girocliente = limpiar($_POST['tipocliente'] == 'NATURAL' ? "" : $_POST["girocliente"]);
		$tlfcliente = limpiar($_POST["tlfcliente"]);
		$id_ciudad = limpiar($_POST['id_ciudad'] == '' ? "0" : $_POST['id_ciudad']);
		$id_comuna = limpiar($_POST['id_comuna'] == '' ? "0" : $_POST['id_comuna']);
		$direccliente = limpiar($_POST["direccliente"]);
		$emailcliente = limpiar($_POST["emailcliente"]);
		$tipocliente = limpiar($_POST["tipocliente"]);
		$limitecredito = limpiar($_POST["limitecredito"]);
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$codcliente = limpiar(decrypt($_POST["codcliente"]));
		$stmt->execute();
    
	echo "<span class='fa fa-check-square-o'></span> EL CLIENTE HA SIDO ACTUALIZADO EXITOSAMENTE";
	exit;

	} else {

		echo "2";
		exit;
	}
}
############################ FUNCION ACTUALIZAR CLIENTES ############################

########################### FUNCION ELIMINAR CLIENTES #################################
public function EliminarClientes()
	{
	$this->p = [];
	if ($_SESSION['acceso'] == "administradorG" || $_SESSION["acceso"]=="administradorS") {

	$sql = "SELECT codcliente, codsucursal FROM ventas WHERE codcliente = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codcliente"]),decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = "DELETE FROM clientes WHERE codcliente = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codcliente);
		$stmt->bindParam(2,$codsucursal);
		$codcliente = decrypt($_GET["codcliente"]);
		$codsucursal = decrypt($_GET["codsucursal"]);
		$stmt->execute();

		echo "1";
		exit;

	} else {
		   
		echo "2";
		exit;
	} 
			
	} else {
		
		echo "3";
		exit;
	}	
}
########################## FUNCION ELIMINAR CLIENTES #################################

############################## FIN DE CLASE CLIENTES #################################


























################################## CLASE PROVEEDORES ###################################

########################## FUNCION CARGAR PROVEEDORES ###############################
public function CargarProveedores()
{
	$this->p = [];
	if(empty($_FILES["sel_file"]) or empty($_POST["codsucursal"]))
	{
		echo "1";
		exit;
	}
    //Aquí es donde seleccionamos nuestro csv
    $fname = $_FILES['sel_file']['name'];
    //echo 'Cargando nombre del archivo: '.$fname.' ';
    $chk_ext = explode(".",$fname);
     
    if(strtolower(end($chk_ext)) == "csv"){

    //si es correcto, entonces damos permisos de lectura para subir
    $filename = $_FILES['sel_file']['tmp_name'];
    $handle = fopen($filename, "r");
    $this->dbh->beginTransaction();
    
    $primera = true;
    while (($data = fgetcsv($handle, 1000, ";")) !== FALSE) {
    // Evitamos la primer línea
    if ($primera){
      $primera = false;
      continue;
    }
	    ############## CREO CODIGO DE PROVEEDOR #################
		$sql = "SELECT codproveedor
		FROM proveedores
		ORDER BY idproveedor DESC LIMIT 1";
		foreach ($this->dbh->query($sql) as $row){

			$proveedor = $row["codproveedor"];
		}
		$codproveedor = limpiar(empty($proveedor) ? "1" : $proveedor+1);
		############## CREO CODIGO DE PROVEEDOR #################

        //Insertamos los datos con los valores...   
		$query = "INSERT INTO proveedores values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codproveedor);
		$stmt->bindParam(2, $documproveedor);
		$stmt->bindParam(3, $dniproveedor);
		$stmt->bindParam(4, $nomproveedor);
		$stmt->bindParam(5, $tlfproveedor);
		$stmt->bindParam(6, $id_ciudad);
		$stmt->bindParam(7, $id_comuna);
		$stmt->bindParam(8, $direcproveedor);
		$stmt->bindParam(9, $emailproveedor);
		$stmt->bindParam(10, $vendedor);
		$stmt->bindParam(11, $tlfvendedor);
		$stmt->bindParam(12, $fechaingreso);
		$stmt->bindParam(13, $codsucursal);

		$documproveedor = limpiar($data[0]);
		$dniproveedor = limpiar($data[1]);
		$nomproveedor = utf8_encode($data[2]);
		$tlfproveedor = limpiar($data[3]);
		$id_ciudad = limpiar($data[4]);
		$id_comuna = limpiar($data[5]);
		$direcproveedor = utf8_encode($data[6]);
		$emailproveedor = limpiar($data[7]);
		$vendedor = utf8_encode($data[8]);
		$tlfvendedor = limpiar($data[9]);
		$fechaingreso = limpiar(date("Y-m-d"));
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();

	   $codproveedor++;
   }
   $this->dbh->commit();
   //cerramos la lectura del archivo "abrir archivo" con un "cerrar archivo"
   fclose($handle);
	        
	   echo "<span class='fa fa-check-square-o'></span> LA CARGA MASIVA DE PROVEEDORES FUE REALIZADA EXITOSAMENTE";
	   exit;
   }
   else
   {
   //si aparece esto es posible que el archivo no tenga el formato adecuado, inclusive cuando es cvs, revisarlo para ver si esta separado por " , "
      echo "2";
		exit;
   }  
}
############################# FUNCION CARGAR PROVEEDORES ##############################

############################ FUNCION REGISTRAR PROVEEDORES ##########################
public function RegistrarProveedores()
{
	$this->p = [];
	if(empty($_POST["cuitproveedor"]) or empty($_POST["nomproveedor"]) or empty($_POST["direcproveedor"]) or empty($_POST["codsucursal"]))
	{
		echo "1";
		exit;
	}
	//llamada de la funcion
	/*elseif (!valida_rut($_POST["cuitproveedor"]))
	{
		echo "2";
		exit;
	}*/

	############## CREO CODIGO DE PROVEEDOR #################
	$sql = "SELECT codproveedor
	FROM proveedores
	ORDER BY idproveedor DESC LIMIT 1";
	foreach ($this->dbh->query($sql) as $row){

		$proveedor = $row["codproveedor"];
	}
	$codproveedor = limpiar(empty($proveedor) ? "1" : $proveedor + 1);
	############## CREO CODIGO DE PROVEEDOR #################

	$sql = " SELECT cuitproveedor FROM proveedores WHERE cuitproveedor = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["cuitproveedor"],decrypt($_POST["codsucursal"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$query = " INSERT INTO proveedores values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codproveedor);
	    $stmt->bindParam(2, $documproveedor);
		$stmt->bindParam(3, $cuitproveedor);
		$stmt->bindParam(4, $nomproveedor);
		$stmt->bindParam(5, $tlfproveedor);
		$stmt->bindParam(6, $id_ciudad);
		$stmt->bindParam(7, $id_comuna);
		$stmt->bindParam(8, $direcproveedor);
		$stmt->bindParam(9, $emailproveedor);
		$stmt->bindParam(10, $vendedor);
		$stmt->bindParam(11, $tlfvendedor);
		$stmt->bindParam(12, $fechaingreso);
		$stmt->bindParam(13, $codsucursal);
		
		$documproveedor = limpiar($_POST['documproveedor'] == '' ? "0" : $_POST['documproveedor']);
		$cuitproveedor = limpiar($_POST["cuitproveedor"]);
		$nomproveedor = limpiar($_POST["nomproveedor"]);
		$tlfproveedor = limpiar($_POST["tlfproveedor"]);
		$id_ciudad = limpiar($_POST['id_ciudad'] == '' ? "0" : $_POST['id_ciudad']);
		$id_comuna = limpiar($_POST['id_comuna'] == '' ? "0" : $_POST['id_comuna']);
		$direcproveedor = limpiar($_POST["direcproveedor"]);
		$emailproveedor = limpiar($_POST["emailproveedor"]);
		$vendedor = limpiar($_POST["vendedor"]);
		$tlfvendedor = limpiar($_POST["tlfvendedor"]);
	    $fechaingreso = limpiar(date("Y-m-d"));
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();

		echo "<span class='fa fa-check-square-o'></span> EL PROVEEDOR HA SIDO REGISTRADO EXITOSAMENTE";
		exit;

	} else {

		echo "3";
		exit;
	}
}
########################### FUNCION REGISTRAR PROVEEDORES ########################

########################### FUNCION LISTAR PROVEEDORES ################################
public function ListarProveedores() 
{
	$this->p = [];
	$tipoAcceso      = isset($_SESSION["acceso"]) ? limpiar($_SESSION["acceso"]) : '';
    $codSucursal     = ($tipoAcceso === 'administradorG') ? limpiar(decrypt($_GET["codsucursal"])) : limpiar($_SESSION["codsucursal"]);
    $whereConditions = [];
    $params          = [];

    $whereConditions[] = "pro.codsucursal = ?";
    $params[]          = $codSucursal;

    $whereClause = "";
    if (!empty($whereConditions)) {
      $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $sqlBase = "SELECT
    pro.codproveedor, pro.documproveedor, pro.cuitproveedor, pro.nomproveedor,
	pro.tlfproveedor, pro.id_ciudad, pro.id_comuna, pro.direcproveedor,
	pro.emailproveedor, pro.vendedor, pro.tlfvendedor, pro.fechaingreso, pro.codsucursal,
	ciud.ciudad, com.comuna,
	suc.documsucursal, suc.cuitsucursal, suc.nomsucursal,
	suc.documencargado, suc.dniencargado, suc.nomencargado,
	doc.documento, doc2.documento AS documento2
	FROM proveedores pro
	LEFT JOIN documentos doc ON pro.documproveedor = doc.coddocumento
	LEFT JOIN ciudades ciud ON pro.id_ciudad = ciud.id_ciudad 
	LEFT JOIN comunas com ON pro.id_comuna = com.id_comuna
	LEFT JOIN sucursales suc ON pro.codsucursal = suc.codsucursal
	LEFT JOIN documentos AS doc2 ON suc.documencargado = doc2.coddocumento";
    $sql = $sqlBase . $whereClause . " ORDER BY pro.nomproveedor ASC";
    try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($results)) {
            return [];
        } else {
            return $results;
        }
    } catch (PDOException $e) {
        error_log("Error en ListarProveedores: " . $e->getMessage());
        return [];
    }
}
########################### FUNCION LISTAR PROVEEDORES ################################

########################### FUNCION ID PROVEEDORES #################################
public function ProveedoresPorId()
{
	$this->p = [];
	$sql = "SELECT
	proveedores.codproveedor,
	proveedores.documproveedor,
	proveedores.cuitproveedor,
	proveedores.nomproveedor,
	proveedores.tlfproveedor,
	proveedores.id_ciudad,
	proveedores.id_comuna,
	proveedores.direcproveedor,
	proveedores.emailproveedor,
	proveedores.vendedor,
	proveedores.tlfvendedor,
	proveedores.fechaingreso,
    documentos.documento,
	ciudades.codciudad,
    ciudades.ciudad,
    comunas.codcomuna,
    comunas.comuna,
	sucursales.documsucursal, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal,
	sucursales.documencargado,
	sucursales.dniencargado,
	sucursales.nomencargado,
	documentos2.documento AS documento2
	FROM proveedores 
	LEFT JOIN documentos ON proveedores.documproveedor = documentos.coddocumento
	LEFT JOIN ciudades ON proveedores.id_ciudad = ciudades.id_ciudad 
	LEFT JOIN comunas ON proveedores.id_comuna = comunas.id_comuna
	LEFT JOIN sucursales ON proveedores.codsucursal = sucursales.codsucursal
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	WHERE proveedores.codproveedor = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codproveedor"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
	}
}
############################ FUNCION ID PROVEEDORES #################################
	
############################ FUNCION ACTUALIZAR PROVEEDORES ############################
public function ActualizarProveedores()
{
	$this->p = [];
	if(empty($_POST["codproveedor"]) or empty($_POST["cuitproveedor"]) or empty($_POST["nomproveedor"]) or empty($_POST["direcproveedor"]) or empty($_POST["codsucursal"]))
	{
		echo "1";
		exit;
	}
	//llamada de la funcion
	/*elseif (!valida_rut($_POST["cuitproveedor"]))
	{
		echo "2";
		exit;
	}*/
	$sql = " SELECT cuitproveedor FROM proveedores WHERE codproveedor != ? AND cuitproveedor = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_POST["codproveedor"]),$_POST["cuitproveedor"],decrypt($_POST["codsucursal"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = "UPDATE proveedores set "
		." documproveedor = ?, "
		." cuitproveedor = ?, "
		." nomproveedor = ?, "
		." tlfproveedor = ?, "
		." id_ciudad = ?, "
		." id_comuna = ?, "
		." direcproveedor = ?, "
		." emailproveedor = ?, "
		." vendedor = ?, "
		." tlfvendedor = ?, "
		." codsucursal = ? "
		." WHERE "
		." codproveedor = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $documproveedor);
		$stmt->bindParam(2, $cuitproveedor);
		$stmt->bindParam(3, $nomproveedor);
		$stmt->bindParam(4, $tlfproveedor);
		$stmt->bindParam(5, $id_ciudad);
		$stmt->bindParam(6, $id_comuna);
		$stmt->bindParam(7, $direcproveedor);
		$stmt->bindParam(8, $emailproveedor);
		$stmt->bindParam(9, $vendedor);
		$stmt->bindParam(10, $tlfvendedor);
		$stmt->bindParam(11, $codsucursal);
		$stmt->bindParam(12, $codproveedor);
		
		$documproveedor = limpiar($_POST['documproveedor'] == '' ? "0" : $_POST['documproveedor']);
		$cuitproveedor = limpiar($_POST["cuitproveedor"]);
		$nomproveedor = limpiar($_POST["nomproveedor"]);
		$tlfproveedor = limpiar($_POST["tlfproveedor"]);
		$id_ciudad = limpiar($_POST['id_ciudad'] == '' ? "0" : $_POST['id_ciudad']);
		$id_comuna = limpiar($_POST['id_comuna'] == '' ? "0" : $_POST['id_comuna']);
		$direcproveedor = limpiar($_POST["direcproveedor"]);
		$emailproveedor = limpiar($_POST["emailproveedor"]);
		$vendedor = limpiar($_POST["vendedor"]);
		$tlfvendedor = limpiar($_POST["tlfvendedor"]);
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$codproveedor = limpiar(decrypt($_POST["codproveedor"]));
		$stmt->execute();
    
	   echo "<span class='fa fa-check-square-o'></span> EL PROVEEDOR HA SIDO ACTUALIZADO EXITOSAMENTE";
	   exit;

	} else {

		echo "3";
		exit;
	}
}
############################ FUNCION ACTUALIZAR PROVEEDORES ############################

########################## FUNCION ELIMINAR PROVEEDORES #################################
public function EliminarProveedores()
{
	$this->p = [];
	if ($_SESSION['acceso'] == "administradorG" || $_SESSION["acceso"]=="administradorS") {

	$sql = "SELECT codproveedor, codsucursal FROM productos WHERE codproveedor = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codproveedor"]),decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = "DELETE FROM proveedores WHERE codproveedor = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codproveedor);
		$stmt->bindParam(2,$codsucursal);
		$codproveedor = decrypt($_GET["codproveedor"]);
		$codsucursal = decrypt($_GET["codsucursal"]);
		$stmt->execute();

		echo "1";
		exit;

	} else {
		   
		echo "2";
		exit;
	} 
			
	} else {
		
		echo "3";
		exit;
	}	
}
########################### FUNCION ELIMINAR PROVEEDORES #########################

############################## FIN DE CLASE PROVEEDORES #################################
















###################################### CLASE PEDIDOS ###################################

############################ FUNCION REGISTRAR PEDIDOS #############################
public function RegistrarPedidos()
{
	$this->p = [];
	if(empty($_POST["codsucursal"]) or empty($_POST["codproveedor"]) or empty($_POST["txtTotal"]) or empty($_POST["fecharegistro"]))
	{
		echo "1";
		exit;
	}
	elseif(empty($_SESSION["CarritoPedido"]))
	{
		echo "2";
		exit;
	}

	################# OBTENGO DATOS DE SUCURSAL #################
	$sql = " SELECT 
	codsucursal,
	cuitsucursal, 
	nroactividadsucursal 
	FROM sucursales WHERE codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$cuitsucursal  = $row['cuitsucursal'];
	$nroactividad  = $row['nroactividadsucursal'];
	################# OBTENGO DATOS DE SUCURSAL #################

	################ CREO CODIGO DE PEDIDO ####################
	$sql = "SELECT codpedido FROM pedidos 
	ORDER BY idpedido DESC LIMIT 1";
	foreach ($this->dbh->query($sql) as $row){

		$pedido = $row["codpedido"];
	}
	if(empty($pedido))
	{
		$codpedido   = "01";

	} else {

		$num         = substr($pedido, 0);
        $dig         = $num + 1;
        $codigofinal = str_pad($dig, 2, "0", STR_PAD_LEFT);
        $codpedido   = $codigofinal;
	}
    ################ CREO CODIGO DE PEDIDO ###############

    ################### CREO CODIGO DE FACTURA ####################
	$sql = "SELECT codfactura FROM pedidos 
	WHERE codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."' 
	ORDER BY idpedido DESC LIMIT 1";
	foreach ($this->dbh->query($sql) as $row){

		$factura = $row["codfactura"];
	}
	if(empty($pedido))
	{
		$codfactura = "0000001";

	} else {

		$var        = strlen("");
        $var1       = substr($factura , $var);
        $var2       = strlen($var1);
        $var3       = $var1 + 1;
        $var4       = str_pad($var3, $var2, "0", STR_PAD_LEFT);
        $codfactura = $var4;
	}
    ################### CREO CODIGO DE FACTURA ####################

    $query = "INSERT INTO pedidos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $codpedido);
	$stmt->bindParam(2, $codfactura);
	$stmt->bindParam(3, $codproveedor);
	$stmt->bindParam(4, $subtotalivasi);
	$stmt->bindParam(5, $subtotalivano);
	$stmt->bindParam(6, $iva);
	$stmt->bindParam(7, $totaliva);
	$stmt->bindParam(8, $descontado);
	$stmt->bindParam(9, $descuento);
	$stmt->bindParam(10, $totaldescuento);
	$stmt->bindParam(11, $totalpago);
	$stmt->bindParam(12, $observaciones);
	$stmt->bindParam(13, $fechapedido);
	$stmt->bindParam(14, $procesada);
	$stmt->bindParam(15, $codigo);
	$stmt->bindParam(16, $codsucursal);

	$codproveedor   = limpiar($_POST["codproveedor"]);
	$subtotalivasi  = limpiar($_POST["txtsubtotal"]);
	$subtotalivano  = limpiar($_POST["txtsubtotal2"]);
	$iva            = limpiar($_POST["iva"]);
	$totaliva       = limpiar($_POST["txtIva"]);
	$descontado     = limpiar($_POST["txtdescontado"]);
	$descuento      = limpiar($_POST["descuento"]);
	$totaldescuento = limpiar($_POST["txtDescuento"]);
	$totalpago      = limpiar($_POST["txtTotal"]);
	$totalpago2     = limpiar($_POST["txtTotalCompra"]);
	$observaciones  = limpiar($_POST["observaciones"]);
    $fechapedido    = limpiar(date("Y-m-d H:i:s",strtotime($_POST['fecharegistro'])));
    $procesada      = limpiar("1");
	$codigo         = limpiar($_SESSION["codigo"]);
	$codsucursal    = limpiar(decrypt($_POST["codsucursal"]));
	$stmt->execute();
	
	$this->dbh->beginTransaction();
	$detalle = $_SESSION["CarritoPedido"];
	for($i=0;$i<count($detalle);$i++){

		$query = "INSERT INTO detallepedidos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codpedido);
	    $stmt->bindParam(2, $idproducto);
	    $stmt->bindParam(3, $codproducto);
	    $stmt->bindParam(4, $producto);
	    $stmt->bindParam(5, $descripcion);
        $stmt->bindParam(6, $opcionvendido);
	    $stmt->bindParam(7, $imei);
	    $stmt->bindParam(8, $condicion);
	    $stmt->bindParam(9, $codmarca);
	    $stmt->bindParam(10, $codmodelo);
	    $stmt->bindParam(11, $codpresentacion);
	    $stmt->bindParam(12, $codcolor);
		$stmt->bindParam(13, $cantidad);
		$stmt->bindParam(14, $preciocompra);
		$stmt->bindParam(15, $precioxmayor);
		$stmt->bindParam(16, $precioxmenor);
		$stmt->bindParam(17, $precioxpublico);
		$stmt->bindParam(18, $ivaproducto);
		$stmt->bindParam(19, $descproducto);
		$stmt->bindParam(20, $descfactura);
		$stmt->bindParam(21, $valortotal);
		$stmt->bindParam(22, $totaldescuentoc);
		$stmt->bindParam(23, $subtotalimpuestos);
		$stmt->bindParam(24, $valorneto);
		$stmt->bindParam(25, $codsucursal);
			
	    $idproducto      = limpiar($detalle[$i]['id']);
		$codproducto     = limpiar($detalle[$i]['txtCodigo']);
		$producto        = limpiar($detalle[$i]['producto']);
		$descripcion     = limpiar($detalle[$i]['descripcion'] == "0" ? "" : $detalle[$i]['descripcion']);
		$opcionvendido   = limpiar($detalle[$i]['opcionvendido']);
	    $imei            = limpiar($detalle[$i]['imei'] == "0" ? "" : $detalle[$i]['imei']);
	    $condicion       = limpiar($detalle[$i]['condicion'] == "0" ? "" : $detalle[$i]['condicion']);
		$codmarca        = limpiar($detalle[$i]['codmarca']);
		$codmodelo       = limpiar($detalle[$i]['codmodelo']);
		$codpresentacion = limpiar($detalle[$i]['codpresentacion']);
		$codcolor        = limpiar($detalle[$i]['codcolor']);
		$cantidad        = $detalle[$i]['opcionvendido'] == "2" ? number_format($detalle[$i]['cantidad'], 3, '.', '') : number_format($detalle[$i]['cantidad'], 0, '.', '');
		$preciocompra    = limpiar($detalle[$i]['precio']);
		$precioxmayor    = limpiar($detalle[$i]['precio3']);
		$precioxmenor    = limpiar($detalle[$i]['precio2']);
		$precioxpublico  = limpiar($detalle[$i]['precio4']);
		$precioconiva    = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['precio']);
		$ivaproducto     = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
		$descproducto    = limpiar($detalle[$i]['descproducto']);
		$descfactura     = limpiar($detalle[$i]['descproductofact']);
		$descuento       = $detalle[$i]['descproductofact']/100;
		$valortotal      = number_format($detalle[$i]['precio']*$detalle[$i]['cantidad'], 2, '.', '');
		$totaldescuentoc = number_format($valortotal*$descuento, 2, '.', '');

		//CALCULO SUBTOTAL IMPUESTOS
		$ValorImpuesto        = 1 + ($_POST["iva"]/100);
		$RestoDescuento       = $precioconiva * $detalle[$i]['descproducto'] / 100;
		$PrecioIvaDescuento   = $precioconiva - $RestoDescuento;
		$Discriminado         = $PrecioIvaDescuento/$ValorImpuesto;
		$SubtotalDiscriminado = $PrecioIvaDescuento - $Discriminado;
	    $BaseDiscriminado     = $SubtotalDiscriminado * $detalle[$i]['cantidad'];
	    $subtotalimpuestos    = number_format($BaseDiscriminado, 2, '.', '');
	    $valorneto            = number_format($valortotal-$totaldescuentoc, 2, '.', '');
		$codsucursal          = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();
    }
        
    ####################### DESTRUYO LA VARIABLE DE SESSION #####################
	unset($_SESSION["CarritoPedido"]);
    $this->dbh->commit();

	echo "<span class='fa fa-check-square-o'></span> EL PEDIDO DE PRODUCTOS HA SIDO REGISTRADO EXITOSAMENTE <a href='reportepdf?codpedido=".encrypt($codpedido)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt("FACTURAPEDIDO")."' class='on-default' data-placement='left' data-toggle='tooltip' data-original-title='Imprimir Documento' target='_black' rel='noopener noreferrer'><font color='black'><strong>IMPRIMIR REPORTE</strong></font color></a>";
	echo "<script>VentanaCentrada('reportepdf?codpedido=".encrypt($codpedido)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt("FACTURAPEDIDO")."', '', '', '1024', '568', 'true');</script>";
	exit;
}
############################ FUNCION REGISTRAR PEDIDOS ###############################

########################### FUNCION LISTAR PEDIDOS ################################
public function ListarPedidos()
{
	$this->p = [];
	$tipoAcceso      = isset($_SESSION["acceso"]) ? limpiar($_SESSION["acceso"]) : '';
    $codSucursal     = ($tipoAcceso === 'administradorG') ? limpiar(decrypt($_GET["codsucursal"])) : limpiar($_SESSION["codsucursal"]);
    $codigoUsuario   = isset($_SESSION["codigo"]) ? limpiar($_SESSION["codigo"]) : '';
    $whereConditions = [];
    $params          = [];

    $whereConditions[] = "ped.codsucursal = ?";
    $params[]          = $codSucursal;
   
    $whereClause = "";
    if (!empty($whereConditions)) {
      $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $sqlBase = "SELECT
        ped.codpedido, ped.codfactura, ped.codproveedor, ped.subtotalivasi, ped.subtotalivano, 
		ped.iva, ped.totaliva, ped.descontado, ped.descuento, ped.totaldescuento, 
		ped.totalpago, ped.observaciones, ped.fechapedido, ped.procesada, ped.codsucursal,
		suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
		suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
		tm.moneda, tm.siglas, tm.simbolo,
		usu.dni, usu.nombres,
		pro.documproveedor, pro.documproveedor, pro.cuitproveedor, pro.nomproveedor,
		doc.documento, doc2.documento AS documento2, doc3.documento AS documento3,
		pag.articulos, pag.detalles_productos
    FROM 
        pedidos ped LEFT JOIN sucursales suc ON ped.codsucursal = suc.codsucursal 
	LEFT JOIN 
	    documentos doc ON suc.documsucursal = doc.coddocumento
	LEFT JOIN 
	    documentos AS doc2 ON suc.documencargado = doc2.coddocumento
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
	LEFT JOIN 
	    proveedores pro ON ped.codproveedor = pro.codproveedor
	LEFT JOIN 
	    documentos AS doc3 ON pro.documproveedor = doc3.coddocumento
	LEFT JOIN 
	    usuarios usu ON ped.codigo = usu.codigo
    LEFT JOIN
        (SELECT
            dp.codpedido,
            SUM(dp.cantidad) AS articulos,
            GROUP_CONCAT(
            CONCAT_WS(
               ' | ',
               dp.cantidad,
               dp.producto,
               dp.descripcion,
               IFNULL(mar.nommarca, ''),
               IFNULL(mode.nommodelo, ''),
               IFNULL(pres.nompresentacion, ''),
               IFNULL(col.nomcolor, '')
            )
                ORDER BY dp.producto
                SEPARATOR '<br>'
            ) AS detalles_productos
            FROM
                detallepedidos dp
            LEFT JOIN 
                marcas mar ON dp.codmarca = mar.codmarca
		    LEFT JOIN 
		        modelos mode ON dp.codmodelo = mode.codmodelo 
		    LEFT JOIN 
		        presentaciones pres ON dp.codpresentacion = pres.codpresentacion
			LEFT JOIN 
			    colores col ON dp.codcolor = col.codcolor
			WHERE dp.codsucursal = $codSucursal
	    GROUP BY
	        dp.codpedido
	    ) pag ON pag.codpedido = ped.codpedido";
    $sql = $sqlBase . $whereClause . " ORDER BY ped.fechapedido DESC";
    try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($results)) {
            return [];
        } else {
            return $results;
        }
    } catch (PDOException $e) {
        error_log("Error en ListarPedidos: " . $e->getMessage());
        return [];
    }
}
############################# FUNCION LISTAR PEDIDOS ############################

############################ FUNCION ID PEDIDOS #################################
public function PedidosPorId()
{
    $this->p      = [];
    $codPedido    = isset($_GET["codpedido"]) ? limpiar(decrypt($_GET["codpedido"])) : '';
    $codSucursal  = isset($_GET["codsucursal"]) ? limpiar(decrypt($_GET["codsucursal"])) : '';
    $sql = "SELECT
        ped.*,
        suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.tlfsucursal,
        suc.correosucursal, suc.id_ciudad, suc.id_comuna, suc.direcsucursal,
        suc.nroactividadsucursal, suc.fechaautorsucursal, suc.llevacontabilidad,
        suc.documencargado, suc.dniencargado, suc.nomencargado, suc.tlfencargado,
        suc.codmoneda, suc.codmoneda2, suc.membrete,
        tm.moneda, tm.siglas, tm.simbolo,
        tm2.moneda AS moneda2, tm2.siglas AS siglas2, tm2.simbolo AS simbolo2,
        valor_cambio.montocambio,
        pro.documproveedor, pro.cuitproveedor, pro.nomproveedor, pro.tlfproveedor, 
        pro.id_ciudad AS id_ciudad2, pro.id_comuna AS id_comuna2, 
	    pro.direcproveedor, pro.emailproveedor, pro.vendedor, pro.tlfvendedor,
        doc.documento, doc2.documento AS documento2, doc3.documento AS documento3,
        usu.dni, usu.nombres,
        ciud.ciudad, com.comuna, ciud2.ciudad AS ciudad2, com2.comuna AS comuna2,
        pag.articulos
    FROM 
        pedidos ped LEFT JOIN sucursales suc ON ped.codsucursal = suc.codsucursal
	LEFT JOIN 
	    documentos doc ON suc.documsucursal = doc.coddocumento
	LEFT JOIN 
	    documentos AS doc2 ON suc.documencargado = doc2.coddocumento
    LEFT JOIN 
        ciudades ciud ON suc.id_ciudad = ciud.id_ciudad 
    LEFT JOIN 
        comunas com ON suc.id_comuna = com.id_comuna 
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
    LEFT JOIN 
        tiposmoneda tm2 ON suc.codmoneda2 = tm2.codmoneda
	LEFT JOIN 
	    proveedores pro ON ped.codproveedor = pro.codproveedor
	LEFT JOIN 
	    documentos AS doc3 ON pro.documproveedor = doc3.coddocumento
    LEFT JOIN 
        ciudades ciud2 ON pro.id_ciudad = ciud2.id_ciudad 
    LEFT JOIN 
        comunas com2 ON pro.id_comuna = com2.id_comuna 
	LEFT JOIN 
	    usuarios usu ON ped.codigo = usu.codigo
    LEFT JOIN
        (SELECT
            dp.codpedido,
            SUM(dp.cantidad) AS articulos
            FROM
                detallepedidos dp
            WHERE dp.codsucursal = :codSucursal1
        GROUP BY
            dp.codpedido
        ) pag ON pag.codpedido = ped.codpedido

    LEFT JOIN
       (SELECT
       codcambio, descripcioncambio, montocambio, codmoneda       
       FROM tiposcambio
       ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = suc.codmoneda2
    WHERE ped.codpedido = :codPedido AND ped.codsucursal = :codSucursal2 LIMIT 1";
    try {
        $stmt = $this->dbh->prepare($sql);
        // Asignamos los parámetros a los marcadores de posición con nombre
        $stmt->bindParam(':codPedido', $codPedido);
        $stmt->bindParam(':codSucursal1', $codSucursal);
        $stmt->bindParam(':codSucursal2', $codSucursal);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        if (!$row) {
            echo "<div class='alert alert-danger'>";
            echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
            echo "<center><span class='fa fa-info-circle'></span> PEDIDO NO ENCONTRADA.</center>";
            echo "</div>";
            exit();
        } else {
            $this->p[] = $row;
            return $this->p;
        }
    } catch (PDOException $e) {
        error_log("Error en PedidosPorId: " . $e->getMessage());
        echo "<div class='alert alert-danger'>";
        echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
        echo "<center><span class='fa fa-exclamation-triangle'></span> OCURRIÓ UN ERROR AL CONSULTAR LA VENTA.</center>";
        echo "</div>";
        return [];
    }
}
############################ FUNCION ID PEDIDOS #################################
	
########################### FUNCION VER DETALLES PEDIDOS ###########################
public function VerDetallesPedidos()
{
	$this->p     = [];
	$codPedido   = isset($_GET["codpedido"]) ? limpiar(decrypt($_GET["codpedido"])) : '';
    $codSucursal = isset($_GET["codsucursal"]) ? limpiar(decrypt($_GET["codsucursal"])) : '';
    $sql = "SELECT
	dp.*,
	ma.nommarca,
	mo.nommodelo,
	pr.nompresentacion,
	co.nomcolor
	FROM
	    detallepedidos dp
	LEFT JOIN 
	    marcas ma ON dp.codmarca = ma.codmarca
	LEFT JOIN 
	    modelos mo ON dp.codmodelo = mo.codmodelo 
	LEFT JOIN 
	    presentaciones pr ON dp.codpresentacion = pr.codpresentacion
	LEFT JOIN 
	    colores co ON dp.codcolor = co.codcolor 
	WHERE dp.codpedido = ? AND dp.codsucursal = ?";
	try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute([$codPedido,$codSucursal]);
        $this->p = $stmt->fetchAll(PDO::FETCH_ASSOC);
        return $this->p;
    } catch (PDOException $e) {
        // Manejo de errores: registra el error y devuelve un array vacío
        error_log("Error en VerDetallesPedidos: " . $e->getMessage() . " SQL: " . $sql . " Params: " . json_encode([$codPedido,$codSucursal]));
        return [];
    }
}
########################### FUNCION VER DETALLES PEDIDOS ############################

########################### FUNCION ACTUALIZAR PEDIDOS #############################
public function ActualizarPedidos()
{
	$this->p = [];
	if(empty($_POST["codpedido"]) or empty($_POST["codsucursal"]) or empty($_POST["codproveedor"]) or empty($_POST["fechapedido"]))
	{
		echo "1";
		exit;
	}
	for($i=0;$i<count($_POST['coddetallepedido']);$i++){  //recorro el array
        if (!empty($_POST['coddetallepedido'][$i])) {

	        if($_POST['cantidad'][$i] == 0 || $_POST['cantidad'][$i] == 0.00){

		        echo "2";
		        exit();
	        }
        }
    }

    $this->dbh->beginTransaction();
	for($i=0;$i<count($_POST['coddetallepedido']);$i++){  //recorro el array
	    if (!empty($_POST['coddetallepedido'][$i])) {

			################## OBTENGO CANTIDAD DE DETALLE ##################
			$sql = "SELECT cantidad FROM detallepedidos 
		    WHERE coddetallepedido = '".limpiar($_POST['coddetallepedido'][$i])."'";
			foreach ($this->dbh->query($sql) as $row)
			{
				$this->p[] = $row;
			}
			$cantidadbd = $row['cantidad'];
			################## OBTENGO CANTIDAD DE DETALLE ##################

	        if($cantidadbd != $_POST['cantidad'][$i]){

			################### ACTUALIZO DETALLES PEDIDOS ###################
			$query = "UPDATE detallepedidos set"
			." cantidad = ?, "
			." valortotal = ?, "
			." totaldescuentoc = ?, "
			." subtotalimpuestos = ?, "
			." valorneto = ? "
			." WHERE "
			." coddetallepedido = ? AND codpedido = ? AND codsucursal = ?;
			";
			$stmt = $this->dbh->prepare($query);
			$stmt->bindParam(1, $cantidad);
			$stmt->bindParam(2, $valortotal);
			$stmt->bindParam(3, $totaldescuento);
			$stmt->bindParam(4, $subtotalimpuestos);
			$stmt->bindParam(5, $valorneto);
			$stmt->bindParam(6, $coddetallepedido);
			$stmt->bindParam(7, $codcompra);
			$stmt->bindParam(8, $codsucursal);

			$cantidad         = $_POST['opcionvendido'][$i] == "2" ? number_format($_POST['cantidad'][$i], 3, '.', '') : number_format($_POST['cantidad'][$i], 0, '.', '');
			$preciocompra     = limpiar($_POST['preciocompra'][$i]);
			$ivaproducto      = limpiar($_POST['ivaproducto'][$i]);
			$descuento        = $_POST['descfactura'][$i]/100;
			$valortotal       = number_format($_POST['valortotal'][$i], 2, '.', '');
			$totaldescuento   = number_format($_POST['totaldescuentoc'][$i], 2, '.', '');
			$subtotalimpuestos= number_format($_POST['subtotalimpuestos'][$i], 2, '.', '');
			$valorneto        = number_format($_POST['valorneto'][$i], 2, '.', '');
			$coddetallepedido = limpiar($_POST['coddetallepedido'][$i]);
			$codcompra        = limpiar(decrypt($_POST["codpedido"]));
			$codsucursal      = limpiar(decrypt($_POST["codsucursal"]));
			$stmt->execute();
			################### ACTUALIZO DETALLES PEDIDOS ###################

		} else {

                echo "";
	        }
        }
    }
    $this->dbh->commit();

    ############ ACTUALIZO LOS TOTALES EN PEDIDO ##############
	$sql = " UPDATE pedidos SET "
	." codproveedor = ?, "
	." subtotalivasi = ?, "
	." subtotalivano = ?, "
	." totaliva = ?, "
	." descontado = ?, "
	." descuento = ?, "
	." totaldescuento = ?, "
	." totalpago = ?, "
	." observaciones = ?, "
	." fechapedido = ? "
	." WHERE "
	." codpedido = ? AND codsucursal = ?;
	";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $codproveedor);
	$stmt->bindParam(2, $subtotalivasi);
	$stmt->bindParam(3, $subtotalivano);
	$stmt->bindParam(4, $totaliva);
	$stmt->bindParam(5, $descontado);
	$stmt->bindParam(6, $descuento);
	$stmt->bindParam(7, $totaldescuento);
	$stmt->bindParam(8, $totalpago);
	$stmt->bindParam(9, $observaciones);
	$stmt->bindParam(10, $fechapedido);
	$stmt->bindParam(11, $codpedido);
	$stmt->bindParam(12, $codsucursal);

	$codproveedor   = limpiar($_POST["codproveedor"]);
	$subtotalivasi  = number_format($_POST["txtsubtotal"], 2, '.', '');
	$subtotalivano  = number_format($_POST["txtsubtotal2"], 2, '.', '');
	$totaliva       = number_format($_POST["txtIva"], 2, '.', '');
	$descontado     = number_format($_POST["txtdescontado"], 2, '.', '');
	$descuento      = limpiar($_POST["descuento"]);
	$totaldescuento = number_format($_POST["txtDescuento"], 2, '.', '');
	$totalpago      = number_format($_POST["txtTotal"], 2, '.', '');
	$observaciones  = limpiar($_POST["observaciones"]);
	$fechapedido    = limpiar(date("Y-m-d H:i:s",strtotime($_POST['fechapedido'])));
	$codpedido      = limpiar(decrypt($_POST["codpedido"]));
	$codsucursal    = limpiar(decrypt($_POST["codsucursal"]));
	$stmt->execute();
	############ ACTUALIZO LOS TOTALES EN PEDIDO ##############

	echo "<span class='fa fa-check-square-o'></span> EL PEDIDO DE PRODUCTOS HA SIDO ACTUALIZADO EXITOSAMENTE <a href='reportepdf?codpedido=".encrypt($codpedido)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt("FACTURAPEDIDO")."' class='on-default' data-placement='left' data-toggle='tooltip' data-original-title='Imprimir Documento' target='_black' rel='noopener noreferrer'><font color='black'><strong>IMPRIMIR REPORTE</strong></font color></a>";
	echo "<script>VentanaCentrada('reportepdf?codpedido=".encrypt($codpedido)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt("FACTURAPEDIDO")."', '', '', '1024', '568', 'true');</script>";
	exit;
}
########################### FUNCION ACTUALIZAR PEDIDOS ############################

########################### FUNCION AGREGAR DETALLES PEDIDOS ############################
public function AgregarDetallesPedidos()
{
	$this->p = [];
	if(empty($_POST["codpedido"]) or empty($_POST["codsucursal"]) or empty($_POST["codproveedor"]) or empty($_POST["fechapedido"]))
	{
		echo "1";
		exit;
	}
    elseif(empty($_SESSION["CarritoPedido"]))
	{
		echo "2";
		exit;
	}

	############ CONSULTO TOTAL ACTUAL DE PEDIDO ##############
	$sql = "SELECT
	codfactura,
	descuento,
	totalpago 
	FROM pedidos 
	WHERE codpedido = '".limpiar(decrypt($_POST["codpedido"]))."' 
	AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$codfacturabd = $row['codfactura'];
	$descuentobd  = $row['descuento'];
	$totalpagobd  = $row['totalpago'];
	############ CONSULTO TOTAL ACTUAL DE PEDIDO ##############

	$this->dbh->beginTransaction();
    $detalle = $_SESSION["CarritoPedido"];
	for($i=0;$i<count($detalle);$i++){

	$sql = "SELECT * 
	FROM detallepedidos 
	WHERE codpedido = '".limpiar(decrypt($_POST['codpedido']))."' 
	AND codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."'  
	AND idproducto = '".limpiar($detalle[$i]['id'])."'
	AND codproducto = '".limpiar($detalle[$i]['txtCodigo'])."'";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num == 0)
	{
        ############################ REGISTRO DETALLES DE PEDIDOS ############################
		$query = "INSERT INTO detallepedidos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codpedido);
	    $stmt->bindParam(2, $idproducto);
	    $stmt->bindParam(3, $codproducto);
	    $stmt->bindParam(4, $producto);
	    $stmt->bindParam(5, $descripcion);
        $stmt->bindParam(6, $opcionvendido);
	    $stmt->bindParam(6, $imei);
	    $stmt->bindParam(7, $condicion);
	    $stmt->bindParam(8, $codmarca);
	    $stmt->bindParam(9, $codmodelo);
	    $stmt->bindParam(10, $codpresentacion);
	    $stmt->bindParam(11, $codcolor);
		$stmt->bindParam(12, $cantidad);
		$stmt->bindParam(13, $preciocompra);
		$stmt->bindParam(14, $precioxmayor);
		$stmt->bindParam(15, $precioxmenor);
		$stmt->bindParam(16, $precioxpublico);
		$stmt->bindParam(17, $ivaproducto);
		$stmt->bindParam(18, $descproducto);
		$stmt->bindParam(19, $descfactura);
		$stmt->bindParam(20, $valortotal);
		$stmt->bindParam(21, $totaldescuentoc);
		$stmt->bindParam(22, $subtotalimpuestos);
		$stmt->bindParam(23, $valorneto);
		$stmt->bindParam(24, $codsucursal);
			
	    $codpedido       = limpiar(decrypt($_POST["codpedido"]));
	    $idproducto      = limpiar($detalle[$i]['id']);
		$codproducto     = limpiar($detalle[$i]['txtCodigo']);
		$producto        = limpiar($detalle[$i]['producto']);
		$descripcion     = limpiar($detalle[$i]['descripcion'] == "0" ? "" : $detalle[$i]['descripcion']);
		$opcionvendido   = limpiar($detalle[$i]['opcionvendido']);
	    $imei            = limpiar($detalle[$i]['imei'] == "0" ? "" : $detalle[$i]['imei']);
		$condicion       = limpiar($detalle[$i]['condicion'] == "0" ? "" : $detalle[$i]['condicion']);
		$codmarca        = limpiar($detalle[$i]['codmarca']);
		$codmodelo       = limpiar($detalle[$i]['codmodelo']);
		$codpresentacion = limpiar($detalle[$i]['codpresentacion']);
		$codcolor        = limpiar($detalle[$i]['codcolor']);
		$cantidad        = $detalle[$i]['opcionvendido'] == "2" ? number_format($detalle[$i]['cantidad'], 3, '.', '') : number_format($detalle[$i]['cantidad'], 0, '.', '');
		$preciocompra    = limpiar($detalle[$i]['precio']);
		$precioxmayor    = limpiar($detalle[$i]['precio3']);
		$precioxmenor    = limpiar($detalle[$i]['precio2']);
		$precioxpublico  = limpiar($detalle[$i]['precio4']);
		$precioconiva    = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['precio']);
		$ivaproducto     = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
		$descproducto    = limpiar($detalle[$i]['descproducto']);
		$descfactura     = limpiar($detalle[$i]['descproductofact']);
		$descuento       = $detalle[$i]['descproductofact']/100;
		$valortotal      = number_format($detalle[$i]['precio']*$detalle[$i]['cantidad'], 2, '.', '');
		$totaldescuentoc = number_format($valortotal*$descuento, 2, '.', '');

		//CALCULO SUBTOTAL IMPUESTOS
		$ValorImpuesto        = 1 + ($_POST["iva"]/100);
		$RestoDescuento       = $precioconiva * $detalle[$i]['descproducto'] / 100;
		$PrecioIvaDescuento   = $precioconiva - $RestoDescuento;
		$Discriminado         = $PrecioIvaDescuento/$ValorImpuesto;
		$SubtotalDiscriminado = $PrecioIvaDescuento - $Discriminado;
	    $BaseDiscriminado     = $SubtotalDiscriminado * $detalle[$i]['cantidad'];
	    $subtotalimpuestos    = number_format($BaseDiscriminado, 2, '.', '');

	    $valorneto            = number_format($valortotal-$totaldescuentoc, 2, '.', '');
		$codsucursal          = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();
		############################ REGISTRO DETALLES DE PEDIDOS ############################

	} else {

		################## OBTENGO CANTIDAD DE DETALLE ##################
		$sql = "SELECT cantidad 
	  	FROM detallepedidos 
	  	WHERE codpedido = '".limpiar(decrypt($_POST['codpedido']))."' 
	  	AND codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."'
	  	AND idproducto = '".limpiar($detalle[$i]['id'])."' 
	  	AND codproducto = '".limpiar($detalle[$i]['txtCodigo'])."'";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		$cantidad = $row['cantidad'];
		################## OBTENGO CANTIDAD DE DETALLE ##################

	  	############################ ACTUALIZO DETALLES DE COMPRAS ############################
	  	$query = "UPDATE detallepedidos set"
		." cantidad = ?, "
		." descproducto = ?, "
		." descfactura = ?, "
		." valortotal = ?, "
		." totaldescuentoc = ?, "
		." subtotalimpuestos = ?, "
		." valorneto = ? "
		." WHERE "
		." codpedido = ? AND codsucursal = ? AND idproducto = ? AND codproducto = ?;
		";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $cantidad);
		$stmt->bindParam(2, $descproducto);
		$stmt->bindParam(3, $descfactura);
		$stmt->bindParam(4, $valortotal);
		$stmt->bindParam(5, $totaldescuentoc);
		$stmt->bindParam(6, $subtotalimpuestos);
		$stmt->bindParam(7, $valorneto);
		$stmt->bindParam(8, $codpedido);
		$stmt->bindParam(9, $codsucursal);
		$stmt->bindParam(10, $idproducto);
		$stmt->bindParam(11, $codproducto);

		$cantidad        = $detalle[$i]['opcionvendido'] == "2" ? number_format($detalle[$i]['cantidad']+$cantidad, 3, '.', '') : number_format($detalle[$i]['cantidad']+$cantidad, 0, '.', '');
		$preciocomprac   = limpiar($detalle[$i]['precio']);
		$precioxmayorc   = limpiar($detalle[$i]['precio3']);
		$precioxmenorc   = limpiar($detalle[$i]['precio2']);
		$precioxpublicoc = limpiar($detalle[$i]['precio4']);
		$precioconiva    = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['precio']);
		$ivaproducto     = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
		$descproducto    = limpiar($detalle[$i]['descproducto']);
		$descfactura     = limpiar($detalle[$i]['descproductofact']);
		$descuento       = $detalle[$i]["descproductofact"]/100;
		$valortotal      = number_format($detalle[$i]['precio']*$cantidad, 2, '.', '');
		$totaldescuentoc = number_format($valortotal*$descuento, 2, '.', '');

		//CALCULO SUBTOTAL IMPUESTOS
		$ValorImpuesto        = 1 + ($_POST["iva"]/100);
		$RestoDescuento       = $precioconiva * $detalle[$i]['descproducto'] / 100;
		$PrecioIvaDescuento   = $precioconiva - $RestoDescuento;
		$Discriminado         = $PrecioIvaDescuento/$ValorImpuesto;
		$SubtotalDiscriminado = $PrecioIvaDescuento - $Discriminado;
		$BaseDiscriminado     = $SubtotalDiscriminado * $cantidad;
		$subtotalimpuestos    = number_format($BaseDiscriminado, 2, '.', '');

	    $valorneto       = number_format($valortotal-$totaldescuentoc, 2, '.', '');
		$codpedido       = limpiar(decrypt($_POST["codpedido"]));
		$codsucursal     = limpiar(decrypt($_POST["codsucursal"]));
		$idproducto      = limpiar($detalle[$i]['id']);
		$codproducto     = limpiar($detalle[$i]['txtCodigo']);
		$stmt->execute();
		############################ ACTUALIZO DETALLES DE PEDIDOS ############################

	   }
    }    
   
    ####################### DESTRUYO LA VARIABLE DE SESSION #####################
	unset($_SESSION["CarritoPedido"]);
    $this->dbh->commit();

    ############ SUMO LOS IMPORTE DE PRODUCTOS CON IVA ##############
    $sql3 = "SELECT SUM(totaldescuentoc) AS totaldescuentosi, SUM(subtotalimpuestos) AS subtotalimpuestos, SUM(valorneto-subtotalimpuestos) AS valorneto FROM detallepedidos WHERE codpedido = '".limpiar(decrypt($_POST["codpedido"]))."' AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."' AND ivaproducto != '0.00'";
    foreach ($this->dbh->query($sql3) as $row3)
    {
  	   $this->p[] = $row3;
    }
    $subtotaldescuentosi = ($row3['totaldescuentosi']== "" ? "0.00" : $row3['totaldescuentosi']);
    $subtotalimpuestos   = ($row3['subtotalimpuestos']== "" ? "0.00" : $row3['subtotalimpuestos']);
    $subtotalivasi       = ($row3['valorneto']== "" ? "0.00" : $row3['valorneto']);
    ############ SUMO LOS IMPORTE DE PRODUCTOS CON IVA ##############

    ############ SUMO LOS IMPORTE DE PRODUCTOS SIN IVA ##############
    $sql4 = "SELECT SUM(totaldescuentoc) AS totaldescuentono, SUM(valorneto) AS valorneto FROM detallepedidos WHERE codpedido = '".limpiar(decrypt($_POST["codpedido"]))."' AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."' AND ivaproducto = '0.00'";
    foreach ($this->dbh->query($sql4) as $row4)
    {
  	   $this->p[] = $row4;
    }
    $subtotaldescuentono = ($row4['totaldescuentono']== "" ? "0.00" : $row4['totaldescuentono']);
    $subtotalivano       = ($row4['valorneto']== "" ? "0.00" : $row4['valorneto']);
    ############ SUMO LOS IMPORTE DE PRODUCTOS SIN IVA ##############

    ############ ACTUALIZO LOS TOTALES EN PEDIDO ##############
	$sql = " UPDATE pedidos SET "
	." codproveedor = ?, "
	." subtotalivasi = ?, "
	." subtotalivano = ?, "
	." totaliva = ?, "
	." descontado = ?, "
	." descuento = ?, "
	." totaldescuento = ?, "
	." totalpago = ?, "
	." observaciones = ?, "
	." fechapedido = ? "
	." WHERE "
	." codpedido = ? AND codsucursal = ?;
	";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $codproveedor);
	$stmt->bindParam(2, $subtotalivasi);
	$stmt->bindParam(3, $subtotalivano);
	$stmt->bindParam(4, $totaliva);
	$stmt->bindParam(5, $descontado);
	$stmt->bindParam(6, $descuento);
	$stmt->bindParam(7, $totaldescuento);
	$stmt->bindParam(8, $totalpago);
	$stmt->bindParam(9, $observaciones);
	$stmt->bindParam(10, $fechapedido);
	$stmt->bindParam(11, $codpedido);
	$stmt->bindParam(12, $codsucursal);

	$codproveedor   = limpiar($_POST["codproveedor"]);
	$iva            = $_POST["iva"]/100;
    $totaliva       = number_format($subtotalimpuestos, 2, '.', '');
    $descontado     = number_format($subtotaldescuentosi+$subtotaldescuentono, 2, '.', '');
    $descuento      = limpiar($_POST["descuento"]+$descuentobd);
    $txtDescuento   = $descuento/100;
    $total          = number_format($subtotalivasi+$subtotalivano+$totaliva, 2, '.', '');
    $totaldescuento = number_format($total*$txtDescuento, 2, '.', '');
    $totalpago      = number_format($total-$totaldescuento, 2, '.', '');
	$observaciones  = limpiar($_POST["observaciones"]);
	$fechapedido    = limpiar(date("Y-m-d H:i:s",strtotime($_POST['fechapedido'])));
	$codpedido      = limpiar(decrypt($_POST["codpedido"]));
	$codsucursal    = limpiar(decrypt($_POST["codsucursal"]));
	$stmt->execute();
	############ ACTUALIZO LOS TOTALES EN PEDIDO ##############

	echo "<span class='fa fa-check-square-o'></span> LOS DETALLES DE PRODUCTOS FUERON AGREGADOS AL PEDIDO EXITOSAMENTE <a href='reportepdf?codpedido=".encrypt($codpedido)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt("FACTURAPEDIDO")."' class='on-default' data-placement='left' data-toggle='tooltip' data-original-title='Imprimir Documento' target='_black' rel='noopener noreferrer'><font color='black'><strong>IMPRIMIR REPORTE</strong></font color></a>";
	echo "<script>VentanaCentrada('reportepdf?codpedido=".encrypt($codpedido)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt("FACTURAPEDIDO")."', '', '', '1024', '568', 'true');</script>";
	exit;
}
########################### FUNCION AGREGAR DETALLES PEDIDOS ############################

########################### FUNCION PROCESAR PEDIDOS A COMPRA ############################
public function ProcesarPedidos()
{
	$this->p = [];
	if(empty($_POST["codpedido"]) or empty($_POST["codproveedor"]) or empty($_POST["codsucursal"]) or empty($_POST["codfactura"]) or empty($_POST["fechaemision"]) or empty($_POST["fecharecepcion"]))
	{
		echo "1";
		exit;
	}
	for($i=0;$i<count($_POST['coddetallepedido']);$i++){  //recorro el array
        if (!empty($_POST['coddetallepedido'][$i])) {

	        if($_POST['cantidad'][$i] == 0 || $_POST['cantidad'][$i] == 0.00){

		        echo "2";
		        exit();
	        }
        }
    }

	if (limpiar($_POST["tipocompra"]) == "CREDITO") { 

	    $fechaactual = date("Y-m-d");
	    $fechavence = date("Y-m-d",strtotime($_POST['fechavencecredito']));
	
        if (strtotime($fechavence) < strtotime($fechaactual)) {
  
            echo "3";
	        exit;
        }
    }

    $sql = "SELECT codfactura FROM compras WHERE codfactura = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST['codfactura'],decrypt($_POST['codsucursal'])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		################ CREO CODIGO DE COMPRA ####################
		$sql = "SELECT codcompra FROM compras 
		ORDER BY idcompra DESC LIMIT 1";
		foreach ($this->dbh->query($sql) as $row){

			$compra = $row["codcompra"];
		}
		if(empty($compra))
		{
			$codcompra   = "01";

		} else {

			$num         = substr($compra, 0);
	        $dig         = $num + 1;
	        $codigofinal = str_pad($dig, 2, "0", STR_PAD_LEFT);
	        $codcompra   = $codigofinal;
		}
	    ################ CREO CODIGO DE COMPRA ###############

	    ############################ REGISTRO COMPRAS ############################
		$query = "INSERT INTO compras values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codcompra);
		$stmt->bindParam(2, $codfactura);
		$stmt->bindParam(3, $codproveedor);
		$stmt->bindParam(4, $subtotalivasi);
		$stmt->bindParam(5, $subtotalivano);
		$stmt->bindParam(6, $iva);
		$stmt->bindParam(7, $totaliva);
		$stmt->bindParam(8, $descontado);
		$stmt->bindParam(9, $descuento);
		$stmt->bindParam(10, $totaldescuento);
		$stmt->bindParam(11, $totalpago);
		$stmt->bindParam(12, $gastoenvio);
		$stmt->bindParam(13, $creditopagado);
		$stmt->bindParam(14, $tipocompra);
		$stmt->bindParam(15, $formacompra);
		$stmt->bindParam(16, $fechavencecredito);
		$stmt->bindParam(17, $fechapagado);
		$stmt->bindParam(18, $statuscompra);
		$stmt->bindParam(19, $fechaemision);
		$stmt->bindParam(20, $fecharecepcion);
		$stmt->bindParam(21, $observaciones);
		$stmt->bindParam(22, $codigo);
		$stmt->bindParam(23, $codsucursal);
	   
		$codfactura        = limpiar($_POST["codfactura"]);
		$codproveedor      = limpiar(decrypt($_POST["codproveedor"]));
		$subtotalivasi     = limpiar($_POST["txtsubtotal"]);
		$subtotalivano     = limpiar($_POST["txtsubtotal2"]);
		$iva               = limpiar($_POST["iva"]);
		$totaliva          = limpiar($_POST["txtIva"]);
		$descontado        = limpiar($_POST["txtdescontado"]);
		$descuento         = limpiar($_POST["descuento"]);
		$totaldescuento    = limpiar($_POST["txtDescuento"]);
		$totalpago         = limpiar($_POST["txtTotal"]);
		$gastoenvio        = limpiar($_POST["gastoenvio"]);
		$creditopagado     = limpiar("0.00");
		$tipocompra        = limpiar($_POST["tipocompra"]);
		$formacompra       = limpiar($_POST["tipocompra"] == "CONTADO" ? $_POST["formacompra"] : "CREDITO");
		$fechavencecredito = limpiar($_POST["tipocompra"] == "CREDITO" ? date("Y-m-d",strtotime($_POST['fechavencecredito'])) : "0000-00-00");
	    $fechapagado       = limpiar("0000-00-00");
		$statuscompra      = limpiar($_POST["tipocompra"] == "CONTADO" ? "PAGADA" : "PENDIENTE");
	    $fechaemision      = limpiar(date("Y-m-d",strtotime($_POST['fechaemision'])));
	    $fecharecepcion    = limpiar(date("Y-m-d",strtotime($_POST['fecharecepcion'])));
	    $observaciones     = limpiar($_POST["observaciones"]);
		$codigo            = limpiar($_SESSION["codigo"]);
		$codsucursal       = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();
		############################ REGISTRO COMPRAS ############################

    $this->dbh->beginTransaction();
	for($i=0;$i<count($_POST['coddetallepedido']);$i++){  //recorro el array
	   if (!empty($_POST['coddetallepedido'][$i])) {

			############### VERIFICO LA EXISTENCIA DEL PRODUCTO EN ALMACEN ################
			$sql = "SELECT * FROM productos 
			WHERE idproducto = '".limpiar($_POST['idproducto'][$i])."' 
			AND codproducto = '".limpiar($_POST['codproducto'][$i])."' 
			AND codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."'";
			foreach ($this->dbh->query($sql) as $row)
			{
				$this->p[] = $row;
			}
			$existenciabd = $row['existencia'];
			############### VERIFICO LA EXISTENCIA DEL PRODUCTO EN ALMACEN ################

			############################ REGISTRO DETALLES DE COMPRAS ############################
			$query = "INSERT INTO detallecompras values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
			$stmt = $this->dbh->prepare($query);
			$stmt->bindParam(1, $codcompra);
		    $stmt->bindParam(2, $idproducto);
		    $stmt->bindParam(3, $codproducto);
		    $stmt->bindParam(4, $producto);
		    $stmt->bindParam(5, $descripcion);
            $stmt->bindParam(6, $opcionvendido);
		    $stmt->bindParam(7, $imei);
		    $stmt->bindParam(8, $condicion);
		    $stmt->bindParam(9, $codmarca);
		    $stmt->bindParam(10, $codmodelo);
		    $stmt->bindParam(11, $codpresentacion);
		    $stmt->bindParam(12, $codcolor);
			$stmt->bindParam(13, $preciocompra);
			$stmt->bindParam(14, $precioxmayor);
			$stmt->bindParam(15, $precioxmenor);
			$stmt->bindParam(16, $precioxpublico);
			$stmt->bindParam(17, $cantcompra);
			$stmt->bindParam(18, $ivaproducto);
			$stmt->bindParam(19, $descproducto);
			$stmt->bindParam(20, $descfactura);
			$stmt->bindParam(21, $valortotal);
			$stmt->bindParam(22, $totaldescuentoc);
			$stmt->bindParam(23, $subtotalimpuestos);
			$stmt->bindParam(24, $valorneto);
			$stmt->bindParam(25, $lote);
			$stmt->bindParam(26, $fechaelaboracion);
			$stmt->bindParam(27, $fechaoptimo);
			$stmt->bindParam(28, $fechamedio);
			$stmt->bindParam(29, $fechaminimo);
			$stmt->bindParam(30, $stockoptimo);
			$stmt->bindParam(31, $stockmedio);
			$stmt->bindParam(32, $stockminimo);
			$stmt->bindParam(33, $codsucursal);
				
			$idproducto        = limpiar($_POST['idproducto'][$i]);
			$codproducto       = limpiar($_POST['codproducto'][$i]);
			$producto          = limpiar($_POST['producto'][$i]);
			$descripcion       = limpiar($_POST['descripcion'][$i]);
			$opcionvendido     = limpiar($_POST['opcionvendido'][$i]);
			$imei              = limpiar($_POST['imei'][$i]);
			$condicion         = limpiar($_POST['condicion'][$i]);
			$codmarca          = limpiar($_POST['codmarca'][$i]);
			$codmodelo         = limpiar($_POST['codmodelo'][$i]);
			$codpresentacion   = limpiar($_POST['codpresentacion'][$i]);
			$codcolor          = limpiar($_POST['codcolor'][$i]);
			$preciocompra      = limpiar($_POST['preciocompra'][$i]);
			$precioxmayor      = limpiar($_POST['precioxmayor'][$i]);
			$precioxmenor      = limpiar($_POST['precioxmenor'][$i]);
			$precioxpublico    = limpiar($_POST['precioxpublico'][$i]);
			$cantcompra        = $_POST['opcionvendido'][$i] == "2" ? number_format($_POST['cantidad'][$i], 3, '.', '') : number_format($_POST['cantidad'][$i], 0, '.', '');
			$ivaproducto       = limpiar($_POST['ivaproducto'][$i]);
			$descproducto      = limpiar($_POST['descproducto'][$i]);
			$descfactura       = limpiar($_POST['descfactura'][$i]);
			$valortotal        = number_format($_POST['valortotal'][$i], 2, '.', '');
			$totaldescuentoc   = number_format($_POST['totaldescuentoc'][$i], 2, '.', '');
			$subtotalimpuestos = number_format($_POST['subtotalimpuestos'][$i], 2, '.', '');
			$valorneto         = number_format($_POST['valorneto'][$i], 2, '.', '');
			$lote              = limpiar($row['lote']);
			$fechaelaboracion  = limpiar($row['fechaelaboracion']);
			$fechaoptimo       = limpiar($row['fechaoptimo']);
			$fechamedio        = limpiar($row['fechamedio']);
			$fechaminimo       = limpiar($row['fechaminimo']);
			$stockoptimo       = limpiar($row['stockoptimo']);
			$stockmedio        = limpiar($row['stockmedio']);
			$stockminimo       = limpiar($row['stockminimo']);
			$codsucursal       = limpiar(decrypt($_POST["codsucursal"]));
			$stmt->execute();
			############################ REGISTRO DETALLES DE COMPRAS ############################

			##################### ACTUALIZAMOS LA EXISTENCIA DE PRODUCTOS #####################
			$sql = "UPDATE productos set "
				." lote = ?, "
			    ." preciocompra = ?, "
				." precioxmayor = ?, "
				." precioxmenor = ?, "
				." precioxpublico = ?, "
				." existencia = ?, "
				." stockoptimo = ?, "
				." stockmedio = ?, "
				." stockminimo = ?, "
				." ivaproducto = ?, "
				." descproducto = ?, "
				." fechaelaboracion = ?, "
				." fechaoptimo = ?, "
				." fechamedio = ?, "
				." fechaminimo = ?, "
				." codproveedor = ? "
				." WHERE "
				." idproducto = ? AND codproducto = ? AND codsucursal = ?;
				";
			$stmt = $this->dbh->prepare($sql);
			$stmt->bindParam(1, $lote);
			$stmt->bindParam(2, $preciocompra);
			$stmt->bindParam(3, $precioxmayor);
			$stmt->bindParam(4, $precioxmenor);
			$stmt->bindParam(5, $precioxpublico);
			$stmt->bindParam(6, $existencia);
			$stmt->bindParam(7, $stockoptimo);
			$stmt->bindParam(8, $stockmedio);
			$stmt->bindParam(9, $stockminimo);
			$stmt->bindParam(10, $ivaproducto);
			$stmt->bindParam(11, $descproducto);
			$stmt->bindParam(12, $fechaelaboracion);
			$stmt->bindParam(13, $fechaoptimo);
			$stmt->bindParam(14, $fechamedio);
			$stmt->bindParam(15, $fechaminimo);
			$stmt->bindParam(16, $codproveedor);
			$stmt->bindParam(17, $idproducto);
			$stmt->bindParam(18, $codproducto);
			$stmt->bindParam(19, $codsucursal);
			
			$lote             = limpiar($row['lote']);
			$preciocompra     = limpiar($_POST['preciocompra'][$i]);
			$precioxmayor     = limpiar($_POST['precioxmayor'][$i]);
			$precioxmenor     = limpiar($_POST['precioxmenor'][$i]);
			$precioxpublico   = limpiar($_POST['precioxpublico'][$i]);
			$existencia       = $_POST['opcionvendido'][$i] == "2" ? number_format($_POST['cantidad'][$i]+$existenciabd, 3, '.', '') : number_format($_POST['cantidad'][$i]+$existenciabd, 0, '.', '');
			$stockoptimo      = limpiar($row['stockoptimo']);
			$stockmedio       = limpiar($row['stockmedio']);
			$stockminimo      = limpiar($row['stockminimo']);
			$ivaproducto      = limpiar($_POST['ivaproducto'][$i] == "0.00" ? "NO" : "SI");
			$descproducto     = limpiar($_POST['descproducto'][$i]);
			$fechaelaboracion = limpiar($row['fechaelaboracion']);
			$fechaoptimo      = limpiar($row['fechaoptimo']);
			$fechamedio       = limpiar($row['fechamedio']);
			$fechaminimo      = limpiar($row['fechaminimo']);
			$codproveedor     = limpiar(decrypt($_POST['codproveedor']));
			$idproducto       = limpiar($_POST['idproducto'][$i]);
			$codproducto      = limpiar($_POST['codproducto'][$i]);
			$codsucursal      = limpiar(decrypt($_POST['codsucursal']));
			$stmt->execute();
			##################### ACTUALIZAMOS LA EXISTENCIA DE PRODUCTOS #####################

			##################### REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX #####################
		    $query = "INSERT INTO kardex values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
			$stmt = $this->dbh->prepare($query);
			$stmt->bindParam(1, $codcompra);
			$stmt->bindParam(2, $codproveedor);
			$stmt->bindParam(3, $codproducto);
			$stmt->bindParam(4, $movimiento);
			$stmt->bindParam(5, $entradas);
			$stmt->bindParam(6, $salidas);
			$stmt->bindParam(7, $devolucion);
			$stmt->bindParam(8, $stockactual);
			$stmt->bindParam(9, $ivaproducto);
			$stmt->bindParam(10, $descproducto);
			$stmt->bindParam(11, $precio);
			$stmt->bindParam(12, $documento);
			$stmt->bindParam(13, $fechakardex);	
			$stmt->bindParam(14, $tipokardex);	
			$stmt->bindParam(15, $procedimiento);		
			$stmt->bindParam(16, $codsucursal);
			$stmt->bindParam(17, $codigo);

			$codproveedor  = limpiar(decrypt($_POST["codproveedor"]));
			$codproducto   = limpiar($_POST['codproducto'][$i]);
			$movimiento    = limpiar("ENTRADAS");
			$entradas      = limpiar($_POST['cantidad'][$i]);
			$salidas       = $_POST['opcionvendido'][$i] == "2" ? "0.000" : "0";
			$devolucion    = $_POST['opcionvendido'][$i] == "2" ? "0.000" : "0";
			$stockactual   = $_POST['opcionvendido'][$i] == "2" ? number_format($_POST['cantidad'][$i]+$existenciabd, 3, '.', '') : number_format($_POST['cantidad'][$i]+$existenciabd, 0, '.', '');
			$precio        = limpiar($_POST['preciocompra'][$i]);
			$ivaproducto   = limpiar($_POST['ivaproducto'][$i]);
			$descproducto  = limpiar($_POST['descproducto'][$i]);
			$documento     = limpiar("COMPRA (PEDIDO PROCESADO): ".$_POST['codfactura']);
			$fechakardex   = limpiar(date("Y-m-d"));
			$tipokardex    = limpiar("1");
			$procedimiento = limpiar("1");
			$codsucursal   = limpiar(decrypt($_POST["codsucursal"]));
			$codigo        = limpiar($_SESSION["codigo"]);
			$stmt->execute();
			##################### REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX #####################
        }
    }
    $this->dbh->commit();

    ##################### ACTUALIZO PEDIDO A PROCESADO ####################
	$sql = "UPDATE pedidos set "
	." procesada = ? "
	." WHERE "
	." codpedido = '".limpiar(decrypt($_POST["codpedido"]))."' 
	AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."';
	";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $procesada);

	$procesada = limpiar("0");
	$stmt->execute();
    ##################### ACTUALIZO PEDIDO A PROCESADO ####################

	    echo "<span class='fa fa-check-square-o'></span> LA COMPRA DE PRODUCTOS HA SIDO REGISTRADA EXITOSAMENTE <a href='reportepdf?codcompra=".encrypt($codcompra)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt("FACTURACOMPRA")."' class='on-default' data-placement='left' data-toggle='tooltip' data-original-title='Imprimir Documento' target='_black' rel='noopener noreferrer'><font color='black'><strong>IMPRIMIR REPORTE</strong></font color></a>";

        echo "<script>VentanaCentrada('reportepdf?codcompra=".encrypt($codcompra)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt("FACTURACOMPRA")."', '', '', '1024', '568', 'true');</script>";
	    exit;
    }
	else
	{
		echo "4";
		exit;
	}
}
########################### FUNCION PROCESAR PEDIDOS A COMPRA ############################

########################## FUNCION ELIMINAR DETALLES PEDIDOS #########################
public function EliminarDetallesPedidos()
{
	$this->p = [];
	if ($_SESSION['acceso'] == "administradorG" || $_SESSION["acceso"]=="administradorS") {

	############ CONSULTO TOTAL ACTUAL DE PEDIDO ##############
	$sql = "SELECT
	iva,
	descuento,
	totalpago 
	FROM pedidos 
	WHERE codpedido = '".limpiar(decrypt($_GET["codpedido"]))."' 
	AND codsucursal = '".limpiar(decrypt($_GET["codsucursal"]))."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$ivabd       = $row["iva"]/100;
	$descuentobd = $row["descuento"]/100;
	$totalpagobd = $row['totalpago'];
	############ CONSULTO TOTAL ACTUAL DE PEDIDO ##############

	$sql = "SELECT * FROM detallepedidos WHERE codpedido = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codpedido"]),decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();
	if($num > 1)
	{
		########## ELIMINAMOS EL PRODUCTO EN DETALLE DE PEDIDO ###########
		$sql = "DELETE FROM detallepedidos WHERE coddetallepedido = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$coddetallepedido);
		$stmt->bindParam(2,$codsucursal);
		$coddetallepedido = decrypt($_GET["coddetallepedido"]);
		$codsucursal      = decrypt($_GET["codsucursal"]);
		$stmt->execute();
		########## ELIMINAMOS EL PRODUCTO EN DETALLE DE PEDIDO ###########

        ############ SUMO LOS IMPORTE DE PRODUCTOS CON IVA ##############
		$sql3 = "SELECT SUM(totaldescuentoc) AS totaldescuentosi, SUM(subtotalimpuestos) AS subtotalimpuestos, SUM(valorneto-subtotalimpuestos) AS valorneto FROM detallepedidos WHERE codpedido = '".limpiar(decrypt($_GET["codpedido"]))."' AND codsucursal = '".limpiar(decrypt($_GET["codsucursal"]))."' AND ivaproducto != '0.00'";
		foreach ($this->dbh->query($sql3) as $row3)
		{
			$this->p[] = $row3;
		}
		$subtotaldescuentosi = ($row3['totaldescuentosi']== "" ? "0.00" : $row3['totaldescuentosi']);
		$subtotalimpuestos   = ($row3['subtotalimpuestos']== "" ? "0.00" : $row3['subtotalimpuestos']);
		$subtotalivasi       = ($row3['valorneto']== "" ? "0.00" : $row3['valorneto']);
		############ SUMO LOS IMPORTE DE PRODUCTOS CON IVA ##############

	    ############ SUMO LOS IMPORTE DE PRODUCTOS SIN IVA ##############
		$sql4 = "SELECT SUM(totaldescuentoc) AS totaldescuentono, SUM(valorneto) AS valorneto FROM detallepedidos WHERE codpedido = '".limpiar(decrypt($_GET["codpedido"]))."' AND codsucursal = '".limpiar(decrypt($_GET["codsucursal"]))."' AND ivaproducto = '0.00'";
		foreach ($this->dbh->query($sql4) as $row4)
		{
			$this->p[] = $row4;
		}
		$subtotaldescuentono = ($row4['totaldescuentono']== "" ? "0.00" : $row4['totaldescuentono']);
		$subtotalivano       = ($row4['valorneto']== "" ? "0.00" : $row4['valorneto']);
		############ SUMO LOS IMPORTE DE PRODUCTOS SIN IVA ##############

		############ ACTUALIZO LOS TOTALES EN PEDIDO ##############
		$sql = " UPDATE pedidos SET "
		." subtotalivasi = ?, "
		." subtotalivano = ?, "
		." totaliva = ?, "
		." descontado = ?, "
		." totaldescuento = ?, "
		." totalpago = ? "
		." WHERE "
		." codpedido = ? AND codsucursal = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $subtotalivasi);
		$stmt->bindParam(2, $subtotalivano);
		$stmt->bindParam(3, $totaliva);
		$stmt->bindParam(4, $descontado);
		$stmt->bindParam(5, $totaldescuento);
		$stmt->bindParam(6, $totalpago);
		$stmt->bindParam(7, $codpedido);
		$stmt->bindParam(8, $codsucursal);

		$totaliva       = number_format($subtotalimpuestos, 2, '.', '');
		$descontado     = number_format($subtotaldescuentosi+$subtotaldescuentono, 2, '.', '');
	    $total          = number_format($subtotalivasi+$subtotalivano+$totaliva, 2, '.', '');
	    $totaldescuento = number_format($total*$descuentobd, 2, '.', '');
	    $totalpago      = number_format($total-$totaldescuento, 2, '.', '');
		$codpedido      = limpiar(decrypt($_GET["codpedido"]));
		$codsucursal    = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();
		############ ACTUALIZO LOS TOTALES EN PEDIDO ##############

		echo "1";
		exit;

	} else {
		   
		echo "2";
		exit;
	} 
			
	} else {
		
		echo "3";
		exit;
	}	
}
######################## FUNCION ELIMINAR DETALLES PEDIDOS #########################

######################### FUNCION ELIMINAR PEDIDOS ###############################
public function EliminarPedidos()
{
	$this->p = [];
	if ($_SESSION['acceso'] == "administradorG" || $_SESSION["acceso"]=="administradorS") {

		#################### ELIMINO PEDIDO ####################
		$sql = "DELETE FROM pedidos WHERE codpedido = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codpedido);
		$stmt->bindParam(2,$codsucursal);
		$codpedido   = decrypt($_GET["codpedido"]);
		$codsucursal = decrypt($_GET["codsucursal"]);
		$stmt->execute();
		#################### ELIMINO PEDIDO ####################

		#################### ELIMINO DETALLE DE PEDIDO ####################
		$sql = "DELETE FROM detallepedidos WHERE codpedido = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codpedido);
		$stmt->bindParam(2,$codsucursal);
		$codpedido   = decrypt($_GET["codpedido"]);
		$codsucursal = decrypt($_GET["codsucursal"]);
		$stmt->execute();
		#################### ELIMINO DETALLE DE PEDIDO ####################

		echo "1";
		exit;

	} else {

		echo "2";
		exit;
	}
}
####################### FUNCION ELIMINAR PEDIDOS #################################

###################### FUNCION BUSQUEDA PEDIDOS POR PROVEEDORES ######################
public function BuscarPedidosxProveedor() 
{
	$this->p = [];
	$tipoAcceso      = isset($_SESSION["acceso"]) ? limpiar($_SESSION["acceso"]) : '';
	$codSucursal     = isset($_GET["codsucursal"]) ? limpiar(decrypt($_GET["codsucursal"])) : '';	
    $codProveedorBusqueda = isset($_GET['codproveedor']) ? decrypt(trim($_GET['codproveedor'])) : null;
    $whereConditions = [];
    $params          = [];

    $sqlBase = "SELECT
        ped.codpedido, ped.codfactura, ped.codproveedor, ped.subtotalivasi, ped.subtotalivano, 
		ped.iva, ped.totaliva, ped.descontado, ped.descuento, ped.totaldescuento, 
		ped.totalpago, ped.observaciones, ped.fechapedido, ped.procesada, ped.codsucursal,
		suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
		suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
		tm.moneda, tm.siglas, tm.simbolo,
		usu.dni, usu.nombres,
		pro.documproveedor, pro.documproveedor, pro.cuitproveedor, pro.nomproveedor,
		pro.tlfproveedor, pro.direcproveedor, pro.vendedor,
		doc.documento, doc2.documento AS documento2, doc3.documento AS documento3,
		pag.articulos, pag.detalles_productos
    FROM 
        pedidos ped LEFT JOIN sucursales suc ON ped.codsucursal = suc.codsucursal 
	LEFT JOIN 
	    documentos doc ON suc.documsucursal = doc.coddocumento
	LEFT JOIN 
	    documentos AS doc2 ON suc.documencargado = doc2.coddocumento
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
	LEFT JOIN 
	    proveedores pro ON ped.codproveedor = pro.codproveedor
	LEFT JOIN 
	    documentos AS doc3 ON pro.documproveedor = doc3.coddocumento
	LEFT JOIN 
	    usuarios usu ON ped.codigo = usu.codigo
    LEFT JOIN
        (SELECT
            dp.codpedido,
            SUM(dp.cantidad) AS articulos,
            GROUP_CONCAT(
            CONCAT_WS(
               ' | ',
               dp.cantidad,
               dp.producto,
               dp.descripcion,
               IFNULL(mar.nommarca, ''),
               IFNULL(mode.nommodelo, ''),
               IFNULL(pres.nompresentacion, ''),
               IFNULL(col.nomcolor, '')
            )
                ORDER BY dp.producto
                SEPARATOR '<br>'
            ) AS detalles_productos
            FROM
                detallepedidos dp
            LEFT JOIN 
                marcas mar ON dp.codmarca = mar.codmarca
		    LEFT JOIN 
		        modelos mode ON dp.codmodelo = mode.codmodelo 
		    LEFT JOIN 
		        presentaciones pres ON dp.codpresentacion = pres.codpresentacion
			LEFT JOIN 
			    colores col ON dp.codcolor = col.codcolor
			WHERE dp.codsucursal = ?
	    GROUP BY
	        dp.codpedido
	    ) pag ON pag.codpedido = ped.codpedido";
	//Condicion de Sucursal
    if (!empty($codSucursal)) {
        $whereConditions[] = "ped.codsucursal = ?";
        $params[]          = $codSucursal;
    }
    //Condicion de Proveedor
    if (!empty($codProveedorBusqueda)) { // Asegurarse de que codcaja exista
        $whereConditions[] = "ped.codproveedor = ?";
        $params[] = $codProveedorBusqueda;
    }
    $whereClause = "";
    if (!empty($whereConditions)) {
        $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $sql = $sqlBase . $whereClause . " ORDER BY ped.fechapedido DESC";
    try {
	    $stmt = $this->dbh->prepare($sql);
        array_unshift($params, $codSucursal);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
	    if (empty($results)) {
	        echo "<div class='alert alert-danger'>";
	        echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	        echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS PARA TU BÚSQUEDA REALIZADA</center>";
	        echo "</div>";
	        exit();
	    } else {
	        return $results;
	    }
	} catch (PDOException $e) {
	    error_log("Error en BuscarPedidosxProveedor: " . $e->getMessage());
	    echo "<div class='alert alert-danger'>";
	    echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	    echo "<center><span class='fa fa-exclamation-triangle'></span> OCURRIÓ UN ERROR AL CONSULTAR LAS VENTAS.</center>";
	    echo "</div>";
	    return [];
	}
}
###################### FUNCION BUSQUEDA PEDIDOS POR PROVEEDORES ######################

###################### FUNCION BUSQUEDA PEDIDOS POR FECHAS ######################
public function BuscarPedidosxFechas() 
{
	$this->p = [];
	$tipoAcceso      = isset($_SESSION["acceso"]) ? limpiar($_SESSION["acceso"]) : '';
	$codSucursal     = isset($_GET["codsucursal"]) ? limpiar(decrypt($_GET["codsucursal"])) : '';	
    $fechaDesde      = isset($_GET['desde']) ? limpiar(date("Y-m-d", strtotime($_GET['desde']))) : '';
    $fechaHasta      = isset($_GET['hasta']) ? limpiar(date("Y-m-d", strtotime($_GET['hasta']))) : '';
    $whereConditions = [];
    $params          = [];

    $sqlBase = "SELECT
        ped.codpedido, ped.codfactura, ped.codproveedor, ped.subtotalivasi, ped.subtotalivano, 
		ped.iva, ped.totaliva, ped.descontado, ped.descuento, ped.totaldescuento, 
		ped.totalpago, ped.observaciones, ped.fechapedido, ped.procesada, ped.codsucursal,
		suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
		suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
		tm.moneda, tm.siglas, tm.simbolo,
		usu.dni, usu.nombres,
		pro.documproveedor, pro.documproveedor, pro.cuitproveedor, pro.nomproveedor,
		pro.tlfproveedor, pro.direcproveedor, pro.vendedor,
		doc.documento, doc2.documento AS documento2, doc3.documento AS documento3,
		pag.articulos, pag.detalles_productos
    FROM 
        pedidos ped LEFT JOIN sucursales suc ON ped.codsucursal = suc.codsucursal 
	LEFT JOIN 
	    documentos doc ON suc.documsucursal = doc.coddocumento
	LEFT JOIN 
	    documentos AS doc2 ON suc.documencargado = doc2.coddocumento
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
	LEFT JOIN 
	    proveedores pro ON ped.codproveedor = pro.codproveedor
	LEFT JOIN 
	    documentos AS doc3 ON pro.documproveedor = doc3.coddocumento
	LEFT JOIN 
	    usuarios usu ON ped.codigo = usu.codigo
    LEFT JOIN
        (SELECT
            dp.codpedido,
            SUM(dp.cantidad) AS articulos,
            GROUP_CONCAT(
            CONCAT_WS(
               ' | ',
               dp.cantidad,
               dp.producto,
               dp.descripcion,
               IFNULL(mar.nommarca, ''),
               IFNULL(mode.nommodelo, ''),
               IFNULL(pres.nompresentacion, ''),
               IFNULL(col.nomcolor, '')
            )
                ORDER BY dp.producto
                SEPARATOR '<br>'
            ) AS detalles_productos
            FROM
                detallepedidos dp
            LEFT JOIN 
                marcas mar ON dp.codmarca = mar.codmarca
		    LEFT JOIN 
		        modelos mode ON dp.codmodelo = mode.codmodelo 
		    LEFT JOIN 
		        presentaciones pres ON dp.codpresentacion = pres.codpresentacion
			LEFT JOIN 
			    colores col ON dp.codcolor = col.codcolor
			WHERE dp.codsucursal = ?
	    GROUP BY
	        dp.codpedido
	    ) pag ON pag.codpedido = ped.codpedido";
	//Condicion de Sucursal
    if (!empty($codSucursal)) {
        $whereConditions[] = "ped.codsucursal = ?";
        $params[]          = $codSucursal;
    }
    //Condicion de Fechas
    if (!empty($fechaDesde) && !empty($fechaHasta)) {
        $whereConditions[] = "DATE_FORMAT(ped.fechapedido,'%Y-%m-%d') BETWEEN ? AND ?";
        $params[] = $fechaDesde;
        $params[] = $fechaHasta;
    }
    $whereClause = "";
    if (!empty($whereConditions)) {
        $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $sql = $sqlBase . $whereClause . " ORDER BY ped.fechapedido DESC";
    try {
	    $stmt = $this->dbh->prepare($sql);
        array_unshift($params, $codSucursal);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
	    if (empty($results)) {
	        echo "<div class='alert alert-danger'>";
	        echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	        echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS PARA TU BÚSQUEDA REALIZADA</center>";
	        echo "</div>";
	        exit();
	    } else {
	        return $results;
	    }
	} catch (PDOException $e) {
	    error_log("Error en BuscarPedidosxFechas: " . $e->getMessage());
	    echo "<div class='alert alert-danger'>";
	    echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	    echo "<center><span class='fa fa-exclamation-triangle'></span> OCURRIÓ UN ERROR AL CONSULTAR LAS VENTAS.</center>";
	    echo "</div>";
	    return [];
	}
}
###################### FUNCION BUSQUEDA PEDIDOS POR FECHAS ######################

############################# FIN DE CLASE PEDIDOS #################################


















################################# CLASE PRODUCTOS ######################################

############################### FUNCION CARGAR PRODUCTOS ##############################
public function CargarProductos()
{
	$this->p = [];
	if(empty($_FILES["sel_file"]) or empty($_POST["codsucursal"]))
	{
		echo "1";
		exit;
	}

	############## OBTENGO VALOR DE IMPUESTO #################
	$sql = "SELECT 
	valorimpuesto 
	FROM impuestos 
	WHERE statusimpuesto = 1";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$valor = (empty($row['valorimpuesto']) ? "0.00" : $row['valorimpuesto']);
	############## OBTENGO VALOR DE IMPUESTO #################

    //$porcentaje=($_SESSION['acceso']=="administradorG" ? "0.00" : $_SESSION['porcentaje']);

    //Aquí es donde seleccionamos nuestro csv
    $fname = $_FILES['sel_file']['name'];
    //echo 'Cargando nombre del archivo: '.$fname.' ';
    $chk_ext = explode(".",$fname);
     
    if(strtolower(end($chk_ext)) == "csv")
    {
    //si es correcto, entonces damos permisos de lectura para subir
    $filename = $_FILES['sel_file']['tmp_name'];
    $handle   = fopen($filename, "r");
    $this->dbh->beginTransaction();
    
    $primera = true;
    while (($data = fgetcsv($handle, 1000, ";")) !== FALSE) {
    // Evitamos la primer línea
    if ($primera){
        $primera = false;
        continue;
    }

        //Insertamos los datos con los valores...
        $query = "INSERT INTO productos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
    	$stmt = $this->dbh->prepare($query);
    	$stmt->bindParam(1, $codproducto);
    	$stmt->bindParam(2, $producto);
    	$stmt->bindParam(3, $descripcion);
    	$stmt->bindParam(4, $opcionvendido);
    	$stmt->bindParam(5, $imei);
    	$stmt->bindParam(6, $condicion);
    	$stmt->bindParam(7, $fabricante);
    	$stmt->bindParam(8, $codfamilia);
    	$stmt->bindParam(9, $codsubfamilia);
    	$stmt->bindParam(10, $codmarca);
    	$stmt->bindParam(11, $codmodelo);
    	$stmt->bindParam(12, $codpresentacion);
    	$stmt->bindParam(13, $codcolor);
    	$stmt->bindParam(14, $codorigen);
    	$stmt->bindParam(15, $year);
    	$stmt->bindParam(16, $nroparte);
    	$stmt->bindParam(17, $lote);
    	$stmt->bindParam(18, $peso);
    	$stmt->bindParam(19, $preciocompra);
    	$stmt->bindParam(20, $precioxmayor);
    	$stmt->bindParam(21, $precioxmenor);
    	$stmt->bindParam(22, $precioxpublico);
    	$stmt->bindParam(23, $existencia);
    	$stmt->bindParam(24, $stockoptimo);
    	$stmt->bindParam(25, $stockmedio);
    	$stmt->bindParam(26, $stockminimo);
    	$stmt->bindParam(27, $ivaproducto);
    	$stmt->bindParam(28, $descproducto);
    	$stmt->bindParam(29, $codigobarra);
    	$stmt->bindParam(30, $fechaelaboracion);
    	$stmt->bindParam(31, $fechaoptimo);
    	$stmt->bindParam(32, $fechamedio);
    	$stmt->bindParam(33, $fechaminimo);
    	$stmt->bindParam(34, $codproveedor);
    	$stmt->bindParam(35, $stockteorico);
    	$stmt->bindParam(36, $motivoajuste);
    	$stmt->bindParam(37, $codsucursal);

    	$codproducto      = limpiar($data[0]);
    	$producto         = utf8_encode($data[1]);
    	$descripcion      = limpiar($data[2]);
    	$opcionvendido    = limpiar($data[3]);
    	$imei             = utf8_encode($data[4]);
    	$condicion        = limpiar($data[5] != '' ? $data[5] : '0');
    	$fabricante       = utf8_encode($data[6]);
    	$codfamilia       = limpiar($data[7]);
    	$codsubfamilia    = limpiar($data[8]);
    	$codmarca         = limpiar($data[9]);
    	$codmodelo        = limpiar($data[10]);
    	$codpresentacion  = limpiar($data[11]);
    	$codcolor         = limpiar($data[12]);
    	$codorigen        = limpiar($data[13]);
    	$year             = limpiar($data[14]);
    	$nroparte         = limpiar($data[15]);
    	$lote             = limpiar($data[16]);
    	$peso             = limpiar($data[17]);
    	$preciocompra     = limpiar($data[18]);
    	$precioxmayor     = limpiar($data[19]);
    	$precioxmenor     = limpiar($data[20]);
    	$precioxpublico   = limpiar($data[21]);
    	$existencia       = limpiar($data[22]);
    	$stockoptimo      = limpiar("0");
    	$stockmedio       = limpiar("0");
    	$stockminimo      = limpiar($data[23]);
    	$ivaproducto      = limpiar($data[24]);
    	$descproducto     = limpiar($data[25]);
    	$codigobarra      = utf8_encode($data[26]);
    	$fechaelaboracion = limpiar($data[27]);
    	$fechaoptimo      = limpiar($data[28]);
    	$fechamedio       = limpiar("0000-00-00");
    	$fechaminimo      = limpiar("0000-00-00");
    	$codproveedor     = limpiar($data[29]);
    	$stockteorico     = limpiar("0");
    	$motivoajuste     = limpiar("NINGUNO");
    	$codsucursal      = limpiar(decrypt($_POST["codsucursal"]));
    	$stmt->execute();

    	##################### REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX #####################
		$query = "INSERT INTO kardex values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codproceso);
		$stmt->bindParam(2, $codresponsable);
		$stmt->bindParam(3, $codproducto);
		$stmt->bindParam(4, $movimiento);
		$stmt->bindParam(5, $entradas);
		$stmt->bindParam(6, $salidas);
		$stmt->bindParam(7, $devolucion);
		$stmt->bindParam(8, $stockactual);
		$stmt->bindParam(9, $ivaproducto);
		$stmt->bindParam(10, $descproducto);
		$stmt->bindParam(11, $precio);
		$stmt->bindParam(12, $documento);
		$stmt->bindParam(13, $fechakardex);
		$stmt->bindParam(14, $tipokardex);
		$stmt->bindParam(15, $procedimiento);
		$stmt->bindParam(16, $codsucursal);
		$stmt->bindParam(17, $codigo);
		
		$codproceso     = limpiar($data[0]);
		$codresponsable = limpiar("0");
		$codproducto    = limpiar($data[0]);
		$movimiento     = limpiar("ENTRADAS");
		$entradas       = limpiar($data[22]);
		$salidas        = limpiar("0.00");
		$devolucion     = limpiar("0.00");
		$stockactual    = limpiar($data[22]);
		$ivaproducto    = limpiar($data[24] == 'SI' ? $valor : "0.00");
		$descproducto   = limpiar($data[25]);
		$precio         = limpiar("0.00");
		$documento      = limpiar("INVENTARIO INICIAL");
		$fechakardex    = limpiar(date("Y-m-d"));
		$tipokardex     = limpiar("1");
		$procedimiento  = limpiar("1");
    	$codsucursal    = limpiar(decrypt($_POST["codsucursal"]));
    	$codigo         = limpiar($_SESSION["codigo"]);
		$stmt->execute();
		##################### REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX #####################
   }
           
   $this->dbh->commit();
   //cerramos la lectura del archivo "abrir archivo" con un "cerrar archivo"
   fclose($handle);
	        
	echo "<span class='fa fa-check-square-o'></span> LA CARGA MASIVA DE PRODUCTOS FUE REALIZADA EXITOSAMENTE";
	exit;
             
    }
    else
    {
    //si aparece esto es posible que el archivo no tenga el formato adecuado, inclusive cuando es cvs, revisarlo para ver si esta separado por " , "
        echo "2";
		exit;
    }  
}
############################## FUNCION CARGAR PRODUCTOS ##############################

########################### FUNCION REGISTRAR PRODUCTOS ###############################
public function RegistrarProductos()
{
	$this->p = [];
	if(empty($_POST["codproducto"]) or empty($_POST["producto"]) or empty($_POST["codfamilia"]) or empty($_POST["codsucursal"]))
	{
		echo "1";
		exit;
	}
	elseif($_POST["opcionvendido"] == '1' && !ctype_digit(trim($_POST["existencia"])))
	{
		echo "2";
		exit;
	}
	elseif($_POST["opcionvendido"] == '2' && ctype_digit(trim($_POST["existencia"])))
	{
		echo "3";
		exit;
	}

    ############## OBTENGO VALOR DE IMPUESTO #################
	$sql = "SELECT 
	valorimpuesto 
	FROM impuestos 
	WHERE statusimpuesto = 1";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$valor = (empty($row['valorimpuesto']) ? "0.00" : $row['valorimpuesto']);
	############## OBTENGO VALOR DE IMPUESTO #################

	$sql = " SELECT codproducto FROM productos WHERE codproducto = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["codproducto"],decrypt($_POST["codsucursal"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
	    ##################### REGISTRO DE PRODUCTO #####################
	    $query = "INSERT INTO productos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
    	$stmt = $this->dbh->prepare($query);
    	$stmt->bindParam(1, $codproducto);
    	$stmt->bindParam(2, $producto);
    	$stmt->bindParam(3, $descripcion);
    	$stmt->bindParam(4, $opcionvendido);
    	$stmt->bindParam(5, $imei);
    	$stmt->bindParam(6, $condicion);
    	$stmt->bindParam(7, $fabricante);
    	$stmt->bindParam(8, $codfamilia);
    	$stmt->bindParam(9, $codsubfamilia);
    	$stmt->bindParam(10, $codmarca);
    	$stmt->bindParam(11, $codmodelo);
    	$stmt->bindParam(12, $codpresentacion);
    	$stmt->bindParam(13, $codcolor);
    	$stmt->bindParam(14, $codorigen);
    	$stmt->bindParam(15, $year);
    	$stmt->bindParam(16, $nroparte);
    	$stmt->bindParam(17, $lote);
    	$stmt->bindParam(18, $peso);
    	$stmt->bindParam(19, $preciocompra);
    	$stmt->bindParam(20, $precioxmayor);
    	$stmt->bindParam(21, $precioxmenor);
    	$stmt->bindParam(22, $precioxpublico);
    	$stmt->bindParam(23, $existencia);
    	$stmt->bindParam(24, $stockoptimo);
    	$stmt->bindParam(25, $stockmedio);
    	$stmt->bindParam(26, $stockminimo);
    	$stmt->bindParam(27, $ivaproducto);
    	$stmt->bindParam(28, $descproducto);
    	$stmt->bindParam(29, $codigobarra);
    	$stmt->bindParam(30, $fechaelaboracion);
    	$stmt->bindParam(31, $fechaoptimo);
    	$stmt->bindParam(32, $fechamedio);
    	$stmt->bindParam(33, $fechaminimo);
    	$stmt->bindParam(34, $codproveedor);
    	$stmt->bindParam(35, $stockteorico);
    	$stmt->bindParam(36, $motivoajuste);
    	$stmt->bindParam(37, $codsucursal);

		$codproducto      = limpiar($_POST["codproducto"]);
		$producto         = limpiar($_POST["producto"]);
		$descripcion      = limpiar($_POST["descripcion"]);
		$opcionvendido    = limpiar($_POST["opcionvendido"]);
		$imei             = limpiar($_POST["imei"]);
		$condicion        = limpiar($_POST['condicion'] == '' ? "0" : $_POST["condicion"]);
		$fabricante       = limpiar($_POST["modulo"] == 1 ? $_POST["fabricante"] : "");
		$codfamilia       = limpiar($_POST['codfamilia'] == '' ? "0" : decrypt($_POST['codfamilia']));
		
		if(limpiar($_POST["modulo"]) == 1){
		$codsubfamilia    = limpiar($_POST['codsubfamilia'] == '' ? "0" : decrypt($_POST['codsubfamilia']));
		$codmarca         = limpiar($_POST['codmarca'] == '' ? "0" : decrypt($_POST['codmarca']));
		$codmodelo        = limpiar($_POST['codmodelo'] == '' ? "0" : decrypt($_POST['codmodelo']));
		$codpresentacion  = limpiar($_POST['codpresentacion'] == '' ? "0" : decrypt($_POST['codpresentacion']));
		$codcolor         = limpiar($_POST['codcolor'] == '' ? "0" : decrypt($_POST['codcolor']));
		$codorigen        = limpiar($_POST['codorigen'] == '' ? "0" : decrypt($_POST['codorigen']));
		$year             = limpiar($_POST["year"]);
		$nroparte         = limpiar($_POST["nroparte"]);
		$lote             = limpiar($_POST['lote'] == '' ? "0" : $_POST['lote']);
		$peso             = limpiar($_POST["peso"]);
		$fechaelaboracion = limpiar($_POST['fechaelaboracion'] == '' ? "0000-00-00" : date("Y-m-d",strtotime($_POST['fechaelaboracion'])));
		$fechaoptimo      = limpiar($_POST['fechaoptimo'] == '' ? "0000-00-00" : date("Y-m-d",strtotime($_POST['fechaoptimo'])));
		$fechamedio       = limpiar($_POST['fechamedio'] == '' ? "0000-00-00" : date("Y-m-d",strtotime($_POST['fechamedio'])));
		$fechaminimo      = limpiar($_POST['fechaminimo'] == '' ? "0000-00-00" : date("Y-m-d",strtotime($_POST['fechaminimo'])));
		} else {
		$codsubfamilia    = limpiar("0");
		$codmarca         = limpiar($_POST['codmarca'] == '' ? "0" : decrypt($_POST['codmarca']));
		$codmodelo        = limpiar($_POST['codmodelo'] == '' ? "0" : decrypt($_POST['codmodelo']));
		$codpresentacion  = limpiar($_POST['codpresentacion'] == '' ? "0" : decrypt($_POST['codpresentacion']));
		$codcolor         = limpiar($_POST['codcolor'] == '' ? "0" : decrypt($_POST['codcolor']));	
		$codorigen        = limpiar("0");
		$year             = limpiar("0");
		$nroparte         = limpiar("0");
		$lote             = limpiar("0");
		$peso             = limpiar("0");
		$fechaelaboracion = limpiar("0000-00-00");
		$fechaoptimo      = limpiar("0000-00-00");
		$fechamedio       = limpiar("0000-00-00");
		$fechaminimo      = limpiar("0000-00-00");
		}

		$preciocompra     = limpiar($_POST["preciocompra"]);
		$precioxmayor     = limpiar($_POST["modulo"] == 1 ? $_POST["precioxmayor"] : "0.00");
		$precioxmenor     = limpiar($_POST["modulo"] == 1 ? $_POST["precioxmenor"] : "0.00");
		$precioxpublico   = limpiar($_POST["precioxpublico"]);
		//$existencia       = limpiar($_POST['opcionvendido'] == 1 ? number_format($_POST["existencia"], 3, '.', '') : number_format($_POST["existencia"], 0, '.', ''));
		$existencia       = limpiar($_POST["existencia"]);
		$stockoptimo      = limpiar($_POST["modulo"] == 1 ? $_POST["stockoptimo"] : "0.00");
		$stockmedio       = limpiar($_POST["modulo"] == 1 ? $_POST["stockmedio"] : "0.00");
		$stockminimo      = limpiar($_POST["modulo"] == 1 ? $_POST["stockminimo"] : "0.00");
		$ivaproducto      = limpiar($_POST["ivaproducto"]);
		$descproducto     = limpiar($_POST["descproducto"]);
		$codigobarra      = limpiar($_POST["codigobarra"]);
		$codproveedor     = limpiar(decrypt($_POST["codproveedor"]));
		$stockteorico     = limpiar("0");
		$motivoajuste     = limpiar("NINGUNO");
		$codsucursal      = decrypt($_POST["codsucursal"]);
		$stmt->execute();
		##################### REGISTRO DE PRODUCTO #####################

		##################### REGISTRAMOS DATOS DE PRODUCTOS EN KARDEX #####################
		$query = "INSERT INTO kardex values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codproceso);
		$stmt->bindParam(2, $codresponsable);
		$stmt->bindParam(3, $codproducto);
		$stmt->bindParam(4, $movimiento);
		$stmt->bindParam(5, $entradas);
		$stmt->bindParam(6, $salidas);
		$stmt->bindParam(7, $devolucion);
		$stmt->bindParam(8, $stockactual);
		$stmt->bindParam(9, $ivaproducto);
		$stmt->bindParam(10, $descproducto);
		$stmt->bindParam(11, $precio);
		$stmt->bindParam(12, $documento);
		$stmt->bindParam(13, $fechakardex);
		$stmt->bindParam(14, $tipokardex);
		$stmt->bindParam(15, $procedimiento);
		$stmt->bindParam(16, $codsucursal);
		$stmt->bindParam(17, $codigo);

		$codproceso     = limpiar($_POST['codproducto']);
		$codresponsable = limpiar("0");
		$codproducto    = limpiar($_POST['codproducto']);
		$movimiento     = limpiar("ENTRADAS");
		$entradas       = limpiar($_POST['existencia']);
		$salidas        = limpiar("0.00");
		$devolucion     = limpiar("0.00");
		$stockactual    = limpiar($_POST['existencia']);
		$ivaproducto    = limpiar($_POST["ivaproducto"] == 'SI' ? $valor : "0.00");
		$descproducto   = limpiar($_POST["descproducto"]);
		$precio         = limpiar("0.00");
		$documento      = limpiar("INVENTARIO INICIAL");
		$fechakardex    = limpiar(date("Y-m-d"));
		$tipokardex     = limpiar("1");
		$procedimiento  = limpiar("1");
		$codsucursal    = decrypt($_POST["codsucursal"]);
    	$codigo         = limpiar($_SESSION["codigo"]);
		$stmt->execute();
		##################### REGISTRAMOS DATOS DE PRODUCTOS EN KARDEX #####################

		############################## SUBIR FOTO DE PRODUCTO ##############################
		//$dirmake = limpiar(is_dir('./fotos/productos/'.$codproducto) ? "" : mkdir('./fotos/productos/'.$codproducto, 0777));
		$permitidos     = array("image/jpg", "image/jpeg", "image/png");
		$limite_kb      = 0;
	    //datos del arhivo  
	    $nombre_archivo = limpiar(isset($_FILES['imagen']['name']) ? $_FILES['imagen']['name'] : "");
		$tipo_archivo   = limpiar(isset($_FILES['imagen']['type']) ? $_FILES['imagen']['type'] : "");
		$tamano_archivo = limpiar(isset($_FILES['imagen']['size']) ? $_FILES['imagen']['size'] : "");
		$file           = new SplFileInfo($nombre_archivo);
		$extension      = $file->getExtension();
	    //compruebo si las características del archivo son las que deseo 
	    if (!empty($_FILES["imagen"]) && in_array($_FILES['imagen']['type'], $permitidos)){
	 
	      if (move_uploaded_file($_FILES['imagen']['tmp_name'], "./fotos/productos/".$codsucursal."/".$nombre_archivo) && rename("./fotos/productos/".$codsucursal."/".$nombre_archivo,"./fotos/productos/".$codsucursal."/".$codproducto.".".$extension))
		   { 
		   ## se puede dar un aviso
		   } 
		   ## se puede dar otro aviso 
		}
		############################## SUBIR FOTO DE PRODUCTO ##############################

		echo "<span class='fa fa-check-square-o'></span> EL PRODUCTO HA SIDO REGISTRADO EXITOSAMENTE";
		exit;

	} else {

		echo "4";
		exit;
	}
}
########################## FUNCION REGISTRAR PRODUCTOS ###############################

########################### FUNCION REGISTRAR NUEVO PRODUCTO ###############################
public function RegistrarNuevoProducto()
{
	$this->p = [];
	if(empty($_POST["codproducto2"]) or empty($_POST["producto2"]) or empty($_POST["codfamilia2"]) or empty($_POST["codsucursal"]))
	{
		echo "1";
		exit;
	}
	elseif($_POST["opcionvendido2"] == '1' && !ctype_digit(trim($_POST["existencia2"])) && $_POST["existencia2"] > 0)
	{
		echo "2";
		exit;
	}
	elseif($_POST["opcionvendido2"] == '2' && ctype_digit(trim($_POST["existencia2"])) && $_POST["existencia2"] > 0)
	{
		echo "3";
		exit;
	}

    ############## OBTENGO VALOR DE IMPUESTO #################
	$sql = "SELECT 
	valorimpuesto 
	FROM impuestos 
	WHERE statusimpuesto = 1";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$valor = (empty($row['valorimpuesto']) ? "0.00" : $row['valorimpuesto']);
	############## OBTENGO VALOR DE IMPUESTO #################

	$sql = " SELECT codproducto FROM productos WHERE codproducto = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["codproducto2"],decrypt($_POST["codsucursal"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
	    ##################### REGISTRO DE PRODUCTO #####################
	    $query = "INSERT INTO productos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
    	$stmt = $this->dbh->prepare($query);
    	$stmt->bindParam(1, $codproducto);
    	$stmt->bindParam(2, $producto);
    	$stmt->bindParam(3, $descripcion);
    	$stmt->bindParam(4, $opcionvendido);
    	$stmt->bindParam(5, $imei);
    	$stmt->bindParam(6, $condicion);
    	$stmt->bindParam(7, $fabricante);
    	$stmt->bindParam(8, $codfamilia);
    	$stmt->bindParam(9, $codsubfamilia);
    	$stmt->bindParam(10, $codmarca);
    	$stmt->bindParam(11, $codmodelo);
    	$stmt->bindParam(12, $codpresentacion);
    	$stmt->bindParam(13, $codcolor);
    	$stmt->bindParam(14, $codorigen);
    	$stmt->bindParam(15, $year);
    	$stmt->bindParam(16, $nroparte);
    	$stmt->bindParam(17, $lote);
    	$stmt->bindParam(18, $peso);
    	$stmt->bindParam(19, $preciocompra);
    	$stmt->bindParam(20, $precioxmayor);
    	$stmt->bindParam(21, $precioxmenor);
    	$stmt->bindParam(22, $precioxpublico);
    	$stmt->bindParam(23, $existencia);
    	$stmt->bindParam(24, $stockoptimo);
    	$stmt->bindParam(25, $stockmedio);
    	$stmt->bindParam(26, $stockminimo);
    	$stmt->bindParam(27, $ivaproducto);
    	$stmt->bindParam(28, $descproducto);
    	$stmt->bindParam(29, $codigobarra);
    	$stmt->bindParam(30, $fechaelaboracion);
    	$stmt->bindParam(31, $fechaoptimo);
    	$stmt->bindParam(32, $fechamedio);
    	$stmt->bindParam(33, $fechaminimo);
    	$stmt->bindParam(34, $codproveedor);
    	$stmt->bindParam(35, $stockteorico);
    	$stmt->bindParam(36, $motivoajuste);
    	$stmt->bindParam(37, $codsucursal);

		$codproducto      = limpiar($_POST["codproducto2"]);
		$producto         = limpiar($_POST["producto2"]);
		$descripcion      = limpiar($_POST["descripcion2"]);
		$opcionvendido    = limpiar($_POST["opcionvendido2"]);
		$imei             = limpiar($_POST["imei2"]);
		$condicion        = limpiar($_POST['condicion2'] == '' ? "0" : $_POST["condicion2"]);
		$fabricante       = limpiar("0");
		$codfamilia       = limpiar($_POST['codfamilia2'] == '' ? "0" : decrypt($_POST['codfamilia2']));
		$codsubfamilia    = limpiar("0");
		$codmarca         = limpiar($_POST['codmarca2'] == '' ? "0" : decrypt($_POST['codmarca2']));
		$codmodelo        = limpiar($_POST['codmodelo2'] == '' ? "0" : decrypt($_POST['codmodelo2']));
		$codpresentacion  = limpiar($_POST['codpresentacion2'] == '' ? "0" : decrypt($_POST['codpresentacion2']));
		$codcolor         = limpiar($_POST['codcolor2'] == '' ? "0" : decrypt($_POST['codcolor2']));	
		$codorigen        = limpiar("0");
		$year             = limpiar("0");
		$nroparte         = limpiar("0");
		$lote             = limpiar("0");
		$peso             = limpiar("0");
		$preciocompra     = limpiar($_POST["preciocompra2"]);
		$precioxmayor     = limpiar("0.00");
		$precioxmenor     = limpiar("0.00");
		$precioxpublico   = limpiar($_POST["precioxpublico2"]);
		$existencia       = limpiar($_POST["existencia2"]);
		$stockoptimo      = limpiar("0.00");
		$stockmedio       = limpiar("0.00");
		$stockminimo      = limpiar("0.00");
		$ivaproducto      = limpiar($_POST["ivaproducto2"]);
		$descproducto     = limpiar($_POST["descproducto2"]);
		$codigobarra      = limpiar($_POST["codigobarra2"]);
		$fechaelaboracion = limpiar("0000-00-00");
		$fechaoptimo      = limpiar("0000-00-00");
		$fechamedio       = limpiar("0000-00-00");
		$fechaminimo      = limpiar("0000-00-00");
		$codproveedor     = limpiar(decrypt($_POST["codproveedor2"]));
		$stockteorico     = limpiar("0");
		$motivoajuste     = limpiar("NINGUNO");
		$codsucursal      = decrypt($_POST["codsucursal"]);
		$stmt->execute();
		##################### REGISTRO DE PRODUCTO #####################

		echo "<span class='fa fa-check-square-o'></span> EL PRODUCTO HA SIDO REGISTRADO EXITOSAMENTE";
		exit;

	} else {

		echo "4";
		exit;
	}
}
########################## FUNCION REGISTRAR NUEVO PRODUCTO ###############################

########################### FUNCION CONTAR PRODUCTOS ################################
public function MostrarStockProductos()
{
	$this->p = [];
	if ($_SESSION['acceso'] == "administradorG") {

		$sql = "SELECT
	    sucursales.documsucursal, 
		sucursales.cuitsucursal, 
		sucursales.nomsucursal,
		sucursales.documencargado,
		sucursales.dniencargado,
		sucursales.nomencargado,
		sucursales.codmoneda,
		documentos.documento,
		tiposmoneda.moneda,
		tiposmoneda.siglas,
		tiposmoneda.simbolo,
	    SUM(ROUND(productos.existencia, 3)) AS Total_Inventario,
	    SUM(productos.preciocompra * productos.existencia) AS Total_Neto
		FROM (productos INNER JOIN sucursales ON productos.codsucursal = sucursales.codsucursal)
		LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
		LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
		WHERE productos.codsucursal = ?
		GROUP BY
		sucursales.documsucursal, 
		sucursales.cuitsucursal, 
		sucursales.nomsucursal,
		sucursales.documencargado,
		sucursales.dniencargado,
		sucursales.nomencargado,
		sucursales.codmoneda,
		documentos.documento,
		tiposmoneda.moneda,
		tiposmoneda.siglas,
		tiposmoneda.simbolo";
	    $stmt = $this->dbh->prepare($sql);
		$stmt->execute(array(decrypt($_GET["codsucursal"])));
		$num = $stmt->rowCount();
		if($num==0)
		{
			echo "";	
		   //exit;
		}
		else
		{
			while($row = $stmt->fetch(PDO::FETCH_ASSOC))
			{
				$this->p[]=$row;
			}
			return $this->p;
		}

	} else {

	    $sql = "SELECT
	    sucursales.documsucursal, 
		sucursales.cuitsucursal, 
		sucursales.nomsucursal,
		sucursales.documencargado,
		sucursales.dniencargado,
		sucursales.nomencargado,
		sucursales.codmoneda,
		documentos.documento,
		tiposmoneda.moneda,
		tiposmoneda.siglas,
		tiposmoneda.simbolo,
	    SUM(ROUND(productos.existencia, 3)) AS Total_Inventario,
	    SUM(productos.preciocompra * productos.existencia) AS Total_Neto
		FROM (productos INNER JOIN sucursales ON productos.codsucursal = sucursales.codsucursal)
		LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
		LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
		WHERE productos.codsucursal = '".limpiar($_SESSION["codsucursal"])."'
		GROUP BY
		sucursales.documsucursal, 
		sucursales.cuitsucursal, 
		sucursales.nomsucursal,
		sucursales.documencargado,
		sucursales.dniencargado,
		sucursales.nomencargado,
		sucursales.codmoneda,
		documentos.documento,
		tiposmoneda.moneda,
		tiposmoneda.siglas,
		tiposmoneda.simbolo";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		return $this->p;
    }
}
########################## FUNCION CONTAR PRODUCTOS ################################

########################## FUNCION BUSQUEDA DE PRODUCTOS ###############################
public function BusquedaProductosPorOpcion() 
{
	$this->p = [];
	$tipoAcceso      = isset($_SESSION["acceso"]) ? limpiar($_SESSION["acceso"]) : '';
	$codSucursal     = ($tipoAcceso === 'administradorG') ? limpiar(decrypt($_GET["codsucursal"])) : limpiar($_SESSION["codsucursal"]);	
    $tipoBusqueda    = isset($_GET['tipobusqueda']) ? limpiar($_GET['tipobusqueda']) : '';
    $searchCriterio  = isset($_GET['search_criterio']) ? limpiar($_GET['search_criterio']) : '';
    $CodFamilia      = isset($_GET['familias']) ? limpiar(decrypt($_GET["familias"])) : '';
    $CodMarca        = isset($_GET['marcas']) ? limpiar(decrypt($_GET["marcas"])) : '';
    $whereConditions = [];
    $params          = [];

    // Lógica de filtro basada en el tipo de acceso
    $whereConditions[] = "p.codsucursal = ?";
    $params[]          = $codSucursal;

    // Lógica de filtro basada en el tipo de búsqueda (tipobusqueda)
    if ($tipoBusqueda == 2) {//Busqueda por Criterio
      $whereConditions[] = "CONCAT(p.codproducto, '',p.producto, '',IFNULL(fam.nomfamilia,'0'), '',IFNULL(subfam.nomsubfamilia,'0'), '',IFNULL(marc.nommarca,'0'), '',IFNULL(mode.nommodelo,'0'), '',IFNULL(pres.nompresentacion,'0'), '',IFNULL(col.nomcolor,'0'), '',IFNULL(p.lote,'0'), '',IFNULL(p.codigobarra,'0'), '',IFNULL(prov.nomproveedor,'0')) LIKE ?";
        $params[] = '%' . $searchCriterio . '%';
    } elseif ($tipoBusqueda == 3) {// Busqueda por Familias
        $whereConditions[] = "p.codfamilia = ?";
        $params[]          = $CodFamilia;
    } elseif ($tipoBusqueda == 4) {// Busqueda por Marcas
        $whereConditions[] = "p.codmarca = ?";
        $params[]          = $CodMarca;
    }
    $whereClause = "";
    if (!empty($whereConditions)) {
      $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $sqlBase = "SELECT
        p.idproducto, p.codproducto, p.producto, p.descripcion, p.imei, p.condicion, p.fabricante,
        p.codfamilia, p.codsubfamilia, p.codmarca, p.codmodelo, p.codpresentacion, p.codcolor,
        p.codorigen, p.year, p.nroparte, p.lote, p.peso, p.preciocompra, p.precioxmayor, p.precioxmenor,
        p.precioxpublico, p.existencia, p.stockoptimo, p.stockmedio, p.stockminimo, p.ivaproducto,
        p.descproducto, p.codigobarra, p.fechaelaboracion, p.fechaoptimo, p.fechamedio, p.fechaminimo,
        p.codproveedor, p.stockteorico, p.motivoajuste, p.codsucursal,
        fam.nomfamilia, subfam.nomsubfamilia, marc.nommarca, mode.nommodelo, pres.nompresentacion,
        col.nomcolor, orig.nomorigen, prov.cuitproveedor, prov.nomproveedor,
		suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
		suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
		tm.moneda, tm.siglas, tm.simbolo,
        tm2.moneda AS moneda2, tm2.siglas AS siglas2, tm2.simbolo AS simbolo2,
        ciud.ciudad, com.comuna, 
		doc.documento, doc2.documento AS documento2
    FROM 
        (productos p INNER JOIN sucursales suc ON p.codsucursal = suc.codsucursal)
    LEFT JOIN 
        familias fam ON p.codfamilia = fam.codfamilia
	LEFT JOIN 
	    subfamilias subfam ON p.codsubfamilia = subfam.codsubfamilia 
	LEFT JOIN 
	    marcas marc ON p.codmarca = marc.codmarca 
	LEFT JOIN 
	    modelos mode ON p.codmodelo = mode.codmodelo
	LEFT JOIN 
	    presentaciones pres ON p.codpresentacion = pres.codpresentacion 
	LEFT JOIN 
	    colores col ON p.codcolor = col.codcolor 
	LEFT JOIN 
	    origenes orig ON p.codorigen=  orig.codorigen 
	LEFT JOIN 
	    proveedores prov ON p.codproveedor = prov.codproveedor
	LEFT JOIN 
	    documentos doc ON suc.documsucursal = doc.coddocumento
	LEFT JOIN 
	    documentos AS doc2 ON suc.documencargado = doc2.coddocumento
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
	LEFT JOIN 
        tiposmoneda tm2 ON suc.codmoneda2 = tm2.codmoneda
    LEFT JOIN 
        ciudades ciud ON suc.id_ciudad = ciud.id_ciudad 
    LEFT JOIN 
        comunas com ON suc.id_comuna = com.id_comuna
    ";
    $sql = $sqlBase . $whereClause . " ORDER BY p.codproducto ASC";
    if ($tipoBusqueda == 2 || $tipoBusqueda == 3 || $tipoBusqueda == 4) {
        $sql .= " LIMIT 0,5000";
    }
    try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($results)) {
            return [];
        } else {
            return $results;
        }
    } catch (PDOException $e) {
        error_log("Error en BusquedaProductosPorOpcion: " . $e->getMessage());
        echo "<div class='alert alert-danger'>";
        echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
        echo "<center><span class='fa fa-exclamation-triangle'></span> OCURRIÓ UN ERROR AL PROCESAR LA BÚSQUEDA. POR FAVOR, INTENTALO MAS TARDE.</center>";
        echo "</div>";
        return [];
    }
}
########################## FUNCION BUSQUEDA DE PRODUCTOS ###############################

########################### FUNCION LISTAR PRODUCTOS ################################
public function ListarProductos()
{
	$this->p = [];
	$tipoAcceso      = isset($_SESSION["acceso"]) ? limpiar($_SESSION["acceso"]) : '';
	$codSucursal     = ($tipoAcceso === 'administradorG') ? limpiar(decrypt($_GET["codsucursal"])) : limpiar($_SESSION["codsucursal"]);	
    $whereConditions = [];
    $params          = [];

    // Lógica de filtro basada en el tipo de acceso
    $whereConditions[] = "p.codsucursal = ?";
    $params[]          = $codSucursal;
   
    $whereClause = "";
    if (!empty($whereConditions)) {
      $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $sqlBase = "SELECT
        p.*,
        fam.nomfamilia, subfam.nomsubfamilia, marc.nommarca, mode.nommodelo, pres.nompresentacion,
        col.nomcolor, orig.nomorigen, prov.cuitproveedor, prov.nomproveedor,
		suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
		suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
		tm.moneda, tm.siglas, tm.simbolo,
        tm2.moneda AS moneda2, tm2.siglas AS siglas2, tm2.simbolo AS simbolo2,
        valor_cambio.montocambio,
        ciud.ciudad, com.comuna, 
		doc.documento, doc2.documento AS documento2
    FROM 
        (productos p INNER JOIN sucursales suc ON p.codsucursal = suc.codsucursal)
    LEFT JOIN 
        familias fam ON p.codfamilia = fam.codfamilia
	LEFT JOIN 
	    subfamilias subfam ON p.codsubfamilia = subfam.codsubfamilia 
	LEFT JOIN 
	    marcas marc ON p.codmarca = marc.codmarca 
	LEFT JOIN 
	    modelos mode ON p.codmodelo = mode.codmodelo
	LEFT JOIN 
	    presentaciones pres ON p.codpresentacion = pres.codpresentacion 
	LEFT JOIN 
	    colores col ON p.codcolor = col.codcolor 
	LEFT JOIN 
	    origenes orig ON p.codorigen=  orig.codorigen 
	LEFT JOIN 
	    proveedores prov ON p.codproveedor = prov.codproveedor
	LEFT JOIN 
	    documentos doc ON suc.documsucursal = doc.coddocumento
	LEFT JOIN 
	    documentos AS doc2 ON suc.documencargado = doc2.coddocumento
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
	LEFT JOIN 
        tiposmoneda tm2 ON suc.codmoneda2 = tm2.codmoneda
    LEFT JOIN 
        ciudades ciud ON suc.id_ciudad = ciud.id_ciudad 
    LEFT JOIN 
        comunas com ON suc.id_comuna = com.id_comuna
    LEFT JOIN
       (SELECT
       codcambio, descripcioncambio, montocambio, codmoneda       
       FROM tiposcambio
       ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = suc.codmoneda2
    ";
    $sql = $sqlBase . $whereClause . " ORDER BY p.codproducto ASC";
    try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($results)) {
            return [];
        } else {
            return $results;
        }
    } catch (PDOException $e) {
        error_log("Error en ListarProductos: " . $e->getMessage());
        return [];
    }
}
########################## FUNCION LISTAR PRODUCTOS ################################

########################### FUNCION LISTAR PRODUCTOS POR SUCURSAL ################################
public function ListarProductosxSucursales()
{
	$this->p = [];
	$tipoAcceso      = isset($_SESSION["acceso"]) ? limpiar($_SESSION["acceso"]) : '';
	$codSucursal     = limpiar(decrypt($_GET["codsucursal"]));	
    $whereConditions = [];
    $params          = [];

    // Lógica de filtro basada en el tipo de acceso
    $whereConditions[] = "p.codsucursal = ?";
    $params[]          = $codSucursal;
   
    $whereClause = "";
    if (!empty($whereConditions)) {
      $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $sqlBase = "SELECT
        p.*,
        fam.nomfamilia, subfam.nomsubfamilia, marc.nommarca, mode.nommodelo, pres.nompresentacion,
        col.nomcolor, orig.nomorigen, prov.cuitproveedor, prov.nomproveedor,
		suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
		suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
		tm.moneda, tm.siglas, tm.simbolo,
        tm2.moneda AS moneda2, tm2.siglas AS siglas2, tm2.simbolo AS simbolo2,
        valor_cambio.montocambio,
        ciud.ciudad, com.comuna, 
		doc.documento, doc2.documento AS documento2
    FROM 
        (productos p INNER JOIN sucursales suc ON p.codsucursal = suc.codsucursal)
    LEFT JOIN 
        familias fam ON p.codfamilia = fam.codfamilia
	LEFT JOIN 
	    subfamilias subfam ON p.codsubfamilia = subfam.codsubfamilia 
	LEFT JOIN 
	    marcas marc ON p.codmarca = marc.codmarca 
	LEFT JOIN 
	    modelos mode ON p.codmodelo = mode.codmodelo
	LEFT JOIN 
	    presentaciones pres ON p.codpresentacion = pres.codpresentacion 
	LEFT JOIN 
	    colores col ON p.codcolor = col.codcolor 
	LEFT JOIN 
	    origenes orig ON p.codorigen=  orig.codorigen 
	LEFT JOIN 
	    proveedores prov ON p.codproveedor = prov.codproveedor
	LEFT JOIN 
	    documentos doc ON suc.documsucursal = doc.coddocumento
	LEFT JOIN 
	    documentos AS doc2 ON suc.documencargado = doc2.coddocumento
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
	LEFT JOIN 
        tiposmoneda tm2 ON suc.codmoneda2 = tm2.codmoneda
    LEFT JOIN 
        ciudades ciud ON suc.id_ciudad = ciud.id_ciudad 
    LEFT JOIN 
        comunas com ON suc.id_comuna = com.id_comuna
    LEFT JOIN
       (SELECT
       codcambio, descripcioncambio, montocambio, codmoneda       
       FROM tiposcambio
       ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = suc.codmoneda2
    ";
    $sql = $sqlBase . $whereClause . " ORDER BY p.codproducto ASC";
    try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($results)) {
            return [];
        } else {
            return $results;
        }
    } catch (PDOException $e) {
        error_log("Error en ListarProductosxSucursales: " . $e->getMessage());
        return [];
    }
}
########################## FUNCION LISTAR PRODUCTOS POR SUCURSAL ################################

########################### FUNCION LISTAR PRODUCTOS EN STOCK OPTIMO ################################
public function ListarProductosOptimo()
{
	$this->p = [];
	$tipoAcceso      = isset($_SESSION["acceso"]) ? limpiar($_SESSION["acceso"]) : '';
	$codSucursal     = ($tipoAcceso === 'administradorG') ? limpiar(decrypt($_GET["codsucursal"])) : limpiar($_SESSION["codsucursal"]);	
    $whereConditions = [];
    $params          = [];

    // Lógica de filtro basada en el tipo de acceso
    $whereConditions[] = "p.codsucursal = ?";
    $params[]          = $codSucursal;
    $whereConditions[] = "CAST(p.existencia AS DECIMAL(10,2)) <= CAST(p.stockoptimo AS DECIMAL(10,2))";
    $whereConditions[] = "CAST(p.existencia AS DECIMAL(10,2)) > CAST(p.stockmedio AS DECIMAL(10,2))";
   
    $whereClause = "";
    if (!empty($whereConditions)) {
      $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $sqlBase = "SELECT
        p.*,
        fam.nomfamilia, subfam.nomsubfamilia, marc.nommarca, mode.nommodelo, pres.nompresentacion,
        col.nomcolor, orig.nomorigen, prov.cuitproveedor, prov.nomproveedor,
		suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
		suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
		tm.moneda, tm.siglas, tm.simbolo,
        tm2.moneda AS moneda2, tm2.siglas AS siglas2, tm2.simbolo AS simbolo2,
        valor_cambio.montocambio,
        ciud.ciudad, com.comuna, 
		doc.documento, doc2.documento AS documento2
    FROM 
        (productos p INNER JOIN sucursales suc ON p.codsucursal = suc.codsucursal)
    LEFT JOIN 
        familias fam ON p.codfamilia = fam.codfamilia
	LEFT JOIN 
	    subfamilias subfam ON p.codsubfamilia = subfam.codsubfamilia 
	LEFT JOIN 
	    marcas marc ON p.codmarca = marc.codmarca 
	LEFT JOIN 
	    modelos mode ON p.codmodelo = mode.codmodelo
	LEFT JOIN 
	    presentaciones pres ON p.codpresentacion = pres.codpresentacion 
	LEFT JOIN 
	    colores col ON p.codcolor = col.codcolor 
	LEFT JOIN 
	    origenes orig ON p.codorigen=  orig.codorigen 
	LEFT JOIN 
	    proveedores prov ON p.codproveedor = prov.codproveedor
	LEFT JOIN 
	    documentos doc ON suc.documsucursal = doc.coddocumento
	LEFT JOIN 
	    documentos AS doc2 ON suc.documencargado = doc2.coddocumento
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
	LEFT JOIN 
        tiposmoneda tm2 ON suc.codmoneda2 = tm2.codmoneda
    LEFT JOIN 
        ciudades ciud ON suc.id_ciudad = ciud.id_ciudad 
    LEFT JOIN 
        comunas com ON suc.id_comuna = com.id_comuna
    LEFT JOIN
       (SELECT
       codcambio, descripcioncambio, montocambio, codmoneda       
       FROM tiposcambio
       ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = suc.codmoneda2
    ";
    $sql = $sqlBase . $whereClause . " ORDER BY p.codproducto ASC";
    try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($results)) {
            return [];
        } else {
            return $results;
        }
    } catch (PDOException $e) {
        error_log("Error en ListarProductosOptimo: " . $e->getMessage());
        return [];
    }
}
########################## FUNCION LISTAR PRODUCTOS EN STOCK OPTIMO ################################

########################### FUNCION LISTAR PRODUCTOS EN STOCK MEDIO ################################
public function ListarProductosMedio()
{
	$this->p = [];
	$tipoAcceso      = isset($_SESSION["acceso"]) ? limpiar($_SESSION["acceso"]) : '';
	$codSucursal     = ($tipoAcceso === 'administradorG') ? limpiar(decrypt($_GET["codsucursal"])) : limpiar($_SESSION["codsucursal"]);	
    $whereConditions = [];
    $params          = [];

    // Lógica de filtro basada en el tipo de acceso
    $whereConditions[] = "p.codsucursal = ?";
    $params[]          = $codSucursal;
    $whereConditions[] = "CAST(p.existencia AS DECIMAL(10,2)) <= CAST(p.stockmedio AS DECIMAL(10,2))";
    $whereConditions[] = "CAST(p.existencia AS DECIMAL(10,2)) > CAST(p.stockminimo AS DECIMAL(10,2))";

    $whereClause = "";
    if (!empty($whereConditions)) {
      $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $sqlBase = "SELECT
        p.*,
        fam.nomfamilia, subfam.nomsubfamilia, marc.nommarca, mode.nommodelo, pres.nompresentacion,
        col.nomcolor, orig.nomorigen, prov.cuitproveedor, prov.nomproveedor,
		suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
		suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
		tm.moneda, tm.siglas, tm.simbolo,
        tm2.moneda AS moneda2, tm2.siglas AS siglas2, tm2.simbolo AS simbolo2,
        valor_cambio.montocambio,
        ciud.ciudad, com.comuna, 
		doc.documento, doc2.documento AS documento2
    FROM 
        (productos p INNER JOIN sucursales suc ON p.codsucursal = suc.codsucursal)
    LEFT JOIN 
        familias fam ON p.codfamilia = fam.codfamilia
	LEFT JOIN 
	    subfamilias subfam ON p.codsubfamilia = subfam.codsubfamilia 
	LEFT JOIN 
	    marcas marc ON p.codmarca = marc.codmarca 
	LEFT JOIN 
	    modelos mode ON p.codmodelo = mode.codmodelo
	LEFT JOIN 
	    presentaciones pres ON p.codpresentacion = pres.codpresentacion 
	LEFT JOIN 
	    colores col ON p.codcolor = col.codcolor 
	LEFT JOIN 
	    origenes orig ON p.codorigen=  orig.codorigen 
	LEFT JOIN 
	    proveedores prov ON p.codproveedor = prov.codproveedor
	LEFT JOIN 
	    documentos doc ON suc.documsucursal = doc.coddocumento
	LEFT JOIN 
	    documentos AS doc2 ON suc.documencargado = doc2.coddocumento
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
	LEFT JOIN 
        tiposmoneda tm2 ON suc.codmoneda2 = tm2.codmoneda
    LEFT JOIN 
        ciudades ciud ON suc.id_ciudad = ciud.id_ciudad 
    LEFT JOIN 
        comunas com ON suc.id_comuna = com.id_comuna
    LEFT JOIN
       (SELECT
       codcambio, descripcioncambio, montocambio, codmoneda       
       FROM tiposcambio
       ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = suc.codmoneda2
    ";
    $sql = $sqlBase . $whereClause . " ORDER BY p.codproducto ASC";
    try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($results)) {
            return [];
        } else {
            return $results;
        }
    } catch (PDOException $e) {
        error_log("Error en ListarProductosMedio: " . $e->getMessage());
        return [];
    }
}
########################## FUNCION LISTAR PRODUCTOS EN STOCK MEDIO ################################

########################### FUNCION LISTAR PRODUCTOS EN STOCK MINIMO ################################
public function ListarProductosMinimo()
{
	$this->p = [];
	$tipoAcceso      = isset($_SESSION["acceso"]) ? limpiar($_SESSION["acceso"]) : '';
	$codSucursal     = ($tipoAcceso === 'administradorG') ? limpiar(decrypt($_GET["codsucursal"])) : limpiar($_SESSION["codsucursal"]);	
    $whereConditions = [];
    $params          = [];

    // Lógica de filtro basada en el tipo de acceso
    $whereConditions[] = "p.codsucursal = ?";
    $params[]          = $codSucursal;
    $whereConditions[] = "CAST(p.existencia AS DECIMAL(10,2)) <= CAST(p.stockminimo AS DECIMAL(10,2))";
   
    $whereClause = "";
    if (!empty($whereConditions)) {
      $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $sqlBase = "SELECT
        p.*,
        fam.nomfamilia, subfam.nomsubfamilia, marc.nommarca, mode.nommodelo, pres.nompresentacion,
        col.nomcolor, orig.nomorigen, prov.cuitproveedor, prov.nomproveedor,
		suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
		suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
		tm.moneda, tm.siglas, tm.simbolo,
        tm2.moneda AS moneda2, tm2.siglas AS siglas2, tm2.simbolo AS simbolo2,
        valor_cambio.montocambio,
        ciud.ciudad, com.comuna, 
		doc.documento, doc2.documento AS documento2
    FROM 
        (productos p INNER JOIN sucursales suc ON p.codsucursal = suc.codsucursal)
    LEFT JOIN 
        familias fam ON p.codfamilia = fam.codfamilia
	LEFT JOIN 
	    subfamilias subfam ON p.codsubfamilia = subfam.codsubfamilia 
	LEFT JOIN 
	    marcas marc ON p.codmarca = marc.codmarca 
	LEFT JOIN 
	    modelos mode ON p.codmodelo = mode.codmodelo
	LEFT JOIN 
	    presentaciones pres ON p.codpresentacion = pres.codpresentacion 
	LEFT JOIN 
	    colores col ON p.codcolor = col.codcolor 
	LEFT JOIN 
	    origenes orig ON p.codorigen=  orig.codorigen 
	LEFT JOIN 
	    proveedores prov ON p.codproveedor = prov.codproveedor
	LEFT JOIN 
	    documentos doc ON suc.documsucursal = doc.coddocumento
	LEFT JOIN 
	    documentos AS doc2 ON suc.documencargado = doc2.coddocumento
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
	LEFT JOIN 
        tiposmoneda tm2 ON suc.codmoneda2 = tm2.codmoneda
    LEFT JOIN 
        ciudades ciud ON suc.id_ciudad = ciud.id_ciudad 
    LEFT JOIN 
        comunas com ON suc.id_comuna = com.id_comuna
    LEFT JOIN
       (SELECT
       codcambio, descripcioncambio, montocambio, codmoneda       
       FROM tiposcambio
       ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = suc.codmoneda2
    ";
    $sql = $sqlBase . $whereClause . " ORDER BY p.codproducto ASC";
    try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($results)) {
            return [];
        } else {
            return $results;
        }
    } catch (PDOException $e) {
        error_log("Error en ListarProductosMinimo: " . $e->getMessage());
        return [];
    }
}
########################## FUNCION LISTAR PRODUCTOS EN STOCK MINIMO ################################

########################### FUNCION LISTAR PRODUCTOS EN STOCK CERO ################################
public function ListarProductosCero()
{
	$this->p = [];
	$tipoAcceso      = isset($_SESSION["acceso"]) ? limpiar($_SESSION["acceso"]) : '';
	$codSucursal     = ($tipoAcceso === 'administradorG') ? limpiar(decrypt($_GET["codsucursal"])) : limpiar($_SESSION["codsucursal"]);	
    $whereConditions = [];
    $params          = [];

    // Lógica de filtro basada en el tipo de acceso
    $whereConditions[] = "p.codsucursal = ?";
    $params[]          = $codSucursal;
    $whereConditions[] = "CAST(p.existencia AS DECIMAL(10,2)) = 0";
   
    $whereClause = "";
    if (!empty($whereConditions)) {
      $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $sqlBase = "SELECT
        p.*,
        fam.nomfamilia, subfam.nomsubfamilia, marc.nommarca, mode.nommodelo, pres.nompresentacion,
        col.nomcolor, orig.nomorigen, prov.cuitproveedor, prov.nomproveedor,
		suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
		suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
		tm.moneda, tm.siglas, tm.simbolo,
        tm2.moneda AS moneda2, tm2.siglas AS siglas2, tm2.simbolo AS simbolo2,
        valor_cambio.montocambio,
        ciud.ciudad, com.comuna, 
		doc.documento, doc2.documento AS documento2
    FROM 
        (productos p INNER JOIN sucursales suc ON p.codsucursal = suc.codsucursal)
    LEFT JOIN 
        familias fam ON p.codfamilia = fam.codfamilia
	LEFT JOIN 
	    subfamilias subfam ON p.codsubfamilia = subfam.codsubfamilia 
	LEFT JOIN 
	    marcas marc ON p.codmarca = marc.codmarca 
	LEFT JOIN 
	    modelos mode ON p.codmodelo = mode.codmodelo
	LEFT JOIN 
	    presentaciones pres ON p.codpresentacion = pres.codpresentacion 
	LEFT JOIN 
	    colores col ON p.codcolor = col.codcolor 
	LEFT JOIN 
	    origenes orig ON p.codorigen=  orig.codorigen 
	LEFT JOIN 
	    proveedores prov ON p.codproveedor = prov.codproveedor
	LEFT JOIN 
	    documentos doc ON suc.documsucursal = doc.coddocumento
	LEFT JOIN 
	    documentos AS doc2 ON suc.documencargado = doc2.coddocumento
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
	LEFT JOIN 
        tiposmoneda tm2 ON suc.codmoneda2 = tm2.codmoneda
    LEFT JOIN 
        ciudades ciud ON suc.id_ciudad = ciud.id_ciudad 
    LEFT JOIN 
        comunas com ON suc.id_comuna = com.id_comuna
    LEFT JOIN
       (SELECT
       codcambio, descripcioncambio, montocambio, codmoneda       
       FROM tiposcambio
       ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = suc.codmoneda2
    ";
    $sql = $sqlBase . $whereClause . " ORDER BY p.codproducto ASC";
    try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($results)) {
            return [];
        } else {
            return $results;
        }
    } catch (PDOException $e) {
        error_log("Error en ListarProductosCero: " . $e->getMessage());
        return [];
    }
}
########################## FUNCION LISTAR PRODUCTOS EN STOCK CERO ################################

########################### FUNCION LISTAR PRODUCTOS EN FECHAS OPTIMO ################################
public function ListarProductosFechasOptimo()
{
	$this->p = [];
	$tipoAcceso      = isset($_SESSION["acceso"]) ? limpiar($_SESSION["acceso"]) : '';
	$codSucursal     = ($tipoAcceso === 'administradorG') ? limpiar(decrypt($_GET["codsucursal"])) : limpiar($_SESSION["codsucursal"]);	
    $whereConditions = [];
    $params          = [];

    // Lógica de filtro basada en el tipo de acceso
    $whereConditions[] = "p.codsucursal = ?";
    $params[]          = $codSucursal;
    $whereConditions[] = "'".date("Y-m-d")."' <= DATE_FORMAT(p.fechaoptimo,'%Y-%m-%d')";
    $whereConditions[] = "CAST(p.existencia AS DECIMAL(10,2)) > 0";
   
    $whereClause = "";
    if (!empty($whereConditions)) {
      $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $sqlBase = "SELECT
        p.*,
        fam.nomfamilia, subfam.nomsubfamilia, marc.nommarca, mode.nommodelo, pres.nompresentacion,
        col.nomcolor, orig.nomorigen, prov.cuitproveedor, prov.nomproveedor,
		suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
		suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
		tm.moneda, tm.siglas, tm.simbolo,
        tm2.moneda AS moneda2, tm2.siglas AS siglas2, tm2.simbolo AS simbolo2,
        valor_cambio.montocambio,
        ciud.ciudad, com.comuna, 
		doc.documento, doc2.documento AS documento2
    FROM 
        (productos p INNER JOIN sucursales suc ON p.codsucursal = suc.codsucursal)
    LEFT JOIN 
        familias fam ON p.codfamilia = fam.codfamilia
	LEFT JOIN 
	    subfamilias subfam ON p.codsubfamilia = subfam.codsubfamilia 
	LEFT JOIN 
	    marcas marc ON p.codmarca = marc.codmarca 
	LEFT JOIN 
	    modelos mode ON p.codmodelo = mode.codmodelo
	LEFT JOIN 
	    presentaciones pres ON p.codpresentacion = pres.codpresentacion 
	LEFT JOIN 
	    colores col ON p.codcolor = col.codcolor 
	LEFT JOIN 
	    origenes orig ON p.codorigen=  orig.codorigen 
	LEFT JOIN 
	    proveedores prov ON p.codproveedor = prov.codproveedor
	LEFT JOIN 
	    documentos doc ON suc.documsucursal = doc.coddocumento
	LEFT JOIN 
	    documentos AS doc2 ON suc.documencargado = doc2.coddocumento
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
	LEFT JOIN 
        tiposmoneda tm2 ON suc.codmoneda2 = tm2.codmoneda
    LEFT JOIN 
        ciudades ciud ON suc.id_ciudad = ciud.id_ciudad 
    LEFT JOIN 
        comunas com ON suc.id_comuna = com.id_comuna
    LEFT JOIN
       (SELECT
       codcambio, descripcioncambio, montocambio, codmoneda       
       FROM tiposcambio
       ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = suc.codmoneda2
    ";
    $sql = $sqlBase . $whereClause . " ORDER BY p.codproducto ASC";
    try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($results)) {
            return [];
        } else {
            return $results;
        }
    } catch (PDOException $e) {
        error_log("Error en ListarProductosFechasOptimo: " . $e->getMessage());
        return [];
    }
}
########################## FUNCION LISTAR PRODUCTOS EN FECHAS OPTIMO ################################

########################### FUNCION LISTAR PRODUCTOS EN FECHAS MEDIO ################################
public function ListarProductosFechasMedio()
{
	$this->p = [];
	$tipoAcceso      = isset($_SESSION["acceso"]) ? limpiar($_SESSION["acceso"]) : '';
	$codSucursal     = ($tipoAcceso === 'administradorG') ? limpiar(decrypt($_GET["codsucursal"])) : limpiar($_SESSION["codsucursal"]);	
    $whereConditions = [];
    $params          = [];

    // Lógica de filtro basada en el tipo de acceso
    $whereConditions[] = "p.codsucursal = ?";
    $params[]          = $codSucursal;
    $whereConditions[] = "'".date("Y-m-d")."' > DATE_FORMAT(p.fechaoptimo,'%Y-%m-%d')";
    $whereConditions[] = "'".date("Y-m-d")."' <= DATE_FORMAT(p.fechamedio,'%Y-%m-%d')";
    $whereConditions[] = "CAST(p.existencia AS DECIMAL(10,2)) > 0";
   
    $whereClause = "";
    if (!empty($whereConditions)) {
      $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $sqlBase = "SELECT
        p.*,
        fam.nomfamilia, subfam.nomsubfamilia, marc.nommarca, mode.nommodelo, pres.nompresentacion,
        col.nomcolor, orig.nomorigen, prov.cuitproveedor, prov.nomproveedor,
		suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
		suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
		tm.moneda, tm.siglas, tm.simbolo,
        tm2.moneda AS moneda2, tm2.siglas AS siglas2, tm2.simbolo AS simbolo2,
        valor_cambio.montocambio,
        ciud.ciudad, com.comuna, 
		doc.documento, doc2.documento AS documento2
    FROM 
        (productos p INNER JOIN sucursales suc ON p.codsucursal = suc.codsucursal)
    LEFT JOIN 
        familias fam ON p.codfamilia = fam.codfamilia
	LEFT JOIN 
	    subfamilias subfam ON p.codsubfamilia = subfam.codsubfamilia 
	LEFT JOIN 
	    marcas marc ON p.codmarca = marc.codmarca 
	LEFT JOIN 
	    modelos mode ON p.codmodelo = mode.codmodelo
	LEFT JOIN 
	    presentaciones pres ON p.codpresentacion = pres.codpresentacion 
	LEFT JOIN 
	    colores col ON p.codcolor = col.codcolor 
	LEFT JOIN 
	    origenes orig ON p.codorigen=  orig.codorigen 
	LEFT JOIN 
	    proveedores prov ON p.codproveedor = prov.codproveedor
	LEFT JOIN 
	    documentos doc ON suc.documsucursal = doc.coddocumento
	LEFT JOIN 
	    documentos AS doc2 ON suc.documencargado = doc2.coddocumento
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
	LEFT JOIN 
        tiposmoneda tm2 ON suc.codmoneda2 = tm2.codmoneda
    LEFT JOIN 
        ciudades ciud ON suc.id_ciudad = ciud.id_ciudad 
    LEFT JOIN 
        comunas com ON suc.id_comuna = com.id_comuna
    LEFT JOIN
       (SELECT
       codcambio, descripcioncambio, montocambio, codmoneda       
       FROM tiposcambio
       ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = suc.codmoneda2
    ";
    $sql = $sqlBase . $whereClause . " ORDER BY p.codproducto ASC";
    try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($results)) {
            return [];
        } else {
            return $results;
        }
    } catch (PDOException $e) {
        error_log("Error en ListarProductosFechasMedio: " . $e->getMessage());
        return [];
    }
}
########################## FUNCION LISTAR PRODUCTOS EN FECHAS MEDIO ################################

########################### FUNCION LISTAR PRODUCTOS EN FECHAS MINIMO ################################
public function ListarProductosFechasMinimo()
{
	$this->p = [];
	$tipoAcceso      = isset($_SESSION["acceso"]) ? limpiar($_SESSION["acceso"]) : '';
	$codSucursal     = ($tipoAcceso === 'administradorG') ? limpiar(decrypt($_GET["codsucursal"])) : limpiar($_SESSION["codsucursal"]);	
    $whereConditions = [];
    $params          = [];

    // Lógica de filtro basada en el tipo de acceso
    $whereConditions[] = "p.codsucursal = ?";
    $params[]          = $codSucursal;
    $whereConditions[] = "p.fechaminimo != '0000-00-00'";
    $whereConditions[] = "DATE_FORMAT(p.fechaminimo,'%Y-%m-%d') <= '".date("Y-m-d")."'";
    $whereConditions[] = "CAST(p.existencia AS DECIMAL(10,2)) > 0";
   
    $whereClause = "";
    if (!empty($whereConditions)) {
      $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $sqlBase = "SELECT
        p.*,
        fam.nomfamilia, subfam.nomsubfamilia, marc.nommarca, mode.nommodelo, pres.nompresentacion,
        col.nomcolor, orig.nomorigen, prov.cuitproveedor, prov.nomproveedor,
		suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
		suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
		tm.moneda, tm.siglas, tm.simbolo,
        tm2.moneda AS moneda2, tm2.siglas AS siglas2, tm2.simbolo AS simbolo2,
        valor_cambio.montocambio,
        ciud.ciudad, com.comuna, 
		doc.documento, doc2.documento AS documento2
    FROM 
        (productos p INNER JOIN sucursales suc ON p.codsucursal = suc.codsucursal)
    LEFT JOIN 
        familias fam ON p.codfamilia = fam.codfamilia
	LEFT JOIN 
	    subfamilias subfam ON p.codsubfamilia = subfam.codsubfamilia 
	LEFT JOIN 
	    marcas marc ON p.codmarca = marc.codmarca 
	LEFT JOIN 
	    modelos mode ON p.codmodelo = mode.codmodelo
	LEFT JOIN 
	    presentaciones pres ON p.codpresentacion = pres.codpresentacion 
	LEFT JOIN 
	    colores col ON p.codcolor = col.codcolor 
	LEFT JOIN 
	    origenes orig ON p.codorigen=  orig.codorigen 
	LEFT JOIN 
	    proveedores prov ON p.codproveedor = prov.codproveedor
	LEFT JOIN 
	    documentos doc ON suc.documsucursal = doc.coddocumento
	LEFT JOIN 
	    documentos AS doc2 ON suc.documencargado = doc2.coddocumento
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
	LEFT JOIN 
        tiposmoneda tm2 ON suc.codmoneda2 = tm2.codmoneda
    LEFT JOIN 
        ciudades ciud ON suc.id_ciudad = ciud.id_ciudad 
    LEFT JOIN 
        comunas com ON suc.id_comuna = com.id_comuna
    LEFT JOIN
       (SELECT
       codcambio, descripcioncambio, montocambio, codmoneda       
       FROM tiposcambio
       ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = suc.codmoneda2
    ";
    $sql = $sqlBase . $whereClause . " ORDER BY p.codproducto ASC";
    try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($results)) {
            return [];
        } else {
            return $results;
        }
    } catch (PDOException $e) {
        error_log("Error en ListarProductosFechasMinimo: " . $e->getMessage());
        return [];
    }
}
########################## FUNCION LISTAR PRODUCTOS EN FECHAS MINIMO ################################

############################# FUNCION LISTAR PRODUCTOS EN VENTANA MODAL ################################
public function ListarProductosModal()
{
	$this->p = [];
	$sql = "SELECT
        p.idproducto, p.codproducto, p.producto, p.descripcion, p.opcionvendido, p.imei, p.condicion, p.codmarca, 
        p.codmodelo, p.codpresentacion, p.codcolor, p.preciocompra, p.precioxmayor, p.precioxmenor,
        p.precioxpublico, p.existencia, p.stockoptimo, p.stockmedio, p.stockminimo, p.ivaproducto,
        p.descproducto, p.fechaelaboracion, p.fechaoptimo, p.fechamedio, p.fechaminimo, p.codigobarra, 
        p.codsucursal,
        fam.nomfamilia, subfam.nomsubfamilia, marc.nommarca, mode.nommodelo, pres.nompresentacion,
        col.nomcolor, orig.nomorigen,
		tm.moneda, tm.siglas, tm.simbolo
    FROM 
        (productos p INNER JOIN sucursales suc ON p.codsucursal = suc.codsucursal)
    LEFT JOIN 
        familias fam ON p.codfamilia = fam.codfamilia
	LEFT JOIN 
	    subfamilias subfam ON p.codsubfamilia = subfam.codsubfamilia 
	LEFT JOIN 
	    marcas marc ON p.codmarca = marc.codmarca 
	LEFT JOIN 
	    modelos mode ON p.codmodelo = mode.codmodelo
	LEFT JOIN 
	    presentaciones pres ON p.codpresentacion = pres.codpresentacion 
	LEFT JOIN 
	    colores col ON p.codcolor = col.codcolor 
	LEFT JOIN 
	    origenes orig ON p.codorigen=  orig.codorigen
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
    WHERE p.codsucursal = '".limpiar($_SESSION["codsucursal"])."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
}
########################## FUNCION LISTAR PRODUCTOS EN VENTANA MODAL ################################

############################# FUNCION LISTAR PRODUCTOS EN VENTANA MODAL ################################
public function ListarProductosPorFiltro(
    $familia_nombre    = '',
    $criterio_busqueda = '',
    $limit             = null,
    $offset            = null
) {
    $this->p = [];
    $codsucursal = limpiar($_SESSION["codsucursal"]); 
    // Parte base de la consulta
    $sql_base = "SELECT
        p.idproducto, p.codproducto, p.producto, p.descripcion, p.opcionvendido, p.imei, p.condicion, p.codmarca, 
        p.codmodelo, p.codpresentacion, p.codcolor, p.preciocompra, p.precioxmayor, p.precioxmenor,
        p.precioxpublico, p.existencia, p.stockoptimo, p.stockmedio, p.stockminimo, p.ivaproducto,
        p.descproducto, p.fechaelaboracion, p.fechaoptimo, p.fechamedio, p.fechaminimo, p.codigobarra, 
        p.codsucursal,
        fam.nomfamilia, subfam.nomsubfamilia, marc.nommarca, mode.nommodelo, pres.nompresentacion,
        col.nomcolor, orig.nomorigen,
		tm.moneda, tm.siglas, tm.simbolo
    FROM 
        (productos p INNER JOIN sucursales suc ON p.codsucursal = suc.codsucursal)
    LEFT JOIN 
        familias fam ON p.codfamilia = fam.codfamilia
	LEFT JOIN 
	    subfamilias subfam ON p.codsubfamilia = subfam.codsubfamilia 
	LEFT JOIN 
	    marcas marc ON p.codmarca = marc.codmarca 
	LEFT JOIN 
	    modelos mode ON p.codmodelo = mode.codmodelo
	LEFT JOIN 
	    presentaciones pres ON p.codpresentacion = pres.codpresentacion 
	LEFT JOIN 
	    colores col ON p.codcolor = col.codcolor 
	LEFT JOIN 
	    origenes orig ON p.codorigen=  orig.codorigen
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
    WHERE p.codsucursal = :codsucursal
    AND p.existencia != 0.00";
    $params = [':codsucursal' => $codsucursal];
    $sql_condiciones = ""; // Para agregar las condiciones WHERE dinámicas
    // Añadir filtro por familia
    if (!empty($familia_nombre) && $familia_nombre !== 'todos') {
        $sql_condiciones .= " AND fam.nomfamilia = :nomfamilia";
        $params[':nomfamilia'] = $familia_nombre;
    }
    // Añadir filtro por búsqueda (busqueda en producto, codproducto, codigobarra)
    if (!empty($criterio_busqueda)) {
        $sql_condiciones .= " AND (p.producto LIKE :busqueda_prod OR p.codproducto LIKE :busqueda_codprod OR p.codigobarra LIKE :busqueda_codbarra)";
        $params[':busqueda_prod'] = '%' . $criterio_busqueda . '%';
        $params[':busqueda_codprod'] = '%' . $criterio_busqueda . '%';
        $params[':busqueda_codbarra'] = '%' . $criterio_busqueda . '%';
    }
    $sql_orden = " ORDER BY p.producto ASC"; // Ordenamiento
    $sql_limit_offset = ""; // Para paginación
    // Añadir paginación (LIMIT y OFFSET)
    if (is_numeric($limit) && $limit > 0) {
        $sql_limit_offset .= " LIMIT :limit";
        $params[':limit'] = (int)$limit;
        if (is_numeric($offset) && $offset >= 0) {
            $sql_limit_offset .= " OFFSET :offset";
            $params[':offset'] = (int)$offset;
        }
    }
    // Construye la consulta final
    $sql = $sql_base . $sql_condiciones . $sql_orden . $sql_limit_offset;
    // --- DEBUGGING ---
    //error_log("SQL Query (final): " . $sql);
    //error_log("Parameters (final): " . var_export($params, true)); 
    // --- FIN DEBUGGING ---
    $stmt = $this->dbh->prepare($sql);
    $stmt->execute($params); 
    $this->p = $stmt->fetchAll(PDO::FETCH_ASSOC);
    return $this->p;
}
########################## FUNCION LISTAR PRODUCTOS EN VENTANA MODAL ################################

########################## FUNCION LISTAR CODIGO DE BARRAS #########################
public function ListarCodigoBarra()
{
	$this->p = [];
	$tipoAcceso      = isset($_SESSION["acceso"]) ? limpiar($_SESSION["acceso"]) : '';
	$codSucursal     = ($tipoAcceso === 'administradorG') ? limpiar(decrypt($_GET["codsucursal"])) : limpiar($_SESSION["codsucursal"]);	
    $whereConditions = [];
    $params          = [];

    // Lógica de filtro basada en el tipo de acceso
    $whereConditions[] = "p.codsucursal = ?";
    $params[]          = $codSucursal;
    $whereConditions[] = "p.codigobarra != ''";
   
    $whereClause = "";
    if (!empty($whereConditions)) {
      $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $sqlBase = "SELECT 
	    p.codproducto, p.producto, p.precioxpublico, p.descripcion, p.imei, 
	    p.condicion, p.codigobarra, 
		s.cuitsucursal, s.nomsucursal, s.nomencargado,
		tp.moneda, tp.siglas, tp.simbolo,
		d.documento 
		FROM productos p INNER JOIN sucursales s ON p.codsucursal = s.codsucursal
		LEFT JOIN tiposmoneda tp ON s.codmoneda = tp.codmoneda
		LEFT JOIN documentos d ON s.documsucursal = d.coddocumento
    ";
    $sql = $sqlBase . $whereClause . " ORDER BY p.codproducto ASC";
    try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($results)) {
            return [];
        } else {
            return $results;
        }
    } catch (PDOException $e) {
        error_log("Error en ListarCodigoBarra: " . $e->getMessage());
        return [];
    }
}
############################ FUNCION LISTAR CODIGO DE BARRAS #########################

############################ FUNCION ID PRODUCTOS #################################
public function ProductosPorId()
{
	$this->p = [];
    $codProducto = isset($_GET["codproducto"]) ? limpiar(decrypt($_GET["codproducto"])) : '';
    $codSucursal = isset($_GET["codsucursal"]) ? limpiar(decrypt($_GET["codsucursal"])) : '';
	$sql = "SELECT
	    p.*,
        fam.nomfamilia, subfam.nomsubfamilia, marc.nommarca, mode.nommodelo, pres.nompresentacion,
        col.nomcolor, orig.nomorigen, prov.cuitproveedor, prov.nomproveedor,
		suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
		suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
		tm.moneda, tm.siglas, tm.simbolo,
        tm2.moneda AS moneda2, tm2.siglas AS siglas2, tm2.simbolo AS simbolo2,
        valor_cambio.montocambio,
        ciud.ciudad, com.comuna, 
		doc.documento, doc2.documento AS documento2
    FROM 
        (productos p INNER JOIN sucursales suc ON p.codsucursal = suc.codsucursal)
    LEFT JOIN 
        familias fam ON p.codfamilia = fam.codfamilia
	LEFT JOIN 
	    subfamilias subfam ON p.codsubfamilia = subfam.codsubfamilia 
	LEFT JOIN 
	    marcas marc ON p.codmarca = marc.codmarca 
	LEFT JOIN 
	    modelos mode ON p.codmodelo = mode.codmodelo
	LEFT JOIN 
	    presentaciones pres ON p.codpresentacion = pres.codpresentacion 
	LEFT JOIN 
	    colores col ON p.codcolor = col.codcolor 
	LEFT JOIN 
	    origenes orig ON p.codorigen=  orig.codorigen 
	LEFT JOIN 
	    proveedores prov ON p.codproveedor = prov.codproveedor
	LEFT JOIN 
	    documentos doc ON suc.documsucursal = doc.coddocumento
	LEFT JOIN 
	    documentos AS doc2 ON suc.documencargado = doc2.coddocumento
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
	LEFT JOIN 
        tiposmoneda tm2 ON suc.codmoneda2 = tm2.codmoneda
    LEFT JOIN 
        ciudades ciud ON suc.id_ciudad = ciud.id_ciudad 
    LEFT JOIN 
        comunas com ON suc.id_comuna = com.id_comuna
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = suc.codmoneda2  
	WHERE p.codproducto = :codProducto AND p.codsucursal = :codSucursal";
	try {
        $stmt = $this->dbh->prepare($sql);
        // Asignamos los parámetros a los marcadores de posición con nombre
        $stmt->bindParam(':codProducto', $codProducto);
        $stmt->bindParam(':codSucursal', $codSucursal);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        if (!$row) {
            echo "<div class='alert alert-danger'>";
            echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
            echo "<center><span class='fa fa-info-circle'></span> PRODUCTO NO ENCONTRADO.</center>";
            echo "</div>";
            exit();
        } else {
            $this->p[] = $row;
            return $this->p;
        }
    } catch (PDOException $e) {
        error_log("Error en ProductosPorId: " . $e->getMessage());
        echo "<div class='alert alert-danger'>";
        echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
        echo "<center><span class='fa fa-exclamation-triangle'></span> OCURRIÓ UN ERROR AL CONSULTAR EL PRODUCTO.</center>";
        echo "</div>";
        return [];
    }
}
############################ FUNCION ID PRODUCTOS #################################

############################ FUNCION DETALLES PRODUCTOS #################################
public function DetallesProductoPorId()
{
	$this->p = [];
    $idProducto  = isset($_GET["d_id"]) ? limpiar($_GET["d_id"]) : '';
    $codProducto = isset($_GET["d_codigo"]) ? limpiar($_GET["d_codigo"]) : '';
    $codSucursal = isset($_SESSION["codsucursal"]) ? limpiar($_SESSION["codsucursal"]) : '';
	$sql = "SELECT
	    p.idproducto, p.codproducto, p.producto, p.descripcion, p.imei, p.opcionvendido, p.condicion, p.fabricante, p.codfamilia,
	    p.codsubfamilia, p.codmarca, p.codmodelo, p.codpresentacion, p.codcolor, p.codorigen, p.year, p.nroparte,
	    p.lote, p.peso, p.preciocompra, p.precioxmayor, p.precioxmenor, p.precioxpublico, p.existencia, p.stockoptimo,
	    p.stockmedio, p.stockminimo, p.ivaproducto, p.descproducto, p.codigobarra, p.fechaelaboracion, p.fechaoptimo,
	    p.fechamedio, p.fechaminimo, p.codproveedor, p.codsucursal,
        fam.nomfamilia, subfam.nomsubfamilia, marc.nommarca, mode.nommodelo, pres.nompresentacion,
        col.nomcolor, orig.nomorigen,
		tm.moneda, tm.siglas, tm.simbolo
    FROM 
        (productos p INNER JOIN sucursales suc ON p.codsucursal = suc.codsucursal)
    LEFT JOIN 
        familias fam ON p.codfamilia = fam.codfamilia
	LEFT JOIN 
	    subfamilias subfam ON p.codsubfamilia = subfam.codsubfamilia 
	LEFT JOIN 
	    marcas marc ON p.codmarca = marc.codmarca 
	LEFT JOIN 
	    modelos mode ON p.codmodelo = mode.codmodelo
	LEFT JOIN 
	    presentaciones pres ON p.codpresentacion = pres.codpresentacion 
	LEFT JOIN 
	    colores col ON p.codcolor = col.codcolor 
	LEFT JOIN 
	    origenes orig ON p.codorigen=  orig.codorigen
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
	WHERE p.idproducto = :idProducto AND p.codproducto = :codProducto AND p.codsucursal = :codSucursal";
	try {
        $stmt = $this->dbh->prepare($sql);
        // Asignamos los parámetros a los marcadores de posición con nombre
        $stmt->bindParam(':idProducto', $idProducto);
        $stmt->bindParam(':codProducto', $codProducto);
        $stmt->bindParam(':codSucursal', $codSucursal);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        if (!$row) {
            echo "<div class='alert alert-danger'>";
            echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
            echo "<center><span class='fa fa-info-circle'></span> PRODUCTO NO ENCONTRADO.</center>";
            echo "</div>";
            exit();
        } else {
            $this->p[] = $row;
            return $this->p;
        }
    } catch (PDOException $e) {
        error_log("Error en ProductosPorId: " . $e->getMessage());
        echo "<div class='alert alert-danger'>";
        echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
        echo "<center><span class='fa fa-exclamation-triangle'></span> OCURRIÓ UN ERROR AL CONSULTAR EL PRODUCTO.</center>";
        echo "</div>";
        return [];
    }
}
############################ FUNCION DETALLES PRODUCTOS #################################

############################ FUNCION ACTUALIZAR PRODUCTOS ############################
public function ActualizarProductos()
{
	$this->p = [];
	if(empty($_POST["codproducto"]) or empty($_POST["producto"]) or empty($_POST["codfamilia"]) or empty($_POST["codsucursal"]))
	{
		echo "1";
		exit;
	}
	elseif($_POST["opcionvendido"] == '1' && !ctype_digit(trim($_POST["existencia"])))
	{
		echo "2";
		exit;
	}
	elseif($_POST["opcionvendido"] == '2' && ctype_digit(trim($_POST["existencia"])))
	{
		echo "3";
		exit;
	}

	############## OBTENGO VALOR DE IMPUESTO #################
	$sql = "SELECT 
	valorimpuesto 
	FROM impuestos 
	WHERE statusimpuesto = 1";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$valor = (empty($row['valorimpuesto']) ? "0.00" : $row['valorimpuesto']);
	############## OBTENGO VALOR DE IMPUESTO #################

	$sql = "SELECT codproducto FROM productos WHERE idproducto != ? AND codproducto = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_POST["idproducto"]),$_POST["codproducto"],decrypt($_POST["codsucursal"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		##################### ACTUALIZO LOS DATOS DE PRODUCTOS #####################
		$sql = "UPDATE productos set"
		." producto = ?, "
		." descripcion = ?, "
		." opcionvendido = ?, "
		." imei = ?, "
		." condicion = ?, "
		." fabricante = ?, "
		." codfamilia = ?, "
		." codsubfamilia = ?, "
		." codmarca = ?, "
		." codmodelo = ?, "
		." codpresentacion = ?, "
		." codcolor = ?, "
		." codorigen = ?, "
		." year = ?, "
		." nroparte = ?, "
		." lote = ?, "
		." peso = ?, "
		." preciocompra = ?, "
		." precioxmayor = ?, "
		." precioxmenor = ?, "
		." precioxpublico = ?, "
		." existencia = ?, "
		." stockoptimo = ?, "
		." stockmedio = ?, "
		." stockminimo = ?, "
		." ivaproducto = ?, "
		." descproducto = ?, "
		." codigobarra = ?, "
		." fechaelaboracion = ?, "
		." fechaoptimo = ?, "
		." fechamedio = ?, "
		." fechaminimo = ?, "
		." codproveedor = ? "
		." WHERE "
		." idproducto = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $producto);
		$stmt->bindParam(2, $descripcion);
		$stmt->bindParam(3, $opcionvendido);
		$stmt->bindParam(4, $imei);
		$stmt->bindParam(5, $condicion);
		$stmt->bindParam(6, $fabricante);
		$stmt->bindParam(7, $codfamilia);
		$stmt->bindParam(8, $codsubfamilia);
		$stmt->bindParam(9, $codmarca);
		$stmt->bindParam(10, $codmodelo);
		$stmt->bindParam(11, $codpresentacion);
		$stmt->bindParam(12, $codcolor);
		$stmt->bindParam(13, $codorigen);
		$stmt->bindParam(14, $year);
		$stmt->bindParam(15, $nroparte);
		$stmt->bindParam(16, $lote);
		$stmt->bindParam(17, $peso);
		$stmt->bindParam(18, $preciocompra);
		$stmt->bindParam(19, $precioxmayor);
		$stmt->bindParam(20, $precioxmenor);
		$stmt->bindParam(21, $precioxpublico);
		$stmt->bindParam(22, $existencia);
		$stmt->bindParam(23, $stockoptimo);
		$stmt->bindParam(24, $stockmedio);
		$stmt->bindParam(25, $stockminimo);
		$stmt->bindParam(26, $ivaproducto);
		$stmt->bindParam(27, $descproducto);
		$stmt->bindParam(28, $codigobarra);
		$stmt->bindParam(29, $fechaelaboracion);
		$stmt->bindParam(30, $fechaoptimo);
		$stmt->bindParam(31, $fechamedio);
		$stmt->bindParam(32, $fechaminimo);
		$stmt->bindParam(33, $codproveedor);
		$stmt->bindParam(34, $idproducto);

		$producto         = limpiar($_POST["producto"]);
		$descripcion      = limpiar($_POST["descripcion"]);
		$opcionvendido    = limpiar($_POST["opcionvendido"]);
		$imei             = limpiar($_POST["imei"]);
		$condicion        = limpiar($_POST['condicion'] == '' ? "0" : $_POST["condicion"]);
		$fabricante       = limpiar($_POST["fabricante"]);
		$codfamilia       = limpiar(decrypt($_POST["codfamilia"]));
		$codsubfamilia    = limpiar($_POST['codsubfamilia'] == '' ? "0" : decrypt($_POST['codsubfamilia']));
		$codmarca         = limpiar($_POST['codmarca'] == '' ? "0" : decrypt($_POST['codmarca']));
		$codmodelo        = limpiar($_POST['codmodelo'] == '' ? "0" : decrypt($_POST['codmodelo']));
		$codpresentacion  = limpiar($_POST['codpresentacion'] == '' ? "0" : decrypt($_POST['codpresentacion']));
		$codcolor         = limpiar($_POST['codcolor'] == '' ? "0" : decrypt($_POST['codcolor']));
		$codorigen        = limpiar($_POST['codorigen'] == '' ? "0" : decrypt($_POST['codorigen']));
		$year             = limpiar($_POST["year"]);
		$nroparte         = limpiar($_POST["nroparte"]);
		$lote             = limpiar($_POST['lote'] == '' ? "0" : $_POST['lote']);
		$peso             = limpiar($_POST["peso"]);
		$preciocompra     = limpiar($_POST["preciocompra"]);
		$precioxmayor     = limpiar($_POST["precioxmayor"]);
		$precioxmenor     = limpiar($_POST["precioxmenor"]);
		$precioxpublico   = limpiar($_POST["precioxpublico"]);
		$existencia       = limpiar($_POST["existencia"]);
		$stockoptimo      = limpiar($_POST["stockoptimo"]);
		$stockmedio       = limpiar($_POST["stockmedio"]);
		$stockminimo      = limpiar($_POST["stockminimo"]);
		$ivaproducto      = limpiar($_POST["ivaproducto"]);
		$descproducto     = limpiar($_POST["descproducto"]);
		$codigobarra      = limpiar($_POST["codigobarra"]);
		$fechaelaboracion = limpiar($_POST['fechaelaboracion'] == '' ? "0000-00-00" : date("Y-m-d",strtotime($_POST['fechaelaboracion'])));
		$fechaoptimo      = limpiar($_POST['fechaoptimo'] == '' ? "0000-00-00" : date("Y-m-d",strtotime($_POST['fechaoptimo'])));
		$fechamedio       = limpiar($_POST['fechamedio'] == '' ? "0000-00-00" : date("Y-m-d",strtotime($_POST['fechamedio'])));
		$fechaminimo      = limpiar($_POST['fechaminimo'] == '' ? "0000-00-00" : date("Y-m-d",strtotime($_POST['fechaminimo'])));
		$codproveedor     = limpiar(decrypt($_POST["codproveedor"]));
		$codproducto      = limpiar($_POST["codproducto"]);
		$idproducto       = limpiar(decrypt($_POST["idproducto"]));
		$codsucursal      = decrypt($_POST["codsucursal"]);
		$stmt->execute();
		##################### ACTUALIZO LOS DATOS DE PRODUCTOS #####################

	if($_POST['existencia'] != $_POST['existencia2']){

		##################### REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX #####################
		$query = "INSERT INTO kardex values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codproceso);
		$stmt->bindParam(2, $codresponsable);
		$stmt->bindParam(3, $codproducto);
		$stmt->bindParam(4, $movimiento);
		$stmt->bindParam(5, $entradas);
		$stmt->bindParam(6, $salidas);
		$stmt->bindParam(7, $devolucion);
		$stmt->bindParam(8, $stockactual);
		$stmt->bindParam(9, $ivaproducto);
		$stmt->bindParam(10, $descproducto);
		$stmt->bindParam(11, $precio);
		$stmt->bindParam(12, $documento);
		$stmt->bindParam(13, $fechakardex);
		$stmt->bindParam(14, $tipokardex);
		$stmt->bindParam(15, $procedimiento);
		$stmt->bindParam(16, $codsucursal);
		$stmt->bindParam(17, $codigo);

		$codproceso     = limpiar($_POST['codproducto']);
		$codresponsable = limpiar("0");
		$codproducto    = limpiar($_POST['codproducto']);
		$movimiento     = limpiar($_POST['existencia'] > $_POST['existencia2'] ? "ENTRADAS" : "SALIDAS");
		$entradas       = limpiar($_POST['existencia'] > $_POST['existencia2'] ? $_POST['existencia']-$_POST['existencia2'] : '0');
		$salidas        = limpiar($_POST['existencia'] > $_POST['existencia2'] ? '0' : $_POST['existencia2']-$_POST['existencia']);
		$devolucion     = limpiar("0.00");
		$stockactual    = limpiar($_POST['existencia']);
		$ivaproducto    = limpiar($_POST["ivaproducto"] == 'SI' ? $valor : "0.00");
		$descproducto   = limpiar($_POST["descproducto"]);
		$precio         = limpiar("0.00");
		$documento      = limpiar("ACTUALIZACIÓN DE INVENTARIO");
		$fechakardex    = limpiar(date("Y-m-d"));
		$tipokardex     = limpiar("1");
		$procedimiento  = limpiar("1");
		$codsucursal    = decrypt($_POST["codsucursal"]);
    	$codigo         = limpiar($_SESSION["codigo"]);
		$stmt->execute();
		##################### REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX #####################
	}

    ############################## SUBIR FOTO DE PRODUCTO ##############################
	$permitidos     = array("image/jpg", "image/jpeg", "image/png");
	$limite_kb      = 0;
    //datos del arhivo  
    $nombre_archivo = limpiar(isset($_FILES['imagen']['name']) ? $_FILES['imagen']['name'] : "");
	$tipo_archivo   = limpiar(isset($_FILES['imagen']['type']) ? $_FILES['imagen']['type'] : "");
	$tamano_archivo = limpiar(isset($_FILES['imagen']['size']) ? $_FILES['imagen']['size'] : "");
	$file           = new SplFileInfo($nombre_archivo);
	$extension      = $file->getExtension();
    //compruebo si las características del archivo son las que deseo 
    if (!empty($_FILES["imagen"]) && in_array($_FILES['imagen']['type'], $permitidos)){
 
        if (move_uploaded_file($_FILES['imagen']['tmp_name'], "fotos/productos/".$nombre_archivo) && rename("fotos/productos/".$nombre_archivo,"fotos/productos/".$codsucursal."_".$codproducto.".".$extension))
	    { 
	    ## se puede dar un aviso
	    } 
	    ## se puede dar otro aviso 
	}
	############################## SUBIR FOTO DE PRODUCTO ##############################
        
	echo "<span class='fa fa-check-square-o'></span> EL PRODUCTO HA SIDO ACTUALIZADO EXITOSAMENTE";
	exit;

	} else {

		echo "4";
		exit;
	}
}
############################ FUNCION ACTUALIZAR PRODUCTOS ############################

########################## FUNCION AJUSTAR STOCK DE PRODUCTOS ###########################
public function ActualizarAjuste()
{
	$this->p = [];
	if(empty($_POST["codproducto"]) or empty($_POST["stockteorico"]) or empty($_POST["motivoajuste"]))
	{
		echo "1";
	   exit;
	}
	
	$sql = "UPDATE productos set"
		." stockteorico = ?, "
		." motivoajuste = ? "
		." WHERE "
		." idproducto = ?;
		";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $stockteorico);
	$stmt->bindParam(2, $motivoajuste);
    $stmt->bindParam(3, $idproducto);
	
	$stockteorico = limpiar($_POST["stockteorico"]);
	$motivoajuste = limpiar($_POST["motivoajuste"]);
	$idproducto   = limpiar(decrypt($_POST["idproducto"]));
	$stmt->execute();

	echo "<span class='fa fa-check-square-o'></span> EL AJUSTE DE STOCK DEL PRODUCTO SE HA REALIZADO EXITOSAMENTE";
	exit;
}
###################### FUNCION AJUSTAR STOCK DE PRODUCTOS #########################

########################## FUNCION ELIMINAR PRODUCTOS ###########################
public function EliminarProductos()
{
	$this->p = [];
	if ($_SESSION["acceso"]=="administradorG" || $_SESSION["acceso"]=="administradorS") {

	$sql = "SELECT codproducto FROM detalleventas WHERE codproducto = ? AND codsucursal = ? AND tipodetalle = 1";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codproducto"]),decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		################### ELIMINO PRODUCTO ###################
		$sql = "DELETE FROM productos WHERE codproducto = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codproducto);
		$stmt->bindParam(2,$codsucursal);
		$codproducto = decrypt($_GET["codproducto"]);
		$codsucursal = decrypt($_GET["codsucursal"]);
		$stmt->execute();
		################### ELIMINO PRODUCTO ###################

		################### ELIMINO KARDEX ###################
		$sql = "DELETE FROM kardex WHERE codproducto = ? AND codsucursal = ? AND tipokardex = 1";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codproducto);
		$stmt->bindParam(2,$codsucursal);
		$codproducto = decrypt($_GET["codproducto"]);
		$codsucursal = decrypt($_GET["codsucursal"]);
		$stmt->execute();
		################### ELIMINO KARDEX ###################

		################### ELIMINO PRODUCTO DE COMBO ###################
		$sql = "DELETE FROM combosxproductos WHERE codproducto = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codproducto);
		$stmt->bindParam(2,$codsucursal);
		$codproducto = decrypt($_GET["codproducto"]);
		$codsucursal = decrypt($_GET["codsucursal"]);
		$stmt->execute();
		################### ELIMINO PRODUCTO DE COMBO ###################

		if (file_exists("fotos/productos/".$codsucursal."_".$codproducto.".jpg")){
	    //funcion para eliminar una carpeta con contenido
		$archivos = "fotos/productos/".$codsucursal."_".$codproducto.".jpg";		
		unlink($archivos);
	    } else if (file_exists("fotos/productos/".$codsucursal."_".$codproducto.".jpeg")){
	    //funcion para eliminar una carpeta con contenido
		$archivos = "fotos/productos/".$codsucursal."_".$codproducto.".jpeg";		
		unlink($archivos);
	    } else if (file_exists("fotos/productos/".$codsucursal."_".$codproducto.".png")){
	    //funcion para eliminar una carpeta con contenido
		$archivos = "fotos/productos/".$codsucursal."_".$codproducto.".png";		
		unlink($archivos);
		}

		echo "1";
		exit;

	} else {
		   
		echo "2";
		exit;
    } 
			
	} else {
		
		echo "3";
		exit;
	}	
}
########################## FUNCION ELIMINAR PRODUCTOS #################################

######################## FUNCION BUSCA KARDEX PRODUCTOS ##########################
public function BuscarKardexProducto() 
{
	$this->p = [];
	$sql ="SELECT
	kardex.*,
	usuarios.dni,
	usuarios.nombres,
	usuarios.nivel
	FROM kardex LEFT JOIN usuarios ON kardex.codigo = usuarios.codigo 
	WHERE kardex.codproducto = ? AND kardex.codsucursal = ? AND kardex.tipokardex = 1";
    $stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_GET["codproducto"], decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "<div class='alert alert-danger'>";
		echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
		echo "<center><span class='fa fa-info-circle'></span> NO EXISTEN MOVIMIENTOS EN KARDEX PARA EL PRODUCTO INGRESADO</center>";
		echo "</div>";		
		exit;
	}
	else
	{
		while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
	}
}
######################## FUNCION BUSCA KARDEX PRODUCTOS #########################

######################## FUNCION DETALLE PRODUCTO KARDEX #########################
public function DetalleKardexProducto()
{
	$this->p = [];
	$codProducto = isset($_GET["codproducto"]) ? limpiar($_GET["codproducto"]) : '';
    $codSucursal = isset($_GET["codsucursal"]) ? limpiar(decrypt($_GET["codsucursal"])) : '';
	$sql = "SELECT
	    p.*,
        fam.nomfamilia, subfam.nomsubfamilia, marc.nommarca, mode.nommodelo, pres.nompresentacion,
        col.nomcolor, orig.nomorigen, prov.cuitproveedor, prov.nomproveedor,
		suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
		suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
		tm.moneda, tm.siglas, tm.simbolo,
        tm2.moneda AS moneda2, tm2.siglas AS siglas2, tm2.simbolo AS simbolo2,
        valor_cambio.montocambio,
        ciud.ciudad, com.comuna, 
		doc.documento, doc2.documento AS documento2
    FROM 
        (productos p INNER JOIN sucursales suc ON p.codsucursal = suc.codsucursal)
	LEFT JOIN 
	    impuestos imp ON p.ivaproducto = imp.codimpuesto
    LEFT JOIN 
        familias fam ON p.codfamilia = fam.codfamilia
	LEFT JOIN 
	    subfamilias subfam ON p.codsubfamilia = subfam.codsubfamilia 
	LEFT JOIN 
	    marcas marc ON p.codmarca = marc.codmarca 
	LEFT JOIN 
	    modelos mode ON p.codmodelo = mode.codmodelo
	LEFT JOIN 
	    presentaciones pres ON p.codpresentacion = pres.codpresentacion 
	LEFT JOIN 
	    colores col ON p.codcolor = col.codcolor 
	LEFT JOIN 
	    origenes orig ON p.codorigen=  orig.codorigen 
	LEFT JOIN 
	    proveedores prov ON p.codproveedor = prov.codproveedor
	LEFT JOIN 
	    documentos doc ON suc.documsucursal = doc.coddocumento
	LEFT JOIN 
	    documentos AS doc2 ON suc.documencargado = doc2.coddocumento
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
	LEFT JOIN 
        tiposmoneda tm2 ON suc.codmoneda2 = tm2.codmoneda
    LEFT JOIN 
        ciudades ciud ON suc.id_ciudad = ciud.id_ciudad 
    LEFT JOIN 
        comunas com ON suc.id_comuna = com.id_comuna
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = suc.codmoneda2 
	WHERE p.codproducto = :codProducto AND p.codsucursal = :codSucursal";
	try {
        $stmt = $this->dbh->prepare($sql);
        // Asignamos los parámetros a los marcadores de posición con nombre
        $stmt->bindParam(':codProducto', $codProducto);
        $stmt->bindParam(':codSucursal', $codSucursal);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        if (!$row) {
            echo "<div class='alert alert-danger'>";
            echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
            echo "<center><span class='fa fa-info-circle'></span> PRODUCTO NO ENCONTRADO.</center>";
            echo "</div>";
            exit();
        } else {
            $this->p[] = $row;
            return $this->p;
        }
    } catch (PDOException $e) {
        error_log("Error en DetalleKardexProducto: " . $e->getMessage());
        echo "<div class='alert alert-danger'>";
        echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
        echo "<center><span class='fa fa-exclamation-triangle'></span> OCURRIÓ UN ERROR AL CONSULTAR EL PRODUCTO.</center>";
        echo "</div>";
        return [];
    }
}
######################## FUNCION DETALLE PRODUCTO KARDEX #########################

########################### FUNCION LISTAR KARDEX PRODUCTO VALORIZADO ################################
public function ListarKardexProductosValorizado()
{
	$this->p = [];
	$tipoAcceso      = isset($_SESSION["acceso"]) ? limpiar($_SESSION["acceso"]) : '';
	$codSucursal     = ($tipoAcceso === 'administradorG') ? limpiar(decrypt($_GET["codsucursal"])) : limpiar($_SESSION["codsucursal"]);	
    $whereConditions = [];
    $params          = [];

    // Lógica de filtro basada en el tipo de acceso
    $whereConditions[] = "p.codsucursal = ?";
    $params[]          = $codSucursal;
   
    $whereClause = "";
    if (!empty($whereConditions)) {
      $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $sqlBase = "SELECT
        p.*,
        fam.nomfamilia, subfam.nomsubfamilia, marc.nommarca, mode.nommodelo, pres.nompresentacion,
        col.nomcolor, orig.nomorigen, prov.cuitproveedor, prov.nomproveedor,
		suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
		suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
		tm.moneda, tm.siglas, tm.simbolo,
        tm2.moneda AS moneda2, tm2.siglas AS siglas2, tm2.simbolo AS simbolo2,
        valor_cambio.montocambio,
        ciud.ciudad, com.comuna, 
		doc.documento, doc2.documento AS documento2
    FROM 
        (productos p INNER JOIN sucursales suc ON p.codsucursal = suc.codsucursal)
    LEFT JOIN 
        familias fam ON p.codfamilia = fam.codfamilia
	LEFT JOIN 
	    subfamilias subfam ON p.codsubfamilia = subfam.codsubfamilia 
	LEFT JOIN 
	    marcas marc ON p.codmarca = marc.codmarca 
	LEFT JOIN 
	    modelos mode ON p.codmodelo = mode.codmodelo
	LEFT JOIN 
	    presentaciones pres ON p.codpresentacion = pres.codpresentacion 
	LEFT JOIN 
	    colores col ON p.codcolor = col.codcolor 
	LEFT JOIN 
	    origenes orig ON p.codorigen=  orig.codorigen 
	LEFT JOIN 
	    proveedores prov ON p.codproveedor = prov.codproveedor
	LEFT JOIN 
	    documentos doc ON suc.documsucursal = doc.coddocumento
	LEFT JOIN 
	    documentos AS doc2 ON suc.documencargado = doc2.coddocumento
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
	LEFT JOIN 
        tiposmoneda tm2 ON suc.codmoneda2 = tm2.codmoneda
    LEFT JOIN 
        ciudades ciud ON suc.id_ciudad = ciud.id_ciudad 
    LEFT JOIN 
        comunas com ON suc.id_comuna = com.id_comuna
    LEFT JOIN
       (SELECT
       codcambio, descripcioncambio, montocambio, codmoneda       
       FROM tiposcambio
       ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = suc.codmoneda2
    ";
    $sql = $sqlBase . $whereClause . " ORDER BY p.codproducto ASC";
    try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($results)) {
            return [];
        } else {
            return $results;
        }
    } catch (PDOException $e) {
        error_log("Error en ListarKardexProductosValorizado: " . $e->getMessage());
        return [];
    }
}


public function ListarKardexProductosValorizado888()
{
	$this->p = [];
        
	if ($_SESSION['acceso'] == "administradorG") {

		$sql = "SELECT
	 	productos.idproducto,
	 	productos.codproducto,
	 	productos.producto,
		productos.descripcion,
		productos.opcionvendido,
		productos.imei,
		productos.condicion,
	 	productos.fabricante,
	 	productos.codfamilia,
	 	productos.codsubfamilia,
	 	productos.codmarca,
	 	productos.codmodelo,
	 	productos.codpresentacion,
	 	productos.codcolor,
	 	productos.codorigen,
	 	productos.year,
	 	productos.nroparte,
	 	productos.lote,
	 	productos.peso,
	 	productos.preciocompra,
	 	productos.precioxmayor,
	 	productos.precioxmenor,
	 	productos.precioxpublico,
	 	productos.existencia,
	 	productos.stockoptimo,
	 	productos.stockmedio,
	 	productos.stockminimo,
	 	productos.ivaproducto,
	 	productos.descproducto,
	 	productos.codigobarra,
	 	productos.fechaelaboracion,
	 	productos.fechaoptimo,
	 	productos.fechamedio,
	 	productos.fechaminimo,
	 	productos.codproveedor,
	 	productos.stockteorico,
	 	productos.motivoajuste,
	 	productos.codsucursal,
	 	sucursales.cuitsucursal, 
		sucursales.nomsucursal,
		sucursales.nomencargado,
		sucursales.codmoneda,
		sucursales.codmoneda2,
		documentos.documento,
		documentos2.documento AS documento2,
		tiposmoneda.moneda,
		tiposmoneda.siglas,
		tiposmoneda.simbolo,
		tiposmoneda2.moneda AS moneda2,
		tiposmoneda2.siglas AS siglas2,
		tiposmoneda2.simbolo AS simbolo2,
		valor_cambio.montocambio,
	 	familias.nomfamilia,
	 	subfamilias.nomsubfamilia,
	 	marcas.nommarca,
	 	modelos.nommodelo,
	 	presentaciones.nompresentacion,
	 	colores.nomcolor,
	 	origenes.nomorigen,
	 	proveedores.cuitproveedor,
	 	proveedores.nomproveedor
		FROM (productos INNER JOIN sucursales ON productos.codsucursal = sucursales.codsucursal)
		LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
		LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
		LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
		LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	    LEFT JOIN familias ON productos.codfamilia=familias.codfamilia
		LEFT JOIN subfamilias ON productos.codsubfamilia=subfamilias.codsubfamilia 
		LEFT JOIN marcas ON productos.codmarca=marcas.codmarca 
		LEFT JOIN modelos ON productos.codmodelo = modelos.codmodelo
		LEFT JOIN presentaciones ON productos.codpresentacion=presentaciones.codpresentacion 
		LEFT JOIN colores ON productos.codcolor=colores.codcolor 
		LEFT JOIN origenes ON productos.codorigen=origenes.codorigen
		LEFT JOIN proveedores ON productos.codproveedor=proveedores.codproveedor
		LEFT JOIN
	        (SELECT
	        codcambio, descripcioncambio, montocambio, codmoneda       
	        FROM tiposcambio
	        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2 
		WHERE productos.codsucursal = '".limpiar(decrypt($_GET["codsucursal"]))."'";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		return $this->p;

   } else {

	 	$sql = "SELECT
	 	productos.idproducto,
	 	productos.codproducto,
	 	productos.producto,
		productos.descripcion,
		productos.opcionvendido,
		productos.imei,
		productos.condicion,
	 	productos.fabricante,
	 	productos.codfamilia,
	 	productos.codsubfamilia,
	 	productos.codmarca,
	 	productos.codmodelo,
	 	productos.codpresentacion,
	 	productos.codcolor,
	 	productos.codorigen,
	 	productos.year,
	 	productos.nroparte,
	 	productos.lote,
	 	productos.peso,
	 	productos.preciocompra,
	 	productos.precioxmayor,
	 	productos.precioxmenor,
	 	productos.precioxpublico,
	 	productos.existencia,
	 	productos.stockoptimo,
	 	productos.stockmedio,
	 	productos.stockminimo,
	 	productos.ivaproducto,
	 	productos.descproducto,
	 	productos.codigobarra,
	 	productos.fechaelaboracion,
	 	productos.fechaoptimo,
	 	productos.fechamedio,
	 	productos.fechaminimo,
	 	productos.codproveedor,
	 	productos.stockteorico,
	 	productos.motivoajuste,
	 	productos.codsucursal,
	 	sucursales.cuitsucursal, 
		sucursales.nomsucursal,
		sucursales.codmoneda,
		sucursales.codmoneda2,
		documentos.documento,
		documentos2.documento AS documento2,
		tiposmoneda.moneda,
		tiposmoneda.siglas,
		tiposmoneda.simbolo,
		tiposmoneda2.moneda AS moneda2,
		tiposmoneda2.siglas AS siglas2,
		tiposmoneda2.simbolo AS simbolo2,
		valor_cambio.montocambio,
	 	familias.nomfamilia,
	 	subfamilias.nomsubfamilia,
	 	marcas.nommarca,
	 	modelos.nommodelo,
	 	presentaciones.nompresentacion,
	 	colores.nomcolor,
	 	origenes.nomorigen,
	 	proveedores.cuitproveedor,
	 	proveedores.nomproveedor
		FROM (productos INNER JOIN sucursales ON productos.codsucursal = sucursales.codsucursal)
		LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
		LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
		LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
		LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	    LEFT JOIN familias ON productos.codfamilia=familias.codfamilia
		LEFT JOIN subfamilias ON productos.codsubfamilia=subfamilias.codsubfamilia 
		LEFT JOIN marcas ON productos.codmarca=marcas.codmarca 
		LEFT JOIN modelos ON productos.codmodelo = modelos.codmodelo
		LEFT JOIN presentaciones ON productos.codpresentacion=presentaciones.codpresentacion 
		LEFT JOIN colores ON productos.codcolor=colores.codcolor 
		LEFT JOIN origenes ON productos.codorigen=origenes.codorigen
		LEFT JOIN proveedores ON productos.codproveedor=proveedores.codproveedor
		LEFT JOIN
	        (SELECT
	        codcambio, descripcioncambio, montocambio, codmoneda       
	        FROM tiposcambio
	        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2 
		WHERE productos.codsucursal = '".limpiar($_SESSION["codsucursal"])."'";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		return $this->p;
    }
}
########################## FUNCION LISTAR KARDEX PRODUCTO VALORIZADO ################################

###################### FUNCION PRODUCTOS VALORIZADO POR FECHAS Y VENDEDOR #########################
public function BuscarProductosValorizadoxFechas() 
{
	$this->p = [];
    $sql ="SELECT 
    detalleventas.idproducto,
    detalleventas.codproducto, 
    detalleventas.producto,
	detalleventas.descripcion,
	detalleventas.opcionvendido,
	detalleventas.imei,
	detalleventas.condicion, 
    detalleventas.codmarca,
    detalleventas.codmodelo,
    detalleventas.codpresentacion,
	detalleventas.codcolor,
    detalleventas.preciocompra,  
    detalleventas.precioventa,  
    detalleventas.ivaproducto,
    detalleventas.descproducto,
    detalleventas.tipodetalle,
    marcas.nommarca, 
    modelos.nommodelo,
    presentaciones.nompresentacion,
    colores.nomcolor,
    ventas.iva, 
    sucursales.cuitsucursal, 
    sucursales.nomsucursal,
    sucursales.nomencargado,
    sucursales.codmoneda,
    sucursales.codmoneda2,
    documentos.documento,
    documentos2.documento AS documento2,
    tiposmoneda.moneda,
    tiposmoneda.siglas,
    tiposmoneda.simbolo,
    tiposmoneda2.moneda AS moneda2,
    tiposmoneda2.siglas AS siglas2,
    tiposmoneda2.simbolo AS simbolo2,
    valor_cambio.montocambio,
    usuarios.dni,
    usuarios.nombres, 
    SUM(detalleventas.cantventa) AS cantidad,
    pag.existencia 
    FROM (detalleventas LEFT JOIN ventas ON detalleventas.codventa = ventas.codventa)
    INNER JOIN sucursales ON ventas.codsucursal = sucursales.codsucursal
    LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
    LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
    LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
    LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
    LEFT JOIN productos ON detalleventas.idproducto = productos.idproducto 
    LEFT JOIN marcas ON detalleventas.codmarca = marcas.codmarca 
    LEFT JOIN modelos ON detalleventas.codmodelo = modelos.codmodelo
	LEFT JOIN presentaciones ON detalleventas.codpresentacion = presentaciones.codpresentacion 
	LEFT JOIN colores ON detalleventas.codcolor = colores.codcolor  
    LEFT JOIN usuarios ON ventas.codigo = usuarios.codigo

    LEFT JOIN
		(SELECT
		idproducto,
		existencia
		FROM productos WHERE codsucursal = '".limpiar(decrypt($_GET['codsucursal']))."') pag ON pag.idproducto = detalleventas.idproducto

    LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2
    WHERE ventas.codsucursal = '".decrypt($_GET['codsucursal'])."' 
    AND ventas.codigo = ? 
    AND DATE_FORMAT(ventas.fechaventa,'%Y-%m-%d') BETWEEN ? AND ?
    AND detalleventas.tipodetalle = 1 
    GROUP BY
    detalleventas.idproducto,
    detalleventas.codproducto, 
    detalleventas.producto,
	detalleventas.descripcion,
	detalleventas.opcionvendido,
	detalleventas.imei,
	detalleventas.condicion, 
    detalleventas.codmarca,
    detalleventas.codmodelo,
    detalleventas.codpresentacion,
	detalleventas.codcolor,
    detalleventas.preciocompra,  
    detalleventas.precioventa,  
    detalleventas.ivaproducto,
    detalleventas.descproducto,
    detalleventas.tipodetalle,
    marcas.nommarca, 
    modelos.nommodelo,
    presentaciones.nompresentacion,
    colores.nomcolor,
    ventas.iva, 
    sucursales.cuitsucursal, 
    sucursales.nomsucursal,
    sucursales.nomencargado,
    sucursales.codmoneda,
    sucursales.codmoneda2,
    documentos.documento,
    documento2,
    tiposmoneda.moneda,
    tiposmoneda.siglas,
    tiposmoneda.simbolo,
    moneda2,
    siglas2,
    simbolo2,
    valor_cambio.montocambio,
    usuarios.dni,
    usuarios.nombres 
    ORDER BY detalleventas.codproducto ASC";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindValue(1, trim($_GET['codigo']));
	$stmt->bindValue(2, trim(date("Y-m-d",strtotime($_GET['desde']))));
	$stmt->bindValue(3, trim(date("Y-m-d",strtotime($_GET['hasta']))));
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "<div class='alert alert-danger'>";
		echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
		echo "<center><span class='fa fa-info-circle'></span> NO EXISTEN PRODUCTOS FACTURADOS PARA EL VENDEDOR Y RANGO DE FECHA INGRESADA</center>";
		echo "</div>";		
		exit;
	}
	else
	{
		while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
	}
}
########################### FUNCION PRODUCTOS VALORIZADO POR FECHAS Y VENDEDOR ###############################

###################### FUNCION BUSCAR PRODUCTOS VENDIDOS POR FECHAS #########################
public function BuscarProductosVendidosxFechas() 
{
	$this->p = [];
	$sql ="SELECT
	detalleventas.idproducto, 
	detalleventas.codproducto,
	detalleventas.producto,
	detalleventas.descripcion,
	detalleventas.opcionvendido,
	detalleventas.imei,
	detalleventas.condicion, 
	detalleventas.codmarca,
	detalleventas.codmodelo, 
	detalleventas.codpresentacion,
	detalleventas.codcolor, 
	detalleventas.preciocompra, 
	detalleventas.precioventa, 
	detalleventas.ivaproducto,
	detalleventas.descproducto,
    detalleventas.tipodetalle,
	productos.existencia,
	marcas.nommarca, 
	modelos.nommodelo,
	presentaciones.nompresentacion,
	colores.nomcolor,
	ventas.iva, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal, 
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	documentos.documento,
	documentos2.documento AS documento2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	tiposmoneda2.moneda AS moneda2,
	tiposmoneda2.siglas AS siglas2,
	tiposmoneda2.simbolo AS simbolo2,
	valor_cambio.montocambio, 
	SUM(detalleventas.cantventa) AS cantidad,
	SUM(detalleventas.totaldescuentov) as totaldescuentov,
	SUM(detalleventas.subtotalimpuestos) as subtotalimpuestos 
	FROM (ventas INNER JOIN detalleventas ON ventas.codventa = detalleventas.codventa) 
	INNER JOIN sucursales ON ventas.codsucursal = sucursales.codsucursal
	LEFT JOIN documentos ON sucursales.documsucursal = documentos.coddocumento
	LEFT JOIN documentos AS documentos2 ON sucursales.documencargado = documentos2.coddocumento
	LEFT JOIN tiposmoneda ON sucursales.codmoneda = tiposmoneda.codmoneda
	LEFT JOIN tiposmoneda AS tiposmoneda2 ON sucursales.codmoneda2 = tiposmoneda2.codmoneda
	LEFT JOIN productos ON detalleventas.idproducto = productos.idproducto
	LEFT JOIN marcas ON detalleventas.codmarca = marcas.codmarca 
    LEFT JOIN modelos ON detalleventas.codmodelo = modelos.codmodelo
	LEFT JOIN presentaciones ON detalleventas.codpresentacion = presentaciones.codpresentacion 
	LEFT JOIN colores ON detalleventas.codcolor = colores.codcolor 
	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = sucursales.codmoneda2
	WHERE ventas.codsucursal = '".decrypt($_GET['codsucursal'])."' 
	AND DATE_FORMAT(ventas.fechaventa,'%Y-%m-%d') BETWEEN ? AND ?
	AND detalleventas.tipodetalle = 1 
	GROUP BY
	detalleventas.idproducto, 
	detalleventas.codproducto,
	detalleventas.producto,
	detalleventas.descripcion,
	detalleventas.opcionvendido,
	detalleventas.imei,
	detalleventas.condicion, 
	detalleventas.codmarca,
	detalleventas.codmodelo, 
	detalleventas.codpresentacion,
	detalleventas.codcolor, 
	detalleventas.preciocompra, 
	detalleventas.precioventa, 
	detalleventas.ivaproducto,
	detalleventas.descproducto,
    detalleventas.tipodetalle,
	productos.existencia,
	marcas.nommarca, 
	modelos.nommodelo,
	presentaciones.nompresentacion,
	colores.nomcolor,
	ventas.iva, 
	sucursales.cuitsucursal, 
	sucursales.nomsucursal, 
	sucursales.nomencargado,
	sucursales.codmoneda,
	sucursales.codmoneda2,
	documentos.documento,
	documento2,
	tiposmoneda.moneda,
	tiposmoneda.siglas,
	tiposmoneda.simbolo,
	moneda2,
	siglas2,
	simbolo2,
	valor_cambio.montocambio
	ORDER BY detalleventas.codproducto ASC";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindValue(1, trim(date("Y-m-d",strtotime($_GET['desde']))));
	$stmt->bindValue(2, trim(date("Y-m-d",strtotime($_GET['hasta']))));
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "<div class='alert alert-danger'>";
		echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
		echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS EN TU BÚSQUEDA REALIZADA</center>";
		echo "</div>";		
		exit;
	}
	else
	{
		while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
	}
}
########################### FUNCION PRODUCTOS VENDIDOS POR FECHAS ###############################

############################### FIN DE CLASE PRODUCTOS ###############################
























################################# CLASE COMBOS ######################################

########################### FUNCION REGISTRAR PRODUCTOS ###############################
public function RegistrarCombos()
{
	$this->p = [];
	if(empty($_POST["codcombo"]) or empty($_POST["nomcombo"]) or empty($_POST["codfamilia"]) or empty($_POST["precioventa"]) or empty($_POST["existencia"]) or empty($_POST["ivacombo"]) or empty($_POST["codsucursal"]))
	{
		echo "1";
		exit;
	}

	if(!empty($_SESSION["CarritoProducto"])){

	############ VALIDO SI LA CANTIDAD ES MAYOR QUE LA EXISTENCIA #############
	$v = $_SESSION["CarritoProducto"];
	for($i=0;$i<count($v);$i++){

		$sql = "SELECT existencia
		FROM productos 
		WHERE codproducto = '".limpiar($v[$i]['txtCodigo'])."'
		AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		
		$cantproductobd = $row['existencia'];
		$cantidad       = $v[$i]['cantidad'];

        if($cantidad == "" || $cantidad == 0 || $cantidad == 0.00){

		    echo "2";
		    exit();
	    }
	    elseif ($cantidad > $cantproductobd) 
        { 
		    echo "3";
		    exit;
	    } 
	}
	############ VALIDO SI LA CANTIDAD ES MAYOR QUE LA EXISTENCIA #############

    }

    ############## OBTENGO VALOR DE IMPUESTO #################
	$sql = "SELECT 
	valorimpuesto 
	FROM impuestos 
	WHERE statusimpuesto = 1";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$valor = (empty($row['valorimpuesto']) ? "0.00" : $row['valorimpuesto']);
	############## OBTENGO VALOR DE IMPUESTO #################

	############## CREO CODIGO DE COMBO #################
	/*$sql = "SELECT codcombo
	FROM combos 
	WHERE codsucursal = '".decrypt($_POST["codsucursal"])."' 
	ORDER BY idcombo DESC LIMIT 1";
	foreach ($this->dbh->query($sql) as $row){

		$combo = $row["codcombo"];
	}
	$codcombo = limpiar(empty($combo) ? "1" : $combo + 1);*/
	############## CREO CODIGO DE COMBO #################

	$sql = " SELECT nomcombo FROM combos WHERE nomcombo = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST["nomcombo"],decrypt($_POST["codsucursal"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
	    $query = "INSERT INTO combos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codcombo);
		$stmt->bindParam(2, $nomcombo);
		$stmt->bindParam(3, $codfamilia);
		$stmt->bindParam(4, $preciocompra);
		$stmt->bindParam(5, $precioventa);
		$stmt->bindParam(6, $existencia);
		$stmt->bindParam(7, $stockminimo);
		$stmt->bindParam(8, $stockmaximo);
		$stmt->bindParam(9, $ivacombo);
		$stmt->bindParam(10, $desccombo);
	    $stmt->bindParam(11, $codsucursal);

		$codcombo     = limpiar($_POST["codcombo"]);
		$nomcombo     = limpiar($_POST["nomcombo"]);
		$codfamilia   = limpiar(decrypt($_POST["codfamilia"]));
		$preciocompra = limpiar($_POST["preciocompra"]);
		$precioventa  = limpiar($_POST["precioventa"]);
		$existencia   = limpiar($_POST["existencia"]);
		$stockminimo  = limpiar($_POST["stockminimo"]);
		$stockmaximo  = limpiar($_POST["stockmaximo"]);
		$ivacombo     = limpiar($_POST["ivacombo"]);
		$desccombo    = limpiar($_POST["desccombo"]);
	    $codsucursal  = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();

	    ##################### REGISTRAMOS LOS DATOS DE COMBOS EN KARDEX #####################
		$query = "INSERT INTO kardex values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codproceso);
		$stmt->bindParam(2, $codresponsable);
		$stmt->bindParam(3, $codcombo);
		$stmt->bindParam(4, $movimiento);
		$stmt->bindParam(5, $entradas);
		$stmt->bindParam(6, $salidas);
		$stmt->bindParam(7, $devolucion);
		$stmt->bindParam(8, $stockactual);
		$stmt->bindParam(9, $ivacombo);
		$stmt->bindParam(10, $desccombo);
		$stmt->bindParam(11, $precio);
		$stmt->bindParam(12, $documento);
		$stmt->bindParam(13, $fechakardex);
		$stmt->bindParam(14, $tipokardex);
		$stmt->bindParam(15, $procedimiento);
		$stmt->bindParam(16, $codsucursal);
		$stmt->bindParam(17, $codigo);

		$codproceso     = limpiar($codcombo);
		$codresponsable = limpiar("0");
		$movimiento     = limpiar("ENTRADAS");
		$entradas       = limpiar($_POST['existencia']);
		$salidas        = limpiar("0");
		$devolucion     = limpiar("0");
		$stockactual    = limpiar($_POST['existencia']);
		$ivacombo       = limpiar($_POST["ivacombo"] == "SI" ? $valor : $_POST["ivacombo"]);
		$desccombo      = limpiar($_POST["desccombo"]);
		$precio         = limpiar($_POST['precioventa']);
		$documento      = limpiar("INVENTARIO INICIAL");
		$fechakardex    = limpiar(date("Y-m-d"));
		$tipokardex     = limpiar("2");
		$procedimiento  = limpiar("2");
		$codsucursal    = limpiar(decrypt($_POST["codsucursal"]));
	    $codigo         = limpiar($_SESSION["codigo"]);
		$stmt->execute();
	    ##################### REGISTRAMOS LOS DATOS DE COMBOS EN KARDEX #####################

    ############################## SUBIR FOTO DE COMBO ##############################
	$permitidos = array("image/jpg", "image/jpeg", "image/png");
	$limite_kb = 8000000;//1MB

    //datos del arhivo  
    $nombre_archivo = limpiar(isset($_FILES['imagen']['name']) ? $_FILES['imagen']['name'] : "");
	$tipo_archivo   = limpiar(isset($_FILES['imagen']['type']) ? $_FILES['imagen']['type'] : "");
	$tamano_archivo = limpiar(isset($_FILES['imagen']['size']) ? $_FILES['imagen']['size'] : "");
	$file           = new SplFileInfo($nombre_archivo);
	$extension      = $file->getExtension();

    //compruebo si las características del archivo son las que deseo 
    if (!empty($_FILES["imagen"]) && in_array($_FILES['imagen']['type'], $permitidos)){
 
      if (move_uploaded_file($_FILES['imagen']['tmp_name'], "./fotos/combos/".$codsucursal."/".$nombre_archivo) && rename("./fotos/combos/".$codsucursal."/".$nombre_archivo,"./fotos/combos/".$codsucursal."/".$codcombo.".".$extension))
	   { 
	   ## se puede dar un aviso
	   } 
	   ## se puede dar otro aviso 
	}
	############################## SUBIR FOTO DE COMBO ##############################

	if(!empty($_SESSION["CarritoProducto"])){

	################## PROCESO DE REGISTRO DE PRODUCTOS A COMBOS ####################
	$this->dbh->beginTransaction();

	$detalle = $_SESSION["CarritoProducto"];
	for($i=0;$i<count($detalle);$i++){

		$query = " INSERT INTO combosxproductos values (null, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codcombo);
		$stmt->bindParam(2, $idproducto);
		$stmt->bindParam(3, $codproducto);
		$stmt->bindParam(4, $cantidad);
		$stmt->bindParam(5, $codsucursal);
		
		$idproducto  = limpiar($detalle[$i]['id']);
		$codproducto = limpiar($detalle[$i]['txtCodigo']);
		$cantidad    = $detalle[$i]['opcionvendido'] == "2" ? number_format($detalle[$i]['cantidad'], 3, '.', '') : number_format($detalle[$i]['cantidad'], 0, '.', '');
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();
	}
	unset($_SESSION["CarritoProducto"]);
    $this->dbh->commit();
	################### PROCESO DE REGISTRO DE PRODUCTOS A COMBOS ##################

    }
		echo "<span class='fa fa-check-square-o'></span> EL COMBO HA SIDO REGISTRADO EXITOSAMENTE";
		exit;

	} else {

		echo "4";
		exit;
	}
}
########################## FUNCION REGISTRAR COMBOS ###############################

########################### FUNCION LISTAR COMBOS ################################
public function ListarCombos()
{
    $this->p = [];
    $tipoAcceso      = isset($_SESSION["acceso"]) ? limpiar($_SESSION["acceso"]) : '';
    $codSucursal     = ($tipoAcceso === 'administradorG') ? limpiar(decrypt($_GET["codsucursal"])) : limpiar($_SESSION["codsucursal"]);
    $whereConditions = [];
    $params          = [];

    // Lógica de filtro basada en el tipo de acceso
    $whereConditions[] = "com.codsucursal = ?";
    $params[]          = $codSucursal;
    
    $whereClause = "";
    if (!empty($whereConditions)) {
        $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    
    $sqlBase = "SELECT
        com.idcombo, com.codcombo, com.nomcombo, com.codfamilia, com.preciocompra, com.precioventa,
        com.existencia, com.stockminimo, com.stockmaximo, com.ivacombo, com.desccombo, com.codsucursal,
        fam.nomfamilia,
        suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
        suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
        tm.moneda, tm.siglas, tm.simbolo,
        tm2.moneda AS moneda2, tm2.siglas AS siglas2, tm2.simbolo AS simbolo2,
        valor_cambio.montocambio,
        ciud.ciudad, comun.comuna,
        doc.documento, doc2.documento AS documento2,
        pag.detalles_productos, pag.stock_combo
    FROM
        (combos com INNER JOIN sucursales suc ON com.codsucursal = suc.codsucursal)
    LEFT JOIN
        impuestos imp ON com.ivacombo = imp.codimpuesto
    LEFT JOIN
        familias fam ON com.codfamilia = fam.codfamilia
    LEFT JOIN
        documentos doc ON suc.documsucursal = doc.coddocumento
    LEFT JOIN
        documentos AS doc2 ON suc.documencargado = doc2.coddocumento
    LEFT JOIN
        tiposmoneda tm ON suc.codmoneda = tm.codmoneda
    LEFT JOIN
        tiposmoneda tm2 ON suc.codmoneda2 = tm2.codmoneda
    LEFT JOIN
        ciudades ciud ON suc.id_ciudad = ciud.id_ciudad
    LEFT JOIN
        comunas comun ON suc.id_comuna = comun.id_comuna
    
    LEFT JOIN
        (SELECT
            cxp.codcombo,
            SUM(cxp.cantidad) AS articulos,
            GROUP_CONCAT(
                CONCAT_WS(
                    ' | ',
                    cxp.cantidad,
                    p.producto,
                    p.descripcion,
                    IFNULL(mar.nommarca, ''),
                    IFNULL(mode.nommodelo, ''),
                    IFNULL(pres.nompresentacion, ''),
                    IFNULL(col.nomcolor, '')
                )
                ORDER BY p.producto
                SEPARATOR '<br>'
            ) AS detalles_productos,
            MIN(FLOOR(p.existencia / cxp.cantidad)) AS stock_combo
        FROM
            combosxproductos cxp
        LEFT JOIN
            productos p ON cxp.idproducto = p.idproducto
        LEFT JOIN
            marcas mar ON p.codmarca = mar.codmarca
        LEFT JOIN
            modelos mode ON p.codmodelo = mode.codmodelo
        LEFT JOIN
            presentaciones pres ON p.codpresentacion = pres.codpresentacion
        LEFT JOIN
            colores col ON p.codcolor = col.codcolor
        WHERE cxp.codsucursal = ?
        GROUP BY cxp.codcombo
        ) pag ON pag.codcombo = com.codcombo
    
    LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = suc.codmoneda2";
    // Aunque tienen el mismo valor, deben estar en el orden correcto para el execute().
    $params_combined = [$codSucursal, $codSucursal];
    // Ahora construyes la consulta final con el orden correcto.
    $groupByClause = " GROUP BY ";
    $groupByClause .= "com.idcombo, com.codcombo, com.nomcombo, com.codfamilia, com.preciocompra, com.precioventa,
        com.existencia, com.stockminimo, com.stockmaximo, com.ivacombo, com.desccombo, com.codsucursal,
        fam.nomfamilia,
        suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
        suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
        tm.moneda, tm.siglas, tm.simbolo,
        moneda2, siglas2, simbolo2,
        valor_cambio.montocambio,
        ciud.ciudad, comun.comuna,
        doc.documento, documento2,
        pag.detalles_productos, pag.stock_combo";
    $sql = $sqlBase . $whereClause . $groupByClause . " ORDER BY com.codcombo ASC";
    try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute($params_combined);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($results)) {
            return [];
        } else {
            return $results;
        }
    } catch (PDOException $e) {
        error_log("Error en ListarCombos: " . $e->getMessage());
        return [];
    }
}
########################## FUNCION LISTAR COMBOS ################################

########################### FUNCION LISTAR COMBOS EN STOCK MINIMO ################################
public function ListarCombosMinimo()
{
    $this->p = [];
    $tipoAcceso      = isset($_SESSION["acceso"]) ? limpiar($_SESSION["acceso"]) : '';
    $codSucursal     = ($tipoAcceso === 'administradorG') ? limpiar(decrypt($_GET["codsucursal"])) : limpiar($_SESSION["codsucursal"]);
    $whereConditions = [];
    $params          = [];

    // Lógica de filtro basada en el tipo de acceso
    $whereConditions[] = "com.codsucursal = ?";
    $params[]          = $codSucursal;
    $whereConditions[] = "CAST(com.existencia AS DECIMAL(10,2)) <= CAST(com.stockminimo AS DECIMAL(10,2))";
    
    $whereClause = "";
    if (!empty($whereConditions)) {
        $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    
    $sqlBase = "SELECT
        com.idcombo, com.codcombo, com.nomcombo, com.codfamilia, com.preciocompra, com.precioventa,
        com.existencia, com.stockminimo, com.stockmaximo, com.ivacombo, com.desccombo, com.codsucursal,
        fam.nomfamilia,
        suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
        suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
        tm.moneda, tm.siglas, tm.simbolo,
        tm2.moneda AS moneda2, tm2.siglas AS siglas2, tm2.simbolo AS simbolo2,
        valor_cambio.montocambio,
        ciud.ciudad, comun.comuna,
        doc.documento, doc2.documento AS documento2,
        pag.detalles_productos, pag.stock_combo
    FROM
        (combos com INNER JOIN sucursales suc ON com.codsucursal = suc.codsucursal)
    LEFT JOIN
        impuestos imp ON com.ivacombo = imp.codimpuesto
    LEFT JOIN
        familias fam ON com.codfamilia = fam.codfamilia
    LEFT JOIN
        documentos doc ON suc.documsucursal = doc.coddocumento
    LEFT JOIN
        documentos AS doc2 ON suc.documencargado = doc2.coddocumento
    LEFT JOIN
        tiposmoneda tm ON suc.codmoneda = tm.codmoneda
    LEFT JOIN
        tiposmoneda tm2 ON suc.codmoneda2 = tm2.codmoneda
    LEFT JOIN
        ciudades ciud ON suc.id_ciudad = ciud.id_ciudad
    LEFT JOIN
        comunas comun ON suc.id_comuna = comun.id_comuna
    
    LEFT JOIN
        (SELECT
            cxp.codcombo,
            SUM(cxp.cantidad) AS articulos,
            GROUP_CONCAT(
                CONCAT_WS(
                    ' | ',
                    cxp.cantidad,
                    p.producto,
                    p.descripcion,
                    IFNULL(mar.nommarca, ''),
                    IFNULL(mode.nommodelo, ''),
                    IFNULL(pres.nompresentacion, ''),
                    IFNULL(col.nomcolor, '')
                )
                ORDER BY p.producto
                SEPARATOR '<br>'
            ) AS detalles_productos,
            MIN(FLOOR(p.existencia / cxp.cantidad)) AS stock_combo
        FROM
            combosxproductos cxp
        LEFT JOIN
            productos p ON cxp.idproducto = p.idproducto
        LEFT JOIN
            marcas mar ON p.codmarca = mar.codmarca
        LEFT JOIN
            modelos mode ON p.codmodelo = mode.codmodelo
        LEFT JOIN
            presentaciones pres ON p.codpresentacion = pres.codpresentacion
        LEFT JOIN
            colores col ON p.codcolor = col.codcolor
        WHERE cxp.codsucursal = ?
        GROUP BY cxp.codcombo
        ) pag ON pag.codcombo = com.codcombo
    
    LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = suc.codmoneda2";
    // Aunque tienen el mismo valor, deben estar en el orden correcto para el execute().
    $params_combined = [$codSucursal, $codSucursal];
    // Ahora construyes la consulta final con el orden correcto.
    $groupByClause = " GROUP BY ";
    $groupByClause .= "com.idcombo, com.codcombo, com.nomcombo, com.codfamilia, com.preciocompra, com.precioventa,
        com.existencia, com.stockminimo, com.stockmaximo, com.ivacombo, com.desccombo, com.codsucursal,
        fam.nomfamilia,
        suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
        suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
        tm.moneda, tm.siglas, tm.simbolo,
        moneda2, siglas2, simbolo2,
        valor_cambio.montocambio,
        ciud.ciudad, comun.comuna,
        doc.documento, documento2,
        pag.detalles_productos, pag.stock_combo";
    $sql = $sqlBase . $whereClause . $groupByClause . " ORDER BY com.codcombo ASC";
    try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute($params_combined);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($results)) {
            return [];
        } else {
            return $results;
        }
    } catch (PDOException $e) {
        error_log("Error en ListarCombosMinimo: " . $e->getMessage());
        return [];
    }
}
########################## FUNCION LISTAR COMBOS EN STOCK MINIMO ################################

########################### FUNCION LISTAR COMBOS EN STOCK MAXIMO ################################
public function ListarCombosMaximo()
{
    $this->p = [];
    $tipoAcceso      = isset($_SESSION["acceso"]) ? limpiar($_SESSION["acceso"]) : '';
    $codSucursal     = ($tipoAcceso === 'administradorG') ? limpiar(decrypt($_GET["codsucursal"])) : limpiar($_SESSION["codsucursal"]);
    $whereConditions = [];
    $params          = [];

    // Lógica de filtro basada en el tipo de acceso
    $whereConditions[] = "com.codsucursal = ?";
    $params[]          = $codSucursal;
    $whereConditions[] = "CAST(com.existencia AS DECIMAL(10,2)) >= CAST(com.stockmaximo AS DECIMAL(10,2))";
    
    $whereClause = "";
    if (!empty($whereConditions)) {
        $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    
    $sqlBase = "SELECT
        com.idcombo, com.codcombo, com.nomcombo, com.codfamilia, com.preciocompra, com.precioventa,
        com.existencia, com.stockminimo, com.stockmaximo, com.ivacombo, com.desccombo, com.codsucursal,
        fam.nomfamilia,
        suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
        suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
        tm.moneda, tm.siglas, tm.simbolo,
        tm2.moneda AS moneda2, tm2.siglas AS siglas2, tm2.simbolo AS simbolo2,
        valor_cambio.montocambio,
        ciud.ciudad, comun.comuna,
        doc.documento, doc2.documento AS documento2,
        pag.detalles_productos, pag.stock_combo
    FROM
        (combos com INNER JOIN sucursales suc ON com.codsucursal = suc.codsucursal)
    LEFT JOIN
        impuestos imp ON com.ivacombo = imp.codimpuesto
    LEFT JOIN
        familias fam ON com.codfamilia = fam.codfamilia
    LEFT JOIN
        documentos doc ON suc.documsucursal = doc.coddocumento
    LEFT JOIN
        documentos AS doc2 ON suc.documencargado = doc2.coddocumento
    LEFT JOIN
        tiposmoneda tm ON suc.codmoneda = tm.codmoneda
    LEFT JOIN
        tiposmoneda tm2 ON suc.codmoneda2 = tm2.codmoneda
    LEFT JOIN
        ciudades ciud ON suc.id_ciudad = ciud.id_ciudad
    LEFT JOIN
        comunas comun ON suc.id_comuna = comun.id_comuna
    
    LEFT JOIN
        (SELECT
            cxp.codcombo,
            SUM(cxp.cantidad) AS articulos,
            GROUP_CONCAT(
                CONCAT_WS(
                    ' | ',
                    cxp.cantidad,
                    p.producto,
                    p.descripcion,
                    IFNULL(mar.nommarca, ''),
                    IFNULL(mode.nommodelo, ''),
                    IFNULL(pres.nompresentacion, ''),
                    IFNULL(col.nomcolor, '')
                )
                ORDER BY p.producto
                SEPARATOR '<br>'
            ) AS detalles_productos,
            MIN(FLOOR(p.existencia / cxp.cantidad)) AS stock_combo
        FROM
            combosxproductos cxp
        LEFT JOIN
            productos p ON cxp.idproducto = p.idproducto
        LEFT JOIN
            marcas mar ON p.codmarca = mar.codmarca
        LEFT JOIN
            modelos mode ON p.codmodelo = mode.codmodelo
        LEFT JOIN
            presentaciones pres ON p.codpresentacion = pres.codpresentacion
        LEFT JOIN
            colores col ON p.codcolor = col.codcolor
        WHERE cxp.codsucursal = ?
        GROUP BY cxp.codcombo
        ) pag ON pag.codcombo = com.codcombo
    
    LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = suc.codmoneda2";
    // Aunque tienen el mismo valor, deben estar en el orden correcto para el execute().
    $params_combined = [$codSucursal, $codSucursal];
    // Ahora construyes la consulta final con el orden correcto.
    $groupByClause = " GROUP BY ";
    $groupByClause .= "com.idcombo, com.codcombo, com.nomcombo, com.codfamilia, com.preciocompra, com.precioventa,
        com.existencia, com.stockminimo, com.stockmaximo, com.ivacombo, com.desccombo, com.codsucursal,
        fam.nomfamilia,
        suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
        suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
        tm.moneda, tm.siglas, tm.simbolo,
        moneda2, siglas2, simbolo2,
        valor_cambio.montocambio,
        ciud.ciudad, comun.comuna,
        doc.documento, documento2,
        pag.detalles_productos, pag.stock_combo";
    $sql = $sqlBase . $whereClause . $groupByClause . " ORDER BY com.codcombo ASC";
    try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute($params_combined);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($results)) {
            return [];
        } else {
            return $results;
        }
    } catch (PDOException $e) {
        error_log("Error en ListarCombosMaximo: " . $e->getMessage());
        return [];
    }
}
########################## FUNCION LISTAR COMBOS EN STOCK MAXIMO ################################

############################# FUNCION LISTAR COMBOS EN MODAL ################################
public function ListarCombosPorFiltro(
    $familia_nombre    = '',
    $criterio_busqueda = '',
    $limit             = null,
    $offset            = null
) {
    $this->p = [];
    $codsucursal = limpiar($_SESSION["codsucursal"]); 
    // Parte base de la consulta
    $sql_base = "SELECT
    com.idcombo, com.codcombo, com.nomcombo, com.codfamilia, com.preciocompra, com.precioventa,
    com.existencia, com.stockminimo, com.stockmaximo, com.ivacombo, com.desccombo, com.codsucursal,
	fa.nomfamilia,
	s.codmoneda,
	tp.moneda, tp.siglas, tp.simbolo
	FROM combos com
    INNER JOIN sucursales s ON com.codsucursal = s.codsucursal
	LEFT JOIN tiposmoneda tp ON s.codmoneda = tp.codmoneda
    LEFT JOIN familias fa ON com.codfamilia = fa.codfamilia
    WHERE com.codsucursal = :codsucursal AND com.existencia != 0.00";
    $params = [':codsucursal' => $codsucursal];
    $sql_condiciones = ""; // Para agregar las condiciones WHERE dinámicas
    // Añadir filtro por familia
    if (!empty($familia_nombre) && $familia_nombre !== 'todos') {
        $sql_condiciones .= " AND fa.nomfamilia = :nomfamilia";
        $params[':nomfamilia'] = $familia_nombre;
    }
    // Añadir filtro por búsqueda (busqueda en nomcombo, codcombo)
    if (!empty($criterio_busqueda)) {
        $sql_condiciones .= " AND (com.nomcombo LIKE :busqueda_prod OR com.codcombo LIKE :busqueda_codprod)";
        $params[':busqueda_prod']    = '%' . $criterio_busqueda . '%';
        $params[':busqueda_codprod'] = '%' . $criterio_busqueda . '%';
        //$params[':busqueda_codbarra'] = '%' . $criterio_busqueda . '%';
    }
    $sql_orden = " ORDER BY com.nomcombo ASC"; // Ordenamiento
    $sql_limit_offset = ""; // Para paginación
    // Añadir paginación (LIMIT y OFFSET)
    if (is_numeric($limit) && $limit > 0) {
        $sql_limit_offset .= " LIMIT :limit";
        $params[':limit'] = (int)$limit;
        if (is_numeric($offset) && $offset >= 0) {
            $sql_limit_offset .= " OFFSET :offset";
            $params[':offset'] = (int)$offset;
        }
    }
    // Construye la consulta final
    $sql = $sql_base . $sql_condiciones . $sql_orden . $sql_limit_offset;
    // --- DEBUGGING ---
    //error_log("SQL Query (final): " . $sql);
    //error_log("Parameters (final): " . var_export($params, true)); 
    // --- FIN DEBUGGING ---
    $stmt = $this->dbh->prepare($sql);
    $stmt->execute($params); 
    $this->p = $stmt->fetchAll(PDO::FETCH_ASSOC);
    return $this->p;
}
########################## FUNCION LISTAR COMBOS EN MODAL ################################

############################# FUNCION LISTAR COMBOS EN MODAL ################################
public function ListarCombosModal()
{
	$this->p = [];
	$sql = "SELECT 
	com.idcombo, com.codcombo, com.nomcombo, com.codfamilia, com.preciocompra, com.precioventa,
    com.existencia, com.stockminimo, com.stockmaximo, com.ivacombo, com.desccombo, com.codsucursal,
	fa.nomfamilia,
	s.codmoneda,
	tp.moneda, tp.siglas, tp.simbolo
	FROM combos com
    INNER JOIN sucursales s ON com.codsucursal = s.codsucursal
	LEFT JOIN tiposmoneda tp ON s.codmoneda = tp.codmoneda
    LEFT JOIN familias fa ON com.codfamilia = fa.codfamilia
    WHERE com.codsucursal = '".limpiar($_SESSION["codsucursal"])."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	return $this->p;
}
########################## FUNCION LISTAR COMBOS EN MODAL ################################

############################ FUNCION ID COMBOS #################################
public function CombosPorId()
{
    $this->p     = [];
    $codCombo    = isset($_GET["codcombo"]) ? limpiar(decrypt($_GET["codcombo"])) : '';
    $codSucursal = isset($_GET["codsucursal"]) ? limpiar(decrypt($_GET["codsucursal"])) : '';
    $sql = "SELECT
	    com.idcombo, com.codcombo, com.nomcombo, com.codfamilia, com.preciocompra, com.precioventa, 
	    com.existencia, com.stockminimo, com.stockmaximo, com.ivacombo, com.desccombo, com.codsucursal,
        fam.nomfamilia,
		suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
		suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
		tm.moneda, tm.siglas, tm.simbolo,
        tm2.moneda AS moneda2, tm2.siglas AS siglas2, tm2.simbolo AS simbolo2,
        valor_cambio.montocambio,
        ciud.ciudad, comun.comuna, 
		doc.documento, doc2.documento AS documento2,
		pag.detalles_productos, pag.stock_combo
    FROM 
        (combos com INNER JOIN sucursales suc ON com.codsucursal = suc.codsucursal)
    LEFT JOIN 
        familias fam ON com.codfamilia = fam.codfamilia
	LEFT JOIN 
	    documentos doc ON suc.documsucursal = doc.coddocumento
	LEFT JOIN 
	    documentos AS doc2 ON suc.documencargado = doc2.coddocumento
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
	LEFT JOIN 
        tiposmoneda tm2 ON suc.codmoneda2 = tm2.codmoneda
    LEFT JOIN
        ciudades ciud ON suc.id_ciudad = ciud.id_ciudad
    LEFT JOIN
        comunas comun ON suc.id_comuna = comun.id_comuna

    LEFT JOIN
        (SELECT
            cxp.codcombo,
            SUM(cxp.cantidad) AS articulos,
            GROUP_CONCAT(
                CONCAT_WS(
                    ' | ',
                    cxp.cantidad,
                    p.producto,
                    p.descripcion,
                    IFNULL(mar.nommarca, ''),
                    IFNULL(mode.nommodelo, ''),
                    IFNULL(pres.nompresentacion, ''),
                    IFNULL(col.nomcolor, '')
                )
                ORDER BY p.producto
                SEPARATOR '<br>'
            ) AS detalles_productos,
            MIN(FLOOR(p.existencia / cxp.cantidad)) AS stock_combo
        FROM
            combosxproductos cxp
        LEFT JOIN
            productos p ON cxp.idproducto = p.idproducto
        LEFT JOIN
            marcas mar ON p.codmarca = mar.codmarca
        LEFT JOIN
            modelos mode ON p.codmodelo = mode.codmodelo
        LEFT JOIN
            presentaciones pres ON p.codpresentacion = pres.codpresentacion
        LEFT JOIN
            colores col ON p.codcolor = col.codcolor
        WHERE cxp.codsucursal = :codSucursal1
        GROUP BY cxp.codcombo
        ) pag ON pag.codcombo = com.codcombo

    LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = suc.codmoneda2

    WHERE com.codcombo = :codCombo AND com.codsucursal = :codSucursal2 LIMIT 1";
    try {
        $stmt = $this->dbh->prepare($sql);
        // Asignamos los parámetros a los marcadores de posición con nombre
        $stmt->bindParam(':codCombo', $codCombo);
        $stmt->bindParam(':codSucursal1', $codSucursal);
        $stmt->bindParam(':codSucursal2', $codSucursal);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        if (!$row) {
            echo "<div class='alert alert-danger'>";
            echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
            echo "<center><span class='fa fa-info-circle'></span> COMBO NO ENCONTRADO.</center>";
            echo "</div>";
            exit();
        } else {
            $this->p[] = $row;
            return $this->p;
        }
    } catch (PDOException $e) {
        error_log("Error en CombosPorId: " . $e->getMessage());
        echo "<div class='alert alert-danger'>";
        echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
        echo "<center><span class='fa fa-exclamation-triangle'></span> OCURRIÓ UN ERROR AL CONSULTAR EL COMBO.</center>";
        echo "</div>";
        return [];
    }
}
############################ FUNCION ID COMBOS #################################

############################ FUNCION VER PRODUCTOS EN COMBOS ############################
public function VerDetallesProductos()
{
	$this->p     = [];
	$codCombo    = isset($_GET["codcombo"]) ? limpiar(decrypt($_GET["codcombo"])) : '';
    $codSucursal = isset($_GET["codsucursal"]) ? limpiar(decrypt($_GET["codsucursal"])) : '';
    $sql = "SELECT
        cxp.*,
        p.producto, p.opcionvendido, p.preciocompra, p.precioxpublico AS precioventa, p.existencia, p.descproducto, 
		p.codmarca, p.codmodelo, p.codpresentacion, p.codcolor,
        marc.nommarca, mode.nommodelo, pres.nompresentacion, col.nomcolor, orig.nomorigen
    FROM 
       combosxproductos cxp
	LEFT JOIN 
	   productos p ON cxp.idproducto = p.idproducto
	LEFT JOIN 
	    marcas marc ON p.codmarca = marc.codmarca 
	LEFT JOIN 
	    modelos mode ON p.codmodelo = mode.codmodelo
	LEFT JOIN 
	    presentaciones pres ON p.codpresentacion = pres.codpresentacion 
	LEFT JOIN 
	    colores col ON p.codcolor = col.codcolor 
	LEFT JOIN 
	    origenes orig ON p.codorigen=  orig.codorigen
	WHERE cxp.codcombo = ? AND cxp.codsucursal = ?";
	try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute([$codCombo,$codSucursal]);
        $this->p = $stmt->fetchAll(PDO::FETCH_ASSOC);
        return $this->p;
    } catch (PDOException $e) {
        // Manejo de errores: registra el error y devuelve un array vacío
        error_log("Error en VerDetallesProductos: " . $e->getMessage() . " SQL: " . $sql . " Params: " . json_encode([$codCombo,$codSucursal]));
        return [];
    }
}
############################ FUNCION VER PRODUCTOS EN COMBOS ############################

############################ FUNCION DETALLE COMBO #################################
public function DetallesComboPorId()
{
	$this->p = [];
	$sql = "SELECT
	combos.idcombo,
	combos.codcombo,
	combos.nomcombo,
	combos.codfamilia,
	combos.preciocompra,
	combos.precioventa,
	combos.existencia,
	combos.stockminimo,
	combos.stockmaximo,
	combos.ivacombo,
	combos.desccombo,
	combos.codsucursal,
 	familias.nomfamilia
	FROM combos LEFT JOIN familias ON combos.codfamilia = familias.codfamilia
    WHERE combos.idcombo = ? AND combos.codcombo = ? AND combos.codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(limpiar($_GET["d_id"]),limpiar($_GET["d_codigo"]),limpiar($_SESSION["codsucursal"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "";
	}
	else
	{
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		return $this->p;
	}
}
############################ FUNCION DETALLE COMBO #################################

############################ FUNCION DETALLE PRODUCTOS POR COMBO ############################
public function DetallesProductosxCombo()
{
	$this->p = [];
	$sql ="SELECT 
	combosxproductos.codcombo,
	combosxproductos.idproducto,  
	combosxproductos.codproducto, 
	combosxproductos.cantidad, 
	productos.producto,
	productos.opcionvendido, 
	productos.descproducto, 
	productos.codmarca,
	productos.codmodelo, 
	marcas.nommarca
	FROM combosxproductos 
	LEFT JOIN productos ON combosxproductos.idproducto = productos.idproducto
	LEFT JOIN marcas ON productos.codmarca = marcas.codmarca 
	WHERE combosxproductos.codcombo = ? 
	AND combosxproductos.codsucursal = ?
	GROUP BY combosxproductos.codproducto, combosxproductos.codsucursal";
    $stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(limpiar($_GET["d_codigo"]),limpiar($_SESSION["codsucursal"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
	echo "";		
	}
	else
	{
		while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
	}
}
############################ FUNCION DETALLE PRODUCTOS POR COMBO ############################

############################ FUNCION ACTUALIZAR COMBOS ############################
public function ActualizarCombos()
{
	$this->p = [];
	if(empty($_POST["codcombo"]) or empty($_POST["nomcombo"]) or empty($_POST["codfamilia"]) or empty($_POST["precioventa"]) or empty($_POST["existencia"]) or empty($_POST["ivacombo"]) or empty($_POST["codsucursal"]))
	{
	    echo "1";
		exit;
	}

	################## PROCESO DE REGISTRO DE PRODUCTOS A COMBOS ####################
	$this->dbh->beginTransaction();
	if (isset($_POST["codproducto"])) {
	    for($i=0;$i<count($_POST['codproducto']);$i++){  //recorro el array
		    if (!empty($_POST['codproducto'][$i])) {

		        if($_POST['cantidad'][$i] == "" || $_POST['cantidad'][$i] == 0 || $_POST['cantidad'][$i] == 0.00){

		            echo "2";
		            exit();
	            }
		    }
        }
	}
	$this->dbh->commit();
	################### PROCESO DE REGISTRO DE PRODUCTOS A COMBOS ##################

	$sql = "SELECT codcombo FROM combos WHERE idcombo != ? AND codcombo = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_POST["idcombo"]),decrypt($_POST["codcombo"]),decrypt($_POST["codsucursal"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		$sql = "UPDATE combos set"
		." nomcombo = ?, "
		." codfamilia = ?, "
		." preciocompra = ?, "
		." precioventa = ?, "
		." existencia = ?, "
		." stockminimo = ?, "
		." stockmaximo = ?, "
		." ivacombo = ?, "
		." desccombo = ? "
		." WHERE "
		." idcombo = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $nomcombo);
		$stmt->bindParam(2, $codfamilia);
		$stmt->bindParam(3, $preciocompra);
		$stmt->bindParam(4, $precioventa);
		$stmt->bindParam(5, $existencia);
		$stmt->bindParam(6, $stockminimo);
		$stmt->bindParam(7, $stockmaximo);
		$stmt->bindParam(8, $ivacombo);
		$stmt->bindParam(9, $desccombo);
		$stmt->bindParam(10, $idcombo);

		$nomcombo     = limpiar($_POST["nomcombo"]);
		$codfamilia   = limpiar(decrypt($_POST["codfamilia"]));
		$preciocompra = limpiar($_POST["preciocompra"]);
		$precioventa  = limpiar($_POST["precioventa"]);
		$existencia   = limpiar($_POST["existencia"]);
		$stockminimo  = limpiar($_POST["stockminimo"]);
		$stockmaximo  = limpiar($_POST["stockmaximo"]);
		$ivacombo     = limpiar($_POST["ivacombo"]);
		$desccombo    = limpiar($_POST["desccombo"]);
		$codcombo     = limpiar(decrypt($_POST["codcombo"]));
		$idcombo      = limpiar(decrypt($_POST["idcombo"]));
		$codsucursal  = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();

	############################## SUBIR FOTO DE COMBO ##############################
	$permitidos = array("image/jpg", "image/jpeg", "image/png");
	$limite_kb  = 8000000;//1MB

    //datos del arhivo  
    $nombre_archivo = limpiar(isset($_FILES['imagen']['name']) ? $_FILES['imagen']['name'] : "");
	$tipo_archivo   = limpiar(isset($_FILES['imagen']['type']) ? $_FILES['imagen']['type'] : "");
	$tamano_archivo = limpiar(isset($_FILES['imagen']['size']) ? $_FILES['imagen']['size'] : "");
	$file           = new SplFileInfo($nombre_archivo);
	$extension      = $file->getExtension();

    //compruebo si las características del archivo son las que deseo 
    if (!empty($_FILES["imagen"]) && in_array($_FILES['imagen']['type'], $permitidos)){
 
        if (move_uploaded_file($_FILES['imagen']['tmp_name'], "fotos/combos/".$nombre_archivo) && rename("fotos/combos/".$nombre_archivo,"fotos/combos/".$codsucursal."_".$codcombo.".".$extension))
	    { 
	    ## se puede dar un aviso
	    } 
	    ## se puede dar otro aviso 
	}
	############################## SUBIR FOTO DE COMBO ##############################

	################## PROCESO DE REGISTRO DE PRODUCTOS A COMBOS ####################
	$this->dbh->beginTransaction();
	if (isset($_POST["codproducto"])) {
	    for($i=0;$i<count($_POST['codproducto']);$i++){  //recorro el array
		    if (!empty($_POST['codproducto'][$i])) {

			   	$query = "UPDATE combosxproductos set"
			   	." cantidad = ? "
			   	." WHERE "
			   	." iddetallecombo = ?;
			   	";
			   	$stmt = $this->dbh->prepare($query);
			   	$stmt->bindParam(1, $cantidad);
			   	$stmt->bindParam(2, $iddetallecombo);
			   	//$stmt->bindParam(3, $idproducto);
			   	//$stmt->bindParam(4, $codproducto);
				//$stmt->bindParam(5, $codsucursal);

			   	$cantidad       = $_POST['opcionvendido'][$i] == "2" ? number_format($_POST['cantidad'][$i], 3, '.', '') : number_format($_POST['cantidad'][$i], 0, '.', '');
			   	$codcombo       = limpiar(decrypt($_POST["codcombo"]));
			   	$iddetallecombo = limpiar($_POST['iddetallecombo'][$i]);
			   	$idproducto     = limpiar($_POST['idproducto'][$i]);
			   	$codproducto    = limpiar($_POST['codproducto'][$i]);
			    $codsucursal    = limpiar(decrypt($_POST["codsucursal"]));
			   	$stmt->execute();
		    }
        }
	}
	$this->dbh->commit();
	################### PROCESO DE REGISTRO DE PRODUCTOS A COMBOS ##################
        
	echo "<span class='fa fa-check-square-o'></span> EL COMBO HA SIDO ACTUALIZADO EXITOSAMENTE";
	exit;

	} else {

		echo "3";
		exit;
	}
}
############################ FUNCION ACTUALIZAR COMBOS ############################

############################ FUNCION AGREGAR PRODUCTOS A COMBOS ############################
public function AgregarProductosxCombo()
{
   $this->p = [];
	if(empty($_POST["codcombo"]) or empty($_SESSION["CarritoProducto"]))
	{
		echo "1";
		exit;
	}

	############ VALIDO SI LA CANTIDAD ES MAYOR QUE LA EXISTENCIA #############
	$v = $_SESSION["CarritoProducto"];
	for($i=0;$i<count($v);$i++){

		$sql = "SELECT existencia
		FROM productos 
		WHERE codproducto = '".limpiar($v[$i]['txtCodigo'])."'
		AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		
		$cantproductobd = $row['existencia'];
		$cantidad       = $v[$i]['cantidad'];

        if($cantidad == "" || $cantidad == 0 || $cantidad == 0.00){

		    echo "2";
		    exit();
	    }
	    elseif ($cantidad > $cantproductobd) 
        { 
		    echo "2";
		    exit;
	    }
	}
	############ VALIDO SI LA CANTIDAD ES MAYOR QUE LA EXISTENCIA #############

	################## PROCESO DE REGISTRO DE PRODUCTOS A COMBOS ####################
	$this->dbh->beginTransaction();

	$detalle = $_SESSION["CarritoProducto"];
	for($i=0;$i<count($detalle);$i++){

		$sql = "SELECT 
		codcombo, 
		codproducto 
		FROM combosxproductos 
		WHERE codcombo = '".limpiar(decrypt($_POST['codcombo']))."' 
		AND codproducto = '".limpiar($detalle[$i]['txtCodigo'])."'
		AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute();
		$num = $stmt->rowCount();
		if($num == 0)
		{
			################### REGISTRO PRODUCTOS ###################
			$query = " INSERT INTO combosxproductos values (null, ?, ?, ?, ?, ?); ";
			$stmt = $this->dbh->prepare($query);
			$stmt->bindParam(1, $codcombo);
			$stmt->bindParam(2, $idproducto);
			$stmt->bindParam(3, $codproducto);
			$stmt->bindParam(4, $cantidad);
			$stmt->bindParam(5, $codsucursal);
			
			$codcombo    = limpiar(decrypt($_POST["codcombo"]));
			$idproducto  = limpiar($detalle[$i]['id']);
			$codproducto = limpiar($detalle[$i]['txtCodigo']);
			$cantidad    = $detalle[$i]['opcionvendido'] == "2" ? number_format($detalle[$i]['cantidad'], 3, '.', '') : number_format($detalle[$i]['cantidad'], 0, '.', '');
			$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
			$stmt->execute();
			################### REGISTRO PRODUCTOS ###################

		} else {

			$sql = "SELECT 
			cantidad
			FROM combosxproductos 
			WHERE codcombo = '".limpiar(decrypt($_POST["codcombo"]))."' 
			AND idproducto = '".limpiar($detalle[$i]['id'])."' 
			AND codproducto = '".limpiar($detalle[$i]['txtCodigo'])."'
			AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
			foreach ($this->dbh->query($sql) as $row)
			{
				$this->p[] = $row;
			}
			$cantidadbd = $row['cantidad'];

			################### ACTUALIZO PRODUCTOS ###################
			$query = "UPDATE combosxproductos set"
			." cantidad = ? "
			." WHERE "
			." codcombo = ? AND idproducto = ? AND codproducto = ? AND codsucursal = ?;
			";
			$stmt = $this->dbh->prepare($query);
			$stmt->bindParam(1, $cantidad);
			$stmt->bindParam(2, $codcombo);
			$stmt->bindParam(3, $idproducto);
			$stmt->bindParam(4, $codproducto);
			$stmt->bindParam(5, $codsucursal);

			$cantidad       = $detalle[$i]['opcionvendido'] == "2" ? number_format($cantidadbd+$detalle[$i]['cantidad'], 3, '.', '') : number_format($cantidadbd+$detalle[$i]['cantidad'], 0, '.', '');
			$codcombo    = limpiar(decrypt($_POST["codcombo"]));
			$idproducto  = limpiar($detalle[$i]['id']);
			$codproducto = limpiar($detalle[$i]['txtCodigo']);
			$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
			$stmt->execute();
			################### ACTUALIZO PRODUCTOS ###################
		}
	}
	unset($_SESSION["CarritoProducto"]);
    $this->dbh->commit();
	################### PROCESO DE REGISTRO DE PRODUCTOS A COMBOS ##################

	############## ACTUALIZAMOS LOS PRECIO DEL COMBO ###################
    /*$sql2 = " UPDATE combos set "
    ." preciocompra = ?, "
    ." precioventa = ? "
    ." WHERE "
    ." codcombo = ? AND codsucursal = ?;
    ";
    $stmt = $this->dbh->prepare($sql2);
    $stmt->bindParam(1, $preciocompra);
    $stmt->bindParam(2, $precioventa);
    $stmt->bindParam(3, $codcombo);
	$stmt->bindParam(4, $codsucursal);

    $preciocompra = number_format($_POST["preciocomprabd"]+$_POST["preciocompra"], 2, '.', '');
    $precioventa = number_format($_POST["precioventabd"]+$_POST["precioventa"], 2, '.', '');
	$codcombo = limpiar(decrypt($_POST["codcombo"]));
	$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
    $stmt->execute();*/
    ############## ACTUALIZAMOS LOS PRECIO DEL COMBO ###################
        
	echo "<span class='fa fa-check-square-o'></span> LOS PRODUCTOS FUERON AGREGADOS AL COMBO EXITOSAMENTE";
	exit;
}
############################ FUNCION AGREGAR PRODUCTOS A COMBOS ############################

########################## FUNCION ELIMINAR DETALLES COMBOS ###########################
public function EliminarDetalleCombo()
{
	$this->p = [];
	if ($_SESSION["acceso"]=="administradorS") {

	$sql = "SELECT 
	preciocompra,
	precioxpublico AS precioventa FROM productos 
	WHERE codproducto = '".limpiar(decrypt($_GET["codproducto"]))."'
	AND codsucursal = '".limpiar(decrypt($_GET["codsucursal"]))."'";
	foreach ($this->dbh->query($sql) as $row)
	{
	$this->p[] = $row;
	}
	$preciocomprabd = $row["preciocompra"];
	$precioventabd  = $row["precioventa"];

	$racionbd          = decrypt($_GET["cantidad"]);
	$totalracioncompra = number_format($racionbd * $preciocomprabd, 2, '.', '');
	$totalracionventa  = number_format($racionbd * $precioventabd, 2, '.', '');
    
    $sql = "DELETE FROM combosxproductos 
    WHERE codcombo = ? 
    AND idproducto = ? 
    AND codproducto = ?
    AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1,$codcombo);
	$stmt->bindParam(2,$idproducto);
	$stmt->bindParam(3,$codproducto);
	$stmt->bindParam(4,$codsucursal);

	$codcombo    = limpiar(decrypt($_GET["codcombo"]));
	$idproducto  = limpiar(decrypt($_GET["idproducto"]));
	$codproducto = limpiar(decrypt($_GET["codproducto"]));
	$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
	$stmt->execute();

	/*############ ACTUALIZAMOS PRECIO DEL COMBO ################
    /*$sql2 = " UPDATE combos set "
    ." preciocompra = ?, "
    ." precioventa = ? "
    ." WHERE"
    ." codcombo = ? AND codsucursal = ?;
    ";
    $stmt = $this->dbh->prepare($sql2);
    $stmt->bindParam(1, $preciocompra);
    $stmt->bindParam(2, $precioventa);
    $stmt->bindParam(3, $codcombo);
    $stmt->bindParam(4, $codsucursal);

    $preciocompra = number_format($preciocomprabd-$totalracioncompra, 2, '.', '');
    $precioventa = number_format($precioventabd-$totalracionventa, 2, '.', '');
	$codcombo = limpiar(decrypt($_GET["codcombo"]));
	$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
    $stmt->execute();*/
    ############ ACTUALIZAMOS PRECIO DEL COMBO ################

		echo "1";
		exit;

	} else {
		   
		echo "2";
		exit;
	} 
}
########################## FUNCION ELIMINAR DETALLES COMBOS #################################

########################## FUNCION ELIMINAR COMBOS ###########################
public function EliminarCombos()
{
	$this->p = [];
	if ($_SESSION["acceso"]=="administradorG" || $_SESSION["acceso"]=="administradorS") {

	$sql = "SELECT codproducto FROM detalleventas WHERE codproducto = ? AND codsucursal = ? AND tipodetalle = 2";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codcombo"]),decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		################### ELIMINO COMBO ###################
		$sql = "DELETE FROM combos WHERE codcombo = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codcombo);
		$stmt->bindParam(2,$codsucursal);

		$codcombo    = decrypt($_GET["codcombo"]);
		$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();
		################### ELIMINO COMBO ###################

		################### ELIMINO KARDEX ###################
		$sql = "DELETE FROM kardex WHERE codproducto = ? AND codsucursal = ? AND tipokardex = 2";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codcombo);
		$stmt->bindParam(2,$codsucursal);

		$codcombo    = decrypt($_GET["codcombo"]);
		$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();
		################### ELIMINO KARDEX ###################

		################### ELIMINO PRODUCTOS ###################
		$sql = "DELETE FROM combosxproductos WHERE codcombo = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codcombo);
		$stmt->bindParam(2,$codsucursal);

		$codcombo    = decrypt($_GET["codcombo"]);
		$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();
		################### ELIMINO PRODUCTOS ###################

		if (file_exists("fotos/combos/".$codsucursal."_".$codcombo.".jpg")){
	    //funcion para eliminar una carpeta con contenido
		$archivos = "fotos/combos/".$codsucursal."_".$codcombo.".jpg";		
		unlink($archivos);
	    } else if (file_exists("fotos/combos/".$codsucursal."_".$codcombo.".jpeg")){
	    //funcion para eliminar una carpeta con contenido
		$archivos = "fotos/combos/".$codsucursal."_".$codcombo.".jpeg";		
		unlink($archivos);
	    } else if (file_exists("fotos/combos/".$codsucursal."_".$codcombo.".png")){
	    //funcion para eliminar una carpeta con contenido
		$archivos = "fotos/combos/".$codsucursal."_".$codcombo.".png";		
		unlink($archivos);
		}

		echo "1";
		exit;

	} else {
		   
		echo "2";
		exit;
	} 
			
	} else {
		
		echo "3";
		exit;
	}	
}
########################## FUNCION ELIMINAR COMBOS #################################

######################## FUNCION BUSCA KARDEX COMBOS ##########################
public function BuscarKardexCombo() 
{
	$this->p = [];
	$sql ="SELECT
	kardex.*,
	usuarios.dni,
	usuarios.nombres,
	usuarios.nivel
	FROM kardex LEFT JOIN usuarios ON kardex.codigo = usuarios.codigo 
	WHERE kardex.codproducto = ? AND kardex.codsucursal = ? AND kardex.tipokardex = 2";
    $stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_GET["codcombo"],decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "<div class='alert alert-danger'>";
		echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
		echo "<center><span class='fa fa-info-circle'></span> NO EXISTEN MOVIMIENTOS EN KARDEX PARA EL COMBO INGRESADO</center>";
		echo "</div>";		
		exit;
	}
	else
	{
		while($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[]=$row;
		}
		return $this->p;
	}
}
######################## FUNCION BUSCA KARDEX COMBOS #########################

######################## FUNCION DETALLE KARDEX COMBO #########################
public function DetalleKardexCombo()
{
	$this->p = [];
	$codCombo    = isset($_GET["codcombo"]) ? limpiar($_GET["codcombo"]) : '';
    $codSucursal = isset($_GET["codsucursal"]) ? limpiar(decrypt($_GET["codsucursal"])) : '';
    $sql = "SELECT
	    com.idcombo, com.codcombo, com.nomcombo, com.codfamilia, com.preciocompra, com.precioventa,
        com.existencia, com.stockminimo, com.stockmaximo, com.ivacombo, com.desccombo, com.codsucursal,
        fam.nomfamilia,
		suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
		suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
		tm.moneda, tm.siglas, tm.simbolo,
        tm2.moneda AS moneda2, tm2.siglas AS siglas2, tm2.simbolo AS simbolo2,
        valor_cambio.montocambio,
        ciud.ciudad, comun.comuna, 
		doc.documento, doc2.documento AS documento2,
		pag.detalles_productos, pag.stock_combo
    FROM 
        (combos com INNER JOIN sucursales suc ON com.codsucursal = suc.codsucursal)
    LEFT JOIN 
        familias fam ON com.codfamilia = fam.codfamilia
	LEFT JOIN 
	    impuestos imp ON com.ivacombo = imp.codimpuesto
	LEFT JOIN 
	    documentos doc ON suc.documsucursal = doc.coddocumento
	LEFT JOIN 
	    documentos AS doc2 ON suc.documencargado = doc2.coddocumento
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
	LEFT JOIN 
        tiposmoneda tm2 ON suc.codmoneda2 = tm2.codmoneda
    LEFT JOIN 
        ciudades ciud ON suc.id_ciudad = ciud.id_ciudad 
    LEFT JOIN 
        comunas comun ON suc.id_comuna = comun.id_comuna

    LEFT JOIN
        (SELECT
            cxp.codcombo,
            SUM(cxp.cantidad) AS articulos,
            GROUP_CONCAT(
                CONCAT_WS(
                    ' | ',
                    cxp.cantidad,
                    p.producto,
                    p.descripcion,
                    IFNULL(mar.nommarca, ''),
                    IFNULL(mode.nommodelo, ''),
                    IFNULL(pres.nompresentacion, ''),
                    IFNULL(col.nomcolor, '')
                )
                ORDER BY p.producto
                SEPARATOR '<br>'
            ) AS detalles_productos,
            MIN(FLOOR(p.existencia / cxp.cantidad)) AS stock_combo
        FROM
            combosxproductos cxp
        LEFT JOIN
            productos p ON cxp.idproducto = p.idproducto
        LEFT JOIN
            marcas mar ON p.codmarca = mar.codmarca
        LEFT JOIN
            modelos mode ON p.codmodelo = mode.codmodelo
        LEFT JOIN
            presentaciones pres ON p.codpresentacion = pres.codpresentacion
        LEFT JOIN
            colores col ON p.codcolor = col.codcolor
        WHERE cxp.codsucursal = :codSucursal1
        GROUP BY cxp.codcombo
        ) pag ON pag.codcombo = com.codcombo

	LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda       
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = suc.codmoneda2 
	WHERE com.codcombo = :codCombo AND com.codsucursal = :codSucursal2";
	try {
        $stmt = $this->dbh->prepare($sql);
        // Asignamos los parámetros a los marcadores de posición con nombre
        $stmt->bindParam(':codCombo', $codCombo);
        $stmt->bindParam(':codSucursal1', $codSucursal);
        $stmt->bindParam(':codSucursal2', $codSucursal);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        if (!$row) {
            echo "<div class='alert alert-danger'>";
            echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
            echo "<center><span class='fa fa-info-circle'></span> COMBO NO ENCONTRADO.</center>";
            echo "</div>";
            exit();
        } else {
            $this->p[] = $row;
            return $this->p;
        }
    } catch (PDOException $e) {
        error_log("Error en DetalleKardexCombo: " . $e->getMessage());
        echo "<div class='alert alert-danger'>";
        echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
        echo "<center><span class='fa fa-exclamation-triangle'></span> OCURRIÓ UN ERROR AL CONSULTAR EL COMBO.</center>";
        echo "</div>";
        return [];
    }
}
######################## FUNCION DETALLE KARDEX COMBO #########################

########################### FUNCION LISTAR KARDEX COMBO VALORIZADO ################################
public function ListarKardexCombosValorizado()
{
    $this->p = [];
    $tipoAcceso      = isset($_SESSION["acceso"]) ? limpiar($_SESSION["acceso"]) : '';
    $codSucursal     = ($tipoAcceso === 'administradorG') ? limpiar(decrypt($_GET["codsucursal"])) : limpiar($_SESSION["codsucursal"]);
    $whereConditions = [];
    $params          = [];

    // Lógica de filtro basada en el tipo de acceso
    $whereConditions[] = "com.codsucursal = ?";
    $params[]          = $codSucursal;
    
    $whereClause = "";
    if (!empty($whereConditions)) {
        $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    
    $sqlBase = "SELECT
        com.idcombo, com.codcombo, com.nomcombo, com.codfamilia, com.preciocompra, com.precioventa,
        com.existencia, com.stockminimo, com.stockmaximo, com.ivacombo, com.desccombo, com.codsucursal,
        fam.nomfamilia,
        suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
        suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
        tm.moneda, tm.siglas, tm.simbolo,
        tm2.moneda AS moneda2, tm2.siglas AS siglas2, tm2.simbolo AS simbolo2,
        valor_cambio.montocambio,
        ciud.ciudad, comun.comuna,
        doc.documento, doc2.documento AS documento2,
        pag.detalles_productos, pag.stock_combo
    FROM
        (combos com INNER JOIN sucursales suc ON com.codsucursal = suc.codsucursal)
    LEFT JOIN
        familias fam ON com.codfamilia = fam.codfamilia
    LEFT JOIN
        documentos doc ON suc.documsucursal = doc.coddocumento
    LEFT JOIN
        documentos AS doc2 ON suc.documencargado = doc2.coddocumento
    LEFT JOIN
        tiposmoneda tm ON suc.codmoneda = tm.codmoneda
    LEFT JOIN
        tiposmoneda tm2 ON suc.codmoneda2 = tm2.codmoneda
    LEFT JOIN 
        ciudades ciud ON suc.id_ciudad = ciud.id_ciudad 
    LEFT JOIN 
        comunas comun ON suc.id_comuna = comun.id_comuna
    
    LEFT JOIN
        (SELECT
            cxp.codcombo,
            SUM(cxp.cantidad) AS articulos,
            GROUP_CONCAT(
                CONCAT_WS(
                    ' | ',
                    cxp.cantidad,
                    p.producto,
                    p.descripcion,
                    IFNULL(mar.nommarca, ''),
                    IFNULL(mode.nommodelo, ''),
                    IFNULL(pres.nompresentacion, ''),
                    IFNULL(col.nomcolor, '')
                )
                ORDER BY p.producto
                SEPARATOR '<br>'
            ) AS detalles_productos,
            MIN(FLOOR(p.existencia / cxp.cantidad)) AS stock_combo
        FROM
            combosxproductos cxp
        LEFT JOIN
            productos p ON cxp.idproducto = p.idproducto
        LEFT JOIN
            marcas mar ON p.codmarca = mar.codmarca
        LEFT JOIN
            modelos mode ON p.codmodelo = mode.codmodelo
        LEFT JOIN
            presentaciones pres ON p.codpresentacion = pres.codpresentacion
        LEFT JOIN
            colores col ON p.codcolor = col.codcolor
        WHERE cxp.codsucursal = ?
        GROUP BY cxp.codcombo
        ) pag ON pag.codcombo = com.codcombo
    
    LEFT JOIN
        (SELECT
        codcambio, descripcioncambio, montocambio, codmoneda
        FROM tiposcambio
        ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = suc.codmoneda2";
    // Aunque tienen el mismo valor, deben estar en el orden correcto para el execute().
    $params_combined = [$codSucursal, $codSucursal];
    // Ahora construyes la consulta final con el orden correcto.
    $groupByClause = " GROUP BY ";
    $groupByClause .= "com.idcombo, com.codcombo, com.nomcombo, com.codfamilia, com.preciocompra, com.precioventa,
        com.existencia, com.stockminimo, com.stockmaximo, com.ivacombo, com.desccombo, com.codsucursal,
        fam.nomfamilia,
        suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
        suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
        tm.moneda, tm.siglas, tm.simbolo,
        moneda2, siglas2, simbolo2,
        valor_cambio.montocambio,
        ciud.ciudad, comun.comuna,
        doc.documento, documento2,
        pag.detalles_productos, pag.stock_combo";
    $sql = $sqlBase . $whereClause . $groupByClause . " ORDER BY com.codcombo ASC";
    try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute($params_combined);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($results)) {
            return [];
        } else {
            return $results;
        }
    } catch (PDOException $e) {
        error_log("Error en ListarKardexCombosValorizado: " . $e->getMessage());
        return [];
    }
}
########################## FUNCION LISTAR KARDEX COMBO VALORIZADO ################################

###################### FUNCION COMBOS VALORIZADO POR FECHAS Y VENDEDOR #########################
public function BuscarCombosValorizadoxFechas() 
{
    $this->p = [];
	$codSucursal         = isset($_GET["codsucursal"]) ? limpiar(decrypt($_GET['codsucursal'])) : '';
	$fechaDesde          = isset($_GET['desde']) ? limpiar(date("Y-m-d", strtotime($_GET['desde']))) : '';
    $fechaHasta          = isset($_GET['hasta']) ? limpiar(date("Y-m-d", strtotime($_GET['hasta']))) : '';
	$whereConditions     = [];
    $params              = [];

    $sqlBase = "SELECT
        com.existencia,
        dv.idproducto, dv.codproducto, dv.producto, dv.preciocompra, dv.precioventa,
        dv.ivaproducto, dv.descproducto, dv.tipodetalle,
	    suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
		suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
		doc.documento, doc2.documento AS documento2, tm.moneda, tm.siglas, tm.simbolo,
		usu.dni, usu.nombres,
        SUM(dv.cantventa) AS cantidad
    FROM
        ventas v
    INNER JOIN
        detalleventas dv ON v.codventa = dv.codventa
    LEFT JOIN 
        combos com ON dv.idproducto = com.idcombo
    LEFT JOIN 
	    sucursales suc ON v.codsucursal = suc.codsucursal 
	LEFT JOIN 
	    documentos doc ON suc.documsucursal = doc.coddocumento
	LEFT JOIN 
	    documentos AS doc2 ON suc.documencargado = doc2.coddocumento
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
    LEFT JOIN 
        usuarios usu ON v.codigo = usu.codigo";
    //Condicion de Sucursal
    if (!empty($codSucursal)) {
        $whereConditions[] = "v.codsucursal = ?";
        $params[]          = $codSucursal;
    }
    //Condicion de Fechas
    if (!empty($fechaDesde) && !empty($fechaHasta)) {
        $whereConditions[] = "DATE_FORMAT(v.fechaventa,'%Y-%m-%d') BETWEEN ? AND ?";
        $params[] = $fechaDesde;
        $params[] = $fechaHasta;
    }
    $whereConditions[] = "dv.tipodetalle = 2";
    $whereClause = "";
    if (!empty($whereConditions)) {
        $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $groupByClause = " GROUP BY ";
    $groupByClause .= "com.existencia,dv.idproducto, dv.codproducto, dv.producto, dv.preciocompra, dv.precioventa,
        dv.ivaproducto, dv.descproducto, dv.tipodetalle,
	    suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
		suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
		doc.documento, documento2, tm.moneda, tm.siglas, tm.simbolo,
		usu.dni, usu.nombres";
    $sql = $sqlBase . $whereClause . $groupByClause . " ORDER BY dv.codproducto ASC";
    try {
        $stmt = $this->dbh->prepare($sql);// Preparar y ejecutar la consulta
        $stmt->execute($params); // Pasamos todos los parámetros juntos
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($results)) {
            echo "<div class='alert alert-danger'>";
            echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
            echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS PARA TU BÚSQUEDA REALIZADA</center>";
            echo "</div>";
            exit();
        } else {
            return $results;
        }
    } catch (PDOException $e) {
        error_log("Error en BuscarCombosValorizadoxFechas: " . $e->getMessage());
        echo "<div class='alert alert-danger'>";
        echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
        echo "<center><span class='fa fa-exclamation-triangle'></span> OCURRIÓ UN ERROR AL CONSULTAR LOS DETALLES DE COMBOS POR FECHAS.</center>";
        echo "</div>";
        exit();
    }
}
########################### FUNCION COMBOS VALORIZADO POR FECHAS Y VENDEDOR ###############################

###################### FUNCION BUSCAR COMBOS VENDIDOS POR FECHAS #########################
public function BuscarCombosVendidosxFechas() 
{
    $this->p = [];
	$codSucursal         = isset($_GET["codsucursal"]) ? limpiar(decrypt($_GET['codsucursal'])) : '';
	$fechaDesde          = isset($_GET['desde']) ? limpiar(date("Y-m-d", strtotime($_GET['desde']))) : '';
    $fechaHasta          = isset($_GET['hasta']) ? limpiar(date("Y-m-d", strtotime($_GET['hasta']))) : '';
	$whereConditions     = [];
    $params              = [];

    $sqlBase = "SELECT
        com.existencia,
        dv.idproducto, dv.codproducto, dv.producto, dv.preciocompra, dv.precioventa,
        dv.ivaproducto, dv.descproducto, dv.tipodetalle,
	    suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
		suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
		doc.documento, doc2.documento AS documento2, tm.moneda, tm.siglas, tm.simbolo,
	    usu.dni, usu.nombres,
        SUM(dv.cantventa) AS cantidad,
	    SUM(dv.totaldescuentov) as totaldescuentov,
	    SUM(dv.subtotalimpuestos) as subtotalimpuestos,
	    pag.detalles_productos, pag.stock_combo
    FROM
        ventas v
    INNER JOIN
        detalleventas dv ON v.codventa = dv.codventa
    LEFT JOIN 
        combos com ON dv.idproducto = com.idcombo
    LEFT JOIN 
	    sucursales suc ON v.codsucursal = suc.codsucursal 
	LEFT JOIN 
	    documentos doc ON suc.documsucursal = doc.coddocumento
	LEFT JOIN 
	    documentos AS doc2 ON suc.documencargado = doc2.coddocumento
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
    LEFT JOIN 
        usuarios usu ON v.codigo = usu.codigo

    LEFT JOIN
        (SELECT
            cxp.codcombo,
            SUM(cxp.cantidad) AS articulos,
            GROUP_CONCAT(
                CONCAT_WS(
                    ' | ',
                    cxp.cantidad,
                    p.producto,
                    p.descripcion,
                    IFNULL(mar.nommarca, ''),
                    IFNULL(mode.nommodelo, ''),
                    IFNULL(pres.nompresentacion, ''),
                    IFNULL(col.nomcolor, '')
                )
                ORDER BY p.producto
                SEPARATOR '<br>'
            ) AS detalles_productos,
            MIN(FLOOR(p.existencia / cxp.cantidad)) AS stock_combo
        FROM
            combosxproductos cxp
        LEFT JOIN
            productos p ON cxp.idproducto = p.idproducto
        LEFT JOIN
            marcas mar ON p.codmarca = mar.codmarca
        LEFT JOIN
            modelos mode ON p.codmodelo = mode.codmodelo
        LEFT JOIN
            presentaciones pres ON p.codpresentacion = pres.codpresentacion
        LEFT JOIN
            colores col ON p.codcolor = col.codcolor
        WHERE cxp.codsucursal = $codSucursal
        GROUP BY cxp.codcombo
        ) pag ON pag.codcombo = com.codcombo
    ";
    //Condicion de Sucursal
    if (!empty($codSucursal)) {
        $whereConditions[] = "v.codsucursal = ?";
        $params[]          = $codSucursal;
    }
    //Condicion de Fechas
    if (!empty($fechaDesde) && !empty($fechaHasta)) {
        $whereConditions[] = "DATE_FORMAT(v.fechaventa,'%Y-%m-%d') BETWEEN ? AND ?";
        $params[] = $fechaDesde;
        $params[] = $fechaHasta;
    }
    $whereConditions[] = "dv.tipodetalle = 2";
    $whereClause = "";
    if (!empty($whereConditions)) {
        $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $groupByClause = " GROUP BY ";
    $groupByClause .= "com.existencia,dv.idproducto, dv.codproducto, dv.producto, dv.preciocompra, dv.precioventa,
        dv.ivaproducto, dv.descproducto, dv.tipodetalle,
	    suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
		suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
		doc.documento, documento2, tm.moneda, tm.siglas, tm.simbolo,
		usu.dni, usu.nombres,
		pag.detalles_productos, pag.stock_combo";
    $sql = $sqlBase . $whereClause . $groupByClause . " ORDER BY dv.codproducto ASC";
    try {
        $stmt = $this->dbh->prepare($sql);// Preparar y ejecutar la consulta
        $stmt->execute($params); // Pasamos todos los parámetros juntos
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($results)) {
            echo "<div class='alert alert-danger'>";
            echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
            echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS PARA TU BÚSQUEDA REALIZADA</center>";
            echo "</div>";
            exit();
        } else {
            return $results;
        }
    } catch (PDOException $e) {
        error_log("Error en BuscarCombosVendidosxFechas: " . $e->getMessage());
        echo "<div class='alert alert-danger'>";
        echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
        echo "<center><span class='fa fa-exclamation-triangle'></span> OCURRIÓ UN ERROR AL CONSULTAR LOS DETALLES DE COMBOS POR FECHAS.</center>";
        echo "</div>";
        exit();
    }
}
########################### FUNCION COMBOS VENDIDOS POR FECHAS ###############################

############################### FIN DE CLASE COMBOS ###############################



























################################## CLASE TRASPASOS ###################################

############################## FUNCION REGISTRAR TRASPASOS ############################
public function RegistrarTraspasos()
{
	$this->p = [];
	if(empty($_POST["sucursal_envia"]) or empty($_POST["sucursal_recibe"]) or empty($_POST["fechatraspaso"]))
	{
		echo "1";
		exit;
	}
	else if(empty($_SESSION["CarritoTraspaso"]) || $_POST["txtTotal"]=="0.00")
	{
		echo "2";
		exit;
	}
	############ VALIDO SI LA CANTIDAD ES MAYOR QUE LA EXISTENCIA #############
	$v = $_SESSION["CarritoTraspaso"];
	for($i=0;$i<count($v);$i++){

	    $sql = "SELECT existencia FROM productos 
	    WHERE codproducto = '".$v[$i]['txtCodigo']."' 
	    AND codsucursal = '".limpiar(decrypt($_POST["sucursal_envia"]))."'";
	    foreach ($this->dbh->query($sql) as $row)
	    {
		   $this->p[] = $row;
	    }
	
	    $existenciabd = $row['existencia'];
	    $cantidad = $v[$i]['cantidad'];

        if ($cantidad > $existenciabd) 
        { 
	        echo "3";
	        exit;
        }
	}
	############ VALIDO SI LA CANTIDAD ES MAYOR QUE LA EXISTENCIA #############

	################# OBTENGO DATOS DE SUCURSAL #################
	$sql = " SELECT 
	cuitsucursal, 
	nroactividadsucursal 
	FROM sucursales WHERE codsucursal = '".limpiar(decrypt($_POST["sucursal_envia"]))."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$cuitsucursal = $row['cuitsucursal'];
	$nroactividad = $row['nroactividadsucursal'];
	################# OBTENGO DATOS DE SUCURSAL #################

	################ CREO CODIGO DE TRASPASO ####################
	$sql = "SELECT codtraspaso FROM traspasos 
	ORDER BY idtraspaso DESC LIMIT 1";
	foreach ($this->dbh->query($sql) as $row){

		$traspaso = $row["codtraspaso"];
	}
	if(empty($traspaso))
	{
		$codtraspaso = "01";

	} else {

		$num         = substr($traspaso, 0);
        $dig         = $num + 1;
        $codigofinal = str_pad($dig, 2, "0", STR_PAD_LEFT);
        $codtraspaso = $codigofinal;
	}
    ################ CREO CODIGO DE TRASPASO ###############

	################### CREO CODIGO DE FACTURA ####################
	$sql4 = "SELECT codfactura FROM traspasos 
	WHERE sucursal_envia = '".limpiar(decrypt($_POST["sucursal_envia"]))."' 
	ORDER BY idtraspaso DESC LIMIT 1";
	foreach ($this->dbh->query($sql4) as $row4){

		$factura = $row4["codfactura"];
	}
	if(empty($factura))
	{
		$codfactura      = "0000001";
		$numero_tracking = date("Ymd")."-".$codfactura;

	} else {

		$var             = strlen("");
        $var1            = substr($factura , $var);
        $var2            = strlen($var1);
        $var3            = $var1 + 1;
        $var4            = str_pad($var3, $var2, "0", STR_PAD_LEFT);
        $codfactura      = $var4;
        $numero_tracking = date("Ymd")."-".$codfactura;
	}
    ################### CREO CODIGO DE FACTURA ####################

    ################### REGISTRO EL TRASPASO ####################
    $query = "INSERT INTO traspasos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $codtraspaso);
	$stmt->bindParam(2, $codfactura);
	$stmt->bindParam(3, $numero_tracking);
	$stmt->bindParam(4, $nombres_responsable);
	$stmt->bindParam(5, $sucursal_envia);
	$stmt->bindParam(6, $sucursal_recibe);
	$stmt->bindParam(7, $subtotalivasi);
	$stmt->bindParam(8, $subtotalivano);
	$stmt->bindParam(9, $iva);
	$stmt->bindParam(10, $totaliva);
	$stmt->bindParam(11, $descontado);
	$stmt->bindParam(12, $descuento);
	$stmt->bindParam(13, $totaldescuento);
	$stmt->bindParam(14, $totalpago);
	$stmt->bindParam(15, $totalpago2);
	$stmt->bindParam(16, $fechatraspaso);
	$stmt->bindParam(17, $observaciones);
	$stmt->bindParam(18, $codigo);
	$stmt->bindParam(19, $estado_traspaso);
	$stmt->bindParam(20, $fecha_enviado);
	$stmt->bindParam(21, $persona_recibe);
	$stmt->bindParam(22, $fecha_recibe);
	$stmt->bindParam(23, $observaciones_recibido);
	$stmt->bindParam(24, $agregar_stock);
    
	$nombres_responsable = limpiar($_POST["nombres_responsable"]);
	$sucursal_envia      = limpiar(decrypt($_POST["sucursal_envia"]));
	$sucursal_recibe     = limpiar(decrypt($_POST["sucursal_recibe"]));
	$subtotalivasi       = limpiar($_POST["txtsubtotal"]);
	$subtotalivano       = limpiar($_POST["txtsubtotal2"]);
	$iva                 = limpiar($_POST["iva"]);
	$totaliva            = limpiar($_POST["txtIva"]);
	$descontado          = limpiar($_POST["txtdescontado"]);
	$descuento           = limpiar($_POST["descuento"]);
	$totaldescuento      = limpiar($_POST["txtDescuento"]);
	$totalpago           = limpiar($_POST["txtTotal"]);
	$totalpago2          = limpiar($_POST["txtTotalCompra"]);
	$fechatraspaso       = limpiar(date("Y-m-d",strtotime($_POST['fechatraspaso']))." ".date("H:i:s"));
	$observaciones       = limpiar($_POST["observaciones"]);
	$codigo              = limpiar($_SESSION["codigo"]);
	$estado_traspaso     = limpiar($_POST["estado_traspaso"]);
	$fecha_enviado       = limpiar($_POST["estado_traspaso"] == 2 ? date("Y-m-d H:i:s") : "");
	$persona_recibe      = limpiar("0");
	$fecha_recibe        = limpiar("");
	$observaciones_recibido = limpiar("");
	$agregar_stock       = limpiar("0");
	$stmt->execute();
	################### REGISTRO EL TRASPASO ####################
	
	$this->dbh->beginTransaction();
	$detalle = $_SESSION["CarritoTraspaso"];
	for($i=0;$i<count($detalle);$i++){

	################ VERIFICO LA EXISTENCIA DEL PRODUCTO EN ALMACEN ################
	$sql = "SELECT * FROM productos 
	WHERE codproducto = '".limpiar($detalle[$i]['txtCodigo'])."' 
	AND codsucursal = '".limpiar(decrypt($_POST["sucursal_envia"]))."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$existenciabd = $row['existencia'];
	################ VERIFICO LA EXISTENCIA DEL PRODUCTO EN ALMACEN ################

	################### REGISTRO DETALLES DE TRASPASO ####################
	$query = "INSERT INTO detalletraspasos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $codtraspaso);
    $stmt->bindParam(2, $idproducto);
    $stmt->bindParam(3, $codproducto);
    $stmt->bindParam(4, $producto);
	$stmt->bindParam(5, $descripcion);
    $stmt->bindParam(6, $opcionvendido);
	$stmt->bindParam(7, $imei);
	$stmt->bindParam(8, $condicion);
	$stmt->bindParam(9, $codmarca);
	$stmt->bindParam(10, $codmodelo);
	$stmt->bindParam(11, $codpresentacion);
	$stmt->bindParam(12, $codcolor);
	$stmt->bindParam(13, $cantidad);
	$stmt->bindParam(14, $preciocompra);
	$stmt->bindParam(15, $precioventa);
	$stmt->bindParam(16, $ivaproducto);
	$stmt->bindParam(17, $descproducto);
	$stmt->bindParam(18, $valortotal);
	$stmt->bindParam(19, $totaldescuentov);
	$stmt->bindParam(20, $subtotalimpuestos);
	$stmt->bindParam(21, $valorneto);
	$stmt->bindParam(22, $valorneto2);
    $stmt->bindParam(23, $tipodetalle);
	$stmt->bindParam(24, $codsucursal);
		
	$idproducto      = limpiar($detalle[$i]['id']);
	$codproducto     = limpiar($detalle[$i]['txtCodigo']);
	$producto        = limpiar($detalle[$i]['producto']);
    $descripcion     = limpiar($detalle[$i]['descripcion'] == "0" ? "" : $detalle[$i]['descripcion']);
    $opcionvendido   = limpiar($detalle[$i]['opcionvendido']);
	$imei            = limpiar($detalle[$i]['imei'] == "0" ? "" : $detalle[$i]['imei']);
	$condicion       = limpiar($detalle[$i]['condicion'] == "0" ? "" : $detalle[$i]['condicion']);
	$codmarca        = limpiar($detalle[$i]['codmarca']);
	$codmodelo       = limpiar($detalle[$i]['codmodelo']);
	$codpresentacion = limpiar($detalle[$i]['codpresentacion']);
	$codcolor        = limpiar($detalle[$i]['codcolor']);
	$cantidad        = $detalle[$i]['opcionvendido'] == "2" ? number_format($detalle[$i]['cantidad'], 3, '.', '') : number_format($detalle[$i]['cantidad'], 0, '.', '');
	$preciocompra    = limpiar($detalle[$i]['precio']);
	$precioventa     = limpiar($detalle[$i]['precio2']);
	$precioconiva    = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['precio2']);
	$ivaproducto     = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
	$descproducto    = limpiar($detalle[$i]['descproducto']);
	$descuento       = $detalle[$i]['descproducto']/100;
	$valortotal      = number_format($detalle[$i]['precio2']*$detalle[$i]['cantidad'], 2, '.', '');
	$totaldescuentov = number_format($valortotal*$descuento, 2, '.', '');
    $valorneto       = number_format($valortotal-$totaldescuentov, 2, '.', '');

	//CALCULO SUBTOTAL IMPUESTOS
	$ValorImpuesto        = 1 + ($_POST["iva"]/100);
	$RestoDescuento       = $precioconiva * $detalle[$i]['descproducto'] / 100;
	$PrecioIvaDescuento   = $precioconiva - $RestoDescuento;
	$Discriminado         = $PrecioIvaDescuento/$ValorImpuesto;
	$SubtotalDiscriminado = $PrecioIvaDescuento - $Discriminado;
    $BaseDiscriminado     = $SubtotalDiscriminado * $detalle[$i]['cantidad'];
    $subtotalimpuestos    = number_format($BaseDiscriminado, 2, '.', '');

	$valorneto2  = number_format($detalle[$i]['precio']*$detalle[$i]['cantidad'], 2, '.', '');
    $tipodetalle = limpiar($detalle[$i]['tipodetalle']);
	$codsucursal = limpiar(decrypt($_POST["sucursal_envia"]));
	$stmt->execute();
	################### REGISTRO DETALLES DE TRASPASO ####################

	##########################################################################################################
	#                                                                                                        #
	#                                   PROCESO DE PRODUCTOS SALIENTES                                       #
	#                                                                                                        #
	##########################################################################################################

    ##################### ACTUALIZO LA EXISTENCIA DEL ALMACEN ####################
	$sql = " UPDATE productos set "
		." existencia = ? "
		." WHERE "
		." codproducto = '".limpiar($detalle[$i]['txtCodigo'])."' 
		AND codsucursal = '".limpiar(decrypt($_POST["sucursal_envia"]))."';
		";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $existencia);
	$cantraspaso = $detalle[$i]['opcionvendido'] == "2" ? number_format($detalle[$i]['cantidad'], 3, '.', '') : number_format($detalle[$i]['cantidad'], 0, '.', '');
	$existencia  = $detalle[$i]['opcionvendido'] == "2" ? number_format($existenciabd-$detalle[$i]['cantidad'], 3, '.', '') : number_format($existenciabd-$detalle[$i]['cantidad'], 0, '.', '');
	$stmt->execute();
	##################### ACTUALIZO LA EXISTENCIA DEL ALMACEN ####################

	################ REGISTRAMOS LOS PRODUCTOS SALIENTES EN KARDEX #################
    $query = "INSERT INTO kardex values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $codtraspaso);
	$stmt->bindParam(2, $codresponsable);
	$stmt->bindParam(3, $codproducto);
	$stmt->bindParam(4, $movimiento);
	$stmt->bindParam(5, $entradas);
	$stmt->bindParam(6, $salidas);
	$stmt->bindParam(7, $devolucion);
	$stmt->bindParam(8, $stockactual);
	$stmt->bindParam(9, $ivaproducto);
	$stmt->bindParam(10, $descproducto);
	$stmt->bindParam(11, $precio);
	$stmt->bindParam(12, $documento);
	$stmt->bindParam(13, $fechakardex);	
	$stmt->bindParam(14, $tipokardex);	
	$stmt->bindParam(15, $procedimiento);	
	$stmt->bindParam(16, $codsucursal);
	$stmt->bindParam(17, $codigo);

	$codresponsable = limpiar(decrypt($_POST["sucursal_recibe"]));
	$codproducto    = limpiar($detalle[$i]['txtCodigo']);
	$movimiento     = limpiar("SALIDAS");
	$entradas       = $detalle[$i]['opcionvendido'] == "2" ? "0.000" : "0";
	$salidas        = $detalle[$i]['opcionvendido'] == "2" ? number_format($detalle[$i]['cantidad'], 3, '.', '') : number_format($detalle[$i]['cantidad'], 0, '.', '');
	$devolucion     = $detalle[$i]['opcionvendido'] == "2" ? "0.000" : "0";
	$stockactual    = $detalle[$i]['opcionvendido'] == "2" ? number_format($existenciabd-$detalle[$i]['cantidad'], 3, '.', '') : number_format($existenciabd-$detalle[$i]['cantidad'], 0, '.', '');
	$precio         = limpiar($detalle[$i]["precio2"]);
	$ivaproducto    = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
	$descproducto   = limpiar($detalle[$i]['descproducto']);
	$documento      = limpiar("TRASPASO: ".$codfactura);
	$fechakardex    = limpiar(date("Y-m-d"));
	$tipokardex     = limpiar($detalle[$i]['tipodetalle']);
	$procedimiento  = limpiar("1");
	$codsucursal    = limpiar(decrypt($_POST["sucursal_envia"]));
    $codigo         = limpiar($_SESSION["codigo"]);
	$stmt->execute();
	################ REGISTRAMOS LOS PRODUCTOS SALIENTES EN KARDEX #################

	##########################################################################################################
	#                                                                                                        #
	#                                   PROCESO DE PRODUCTOS SALIENTES                                       #
	#                                                                                                        #
	##########################################################################################################

    }//FIN SESSION DETALLES
        
    ####################### DESTRUYO LA VARIABLE DE SESSION #####################
	unset($_SESSION["CarritoTraspaso"]);
    $this->dbh->commit();
    ################################### REGISTRO DETALLES DE FACTURA ###################################
		
    echo "<span class='fa fa-check-square-o'></span> EL TRASPASO DE PRODUCTOS HA SIDO REALIZADO EXITOSAMENTE <a href='reportepdf?codtraspaso=".encrypt($codtraspaso)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt("FACTURATRASPASO")."' class='on-default' data-placement='left' data-toggle='tooltip' data-original-title='Imprimir Documento' target='_black' rel='noopener noreferrer'><font color='black'><strong>IMPRIMIR REPORTE</strong></font color></a></div>";

	echo "<script>VentanaCentrada('reportepdf?codtraspaso=".encrypt($codtraspaso)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt("FACTURATRASPASO")."', '', '', '1024', '568', 'true');</script>";
	exit;
}
############################## FUNCION REGISTRAR TRASPASOS #############################

############################## FUNCION LISTAR TRASPASOS ################################
public function ListarTraspasos()
{
    $this->p = [];
    $tipoAcceso      = isset($_SESSION["acceso"]) ? limpiar($_SESSION["acceso"]) : '';
    $codSucursal     = ($tipoAcceso === 'administradorG') ? limpiar(decrypt($_GET["codsucursal"])) : limpiar($_SESSION["codsucursal"]);
    $whereConditions = [];
    $params          = [];
    // Lógica de filtro basada en el tipo de acceso y usando parámetros con nombre para mayor claridad
    if ($tipoAcceso === 'administradorG') {
	    $whereConditions[] = "tras.sucursal_envia = :codSucursal_envia";
	    $params[':codSucursal_envia'] = $codSucursal;
	} else {
	    // CORRECCIÓN: Para que la consulta funcione, necesitas pasar el parámetro dos veces
	    // o usar un alias diferente para cada marcador de posición, incluso si el valor es el mismo.
	    $whereConditions[] = "(tras.sucursal_envia = :codSucursal_envia OR tras.sucursal_recibe = :codSucursal_recibe)";
	    $params[':codSucursal_envia'] = $codSucursal;
	    $params[':codSucursal_recibe'] = $codSucursal;
	}
    $whereClause = "";
    if (!empty($whereConditions)) {
        $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    // Consulta SQL optimizada y corregida
    $sqlBase = "SELECT
        tras.idtraspaso, tras.codtraspaso, tras.codfactura, tras.numero_tracking, tras.sucursal_envia, 
        tras.sucursal_recibe, tras.nombres_responsable, tras.subtotalivasi, tras.subtotalivano, tras.iva, 
        tras.totaliva, tras.descontado, tras.descuento, tras.totaldescuento, tras.totalpago, tras.totalpago2, 
        tras.fechatraspaso, tras.observaciones, tras.codigo, tras.estado_traspaso, tras.fecha_enviado, 
        tras.persona_recibe, tras.fecha_recibe, tras.observaciones_recibido, tras.agregar_stock,
		suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
		suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
		doc.documento, doc2.documento AS documento2, 
		tm.moneda, tm.siglas, tm.simbolo,
		tm2.moneda AS moneda2, tm2.siglas AS siglas2, tm2.simbolo AS simbolo2,
		usu.dni, usu.nombres,
		usu2.dni AS dni2, usu2.nombres AS nombres2,
		suc2.documsucursal AS documsucursal2, suc2.cuitsucursal AS cuitsucursal2, suc2.nomsucursal AS nomsucursal2,
		suc2.documencargado AS documencargado2, suc2.dniencargado AS dniencargado2, suc2.nomencargado AS nomencargado2,
		doc3.documento AS documento3, doc4.documento AS documento4,
		pag.articulos, pag.detalles_productos
    FROM 
        traspasos tras LEFT JOIN sucursales suc ON tras.sucursal_envia = suc.codsucursal
	LEFT JOIN 
	    documentos doc ON suc.documsucursal = doc.coddocumento
	LEFT JOIN 
	    documentos AS doc2 ON suc.documencargado = doc2.coddocumento
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
	LEFT JOIN 
	    tiposmoneda AS tm2 ON suc.codmoneda2 = tm2.codmoneda
	LEFT JOIN 
	    usuarios usu ON tras.codigo = usu.codigo 
	LEFT JOIN 
	    usuarios AS usu2 ON tras.persona_recibe = usu2.codigo
	LEFT JOIN 
	    sucursales AS suc2 ON tras.sucursal_recibe = suc2.codsucursal
	LEFT JOIN 
	    documentos AS doc3 ON suc2.documsucursal = doc3.coddocumento
	LEFT JOIN 
	    documentos AS doc4 ON suc2.documencargado = doc4.coddocumento
    LEFT JOIN (
        SELECT
            dtra.codtraspaso,
            SUM(dtra.cantidad) AS articulos,
            GROUP_CONCAT(
                CONCAT_WS(
                    ' | ',
                    dtra.cantidad,
                    dtra.producto,
                    dtra.descripcion,
                    IFNULL(mar.nommarca, ''),
                    IFNULL(mode.nommodelo, ''),
                    IFNULL(pres.nompresentacion, ''),
                    IFNULL(col.nomcolor, '')
                )
                ORDER BY dtra.producto
                SEPARATOR '<br>'
            ) AS detalles_productos
        FROM 
            detalletraspasos dtra
        LEFT JOIN 
            marcas mar ON dtra.codmarca = mar.codmarca
        LEFT JOIN 
            modelos mode ON dtra.codmodelo = mode.codmodelo
        LEFT JOIN 
            presentaciones pres ON dtra.codpresentacion = pres.codpresentacion
        LEFT JOIN 
            colores col ON dtra.codcolor = col.codcolor
        GROUP BY dtra.codtraspaso
    ) pag ON pag.codtraspaso = tras.codtraspaso";
    
    $sql = $sqlBase . $whereClause . " ORDER BY tras.fechatraspaso DESC";
    try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if (empty($results)) {
            return [];
        } else {
            return $results;
        }
    } catch (PDOException $e) {
        error_log("Error en ListarTraspasos: " . $e->getMessage());
        return [];
    }
}
############################ FUNCION LISTAR TRASPASOS ############################

############################ FUNCION ID TRASPASOS #################################
public function TraspasosPorId()
{
    $this->p     = [];
    $codTraspaso = isset($_GET["codtraspaso"]) ? limpiar(decrypt($_GET["codtraspaso"])) : '';
    $codSucursal = isset($_GET["codsucursal"]) ? limpiar(decrypt($_GET["codsucursal"])) : '';
    $sql = "SELECT
        tras.idtraspaso, tras.codtraspaso, tras.codfactura, tras.numero_tracking, tras.sucursal_envia, 
        tras.sucursal_recibe, tras.nombres_responsable, tras.subtotalivasi, tras.subtotalivano, tras.iva, 
        tras.totaliva, tras.descontado, tras.descuento, tras.totaldescuento, tras.totalpago, tras.totalpago2, 
        tras.fechatraspaso, tras.observaciones, tras.codigo, tras.estado_traspaso, tras.fecha_enviado, 
        tras.persona_recibe, tras.fecha_recibe, tras.observaciones_recibido, tras.agregar_stock,
        suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.tlfsucursal, suc.correosucursal, suc.id_ciudad, 
        suc.id_comuna, suc.direcsucursal, suc.nroactividadsucursal, suc.fechaautorsucursal, suc.llevacontabilidad, 
        suc.documencargado, suc.dniencargado, suc.nomencargado, suc.tlfencargado,suc.fechaautorsucursal, 
        suc.llevacontabilidad, suc.codmoneda,suc.codmoneda2, suc.membrete,
        doc.documento, doc2.documento AS documento2,
        ciud.ciudad, com.comuna,
        tm.moneda, tm.siglas, tm.simbolo,
        tm2.moneda AS moneda2, tm2.siglas AS siglas2, tm2.simbolo AS simbolo2,
        valor_cambio.montocambio,
        usu.dni, usu.nombres,
        usu2.dni AS dni2, usu2.nombres AS nombres2,
        suc2.documsucursal AS documsucursal2, suc2.cuitsucursal AS cuitsucursal2, suc2.nomsucursal AS nomsucursal2,
		suc2.id_ciudad AS id_ciudad2, suc2.id_comuna AS id_comuna2, suc2.direcsucursal AS direcsucursal2,
		suc2.correosucursal AS correosucursal2, suc2.tlfsucursal AS tlfsucursal2, suc2.documencargado AS documencargado2,
		suc2.dniencargado AS dniencargado2, suc2.nomencargado AS nomencargado2, suc2.tlfencargado AS tlfencargado2,
		doc3.documento AS documento3, doc4.documento AS documento4,
        ciud2.ciudad AS ciudad2, com2.comuna AS comuna2,
        pag.articulos
    FROM 
        traspasos tras LEFT JOIN sucursales suc ON tras.sucursal_envia = suc.codsucursal
	LEFT JOIN 
	    documentos doc ON suc.documsucursal = doc.coddocumento
	LEFT JOIN 
	    documentos AS doc2 ON suc.documencargado = doc2.coddocumento
    LEFT JOIN 
        ciudades ciud ON suc.id_ciudad = ciud.id_ciudad 
    LEFT JOIN 
        comunas com ON suc.id_comuna = com.id_comuna 
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
	LEFT JOIN 
	    tiposmoneda AS tm2 ON suc.codmoneda2 = tm2.codmoneda
	LEFT JOIN 
	    usuarios usu ON tras.codigo = usu.codigo 
	LEFT JOIN 
	    usuarios AS usu2 ON tras.persona_recibe = usu2.codigo
	LEFT JOIN 
	    sucursales AS suc2 ON tras.sucursal_recibe = suc2.codsucursal
	LEFT JOIN 
	    documentos AS doc3 ON suc2.documsucursal = doc3.coddocumento
	LEFT JOIN 
	    documentos AS doc4 ON suc2.documencargado = doc4.coddocumento
	LEFT JOIN 
        ciudades ciud2 ON suc2.id_ciudad = ciud2.id_ciudad 
    LEFT JOIN 
        comunas com2 ON suc2.id_comuna = com2.id_comuna
    LEFT JOIN (
        SELECT
            dtra.codtraspaso,
            SUM(dtra.cantidad) AS articulos
        FROM 
            detalletraspasos dtra
            WHERE dtra.codsucursal = :codSucursal1
        GROUP BY dtra.codtraspaso
    ) pag ON pag.codtraspaso = tras.codtraspaso
    LEFT JOIN
       (SELECT
       codcambio, descripcioncambio, montocambio, codmoneda       
       FROM tiposcambio
       ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = suc.codmoneda2
    WHERE tras.codtraspaso = :codTraspaso AND tras.sucursal_envia = :codSucursal2 LIMIT 1";
    try {
        $stmt = $this->dbh->prepare($sql);
        // Asignamos los parámetros a los marcadores de posición con nombre
        $stmt->bindParam(':codTraspaso', $codTraspaso);
        $stmt->bindParam(':codSucursal1', $codSucursal);
        $stmt->bindParam(':codSucursal2', $codSucursal);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        if (!$row) {
            echo "<div class='alert alert-danger'>";
            echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
            echo "<center><span class='fa fa-info-circle'></span> TRASPASO NO ENCONTRADO.</center>";
            echo "</div>";
            exit();
        } else {
            $this->p[] = $row;
            return $this->p;
        }
    } catch (PDOException $e) {
        error_log("Error en TraspasosPorId: " . $e->getMessage());
        echo "<div class='alert alert-danger'>";
        echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
        echo "<center><span class='fa fa-exclamation-triangle'></span> OCURRIÓ UN ERROR AL CONSULTAR EL TRASPASO.</center>";
        echo "</div>";
        return [];
    }
}
############################ FUNCION ID TRASPASOS #################################

############################ FUNCION VER DETALLES TRASPASOS ###########################
public function VerDetallesTraspasos()
{
	$this->p     = [];
	$codTraspaso = isset($_GET["codtraspaso"]) ? limpiar(decrypt($_GET["codtraspaso"])) : '';
    $codSucursal = isset($_GET["codsucursal"]) ? limpiar(decrypt($_GET["codsucursal"])) : '';
    $sql = "SELECT
	dtra.*,
	ma.nommarca,
	mo.nommodelo,
	pr.nompresentacion,
	co.nomcolor
	FROM
	    detalletraspasos dtra
	LEFT JOIN 
	    marcas ma ON dtra.codmarca = ma.codmarca
	LEFT JOIN 
	    modelos mo ON dtra.codmodelo = mo.codmodelo 
	LEFT JOIN 
	    presentaciones pr ON dtra.codpresentacion = pr.codpresentacion
	LEFT JOIN 
	    colores co ON dtra.codcolor = co.codcolor 
	WHERE dtra.codtraspaso = ? AND dtra.codsucursal = ?";
	try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute([$codTraspaso,$codSucursal]);
        $this->p = $stmt->fetchAll(PDO::FETCH_ASSOC);
        return $this->p;
    } catch (PDOException $e) {
        // Manejo de errores: registra el error y devuelve un array vacío
        error_log("Error en VerDetallesTraspasos: " . $e->getMessage() . " SQL: " . $sql . " Params: " . json_encode([$codTraspaso,$codSucursal]));
        return [];
    }
}
############################ FUNCION VER DETALLES TRASPASOS ############################

############################ FUNCION ACTUALIZAR TRASPASOS ##########################
public function ActualizarTraspasos()
{
	$this->p = [];
	if(empty($_POST["codtraspaso"]) or empty($_POST["sucursal_envia"]) or empty($_POST["sucursal_recibe"]) or empty($_POST["fechatraspaso"]))
	{
		echo "1";
		exit;
	}

	############ VERIFICO QUE CANTIDAD NO SEA IGUAL A CERO #############
	for($i=0;$i<count($_POST['coddetalletraspaso']);$i++){  //recorro el array
        if (!empty($_POST['coddetalletraspaso'][$i])) {

	        if($_POST['cantidad'][$i]==0){

		        echo "2";
		        exit();
	        }
        }
    }
    ############ VERIFICO QUE CANTIDAD NO SEA IGUAL A CERO #############

	$this->dbh->beginTransaction();
	for($i=0;$i<count($_POST['coddetalletraspaso']);$i++){  //recorro el array
	if (!empty($_POST['coddetalletraspaso'][$i])) {

	############### OBTENGO DETALLES DE TRASPASOS ##################
	$sql = "SELECT 
	cantidad 
	FROM detalletraspasos 
	WHERE coddetalletraspaso = '".limpiar($_POST['coddetalletraspaso'][$i])."' 
	AND codtraspaso = '".limpiar(decrypt($_POST["codtraspaso"]))."' 
	AND codsucursal = '".limpiar(decrypt($_POST["sucursal_envia"]))."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$cantidadbd = $row['cantidad'];
	############### OBTENGO DETALLES DE TRASPASOS ##################

	if($cantidadbd != $_POST['cantidad'][$i]){

	############ CONSULTO LA EXISTENCIA DE PRODUCTO EN ALMACEN SALIENTE ############
    $sql = "SELECT existencia FROM productos 
    WHERE codproducto = '".limpiar($_POST['codproducto'][$i])."' 
    AND codsucursal = '".limpiar(decrypt($_POST["sucursal_envia"]))."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$existenciabd  = $row['existencia'];
	$cantidad      = $_POST["cantidad"][$i];
	$cantidadbd    = $_POST["cantidadbd"][$i];
	$totaltraspaso = $cantidad-$cantidadbd;
	############ CONSULTO LA EXISTENCIA DE PRODUCTO EN ALMACEN SALIENTE ############

    if ($totaltraspaso > $existenciabd) 
    { 
	    echo "3";
	    exit;
    }

	################### ACTUALIZO DETALLES DE TRASPASO ####################
	$query = "UPDATE detalletraspasos set"
	." cantidad = ?, "
	." valortotal = ?, "
	." totaldescuentov = ?, "
	." subtotalimpuestos = ?, "
	." valorneto = ?, "
	." valorneto2 = ? "
	." WHERE "
	." coddetalletraspaso = ? AND codtraspaso = ? AND codsucursal = ?;
	";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $cantidad);
	$stmt->bindParam(2, $valortotal);
	$stmt->bindParam(3, $totaldescuentov);
	$stmt->bindParam(4, $subtotalimpuestos);
	$stmt->bindParam(5, $valorneto);
	$stmt->bindParam(6, $valorneto2);
	$stmt->bindParam(7, $coddetalletraspaso);
	$stmt->bindParam(8, $codtraspaso);
	$stmt->bindParam(9, $codsucursal);

	$cantidad           = $_POST['opcionvendido'][$i] == "2" ? number_format($_POST['cantidad'][$i], 3, '.', '') : number_format($_POST['cantidad'][$i], 0, '.', '');
	$preciocompra       = limpiar($_POST['preciocompra'][$i]);
	$precioventa        = limpiar($_POST['precioventa'][$i]);
	$ivaproducto        = limpiar($_POST['ivaproducto'][$i]);
	$descuento          = $_POST['descproducto'][$i]/100;
	$valortotal         = number_format($_POST['valortotal'][$i], 2, '.', '');
	$totaldescuento     = number_format($_POST['totaldescuentov'][$i], 2, '.', '');
	$subtotalimpuestos  = number_format($_POST['subtotalimpuestos'][$i], 0, '.', '');
	$valorneto          = number_format($_POST['valorneto'][$i], 2, '.', '');
	$valorneto2         = number_format($_POST['valorneto2'][$i], 2, '.', '');
	$coddetalletraspaso = limpiar($_POST['coddetalletraspaso'][$i]);
	$codtraspaso        = limpiar(decrypt($_POST["codtraspaso"]));
	$codsucursal        = limpiar(decrypt($_POST["sucursal_envia"]));
	$stmt->execute();
	################### ACTUALIZO DETALLES DE TRASPASO ####################

	##########################################################################################################
	#                                                                                                        #
	#                                   PROCESO DE PRODUCTOS SALIENTES                                       #
	#                                                                                                        #
	##########################################################################################################

	############## ACTUALIZAMOS EXISTENCIA DEL PRODUCTO EN ALMACEN #1 ##############
	$sql2 = "UPDATE productos set "
	." existencia = ? "
	." WHERE "
	." codproducto = '".limpiar($_POST["codproducto"][$i])."' 
	AND codsucursal = '".limpiar(decrypt($_POST["sucursal_envia"]))."';
	";
	$stmt = $this->dbh->prepare($sql2);
	$stmt->bindParam(1, $existencia);
	$existencia = $_POST["opcionvendido"][$i] == "2" ? number_format($existenciabd-$totaltraspaso, 3, '.', '') : number_format($existenciabd-$totaltraspaso, 0, '.', '');
	$stmt->execute();
    ############## ACTUALIZAMOS EXISTENCIA DEL PRODUCTO EN ALMACEN #1 ##############

	############### ACTUALIZAMOS LOS DATOS DEL PRODUCTO EN KARDEX #1 ###############
	$sql3 = " UPDATE kardex set "
	." salidas = ?, "
	." stockactual = ? "
	." WHERE "
	." codproceso = '".limpiar($_POST["codtraspaso"])."' 
	AND codproducto = '".limpiar($_POST["codproducto"][$i])."' 
	AND codsucursal = '".limpiar(decrypt($_POST["sucursal_envia"]))."'
	AND tipokardex = 1
	AND procedimiento = 1;
	";
	$stmt = $this->dbh->prepare($sql3);
	$stmt->bindParam(1, $salidas);
	$stmt->bindParam(2, $existencia);

	$salidas    = $_POST["opcionvendido"][$i] == "2" ? number_format($_POST["cantidad"][$i], 3, '.', '') : number_format($_POST["cantidad"][$i], 0, '.', '');
	$existencia = $_POST["opcionvendido"][$i] == "2" ? number_format($existenciabd-$totaltraspaso, 3, '.', '') : number_format($existenciabd-$totaltraspaso, 0, '.', '');
	$stmt->execute();
	############### ACTUALIZAMOS LOS DATOS DEL PRODUCTO EN KARDEX #1 ###############

	##########################################################################################################
	#                                                                                                        #
	#                                   PROCESO DE PRODUCTOS SALIENTES                                       #
	#                                                                                                        #
	##########################################################################################################

	} else {
                echo "";
	        }
        }
    }
    $this->dbh->commit();

    ################### ACTUALIZO TRASPASO ####################
	$sql = " UPDATE traspasos SET "
	." nombres_responsable = ?, "
	." subtotalivasi = ?, "
	." subtotalivano = ?, "
	." totaliva = ?, "
	." descontado = ?, "
	." descuento = ?, "
	." totaldescuento = ?, "
	." totalpago = ?, "
	." totalpago2= ?, "
	." observaciones = ?, "
	." estado_traspaso = ?, "
	." fecha_enviado = ? "
	." WHERE "
	." codtraspaso = ? AND sucursal_envia = ?;
	";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $nombres_responsable);
	$stmt->bindParam(2, $subtotalivasi);
	$stmt->bindParam(3, $subtotalivano);
	$stmt->bindParam(4, $totaliva);
	$stmt->bindParam(5, $descontado);
	$stmt->bindParam(6, $descuento);
	$stmt->bindParam(7, $totaldescuento);
	$stmt->bindParam(8, $totalpago);
	$stmt->bindParam(9, $totalpago2);
	$stmt->bindParam(10, $observaciones);
	$stmt->bindParam(11, $estado_traspaso);
	$stmt->bindParam(12, $fecha_enviado);
	$stmt->bindParam(13, $codtraspaso);
	$stmt->bindParam(14, $codsucursal);

	$nombres_responsable = limpiar($_POST["nombres_responsable"]);
	$subtotalivasi       = number_format($_POST["txtsubtotal"], 2, '.', '');
	$subtotalivano       = number_format($_POST["txtsubtotal2"], 2, '.', '');
	$totaliva            = number_format($_POST["txtIva"], 2, '.', '');
	$descontado          = number_format($_POST["txtdescontado"], 2, '.', '');
	$descuento           = limpiar($_POST["descuento"]);
	$totaldescuento      = number_format($_POST["txtDescuento"], 2, '.', '');
	$totalpago           = number_format($_POST["txtTotal"], 2, '.', '');
	$totalpago2          = number_format($_POST["txtTotalCompra"], 2, '.', '');
    $observaciones       = limpiar($_POST["observaciones"]);
    $estado_traspaso     = limpiar($_POST["estado_traspaso"]);
    $fecha_enviado       = limpiar($_POST["estado_traspaso"] == 2 ? date("Y-m-d H:i:s") : "");
	$codtraspaso         = limpiar(decrypt($_POST["codtraspaso"]));
    $codsucursal         = limpiar(decrypt($_POST["sucursal_envia"]));
	$stmt->execute();
	################### ACTUALIZO TRASPASO ####################

    echo "<span class='fa fa-check-square-o'></span> EL TRASPASO DE PRODUCTOS HA SIDO ACTUALIZADO EXITOSAMENTE <a href='reportepdf?codtraspaso=".encrypt($codtraspaso)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt("FACTURATRASPASO")."' class='on-default' data-placement='left' data-toggle='tooltip' data-original-title='Imprimir Documento' target='_black' rel='noopener noreferrer'><font color='black'><strong>IMPRIMIR REPORTE</strong></font color></a></div>";

	echo "<script>VentanaCentrada('reportepdf?codtraspaso=".encrypt($codtraspaso)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt("FACTURATRASPASO")."', '', '', '1024', '568', 'true');</script>";
	exit;
}
######################### FUNCION ACTUALIZAR TRASPASOS ############################

######################### FUNCION AGREGAR DETALLES TRASPASOS #########################
public function AgregarDetallesTraspasos()
{
	$this->p = [];
	if(empty($_POST["codtraspaso"]) or empty($_POST["sucursal_envia"]) or empty($_POST["sucursal_recibe"]) or empty($_POST["fechatraspaso"]))
	{
		echo "1";
		exit;
	}
    elseif(empty($_SESSION["CarritoTraspaso"]) || $_POST["txtTotal"]=="0.00")
	{
		echo "2";
		exit;
	}

	############ CONSULTO TOTAL ACTUAL DE TRASPASOS ##############
	$sql = "SELECT
	codfactura,
	descuento,
	totalpago 
	FROM traspasos 
	WHERE codtraspaso = '".limpiar(decrypt($_POST["codtraspaso"]))."' 
	AND sucursal_envia = '".limpiar(decrypt($_POST["sucursal_envia"]))."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$codfacturabd = $row['codfactura'];
	$descuentobd  = $row['descuento'];
	$totalpagobd  = $row['totalpago'];
	############ CONSULTO TOTAL ACTUAL DE TRASPASOS ##############

    $this->dbh->beginTransaction();
    $detalle = $_SESSION["CarritoTraspaso"];
	for($i=0;$i<count($detalle);$i++){

    ############### VERIFICO AL EXISTENCIA DEL PRODUCTO AGREGADO ################
	$sql = "SELECT * FROM productos 
	WHERE codproducto = '".limpiar($detalle[$i]['txtCodigo'])."' 
	AND codsucursal = '".limpiar(decrypt($_POST["sucursal_envia"]))."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$existenciabd = $row['existencia'];
	############### VERIFICO AL EXISTENCIA DEL PRODUCTO AGREGADO ################

	############# REVISAMOS QUE LA CANTIDAD NO SEA IGUAL A CERO ##############
	if($detalle[$i]['cantidad']==0){

		echo "3";
		exit;
    }
    ############# REVISAMOS QUE LA CANTIDAD NO SEA IGUAL A CERO ##############

	############ REVISAMOS SI LA CANTIDAD ES MAYOR QUE LA EXISTENCIA #######
    if ($detalle[$i]['cantidad'] > $existenciabd) 
    { 
        echo "4";
        exit;
    }
    ############ REVISAMOS SI LA CANTIDAD ES MAYOR QUE LA EXISTENCIA #######

	$sql = "SELECT 
	codtraspaso, 
	codproducto 
	FROM detalletraspasos 
	WHERE codtraspaso = '".limpiar(decrypt($_POST['codtraspaso']))."' 
	AND codsucursal = '".limpiar(decrypt($_POST['sucursal_envia']))."' 
	AND codproducto = '".limpiar($detalle[$i]['txtCodigo'])."'";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num == 0)
	{
        ################### REGISTRO DETALLES DE TRASPASO ####################
        $query = "INSERT INTO detalletraspasos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codtraspaso);
        $stmt->bindParam(2, $idproducto);
	    $stmt->bindParam(3, $codproducto);
	    $stmt->bindParam(4, $producto);
	    $stmt->bindParam(5, $descripcion);
        $stmt->bindParam(6, $opcionvendido);
	    $stmt->bindParam(7, $imei);
	    $stmt->bindParam(8, $condicion);
        $stmt->bindParam(9, $codmarca);
        $stmt->bindParam(10, $codmodelo);
        $stmt->bindParam(11, $codpresentacion);
	    $stmt->bindParam(12, $codcolor);
		$stmt->bindParam(13, $cantidad);
		$stmt->bindParam(14, $preciocompra);
		$stmt->bindParam(15, $precioventa);
		$stmt->bindParam(16, $ivaproducto);
		$stmt->bindParam(17, $descproducto);
		$stmt->bindParam(18, $valortotal);
		$stmt->bindParam(19, $totaldescuentov);
		$stmt->bindParam(20, $subtotalimpuestos);
		$stmt->bindParam(21, $valorneto);
		$stmt->bindParam(22, $valorneto2);
		$stmt->bindParam(23, $tipodetalle);
		$stmt->bindParam(24, $codsucursal);
			
		$codtraspaso     = limpiar(decrypt($_POST["codtraspaso"]));
	    $idproducto      = limpiar($detalle[$i]['id']);
		$codproducto     = limpiar($detalle[$i]['txtCodigo']);
		$producto        = limpiar($detalle[$i]['producto']);
		$descripcion     = limpiar($detalle[$i]['descripcion'] == "0" ? "" : $detalle[$i]['descripcion']);
	    $imei            = limpiar($detalle[$i]['imei'] == "0" ? "" : $detalle[$i]['imei']);
	    $condicion       = limpiar($detalle[$i]['condicion'] == "0" ? "" : $detalle[$i]['condicion']);
		$codmarca        = limpiar($detalle[$i]['codmarca']);
		$codmodelo       = limpiar($detalle[$i]['codmodelo']);
		$codpresentacion = limpiar($detalle[$i]['codpresentacion']);
		$codcolor        = limpiar($detalle[$i]['codcolor']);
		$cantidad        = $detalle[$i]['opcionvendido'] == "2" ? number_format($detalle[$i]['cantidad'], 3, '.', '') : number_format($detalle[$i]['cantidad'], 0, '.', '');
		$preciocompra    = limpiar($detalle[$i]['precio']);
		$precioventa     = limpiar($detalle[$i]['precio2']);
		$precioconiva    = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['precio2']);
		$ivaproducto     = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
		$descproducto    = limpiar($detalle[$i]['descproducto']);
		$descuento       = $detalle[$i]['descproducto']/100;
		$valortotal      = number_format($detalle[$i]['precio2']*$detalle[$i]['cantidad'], 2, '.', '');
		$totaldescuentov = number_format($valortotal*$descuento, 2, '.', '');

		//CALCULO SUBTOTAL IMPUESTOS
		$ValorImpuesto        = 1 + ($_POST["iva"]/100);
		$RestoDescuento       = $precioconiva * $detalle[$i]['descproducto'] / 100;
		$PrecioIvaDescuento   = $precioconiva - $RestoDescuento;
		$Discriminado         = $PrecioIvaDescuento/$ValorImpuesto;
	    $SubtotalDiscriminado = $PrecioIvaDescuento - $Discriminado;
		$BaseDiscriminado     = $SubtotalDiscriminado * $detalle[$i]['cantidad'];
		$subtotalimpuestos    = number_format($BaseDiscriminado, 2, '.', '');

	    $valorneto   = number_format($valortotal-$totaldescuentov, 2, '.', '');
		$valorneto2  = number_format($detalle[$i]['precio']*$detalle[$i]['cantidad'], 2, '.', '');
        $tipodetalle = limpiar($detalle[$i]['tipodetalle']);
		$codsucursal = limpiar(decrypt($_POST["sucursal_envia"]));
		$stmt->execute();
		################### REGISTRO DETALLES DE TRASPASO ####################

	    ##################### ACTUALIZO LA EXISTENCIA DEL ALMACEN #1 ###################
		$sql = " UPDATE productos set "
		." existencia = ? "
		." WHERE "
		." codproducto = '".limpiar($detalle[$i]['txtCodigo'])."'
		AND codsucursal = '".limpiar(decrypt($_POST["sucursal_envia"]))."';
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $existencia);

		$cantraspaso = $detalle[$i]['opcionvendido'] == "2" ? number_format($detalle[$i]['cantidad'], 3, '.', '') : number_format($detalle[$i]['cantidad'], 0, '.', '');
		$existencia  = $detalle[$i]['opcionvendido'] == "2" ? number_format($existenciabd-$detalle[$i]['cantidad'], 3, '.', '') : number_format($existenciabd-$detalle[$i]['cantidad'], 0, '.', '');
		$stmt->execute();
		##################### ACTUALIZO LA EXISTENCIA DEL ALMACEN #1 ###################

		############### REGISTRAMOS LOS PRODUCTOS SALIENTES EN KARDEX #1 ###############
        $query = "INSERT INTO kardex values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codtraspaso);
		$stmt->bindParam(2, $codresponsable);
		$stmt->bindParam(3, $codproducto);
		$stmt->bindParam(4, $movimiento);
		$stmt->bindParam(5, $entradas);
		$stmt->bindParam(6, $salidas);
		$stmt->bindParam(7, $devolucion);
		$stmt->bindParam(8, $stockactual);
		$stmt->bindParam(9, $ivaproducto);
		$stmt->bindParam(10, $descproducto);
		$stmt->bindParam(11, $precio);
		$stmt->bindParam(12, $documento);
		$stmt->bindParam(13, $fechakardex);	
		$stmt->bindParam(14, $tipokardex);	
		$stmt->bindParam(15, $procedimiento);		
		$stmt->bindParam(16, $codsucursal);
		$stmt->bindParam(17, $codigo);

		$codresponsable = limpiar(decrypt($_POST["sucursal_recibe"]));
		$codproducto    = limpiar($detalle[$i]['txtCodigo']);
		$movimiento     = limpiar("SALIDAS");
		$entradas       = $detalle[$i]['opcionvendido'] == "2" ? "0.000" : "0";
		$salidas        = $detalle[$i]['opcionvendido'] == "2" ? number_format($detalle[$i]['cantidad'], 3, '.', '') : number_format($detalle[$i]['cantidad'], 0, '.', '');
		$devolucion     = $detalle[$i]['opcionvendido'] == "2" ? "0.000" : "0";
		$stockactual    = $detalle[$i]['opcionvendido'] == "2" ? number_format($existenciabd-$detalle[$i]['cantidad'], 3, '.', '') : number_format($existenciabd-$detalle[$i]['cantidad'], 0, '.', '');
		$precio         = limpiar($detalle[$i]["precio2"]);
		$ivaproducto    = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
		$descproducto   = limpiar($detalle[$i]['descproducto']);
		$documento      = limpiar("TRASPASO: ".$codfacturabd);
		$fechakardex    = limpiar(date("Y-m-d"));
		$tipokardex     = limpiar($detalle[$i]['tipodetalle']);
		$procedimiento  = limpiar("1");
		$codsucursal    = limpiar(decrypt($_POST["sucursal_envia"]));
    	$codigo         = limpiar($_SESSION["codigo"]);
		$stmt->execute();

	} else {

	  	############### OBTENGO DETALLES DE TRASPASOS ##################
	  	$sql = "SELECT cantidad FROM detalletraspasos 
	  	WHERE codtraspaso = '".limpiar(decrypt($_POST['codtraspaso']))."' 
	  	AND codsucursal = '".limpiar(decrypt($_POST['sucursal_envia']))."' 
	  	AND codproducto = '".limpiar($detalle[$i]['txtCodigo'])."'";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		$cantidadbd = $row['cantidad'];
		############### OBTENGO DETALLES DE TRASPASOS ##################

	  	################### ACTUALIZO DETALLES DE TRASPASO ####################
	  	$query = "UPDATE detalletraspasos set"
		." cantidad = ?, "
		." descproducto = ?, "
		." valortotal = ?, "
		." totaldescuentov = ?, "
		." subtotalimpuestos = ?, "
		." valorneto = ?, "
		." valorneto2 = ? "
		." WHERE "
		." codtraspaso = ? AND codsucursal = ? AND codproducto = ?;
		";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $cantidad);
		$stmt->bindParam(2, $descproducto);
		$stmt->bindParam(3, $valortotal);
		$stmt->bindParam(4, $totaldescuentov);
		$stmt->bindParam(5, $subtotalimpuestos);
		$stmt->bindParam(6, $valorneto);
		$stmt->bindParam(7, $valorneto2);
		$stmt->bindParam(8, $codtraspaso);
		$stmt->bindParam(9, $codsucursal);
		$stmt->bindParam(10, $codproducto);

		$cantidad        = limpiar($detalle[$i]['cantidad']+$cantidadbd);
		$preciocompra    = limpiar($detalle[$i]['precio']);
		$precioventa     = limpiar($detalle[$i]['precio2']);
		$precioconiva    = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['precio2']);
		$ivaproducto     = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
		$descproducto    = limpiar($detalle[$i]['descproducto']);
		$descuento       = $detalle[$i]['descproducto']/100;
		$valortotal      = number_format($detalle[$i]['precio2'] * $cantidad, 2, '.', '');
		$totaldescuentov = number_format($valortotal * $descuento, 2, '.', '');

		//CALCULO SUBTOTAL IMPUESTOS
		$ValorImpuesto        = 1 + ($_POST["iva"]/100);
		$RestoDescuento       = $precioconiva * $detalle[$i]['descproducto'] / 100;
		$PrecioIvaDescuento   = $precioconiva - $RestoDescuento;
		$Discriminado         = $PrecioIvaDescuento/$ValorImpuesto;
	    $SubtotalDiscriminado = $PrecioIvaDescuento - $Discriminado;
		$BaseDiscriminado     = $SubtotalDiscriminado * $cantidad;
		$subtotalimpuestos    = number_format($BaseDiscriminado, 2, '.', '');

		$valorneto   = number_format($valortotal - $totaldescuentov, 2, '.', '');
		$valorneto2  = number_format($detalle[$i]['precio'] * $cantidad, 2, '.', '');
		$codtraspaso = limpiar(decrypt($_POST["codtraspaso"]));
		$codsucursal = limpiar(decrypt($_POST['sucursal_envia']));
		$codproducto = limpiar($detalle[$i]['txtCodigo']);
		$stmt->execute();
		################### ACTUALIZO DETALLES DE TRASPASO ####################

		############## ACTUALIZAMOS EXISTENCIA DEL PRODUCTO ##############
		$sql = " UPDATE productos set "
			." existencia = ? "
			." WHERE "
			." codproducto = '".limpiar($detalle[$i]['txtCodigo'])."' 
			AND codsucursal = '".limpiar(decrypt($_POST['sucursal_envia']))."';
			";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $existencia);
		$cantraspaso = $detalle[$i]['opcionvendido'] == "2" ? number_format($detalle[$i]['cantidad'], 3, '.', '') : number_format($detalle[$i]['cantidad'], 0, '.', '');
		$existencia  = $detalle[$i]['opcionvendido'] == "2" ? number_format($existenciabd-$detalle[$i]['cantidad'], 3, '.', '') : number_format($existenciabd-$detalle[$i]['cantidad'], 0, '.', '');
		$stmt->execute();
		############## ACTUALIZAMOS EXISTENCIA DEL PRODUCTO ##############

		############### ACTUALIZAMOS DATOS EN KARDEX ##############
		$sql3 = " UPDATE kardex set "
		." salidas = ?, "
		." stockactual = ? "
		." WHERE "
		." codproceso = '".limpiar(decrypt($_POST["codtraspaso"]))."' 
		AND codproducto = '".limpiar($detalle[$i]['txtCodigo'])."' 
		AND codsucursal = '".limpiar(decrypt($_POST['sucursal_envia']))."'
		AND tipokardex = 1
		AND procedimiento = 1;
		";
		$stmt = $this->dbh->prepare($sql3);
		$stmt->bindParam(1, $salidas);
		$stmt->bindParam(2, $existencia);

		$salidas    = $detalle[$i]['opcionvendido'] == "2" ? number_format($detalle[$i]['cantidad']+$cantidadbd, 3, '.', '') : number_format($detalle[$i]['cantidad']+$cantidadbd, 0, '.', '');
		$existencia = $detalle[$i]['opcionvendido'] == "2" ? number_format($existenciabd-$detalle[$i]['cantidad'], 3, '.', '') : number_format($existenciabd-$detalle[$i]['cantidad'], 0, '.', '');
		$stmt->execute();
		############### ACTUALIZAMOS DATOS EN KARDEX ##############

	}//FIN DE AGREGAR DETALLES DE PRODUCTOS

    }//FIN SESSION DETALLES

    
    ####################### DESTRUYO LA VARIABLE DE SESSION #####################
    unset($_SESSION["CarritoTraspaso"]);
    $this->dbh->commit();

    ############ SUMO LOS IMPORTE DE PRODUCTOS CON IVA ##############
	$sql3 = "SELECT SUM(totaldescuentov) AS totaldescuentosi, SUM(subtotalimpuestos) AS subtotalimpuestos, SUM(valorneto-subtotalimpuestos) AS valorneto, SUM(valorneto2) AS valorneto2 FROM detalletraspasos WHERE codtraspaso = '".limpiar(decrypt($_POST["codtraspaso"]))."' AND codsucursal = '".limpiar(decrypt($_POST["sucursal_envia"]))."' AND ivaproducto != '0.00'";
	foreach ($this->dbh->query($sql3) as $row3)
	{
		$this->p[] = $row3;
	}
	$subtotaldescuentosi = ($row3['totaldescuentosi']== "" ? "0.00" : $row3['totaldescuentosi']);
	$subtotalimpuestos   = ($row3['subtotalimpuestos']== "" ? "0.00" : $row3['subtotalimpuestos']);
	$subtotalivasi       = ($row3['valorneto']== "" ? "0.00" : $row3['valorneto']);
	$subtotalivasi2      = ($row3['valorneto2']== "" ? "0.00" : $row3['valorneto2']);
	############ SUMO LOS IMPORTE DE PRODUCTOS CON IVA ##############	

	############ SUMO LOS IMPORTE DE PRODUCTOS SIN IVA ##############
	$sql4 = "SELECT SUM(totaldescuentov) AS totaldescuentono, SUM(valorneto) AS valorneto, SUM(valorneto2) AS valorneto2 FROM detalletraspasos WHERE codtraspaso = '".limpiar(decrypt($_POST["codtraspaso"]))."' AND codsucursal = '".limpiar(decrypt($_POST["sucursal_envia"]))."' AND ivaproducto = '0.00'";
	foreach ($this->dbh->query($sql4) as $row4)
	{
		$this->p[] = $row4;
	}
	$subtotaldescuentono = ($row4['totaldescuentono']== "" ? "0.00" : $row4['totaldescuentono']);
	$subtotalivano       = ($row4['valorneto']== "" ? "0.00" : $row4['valorneto']);
	$subtotalivano2      = ($row4['valorneto2']== "" ? "0.00" : $row4['valorneto2']);
	############ SUMO LOS IMPORTE DE PRODUCTOS SIN IVA ##############

    ################### ACTUALIZO TRASPASO ####################
	$sql = " UPDATE traspasos SET "
	." nombres_responsable = ?, "
	." subtotalivasi = ?, "
	." subtotalivano = ?, "
	." totaliva = ?, "
	." descontado = ?, "
	." descuento = ?, "
	." totaldescuento = ?, "
	." totalpago = ?, "
	." totalpago2= ?, "
	." observaciones = ?, "
	." estado_traspaso = ? "
	." WHERE "
	." codtraspaso = ? AND sucursal_envia = ?;
	";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $nombres_responsable);
	$stmt->bindParam(2, $subtotalivasi);
	$stmt->bindParam(3, $subtotalivano);
	$stmt->bindParam(4, $totaliva);
	$stmt->bindParam(5, $descontado);
	$stmt->bindParam(6, $descuento);
	$stmt->bindParam(7, $totaldescuento);
	$stmt->bindParam(8, $totalpago);
	$stmt->bindParam(9, $totalpago2);
	$stmt->bindParam(10, $observaciones);
	$stmt->bindParam(11, $estado_traspaso);
	$stmt->bindParam(12, $codtraspaso);
	$stmt->bindParam(13, $codsucursal);

	$nombres_responsable = limpiar($_POST["nombres_responsable"]);
	$iva             = $_POST["iva"]/100;
	$totaliva        = number_format($subtotalimpuestos, 2, '.', '');
	$descontado      = number_format($subtotaldescuentosi+$subtotaldescuentono, 2, '.', '');
	$descuento       = limpiar($_POST["descuento"]+$descuentobd);
    $txtDescuento    = $descuento/100;
    $total           = number_format($subtotalivasi+$subtotalivano+$totaliva, 2, '.', '');
    $totaldescuento  = number_format($total*$txtDescuento, 2, '.', '');
    $totalpago       = number_format($total-$totaldescuento, 2, '.', '');
	$totalpago2      = number_format($subtotalivasi2+$subtotalivano2, 2, '.', '');
	$observaciones   = limpiar($_POST["observaciones"]);
    $estado_traspaso = limpiar($_POST["estado_traspaso"]);
    $fecha_enviado   = limpiar($_POST["estado_traspaso"] == 2 ? date("Y-m-d H:i:s") : "");
	$codtraspaso     = limpiar(decrypt($_POST["codtraspaso"]));
	$codsucursal     = limpiar(decrypt($_POST["sucursal_envia"]));
	$stmt->execute();
	################### ACTUALIZO TRASPASO ####################

    echo "<span class='fa fa-check-square-o'></span> LOS DETALLES DE PRODUCTOS FUERON AGREGADOS AL TRASPASO EXITOSAMENTE <a href='reportepdf?codtraspaso=".encrypt($codtraspaso)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt("FACTURATRASPASO")."' class='on-default' data-placement='left' data-toggle='tooltip' data-original-title='Imprimir Documento' target='_black' rel='noopener noreferrer'><font color='black'><strong>IMPRIMIR REPORTE</strong></font color></a></div>";

	echo "<script>VentanaCentrada('reportepdf?codtraspaso=".encrypt($codtraspaso)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt("FACTURATRASPASO")."', '', '', '1024', '568', 'true');</script>";
	exit;
}
########################### FUNCION AGREGAR DETALLES TRASPASOS #########################

########################## FUNCION ELIMINAR DETALLES TRASPASOS ##########################
public function EliminarDetallesTraspasos()
{
	$this->p = [];
	if ($_SESSION["acceso"]=="administradorS") {

    ############ CONSULTO TOTAL ACTUAL DE TRASPASOS ##############
	$sql = "SELECT
	codfactura,
	sucursal_recibe, 
	iva,
	descuento,
	totalpago 
	FROM traspasos 
	WHERE codtraspaso = '".limpiar(decrypt($_GET["codtraspaso"]))."' 
	AND sucursal_envia = '".limpiar(decrypt($_GET["codsucursal"]))."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$codfacturabd      = $row['codfactura'];
	$sucursal_recibebd = $row['sucursal_recibe'];
	$iva               = $row["iva"]/100;
	$descuento         = $row["descuento"]/100;
	$totalpagobd       = $row['totalpago'];
	############ CONSULTO TOTAL ACTUAL DE TRASPASOS ##############

	$sql = "SELECT * FROM detalletraspasos WHERE codtraspaso = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codtraspaso"]),decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();
	if($num > 1)
	{
		############ OBTENGO DETALLES DE TRASPASO ##############
		$sql = "SELECT 
		codproducto,
		opcionvendido, 
		cantidad, 
		precioventa, 
		ivaproducto, 
		descproducto 
		FROM detalletraspasos 
		WHERE coddetalletraspaso = ? 
		AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array(decrypt($_GET["coddetalletraspaso"]),decrypt($_GET["codsucursal"])));
		$num = $stmt->rowCount();

		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$p[] = $row;
		}
		$codproductobd   = $row['codproducto'];
		$opcionvendidobd = $row['opcionvendido'];
		$cantidadbd      = $row['cantidad'];
		$precioventabd   = $row['precioventa'];
		$ivaproductobd   = $row['ivaproducto'];
		$descproductobd  = $row['descproducto'];
		############ OBTENGO DETALLES DE TRASPASO ##############

    ##########################################################################################################
	#                                                                                                        #
	#                                   PROCESO DE PRODUCTOS SALIENTES                                       #
	#                                                                                                        #
	##########################################################################################################	

	############ OBTENGO LA EXISTENCIA DE PRODUCTO EN ALMACEN #############
	$sql2 = "SELECT existencia FROM productos WHERE codproducto = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql2);
	$stmt->execute(array($codproductobd,decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();

	if($row = $stmt->fetch(PDO::FETCH_ASSOC))
	{
		$p[] = $row;
	}
	$existenciabd = $row['existencia'];
	############ OBTENGO LA EXISTENCIA DE PRODUCTO EN ALMACEN #############

	############ ACTUALIZAMOS LA EXISTENCIA DE PRODUCTO EN ALMACEN #############
	$sql = "UPDATE productos SET "
	." existencia = ? "
	." WHERE "
	." codproducto = ? AND codsucursal = ?;
	";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $existencia);
	$stmt->bindParam(2, $codproducto);
	$stmt->bindParam(3, $codsucursal);

	$existencia  = $opcionvendidobd == "2" ? number_format($existenciabd+$cantidadbd, 3, '.', '') : number_format($existenciabd+$cantidadbd, 0, '.', '');
	$codproducto = limpiar($codproductobd);
	$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
	$stmt->execute();
	############ ACTUALIZAMOS LA EXISTENCIA DE PRODUCTO EN ALMACEN #############

    ########## REGISTRAMOS LOS DATOS DEL PRODUCTO ELIMINADO EN KARDEX ##########
	$query = "INSERT INTO kardex values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $codtraspaso);
	$stmt->bindParam(2, $recibe);
	$stmt->bindParam(3, $codproducto);
	$stmt->bindParam(4, $movimiento);
	$stmt->bindParam(5, $entradas);
	$stmt->bindParam(6, $salidas);
	$stmt->bindParam(7, $devolucion);
	$stmt->bindParam(8, $stockactual);
	$stmt->bindParam(9, $ivaproducto);
	$stmt->bindParam(10, $descproducto);
	$stmt->bindParam(11, $precio);
	$stmt->bindParam(12, $documento);
	$stmt->bindParam(13, $fechakardex);	
	$stmt->bindParam(14, $tipokardex);	
	$stmt->bindParam(15, $procedimiento);
	$stmt->bindParam(16, $codsucursal);
    $stmt->bindParam(17, $codigo);

	$codtraspaso   = limpiar(decrypt($_GET["codtraspaso"]));
	$recibe        = limpiar($sucursal_recibebd);
	$codproducto   = limpiar($codproductobd);
	$movimiento    = limpiar("DEVOLUCION");
	$entradas      = $opcionvendidobd == "2" ? "0.000" : "0";
	$salidas       = $opcionvendidobd == "2" ? "0.000" : "0";
	$devolucion    = $opcionvendidobd == "2" ? number_format($cantidadbd, 3, '.', '') : number_format($cantidadbd, 0, '.', '');
	$stockactual   = $opcionvendidobd == "2" ? number_format($existenciabd+$cantidadbd, 3, '.', '') : number_format($existenciabd+$cantidadbd, 0, '.', '');
	$precio        = limpiar($precioventabd);
	$ivaproducto   = limpiar($ivaproductobd);
	$descproducto  = limpiar($descproductobd);
	$documento     = limpiar("DEVOLUCION TRASPASO: ".$codfacturabd);
	$fechakardex   = limpiar(date("Y-m-d"));
	$tipokardex    = limpiar("1");
	$procedimiento = limpiar("1");
	$codsucursal   = limpiar(decrypt($_GET["codsucursal"]));
    $codigo        = limpiar($_SESSION["codigo"]);
	$stmt->execute();
	########## REGISTRAMOS LOS DATOS DEL PRODUCTO ELIMINADO EN KARDEX ##########

    ##########################################################################################################
	#                                                                                                        #
	#                                   PROCESO DE PRODUCTOS SALIENTES                                       #
	#                                                                                                        #
	##########################################################################################################				

	########## ELIMINO DETALLES DE TRASPASOS ##########
	$sql = "DELETE FROM detalletraspasos WHERE coddetalletraspaso = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1,$coddetalletraspaso);
	$stmt->bindParam(2,$codsucursal);
	$coddetalletraspaso = decrypt($_GET["coddetalletraspaso"]);
	$codsucursal        = decrypt($_GET["codsucursal"]);
	$stmt->execute();
	########## ELIMINO DETALLES DE TRASPASOS ##########

    ############ SUMO LOS IMPORTE DE PRODUCTOS CON IVA ##############
	$sql3 = "SELECT SUM(totaldescuentov) AS totaldescuentosi, SUM(subtotalimpuestos) AS subtotalimpuestos, SUM(valorneto-subtotalimpuestos) AS valorneto, SUM(valorneto2) AS valorneto2 FROM detalletraspasos WHERE codtraspaso = '".limpiar(decrypt($_GET["codtraspaso"]))."' AND codsucursal = '".limpiar(decrypt($_GET["codsucursal"]))."' AND ivaproducto != '0.00'";
	foreach ($this->dbh->query($sql3) as $row3)
	{
		$this->p[] = $row3;
	}
	$subtotaldescuentosi = ($row3['totaldescuentosi']== "" ? "0.00" : $row3['totaldescuentosi']);
	$subtotalimpuestos   = ($row3['subtotalimpuestos']== "" ? "0.00" : $row3['subtotalimpuestos']);
	$subtotalivasi       = ($row3['valorneto']== "" ? "0.00" : $row3['valorneto']);
	$subtotalivasi2      = ($row3['valorneto2']== "" ? "0.00" : $row3['valorneto2']);
	############ SUMO LOS IMPORTE DE PRODUCTOS CON IVA ##############

    ############ SUMO LOS IMPORTE DE PRODUCTOS SIN IVA ##############
	$sql4 = "SELECT SUM(totaldescuentov) AS totaldescuentono, SUM(valorneto) AS valorneto, SUM(valorneto2) AS valorneto2 FROM detalletraspasos WHERE codtraspaso = '".limpiar(decrypt($_GET["codtraspaso"]))."' AND codsucursal = '".limpiar(decrypt($_GET["codsucursal"]))."' AND ivaproducto = '0.00'";
	foreach ($this->dbh->query($sql4) as $row4)
	{
		$this->p[] = $row4;
	}
	$subtotaldescuentono = ($row4['totaldescuentono']== "" ? "0.00" : $row4['totaldescuentono']);
	$subtotalivano       = ($row4['valorneto']== "" ? "0.00" : $row4['valorneto']);
	$subtotalivano2      = ($row4['valorneto2']== "" ? "0.00" : $row4['valorneto2']);
	############ SUMO LOS IMPORTE DE PRODUCTOS SIN IVA ##############

    ################### ACTUALIZO EL TRASPASO ####################
	$sql = " UPDATE traspasos SET "
	." subtotalivasi = ?, "
	." subtotalivano = ?, "
	." totaliva = ?, "
	." descontado = ?, "
	." totaldescuento = ?, "
	." totalpago = ?, "
	." totalpago2= ? "
	." WHERE "
	." codtraspaso = ? AND sucursal_envia = ?;
	";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $subtotalivasi);
	$stmt->bindParam(2, $subtotalivano);
	$stmt->bindParam(3, $totaliva);
	$stmt->bindParam(4, $descontado);
	$stmt->bindParam(5, $totaldescuento);
	$stmt->bindParam(6, $totalpago);
	$stmt->bindParam(7, $totalpago2);
	$stmt->bindParam(8, $codtraspaso);
	$stmt->bindParam(9, $codsucursal);

	$totaliva       = number_format($subtotalimpuestos, 2, '.', '');
	$descontado     = number_format($subtotaldescuentosi+$subtotaldescuentono, 2, '.', '');
    $total          = number_format($subtotalivasi+$subtotalivano+$totaliva, 2, '.', '');
    $totaldescuento = number_format($total*$descuento, 2, '.', '');
    $totalpago      = number_format($total-$totaldescuento, 2, '.', '');
	$totalpago2     = number_format($subtotalivasi2+$subtotalivano2, 2, '.', '');
	$codtraspaso    = limpiar(decrypt($_GET["codtraspaso"]));
	$codsucursal    = limpiar(decrypt($_GET["codsucursal"]));
	$stmt->execute();
	################### ACTUALIZO EL TRASPASO ####################

		echo "1";
		exit;

	} else {
		   
		echo "2";
		exit;
	} 
			
	} else {
		
		echo "3";
		exit;
	}	
}
######################### FUNCION ELIMINAR DETALLES TRASPASOS #########################

########################## FUNCION ELIMINAR TRASPASOS #############################
public function EliminarTraspasos()
{
	$this->p = [];
	if ($_SESSION["acceso"]=="administradorS") {

    ########################## CONSULTO DATOS DE TRASPASO ##########################
	$sql = "SELECT
	codfactura,
	sucursal_recibe, 
	totalpago 
	FROM traspasos 
	WHERE codtraspaso = '".limpiar(decrypt($_GET["codtraspaso"]))."' 
	AND sucursal_envia = '".limpiar(decrypt($_GET["codsucursal"]))."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$codfacturabd      = $row['codfactura'];
	$sucursal_recibebd = $row['sucursal_recibe'];
	$totalpagobd       = $row['totalpago'];
	########################## CONSULTO DATOS DE TRASPASO ##########################

    $sql = "SELECT * FROM detalletraspasos 
    WHERE codtraspaso = '".limpiar(decrypt($_GET["codtraspaso"]))."' 
    AND codsucursal = '".limpiar(decrypt($_GET["codsucursal"]))."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;

		$codproductobd  = $row['codproducto'];
		$opcionvendidobd = $row['opcionvendido'];
		$cantidadbd     = $row['cantidad'];
		$precioventabd  = $row['precioventa'];
		$ivaproductobd  = $row['ivaproducto'];
		$descproductobd = $row['descproducto'];

    ##########################################################################################################
	#                                                                                                        #
	#                                   PROCESO DE PRODUCTOS SALIENTES                                       #
	#                                                                                                        #
	##########################################################################################################

    ############ OBTENGO LA EXISTENCIA DE PRODUCTO EN ALMACEN #############
	$sql2 = "SELECT existencia FROM productos WHERE codproducto = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql2);
	$stmt->execute(array($codproductobd,decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();

	if($row2 = $stmt->fetch(PDO::FETCH_ASSOC))
	{
		$p[] = $row2;
	}
	$existenciabd = $row2['existencia'];
	############ OBTENGO LA EXISTENCIA DE PRODUCTO EN ALMACEN #############

	########### ACTUALIZAMOS LA EXISTENCIA DE PRODUCTO EN ALMACEN ############
	$sql = "UPDATE productos SET "
	." existencia = ? "
	." WHERE "
	." codproducto = ? AND codsucursal = ?;
	";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $existencia);
	$stmt->bindParam(2, $codproducto);
	$stmt->bindParam(3, $codsucursal);

	$existencia  = $opcionvendidobd == "2" ? number_format($existenciabd+$cantidadbd, 3, '.', '') : number_format($existenciabd+$cantidadbd, 0, '.', '');
	$codproducto = limpiar($codproductobd);
	$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
	$stmt->execute();
	########### ACTUALIZAMOS LA EXISTENCIA DE PRODUCTO EN ALMACEN ############

    ########### REGISTRAMOS DATOS DEL PRODUCTO ELIMINADO EN KARDEX ############
	$query = "INSERT INTO kardex values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $codtraspaso);
	$stmt->bindParam(2, $recibe);
	$stmt->bindParam(3, $codproducto);
	$stmt->bindParam(4, $movimiento);
	$stmt->bindParam(5, $entradas);
	$stmt->bindParam(6, $salidas);
	$stmt->bindParam(7, $devolucion);
	$stmt->bindParam(8, $stockactual);
	$stmt->bindParam(9, $ivaproducto);
	$stmt->bindParam(10, $descproducto);
	$stmt->bindParam(11, $precio);
	$stmt->bindParam(12, $documento);
	$stmt->bindParam(13, $fechakardex);	
	$stmt->bindParam(14, $tipokardex);	
	$stmt->bindParam(15, $procedimiento);
	$stmt->bindParam(16, $codsucursal);
	$stmt->bindParam(17, $codigo);	

	$codtraspaso   = limpiar(decrypt($_GET["codtraspaso"]));
    $recibe        = limpiar($sucursal_recibebd);
    $codproducto   = limpiar($codproductobd);
	$movimiento    = limpiar("DEVOLUCION");
	$entradas      = $opcionvendidobd == "2" ? "0.000" : "0";
	$salidas       = $opcionvendidobd == "2" ? "0.000" : "0";
	$devolucion    = $opcionvendidobd == "2" ? number_format($cantidadbd, 3, '.', '') : number_format($cantidadbd, 0, '.', '');
	$stockactual   = $opcionvendidobd == "2" ? number_format($existenciabd+$cantidadbd, 3, '.', '') : number_format($existenciabd+$cantidadbd, 0, '.', '');
	$ivaproducto   = limpiar($ivaproductobd);
	$descproducto  = limpiar($descproductobd);
	$precio        = limpiar($precioventabd);
	$documento     = limpiar("DEVOLUCION TRASPASO: ".$codfacturabd);
	$fechakardex   = limpiar(date("Y-m-d"));
	$tipokardex    = limpiar("1");
	$procedimiento = limpiar("1");
	$codsucursal   = limpiar(decrypt($_GET["codsucursal"]));
    $codigo        = limpiar($_SESSION["codigo"]);
	$stmt->execute();
	########### REGISTRAMOS DATOS DEL PRODUCTO ELIMINADO EN KARDEX ############

	##########################################################################################################
	#                                                                                                        #
	#                                   PROCESO DE PRODUCTOS SALIENTES                                       #
	#                                                                                                        #
	##########################################################################################################
    		
	}

	########################## ELIMINO TRASPASOS ##########################
	$sql = "DELETE FROM traspasos WHERE codtraspaso = ? AND sucursal_envia = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1,$codtraspaso);
	$stmt->bindParam(2,$codsucursal);
	$codtraspaso = decrypt($_GET["codtraspaso"]);
	$codsucursal = decrypt($_GET["codsucursal"]);
	$stmt->execute();
	########################## ELIMINO TRASPASOS ##########################

	########################## ELIMINO DETALLES TRASPASOS ##########################
	$sql = "DELETE FROM detalletraspasos WHERE codtraspaso = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1,$codtraspaso);
	$stmt->bindParam(2,$codsucursal);
	$codtraspaso = decrypt($_GET["codtraspaso"]);
	$codsucursal = decrypt($_GET["codsucursal"]);
	$stmt->execute();
	########################## ELIMINO DETALLES TRASPASOS ##########################

		echo "1";
		exit;

	} else {

		echo "2";
		exit;
	}
}
########################## FUNCION ELIMINAR TRASPASOS ###########################

####################### FUNCION BUSQUEDA TRASPASOS POR FECHAS #######################
public function BuscarTraspasosxFechas() 
{
	$this->p = [];
	$codSucursal      = isset($_GET["codsucursal"]) ? limpiar(decrypt($_GET['codsucursal'])) : '';
	$fechaDesde       = isset($_GET['desde']) ? limpiar(date("Y-m-d", strtotime($_GET['desde']))) : '';
    $fechaHasta       = isset($_GET['hasta']) ? limpiar(date("Y-m-d", strtotime($_GET['hasta']))) : '';
	$whereConditions  = [];
    $params           = [];

	$sqlBase = "SELECT
        tras.idtraspaso, tras.codtraspaso, tras.codfactura, tras.numero_tracking, tras.sucursal_envia, 
        tras.sucursal_recibe, tras.nombres_responsable, tras.subtotalivasi, tras.subtotalivano, tras.iva, 
        tras.totaliva, tras.descontado, tras.descuento, tras.totaldescuento, tras.totalpago, tras.totalpago2, 
        tras.fechatraspaso, tras.observaciones, tras.codigo, tras.estado_traspaso, tras.fecha_enviado, 
        tras.persona_recibe, tras.fecha_recibe, tras.observaciones_recibido, tras.agregar_stock,
		suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
		suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
		doc.documento, doc2.documento AS documento2, 
		tm.moneda, tm.siglas, tm.simbolo,
		tm2.moneda AS moneda2, tm2.siglas AS siglas2, tm2.simbolo AS simbolo2,
		usu.dni, usu.nombres,
		usu2.dni AS dni2, usu2.nombres AS nombres2,
		suc2.documsucursal AS documsucursal2, suc2.cuitsucursal AS cuitsucursal2, suc2.nomsucursal AS nomsucursal2,
		suc2.documencargado AS documencargado2, suc2.dniencargado AS dniencargado2, suc2.nomencargado AS nomencargado2,
		doc3.documento AS documento3, doc4.documento AS documento4,
		pag.articulos, pag.detalles_productos
    FROM 
        traspasos tras LEFT JOIN sucursales suc ON tras.sucursal_envia = suc.codsucursal
	LEFT JOIN 
	    documentos doc ON suc.documsucursal = doc.coddocumento
	LEFT JOIN 
	    documentos AS doc2 ON suc.documencargado = doc2.coddocumento
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
	LEFT JOIN 
	    tiposmoneda AS tm2 ON suc.codmoneda2 = tm2.codmoneda
	LEFT JOIN 
	    usuarios usu ON tras.codigo = usu.codigo 
	LEFT JOIN 
	    usuarios AS usu2 ON tras.persona_recibe = usu2.codigo
	LEFT JOIN 
	    sucursales AS suc2 ON tras.sucursal_recibe = suc2.codsucursal
	LEFT JOIN 
	    documentos AS doc3 ON suc2.documsucursal = doc3.coddocumento
	LEFT JOIN 
	    documentos AS doc4 ON suc2.documencargado = doc4.coddocumento
    LEFT JOIN (
        SELECT
            dtra.codtraspaso,
            SUM(dtra.cantidad) AS articulos,
            GROUP_CONCAT(
                CONCAT_WS(
                    ' | ',
                    dtra.cantidad,
                    dtra.producto,
                    dtra.descripcion,
                    IFNULL(mar.nommarca, ''),
                    IFNULL(mode.nommodelo, ''),
                    IFNULL(pres.nompresentacion, ''),
                    IFNULL(col.nomcolor, '')
                )
                ORDER BY dtra.producto
                SEPARATOR '<br>'
            ) AS detalles_productos
        FROM 
            detalletraspasos dtra
        LEFT JOIN 
            marcas mar ON dtra.codmarca = mar.codmarca
        LEFT JOIN 
            modelos mode ON dtra.codmodelo = mode.codmodelo
        LEFT JOIN 
            presentaciones pres ON dtra.codpresentacion = pres.codpresentacion
        LEFT JOIN 
            colores col ON dtra.codcolor = col.codcolor
        WHERE dtra.codsucursal = ?
        GROUP BY dtra.codtraspaso
    ) pag ON pag.codtraspaso = tras.codtraspaso";
    //Condicion de Sucursal
    if (!empty($codSucursal)) {
        $whereConditions[] = "tras.sucursal_envia = ?";
        $params[]          = $codSucursal;
    }
	//Condicion de Fechas
	if (!empty($fechaDesde) && !empty($fechaHasta)) {
	    $whereConditions[] = "DATE_FORMAT(tras.fechatraspaso,'%Y-%m-%d') BETWEEN ? AND ?";
	    $params[]          = $fechaDesde;
	    $params[]          = $fechaHasta;
	}
	$whereClause = "";
	if (!empty($whereConditions)) {
	    $whereClause = " WHERE " . implode(" AND ", $whereConditions);
	}
	$sql = $sqlBase . $whereClause . " ORDER BY tras.codtraspaso ASC";
	try {
	    $stmt = $this->dbh->prepare($sql);
        array_unshift($params, $codSucursal);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
	    if (empty($results)) {
	        echo "<div class='alert alert-danger'>";
	        echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	        echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS PARA TU BÚSQUEDA REALIZADA</center>";
	        echo "</div>";
	        exit();
	    } else {
	        return $results;
	    }
	} catch (PDOException $e) {
	    error_log("Error en BuscarTraspasosxFechas: " . $e->getMessage());
	    echo "<div class='alert alert-danger'>";
	    echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	    echo "<center><span class='fa fa-exclamation-triangle'></span> OCURRIÓ UN ERROR AL CONSULTAR LAS VENTAS.</center>";
	    echo "</div>";
	    return [];
	}
}
###################### FUNCION BUSQUEDA TRASPASOS POR FECHAS ###########################

####################### FUNCION BUSQUEDA DETALLES TRASPASOS POR FECHAS #######################
public function BuscarDetallesTraspasosxFechas() 
{
    $this->p = [];
	$codSucursal         = isset($_GET["codsucursal"]) ? limpiar(decrypt($_GET['codsucursal'])) : '';
	$fechaDesde          = isset($_GET['desde']) ? limpiar(date("Y-m-d", strtotime($_GET['desde']))) : '';
    $fechaHasta          = isset($_GET['hasta']) ? limpiar(date("Y-m-d", strtotime($_GET['hasta']))) : '';
	$whereConditions     = [];
    $params              = [];
    $sqlBase = "SELECT
        dtra.idproducto, dtra.codproducto, dtra.producto, dtra.descripcion, dtra.opcionvendido,
		dtra.imei, dtra.condicion, dtra.codmarca, dtra.codmodelo, dtra.codpresentacion, dtra.codcolor, 
		dtra.preciocompra, dtra.precioventa, dtra.ivaproducto, dtra.descproducto, dtra.tipodetalle,
	    suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
		suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
		doc.documento, doc2.documento AS documento2, tm.moneda, tm.siglas, tm.simbolo,
	    mar.nommarca, mode.nommodelo, pres.nompresentacion, col.nomcolor,
        SUM(dtra.cantidad) AS cantidad,
        prod.existencia AS existencia,
        com.existencia AS cantcombo
    FROM
        traspasos tras
    INNER JOIN
        detalletraspasos dtra ON tras.codtraspaso = dtra.codtraspaso
    LEFT JOIN 
	    sucursales suc ON tras.sucursal_envia = suc.codsucursal 
	LEFT JOIN 
	    documentos doc ON suc.documsucursal = doc.coddocumento
	LEFT JOIN 
	    documentos AS doc2 ON suc.documencargado = doc2.coddocumento
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
    LEFT JOIN 
        marcas mar ON dtra.codmarca = mar.codmarca 
    LEFT JOIN
        modelos mode ON dtra.codmodelo = mode.codmodelo  
	LEFT JOIN 
	    presentaciones pres ON dtra.codpresentacion = pres.codpresentacion
    LEFT JOIN 
        colores col ON dtra.codcolor = col.codcolor  
    LEFT JOIN
        productos prod ON dtra.tipodetalle = 1 AND prod.idproducto = dtra.idproducto
    LEFT JOIN
        combos com ON dtra.tipodetalle = 2 AND com.idcombo = dtra.idproducto ";
    //Condicion de Sucursal
    if (!empty($codSucursal)) {
        $whereConditions[] = "tras.sucursal_envia = ?";
        $params[]          = $codSucursal;
    }
    //Condicion de Fechas
    if (!empty($fechaDesde) && !empty($fechaHasta)) {
        $whereConditions[] = "DATE_FORMAT(tras.fechatraspaso,'%Y-%m-%d') BETWEEN ? AND ?";
        $params[] = $fechaDesde;
        $params[] = $fechaHasta;
    }
    $whereClause = "";
    if (!empty($whereConditions)) {
        $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $groupByClause = " GROUP BY ";
    $groupByClause .= "dtra.idproducto, dtra.codproducto, dtra.producto, dtra.descripcion, dtra.opcionvendido,
		dtra.imei, dtra.condicion, dtra.codmarca, dtra.codmodelo, dtra.codpresentacion, dtra.codcolor, 
		dtra.preciocompra, dtra.precioventa, dtra.ivaproducto, dtra.descproducto, dtra.tipodetalle,
	    suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
		suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
		doc.documento, documento2, tm.moneda, tm.siglas, tm.simbolo,
		mar.nommarca, mode.nommodelo, pres.nompresentacion, col.nomcolor,
	    existencia,
        cantcombo";
    $sql = $sqlBase . $whereClause . $groupByClause . " ORDER BY dtra.codproducto ASC";
    try {
        $stmt = $this->dbh->prepare($sql);// Preparar y ejecutar la consulta
        $stmt->execute($params); // Pasamos todos los parámetros juntos
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($results)) {
            echo "<div class='alert alert-danger'>";
            echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
            echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS PARA TU BÚSQUEDA REALIZADA</center>";
            echo "</div>";
            exit();
        } else {
            return $results;
        }
    } catch (PDOException $e) {
        error_log("Error en BuscarDetallesTraspasosxFechas: " . $e->getMessage());
        echo "<div class='alert alert-danger'>";
        echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
        echo "<center><span class='fa fa-exclamation-triangle'></span> OCURRIÓ UN ERROR AL CONSULTAR LOS DETALLES DE VENTAS.</center>";
        echo "</div>";
        exit();
    }
}
###################### FUNCION BUSQUEDA DETALLES TRASPASOS POR FECHAS ###########################

############################ FUNCION OBTENER ID ASOCIADOS DE PRODUCTOS ############################
private function obtenerIdTablaPorNombre($tabla, $campo_id, $campo_nombre, $nombre_a_buscar, $codsucursal) {
    $sql = "SELECT {$campo_id} FROM {$tabla} WHERE {$campo_nombre} = ? AND codsucursal = ?";
    $stmt = $this->dbh->prepare($sql);
    $stmt->execute([$nombre_a_buscar, $codsucursal]);
    $resultado = $stmt->fetchColumn();
    return $resultado ? $resultado : '0';
}
############################ FUNCION OBTENER ID ASOCIADOS DE PRODUCTOS ############################

############################ FUNCION PROCESAR TRASPASOS ############################
public function ProcesarTraspaso()
{
	$this->p = [];
	if(empty($_POST["codtraspaso"]) or empty($_POST["codsucursal"]) or empty($_POST["persona_recibe"]) or empty($_POST["estado_traspaso"]) or empty($_POST["agregar_stock"]))
	{
		echo "1";
		exit;
	}

	################### OBTENGO DATOS DE TRASPASO ######################
    $sql = "SELECT codfactura, sucursal_recibe FROM traspasos WHERE codtraspaso = ? AND sucursal_envia = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_POST['codtraspaso']),decrypt($_POST['codsucursal'])));
	$num = $stmt->rowCount();
	if($row = $stmt->fetch(PDO::FETCH_ASSOC))
	{
		$p[] = $row;
	}
	$codfacturaBD      = $row['codfactura'];
	$sucursal_recibeBD = $row['sucursal_recibe'];
    ################### OBTENGO DATOS DE TRASPASO ######################

	############################ PROCESO EL TRASPASO ############################
    $sql = "UPDATE traspasos set "
	." estado_traspaso = ?, "
	." persona_recibe = ?, "
	." fecha_recibe = ?, "
	." observaciones_recibido = ?, "
	." agregar_stock = ? "
	." WHERE "
	." codtraspaso = ? AND sucursal_envia = ?;
	";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $estado_traspaso);
	$stmt->bindParam(2, $persona_recibe);
	$stmt->bindParam(3, $fecha_recibe);
	$stmt->bindParam(4, $observaciones_recibido);
	$stmt->bindParam(5, $agregar_stock);
	$stmt->bindParam(6, $codtraspaso);
	$stmt->bindParam(7, $codsucursal);

	$estado_traspaso        = limpiar($_POST["estado_traspaso"]);
    $persona_recibe         = limpiar(decrypt($_POST['persona_recibe']));
	$fecha_recibe           = limpiar(date("Y-m-d H:i:s"));
	$observaciones_recibido = limpiar($_POST["observaciones_recibido"]);
	$agregar_stock          = limpiar($_POST["agregar_stock"]);
    $codtraspaso            = limpiar(decrypt($_POST['codtraspaso']));
    $codsucursal            = limpiar(decrypt($_POST['codsucursal']));
	$stmt->execute();
	############################ PROCESO EL TRASPASO ############################

	if($_POST["estado_traspaso"] == 4 && $_POST["agregar_stock"] == 1){

	##########################################################################################################
	#                                                                                                        #
	#                                   PROCESO DE PRODUCTOS ENTRANTES                                       #
	#                                                                                                        #
	##########################################################################################################
	$this->dbh->beginTransaction();

	$sql = "SELECT * FROM detalletraspasos 
	WHERE codtraspaso = '".limpiar(decrypt($_POST["codtraspaso"]))."'
	AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
    foreach ($this->dbh->query($sql) as $row){ 
	   
	$this->p[] = $row;

	    ############################ VERIFICO SI EXISTE EN SUCURSAL ############################
		$sql = "SELECT codproducto FROM productos WHERE codproducto = ? AND producto = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array(limpiar($row['codproducto']),limpiar($row['producto']),limpiar($sucursal_recibeBD)));
		$num = $stmt->rowCount();
		if($num == 0)
		{
			############################## VERIFICO EXISTENCIA EN SUCURSAL QUE ENVIA ##############################
			$sql2 = "SELECT * FROM productos 
			WHERE codproducto = '".limpiar($row['codproducto'])."' 
			AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
			foreach ($this->dbh->query($sql2) as $row2)
			{
				$this->p[] = $row2;
			}
			//$existenciaBD = $row['existencia'];
			############################## VERIFICO EXISTENCIA EN SUCURSAL QUE ENVIA ##############################

	        ############################## REGISTRO DATOS DE PRODUCTOS ##############################
			$query = "INSERT INTO productos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
			$stmt = $this->dbh->prepare($query);
			$stmt->bindParam(1, $codproducto);
			$stmt->bindParam(2, $producto);
			$stmt->bindParam(3, $descripcion);
			$stmt->bindParam(4, $opcionvendido);
			$stmt->bindParam(5, $imei);
			$stmt->bindParam(6, $condicion);
			$stmt->bindParam(7, $fabricante);
			$stmt->bindParam(8, $codfamilia);
			$stmt->bindParam(9, $codsubfamilia);
			$stmt->bindParam(10, $codmarca);
			$stmt->bindParam(11, $codmodelo);
			$stmt->bindParam(12, $codpresentacion);
			$stmt->bindParam(13, $codcolor);
			$stmt->bindParam(14, $codorigen);
			$stmt->bindParam(15, $year);
			$stmt->bindParam(16, $nroparte);
			$stmt->bindParam(17, $lote);
			$stmt->bindParam(18, $peso);
			$stmt->bindParam(19, $preciocompra);
			$stmt->bindParam(20, $precioxmayor);
			$stmt->bindParam(21, $precioxmenor);
			$stmt->bindParam(22, $precioxpublico);
			$stmt->bindParam(23, $existencia);
			$stmt->bindParam(24, $stockoptimo);
			$stmt->bindParam(25, $stockmedio);
			$stmt->bindParam(26, $stockminimo);
			$stmt->bindParam(27, $ivaproducto);
			$stmt->bindParam(28, $descproducto);
			$stmt->bindParam(29, $codigobarra);
			$stmt->bindParam(30, $fechaelaboracion);
			$stmt->bindParam(31, $fechaoptimo);
			$stmt->bindParam(32, $fechamedio);
			$stmt->bindParam(33, $fechaminimo);
			$stmt->bindParam(34, $codproveedor);
			$stmt->bindParam(35, $stockteorico);
			$stmt->bindParam(36, $motivoajuste);
			$stmt->bindParam(37, $recibe);

			$codproducto      = limpiar($row["codproducto"]);
			$producto         = limpiar($row["producto"]);
			$descripcion      = limpiar($row["descripcion"]);
			$opcionvendido    = limpiar($row["opcionvendido"]);
			$imei             = limpiar($row["imei"]);
			$condicion        = limpiar($row["condicion"]);
			$fabricante       = limpiar($row2["fabricante"]);
			$codfamilia       = limpiar($row2["codfamilia"]);
			$codsubfamilia    = limpiar($row2["codsubfamilia"]);
			$codmarca         = limpiar($row["codmarca"]);
			$codmodelo        = limpiar($row["codmodelo"]);
			$codpresentacion  = limpiar($row["codpresentacion"]);
			$codcolor         = limpiar($row["codcolor"]);
			$codorigen        = limpiar($row2["codorigen"]);
			$year             = limpiar($row2["year"]);
			$nroparte         = limpiar($row2["nroparte"]);
			$lote             = limpiar($row2["lote"]);
			$peso             = limpiar($row2["peso"]);
			$preciocompra     = limpiar($row["preciocompra"]);
			$precioxmayor     = limpiar($row2["precioxmayor"]);
			$precioxmenor     = limpiar($row2["precioxmenor"]);
			$precioxpublico   = limpiar($row["precioventa"]);
			$existencia       = limpiar($row["cantidad"]);
			$stockoptimo      = limpiar($row2["stockoptimo"]);
			$stockmedio       = limpiar($row2["stockmedio"]);
			$stockminimo      = limpiar($row2["stockminimo"]);
		    $ivaproducto      = limpiar($row['ivaproducto'] == "0.00" ? "NO" : "SI");
			$descproducto     = limpiar($row['descproducto']);
			$codigobarra      = limpiar($row2["codigobarra"]);
			$fechaelaboracion = limpiar($row2['fechaelaboracion']);
			$fechaoptimo      = limpiar($row2['fechaoptimo']);
			$fechamedio       = limpiar($row2['fechamedio']);
			$fechaminimo      = limpiar($row2['fechaminimo']);
			$codproveedor     = limpiar($row2["codproveedor"]);
			$stockteorico     = limpiar("0");
			$motivoajuste     = limpiar("NINGUNO");
			$recibe           = limpiar($sucursal_recibeBD);
			$stmt->execute();
			############################## REGISTRO DATOS DE PRODUCTOS ##############################

			############## REGISTRAMOS LOS PRODUCTOS ENTRANTES EN KARDEX ###############
	        $query = "INSERT INTO kardex values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
			$stmt = $this->dbh->prepare($query);
			$stmt->bindParam(1, $codtraspaso);
			$stmt->bindParam(2, $codresponsable);
			$stmt->bindParam(3, $codproducto);
			$stmt->bindParam(4, $movimiento);
			$stmt->bindParam(5, $entradas);
			$stmt->bindParam(6, $salidas);
			$stmt->bindParam(7, $devolucion);
			$stmt->bindParam(8, $stockactual);
			$stmt->bindParam(9, $ivaproducto);
			$stmt->bindParam(10, $descproducto);
			$stmt->bindParam(11, $precio);
			$stmt->bindParam(12, $documento);
			$stmt->bindParam(13, $fechakardex);
			$stmt->bindParam(14, $tipokardex);	
			$stmt->bindParam(15, $procedimiento);
			$stmt->bindParam(16, $recibe);
			$stmt->bindParam(17, $codigo);

			$codtraspaso    = limpiar(decrypt($_POST['codtraspaso']));
			$codresponsable = limpiar(decrypt($_POST["codsucursal"]));
			$codproducto    = limpiar($row['codproducto']);
			$movimiento     = limpiar("ENTRADAS");
		    $entradas       = $row['opcionvendido'] == "2" ? number_format($row['cantidad'], 3, '.', '') : number_format($row['cantidad'], 0, '.', '');
		    $salidas        = $row['opcionvendido'] == "2" ? "0.000" : "0";
		    $devolucion     = $row['opcionvendido'] == "2" ? "0.000" : "0";
		    $stockactual    = $row['opcionvendido'] == "2" ? number_format($row['cantidad'], 3, '.', '') : number_format($row['cantidad'], 0, '.', '');
			$precio         = limpiar($row["precioventa"]);
			$ivaproducto    = limpiar($row['ivaproducto']);
			$descproducto   = limpiar($row['descproducto']);
			$documento      = limpiar("TRASPASO ".$codfacturaBD);
			$fechakardex    = limpiar(date("Y-m-d"));	
		    $tipokardex     = limpiar($row['tipodetalle']);	
		    $procedimiento  = limpiar("1");	
			$recibe         = limpiar($sucursal_recibeBD);
	    	$codigo         = limpiar($_SESSION["codigo"]);
			$stmt->execute();
			############## REGISTRAMOS LOS PRODUCTOS ENTRANTES EN KARDEX ###############

		} else {

			############################## VERIFICO EXISTENCIA EN SUCURSAL QUE RECIBE ##############################
			$sql2 = "SELECT * FROM productos 
			WHERE codproducto = '".limpiar($row['codproducto'])."' 
			AND codsucursal = '".limpiar($sucursal_recibeBD)."'";
			foreach ($this->dbh->query($sql2) as $row2)
			{
				$this->p[] = $row2;
			}
			$existenciaBD = $row2['existencia'];
		    ############################## VERIFICO EXISTENCIA EN SUCURSAL QUE RECIBE ##############################

		    ############# ACTUALIZAMOS LA EXISTENCIA DE PRODUCTOS RECIBIDOS ###############
			$sql = "UPDATE productos SET"
				." existencia = ? "
				." WHERE "
				." codproducto = ? AND codsucursal = ?;
				 ";
			$stmt = $this->dbh->prepare($sql);
			$stmt->bindParam(1, $existencia);
			$stmt->bindParam(2, $codproducto);
			$stmt->bindParam(3, $sucursal_recibe);

			$existencia      = $row['opcionvendido'] == "2" ? number_format($existenciaBD+$row['cantidad'], 3, '.', '') : number_format($existenciaBD+$row['cantidad'], 0, '.', '');
			$codproducto     = limpiar($row['codproducto']);
			$sucursal_recibe = limpiar($sucursal_recibeBD);
			$stmt->execute();
			############# ACTUALIZAMOS LA EXISTENCIA DE PRODUCTOS RECIBIDOS ###############

			############## REGISTRAMOS LOS PRODUCTOS ENTRANTES EN KARDEX ###############
	        $query = "INSERT INTO kardex values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
			$stmt = $this->dbh->prepare($query);
			$stmt->bindParam(1, $codtraspaso);
			$stmt->bindParam(2, $codresponsable);
			$stmt->bindParam(3, $codproducto);
			$stmt->bindParam(4, $movimiento);
			$stmt->bindParam(5, $entradas);
			$stmt->bindParam(6, $salidas);
			$stmt->bindParam(7, $devolucion);
			$stmt->bindParam(8, $stockactual);
			$stmt->bindParam(9, $ivaproducto);
			$stmt->bindParam(10, $descproducto);
			$stmt->bindParam(11, $precio);
			$stmt->bindParam(12, $documento);
			$stmt->bindParam(13, $fechakardex);
			$stmt->bindParam(14, $tipokardex);	
			$stmt->bindParam(15, $procedimiento);
			$stmt->bindParam(16, $recibe);
			$stmt->bindParam(17, $codigo);

			$codtraspaso    = limpiar(decrypt($_POST['codtraspaso']));
			$codresponsable = limpiar(decrypt($_POST["codsucursal"]));
			$codproducto    = limpiar($row['codproducto']);
			$movimiento     = limpiar("ENTRADAS");
		    $entradas       = $row['opcionvendido'] == "2" ? number_format($row['cantidad'], 3, '.', '') : number_format($row['cantidad'], 0, '.', '');
		    $salidas        = $row['opcionvendido'] == "2" ? "0.000" : "0";
		    $devolucion     = $row['opcionvendido'] == "2" ? "0.000" : "0";
		    $stockactual    = $row['opcionvendido'] == "2" ? number_format($row['cantidad'], 3, '.', '') : number_format($row['cantidad'], 0, '.', '');
			$precio         = limpiar($row["precioventa"]);
			$ivaproducto    = limpiar($row['ivaproducto']);
			$descproducto   = limpiar($row['descproducto']);
			$documento      = limpiar("TRASPASO ".$codfacturaBD);
			$fechakardex    = limpiar(date("Y-m-d"));	
		    $tipokardex     = limpiar($row['tipodetalle']);	
		    $procedimiento  = limpiar("1");	
			$recibe         = limpiar($sucursal_recibeBD);
	    	$codigo         = limpiar($_SESSION["codigo"]);
			$stmt->execute();
			############## REGISTRAMOS LOS PRODUCTOS ENTRANTES EN KARDEX ###############
		}
    }//FIN SESSION DETALLES
    $this->dbh->commit();
    ##########################################################################################################
	#                                                                                                        #
	#                                   PROCESO DE PRODUCTOS ENTRANTES                                       #
	#                                                                                                        #
	##########################################################################################################

    }

    echo "<span class='fa fa-check-square-o'></span> EL TRASPASO HA SIDO PROCESADO EXITOSAMENTE";
	exit;
}
############################ FUNCION PROCESAR TRASPASOS ############################

############################ FUNCION BUSQUEDA DE TRACKING #################################
public function BusquedaTracking()
{
    $this->p         = [];
    $tipoAcceso      = isset($_SESSION["acceso"]) ? limpiar($_SESSION["acceso"]) : '';
    $codTracking     = isset($_GET["tracking"]) ? limpiar($_GET["tracking"]) : '';
    $whereConditions = [];
    $params          = [];
    // Lógica de filtro basada en el tipo de acceso y usando parámetros con nombre para mayor claridad
    $whereConditions[] = "tras.numero_tracking = :codTracking";
	$params[':codTracking'] = $codTracking;
	
    $whereClause = "";
    if (!empty($whereConditions)) {
        $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    // Consulta SQL optimizada y corregida
    $sqlBase = "SELECT
        tras.idtraspaso, tras.codtraspaso, tras.codfactura, tras.numero_tracking, tras.sucursal_envia, 
        tras.sucursal_recibe, tras.nombres_responsable, tras.subtotalivasi, tras.subtotalivano, tras.iva, 
        tras.totaliva, tras.descontado, tras.descuento, tras.totaldescuento, tras.totalpago, tras.totalpago2, 
        tras.fechatraspaso, tras.observaciones, tras.codigo, tras.estado_traspaso, tras.fecha_enviado, 
        tras.persona_recibe, tras.fecha_recibe, tras.observaciones_recibido, tras.agregar_stock,
		suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.tlfsucursal, suc.correosucursal, suc.id_ciudad, 
		suc.id_comuna, suc.direcsucursal, suc.nroactividadsucursal, suc.fechaautorsucursal, suc.llevacontabilidad,
        suc.documencargado, suc.dniencargado, suc.nomencargado, suc.tlfencargado, suc.fechaautorsucursal, 
        suc.llevacontabilidad, suc.codmoneda,suc.codmoneda2, suc.membrete,
		doc.documento, doc2.documento AS documento2, 
		ciud.ciudad, com.comuna,
		tm.moneda, tm.siglas, tm.simbolo,
		tm2.moneda AS moneda2, tm2.siglas AS siglas2, tm2.simbolo AS simbolo2,
		usu.dni, usu.nombres,
		usu2.dni AS dni2, usu2.nombres AS nombres2,
		suc2.documsucursal AS documsucursal2, suc2.cuitsucursal AS cuitsucursal2, suc2.nomsucursal AS nomsucursal2,
		suc2.id_ciudad AS id_ciudad2, suc2.id_comuna AS id_comuna2, suc2.direcsucursal AS direcsucursal2,
		suc2.correosucursal AS correosucursal2, suc2.tlfsucursal AS tlfsucursal2, suc2.documencargado AS documencargado2,
		suc2.dniencargado AS dniencargado2, suc2.nomencargado AS nomencargado2, suc2.tlfencargado AS tlfencargado2,
		doc3.documento AS documento3, doc4.documento AS documento4,
		ciud2.ciudad AS ciudad2, com2.comuna AS comuna2
    FROM 
        traspasos tras LEFT JOIN sucursales suc ON tras.sucursal_envia = suc.codsucursal
	LEFT JOIN 
	    documentos doc ON suc.documsucursal = doc.coddocumento
	LEFT JOIN 
	    documentos AS doc2 ON suc.documencargado = doc2.coddocumento
	LEFT JOIN 
        ciudades ciud ON suc.id_ciudad = ciud.id_ciudad 
    LEFT JOIN 
        comunas com ON suc.id_comuna = com.id_comuna 
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
	LEFT JOIN 
	    tiposmoneda AS tm2 ON suc.codmoneda2 = tm2.codmoneda
	LEFT JOIN 
	    usuarios usu ON tras.codigo = usu.codigo 
	LEFT JOIN 
	    usuarios AS usu2 ON tras.persona_recibe = usu2.codigo
	LEFT JOIN 
	    sucursales AS suc2 ON tras.sucursal_recibe = suc2.codsucursal
	LEFT JOIN 
	    documentos AS doc3 ON suc2.documsucursal = doc3.coddocumento
	LEFT JOIN 
	    documentos AS doc4 ON suc2.documencargado = doc4.coddocumento
	LEFT JOIN 
        ciudades ciud2 ON suc2.id_ciudad = ciud2.id_ciudad 
    LEFT JOIN 
        comunas com2 ON suc2.id_comuna = com2.id_comuna";
    $sql = $sqlBase . $whereClause;
    try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($results)) {
            echo "<div class='alert alert-warning'>";
			echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
			echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS PARA TU BÚSQUEDA REALIZADA</center>";
			echo "</div>";		
			exit;
        } else {
            return $results;
        }
    } catch (PDOException $e) {
        error_log("Error en BusquedaTracking: " . $e->getMessage());
        return [];
    }
}
############################ FUNCION BUSQUEDA DE TRACKING #################################

################################## CLASE TRASPASOS ###################################
























###################################### CLASE COMPRAS ###################################

############################# FUNCION REGISTRAR COMPRAS #############################
public function RegistrarCompras()
{
	$this->p = [];
	if(empty($_POST["codsucursal"]) or empty($_POST["codfactura"]) or empty($_POST["fechaemision"]) or empty($_POST["fecharecepcion"]) or empty($_POST["codproveedor"]))
	{
		echo "1";
		exit;
	}
	elseif(empty($_SESSION["CarritoCompra"]))
	{
		echo "2";
		exit;
	}

	if (limpiar($_POST["tipocompra"]) == "CREDITO") { 

	    $fechaactual = date("Y-m-d");
	    $fechavence = date("Y-m-d",strtotime($_POST['fechavencecredito']));
	
        if (strtotime($fechavence) < strtotime($fechaactual)) {
  
            echo "3";
	        exit;
        }
    }

    $sql = "SELECT codfactura FROM compras WHERE codfactura = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_POST['codfactura'],decrypt($_POST['codsucursal'])));
	$num = $stmt->rowCount();
	if($num == 0)
	{
		################ CREO CODIGO DE COMPRA ####################
		$sql = "SELECT codcompra FROM compras 
		ORDER BY idcompra DESC LIMIT 1";
		foreach ($this->dbh->query($sql) as $row){

			$compra = $row["codcompra"];
		}
		if(empty($compra))
		{
			$codcompra   = "01";

		} else {

			$num         = substr($compra, 0);
	        $dig         = $num + 1;
	        $codigofinal = str_pad($dig, 2, "0", STR_PAD_LEFT);
	        $codcompra   = $codigofinal;
		}
	    ################ CREO CODIGO DE COMPRA ###############

	    ################### REGISTRO LA COMPRA ####################
		$query = "INSERT INTO compras values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codcompra);
		$stmt->bindParam(2, $codfactura);
		$stmt->bindParam(3, $codproveedor);
		$stmt->bindParam(4, $subtotalivasi);
		$stmt->bindParam(5, $subtotalivano);
		$stmt->bindParam(6, $iva);
		$stmt->bindParam(7, $totaliva);
		$stmt->bindParam(8, $descontado);
		$stmt->bindParam(9, $descuento);
		$stmt->bindParam(10, $totaldescuento);
		$stmt->bindParam(11, $totalpago);
		$stmt->bindParam(12, $gastoenvio);
		$stmt->bindParam(13, $creditopagado);
		$stmt->bindParam(14, $tipocompra);
		$stmt->bindParam(15, $formacompra);
		$stmt->bindParam(16, $fechavencecredito);
		$stmt->bindParam(17, $fechapagado);
		$stmt->bindParam(18, $statuscompra);
		$stmt->bindParam(19, $fechaemision);
		$stmt->bindParam(20, $fecharecepcion);
		$stmt->bindParam(21, $observaciones);
		$stmt->bindParam(22, $codigo);
		$stmt->bindParam(23, $codsucursal);
	   
		$codfactura        = limpiar($_POST["codfactura"]);
		$codproveedor      = limpiar($_POST["codproveedor"]);
		$subtotalivasi     = limpiar($_POST["txtsubtotal"]);
		$subtotalivano     = limpiar($_POST["txtsubtotal2"]);
		$iva               = limpiar($_POST["iva"]);
		$totaliva          = limpiar($_POST["txtIva"]);
		$descontado        = limpiar($_POST["txtdescontado"]);
		$descuento         = limpiar($_POST["descuento"]);
		$totaldescuento    = limpiar($_POST["txtDescuento"]);
		$totalpago         = limpiar($_POST["txtTotal"]);
		$gastoenvio        = limpiar($_POST["gastoenvio"]);
		$creditopagado     = limpiar("0.00");
		$tipocompra        = limpiar($_POST["tipocompra"]);
		$tipocompra        = limpiar($_POST["tipocompra"]);
		$formacompra       = limpiar($_POST["tipocompra"]=="CONTADO" ? $_POST["formacompra"] : "CREDITO");
		$fechavencecredito = limpiar($_POST["tipocompra"]=="CREDITO" ? date("Y-m-d",strtotime($_POST['fechavencecredito'])) : "0000-00-00");
	    $fechapagado       = limpiar("0000-00-00");
		$statuscompra      = limpiar($_POST["tipocompra"]=="CONTADO" ? "PAGADA" : "PENDIENTE");
	    $fechaemision      = limpiar(date("Y-m-d",strtotime($_POST['fechaemision'])));
	    $fecharecepcion    = limpiar(date("Y-m-d",strtotime($_POST['fecharecepcion'])));
	    $observaciones     = limpiar($_POST["observaciones"]);
		$codigo            = limpiar($_SESSION["codigo"]);
		$codsucursal       = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();
		################### REGISTRO LA COMPRA ####################
	
	$this->dbh->beginTransaction();
	$detalle = $_SESSION["CarritoCompra"];
	for($i=0;$i<count($detalle);$i++){

	    ############### VERIFICO LA EXISTENCIA DEL PRODUCTO EN ALMACEN ################
		$sql = "SELECT existencia 
		FROM productos 
		WHERE codproducto = '".limpiar($detalle[$i]['txtCodigo'])."' 
		AND codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."'";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		$existenciabd = $row['existencia'];
		############### VERIFICO LA EXISTENCIA DEL PRODUCTO EN ALMACEN ################

		################### REGISTRO DETALLES DE COMPRA ####################
		$query = "INSERT INTO detallecompras values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codcompra);
	    $stmt->bindParam(2, $idproducto);
	    $stmt->bindParam(3, $codproducto);
	    $stmt->bindParam(4, $producto);
	    $stmt->bindParam(5, $descripcion);
        $stmt->bindParam(6, $opcionvendido);
	    $stmt->bindParam(7, $imei);
	    $stmt->bindParam(8, $condicion);
	    $stmt->bindParam(9, $codmarca);
	    $stmt->bindParam(10, $codmodelo);
	    $stmt->bindParam(11, $codpresentacion);
	    $stmt->bindParam(12, $codcolor);
		$stmt->bindParam(13, $preciocompra);
		$stmt->bindParam(14, $precioxmayor);
		$stmt->bindParam(15, $precioxmenor);
		$stmt->bindParam(16, $precioxpublico);
		$stmt->bindParam(17, $cantcompra);
		$stmt->bindParam(18, $ivaproducto);
		$stmt->bindParam(19, $descproducto);
		$stmt->bindParam(20, $descfactura);
		$stmt->bindParam(21, $valortotal);
		$stmt->bindParam(22, $totaldescuentoc);
		$stmt->bindParam(23, $subtotalimpuestos);
		$stmt->bindParam(24, $valorneto);
		$stmt->bindParam(25, $lote);
		$stmt->bindParam(26, $fechaelaboracion);
		$stmt->bindParam(27, $fechaoptimo);
		$stmt->bindParam(28, $fechamedio);
		$stmt->bindParam(29, $fechaminimo);
		$stmt->bindParam(30, $stockoptimo);
		$stmt->bindParam(31, $stockmedio);
		$stmt->bindParam(32, $stockminimo);
		$stmt->bindParam(33, $codsucursal);
			
		$idproducto      = limpiar($detalle[$i]['id']);
		$codproducto     = limpiar($detalle[$i]['txtCodigo']);
		$producto        = limpiar($detalle[$i]['producto']);
		$descripcion     = limpiar($detalle[$i]['descripcion'] == "0" ? "" : $detalle[$i]['descripcion']);
		$opcionvendido   = limpiar($detalle[$i]['opcionvendido']);
	    $imei            = limpiar($detalle[$i]['imei'] == "0" ? "" : $detalle[$i]['imei']);
	    $condicion       = limpiar($detalle[$i]['condicion'] == "0" ? "" : $detalle[$i]['condicion']);
		$codmarca        = limpiar($detalle[$i]['codmarca']);
		$codmodelo       = limpiar($detalle[$i]['codmodelo']);
		$codpresentacion = limpiar($detalle[$i]['codpresentacion']);
		$codcolor        = limpiar($detalle[$i]['codcolor']);
		$preciocompra    = limpiar($detalle[$i]['precio']);
		$precioxmayor    = limpiar($detalle[$i]['precio2']);
		$precioxmenor    = limpiar($detalle[$i]['precio3']);
		$precioxpublico  = limpiar($detalle[$i]['precio4']);
		$cantcompra      = $detalle[$i]['opcionvendido'] == "2" ? number_format($detalle[$i]['cantidad'], 3, '.', '') : number_format($detalle[$i]['cantidad'], 0, '.', '');
		$precioconiva    = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['precio']);
		$ivaproducto     = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
		$descproducto    = limpiar($detalle[$i]['descproducto']);
		$descfactura     = limpiar($detalle[$i]['descproductofact']);
		$descuento       = $detalle[$i]["descproductofact"]/100;
		$valortotal      = number_format($detalle[$i]['precio']*$detalle[$i]['cantidad'], 2, '.', '');
		$totaldescuentoc = number_format($valortotal*$descuento, 2, '.', '');

		//CALCULO SUBTOTAL IMPUESTOS
		$ValorImpuesto        = 1 + ($_POST["iva"]/100);
		$RestoDescuento       = $precioconiva * $detalle[$i]['descproductofact'] / 100;
		$PrecioIvaDescuento   = $precioconiva - $RestoDescuento;
		$Discriminado         = $PrecioIvaDescuento/$ValorImpuesto;
	    $SubtotalDiscriminado = $PrecioIvaDescuento - $Discriminado;
	    $BaseDiscriminado     = $SubtotalDiscriminado * $detalle[$i]['cantidad'];
	    $subtotalimpuestos    = number_format($BaseDiscriminado, 2, '.', '');

	    $valorneto        = number_format($valortotal-$totaldescuentoc, 2, '.', '');
		$lote             = limpiar($detalle[$i]['lote']);
		$fechaelaboracion = limpiar($detalle[$i]['fechaelaboracion']=="" ? "0000-00-00" : date("Y-m-d",strtotime($detalle[$i]['fechaelaboracion'])));
		$fechaoptimo      = limpiar($detalle[$i]['fechaexpiracion']=="" ? "0000-00-00" : date("Y-m-d",strtotime($detalle[$i]['fechaexpiracion'])));
		$fechamedio       = limpiar($detalle[$i]['fechaexpiracion2']=="" ? "0000-00-00" : date("Y-m-d",strtotime($detalle[$i]['fechaexpiracion2'])));
		$fechaminimo      = limpiar($detalle[$i]['fechaexpiracion3']=="" ? "0000-00-00" : date("Y-m-d",strtotime($detalle[$i]['fechaexpiracion3'])));
		$stockoptimo      = limpiar($detalle[$i]['optimo']);
		$stockmedio       = limpiar($detalle[$i]['medio']);
		$stockminimo      = limpiar($detalle[$i]['minimo']);
		$codsucursal      = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();
		################### REGISTRO DETALLES DE COMPRA ####################

		##################### ACTUALIZAMOS LA EXISTENCIA DE PRODUCTOS #####################
		$sql = "UPDATE productos set "
		    ." preciocompra = ?, "
			." precioxmayor = ?, "
			." precioxmenor = ?, "
			." precioxpublico = ?, "
			." existencia = ?, "
			." ivaproducto = ?, "
			." descproducto = ?, "
			." fechaelaboracion = ?, "
			." fechaoptimo = ?, "
			." fechamedio = ?, "
			." fechaminimo = ?, "
			." stockoptimo = ?, "
			." stockmedio = ?, "
			." stockminimo = ?, "
			." codproveedor = ?, "
			." lote = ? "
			." WHERE "
			." codproducto = ? AND codsucursal = ?;
			";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $preciocompra);
		$stmt->bindParam(2, $precioxmayor);
		$stmt->bindParam(3, $precioxmenor);
		$stmt->bindParam(4, $precioxpublico);
		$stmt->bindParam(5, $existencia);
		$stmt->bindParam(6, $ivaproducto);
		$stmt->bindParam(7, $descproducto);
		$stmt->bindParam(8, $fechaelaboracion);
		$stmt->bindParam(9, $fechaoptimo);
		$stmt->bindParam(10, $fechamedio);
		$stmt->bindParam(11, $fechaminimo);
		$stmt->bindParam(12, $stockoptimo);
		$stmt->bindParam(13, $stockmedio);
		$stmt->bindParam(14, $stockminimo);
		$stmt->bindParam(15, $codproveedor);
		$stmt->bindParam(16, $lote);
		$stmt->bindParam(17, $codproducto);
		$stmt->bindParam(18, $codsucursal);
		
		$preciocompra     = limpiar($detalle[$i]['precio']);
		$precioxmayor     = limpiar($detalle[$i]['precio3']);
		$precioxmenor     = limpiar($detalle[$i]['precio2']);
		$precioxpublico   = limpiar($detalle[$i]['precio4']);
		$existencia       = $detalle[$i]['opcionvendido'] == "2" ? number_format($detalle[$i]['cantidad']+$existenciabd, 3, '.', '') : number_format($detalle[$i]['cantidad']+$existenciabd, 0, '.', '');
		$ivaproducto      = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "NO" : "SI");
		$descproducto     = limpiar($detalle[$i]['descproducto']);
		$fechaelaboracion = limpiar($detalle[$i]['fechaelaboracion']=="" ? "0000-00-00" : date("Y-m-d",strtotime($detalle[$i]['fechaelaboracion'])));
		$fechaoptimo      = limpiar($detalle[$i]['fechaexpiracion']=="" ? "0000-00-00" : date("Y-m-d",strtotime($detalle[$i]['fechaexpiracion'])));
		$fechamedio       = limpiar($detalle[$i]['fechaexpiracion2']=="" ? "0000-00-00" : date("Y-m-d",strtotime($detalle[$i]['fechaexpiracion2'])));
		$fechaminimo      = limpiar($detalle[$i]['fechaexpiracion3']=="" ? "0000-00-00" : date("Y-m-d",strtotime($detalle[$i]['fechaexpiracion3'])));
		$stockoptimo      = limpiar($detalle[$i]['optimo']);
		$stockmedio       = limpiar($detalle[$i]['medio']);
		$stockminimo      = limpiar($detalle[$i]['minimo']);
		$codproveedor     = limpiar($_POST['codproveedor']);
		$lote             = limpiar($detalle[$i]['lote']);
		$codproducto      = limpiar($detalle[$i]['txtCodigo']);
		$codsucursal      = limpiar(decrypt($_POST['codsucursal']));
		$stmt->execute();
		##################### ACTUALIZAMOS LA EXISTENCIA DE PRODUCTOS #####################

		##################### REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX #####################
	    $query = "INSERT INTO kardex values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codcompra);
		$stmt->bindParam(2, $codproveedor);
		$stmt->bindParam(3, $codproducto);
		$stmt->bindParam(4, $movimiento);
		$stmt->bindParam(5, $entradas);
		$stmt->bindParam(6, $salidas);
		$stmt->bindParam(7, $devolucion);
		$stmt->bindParam(8, $stockactual);
		$stmt->bindParam(9, $ivaproducto);
		$stmt->bindParam(10, $descproducto);
		$stmt->bindParam(11, $precio);
		$stmt->bindParam(12, $documento);
		$stmt->bindParam(13, $fechakardex);	
		$stmt->bindParam(14, $tipokardex);	
		$stmt->bindParam(15, $procedimiento);		
		$stmt->bindParam(16, $codsucursal);
		$stmt->bindParam(17, $codigo);

		$codproveedor  = limpiar($_POST["codproveedor"]);
		$codproducto   = limpiar($detalle[$i]['txtCodigo']);
		$movimiento    = limpiar("ENTRADAS");
		$entradas      = $detalle[$i]['opcionvendido'] == "2" ? number_format($detalle[$i]['cantidad'], 3, '.', '') : number_format($detalle[$i]['cantidad'], 0, '.', '');
		$salidas       = $detalle[$i]['opcionvendido'] == "2" ? "0.000" : "0";
		$devolucion    = $detalle[$i]['opcionvendido'] == "2" ? "0.000" : "0";
		$stockactual   = $detalle[$i]['opcionvendido'] == "2" ? number_format($detalle[$i]['cantidad']+$existenciabd, 3, '.', '') : number_format($detalle[$i]['cantidad']+$existenciabd, 0, '.', '');
		$precio        = limpiar($detalle[$i]["precio"]);
		$ivaproducto   = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
		$descproducto  = limpiar($detalle[$i]['descproducto']);
		$documento     = limpiar("COMPRA: ".$_POST['codfactura']);
		$fechakardex   = limpiar(date("Y-m-d"));
		$tipokardex    = limpiar("1");
		$procedimiento = limpiar("1");
		$codsucursal   = limpiar(decrypt($_POST["codsucursal"]));
    	$codigo        = limpiar($_SESSION["codigo"]);
		$stmt->execute();
		##################### REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX #####################
    }
	####################### DESTRUYO LA VARIABLE DE SESSION #####################
    unset($_SESSION["CarritoCompra"]);
    $this->dbh->commit();
		
        echo "<span class='fa fa-check-square-o'></span> LA COMPRA DE PRODUCTOS HA SIDO REGISTRADA EXITOSAMENTE <a href='reportepdf?codcompra=".encrypt($codcompra)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt("FACTURACOMPRA")."' class='on-default' data-placement='left' data-toggle='tooltip' data-original-title='Imprimir Documento' target='_black' rel='noopener noreferrer'><font color='black'><strong>IMPRIMIR REPORTE</strong></font color></a></div>";

        echo "<script>VentanaCentrada('reportepdf?codcompra=".encrypt($codcompra)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt("FACTURACOMPRA")."', '', '', '1024', '568', 'true');</script>";
	    exit;
	}
	else
	{
		echo "4";
		exit;
	}
}
############################ FUNCION REGISTRAR COMPRAS ##########################

########################## FUNCION BUSQUEDA DE COMPRAS ###############################
public function BusquedaCompras() 
{
	$this->p = [];
	$tipoAcceso      = isset($_SESSION["acceso"]) ? limpiar($_SESSION["acceso"]) : '';
	$codSucursal     = isset($_SESSION["codsucursal"]) ? limpiar($_SESSION["codsucursal"]) : '';	
    $codigoUsuario   = isset($_SESSION["codigo"]) ? limpiar($_SESSION["codigo"]) : '';
    $tipoBusqueda    = isset($_GET['tipobusqueda']) ? limpiar($_GET['tipobusqueda']) : '';
    $searchCriterio  = isset($_GET['search_criterio']) ? limpiar($_GET['search_criterio']) : '';
    $fechaDesde      = isset($_GET['desde']) ? limpiar(date("Y-m-d", strtotime($_GET['desde']))) : '';
    $fechaHasta      = isset($_GET['hasta']) ? limpiar(date("Y-m-d", strtotime($_GET['hasta']))) : '';
    $whereConditions = [];
    $params          = [];

    // Lógica de filtro basada en el tipo de acceso
    $whereConditions[] = "c.codsucursal = ?";
    $whereConditions[] = "c.tipocompra = 'CONTADO'";
    $params[]          = $codSucursal;

    // Lógica de filtro basada en el tipo de búsqueda (tipobusqueda)
    if ($tipoBusqueda == 2) {//Busqueda por Criterio
        $whereConditions[] = "CONCAT(c.codcompra, '',c.codfactura, '',c.totalpago, '',pro.cuitproveedor, '',pro.nomproveedor, ' ',suc.cuitsucursal, ' ',suc.nomsucursal, ' ',suc.dniencargado, ' ',suc.nomencargado) LIKE ?";
        $params[]          = '%' . $searchCriterio . '%';
    } elseif ($tipoBusqueda == 3) {// Busqueda por Fechas
        $whereConditions[] = "DATE_FORMAT(c.fechaemision,'%Y-%m-%d') BETWEEN ? AND ?";
        $params[]          = $fechaDesde;
        $params[]          = $fechaHasta;
    }
    $whereClause = "";
    if (!empty($whereConditions)) {
      $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $sqlBase = "SELECT
        c.codcompra, c.codfactura, c.codproveedor, c.subtotalivasi, c.subtotalivano, 
        c.iva, c.totaliva, c.descontado, c.descuento, c.totaldescuento, c.totalpago, c.gastoenvio,
        c.creditopagado, c.statuscompra, c.fechavencecredito, c.fechapagado, c.fecharecepcion, c.fechaemision, 
        c.observaciones, c.codsucursal,
		suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
		suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
		tm.moneda, tm.siglas, tm.simbolo,
		usu.dni, usu.nombres,
		pro.documproveedor, pro.documproveedor, pro.cuitproveedor, pro.nomproveedor,
		doc.documento, doc2.documento AS documento2, doc3.documento AS documento3,
		pag.articulos, pag.detalles_productos
    FROM 
        compras c LEFT JOIN sucursales suc ON c.codsucursal = suc.codsucursal 
	LEFT JOIN 
	    documentos doc ON suc.documsucursal = doc.coddocumento
	LEFT JOIN 
	    documentos AS doc2 ON suc.documencargado = doc2.coddocumento
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
	LEFT JOIN 
	    proveedores pro ON c.codproveedor = pro.codproveedor
	LEFT JOIN 
	    documentos AS doc3 ON pro.documproveedor = doc3.coddocumento
	LEFT JOIN 
	    usuarios usu ON c.codigo = usu.codigo

    LEFT JOIN
        (SELECT
            dc.codcompra,
            SUM(dc.cantcompra) AS articulos,
            GROUP_CONCAT(
            CONCAT_WS(
               ' | ',
               dc.cantcompra,
               dc.producto,
               dc.descripcion,
               IFNULL(mar.nommarca, ''),
               IFNULL(mode.nommodelo, ''),
               IFNULL(pres.nompresentacion, ''),
               IFNULL(col.nomcolor, '')
            )
                ORDER BY dc.producto
                SEPARATOR '<br>'
            ) AS detalles_productos
            FROM
                detallecompras dc
            LEFT JOIN 
                marcas mar ON dc.codmarca = mar.codmarca
		    LEFT JOIN 
		        modelos mode ON dc.codmodelo = mode.codmodelo 
		    LEFT JOIN 
		        presentaciones pres ON dc.codpresentacion = pres.codpresentacion
			LEFT JOIN 
			    colores col ON dc.codcolor = col.codcolor
			WHERE dc.codsucursal = $codSucursal
	    GROUP BY
	        dc.codcompra
	    ) pag ON pag.codcompra = c.codcompra";
        $sql = $sqlBase . $whereClause . " ORDER BY c.fechaemision ASC";
    if ($tipoBusqueda == 2 || $tipoBusqueda == 3) {
        $sql .= " LIMIT 0,3000";
    }
    try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($results)) {
            return [];
        } else {
            return $results;
        }
    } catch (PDOException $e) {
        error_log("Error en BusquedaCompras: " . $e->getMessage());
        echo "<div class='alert alert-danger'>";
        echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
        echo "<center><span class='fa fa-exclamation-triangle'></span> OCURRIÓ UN ERROR AL PROCESAR LA BÚSQUEDA. POR FAVOR, INTENTALO MAS TARDE.</center>";
        echo "</div>";
        return [];
    }
}
########################## FUNCION BUSQUEDA DE COMPRAS ###############################

######################### FUNCION LISTAR COMPRAS ################################
public function ListarCompras()
{
	$this->p = [];
	$tipoAcceso      = isset($_SESSION["acceso"]) ? limpiar($_SESSION["acceso"]) : '';
	$codSucursal     = ($tipoAcceso === 'administradorG') ? limpiar(decrypt($_GET["codsucursal"])) : limpiar($_SESSION["codsucursal"]);	
    $codigoUsuario   = isset($_SESSION["codigo"]) ? limpiar($_SESSION["codigo"]) : '';
    $whereConditions = [];
    $params          = [];

    $whereConditions[] = "c.codsucursal = ?";
    $whereConditions[] = "c.tipocompra = 'CONTADO'";
    $params[]          = $codSucursal;
   
    $whereClause = "";
    if (!empty($whereConditions)) {
      $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $sqlBase = "SELECT
        c.codcompra, c.codfactura, c.codproveedor, c.subtotalivasi, c.subtotalivano, 
        c.iva, c.totaliva, c.descontado, c.descuento, c.totaldescuento, c.totalpago, c.gastoenvio,
        c.creditopagado, c.statuscompra, c.fechavencecredito, c.fechapagado, c.fecharecepcion, c.fechaemision, 
        c.observaciones, c.codsucursal,
		suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
		suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
		tm.moneda, tm.siglas, tm.simbolo,
		usu.dni, usu.nombres,
		pro.documproveedor, pro.documproveedor, pro.cuitproveedor, pro.nomproveedor,
		doc.documento, doc2.documento AS documento2, doc3.documento AS documento3,
		pag.articulos, pag.detalles_productos
    FROM 
        compras c LEFT JOIN sucursales suc ON c.codsucursal = suc.codsucursal  
	LEFT JOIN 
	    documentos doc ON suc.documsucursal = doc.coddocumento
	LEFT JOIN 
	    documentos AS doc2 ON suc.documencargado = doc2.coddocumento
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
	LEFT JOIN 
	    proveedores pro ON c.codproveedor = pro.codproveedor
	LEFT JOIN 
	    documentos AS doc3 ON pro.documproveedor = doc3.coddocumento
	LEFT JOIN 
	    usuarios usu ON c.codigo = usu.codigo

    LEFT JOIN
        (SELECT
            dc.codcompra,
            SUM(dc.cantcompra) AS articulos,
            GROUP_CONCAT(
            CONCAT_WS(
               ' | ',
               dc.cantcompra,
               dc.producto,
               dc.descripcion,
               IFNULL(mar.nommarca, ''),
               IFNULL(mode.nommodelo, ''),
               IFNULL(pres.nompresentacion, ''),
               IFNULL(col.nomcolor, '')
            )
                ORDER BY dc.producto
                SEPARATOR '<br>'
            ) AS detalles_productos
            FROM
                detallecompras dc
            LEFT JOIN 
                marcas mar ON dc.codmarca = mar.codmarca
		    LEFT JOIN 
		        modelos mode ON dc.codmodelo = mode.codmodelo 
		    LEFT JOIN 
		        presentaciones pres ON dc.codpresentacion = pres.codpresentacion
			LEFT JOIN 
			    colores col ON dc.codcolor = col.codcolor
			WHERE dc.codsucursal = $codSucursal
	    GROUP BY
	        dc.codcompra
	    ) pag ON pag.codcompra = c.codcompra";
	    $sql = $sqlBase . $whereClause . " ORDER BY c.fechaemision ASC";
    try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($results)) {
            return [];
        } else {
            return $results;
        }
    } catch (PDOException $e) {
        error_log("Error en ListarCompras: " . $e->getMessage());
        return [];
    }
}
################################## FUNCION LISTAR COMPRAS ############################

########################## FUNCION BUSQUEDA DE CUENTAS POR PAGAR ###############################
public function BusquedaCuentasxPagar() 
{
	$this->p = [];
	$tipoAcceso      = isset($_SESSION["acceso"]) ? limpiar($_SESSION["acceso"]) : '';
	$codSucursal     = isset($_SESSION["codsucursal"]) ? limpiar($_SESSION["codsucursal"]) : '';	
    $codigoUsuario   = isset($_SESSION["codigo"]) ? limpiar($_SESSION["codigo"]) : '';
    $tipoBusqueda    = isset($_GET['tipobusqueda']) ? limpiar($_GET['tipobusqueda']) : '';
    $searchCriterio  = isset($_GET['search_criterio']) ? limpiar($_GET['search_criterio']) : '';
    $fechaDesde      = isset($_GET['desde']) ? limpiar(date("Y-m-d", strtotime($_GET['desde']))) : '';
    $fechaHasta      = isset($_GET['hasta']) ? limpiar(date("Y-m-d", strtotime($_GET['hasta']))) : '';
    $whereConditions = [];
    $params          = [];

    $whereConditions[] = "c.codsucursal = ?";
    $whereConditions[] = "c.tipocompra = 'CREDITO'";
    $params[]          = $codSucursal;

    // Lógica de filtro basada en el tipo de búsqueda (tipobusqueda)
    if ($tipoBusqueda == 2) {//Busqueda por Criterio
        $whereConditions[] = "CONCAT(c.codcompra, '',c.codfactura, '',c.totalpago, '',pro.cuitproveedor, '',pro.nomproveedor, ' ',suc.cuitsucursal, ' ',suc.nomsucursal, ' ',suc.dniencargado, ' ',suc.nomencargado) LIKE ?";
        $params[]          = '%' . $searchCriterio . '%';
    } elseif ($tipoBusqueda == 3) {// Busqueda por Fechas
        $whereConditions[] = "DATE_FORMAT(c.fechaemision,'%Y-%m-%d') BETWEEN ? AND ?";
        $params[]          = $fechaDesde;
        $params[]          = $fechaHasta;
    }
    $whereClause = "";
    if (!empty($whereConditions)) {
      $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $sqlBase = "SELECT
        c.codcompra, c.codfactura, c.codproveedor, c.subtotalivasi, c.subtotalivano, 
        c.iva, c.totaliva, c.descontado, c.descuento, c.totaldescuento, c.totalpago, c.gastoenvio,
        c.creditopagado, c.statuscompra, c.fechavencecredito, c.fechapagado, c.fecharecepcion, c.fechaemision, 
        c.observaciones, c.codsucursal,
		suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
		suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
		tm.moneda, tm.siglas, tm.simbolo,
		usu.dni, usu.nombres,
		pro.documproveedor, pro.documproveedor, pro.cuitproveedor, pro.nomproveedor,
		doc.documento, doc2.documento AS documento2, doc3.documento AS documento3,
		pag.articulos, pag.detalles_productos
    FROM 
        compras c LEFT JOIN sucursales suc ON c.codsucursal = suc.codsucursal  
	LEFT JOIN 
	    documentos doc ON suc.documsucursal = doc.coddocumento
	LEFT JOIN 
	    documentos AS doc2 ON suc.documencargado = doc2.coddocumento
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
	LEFT JOIN 
	    proveedores pro ON c.codproveedor = pro.codproveedor
	LEFT JOIN 
	    documentos AS doc3 ON pro.documproveedor = doc3.coddocumento
	LEFT JOIN 
	    usuarios usu ON c.codigo = usu.codigo

    LEFT JOIN
        (SELECT
            dc.codcompra,
            SUM(dc.cantcompra) AS articulos,
            GROUP_CONCAT(
            CONCAT_WS(
               ' | ',
               dc.cantcompra,
               dc.producto,
               dc.descripcion,
               IFNULL(mar.nommarca, ''),
               IFNULL(mode.nommodelo, ''),
               IFNULL(pres.nompresentacion, ''),
               IFNULL(col.nomcolor, '')
            )
                ORDER BY dc.producto
                SEPARATOR '<br>'
            ) AS detalles_productos
            FROM
                detallecompras dc
            LEFT JOIN 
                marcas mar ON dc.codmarca = mar.codmarca
		    LEFT JOIN 
		        modelos mode ON dc.codmodelo = mode.codmodelo 
		    LEFT JOIN 
		        presentaciones pres ON dc.codpresentacion = pres.codpresentacion
			LEFT JOIN 
			    colores col ON dc.codcolor = col.codcolor
			WHERE dc.codsucursal = $codSucursal
	    GROUP BY
	        dc.codcompra
	    ) pag ON pag.codcompra = c.codcompra";
	    $sql = $sqlBase . $whereClause . " ORDER BY c.fechaemision ASC";
    if ($tipoBusqueda == 2 || $tipoBusqueda == 3) {
        $sql .= " LIMIT 0,3000";
    }
    try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($results)) {
            return [];
        } else {
            return $results;
        }
    } catch (PDOException $e) {
        error_log("Error en BusquedaCuentasxPagar: " . $e->getMessage());
        echo "<div class='alert alert-danger'>";
        echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
        echo "<center><span class='fa fa-exclamation-triangle'></span> OCURRIÓ UN ERROR AL PROCESAR LA BÚSQUEDA. POR FAVOR, INTENTALO MAS TARDE.</center>";
        echo "</div>";
        return [];
    }
}
########################## FUNCION BUSQUEDA DE CUENTAS POR PAGAR ###############################

########################### FUNCION LISTAR CUENTAS POR PAGAR #######################
public function ListarCuentasxPagar()
{
	$this->p = [];
	$tipoAcceso      = isset($_SESSION["acceso"]) ? limpiar($_SESSION["acceso"]) : '';
	$codSucursal     = ($tipoAcceso === 'administradorG') ? limpiar(decrypt($_GET["codsucursal"])) : limpiar($_SESSION["codsucursal"]);	
    $codigoUsuario   = isset($_SESSION["codigo"]) ? limpiar($_SESSION["codigo"]) : '';
    $whereConditions = [];
    $params          = [];

    $whereConditions[] = "c.codsucursal = ?";
    $whereConditions[] = "c.tipocompra = 'CREDITO'";
    $params[]          = $codSucursal;
   
    $whereClause = "";
    if (!empty($whereConditions)) {
      $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $sqlBase = "SELECT
        c.codcompra, c.codfactura, c.codproveedor, c.subtotalivasi, c.subtotalivano, 
        c.iva, c.totaliva, c.descontado, c.descuento, c.totaldescuento, c.totalpago, c.gastoenvio,
        c.creditopagado, c.statuscompra, c.fechavencecredito, c.fechapagado, c.fecharecepcion, c.fechaemision, 
        c.observaciones, c.codsucursal,
		suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
		suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
		tm.moneda, tm.siglas, tm.simbolo,
		usu.dni, usu.nombres,
		pro.documproveedor, pro.documproveedor, pro.cuitproveedor, pro.nomproveedor,
		doc.documento, doc2.documento AS documento2, doc3.documento AS documento3,
		pag.articulos, pag.detalles_productos
    FROM 
        compras c LEFT JOIN sucursales suc ON c.codsucursal = suc.codsucursal 
	LEFT JOIN 
	    documentos doc ON suc.documsucursal = doc.coddocumento
	LEFT JOIN 
	    documentos AS doc2 ON suc.documencargado = doc2.coddocumento
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
	LEFT JOIN 
	    proveedores pro ON c.codproveedor = pro.codproveedor
	LEFT JOIN 
	    documentos AS doc3 ON pro.documproveedor = doc3.coddocumento
	LEFT JOIN 
	    usuarios usu ON c.codigo = usu.codigo

    LEFT JOIN
        (SELECT
            dc.codcompra,
            SUM(dc.cantcompra) AS articulos,
            GROUP_CONCAT(
            CONCAT_WS(
               ' | ',
               dc.cantcompra,
               dc.producto,
               dc.descripcion,
               IFNULL(mar.nommarca, ''),
               IFNULL(mode.nommodelo, ''),
               IFNULL(pres.nompresentacion, ''),
               IFNULL(col.nomcolor, '')
            )
                ORDER BY dc.producto
                SEPARATOR '<br>'
            ) AS detalles_productos
            FROM
                detallecompras dc
            LEFT JOIN 
                marcas mar ON dc.codmarca = mar.codmarca
		    LEFT JOIN 
		        modelos mode ON dc.codmodelo = mode.codmodelo 
		    LEFT JOIN 
		        presentaciones pres ON dc.codpresentacion = pres.codpresentacion
			LEFT JOIN 
			    colores col ON dc.codcolor = col.codcolor
			WHERE dc.codsucursal = $codSucursal
	    GROUP BY
	        dc.codcompra
	    ) pag ON pag.codcompra = c.codcompra";
	    $sql = $sqlBase . $whereClause . " ORDER BY c.fechaemision ASC";
    try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($results)) {
            return [];
        } else {
            return $results;
        }
    } catch (PDOException $e) {
        error_log("Error en ListarCuentasxPagar: " . $e->getMessage());
        return [];
    }
}
######################### FUNCION LISTAR CUENTAS POR PAGAR ############################

########################### FUNCION LISTAR CUENTAS POR PAGAR VENCIDAS #######################
public function ListarCuentasxPagarVencidas()
{
	$this->p = [];
	$tipoAcceso      = isset($_SESSION["acceso"]) ? limpiar($_SESSION["acceso"]) : '';
	$codSucursal     = ($tipoAcceso === 'administradorG') ? limpiar(decrypt($_GET["codsucursal"])) : limpiar($_SESSION["codsucursal"]);	
    $codigoUsuario   = isset($_SESSION["codigo"]) ? limpiar($_SESSION["codigo"]) : '';
    $fechaActual     = date("Y-m-d");
    $whereConditions = [];
    $params          = [];

    $whereConditions[] = "c.codsucursal = ?";
    $whereConditions[] = "c.tipocompra = 'CREDITO'";
    $whereConditions[] = "DATE_FORMAT(c.fechavencecredito, '%Y-%m-%d') <= ?";
    $whereConditions[] = "c.fechapagado = '0000-00-00'";
    $params[]          = $codSucursal;
    $params[]          = $fechaActual; // <-- Aquí se agrega la fecha actual
   
    $whereClause = "";
    if (!empty($whereConditions)) {
      $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $sqlBase = "SELECT
        c.codcompra, c.tipodocumento, c.codfactura, c.codproveedor, c.subtotal,
		c.subtotalexento, c.subtotaliva, c.iva, c.totaliva, c.descontado, c.descuento, 
		c.totaldescuento, c.totalpago, c.gastoenvio, c.creditopagado, c.statuscompra, 
		c.fechavencecredito, c.fechapagado, c.fecharecepcion, c.fechaemision, c.observaciones,
		c.codsucursal, c.notacredito,
		suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
		suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
		tm.moneda, tm.siglas, tm.simbolo,
		usu.dni, usu.nombres,
		pro.documproveedor, pro.documproveedor, pro.cuitproveedor, pro.nomproveedor,
		doc.documento, doc2.documento AS documento2, doc3.documento AS documento3,
		pag.articulos, pag.detalles_productos
    FROM 
        compras c LEFT JOIN sucursales suc ON c.codsucursal = suc.codsucursal 
	LEFT JOIN 
	    documentos doc ON suc.documsucursal = doc.coddocumento
	LEFT JOIN 
	    documentos AS doc2 ON suc.documencargado = doc2.coddocumento
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
	LEFT JOIN 
	    proveedores pro ON c.codproveedor = pro.codproveedor
	LEFT JOIN 
	    documentos AS doc3 ON pro.documproveedor = doc3.coddocumento
	LEFT JOIN 
	    usuarios usu ON c.codigo = usu.codigo

    LEFT JOIN
        (SELECT
            dc.codcompra,
            SUM(dc.cantcompra) AS articulos,
            GROUP_CONCAT(
            CONCAT_WS(
               ' | ',
               dc.cantcompra,
               dc.producto,
               dc.descripcion,
               IFNULL(mar.nommarca, ''),
               IFNULL(mode.nommodelo, ''),
               IFNULL(pres.nompresentacion, ''),
               IFNULL(col.nomcolor, '')
            )
                ORDER BY dc.producto
                SEPARATOR '<br>'
            ) AS detalles_productos
            FROM
                detallecompras dc
            LEFT JOIN 
                marcas mar ON dc.codmarca = mar.codmarca
		    LEFT JOIN 
		        modelos mode ON dc.codmodelo = mode.codmodelo 
		    LEFT JOIN 
		        presentaciones pres ON dc.codpresentacion = pres.codpresentacion
			LEFT JOIN 
			    colores col ON dc.codcolor = col.codcolor
			WHERE dc.codsucursal = $codSucursal
	    GROUP BY
	        dc.codcompra
	    ) pag ON pag.codcompra = c.codcompra";
	    $sql = $sqlBase . $whereClause . " ORDER BY c.fechaemision ASC";
    try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($results)) {
            return [];
        } else {
            return $results;
        }
    } catch (PDOException $e) {
        error_log("Error en ListarCuentasxPagarVencidas: " . $e->getMessage());
        return [];
    }
}#################### FUNCION LISTAR CUENTAS POR PAGAR VENCIDAS ############################

############################ FUNCION PARA PAGAR COMPRAS ############################
public function RegistrarPagoCompra()
{
	$this->p = [];
	if(empty($_POST["codproveedor"]) or empty($_POST["codcompra"]) or empty($_POST["montoabono"]))
	{
		echo "1";
		exit;
	} 
	else if($_POST["montoabono"] > $_POST["totaldebe"])
	{
		echo "2";
		exit;
	}
	######################### CODIGO DE ABONO #########################
	$sql = "SELECT 
	codabono 
	FROM abonoscreditoscompras 
	ORDER BY idabono 
	DESC LIMIT 1";
	foreach ($this->dbh->query($sql) as $row){

		$num=$row["codabono"];
	}
	$codabono = (empty($num) ? "1" : $num + 1);
    ######################### CODIGO DE ABONO #########################

	####################### REGISTRO ABONOS DE COMPRAS #######################
	$query = "INSERT INTO abonoscreditoscompras values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $codabono);
	$stmt->bindParam(2, $codcompra);
	$stmt->bindParam(3, $codproveedor);
	$stmt->bindParam(4, $montoabono);
	$stmt->bindParam(5, $formaabono);
	$stmt->bindParam(6, $codbanco);
	$stmt->bindParam(7, $comprobante);
	$stmt->bindParam(8, $fechaabono);
	$stmt->bindParam(9, $codsucursal);

	$codcompra    = limpiar(decrypt($_POST["codcompra"]));
	$codproveedor = limpiar(decrypt($_POST["codproveedor"]));
	$montoabono   = limpiar($_POST["montoabono"]);
	$formaabono   = limpiar(decrypt($_POST["formaabono"]));
	$codbanco     = limpiar($_POST["codbanco"] == "" ? '0' : decrypt($_POST["codbanco"]));
	$comprobante  = limpiar($_POST["comprobante"]);
	$fechaabono   = limpiar(date("Y-m-d H:i:s"));
	$codsucursal  = limpiar(decrypt($_POST["codsucursal"]));
	$stmt->execute();
	####################### REGISTRO ABONOS DE COMPRAS #######################

    ############## ACTUALIZAMOS EL STATUS DE LA FACTURA ##################
	if($_POST["montoabono"] == $_POST["totaldebe"]) {

		######################### ACTUALIZO DATOS EN COMPRA #########################
		$sql = "UPDATE compras set "
		." creditopagado = ?, "
		." statuscompra = ?, "
		." fechapagado = ? "
		." WHERE "
		." codcompra = ? AND codsucursal = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $creditopagado);
		$stmt->bindParam(2, $statuscompra);
		$stmt->bindParam(3, $fechapagado);
		$stmt->bindParam(4, $codcompra);
		$stmt->bindParam(5, $codsucursal);

		$creditopagado = number_format($_POST["totalabono"] + $_POST["montoabono"], 2, '.', '');
		$statuscompra  = limpiar("PAGADA");
		$fechapagado   = limpiar(date("Y-m-d"));
		$codcompra     = limpiar(decrypt($_POST["codcompra"]));
		$codsucursal   = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();
		######################### ACTUALIZO DATOS EN COMPRA #########################
	
	} else {

		######################### ACTUALIZO DATOS EN COMPRA #########################
		$sql = "UPDATE compras set "
		." creditopagado = ? "
		." WHERE "
		." codcompra = ? AND codsucursal = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $creditopagado);
		$stmt->bindParam(2, $codcompra);
		$stmt->bindParam(3, $codsucursal);

		$creditopagado = number_format($_POST["totalabono"] + $_POST["montoabono"], 2, '.', '');
		$codcompra     = limpiar(decrypt($_POST["codcompra"]));
		$codsucursal   = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();
		######################### ACTUALIZO DATOS EN COMPRA #########################
	}
    ############## ACTUALIZAMOS EL STATUS DE LA FACTURA ##################

    echo "<span class='fa fa-check-square-o'></span> EL ABONO AL CR&Eacute;DITO DE COMPRA HA SIDO REGISTRADO EXITOSAMENTE <a href='reportepdf?codcompra=".encrypt($codcompra)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt("TICKETCOMPRA")."' class='on-default' data-placement='left' data-toggle='tooltip' data-original-title='Imprimir Documento' target='_black' rel='noopener noreferrer'><font color='black'><strong>IMPRIMIR TICKET</strong></font color></a></div>";

    echo "<script>VentanaCentrada('reportepdf?codcompra=".encrypt($codcompra)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt("TICKETCOMPRA")."', '', '', '1024', '568', 'true');</script>";
	exit;
}
########################## FUNCION PARA PAGAR COMPRAS ###############################

########################### FUNCION VER DETALLES COMPRAS #######################
public function VerDetallesAbonosCompras()
{
	$this->p     = [];
	$codCompra   = isset($_GET["codcompra"]) ? limpiar(decrypt($_GET["codcompra"])) : '';
    $codSucursal = isset($_GET["codsucursal"]) ? limpiar(decrypt($_GET["codsucursal"])) : '';
	$sql = "SELECT 
	abonc.*, 
	c.codcompra,
	mp.mediopago,
	ba.nombanco
	FROM abonoscreditoscompras abonc
	LEFT JOIN compras c ON abonc.codcompra = c.codcompra
	LEFT JOIN mediospagos mp ON abonc.formaabono = mp.codmediopago
	LEFT JOIN bancos ba ON abonc.codbanco = ba.codbanco
	WHERE abonc.codcompra = :codCompra AND abonc.codsucursal = :codSucursal";	
	try {
        $stmt = $this->dbh->prepare($sql);
        // Asignamos los parámetros a los marcadores de posición con nombre
        $stmt->bindParam(':codCompra', $codCompra);
        $stmt->bindParam(':codSucursal', $codSucursal);
        $stmt->execute();
        $this->p = $stmt->fetchAll(PDO::FETCH_ASSOC);
        return $this->p;
    } catch (PDOException $e) {
        // Manejo de errores: registra el error y devuelve un array vacío
        error_log("Error en VerDetallesAbonosCompras: " . $e->getMessage() . " SQL: " . $sql . " Params: " . json_encode([$codCompra,$codSucursal]));
        return [];
    }
}
########################## FUNCION VER DETALLES COMPRAS ###########################

############################ FUNCION ID COMPRAS #################################
public function ComprasPorId()
{
    $this->p      = [];
    $codCompra    = isset($_GET["codcompra"]) ? limpiar(decrypt($_GET["codcompra"])) : '';
    $codSucursal  = isset($_GET["codsucursal"]) ? limpiar(decrypt($_GET["codsucursal"])) : '';
    $sql = "SELECT
        c.*,
        suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.girosucursal, suc.tlfsucursal,
        suc.correosucursal, suc.id_ciudad, suc.id_comuna, suc.direcsucursal,
        suc.documencargado, suc.dniencargado, suc.nomencargado, suc.tlfencargado,
        suc.fechaautorsucursal, suc.llevacontabilidad, suc.codmoneda, suc.codmoneda2,
        tm.moneda, tm.siglas, tm.simbolo,
        tm2.moneda AS moneda2, tm2.siglas AS siglas2, tm2.simbolo AS simbolo2,
        valor_cambio.montocambio,
        pro.documproveedor, pro.cuitproveedor, pro.nomproveedor, pro.tlfproveedor, 
        pro.id_ciudad AS id_ciudad2, pro.id_comuna AS id_comuna2, 
	    pro.direcproveedor, pro.emailproveedor, pro.vendedor, pro.tlfvendedor,
        doc.documento, doc2.documento AS documento2, doc3.documento AS documento3,
        usu.dni, usu.nombres,
        mp.mediopago,
        ciud.codciudad, ciud.ciudad, com.codcomuna, com.comuna,
        ciud2.codciudad AS codciudad2, ciud2.ciudad AS ciudad2, com2.codcomuna AS codcomuna2, com2.comuna AS comuna2,
        pag.articulos
    FROM 
        compras c LEFT JOIN sucursales suc ON c.codsucursal = suc.codsucursal
	LEFT JOIN 
	    documentos doc ON suc.documsucursal = doc.coddocumento
	LEFT JOIN 
	    documentos AS doc2 ON suc.documencargado = doc2.coddocumento
    LEFT JOIN 
        ciudades ciud ON suc.id_ciudad = ciud.id_ciudad 
    LEFT JOIN 
        comunas com ON suc.id_comuna = com.id_comuna 
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
    LEFT JOIN 
        tiposmoneda tm2 ON suc.codmoneda2 = tm2.codmoneda
	LEFT JOIN 
	    proveedores pro ON c.codproveedor = pro.codproveedor
	LEFT JOIN 
	    documentos AS doc3 ON pro.documproveedor = doc3.coddocumento
    LEFT JOIN 
        ciudades ciud2 ON pro.id_ciudad = ciud2.id_ciudad 
    LEFT JOIN 
        comunas com2 ON pro.id_comuna = com2.id_comuna 
    LEFT JOIN 
        mediospagos mp ON c.formacompra = mp.codmediopago
	LEFT JOIN 
	    usuarios usu ON c.codigo = usu.codigo

    LEFT JOIN
        (SELECT
            dc.codcompra,
            SUM(dc.cantcompra) AS articulos
            FROM
                detallecompras dc
            WHERE dc.codsucursal = :codSucursal1
        GROUP BY
            dc.codcompra
        ) pag ON pag.codcompra = c.codcompra

    LEFT JOIN
       (SELECT
       codcambio, descripcioncambio, montocambio, codmoneda       
       FROM tiposcambio
       ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = suc.codmoneda2
    WHERE c.codcompra = :codCompra AND c.codsucursal = :codSucursal2 LIMIT 1";
    try {
        $stmt = $this->dbh->prepare($sql);
        // Asignamos los parámetros a los marcadores de posición con nombre
        $stmt->bindParam(':codCompra', $codCompra);
        $stmt->bindParam(':codSucursal1', $codSucursal);
        $stmt->bindParam(':codSucursal2', $codSucursal);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        if (!$row) {
            echo "<div class='alert alert-danger'>";
            echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
            echo "<center><span class='fa fa-info-circle'></span> COMPRA NO ENCONTRADA.</center>";
            echo "</div>";
            exit();
        } else {
            $this->p[] = $row;
            return $this->p;
        }
    } catch (PDOException $e) {
        error_log("Error en ComprasPorId: " . $e->getMessage());
        echo "<div class='alert alert-danger'>";
        echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
        echo "<center><span class='fa fa-exclamation-triangle'></span> OCURRIÓ UN ERROR AL CONSULTAR LA VENTA.</center>";
        echo "</div>";
        return [];
    }
}
############################ FUNCION ID COMPRAS #################################
	
############################ FUNCION VER DETALLES COMPRAS ############################
public function VerDetallesCompras()
{
	$this->p     = [];
	$codCompra   = isset($_GET["codcompra"]) ? limpiar(decrypt($_GET["codcompra"])) : '';
    $codSucursal = isset($_GET["codsucursal"]) ? limpiar(decrypt($_GET["codsucursal"])) : '';
    $sql = "SELECT
	dc.*,
	ma.nommarca,
	mo.nommodelo,
	pr.nompresentacion,
	co.nomcolor
	FROM
	    detallecompras dc
	LEFT JOIN 
	    marcas ma ON dc.codmarca = ma.codmarca
	LEFT JOIN 
	    modelos mo ON dc.codmodelo = mo.codmodelo 
	LEFT JOIN 
	    presentaciones pr ON dc.codpresentacion = pr.codpresentacion
	LEFT JOIN 
	    colores co ON dc.codcolor = co.codcolor 
	WHERE dc.codcompra = ? AND dc.codsucursal = ?";
	try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute([$codCompra,$codSucursal]);
        $this->p = $stmt->fetchAll(PDO::FETCH_ASSOC);
        return $this->p;
    } catch (PDOException $e) {
        // Manejo de errores: registra el error y devuelve un array vacío
        error_log("Error en VerDetallesCompras: " . $e->getMessage() . " SQL: " . $sql . " Params: " . json_encode([$codCompra,$codSucursal]));
        return [];
    }
}
############################ FUNCION VER DETALLES COMPRAS ##############################

############################## FUNCION ACTUALIZAR COMPRAS #############################
public function ActualizarCompras()
{
	$this->p = [];
	if(empty($_POST["codsucursal"]) or empty($_POST["codfactura"]) or empty($_POST["fechaemision"]) or empty($_POST["fecharecepcion"]) or empty($_POST["codproveedor"]))
	{
		echo "1";
		exit;
	}

	for($i=0;$i<count($_POST['coddetallecompra']);$i++){  //recorro el array
        if (!empty($_POST['coddetallecompra'][$i])) {

	        if($_POST['cantcompra'][$i] == 0 || $_POST['cantcompra'][$i] == 0.00){

		        echo "2";
		        exit();
	        }
        }
    }

	if (limpiar($_POST["tipocompra"]) == "CREDITO") { 

	    $fechaactual = date("Y-m-d");
	    $fechavence = date("Y-m-d",strtotime($_POST['fechavencecredito']));
	
        if (strtotime($fechavence) < strtotime($fechaactual)) {
  
            echo "3";
	        exit;
        }
    }

    $this->dbh->beginTransaction();
 
    for($i=0;$i<count($_POST['coddetallecompra']);$i++){  //recorro el array
    if (!empty($_POST['coddetallecompra'][$i])) {

    $sql = "SELECT cantcompra FROM detallecompras 
    WHERE coddetallecompra = '".limpiar($_POST['coddetallecompra'][$i])."' 
    AND codcompra = '".limpiar(decrypt($_POST["codcompra"]))."' 
    AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$cantidadbd = $row['cantcompra'];

	if($cantidadbd != $_POST['cantcompra'][$i]){

		$sql = "SELECT existencia FROM productos 
		WHERE codproducto = '".limpiar(decrypt($_POST['codproducto'][$i]))."' 
		AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
	    foreach ($this->dbh->query($sql) as $row)
	    {
		   $this->p[] = $row;
	    }
	    $existenciabd     = $row['existencia'];
	    $cantcompra       = $_POST["cantcompra"][$i];
	    $cantidadcomprabd = $_POST["cantidadcomprabd"][$i];
	    $totalcompra      = $cantcompra-$cantidadcomprabd;

		################### ACTUALIZO DETALLES COMPRAS ###################
		$query = "UPDATE detallecompras set"
		." cantcompra = ?, "
		." valortotal = ?, "
		." totaldescuentoc = ?, "
		." subtotalimpuestos = ?, "
		." valorneto = ? "
		." WHERE "
		." coddetallecompra = ? AND codcompra = ? AND codsucursal = ?;
		";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $cantcompra);
		$stmt->bindParam(2, $valortotal);
		$stmt->bindParam(3, $totaldescuento);
		$stmt->bindParam(4, $subtotalimpuestos);
		$stmt->bindParam(5, $valorneto);
		$stmt->bindParam(6, $coddetallecompra);
		$stmt->bindParam(7, $codcompra);
		$stmt->bindParam(8, $codsucursal);

		$cantcompra        = $_POST['opcionvendido'][$i] == "2" ? number_format($_POST['cantcompra'][$i], 3, '.', '') : number_format($_POST['cantcompra'][$i], 0, '.', '');
		$preciocompra      = limpiar($_POST['preciocompra'][$i]);
		$ivaproducto       = limpiar($_POST['ivaproducto'][$i]);
		$descuento         = $_POST['descfactura'][$i]/100;
		$valortotal        = number_format($_POST['valortotal'][$i], 2, '.', '');
		$totaldescuento    = number_format($_POST['totaldescuentoc'][$i], 2, '.', '');
		$subtotalimpuestos = number_format($_POST['subtotalimpuestos'][$i], 2, '.', '');
		$valorneto         = number_format($_POST['valorneto'][$i], 2, '.', '');
		$coddetallecompra  = limpiar($_POST['coddetallecompra'][$i]);
		$codcompra         = limpiar(decrypt($_POST["codcompra"]));
		$codsucursal       = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();
		################### ACTUALIZO DETALLES COMPRAS ###################

		############ ACTUALIZAMOS EXISTENCIA DEL PRODUCTO EN ALMACEN ################
		$sql2 = " UPDATE productos set "
	    ." existencia = ? "
	    ." WHERE "
	    ." codproducto = '".limpiar($_POST["codproducto"][$i])."' 
	    AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."';
	    ";
	    $stmt = $this->dbh->prepare($sql2);
	    $stmt->bindParam(1, $existencia);
	    $existencia = $_POST["opcionvendido"][$i] == "2" ? number_format($existenciabd+$totalcompra, 3, '.', '') : number_format($existenciabd+$totalcompra, 0, '.', '');
	    $stmt->execute();
		############ ACTUALIZAMOS EXISTENCIA DEL PRODUCTO EN ALMACEN ################

		############## ACTUALIZAMOS LOS DATOS DEL PRODUCTO EN KARDEX ###################
		$sql3 = " UPDATE kardex set "
		    ." entradas = ?, "
		    ." stockactual = ?, "
		    ." documento = ? "
		    ." WHERE "
			." codproceso = '".limpiar(decrypt($_POST["codcompra"]))."'
			AND codproducto = '".limpiar($_POST["codproducto"][$i])."'
			AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'
			AND tipokardex = 1
			AND procedimiento = 1;
			";
		$stmt = $this->dbh->prepare($sql3);
		$stmt->bindParam(1, $entradas);
		$stmt->bindParam(2, $stockactual);
		$stmt->bindParam(3, $documento);
		
		$entradas    = $_POST["opcionvendido"][$i] == "2" ? number_format($_POST["cantcompra"][$i], 3, '.', '') : number_format($_POST["cantcompra"][$i], 0, '.', '');
		$stockactual = $_POST["opcionvendido"][$i] == "2" ? number_format($existenciabd+$totalcompra, 3, '.', '') : number_format($existenciabd+$totalcompra, 0, '.', '');
		$documento   = limpiar("COMPRA: ".$_POST['codfactura']);
		$stmt->execute();
		############## ACTUALIZAMOS LOS DATOS DEL PRODUCTO EN KARDEX ###################

		} else {

                echo "";
	        }
        }
    }

    $this->dbh->commit();

        ############ ACTUALIZO LOS TOTALES EN LA COMPRA ##############
		$sql = " UPDATE compras SET "
		." codfactura = ?, "
		." codproveedor = ?, "
		." subtotalivasi = ?, "
		." subtotalivano = ?, "
		." totaliva = ?, "
		." descontado = ?, "
		." descuento = ?, "
		." totaldescuento = ?, "
		." totalpago = ?, "
		." tipocompra = ?, "
		." formacompra = ?, "
		." fechavencecredito = ?, "
		." fechaemision = ?, "
	    ." fecharecepcion = ?, "
	    ." observaciones = ? "
		." WHERE "
		." codcompra = ? AND codsucursal = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $codfactura);
		$stmt->bindParam(2, $codproveedor);
		$stmt->bindParam(3, $subtotalivasi);
		$stmt->bindParam(4, $subtotalivano);
		$stmt->bindParam(5, $totaliva);
		$stmt->bindParam(6, $descontado);
		$stmt->bindParam(7, $descuento);
		$stmt->bindParam(8, $totaldescuento);
		$stmt->bindParam(9, $totalpago);
		$stmt->bindParam(10, $tipocompra);
		$stmt->bindParam(11, $formacompra);
		$stmt->bindParam(12, $fechavencecredito);
		$stmt->bindParam(13, $fechaemision);
		$stmt->bindParam(14, $fecharecepcion);
	    $stmt->bindParam(15, $observaciones);
		$stmt->bindParam(16, $codcompra);
		$stmt->bindParam(17, $codsucursal);

		$codfactura        = limpiar($_POST["codfactura"]);
		$codproveedor      = limpiar($_POST["codproveedor"]);
		$subtotalivasi     = number_format($_POST["txtsubtotal"], 2, '.', '');
		$subtotalivano     = number_format($_POST["txtsubtotal2"], 2, '.', '');
		$totaliva          = number_format($_POST["txtIva"], 2, '.', '');
		$descontado        = number_format($_POST["txtdescontado"], 2, '.', '');
		$descuento         = limpiar($_POST["descuento"]);
		$totaldescuento    = number_format($_POST["txtDescuento"], 2, '.', '');
		$totalpago         = number_format($_POST["txtTotal"], 2, '.', '');
		$tipocompra        = limpiar($_POST["tipocompra"]);
		$formacompra       = limpiar($_POST["tipocompra"]=="CONTADO" ? $_POST["formacompra"] : "CREDITO");
		$fechavencecredito = limpiar($_POST["tipocompra"]=="CREDITO" ? date("Y-m-d",strtotime($_POST['fechavencecredito'])) : "0000-00-00");
		$statuscompra      = limpiar($_POST["tipocompra"]=="CONTADO" ? "PAGADA" : "PENDIENTE");
		$fechaemision      = limpiar(date("Y-m-d",strtotime($_POST['fechaemision'])));
		$fecharecepcion    = limpiar(date("Y-m-d",strtotime($_POST['fecharecepcion'])));
	    $observaciones     = limpiar($_POST["observaciones"]);
		$codcompra         = limpiar(decrypt($_POST["codcompra"]));
		$codsucursal       = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();
		############ ACTUALIZO LOS TOTALES EN LA COMPRA ##############

    echo "<span class='fa fa-check-square-o'></span> LA COMPRA DE PRODUCTOS HA SIDO ACTUALIZADA EXITOSAMENTE <a href='reportepdf?codcompra=".encrypt($codcompra)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt("FACTURACOMPRA")."' class='on-default' data-placement='left' data-toggle='tooltip' data-original-title='Imprimir Documento' target='_black' rel='noopener noreferrer'><font color='black'><strong>IMPRIMIR REPORTE</strong></font color></a></div>";

    echo "<script>VentanaCentrada('reportepdf?codcompra=".encrypt($codcompra)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt("FACTURACOMPRA")."', '', '', '1024', '568', 'true');</script>";
	exit;
}
############################# FUNCION ACTUALIZAR COMPRAS #########################

####################### FUNCION AGREGAR DETALLES COMPRAS ########################
public function AgregarDetallesCompras()
{
	$this->p = [];
	if(empty($_POST["codcompra"]) or empty($_POST["codsucursal"]) or empty($_POST["codfactura"]) or empty($_POST["fechaemision"]) or empty($_POST["fecharecepcion"]) or empty($_POST["codproveedor"]))
	{
		echo "1";
		exit;
	}
    elseif(empty($_SESSION["CarritoCompra"]))
	{
		echo "2";
		exit;
	}

	############ CONSULTO TOTAL ACTUAL DE COMPRA ##############
	$sql = "SELECT
	codfactura,
	descuento,
	totalpago 
	FROM compras 
	WHERE codcompra = '".limpiar(decrypt($_POST["codcompra"]))."' 
	AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$codfacturabd = $row['codfactura'];
	$descuentobd  = $row['descuento'];
	$totalpagobd  = $row['totalpago'];
	############ CONSULTO TOTAL ACTUAL DE COMPRA ##############

    $this->dbh->beginTransaction();
    $detalle = $_SESSION["CarritoCompra"];
	for($i=0;$i<count($detalle);$i++){

  	############### VERIFICO LA EXISTENCIA DEL PRODUCTO EN ALMACEN ################
	$sql = "SELECT existencia 
	FROM productos 
	WHERE idproducto = '".limpiar($detalle[$i]['id'])."'
	AND codproducto = '".limpiar($detalle[$i]['txtCodigo'])."' 
	AND codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$existenciabd = $row['existencia'];
	############### VERIFICO LA EXISTENCIA DEL PRODUCTO EN ALMACEN ################

	$sql = "SELECT * 
	FROM detallecompras 
	WHERE codcompra = '".limpiar(decrypt($_POST['codcompra']))."' 
	AND codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."'  
	AND idproducto = '".limpiar($detalle[$i]['id'])."'
	AND codproducto = '".limpiar($detalle[$i]['txtCodigo'])."'";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num == 0)
	{
        ############################ REGISTRO DETALLES DE COMPRAS ############################
		$query = "INSERT INTO detallecompras values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codcompra);
	    $stmt->bindParam(2, $idproducto);
	    $stmt->bindParam(3, $codproducto);
	    $stmt->bindParam(4, $producto);
	    $stmt->bindParam(5, $descripcion);
        $stmt->bindParam(6, $opcionvendido);
	    $stmt->bindParam(7, $imei);
	    $stmt->bindParam(8, $condicion);
	    $stmt->bindParam(9, $codmarca);
	    $stmt->bindParam(10, $codmodelo);
	    $stmt->bindParam(11, $codpresentacion);
	    $stmt->bindParam(12, $codcolor);
		$stmt->bindParam(13, $preciocompra);
		$stmt->bindParam(14, $precioxmayor);
		$stmt->bindParam(15, $precioxmenor);
		$stmt->bindParam(16, $precioxpublico);
		$stmt->bindParam(17, $cantcompra);
		$stmt->bindParam(18, $ivaproducto);
		$stmt->bindParam(19, $descproducto);
		$stmt->bindParam(20, $descfactura);
		$stmt->bindParam(21, $valortotal);
		$stmt->bindParam(22, $totaldescuentoc);
		$stmt->bindParam(23, $subtotalimpuestos);
		$stmt->bindParam(24, $valorneto);
		$stmt->bindParam(25, $lote);
		$stmt->bindParam(26, $fechaelaboracion);
		$stmt->bindParam(27, $fechaoptimo);
		$stmt->bindParam(28, $fechamedio);
		$stmt->bindParam(29, $fechaminimo);
		$stmt->bindParam(30, $stockoptimo);
		$stmt->bindParam(31, $stockmedio);
		$stmt->bindParam(32, $stockminimo);
		$stmt->bindParam(33, $codsucursal);
			
		$codcompra       = limpiar(decrypt($_POST["codcompra"]));
		$idproducto      = limpiar($detalle[$i]['id']);
		$codproducto     = limpiar($detalle[$i]['txtCodigo']);
		$producto        = limpiar($detalle[$i]['producto']);
		$descripcion     = limpiar($detalle[$i]['descripcion'] == "0" ? "" : $detalle[$i]['descripcion']);
		$opcionvendido   = limpiar($detalle[$i]['opcionvendido']);
	    $imei            = limpiar($detalle[$i]['imei'] == "0" ? "" : $detalle[$i]['imei']);
	    $condicion       = limpiar($detalle[$i]['condicion'] == "0" ? "" : $detalle[$i]['condicion']);
		$codmarca        = limpiar($detalle[$i]['codmarca']);
		$codmodelo       = limpiar($detalle[$i]['codmodelo']);
		$codpresentacion = limpiar($detalle[$i]['codpresentacion']);
		$codcolor        = limpiar($detalle[$i]['codcolor']);
		$preciocompra    = limpiar($detalle[$i]['precio']);
		$precioxmayor    = limpiar($detalle[$i]['precio2']);
		$precioxmenor    = limpiar($detalle[$i]['precio3']);
		$precioxpublico  = limpiar($detalle[$i]['precio4']);
		$cantcompra      = $detalle[$i]['opcionvendido'] == "2" ? number_format($detalle[$i]['cantidad'], 3, '.', '') : number_format($detalle[$i]['cantidad'], 0, '.', '');
		$precioconiva    = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['precio']);
		$ivaproducto     = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
		$descproducto    = limpiar($detalle[$i]['descproducto']);
		$descfactura     = limpiar($detalle[$i]['descproductofact']);
		$descuento       = $detalle[$i]["descproductofact"]/100;
		$valortotal      = number_format($detalle[$i]['precio']*$detalle[$i]['cantidad'], 2, '.', '');
		$totaldescuentoc = number_format($valortotal*$descuento, 2, '.', '');

		//CALCULO SUBTOTAL IMPUESTOS
		$ValorImpuesto        = 1 + ($_POST["iva"]/100);
		$RestoDescuento       = $precioconiva * $detalle[$i]['descproductofact'] / 100;
		$PrecioIvaDescuento   = $precioconiva - $RestoDescuento;
		$Discriminado         = $PrecioIvaDescuento/$ValorImpuesto;
	    $SubtotalDiscriminado = $PrecioIvaDescuento - $Discriminado;
	    $BaseDiscriminado     = $SubtotalDiscriminado * $detalle[$i]['cantidad'];
	    $subtotalimpuestos    = number_format($BaseDiscriminado, 2, '.', '');

	    $valorneto         = number_format($valortotal-$totaldescuentoc, 2, '.', '');
		$lote              = limpiar($detalle[$i]['lote']);
		$fechaelaboracion  = limpiar($detalle[$i]['fechaelaboracion']=="" ? "0000-00-00" : date("Y-m-d",strtotime($detalle[$i]['fechaelaboracion'])));
		$fechaoptimo       = limpiar($detalle[$i]['fechaexpiracion']=="" ? "0000-00-00" : date("Y-m-d",strtotime($detalle[$i]['fechaexpiracion'])));
		$fechamedio        = limpiar($detalle[$i]['fechaexpiracion2']=="" ? "0000-00-00" : date("Y-m-d",strtotime($detalle[$i]['fechaexpiracion2'])));
		$fechaminimo       = limpiar($detalle[$i]['fechaexpiracion3']=="" ? "0000-00-00" : date("Y-m-d",strtotime($detalle[$i]['fechaexpiracion3'])));
		$stockoptimo       = limpiar($detalle[$i]['optimo']);
		$stockmedio        = limpiar($detalle[$i]['medio']);
		$stockminimo       = limpiar($detalle[$i]['minimo']);
		$codsucursal       = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();
		############################ REGISTRO DETALLES DE COMPRAS ############################

		##################### ACTUALIZAMOS LA EXISTENCIA DE PRODUCTOS #####################
		$sql = "UPDATE productos set "
		    ." preciocompra = ?, "
		    ." precioxmayor = ?, "
			." precioxmenor = ?, "
			." precioxpublico = ?, "
			." existencia = ?, "
			." ivaproducto = ?, "
			." descproducto = ?, "
			." fechaelaboracion = ?, "
			." fechaoptimo = ?, "
			." fechamedio = ?, "
			." fechaminimo = ?, "
			." stockoptimo = ?, "
			." stockmedio = ?, "
			." stockminimo = ?, "
			." codproveedor = ?, "
			." lote = ? "
			." WHERE "
			." idproducto = ? AND codproducto = ? AND codsucursal = ?;
			";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $preciocompra);
		$stmt->bindParam(2, $precioxmayor);
		$stmt->bindParam(3, $precioxmenor);
		$stmt->bindParam(4, $precioxpublico);
		$stmt->bindParam(5, $existencia);
		$stmt->bindParam(6, $ivaproducto);
		$stmt->bindParam(7, $descproducto);
		$stmt->bindParam(8, $fechaelaboracion);
		$stmt->bindParam(9, $fechaoptimo);
		$stmt->bindParam(10, $fechamedio);
		$stmt->bindParam(11, $fechaminimo);
		$stmt->bindParam(12, $stockoptimo);
		$stmt->bindParam(13, $stockmedio);
		$stmt->bindParam(14, $stockminimo);
		$stmt->bindParam(15, $codproveedor);
		$stmt->bindParam(16, $lote);
		$stmt->bindParam(17, $idproducto);
		$stmt->bindParam(18, $codproducto);
		$stmt->bindParam(19, $codsucursal);
		
		$preciocompra     = limpiar($detalle[$i]['precio']);
		$precioxmayor     = limpiar($detalle[$i]['precio3']);
		$precioxmenor     = limpiar($detalle[$i]['precio2']);
		$precioxpublico   = limpiar($detalle[$i]['precio4']);
		$existencia       = $detalle[$i]['opcionvendido'] == "2" ? number_format($detalle[$i]['cantidad']+$existenciabd, 3, '.', '') : number_format($detalle[$i]['cantidad']+$existenciabd, 0, '.', '');
		$ivaproducto      = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "NO" : "SI");
		$descproducto     = limpiar($detalle[$i]['descproducto']);
		$fechaelaboracion = limpiar($detalle[$i]['fechaelaboracion']=="" ? "0000-00-00" : date("Y-m-d",strtotime($detalle[$i]['fechaelaboracion'])));
		$fechaoptimo      = limpiar($detalle[$i]['fechaexpiracion']=="" ? "0000-00-00" : date("Y-m-d",strtotime($detalle[$i]['fechaexpiracion'])));
		$fechamedio       = limpiar($detalle[$i]['fechaexpiracion2']=="" ? "0000-00-00" : date("Y-m-d",strtotime($detalle[$i]['fechaexpiracion2'])));
		$fechaminimo      = limpiar($detalle[$i]['fechaexpiracion3']=="" ? "0000-00-00" : date("Y-m-d",strtotime($detalle[$i]['fechaexpiracion3'])));
		$stockoptimo      = limpiar($detalle[$i]['optimo']);
		$stockmedio       = limpiar($detalle[$i]['medio']);
		$stockminimo      = limpiar($detalle[$i]['minimo']);
		$codproveedor     = limpiar($_POST['codproveedor']);
		$lote             = limpiar($detalle[$i]['lote']);
		$idproducto       = limpiar($detalle[$i]['id']);
		$codproducto      = limpiar($detalle[$i]['txtCodigo']);
		$codsucursal      = limpiar(decrypt($_POST['codsucursal']));
		$stmt->execute();
		##################### ACTUALIZAMOS LA EXISTENCIA DE PRODUCTOS #####################

		##################### REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX #####################
	    $query = "INSERT INTO kardex values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codcompra);
		$stmt->bindParam(2, $codproveedor);
		$stmt->bindParam(3, $codproducto);
		$stmt->bindParam(4, $movimiento);
		$stmt->bindParam(5, $entradas);
		$stmt->bindParam(6, $salidas);
		$stmt->bindParam(7, $devolucion);
		$stmt->bindParam(8, $stockactual);
		$stmt->bindParam(9, $ivaproducto);
		$stmt->bindParam(10, $descproducto);
		$stmt->bindParam(11, $precio);
		$stmt->bindParam(12, $documento);
		$stmt->bindParam(13, $fechakardex);	
		$stmt->bindParam(14, $tipokardex);	
		$stmt->bindParam(15, $procedimiento);		
		$stmt->bindParam(16, $codsucursal);
		$stmt->bindParam(17, $codigo);

		$codcompra     = limpiar(decrypt($_POST["codcompra"]));
		$codproveedor  = limpiar($_POST["codproveedor"]);
		$codproducto   = limpiar($detalle[$i]['txtCodigo']);
		$movimiento    = limpiar("ENTRADAS");
		$entradas      = $detalle[$i]['opcionvendido'] == "2" ? number_format($detalle[$i]['cantidad'], 3, '.', '') : number_format($detalle[$i]['cantidad'], 0, '.', '');
		$salidas       = $detalle[$i]['opcionvendido'] == "2" ? "0.000" : "0";
		$devolucion    = $detalle[$i]['opcionvendido'] == "2" ? "0.000" : "0";
		$stockactual   = $detalle[$i]['opcionvendido'] == "2" ? number_format($detalle[$i]['cantidad']+$existenciabd, 3, '.', '') : number_format($detalle[$i]['cantidad']+$existenciabd, 0, '.', '');
		$precio        = limpiar($detalle[$i]["precio"]);
		$ivaproducto   = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
		$descproducto  = limpiar($detalle[$i]['descproducto']);
		$documento     = limpiar("COMPRA: ".$_POST['codfactura']);
		$fechakardex   = limpiar(date("Y-m-d"));
		$tipokardex    = limpiar("1");
		$procedimiento = limpiar("1");
		$codsucursal   = limpiar(decrypt($_POST["codsucursal"]));
		$codigo        = limpiar($_SESSION["codigo"]);
		$stmt->execute();
		##################### REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX #####################

	} else {

		################## OBTENGO CANTIDAD DE DETALLE ##################
		$sql = "SELECT cantcompra 
	  	FROM detallecompras 
	  	WHERE codcompra = '".limpiar(decrypt($_POST['codcompra']))."' 
	  	AND codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."'
	  	AND idproducto = '".limpiar($detalle[$i]['id'])."' 
	  	AND codproducto = '".limpiar($detalle[$i]['txtCodigo'])."'";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		$cantidad = $row['cantcompra'];
		################## OBTENGO CANTIDAD DE DETALLE ##################

	  	############################ ACTUALIZO DETALLES DE COMPRAS ############################
	  	$query = "UPDATE detallecompras set"
		." cantcompra = ?, "
		." descproducto = ?, "
		." descfactura = ?, "
		." valortotal = ?, "
		." totaldescuentoc = ?, "
		." subtotalimpuestos = ?, "
		." valorneto = ? "
		." WHERE "
		." codcompra = ? AND codsucursal = ? AND idproducto = ? AND codproducto = ?;
		";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $cantcompra);
		$stmt->bindParam(2, $descproducto);
		$stmt->bindParam(3, $descfactura);
		$stmt->bindParam(4, $valortotal);
		$stmt->bindParam(5, $totaldescuentoc);
		$stmt->bindParam(6, $subtotalimpuestos);
		$stmt->bindParam(7, $valorneto);
		$stmt->bindParam(8, $codcompra);
		$stmt->bindParam(9, $codsucursal);
		$stmt->bindParam(10, $idproducto);
		$stmt->bindParam(11, $codproducto);

		$cantcompra        = $detalle[$i]['opcionvendido'] == "2" ? number_format($detalle[$i]['cantidad']+$cantidad, 3, '.', '') : number_format($detalle[$i]['cantidad']+$cantidad, 0, '.', '');
		$preciocompra    = limpiar($detalle[$i]['precio']);
		$precioxmayor    = limpiar($detalle[$i]['precio3']);
		$precioxmenor    = limpiar($detalle[$i]['precio2']);
		$precioxpublico  = limpiar($detalle[$i]['precio4']);
		$precioconiva    = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['precio']);
		$ivaproducto     = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
		$descproducto    = limpiar($detalle[$i]['descproducto']);
		$descfactura     = limpiar($detalle[$i]['descproductofact']);
		$descuento       = $detalle[$i]["descproductofact"]/100;
		$valortotal      = number_format($detalle[$i]['precio']*$cantcompra, 2, '.', '');
		$totaldescuentoc = number_format($valortotal*$descuento, 2, '.', '');

		//CALCULO SUBTOTAL IMPUESTOS
		$ValorImpuesto        = 1 + ($_POST["iva"]/100);
		$RestoDescuento       = $precioconiva * $detalle[$i]['descproductofact'] / 100;
		$PrecioIvaDescuento   = $precioconiva - $RestoDescuento;
		$Discriminado         = $PrecioIvaDescuento/$ValorImpuesto;
	    $SubtotalDiscriminado = $PrecioIvaDescuento - $Discriminado;
	    $BaseDiscriminado     = $SubtotalDiscriminado * $cantcompra;
	    $subtotalimpuestos    = number_format($BaseDiscriminado, 2, '.', '');

	    $valorneto   = number_format($valortotal-$totaldescuentoc, 2, '.', '');
		$codcompra   = limpiar(decrypt($_POST["codcompra"]));
		$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
		$idproducto  = limpiar($detalle[$i]['id']);
		$codproducto = limpiar($detalle[$i]['txtCodigo']);
		$stmt->execute();
		############################ ACTUALIZO DETALLES DE COMPRAS ############################

		##################### ACTUALIZO LA EXISTENCIA DEL ALMACEN ####################
		$sql = " UPDATE productos set "
		." existencia = ? "
		." WHERE "
		." idproducto = '".limpiar($detalle[$i]['id'])."'
		AND codproducto = '".limpiar($detalle[$i]['txtCodigo'])."' 
		AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."';
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $existencia);
		$cantidad   = limpiar($detalle[$i]['cantidad']);
		$existencia = number_format($existenciabd-$cantidad, 2, '.', '');
		$stmt->execute();
	    ##################### ACTUALIZO LA EXISTENCIA DEL ALMACEN ####################

		##################### REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX #####################
	    $query = "INSERT INTO kardex values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codcompra);
		$stmt->bindParam(2, $codproveedor);
		$stmt->bindParam(3, $codproducto);
		$stmt->bindParam(4, $movimiento);
		$stmt->bindParam(5, $entradas);
		$stmt->bindParam(6, $salidas);
		$stmt->bindParam(7, $devolucion);
		$stmt->bindParam(8, $stockactual);
		$stmt->bindParam(9, $ivaproducto);
		$stmt->bindParam(10, $descproducto);
		$stmt->bindParam(11, $precio);
		$stmt->bindParam(12, $documento);
		$stmt->bindParam(13, $fechakardex);	
		$stmt->bindParam(14, $tipokardex);	
		$stmt->bindParam(15, $procedimiento);		
		$stmt->bindParam(16, $codsucursal);
		$stmt->bindParam(17, $codigo);

		$codcompra     = limpiar(decrypt($_POST["codcompra"]));
		$codproveedor  = limpiar($_POST["codproveedor"]);
		$codproducto   = limpiar($detalle[$i]['txtCodigo']);
		$movimiento    = limpiar("ENTRADAS");
		$entradas      = $detalle[$i]['opcionvendido'] == "2" ? number_format($detalle[$i]['cantidad'], 3, '.', '') : number_format($detalle[$i]['cantidad'], 0, '.', '');
		$salidas       = $detalle[$i]['opcionvendido'] == "2" ? "0.000" : "0";
		$devolucion    = $detalle[$i]['opcionvendido'] == "2" ? "0.000" : "0";
		$stockactual   = $detalle[$i]['opcionvendido'] == "2" ? number_format($detalle[$i]['cantidad']+$existenciabd, 3, '.', '') : number_format($detalle[$i]['cantidad']+$existenciabd, 0, '.', '');
		$precio        = limpiar($detalle[$i]["precio"]);
		$ivaproducto   = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
		$descproducto  = limpiar($detalle[$i]['descproducto']);
		$documento     = limpiar("COMPRA: ".$_POST['codfactura']);
		$fechakardex   = limpiar(date("Y-m-d"));
		$tipokardex    = limpiar("1");
		$procedimiento = limpiar("1");
		$codsucursal   = limpiar(decrypt($_POST["codsucursal"]));
		$codigo        = limpiar($_SESSION["codigo"]);
		$stmt->execute();
		##################### REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX #####################

	   }
    }    
   
    ####################### DESTRUYO LA VARIABLE DE SESSION #####################
	unset($_SESSION["CarritoCompra"]);
    $this->dbh->commit();

    ############ SUMO LOS IMPORTE DE PRODUCTOS CON IVA ##############
    $sql3 = "SELECT SUM(totaldescuentoc) AS totaldescuentosi, SUM(subtotalimpuestos) AS subtotalimpuestos, SUM(valorneto-subtotalimpuestos) AS valorneto FROM detallecompras WHERE codcompra = '".limpiar(decrypt($_POST["codcompra"]))."' AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."' AND ivaproducto != '0.00'";
    foreach ($this->dbh->query($sql3) as $row3)
    {
  	   $this->p[] = $row3;
    }
    $subtotaldescuentosi = ($row3['totaldescuentosi']== "" ? "0.00" : $row3['totaldescuentosi']);
    $subtotalimpuestos   = ($row3['subtotalimpuestos']== "" ? "0.00" : $row3['subtotalimpuestos']);
    $subtotalivasi       = ($row3['valorneto']== "" ? "0.00" : $row3['valorneto']);
    ############ SUMO LOS IMPORTE DE PRODUCTOS CON IVA ##############

    ############ SUMO LOS IMPORTE DE PRODUCTOS SIN IVA ##############
    $sql4 = "SELECT SUM(totaldescuentoc) AS totaldescuentono, SUM(valorneto) AS valorneto FROM detallecompras WHERE codcompra = '".limpiar(decrypt($_POST["codcompra"]))."' AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."' AND ivaproducto = '0.00'";
    foreach ($this->dbh->query($sql4) as $row4)
    {
  	   $this->p[] = $row4;
    }
    $subtotaldescuentono = ($row4['totaldescuentono']== "" ? "0.00" : $row4['totaldescuentono']);
    $subtotalivano       = ($row4['valorneto']== "" ? "0.00" : $row4['valorneto']);
    ############ SUMO LOS IMPORTE DE PRODUCTOS SIN IVA ##############

    ################### ACTUALIZO LA COMPRA ####################
	$sql = " UPDATE compras SET "
	." codfactura = ?, "
	." codproveedor = ?, "
	." subtotalivasi = ?, "
	." subtotalivano = ?, "
	." totaliva = ?, "
	." descontado = ?, "
	." descuento = ?, "
	." totaldescuento = ?, "
	." totalpago = ?, "
	." tipocompra = ?, "
	." formacompra = ?, "
	." fechavencecredito = ?, "
	." fechaemision = ?, "
	." fecharecepcion = ?, "
	." observaciones = ? "
	." WHERE "
	." codcompra = ? AND codsucursal = ?;
	";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $codfactura);
	$stmt->bindParam(2, $codproveedor);
	$stmt->bindParam(3, $subtotalivasi);
	$stmt->bindParam(4, $subtotalivano);
	$stmt->bindParam(5, $totaliva);
	$stmt->bindParam(6, $descontado);
	$stmt->bindParam(7, $descuento);
	$stmt->bindParam(8, $totaldescuento);
	$stmt->bindParam(9, $totalpago);
	$stmt->bindParam(10, $tipocompra);
	$stmt->bindParam(11, $formacompra);
	$stmt->bindParam(12, $fechavencecredito);
	$stmt->bindParam(13, $fechaemision);
	$stmt->bindParam(14, $fecharecepcion);
	$stmt->bindParam(15, $observaciones);
	$stmt->bindParam(16, $codcompra);
	$stmt->bindParam(17, $codsucursal);

	$codfactura        = limpiar($_POST["codfactura"]);
	$codproveedor      = limpiar($_POST["codproveedor"]);
	$iva               = $_POST["iva"]/100;
    $totaliva          = number_format($subtotalimpuestos, 2, '.', '');
    $descontado        = number_format($subtotaldescuentosi+$subtotaldescuentono, 2, '.', '');
    $descuento         = limpiar($_POST["descuento"]+$descuentobd);
    $txtDescuento      = $descuento/100;
    $total             = number_format($subtotalivasi+$subtotalivano+$totaliva, 2, '.', '');
    $totaldescuento    = number_format($total*$txtDescuento, 2, '.', '');
    $totalpago         = number_format($total-$totaldescuento, 2, '.', '');
	$tipocompra        = limpiar($_POST["tipocompra"]);
	$formacompra       = limpiar($_POST["tipocompra"]=="CONTADO" ? $_POST["formacompra"] : "CREDITO");
	$fechavencecredito = limpiar($_POST["tipocompra"]=="CREDITO" ? date("Y-m-d",strtotime($_POST['fechavencecredito'])) : "0000-00-00");
	$statuscompra      = limpiar($_POST["tipocompra"]=="CONTADO" ? "PAGADA" : "PENDIENTE");
	$fechaemision      = limpiar(date("Y-m-d",strtotime($_POST['fechaemision'])));
	$fecharecepcion    = limpiar(date("Y-m-d",strtotime($_POST['fecharecepcion'])));
	$observaciones     = limpiar($_POST["observaciones"]);
	$codcompra         = limpiar(decrypt($_POST["codcompra"]));
	$codsucursal       = limpiar(decrypt($_POST["codsucursal"]));
	$stmt->execute();
	################### ACTUALIZO LA COMPRA ####################
		
    echo "<span class='fa fa-check-square-o'></span> LOS DETALLES DE PRODUCTOS FUERON AGREGADOS A LA COMPRA EXITOSAMENTE <a href='reportepdf?codcompra=".encrypt($codcompra)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt("FACTURACOMPRA")."' class='on-default' data-placement='left' data-toggle='tooltip' data-original-title='Imprimir Documento' target='_black' rel='noopener noreferrer'><font color='black'><strong>IMPRIMIR REPORTE</strong></font color></a></div>";

    echo "<script>VentanaCentrada('reportepdf?codcompra=".encrypt($codcompra)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt("FACTURACOMPRA")."', '', '', '1024', '568', 'true');</script>";
	exit;
}
######################### FUNCION AGREGAR DETALLES COMPRAS #######################

########################## FUNCION ELIMINAR DETALLES COMPRAS ########################
public function EliminarDetallesCompras()
{
   $this->p = [];
	if ($_SESSION["acceso"]=="administradorS") {

	############ CONSULTO TOTAL ACTUAL DE COMPRAS ##############
	$sql = "SELECT
	codfactura,
	iva,
	descuento,
	totalpago 
	FROM compras 
	WHERE codcompra = '".limpiar(decrypt($_GET["codcompra"]))."' 
	AND codsucursal = '".limpiar(decrypt($_GET["codsucursal"]))."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$codfacturabd = $row['codfactura'];
	$ivabd        = $row["iva"]/100;
	$descuentobd  = $row["descuento"]/100;
	$totalpagobd  = $row['totalpago'];
	############ CONSULTO TOTAL ACTUAL DE COMPRAS ##############

	$sql = "SELECT * FROM detallecompras WHERE codcompra = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codcompra"]),decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();
	if($num > 1)
	{
		$sql = "SELECT codproducto, opcionvendido, cantcompra, preciocompra, ivaproducto, descproducto FROM detallecompras WHERE coddetallecompra = ? and codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array(decrypt($_GET["coddetallecompra"]),decrypt($_GET["codsucursal"])));
		$num = $stmt->rowCount();

		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$p[] = $row;
		}
		$codproductobd   = $row['codproducto'];
		$cantidadbd      = $row['cantcompra'];
		$preciocomprabd  = $row['preciocompra'];
		$ivaproductobd   = $row['ivaproducto'];
		$descproductobd  = $row['descproducto'];
		$opcionvendidobd = $row['opcionvendido'];

		$sql2 = "SELECT existencia FROM productos WHERE codproducto = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql2);
		$stmt->execute(array($codproductobd,decrypt($_GET["codsucursal"])));
		$num = $stmt->rowCount();

		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$p[] = $row;
		}
		$existenciabd = $row['existencia'];

		############# ACTUALIZAMOS LA EXISTENCIA DE PRODUCTO EN ALMACEN #############
		$sql = "UPDATE productos SET "
		." existencia = ? "
		." WHERE "
		." codproducto = ? AND codsucursal = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $existencia);
		$stmt->bindParam(2, $codproducto);
		$stmt->bindParam(3, $codsucursal);

		$existencia  = $opcionvendidobd == "2" ? number_format($existenciabd-$cantidadbd, 3, '.', '') : number_format($existenciabd-$cantidadbd, 0, '.', '');
		$codproducto = limpiar($codproductobd);
		$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();
		############# ACTUALIZAMOS LA EXISTENCIA DE PRODUCTO EN ALMACEN #############

	    ########## REGISTRAMOS LOS DATOS DEL PRODUCTO ELIMINADO EN KARDEX ##########
		$query = "INSERT INTO kardex values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codcompra);
		$stmt->bindParam(2, $codproveedor);
		$stmt->bindParam(3, $codproducto);
		$stmt->bindParam(4, $movimiento);
		$stmt->bindParam(5, $entradas);
		$stmt->bindParam(6, $salidas);
		$stmt->bindParam(7, $devolucion);
		$stmt->bindParam(8, $stockactual);
		$stmt->bindParam(9, $ivaproducto);
		$stmt->bindParam(10, $descproducto);
		$stmt->bindParam(11, $precio);
		$stmt->bindParam(12, $documento);
		$stmt->bindParam(13, $fechakardex);	
		$stmt->bindParam(14, $tipokardex);
		$stmt->bindParam(15, $procedimiento);		
		$stmt->bindParam(16, $codsucursal);
		$stmt->bindParam(17, $codigo);

		$codcompra      = limpiar(decrypt($_GET["codcompra"]));
	    $codproveedor   = limpiar(decrypt($_GET["codproveedor"]));
	    $codproducto    = limpiar($codproductobd);
		$movimiento     = limpiar("DEVOLUCION");
		$entradas       = $opcionvendidobd == "2" ? "0.000" : "0";
		$salidas        = $opcionvendidobd == "2" ? "0.000" : "0";
		$devolucion     = $opcionvendidobd == "2" ? number_format($cantidadbd, 3, '.', '') : number_format($cantidadbd, 0, '.', '');
		$stockactual    = $opcionvendidobd == "2" ? number_format($existenciabd-$cantidadbd, 3, '.', '') : number_format($existenciabd-$cantidadbd, 0, '.', '');
		$precio         = limpiar($preciocomprabd);
		$ivaproducto    = limpiar($ivaproductobd);
		$descproducto   = limpiar($descproductobd);
		$documento      = limpiar("DEVOLUCION COMPRA ".$codfacturabd);
		$fechakardex    = limpiar(date("Y-m-d"));
		$tipokardex     = limpiar("1");
		$procedimiento  = limpiar("1");
		$codsucursal    = limpiar(decrypt($_GET["codsucursal"]));
    	$codigo         = limpiar($_SESSION["codigo"]);
		$stmt->execute();

		########## ELIMINAMOS EL PRODUCTO EN DETALLES DE COMPRAS ###########
		$sql = "DELETE FROM detallecompras WHERE coddetallecompra = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$coddetallecompra);
		$stmt->bindParam(2,$codsucursal);
		$coddetallecompra = decrypt($_GET["coddetallecompra"]);
		$codsucursal      = decrypt($_GET["codsucursal"]);
		$stmt->execute();
		########## ELIMINAMOS EL PRODUCTO EN DETALLES DE COMPRAS ###########

        ############ SUMO LOS IMPORTE DE PRODUCTOS CON IVA ##############
		$sql3 = "SELECT SUM(totaldescuentoc) AS totaldescuentosi, SUM(subtotalimpuestos) AS subtotalimpuestos, SUM(valorneto-subtotalimpuestos) AS valorneto FROM detallecompras WHERE codcompra = '".limpiar(decrypt($_GET["codcompra"]))."' AND codsucursal = '".limpiar(decrypt($_GET["codsucursal"]))."' AND ivaproducto != '0.00'";
		foreach ($this->dbh->query($sql3) as $row3)
		{
			$this->p[] = $row3;
		}
		$subtotaldescuentosi = ($row3['totaldescuentosi']== "" ? "0.00" : $row3['totaldescuentosi']);
		$subtotalimpuestos   = ($row3['subtotalimpuestos']== "" ? "0.00" : $row3['subtotalimpuestos']);
		$subtotalivasi       = ($row3['valorneto']== "" ? "0.00" : $row3['valorneto']);
		############ SUMO LOS IMPORTE DE PRODUCTOS CON IVA ##############

	    ############ SUMO LOS IMPORTE DE PRODUCTOS SIN IVA ##############
		$sql4 = "SELECT SUM(totaldescuentoc) AS totaldescuentono, SUM(valorneto) AS valorneto FROM detallecompras WHERE codcompra = '".limpiar(decrypt($_GET["codcompra"]))."' AND codsucursal = '".limpiar(decrypt($_GET["codsucursal"]))."' AND ivaproducto = '0.00'";
		foreach ($this->dbh->query($sql4) as $row4)
		{
			$this->p[] = $row4;
		}
		$subtotaldescuentono = ($row4['totaldescuentono']== "" ? "0.00" : $row4['totaldescuentono']);
		$subtotalivano       = ($row4['valorneto']== "" ? "0.00" : $row4['valorneto']);
		############ SUMO LOS IMPORTE DE PRODUCTOS SIN IVA ##############

        ############ ACTUALIZO LOS TOTALES EN LA COMPRAS ##############
		$sql = " UPDATE compras SET "
		." subtotalivasi = ?, "
		." subtotalivano = ?, "
		." totaliva = ?, "
		." descontado = ?, "
		." totaldescuento = ?, "
		." totalpago = ? "
		." WHERE "
		." codcompra = ? AND codsucursal = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $subtotalivasi);
		$stmt->bindParam(2, $subtotalivano);
		$stmt->bindParam(3, $totaliva);
		$stmt->bindParam(4, $descontado);
		$stmt->bindParam(5, $totaldescuento);
		$stmt->bindParam(6, $totalpago);
		$stmt->bindParam(7, $codcompra);
		$stmt->bindParam(8, $codsucursal);

		$totaliva       = number_format($subtotalimpuestos, 2, '.', '');
		$descontado     = number_format($subtotaldescuentosi+$subtotaldescuentono, 2, '.', '');
	    $total          = number_format($subtotalivasi+$subtotalivano+$totaliva, 2, '.', '');
	    $totaldescuento = number_format($total*$descuentobd, 2, '.', '');
	    $totalpago      = number_format($total-$totaldescuento, 2, '.', '');
		$codcompra      = limpiar(decrypt($_GET["codcompra"]));
		$codsucursal    = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();
		############ ACTUALIZO LOS TOTALES EN LA COMPRAS ##############

		echo "1";
		exit;

	} else {
		   
		echo "2";
		exit;
	} 
			
	} else {
		
		echo "3";
		exit;
	}	
}
###################### FUNCION ELIMINAR DETALLES COMPRAS #######################

####################### FUNCION ELIMINAR COMPRAS #################################
public function EliminarCompras()
{
	$this->p = [];
	if ($_SESSION["acceso"]=="administradorS") {

	########################## CONSULTO DATOS DE COMPRA ##########################
	$sql = "SELECT
	codfactura 
	FROM compras 
	WHERE codcompra = '".limpiar(decrypt($_GET["codcompra"]))."' 
	AND codsucursal = '".limpiar(decrypt($_GET["codsucursal"]))."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$codfacturabd = $row['codfactura'];
	########################## CONSULTO DATOS DE COMPRA ##########################

	$sql = "SELECT * FROM detallecompras WHERE codcompra = '".limpiar(decrypt($_GET["codcompra"]))."' 
	AND codsucursal = '".limpiar(decrypt($_GET["codsucursal"]))."'";
	$array=array();
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;

		$codproductobd   = $row['codproducto'];
		$cantidadbd      = $row['cantcompra'];
		$preciocomprabd  = $row['preciocompra'];
		$ivaproductobd   = $row['ivaproducto'];
		$descproductobd  = $row['descproducto'];
		$opcionvendidobd = $row['opcionvendido'];

		$sql2 = "SELECT existencia FROM productos WHERE codproducto = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql2);
		$stmt->execute( array($codproductobd,decrypt($_GET["codsucursal"])));
		$num = $stmt->rowCount();

		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$p[] = $row;
		}
		$existenciabd = $row['existencia'];

		########### ACTUALIZAMOS LA EXISTENCIA DE PRODUCTO EN ALMACEN #############
		$sql = "UPDATE productos SET "
		." existencia = ? "
		." WHERE "
		." codproducto = ? AND codsucursal = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $existencia);
		$stmt->bindParam(2, $codproducto);
		$stmt->bindParam(3, $codsucursal);

		$existencia  = $opcionvendidobd == "2" ? number_format($existenciabd-$cantidadbd, 3, '.', '') : number_format($existenciabd-$cantidadbd, 0, '.', '');
		$codproducto = limpiar($codproductobd);
		$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();
		########### ACTUALIZAMOS LA EXISTENCIA DE PRODUCTO EN ALMACEN #############

	    ########## REGISTRAMOS LOS DATOS DEL PRODUCTO ELIMINADO EN KARDEX ##########
		$query = "INSERT INTO kardex values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codcompra);
		$stmt->bindParam(2, $codproveedor);
		$stmt->bindParam(3, $codproducto);
		$stmt->bindParam(4, $movimiento);
		$stmt->bindParam(5, $entradas);
		$stmt->bindParam(6, $salidas);
		$stmt->bindParam(7, $devolucion);
		$stmt->bindParam(8, $stockactual);
		$stmt->bindParam(9, $ivaproducto);
		$stmt->bindParam(10, $descproducto);
		$stmt->bindParam(11, $precio);
		$stmt->bindParam(12, $documento);
		$stmt->bindParam(13, $fechakardex);
		$stmt->bindParam(14, $tipokardex);	
		$stmt->bindParam(15, $procedimiento);	
		$stmt->bindParam(16, $codsucursal);
		$stmt->bindParam(17, $codigo);

		$codcompra      = limpiar(decrypt($_GET["codcompra"]));
	    $codproveedor   = limpiar(decrypt($_GET["codproveedor"]));
	    $codproducto    = limpiar($codproductobd);
		$movimiento     = limpiar("DEVOLUCION");
		$entradas       = $opcionvendidobd == "2" ? "0.000" : "0";
		$salidas        = $opcionvendidobd == "2" ? "0.000" : "0";
		$devolucion     = $opcionvendidobd == "2" ? number_format($cantidadbd, 3, '.', '') : number_format($cantidadbd, 0, '.', '');
		$stockactual    = $opcionvendidobd == "2" ? number_format($existenciabd-$cantidadbd, 3, '.', '') : number_format($existenciabd-$cantidadbd, 0, '.', '');
		$precio         = limpiar($preciocomprabd);
		$ivaproducto    = limpiar($ivaproductobd);
		$descproducto   = limpiar($descproductobd);
		$documento      = limpiar("DEVOLUCION COMPRA: ".$codfacturabd);
		$fechakardex    = limpiar(date("Y-m-d"));
		$tipokardex     = limpiar("1");
		$procedimiento  = limpiar("1");
		$codsucursal    = limpiar(decrypt($_GET["codsucursal"]));
    	$codigo         = limpiar($_SESSION["codigo"]);
		$stmt->execute();
		########## REGISTRAMOS LOS DATOS DEL PRODUCTO ELIMINADO EN KARDEX ##########
	}
		#################### ELIMINO LA COMPRA ####################
	    $sql = "DELETE FROM compras WHERE codcompra = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codcompra);
		$stmt->bindParam(2,$codsucursal);
		$codcompra   = decrypt($_GET["codcompra"]);
		$codsucursal = decrypt($_GET["codsucursal"]);
		$stmt->execute();
		#################### ELIMINO LA COMPRA ####################

		#################### ELIMINO DETALLE DE COMPRA ####################
		$sql = "DELETE FROM detallecompras WHERE codcompra = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codcompra);
		$stmt->bindParam(2,$codsucursal);
		$codcompra   = decrypt($_GET["codcompra"]);
		$codsucursal = decrypt($_GET["codsucursal"]);
		$stmt->execute();
		#################### ELIMINO DETALLE DE COMPRA ####################

		echo "1";
		exit;

	} else {

		echo "2";
		exit;
	}
}
######################### FUNCION ELIMINAR COMPRAS #################################

##################### FUNCION BUSQUEDA COMPRAS POR PROVEEDORES ###################
public function BuscarComprasxProveedor() 
{
	$this->p = [];
	$codSucursal      = isset($_GET["codsucursal"]) ? limpiar(decrypt($_GET['codsucursal'])) : '';
    $codProveedorBusqueda = isset($_GET['codproveedor']) ? decrypt(trim($_GET['codproveedor'])) : null;
	$whereConditions  = [];
    $params           = [];

	$sqlBase = "SELECT
        c.codcompra, c.codfactura, c.codproveedor, c.subtotalivasi, c.subtotalivano, 
        c.iva, c.totaliva, c.descontado, c.descuento, c.totaldescuento, c.totalpago, c.gastoenvio,
        c.creditopagado, c.statuscompra, c.fechavencecredito, c.fechapagado, c.fecharecepcion, c.fechaemision, 
        c.observaciones, c.codsucursal,
		suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
		suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
		tm.moneda, tm.siglas, tm.simbolo,
		usu.dni, usu.nombres,
		mp.mediopago,
		pro.documproveedor, pro.cuitproveedor, pro.nomproveedor, pro.tlfproveedor, 
		pro.id_ciudad AS id_ciudad2, pro.id_comuna AS id_comuna2, 
		pro.direcproveedor, pro.emailproveedor, pro.vendedor, pro.tlfvendedor,
		doc.documento, doc2.documento AS documento2, doc3.documento AS documento3,
		pag.articulos, pag.detalles_productos
    FROM 
        compras c LEFT JOIN sucursales suc ON c.codsucursal = suc.codsucursal
	LEFT JOIN 
	    documentos doc ON suc.documsucursal = doc.coddocumento
	LEFT JOIN 
	    documentos AS doc2 ON suc.documencargado = doc2.coddocumento
    LEFT JOIN 
        ciudades ciud ON suc.id_ciudad = ciud.id_ciudad 
    LEFT JOIN 
        comunas com ON suc.id_comuna = com.id_comuna 
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
	LEFT JOIN 
	    proveedores pro ON c.codproveedor = pro.codproveedor
	LEFT JOIN 
	    documentos AS doc3 ON pro.documproveedor = doc3.coddocumento
    LEFT JOIN 
        ciudades ciud2 ON pro.id_ciudad = ciud2.id_ciudad 
    LEFT JOIN 
        comunas com2 ON pro.id_comuna = com2.id_comuna  
    LEFT JOIN 
        mediospagos mp ON c.formacompra = mp.codmediopago
	LEFT JOIN 
	    usuarios usu ON c.codigo = usu.codigo

    LEFT JOIN
        (SELECT
            dc.codcompra,
            SUM(dc.cantcompra) AS articulos,
            GROUP_CONCAT(
            CONCAT_WS(
               ' | ',
               dc.cantcompra,
               dc.producto,
               dc.descripcion,
               IFNULL(mar.nommarca, ''),
               IFNULL(mode.nommodelo, ''),
               IFNULL(pres.nompresentacion, ''),
               IFNULL(col.nomcolor, '')
            )
                ORDER BY dc.producto
                SEPARATOR '<br>'
            ) AS detalles_productos
            FROM
                detallecompras dc
            LEFT JOIN 
                marcas mar ON dc.codmarca = mar.codmarca
		    LEFT JOIN 
		        modelos mode ON dc.codmodelo = mode.codmodelo 
		    LEFT JOIN 
		        presentaciones pres ON dc.codpresentacion = pres.codpresentacion
			LEFT JOIN 
			    colores col ON dc.codcolor = col.codcolor
			WHERE dc.codsucursal = ?
	    GROUP BY
	        dc.codcompra
	    ) pag ON pag.codcompra = c.codcompra";
    //Condicion de Sucursal
    if (!empty($codSucursal)) {
        $whereConditions[] = "c.codsucursal = ?";
        $params[]          = $codSucursal;
    }
    //Condicion de Proveedor
    if (!empty($codProveedorBusqueda)) { // Asegurarse de que codcaja exista
        $whereConditions[] = "c.codproveedor = ?";
        $params[] = $codProveedorBusqueda;
    }
    $whereClause = "";
    if (!empty($whereConditions)) {
        $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $sql = $sqlBase . $whereClause . " ORDER BY c.codcompra ASC";
	try {
	    $stmt = $this->dbh->prepare($sql);
        array_unshift($params, $codSucursal);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
	    if (empty($results)) {
	        echo "<div class='alert alert-danger'>";
	        echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	        echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS PARA TU BÚSQUEDA REALIZADA</center>";
	        echo "</div>";
	        exit();
	    } else {
	        return $results;
	    }
	} catch (PDOException $e) {
	    error_log("Error en BuscarComprasxProveedor: " . $e->getMessage());
	    echo "<div class='alert alert-danger'>";
	    echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	    echo "<center><span class='fa fa-exclamation-triangle'></span> OCURRIÓ UN ERROR AL CONSULTAR LAS VENTAS.</center>";
	    echo "</div>";
	    return [];
	}
}
################### FUNCION BUSQUEDA COMPRAS POR PROVEEDORES ###################

###################### FUNCION BUSQUEDA COMPRAS POR FECHAS ###########################
public function BuscarComprasxFechas() 
{
	$this->p = [];
	$codSucursal      = isset($_GET["codsucursal"]) ? limpiar(decrypt($_GET['codsucursal'])) : '';
	$fechaDesde       = isset($_GET['desde']) ? limpiar(date("Y-m-d", strtotime($_GET['desde']))) : '';
    $fechaHasta       = isset($_GET['hasta']) ? limpiar(date("Y-m-d", strtotime($_GET['hasta']))) : '';
	$whereConditions  = [];
    $params           = [];

	$sqlBase = "SELECT
        c.codcompra, c.codfactura, c.codproveedor, c.subtotalivasi, c.subtotalivano, 
        c.iva, c.totaliva, c.descontado, c.descuento, c.totaldescuento, c.totalpago, c.gastoenvio,
        c.creditopagado, c.statuscompra, c.fechavencecredito, c.fechapagado, c.fecharecepcion, c.fechaemision, 
        c.observaciones, c.codsucursal,
		suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
		suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
		tm.moneda, tm.siglas, tm.simbolo,
		usu.dni, usu.nombres,
		mp.mediopago,
		pro.documproveedor, pro.cuitproveedor, pro.nomproveedor, pro.tlfproveedor, 
		pro.id_ciudad AS id_ciudad2, pro.id_comuna AS id_comuna2, 
		pro.direcproveedor, pro.emailproveedor, pro.vendedor, pro.tlfvendedor,
		doc.documento, doc2.documento AS documento2, doc3.documento AS documento3,
		pag.articulos, pag.detalles_productos
    FROM 
        compras c LEFT JOIN sucursales suc ON c.codsucursal = suc.codsucursal
	LEFT JOIN 
	    documentos doc ON suc.documsucursal = doc.coddocumento
	LEFT JOIN 
	    documentos AS doc2 ON suc.documencargado = doc2.coddocumento
    LEFT JOIN 
        ciudades ciud ON suc.id_ciudad = ciud.id_ciudad 
    LEFT JOIN 
        comunas com ON suc.id_comuna = com.id_comuna 
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
	LEFT JOIN 
	    proveedores pro ON c.codproveedor = pro.codproveedor
	LEFT JOIN 
	    documentos AS doc3 ON pro.documproveedor = doc3.coddocumento
    LEFT JOIN 
        ciudades ciud2 ON pro.id_ciudad = ciud2.id_ciudad 
    LEFT JOIN 
        comunas com2 ON pro.id_comuna = com2.id_comuna
    LEFT JOIN 
        mediospagos mp ON c.formacompra = mp.codmediopago
	LEFT JOIN 
	    usuarios usu ON c.codigo = usu.codigo

    LEFT JOIN
        (SELECT
            dc.codcompra,
            SUM(dc.cantcompra) AS articulos,
            GROUP_CONCAT(
            CONCAT_WS(
               ' | ',
               dc.cantcompra,
               dc.producto,
               dc.descripcion,
               IFNULL(mar.nommarca, ''),
               IFNULL(mode.nommodelo, ''),
               IFNULL(pres.nompresentacion, ''),
               IFNULL(col.nomcolor, '')
            )
                ORDER BY dc.producto
                SEPARATOR '<br>'
            ) AS detalles_productos
            FROM
                detallecompras dc
            LEFT JOIN 
                marcas mar ON dc.codmarca = mar.codmarca
		    LEFT JOIN 
		        modelos mode ON dc.codmodelo = mode.codmodelo 
		    LEFT JOIN 
		        presentaciones pres ON dc.codpresentacion = pres.codpresentacion
			LEFT JOIN 
			    colores col ON dc.codcolor = col.codcolor
			WHERE dc.codsucursal = ?
	    GROUP BY
	        dc.codcompra
	    ) pag ON pag.codcompra = c.codcompra";
    //Condicion de Sucursal
    if (!empty($codSucursal)) {
        $whereConditions[] = "c.codsucursal = ?";
        $params[]          = $codSucursal;
    }
    //Condicion de Fechas
    if (!empty($fechaDesde) && !empty($fechaHasta)) {
        $whereConditions[] = "DATE_FORMAT(c.fechaemision,'%Y-%m-%d') BETWEEN ? AND ?";
        $params[] = $fechaDesde;
        $params[] = $fechaHasta;
    }
    $whereClause = "";
    if (!empty($whereConditions)) {
        $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $sql = $sqlBase . $whereClause . " ORDER BY c.codcompra ASC";
	try {
	    $stmt = $this->dbh->prepare($sql);
        array_unshift($params, $codSucursal);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
	    if (empty($results)) {
	        echo "<div class='alert alert-danger'>";
	        echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	        echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS PARA TU BÚSQUEDA REALIZADA</center>";
	        echo "</div>";
	        exit();
	    } else {
	        return $results;
	    }
	} catch (PDOException $e) {
	    error_log("Error en BuscarComprasxFechas: " . $e->getMessage());
	    echo "<div class='alert alert-danger'>";
	    echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	    echo "<center><span class='fa fa-exclamation-triangle'></span> OCURRIÓ UN ERROR AL CONSULTAR LAS VENTAS.</center>";
	    echo "</div>";
	    return [];
	}
}
###################### FUNCION BUSQUEDA COMPRAS POR FECHAS ###########################

###################### FUNCION BUSQUEDA ABONOS CREDITOS POR FECHAS ###########################
public function BuscarAbonosCreditosComprasxFechas() 
{
	$this->p = [];
	$codPagoBusqueda = isset($_GET['codmediopago']) ? decrypt(trim($_GET['codmediopago'])) : null;
    $codSucursal     = isset($_SESSION["codsucursal"]) ? limpiar($_SESSION["codsucursal"]) : '';
    $fechaDesde      = isset($_GET['desde']) ? limpiar(date("Y-m-d", strtotime($_GET['desde']))) : '';
    $fechaHasta      = isset($_GET['hasta']) ? limpiar(date("Y-m-d", strtotime($_GET['hasta']))) : '';
    $whereConditions = [];
    $params          = [];

	$sqlBase = "SELECT
	    c.idcompra, c.codcompra, c.codfactura, c.totalpago, 
	    c.gastoenvio, c.fechaemision, c.creditopagado, c.statuscompra,
		suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.tlfsucursal,
		suc.documencargado, suc.dniencargado, suc.nomencargado, suc.codmoneda,
		tm.moneda, tm.siglas, tm.simbolo,
		pro.codproveedor, pro.documproveedor, pro.cuitproveedor, pro.nomproveedor, 
		pro.tlfproveedor, pro.direcproveedor, pro.id_ciudad AS id_ciudad2, pro.id_comuna AS id_comuna2, pro.emailproveedor,
		doc.documento, doc2.documento AS documento2, doc3.documento AS documento3,
		abonc.idabono, abonc.codabono, abonc.codcompra, abonc.codproveedor,
		abonc.montoabono, abonc.formaabono, abonc.codbanco, abonc.comprobante,
		abonc.fechaabono,
		mp.mediopago, b.nombanco
	FROM 
	    abonoscreditoscompras abonc LEFT JOIN compras c ON abonc.codcompra = c.codcompra
	LEFT JOIN 
	    sucursales suc ON abonc.codsucursal = suc.codsucursal
	LEFT JOIN 
        documentos doc ON suc.documsucursal = doc.coddocumento
    LEFT JOIN 
        documentos doc2 ON suc.documencargado = doc2.coddocumento
	LEFT JOIN 
        ciudades ciud ON suc.id_ciudad = ciud.id_ciudad 
    LEFT JOIN 
        comunas com ON suc.id_comuna = com.id_comuna 
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
	LEFT JOIN 
	    proveedores pro ON abonc.codproveedor = pro.codproveedor
    LEFT JOIN 
        documentos AS doc3 ON pro.documproveedor = doc3.coddocumento
    LEFT JOIN 
        ciudades ciud2 ON pro.id_ciudad = ciud2.id_ciudad 
    LEFT JOIN 
        comunas com2 ON pro.id_comuna = com2.id_comuna
	LEFT JOIN 
	    mediospagos mp ON abonc.formaabono = mp.codmediopago
	LEFT JOIN 
	    bancos b ON abonc.codbanco = b.codbanco";
    //Condicion de Sucursal
    if (!empty($codSucursal)) {
        $whereConditions[] = "abonc.codsucursal = ?";
        $params[]          = $codSucursal;
    }
    //Condicion de Pago
    if (!empty($codPagoBusqueda)) { // Asegurarse de que codcaja exista
        $whereConditions[] = "abonc.formaabono = ?";
        $params[] = $codPagoBusqueda;
    }
    //Condicion de Fechas
    if (!empty($fechaDesde) && !empty($fechaHasta)) {
        $whereConditions[] = "DATE_FORMAT(abonc.fechaabono,'%Y-%m-%d') BETWEEN ? AND ?";
        $params[] = $fechaDesde;
        $params[] = $fechaHasta;
    }
    $whereClause = "";
    if (!empty($whereConditions)) {
        $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $sql = $sqlBase . $whereClause . " ORDER BY abonc.codabono ASC"; // Se añadió ORDER BY
    try {
        $stmt = $this->dbh->prepare($sql);// Preparar y ejecutar la consulta
        $stmt->execute($params); // Pasamos todos los parámetros juntos
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($results)) {
            echo "<div class='alert alert-danger'>";
            echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
            echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS PARA TU BÚSQUEDA REALIZADA</center>";
            echo "</div>";
            exit();
        } else {
            return $results;
        }
    } catch (PDOException $e) {
        error_log("Error en BuscarAbonosCreditosComprasxFechas: " . $e->getMessage());
        echo "<div class='alert alert-danger'>";
        echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
        echo "<center><span class='fa fa-exclamation-triangle'></span> OCURRIÓ UN ERROR AL CONSULTAR LOS ABONOS DE CREDITOS.</center>";
        echo "</div>";
        return [];
    }
}
###################### FUNCION BUSQUEDA ABONOS CREDITOS POR FECHAS ###########################

###################### FUNCION BUSQUEDA CREDITOS POR PROVEEDOR ###########################
public function BuscarCreditosComprasxProveedor() 
{
	$this->p = [];
    $EstadoBusqueda   = isset($_GET['status']) ? decrypt(trim($_GET['status'])) : null;
	$codSucursal      = isset($_GET["codsucursal"]) ? limpiar(decrypt($_GET['codsucursal'])) : '';
    $codProveedorBusqueda = isset($_GET['codproveedor']) ? decrypt(trim($_GET['codproveedor'])) : null;
	$whereConditions  = [];
    $params           = [];

	$sqlBase = "SELECT
        c.codcompra, c.codfactura, c.codproveedor, c.subtotalivasi, c.subtotalivano, 
        c.iva, c.totaliva, c.descontado, c.descuento, c.totaldescuento, c.totalpago, c.gastoenvio,
        c.creditopagado, c.statuscompra, c.fechavencecredito, c.fechapagado, c.fecharecepcion, c.fechaemision, 
        c.observaciones, c.codsucursal,
		suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
		suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
		tm.moneda, tm.siglas, tm.simbolo,
		usu.dni, usu.nombres,
		mp.mediopago,
		pro.documproveedor, pro.cuitproveedor, pro.nomproveedor, pro.tlfproveedor, 
		pro.id_ciudad AS id_ciudad2, pro.id_comuna AS id_comuna2, 
		pro.direcproveedor, pro.emailproveedor, pro.vendedor, pro.tlfvendedor,
		doc.documento, doc2.documento AS documento2, doc3.documento AS documento3,
		pag.articulos, pag.detalles_productos
    FROM 
        compras c LEFT JOIN sucursales suc ON c.codsucursal = suc.codsucursal
	LEFT JOIN 
	    documentos doc ON suc.documsucursal = doc.coddocumento
	LEFT JOIN 
	    documentos AS doc2 ON suc.documencargado = doc2.coddocumento
    LEFT JOIN 
        ciudades ciud ON suc.id_ciudad = ciud.id_ciudad 
    LEFT JOIN 
        comunas com ON suc.id_comuna = com.id_comuna 
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
	LEFT JOIN 
	    proveedores pro ON c.codproveedor = pro.codproveedor
	LEFT JOIN 
	    documentos AS doc3 ON pro.documproveedor = doc3.coddocumento
    LEFT JOIN 
        ciudades ciud2 ON pro.id_ciudad = ciud2.id_ciudad 
    LEFT JOIN 
        comunas com2 ON pro.id_comuna = com2.id_comuna
    LEFT JOIN 
        mediospagos mp ON c.formacompra = mp.codmediopago
	LEFT JOIN 
	    usuarios usu ON c.codigo = usu.codigo

    LEFT JOIN
        (SELECT
            dc.codcompra,
            SUM(dc.cantcompra) AS articulos,
            GROUP_CONCAT(
            CONCAT_WS(
               ' | ',
               dc.cantcompra,
               dc.producto,
               dc.descripcion,
               IFNULL(mar.nommarca, ''),
               IFNULL(mode.nommodelo, ''),
               IFNULL(pres.nompresentacion, ''),
               IFNULL(col.nomcolor, '')
            )
                ORDER BY dc.producto
                SEPARATOR '<br>'
            ) AS detalles_productos
            FROM
                detallecompras dc
            LEFT JOIN 
                marcas mar ON dc.codmarca = mar.codmarca
		    LEFT JOIN 
		        modelos mode ON dc.codmodelo = mode.codmodelo 
		    LEFT JOIN 
		        presentaciones pres ON dc.codpresentacion = pres.codpresentacion
			LEFT JOIN 
			    colores col ON dc.codcolor = col.codcolor
			WHERE dc.codsucursal = ?
	    GROUP BY
	        dc.codcompra
	    ) pag ON pag.codcompra = c.codcompra";
	$whereConditions[] = "c.tipocompra = 'CREDITO'";
    //Condicion de Sucursal
    if (!empty($codSucursal)) {
        $whereConditions[] = "c.codsucursal = ?";
        $params[]          = $codSucursal;
    }
    //Condicion de Proveedor
    if (!empty($codProveedorBusqueda)) { // Asegurarse de que codcaja exista
        $whereConditions[] = "c.codproveedor = ?";
        $params[] = $codProveedorBusqueda;
    }
    //Condicion de Estado de Busqueda
    if ($EstadoBusqueda == 2) { // Pagada
        $whereConditions[] = "c.statuscompra = 'PAGADA'";
    } elseif ($EstadoBusqueda == 3) { // Pendiente
        $whereConditions[] = "c.statuscompra = 'PENDIENTE'";
    }
    $whereClause = "";
    if (!empty($whereConditions)) {
        $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $sql = $sqlBase . $whereClause . " ORDER BY c.codcompra ASC";
	try {
	    $stmt = $this->dbh->prepare($sql);
        array_unshift($params, $codSucursal);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
	    if (empty($results)) {
	        echo "<div class='alert alert-danger'>";
	        echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	        echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS PARA TU BÚSQUEDA REALIZADA</center>";
	        echo "</div>";
	        exit();
	    } else {
	        return $results;
	    }
	} catch (PDOException $e) {
	    error_log("Error en BuscarCreditosComprasxProveedor: " . $e->getMessage());
	    echo "<div class='alert alert-danger'>";
	    echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	    echo "<center><span class='fa fa-exclamation-triangle'></span> OCURRIÓ UN ERROR AL CONSULTAR LAS VENTAS.</center>";
	    echo "</div>";
	    return [];
	}
}
###################### FUNCION BUSQUEDA CREDITOS POR PROVEEDOR ###########################

###################### FUNCION BUSQUEDA CREDITOS DE COMPRAS POR FECHAS ###########################
public function BuscarCreditosComprasxFechas() 
{
	$this->p = [];
    $EstadoBusqueda   = isset($_GET['status']) ? decrypt(trim($_GET['status'])) : null;
	$codSucursal      = isset($_GET["codsucursal"]) ? limpiar(decrypt($_GET['codsucursal'])) : '';
	$fechaDesde       = isset($_GET['desde']) ? limpiar(date("Y-m-d", strtotime($_GET['desde']))) : '';
    $fechaHasta       = isset($_GET['hasta']) ? limpiar(date("Y-m-d", strtotime($_GET['hasta']))) : '';
	$whereConditions  = [];
    $params           = [];

	$sqlBase = "SELECT
        c.codcompra, c.codfactura, c.codproveedor, c.subtotalivasi, c.subtotalivano, 
        c.iva, c.totaliva, c.descontado, c.descuento, c.totaldescuento, c.totalpago, c.gastoenvio,
        c.creditopagado, c.statuscompra, c.fechavencecredito, c.fechapagado, c.fecharecepcion, c.fechaemision, 
        c.observaciones, c.codsucursal,
		suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
		suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
		tm.moneda, tm.siglas, tm.simbolo,
		usu.dni, usu.nombres,
		mp.mediopago,
		pro.documproveedor, pro.cuitproveedor, pro.nomproveedor, pro.tlfproveedor, 
		pro.id_ciudad AS id_ciudad2, pro.id_comuna AS id_comuna2,
		pro.direcproveedor, pro.emailproveedor, pro.vendedor, pro.tlfvendedor,
		doc.documento, doc2.documento AS documento2, doc3.documento AS documento3,
		pag.articulos, pag.detalles_productos
    FROM 
        compras c LEFT JOIN sucursales suc ON c.codsucursal = suc.codsucursal
	LEFT JOIN 
	    documentos doc ON suc.documsucursal = doc.coddocumento
	LEFT JOIN 
	    documentos AS doc2 ON suc.documencargado = doc2.coddocumento
    LEFT JOIN 
        ciudades ciud ON suc.id_ciudad = ciud.id_ciudad 
    LEFT JOIN 
        comunas com ON suc.id_comuna = com.id_comuna 
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
	LEFT JOIN 
	    proveedores pro ON c.codproveedor = pro.codproveedor
	LEFT JOIN 
	    documentos AS doc3 ON pro.documproveedor = doc3.coddocumento
    LEFT JOIN 
        ciudades ciud2 ON pro.id_ciudad = ciud2.id_ciudad 
    LEFT JOIN 
        comunas com2 ON pro.id_comuna = com2.id_comuna 
    LEFT JOIN 
        mediospagos mp ON c.formacompra = mp.codmediopago
	LEFT JOIN 
	    usuarios usu ON c.codigo = usu.codigo

    LEFT JOIN
        (SELECT
            dc.codcompra,
            SUM(dc.cantcompra) AS articulos,
            GROUP_CONCAT(
            CONCAT_WS(
               ' | ',
               dc.cantcompra,
               dc.producto,
               dc.descripcion,
               IFNULL(mar.nommarca, ''),
               IFNULL(mode.nommodelo, ''),
               IFNULL(pres.nompresentacion, ''),
               IFNULL(col.nomcolor, '')
            )
                ORDER BY dc.producto
                SEPARATOR '<br>'
            ) AS detalles_productos
            FROM
                detallecompras dc
            LEFT JOIN 
                marcas mar ON dc.codmarca = mar.codmarca
		    LEFT JOIN 
		        modelos mode ON dc.codmodelo = mode.codmodelo 
		    LEFT JOIN 
		        presentaciones pres ON dc.codpresentacion = pres.codpresentacion
			LEFT JOIN 
			    colores col ON dc.codcolor = col.codcolor
			WHERE dc.codsucursal = ?
	    GROUP BY
	        dc.codcompra
	    ) pag ON pag.codcompra = c.codcompra";
	$whereConditions[] = "c.tipocompra = 'CREDITO'";
    //Condicion de Sucursal
    if (!empty($codSucursal)) {
        $whereConditions[] = "c.codsucursal = ?";
        $params[]          = $codSucursal;
    }
    //Condicion de Fechas
    if (!empty($fechaDesde) && !empty($fechaHasta)) {
        $whereConditions[] = "DATE_FORMAT(c.fechaemision,'%Y-%m-%d') BETWEEN ? AND ?";
        $params[] = $fechaDesde;
        $params[] = $fechaHasta;
    }
    //Condicion de Estado de Busqueda
    if ($EstadoBusqueda == 2) { // Pagada
        $whereConditions[] = "c.statuscompra = 'PAGADA'";
    } elseif ($EstadoBusqueda == 3) { // Pendiente
        $whereConditions[] = "c.statuscompra = 'PENDIENTE'";
    }
    $whereClause = "";
    if (!empty($whereConditions)) {
        $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $sql = $sqlBase . $whereClause . " ORDER BY c.codcompra ASC";
	try {
	    $stmt = $this->dbh->prepare($sql);
        array_unshift($params, $codSucursal);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
	    if (empty($results)) {
	        echo "<div class='alert alert-danger'>";
	        echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	        echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS PARA TU BÚSQUEDA REALIZADA</center>";
	        echo "</div>";
	        exit();
	    } else {
	        return $results;
	    }
	} catch (PDOException $e) {
	    error_log("Error en BuscarCreditosComprasxFechas: " . $e->getMessage());
	    echo "<div class='alert alert-danger'>";
	    echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	    echo "<center><span class='fa fa-exclamation-triangle'></span> OCURRIÓ UN ERROR AL CONSULTAR LAS VENTAS.</center>";
	    echo "</div>";
	    return [];
	}
}
###################### FUNCION BUSQUEDA CREDITOS DE COMPRAS POR FECHAS ###########################

###################### FUNCION BUSQUEDA DETALLES CREDITOS POR PROVEEDOR ###########################
public function BuscarDetallesCreditosComprasxProveedor() 
{
	$this->p = [];
    $EstadoBusqueda   = isset($_GET['status']) ? decrypt(trim($_GET['status'])) : null;
	$codSucursal      = isset($_GET["codsucursal"]) ? limpiar(decrypt($_GET['codsucursal'])) : '';
    $codProveedorBusqueda = isset($_GET['codproveedor']) ? decrypt(trim($_GET['codproveedor'])) : null;
	$whereConditions  = [];
    $params           = [];

    // Construcción de la subconsulta 'pag' (detallecompras)
    $sqlPag = "(SELECT
        dc.codcompra,
        SUM(dc.cantcompra) AS articulos,
        GROUP_CONCAT(
            CONCAT_WS(
                ' | ',
                dc.cantcompra,
                dc.producto,
                dc.descripcion,
                IFNULL(mar.nommarca, ''),
                IFNULL(mode.nommodelo, ''),
                IFNULL(pres.nompresentacion, ''),
                IFNULL(col.nomcolor, '')
            )
                ORDER BY dc.producto
                SEPARATOR '<br>'
        ) AS detalles_productos
        FROM
            detallecompras dc
        LEFT JOIN marcas mar ON dc.codmarca = mar.codmarca
        LEFT JOIN modelos mode ON dc.codmodelo = mode.codmodelo 
        LEFT JOIN presentaciones pres ON dc.codpresentacion = pres.codpresentacion
        LEFT JOIN colores col ON dc.codcolor = col.codcolor";
    // Condición para la subconsulta pag
    if (!empty($codSucursal)) {
        $sqlPag .= " WHERE dc.codsucursal = :codSucursal_pag";
        $params[':codSucursal_pag'] = $codSucursal;
    }
    $sqlPag .= " GROUP BY dc.codcompra) pag";

    // Construcción de la subconsulta 'pag2' (abonoscreditoscompras)
    $sqlPag2 = "(SELECT
        codcompra,
        GROUP_CONCAT(
            abonc.montoabono, ' | ',
            mp.mediopago, ' | ',
            DATE_FORMAT(abonc.fechaabono, '%d/%m/%Y %H:%i:%s')
            SEPARATOR '<br>'
        ) AS detalles_abonos
        FROM abonoscreditoscompras abonc
        LEFT JOIN mediospagos mp ON abonc.formaabono = mp.codmediopago";
    // Condición para la subconsulta pag2
    if (!empty($codSucursal)) {
        $sqlPag2 .= " WHERE abonc.codsucursal = :codSucursal_pag2";
        $params[':codSucursal_pag2'] = $codSucursal;
    }
    $sqlPag2 .= " GROUP BY abonc.codcompra) pag2";

    $sqlBase = "SELECT
        c.codcompra, c.codfactura, c.codproveedor, c.subtotalivasi, c.subtotalivano, 
        c.iva, c.totaliva, c.descontado, c.descuento, c.totaldescuento, c.totalpago, c.gastoenvio,
        c.creditopagado, c.statuscompra, c.fechavencecredito, c.fechapagado, c.fecharecepcion, c.fechaemision, 
        c.observaciones, c.codsucursal,
		suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
		suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
		tm.moneda, tm.siglas, tm.simbolo,
		usu.dni, usu.nombres,
		mp.mediopago,
		pro.documproveedor, pro.cuitproveedor, pro.nomproveedor, pro.tlfproveedor, 
		pro.id_ciudad AS id_ciudad2, pro.id_comuna AS id_comuna2, 
		pro.direcproveedor, pro.emailproveedor, pro.vendedor, pro.tlfvendedor,
		doc.documento, doc2.documento AS documento2, doc3.documento AS documento3,
		pag.articulos, pag.detalles_productos, pag2.detalles_abonos
    FROM 
        compras c LEFT JOIN sucursales suc ON c.codsucursal = suc.codsucursal
	LEFT JOIN 
	    documentos doc ON suc.documsucursal = doc.coddocumento
	LEFT JOIN 
	    documentos AS doc2 ON suc.documencargado = doc2.coddocumento
    LEFT JOIN 
        ciudades ciud ON suc.id_ciudad = ciud.id_ciudad 
    LEFT JOIN 
        comunas com ON suc.id_comuna = com.id_comuna
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
	LEFT JOIN 
	    proveedores pro ON c.codproveedor = pro.codproveedor
	LEFT JOIN 
	    documentos AS doc3 ON pro.documproveedor = doc3.coddocumento
    LEFT JOIN 
        ciudades ciud2 ON pro.id_ciudad = ciud2.id_ciudad 
    LEFT JOIN 
        comunas com2 ON pro.id_comuna = com2.id_comuna 
    LEFT JOIN 
        mediospagos mp ON c.formacompra = mp.codmediopago
	LEFT JOIN 
	    usuarios usu ON c.codigo = usu.codigo
	LEFT JOIN 
	    $sqlPag ON pag.codcompra = c.codcompra
    LEFT JOIN 
        $sqlPag2 ON c.codcompra = pag2.codcompra";    

	// Las siguientes condiciones son para la cláusula WHERE principal
	$whereConditions[] = "c.tipocompra = 'CREDITO'";

    // Condición de Sucursal
    if (!empty($codSucursal)) {
        $whereConditions[] = "c.codsucursal = :codSucursal_main";
        $params[':codSucursal_main'] = $codSucursal;
    }
    //Condicion de Proveedor
    if (!empty($codProveedorBusqueda)) { // Asegurarse de que codcaja exista
        $whereConditions[] = "c.codproveedor = :codProveedor";
        $params[':codProveedor'] = $codProveedorBusqueda;
    }
    // Condición de Estado de Búsqueda
    if ($EstadoBusqueda == 2) { // Pagada
        $whereConditions[] = "c.statuscompra = 'PAGADA'";
    } elseif ($EstadoBusqueda == 3) { // Pendiente
        $whereConditions[] = "c.statuscompra = 'PENDIENTE'";
    }

    $whereClause = "";
    if (!empty($whereConditions)) {
        $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $sql = $sqlBase . $whereClause . " ORDER BY c.codcompra ASC";
	try {
	    $stmt = $this->dbh->prepare($sql);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
	    if (empty($results)) {
	        echo "<div class='alert alert-danger'>";
	        echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	        echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS PARA TU BÚSQUEDA REALIZADA</center>";
	        echo "</div>";
	        exit();
	    } else {
	        return $results;
	    }
	} catch (PDOException $e) {
	    error_log("Error en BuscarDetallesCreditosComprasxProveedor: " . $e->getMessage());
	    echo "<div class='alert alert-danger'>";
	    echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	    echo "<center><span class='fa fa-exclamation-triangle'></span> OCURRIÓ UN ERROR AL CONSULTAR LAS VENTAS.</center>";
	    echo "</div>";
	    return [];
	}
}
###################### FUNCION BUSQUEDA DETALLES CREDITOS POR PROVEEDOR ###########################

###################### FUNCION BUSQUEDA DETALLES CREDITOS POR FECHAS ###########################
public function BuscarDetallesCreditosComprasxFechas() 
{
	$this->p = [];
    $EstadoBusqueda  = isset($_GET['status']) ? decrypt(trim($_GET['status'])) : null;
	$codSucursal     = isset($_GET["codsucursal"]) ? limpiar(decrypt($_GET['codsucursal'])) : '';
    $fechaDesde      = isset($_GET['desde']) ? limpiar(date("Y-m-d", strtotime($_GET['desde']))) : '';
    $fechaHasta      = isset($_GET['hasta']) ? limpiar(date("Y-m-d", strtotime($_GET['hasta']))) : '';
	$whereConditions = [];
    $params          = [];

    // Construcción de la subconsulta 'pag' (detallecompras)
    $sqlPag = "(SELECT
        dc.codcompra,
        SUM(dc.cantcompra) AS articulos,
        GROUP_CONCAT(
            CONCAT_WS(
                ' | ',
                dc.cantcompra,
                dc.producto,
                dc.descripcion,
                IFNULL(mar.nommarca, ''),
                IFNULL(mode.nommodelo, ''),
                IFNULL(pres.nompresentacion, ''),
                IFNULL(col.nomcolor, '')
            )
                ORDER BY dc.producto
                SEPARATOR '<br>'
        ) AS detalles_productos
        FROM
            detallecompras dc
        LEFT JOIN marcas mar ON dc.codmarca = mar.codmarca
        LEFT JOIN modelos mode ON dc.codmodelo = mode.codmodelo 
        LEFT JOIN presentaciones pres ON dc.codpresentacion = pres.codpresentacion
        LEFT JOIN colores col ON dc.codcolor = col.codcolor";
    // Condición para la subconsulta pag
    if (!empty($codSucursal)) {
        $sqlPag .= " WHERE dc.codsucursal = :codSucursal_pag";
        $params[':codSucursal_pag'] = $codSucursal;
    }
    $sqlPag .= " GROUP BY dc.codcompra) pag";

    // Construcción de la subconsulta 'pag2' (abonoscreditoscompras)
    $sqlPag2 = "(SELECT
        codcompra,
        GROUP_CONCAT(
            abonc.montoabono, ' | ',
            mp.mediopago, ' | ',
            DATE_FORMAT(abonc.fechaabono, '%d/%m/%Y %H:%i:%s')
            SEPARATOR '<br>'
        ) AS detalles_abonos
        FROM abonoscreditoscompras abonc
        LEFT JOIN mediospagos mp ON abonc.formaabono = mp.codmediopago";
    // Condición para la subconsulta pag2
    if (!empty($codSucursal)) {
        $sqlPag2 .= " WHERE abonc.codsucursal = :codSucursal_pag2";
        $params[':codSucursal_pag2'] = $codSucursal;
    }
    $sqlPag2 .= " GROUP BY abonc.codcompra) pag2";

    $sqlBase = "SELECT
        c.codcompra, c.codfactura, c.codproveedor, c.subtotalivasi, c.subtotalivano, 
        c.iva, c.totaliva, c.descontado, c.descuento, c.totaldescuento, c.totalpago, c.gastoenvio,
        c.creditopagado, c.statuscompra, c.fechavencecredito, c.fechapagado, c.fecharecepcion, c.fechaemision, 
        c.observaciones, c.codsucursal,
		suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
		suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
		tm.moneda, tm.siglas, tm.simbolo,
		usu.dni, usu.nombres,
		mp.mediopago,
		pro.documproveedor, pro.cuitproveedor, pro.nomproveedor, pro.tlfproveedor, 
		pro.id_ciudad AS id_ciudad2, pro.id_comuna AS id_comuna2,
		pro.direcproveedor, pro.emailproveedor, pro.vendedor, pro.tlfvendedor,
		doc.documento, doc2.documento AS documento2, doc3.documento AS documento3,
		pag.articulos, pag.detalles_productos, pag2.detalles_abonos
    FROM 
        compras c LEFT JOIN sucursales suc ON c.codsucursal = suc.codsucursal
	LEFT JOIN 
	    documentos doc ON suc.documsucursal = doc.coddocumento
	LEFT JOIN 
	    documentos AS doc2 ON suc.documencargado = doc2.coddocumento
   LEFT JOIN 
        ciudades ciud ON suc.id_ciudad = ciud.id_ciudad 
    LEFT JOIN 
        comunas com ON suc.id_comuna = com.id_comuna 
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
	LEFT JOIN 
	    proveedores pro ON c.codproveedor = pro.codproveedor
	LEFT JOIN 
	    documentos AS doc3 ON pro.documproveedor = doc3.coddocumento
    LEFT JOIN 
        ciudades ciud2 ON pro.id_ciudad = ciud2.id_ciudad 
    LEFT JOIN 
        comunas com2 ON pro.id_comuna = com2.id_comuna
    LEFT JOIN 
        mediospagos mp ON c.formacompra = mp.codmediopago
	LEFT JOIN 
	    usuarios usu ON c.codigo = usu.codigo
	LEFT JOIN 
	    $sqlPag ON pag.codcompra = c.codcompra
    LEFT JOIN 
        $sqlPag2 ON c.codcompra = pag2.codcompra";    
        
	// Las siguientes condiciones son para la cláusula WHERE principal
	$whereConditions[] = "c.tipocompra = 'CREDITO'";

    // Condición de Sucursal
    if (!empty($codSucursal)) {
        $whereConditions[] = "c.codsucursal = :codSucursal_main";
        $params[':codSucursal_main'] = $codSucursal;
    }
    // Condicion de Fechas
    if (!empty($fechaDesde) && !empty($fechaHasta)) {
        $whereConditions[] = "DATE_FORMAT(c.fechaemision,'%Y-%m-%d') BETWEEN :fechaDesde AND :fechaHasta";
        $params[':fechaDesde'] = $fechaDesde;
        $params[':fechaHasta'] = $fechaHasta;
    }
    // Condición de Estado de Búsqueda
    if ($EstadoBusqueda == 2) { // Pagada
        $whereConditions[] = "c.statuscompra = 'PAGADA'";
    } elseif ($EstadoBusqueda == 3) { // Pendiente
        $whereConditions[] = "c.statuscompra = 'PENDIENTE'";
    }

    $whereClause = "";
    if (!empty($whereConditions)) {
        $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $sql = $sqlBase . $whereClause . " ORDER BY c.codcompra ASC";
	try {
	    $stmt = $this->dbh->prepare($sql);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
	    if (empty($results)) {
	        echo "<div class='alert alert-danger'>";
	        echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	        echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS PARA TU BÚSQUEDA REALIZADA</center>";
	        echo "</div>";
	        exit();
	    } else {
	        return $results;
	    }
	} catch (PDOException $e) {
	    error_log("Error en BuscarDetallesCreditosComprasxFechas: " . $e->getMessage());
	    echo "<div class='alert alert-danger'>";
	    echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	    echo "<center><span class='fa fa-exclamation-triangle'></span> OCURRIÓ UN ERROR AL CONSULTAR LAS VENTAS.</center>";
	    echo "</div>";
	    return [];
	}
}
###################### FUNCION BUSQUEDA DETALLES CREDITOS POR FECHAS ###########################

############################# FIN DE CLASE COMPRAS ###################################


















############################## CLASE COTIZACIONES ###################################

########################### FUNCION REGISTRAR COTIZACIONES ##########################
public function RegistrarCotizaciones()
{
	$this->p = [];
	if(empty($_POST["codsucursal"]) or empty($_POST["tipodocumento"]) or empty($_POST["txtTotal"]))
	{
		echo "1";
		exit;
	}
	elseif(empty($_SESSION["CarritoCotizacion"]))
	{
		echo "2";
		exit;
	}

	################### SELECCIONE LOS DATOS DEL CLIENTE ######################
    $sql = "SELECT
    codcliente
    FROM clientes
    WHERE dnicliente = ?
    AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(limpiar($_POST['nrodocumento']),decrypt($_POST["codsucursal"])));
	$num = $stmt->rowCount();
	if($row = $stmt->fetch(PDO::FETCH_ASSOC))
	{
		$p[] = $row;
	}
	$codcliente = (empty($row['codcliente']) ? "0" : $row['codcliente']);
    ################### SELECCIONE LOS DATOS DEL CLIENTE ######################

    ################# OBTENGO DATOS DE SUCURSAL #################
	$sql = " SELECT 
	cuitsucursal, 
	nroactividadsucursal 
	FROM sucursales WHERE codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$cuitsucursal = $row['cuitsucursal'];
	$nroactividad = $row['nroactividadsucursal'];
	################# OBTENGO DATOS DE SUCURSAL #################

	################ CREO CODIGO DE COTIZACION ####################
	$sql = "SELECT codcotizacion FROM cotizaciones 
	ORDER BY idcotizacion DESC LIMIT 1";
	foreach ($this->dbh->query($sql) as $row){

		$cotizacion=$row["codcotizacion"];
	}
	if(empty($cotizacion))
	{
		$codcotizacion = "01";

	} else {

		$num = substr($cotizacion, 0);
        $dig = $num + 1;
        $codigofinal = str_pad($dig, 2, "0", STR_PAD_LEFT);
        $codcotizacion = $codigofinal;
	}
    ################ CREO CODIGO DE COTIZACION ###############

    ################### CREO CODIGO DE FACTURA ####################
	$sql4 = "SELECT codfactura FROM cotizaciones 
	WHERE codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."' 
	ORDER BY idcotizacion DESC LIMIT 1";
	foreach ($this->dbh->query($sql4) as $row4){

		$factura=$row4["codfactura"];
	}
	if(empty($factura))
	{
		$codfactura = "0000001";

	} else {

		$var = strlen("");
        $var1 = substr($factura , $var);
        $var2 = strlen($var1);
        $var3 = $var1 + 1;
        $var4 = str_pad($var3, $var2, "0", STR_PAD_LEFT);
        $codfactura = $var4;
	}
	################### CREO CODIGO DE FACTURA ####################

    ################### REGISTRO LA COTIZACION ####################
    $query = "INSERT INTO cotizaciones values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $codcotizacion);
	$stmt->bindParam(2, $tipodocumento);
	$stmt->bindParam(3, $codfactura);
	$stmt->bindParam(4, $codcliente);
	$stmt->bindParam(5, $subtotalivasi);
	$stmt->bindParam(6, $subtotalivano);
	$stmt->bindParam(7, $iva);
	$stmt->bindParam(8, $totaliva);
	$stmt->bindParam(9, $descontado);
	$stmt->bindParam(10, $descuento);
	$stmt->bindParam(11, $totaldescuento);
	$stmt->bindParam(12, $totalpago);
	$stmt->bindParam(13, $totalpago2);
	$stmt->bindParam(14, $observaciones);
	$stmt->bindParam(15, $fechacotizacion);
	$stmt->bindParam(16, $procesada);
	$stmt->bindParam(17, $codigo);
	$stmt->bindParam(18, $codsucursal);
    
	$tipodocumento = limpiar($_POST["tipodocumento"]);
	$subtotalivasi = limpiar($_POST["txtsubtotal"]);
	$subtotalivano = limpiar($_POST["txtsubtotal2"]);
	$iva = limpiar($_POST["iva"]);
	$totaliva = limpiar($_POST["txtIva"]);
	$descontado = limpiar($_POST["txtdescontado"]);
	$descuento = limpiar($_POST["descuento"]);
	$totaldescuento = limpiar($_POST["txtDescuento"]);
	$totalpago = limpiar($_POST["txtTotal"]);
	$totalpago2 = limpiar($_POST["txtTotalCompra"]);
	$observaciones = limpiar($_POST["observaciones"]);
    $fechacotizacion = limpiar(date("Y-m-d H:i:s"));
	$procesada = limpiar("1");
	$codigo = limpiar($_SESSION["codigo"]);
	$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
	$stmt->execute();
	################### REGISTRO LA COTIZACION ####################
	
	$this->dbh->beginTransaction();
	$detalle = $_SESSION["CarritoCotizacion"];
	for($i=0;$i<count($detalle);$i++){

		################### REGISTRO DETALLES DE COTIZACION ####################
		$query = "INSERT INTO detallecotizaciones values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codcotizacion);
	    $stmt->bindParam(2, $idproducto);
	    $stmt->bindParam(3, $codproducto);
	    $stmt->bindParam(4, $producto);
	    $stmt->bindParam(5, $descripcion);
        $stmt->bindParam(6, $opcionvendido);
	    $stmt->bindParam(7, $imei);
	    $stmt->bindParam(8, $condicion);
	    $stmt->bindParam(9, $codmarca);
	    $stmt->bindParam(10, $codmodelo);
	    $stmt->bindParam(11, $codpresentacion);
	    $stmt->bindParam(12, $codcolor);
		$stmt->bindParam(13, $cantidad);
		$stmt->bindParam(14, $preciocompra);
		$stmt->bindParam(15, $precioventa);
		$stmt->bindParam(16, $ivaproducto);
		$stmt->bindParam(17, $descproducto);
		$stmt->bindParam(18, $valortotal);
		$stmt->bindParam(19, $totaldescuentov);
		$stmt->bindParam(20, $subtotalimpuestos);
		$stmt->bindParam(21, $valorneto);
		$stmt->bindParam(22, $valorneto2);
		$stmt->bindParam(23, $tipodetalle);
		$stmt->bindParam(24, $codsucursal);
			
	    $idproducto      = limpiar($detalle[$i]['tipodetalle'] == "3" ? "0" : $detalle[$i]['id']);
		$codproducto     = limpiar($detalle[$i]['tipodetalle'] == "3" ? "0" : $detalle[$i]['txtCodigo']);
		$producto        = limpiar($detalle[$i]['producto']);
		$descripcion     = limpiar($detalle[$i]['tipodetalle'] == "3" || $detalle[$i]['descripcion'] == "0" ? "" : $detalle[$i]['descripcion']);
		$opcionvendido   = limpiar($detalle[$i]['opcionvendido']);
		$imei            = limpiar($detalle[$i]['tipodetalle'] == "3" || $detalle[$i]['imei'] == "0" ? "" : $detalle[$i]['imei']);
		$condicion       = limpiar($detalle[$i]['tipodetalle'] == "3" || $detalle[$i]['condicion'] == "0" ? "" : $detalle[$i]['condicion']);
		$codmarca        = limpiar($detalle[$i]['tipodetalle'] == "3" ? "0" : $detalle[$i]['codmarca']);
		$codmodelo       = limpiar($detalle[$i]['tipodetalle'] == "3" ? "0" : $detalle[$i]['codmodelo']);
		$codpresentacion = limpiar($detalle[$i]['tipodetalle'] == "3" ? "0" : $detalle[$i]['codpresentacion']);
		$codcolor        = limpiar($detalle[$i]['tipodetalle'] == "3" ? "0" : $detalle[$i]['codcolor']);
		$cantidad        = $detalle[$i]['opcionvendido'] == "2" ? number_format($detalle[$i]['cantidad'], 3, '.', '') : number_format($detalle[$i]['cantidad'], 0, '.', '');
		$preciocompra    = limpiar($detalle[$i]['precio']);
		$precioventa     = limpiar($detalle[$i]['precio2']);
		$precioconiva    = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['precio2']);
		$ivaproducto     = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
		$descproducto    = limpiar($detalle[$i]['descproducto']);
		$descuento       = $detalle[$i]['descproducto']/100;
		$valortotal      = number_format($detalle[$i]['precio2']*$detalle[$i]['cantidad'], 2, '.', '');
		$totaldescuentov = number_format($valortotal*$descuento, 2, '.', '');

		//CALCULO SUBTOTAL IMPUESTOS
		$ValorImpuesto        = 1 + ($_POST["iva"]/100);
		$RestoDescuento       = $precioconiva * $detalle[$i]['descproducto'] / 100;
		$PrecioIvaDescuento   = $precioconiva - $RestoDescuento;
		$Discriminado         = $PrecioIvaDescuento/$ValorImpuesto;
		$SubtotalDiscriminado = $PrecioIvaDescuento - $Discriminado;
	    $BaseDiscriminado     = $SubtotalDiscriminado * $detalle[$i]['cantidad'];
	    $subtotalimpuestos    = number_format($BaseDiscriminado, 2, '.', '');

	    $valorneto      = number_format($valortotal-$totaldescuentov, 2, '.', '');
		$valorneto2     = limpiar($detalle[$i]['tipodetalle'] == "3" ? "0.00" : number_format($detalle[$i]['precio']*$detalle[$i]['cantidad'], 2, '.', ''));
	    $tipodetalle    = limpiar($detalle[$i]['tipodetalle']);
		$codsucursal    = limpiar(decrypt($_POST['codsucursal']));
		$stmt->execute();
		################### REGISTRO DETALLES DE COTIZACION ####################
   }
        
    ####################### DESTRUYO LA VARIABLE DE SESSION #####################
	unset($_SESSION["CarritoCotizacion"]);
    $this->dbh->commit();
		
    echo "<span class='fa fa-check-square-o'></span> LA COTIZACI&Oacute;N DE PRODUCTOS HA SIDO REGISTRADA EXITOSAMENTE <a href='reportepdf?codcotizacion=".encrypt($codcotizacion)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt($tipodocumento)."' class='on-default' data-placement='left' data-toggle='tooltip' data-original-title='Imprimir Documento' target='_black' rel='noopener noreferrer'><font color='black'><strong>IMPRIMIR REPORTE</strong></font color></a></div>";

    echo "<script>VentanaCentrada('reportepdf?codcotizacion=".encrypt($codcotizacion)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt($tipodocumento)."', '', '', '1024', '568', 'true');</script>";
	exit;
}
########################## FUNCION REGISTRAR COTIZACIONES ############################

########################## FUNCION BUSQUEDA DE COTIZACIONES ###############################
public function BusquedaCotizaciones() 
{
	$this->p = [];
	$tipoAcceso      = isset($_SESSION["acceso"]) ? limpiar($_SESSION["acceso"]) : '';
	$codSucursal     = ($tipoAcceso === 'administradorG') ? limpiar(decrypt($_GET["codsucursal"])) : limpiar($_SESSION["codsucursal"]);	
    $codigoUsuario   = isset($_SESSION["codigo"]) ? limpiar($_SESSION["codigo"]) : '';
    $tipoBusqueda    = isset($_GET['tipobusqueda']) ? limpiar($_GET['tipobusqueda']) : '';
    $searchCriterio  = isset($_GET['search_criterio']) ? limpiar($_GET['search_criterio']) : '';
    $fechaDesde      = isset($_GET['desde']) ? limpiar(date("Y-m-d", strtotime($_GET['desde']))) : '';
    $fechaHasta      = isset($_GET['hasta']) ? limpiar(date("Y-m-d", strtotime($_GET['hasta']))) : '';
    $whereConditions = [];
    $params          = [];

    // Lógica de filtro basada en el tipo de acceso
    if ($tipoAcceso === 'cajero' || $tipoAcceso === 'vendedor') { // Acceso Cajero
        $whereConditions[] = "cot.codigo = ?";
        $params[]          = $codigoUsuario;
        $whereConditions[] = "cot.codsucursal = ?";
        $params[]          = $codSucursal;
    } else { // // Acceso Diferente a Cajero
        $whereConditions[] = "cot.codsucursal = ?";
        $params[]          = $codSucursal;
    }

    // Lógica de filtro basada en el tipo de búsqueda (tipobusqueda)
    if ($tipoBusqueda == 2) {//Busqueda por Criterio
      $whereConditions[] = "CONCAT(cot.codcotizacion, ' ',cot.codfactura, ' ',cot.tipodocumento, ' ',cot.totalpago, ' ',IFNULL(cl.dnicliente,'0'), ' ',IFNULL(cl.nomcliente,'0'), ' ',IFNULL(cl.girocliente,'0'), ' ',suc.cuitsucursal, ' ',suc.nomsucursal, ' ',suc.dniencargado, ' ',suc.nomencargado) LIKE ?";
        $params[] = '%' . $searchCriterio . '%';
    } elseif ($tipoBusqueda == 3) {// Busqueda por Fechas
        $whereConditions[] = "DATE_FORMAT(cot.fechacotizacion,'%Y-%m-%d') BETWEEN ? AND ?";
        $params[]          = $fechaDesde;
        $params[]          = $fechaHasta;
    }
    $whereClause = "";
    if (!empty($whereConditions)) {
      $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $sqlBase = "SELECT
        cot.idcotizacion, cot.codcotizacion, cot.tipodocumento, cot.codfactura, cot.codcliente, 
        cot.subtotalivasi, cot.subtotalivano, cot.iva, cot.totaliva, cot.descontado,cot.descuento, 
		cot.totaldescuento, cot.totalpago, cot.totalpago2, cot.observaciones, cot.fechacotizacion, 
		cot.procesada, cot.codigo, cot.codsucursal,
		suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
		suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
		tm.moneda, tm.siglas, tm.simbolo,
		usu.dni, usu.nombres,
		cl.tipocliente, cl.documcliente, cl.dnicliente,
		CONCAT(if(cl.tipocliente='NATURAL',cl.nomcliente,cl.razoncliente)) as nomcliente,
		cl.girocliente, cl.tlfcliente, cl.id_ciudad AS id_ciudad2, cl.id_comuna AS id_comuna2, 
		cl.direccliente, cl.emailcliente, cl.limitecredito,
		doc.documento, doc2.documento AS documento2, doc3.documento AS documento3,
		pag.articulos, pag.detalles_productos
    FROM 
        cotizaciones cot LEFT JOIN sucursales suc ON cot.codsucursal = suc.codsucursal
	LEFT JOIN 
	    documentos doc ON suc.documsucursal = doc.coddocumento
	LEFT JOIN 
	    documentos AS doc2 ON suc.documencargado = doc2.coddocumento
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
	LEFT JOIN 
	    clientes cl ON cot.codcliente = cl.codcliente
	LEFT JOIN 
	    documentos AS doc3 ON cl.documcliente = doc3.coddocumento 
	LEFT JOIN 
	    usuarios usu ON cot.codigo = usu.codigo
    LEFT JOIN
        (SELECT
            dcot.codcotizacion,
            SUM(dcot.cantcotizacion) AS articulos,
            GROUP_CONCAT(
            CONCAT_WS(
               ' | ',
               dcot.cantcotizacion,
               dcot.producto,
               dcot.descripcion,
               IFNULL(mar.nommarca, ''),
               IFNULL(mode.nommodelo, ''),
               IFNULL(pres.nompresentacion, ''),
               IFNULL(col.nomcolor, '')
            )
                ORDER BY dcot.producto
                SEPARATOR '<br>'
            ) AS detalles_productos
            FROM
                detallecotizaciones dcot
            LEFT JOIN 
                marcas mar ON dcot.codmarca = mar.codmarca
		    LEFT JOIN 
		        modelos mode ON dcot.codmodelo = mode.codmodelo 
		    LEFT JOIN 
		        presentaciones pres ON dcot.codpresentacion = pres.codpresentacion
			LEFT JOIN 
			    colores col ON dcot.codcolor = col.codcolor
			WHERE dcot.codsucursal = $codSucursal
	    GROUP BY
	        dcot.codcotizacion
	    ) pag ON pag.codcotizacion = cot.codcotizacion";
    $sql = $sqlBase . $whereClause . " ORDER BY cot.fechacotizacion DESC";
    if ($tipoBusqueda == 2 || $tipoBusqueda == 3) {
        $sql .= " LIMIT 0,3000";
    }
    try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($results)) {
            return [];
        } else {
            return $results;
        }
    } catch (PDOException $e) {
        error_log("Error en BusquedaCotizaciones: " . $e->getMessage());
        echo "<div class='alert alert-danger'>";
        echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
        echo "<center><span class='fa fa-exclamation-triangle'></span> OCURRIÓ UN ERROR AL PROCESAR LA BÚSQUEDA. POR FAVOR, INTENTALO MAS TARDE.</center>";
        echo "</div>";
        return [];
    }
}
########################## FUNCION BUSQUEDA DE COTIZACIONES ###############################

####################### FUNCION LISTAR COTIZACIONES ################################
public function ListarCotizaciones()
{
	$this->p = [];
	$tipoAcceso      = isset($_SESSION["acceso"]) ? limpiar($_SESSION["acceso"]) : '';
	$codSucursal     = ($tipoAcceso === 'administradorG') ? limpiar(decrypt($_GET["codsucursal"])) : limpiar($_SESSION["codsucursal"]);	
    $codigoUsuario   = isset($_SESSION["codigo"]) ? limpiar($_SESSION["codigo"]) : '';
    $whereConditions = [];
    $params          = [];

    // Lógica de filtro basada en el tipo de acceso
    if ($tipoAcceso === 'cajero' || $tipoAcceso === 'vendedor') { // Acceso Cajero
        $whereConditions[] = "cot.codigo = ?";
        $params[]          = $codigoUsuario;
        $whereConditions[] = "cot.codsucursal = ?";
        $params[]          = $codSucursal;
    } else { // // Acceso Diferente a Cajero
        $whereConditions[] = "cot.codsucursal = ?";
        $params[]          = $codSucursal;
    }
   
    $whereClause = "";
    if (!empty($whereConditions)) {
      $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $sqlBase = "SELECT
        cot.idcotizacion, cot.codcotizacion, cot.tipodocumento, cot.codfactura, cot.codcliente, 
        cot.subtotalivasi, cot.subtotalivano, cot.iva, cot.totaliva, cot.descontado,cot.descuento, 
		cot.totaldescuento, cot.totalpago, cot.totalpago2, cot.observaciones, cot.fechacotizacion, 
		cot.procesada, cot.codigo, cot.codsucursal,
		suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
		suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
		tm.moneda, tm.siglas, tm.simbolo,
		usu.dni, usu.nombres,
		cl.tipocliente, cl.documcliente, cl.dnicliente,
		CONCAT(if(cl.tipocliente='NATURAL',cl.nomcliente,cl.razoncliente)) as nomcliente,
		cl.girocliente, cl.tlfcliente, cl.id_ciudad AS id_ciudad2, cl.id_comuna AS id_comuna2, 
		cl.direccliente, cl.emailcliente, cl.limitecredito,
		doc.documento, doc2.documento AS documento2, doc3.documento AS documento3,
		pag.articulos, pag.detalles_productos
    FROM 
        cotizaciones cot LEFT JOIN sucursales suc ON cot.codsucursal = suc.codsucursal
	LEFT JOIN 
	    documentos doc ON suc.documsucursal = doc.coddocumento
	LEFT JOIN 
	    documentos AS doc2 ON suc.documencargado = doc2.coddocumento
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
	LEFT JOIN 
	    clientes cl ON cot.codcliente = cl.codcliente
	LEFT JOIN 
	    documentos AS doc3 ON cl.documcliente = doc3.coddocumento 
	LEFT JOIN 
	    usuarios usu ON cot.codigo = usu.codigo
    LEFT JOIN
        (SELECT
            dcot.codcotizacion,
            SUM(dcot.cantcotizacion) AS articulos,
            GROUP_CONCAT(
            CONCAT_WS(
               ' | ',
               dcot.cantcotizacion,
               dcot.producto,
               dcot.descripcion,
               IFNULL(mar.nommarca, ''),
               IFNULL(mode.nommodelo, ''),
               IFNULL(pres.nompresentacion, ''),
               IFNULL(col.nomcolor, '')
            )
                ORDER BY dcot.producto
                SEPARATOR '<br>'
            ) AS detalles_productos
            FROM
                detallecotizaciones dcot
            LEFT JOIN 
                marcas mar ON dcot.codmarca = mar.codmarca
		    LEFT JOIN 
		        modelos mode ON dcot.codmodelo = mode.codmodelo 
		    LEFT JOIN 
		        presentaciones pres ON dcot.codpresentacion = pres.codpresentacion
			LEFT JOIN 
			    colores col ON dcot.codcolor = col.codcolor
			WHERE dcot.codsucursal = $codSucursal
	    GROUP BY
	        dcot.codcotizacion
	    ) pag ON pag.codcotizacion = cot.codcotizacion";
    $sql = $sqlBase . $whereClause . " ORDER BY cot.fechacotizacion DESC";
    try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($results)) {
            return [];
        } else {
            return $results;
        }
    } catch (PDOException $e) {
        error_log("Error en ListarCotizaciones: " . $e->getMessage());
        return [];
    }
}
######################### FUNCION LISTAR COTIZACIONES ############################

############################ FUNCION ID COTIZACIONES #################################
public function CotizacionesPorId()
{
    $this->p       = [];
    $codCotizacion = isset($_GET["codcotizacion"]) ? limpiar(decrypt($_GET["codcotizacion"])) : '';
    $codSucursal   = isset($_GET["codsucursal"]) ? limpiar(decrypt($_GET["codsucursal"])) : '';
    $sql = "SELECT
        cot.*,
        suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.codgiro, suc.girosucursal,
        suc.tlfsucursal, suc.correosucursal, suc.id_ciudad, suc.id_comuna, suc.direcsucursal,
        suc.nroactividadsucursal, suc.fechaautorsucursal, suc.llevacontabilidad, suc.documencargado, 
        suc.dniencargado, suc.nomencargado, suc.tlfencargado, suc.fechaautorsucursal, suc.llevacontabilidad, 
        suc.codmoneda,suc.codmoneda2, suc.membrete,
        tm.moneda, tm.siglas, tm.simbolo,
        tm2.moneda AS moneda2, tm2.siglas AS siglas2, tm2.simbolo AS simbolo2,
        valor_cambio.montocambio,
        cl.tipocliente, cl.documcliente, cl.dnicliente,
		CONCAT(if(cl.tipocliente='NATURAL',cl.nomcliente,cl.razoncliente)) as nomcliente,
		cl.girocliente, cl.tlfcliente, cl.id_ciudad AS id_ciudad2, cl.id_comuna AS id_comuna2, 
		cl.direccliente, cl.emailcliente, cl.limitecredito,
        doc.documento, doc2.documento AS documento2, doc3.documento AS documento3,
        usu.dni, usu.nombres,
        ciud.ciudad, com.comuna, ciud2.ciudad AS ciudad2, com2.comuna AS comuna2,
        pag.articulos
    FROM 
        cotizaciones cot LEFT JOIN sucursales suc ON cot.codsucursal = suc.codsucursal
    LEFT JOIN 
        documentos doc ON suc.documsucursal = doc.coddocumento
    LEFT JOIN 
        documentos doc2 ON suc.documencargado = doc2.coddocumento
    LEFT JOIN 
        ciudades ciud ON suc.id_ciudad = ciud.id_ciudad 
    LEFT JOIN 
        comunas com ON suc.id_comuna = com.id_comuna 
    LEFT JOIN 
        tiposmoneda tm ON suc.codmoneda = tm.codmoneda
    LEFT JOIN 
        tiposmoneda tm2 ON suc.codmoneda2 = tm2.codmoneda
    LEFT JOIN 
        clientes cl ON cot.codcliente = cl.codcliente
    LEFT JOIN 
        documentos AS doc3 ON cl.documcliente = doc3.coddocumento
    LEFT JOIN 
        ciudades ciud2 ON cl.id_ciudad = ciud2.id_ciudad
    LEFT JOIN 
        comunas com2 ON cl.id_comuna = com2.id_comuna  
    LEFT JOIN 
        usuarios usu ON cot.codigo = usu.codigo
    LEFT JOIN
        (SELECT
            dcot.codcotizacion,
            SUM(dcot.cantcotizacion) AS articulos
            FROM
                detallecotizaciones dcot
            WHERE dcot.codsucursal = :codSucursal1
        GROUP BY
            dcot.codcotizacion
        ) pag ON pag.codcotizacion = cot.codcotizacion

    LEFT JOIN
       (SELECT
       codcambio, descripcioncambio, montocambio, codmoneda       
       FROM tiposcambio
       ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = suc.codmoneda2
    WHERE cot.codcotizacion = :codCotizacion AND cot.codsucursal = :codSucursal2 LIMIT 1";
    try {
        $stmt = $this->dbh->prepare($sql);
        // Asignamos los parámetros a los marcadores de posición con nombre
        $stmt->bindParam(':codCotizacion', $codCotizacion);
        $stmt->bindParam(':codSucursal1', $codSucursal);
        $stmt->bindParam(':codSucursal2', $codSucursal);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        if (!$row) {
            echo "<div class='alert alert-danger'>";
            echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
            echo "<center><span class='fa fa-info-circle'></span> COTIZACION NO ENCONTRADA.</center>";
            echo "</div>";
            exit();
        } else {
            $this->p[] = $row;
            return $this->p;
        }
    } catch (PDOException $e) {
        error_log("Error en CotizacionesPorId: " . $e->getMessage());
        echo "<div class='alert alert-danger'>";
        echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
        echo "<center><span class='fa fa-exclamation-triangle'></span> OCURRIÓ UN ERROR AL CONSULTAR LA COTIZACION.</center>";
        echo "</div>";
        return [];
    }
}
############################ FUNCION ID COTIZACIONES #################################
	
######################## FUNCION VER DETALLES COTIZACIONES ############################
public function VerDetallesCotizaciones()
{
	$this->p       = [];
	$codCotizacion = isset($_GET["codcotizacion"]) ? limpiar(decrypt($_GET["codcotizacion"])) : '';
    $codSucursal   = isset($_GET["codsucursal"]) ? limpiar(decrypt($_GET["codsucursal"])) : '';
    $sql = "SELECT
	dcot.*,
	ma.nommarca,
	mo.nommodelo,
	pr.nompresentacion,
	co.nomcolor
	FROM
	    detallecotizaciones dcot
	LEFT JOIN 
	    marcas ma ON dcot.codmarca = ma.codmarca
	LEFT JOIN 
	    modelos mo ON dcot.codmodelo = mo.codmodelo 
	LEFT JOIN 
	    presentaciones pr ON dcot.codpresentacion = pr.codpresentacion
	LEFT JOIN 
	    colores co ON dcot.codcolor = co.codcolor 
	WHERE dcot.codcotizacion = ? AND dcot.codsucursal = ?";
	try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute([$codCotizacion,$codSucursal]);
        $this->p = $stmt->fetchAll(PDO::FETCH_ASSOC);
        return $this->p;
    } catch (PDOException $e) {
        // Manejo de errores: registra el error y devuelve un array vacío
        error_log("Error en VerDetallesCotizaciones: " . $e->getMessage() . " SQL: " . $sql . " Params: " . json_encode([$codCotizacion,$codSucursal]));
        return [];
    }
}
##################### FUNCION VER DETALLES COTIZACIONES #########################

######################## FUNCION ACTUALIZAR COTIZACIONES #######################
public function ActualizarCotizaciones()
{
	$this->p = [];
	if(empty($_POST["codcotizacion"]) or empty($_POST["codsucursal"]) or empty($_POST["tipodocumento"]))
	{
		echo "1";
		exit;
	}

	for($i=0;$i<count($_POST['coddetallecotizacion']);$i++){  //recorro el array
        if (!empty($_POST['coddetallecotizacion'][$i])) {

	        if($_POST['cantcotizacion'][$i]==0){

		        echo "2";
		        exit();
	        }
        }
    }

	################### SELECCIONE LOS DATOS DEL CLIENTE ######################
    $sql = "SELECT
    codcliente
    FROM clientes
    WHERE dnicliente = ?
    AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(limpiar($_POST['nrodocumento']),decrypt($_POST["codsucursal"])));
	$num = $stmt->rowCount();
	if($row = $stmt->fetch(PDO::FETCH_ASSOC))
	{
		$p[] = $row;
	}
	$codcliente = (empty($row['codcliente']) ? "0" : $row['codcliente']);
    ################### SELECCIONE LOS DATOS DEL CLIENTE ######################

    $this->dbh->beginTransaction();
	for($i=0;$i<count($_POST['coddetallecotizacion']);$i++){  //recorro el array
	if (!empty($_POST['coddetallecotizacion'][$i])) {

	$sql = "SELECT cantcotizacion 
	FROM detallecotizaciones 
	WHERE coddetallecotizacion = '".limpiar($_POST['coddetallecotizacion'][$i])."' 
	AND codcotizacion = '".limpiar(decrypt($_POST["codcotizacion"]))."' 
	AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$cantidadbd = $row['cantcotizacion'];

	if($cantidadbd != $_POST['cantcotizacion'][$i]){

		################### ACTUALIZO DETALLES DE COTIZACION ####################
		$query = "UPDATE detallecotizaciones set"
		." cantcotizacion = ?, "
		." valortotal = ?, "
		." totaldescuentov = ?, "
	    ." subtotalimpuestos = ?, "
		." valorneto = ?, "
		." valorneto2 = ? "
		." WHERE "
		." coddetallecotizacion = ? AND codcotizacion = ? AND codsucursal = ?;
		";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $cantcotizacion);
		$stmt->bindParam(2, $valortotal);
		$stmt->bindParam(3, $totaldescuentov);
	    $stmt->bindParam(4, $subtotalimpuestos);
		$stmt->bindParam(5, $valorneto);
		$stmt->bindParam(6, $valorneto2);
		$stmt->bindParam(7, $coddetallecotizacion);
		$stmt->bindParam(8, $codcotizacion);
		$stmt->bindParam(9, $codsucursal);

		$cantcotizacion       = $_POST['opcionvendido'][$i] == "2" ? number_format($_POST['cantcotizacion'][$i], 3, '.', '') : number_format($_POST['cantcotizacion'][$i], 0, '.', '');  
		$preciocompra         = limpiar($_POST['preciocompra'][$i]);
		$precioventa          = limpiar($_POST['precioventa'][$i]);
		$ivaproducto          = limpiar($_POST['ivaproducto'][$i]);
		$descuento            = $_POST['descproducto'][$i]/100;
		$valortotal           = number_format($_POST['valortotal'][$i], 2, '.', '');
		$totaldescuento       = number_format($_POST['totaldescuentov'][$i], 2, '.', '');
		$subtotalimpuestos    = number_format($_POST['subtotalimpuestos'][$i], 0, '.', '');
		$valorneto            = number_format($_POST['valorneto'][$i], 2, '.', '');
		$valorneto2           = number_format($_POST['valorneto2'][$i], 2, '.', '');
		$coddetallecotizacion = limpiar($_POST['coddetallecotizacion'][$i]);
		$codcotizacion        = limpiar(decrypt($_POST["codcotizacion"]));
		$codsucursal          = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();
		################### ACTUALIZO DETALLES DE COTIZACION ####################

			} else {

	           echo "";
		    }
        }
    }
    $this->dbh->commit();

    ############ SUMO LOS IMPORTE DE PRODUCTOS CON IVA ##############
	$sql3 = "SELECT SUM(totaldescuentov) AS totaldescuentosi, SUM(subtotalimpuestos) AS subtotalimpuestos, SUM(valorneto-subtotalimpuestos) AS valorneto, SUM(valorneto2) AS valorneto2 FROM detallecotizaciones WHERE codcotizacion = '".limpiar(decrypt($_POST["codcotizacion"]))."' AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."' AND ivaproducto != '0.00'";
	foreach ($this->dbh->query($sql3) as $row3)
	{
		$this->p[] = $row3;
	}
	$subtotaldescuentosi = ($row3['totaldescuentosi']== "" ? "0.00" : $row3['totaldescuentosi']);
	$subtotalimpuestos   = ($row3['subtotalimpuestos']== "" ? "0.00" : $row3['subtotalimpuestos']);
	$subtotalivasi       = ($row3['valorneto']== "" ? "0.00" : $row3['valorneto']);
	$subtotalivasi2      = ($row3['valorneto2']== "" ? "0.00" : $row3['valorneto2']);
	############ SUMO LOS IMPORTE DE PRODUCTOS CON IVA ##############

    ############ SUMO LOS IMPORTE DE PRODUCTOS SIN IVA ##############
	$sql4 = "SELECT SUM(totaldescuentov) AS totaldescuentono, SUM(valorneto) AS valorneto, SUM(valorneto2) AS valorneto2 FROM detallecotizaciones WHERE codcotizacion = '".limpiar(decrypt($_POST["codcotizacion"]))."' AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."' AND ivaproducto = '0.00'";
	foreach ($this->dbh->query($sql4) as $row4)
	{
		$this->p[] = $row4;
	}
	$subtotaldescuentono = ($row4['totaldescuentono']== "" ? "0.00" : $row4['totaldescuentono']);
	$subtotalivano       = ($row4['valorneto']== "" ? "0.00" : $row4['valorneto']);
	$subtotalivano2      = ($row4['valorneto2']== "" ? "0.00" : $row4['valorneto2']);
	############ SUMO LOS IMPORTE DE PRODUCTOS SIN IVA ##############

    ################### ACTUALIZO COTIZACION ####################
	$sql = " UPDATE cotizaciones SET "
	." tipodocumento = ?, "
	." codcliente = ?, "
	." observaciones = ?, "
	." subtotalivasi = ?, "
	." subtotalivano = ?, "
	." totaliva = ?, "
	." descontado = ?, "
	." descuento = ?, "
	." totaldescuento = ?, "
	." totalpago = ?, "
	." totalpago2= ? "
	." WHERE "
	." codcotizacion = ? AND codsucursal = ?;
	";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $tipodocumento);
	$stmt->bindParam(2, $codcliente);
	$stmt->bindParam(3, $observaciones);
	$stmt->bindParam(4, $subtotalivasi);
	$stmt->bindParam(5, $subtotalivano);
	$stmt->bindParam(6, $totaliva);
	$stmt->bindParam(7, $descontado);
	$stmt->bindParam(8, $descuento);
	$stmt->bindParam(9, $totaldescuento);
	$stmt->bindParam(10, $totalpago);
	$stmt->bindParam(11, $totalpago2);
	$stmt->bindParam(12, $codcotizacion);
	$stmt->bindParam(13, $codsucursal);

	$tipodocumento  = limpiar($_POST["tipodocumento"]);
	$observaciones  = limpiar($_POST["observaciones"]);
	$subtotalivasi  = number_format($_POST["txtsubtotal"], 2, '.', '');
	$subtotalivano  = number_format($_POST["txtsubtotal2"], 2, '.', '');
	$totaliva       = number_format($_POST["txtIva"], 2, '.', '');
	$descontado     = number_format($_POST["txtdescontado"], 2, '.', '');
	$descuento      = limpiar($_POST["descuento"]);
    $totaldescuento = number_format($_POST["txtDescuento"], 2, '.', '');
    $totalpago      = number_format($_POST["txtTotal"], 2, '.', '');
    $totalpago2     = number_format($_POST["txtTotalCompra"], 2, '.', '');
	$codcotizacion  = limpiar(decrypt($_POST["codcotizacion"]));
	$codsucursal    = limpiar(decrypt($_POST["codsucursal"]));
	$stmt->execute();
	################### ACTUALIZO COTIZACION ####################

   echo "<span class='fa fa-check-square-o'></span> LA COTIZACI&Oacute;N DE PRODUCTOS HA SIDO ACTUALIZADA EXITOSAMENTE <a href='reportepdf?codcotizacion=".encrypt($codcotizacion)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt($tipodocumento)."' class='on-default' data-placement='left' data-toggle='tooltip' data-original-title='Imprimir Documento' target='_black' rel='noopener noreferrer'><font color='black'><strong>IMPRIMIR REPORTE</strong></font color></a></div>";

   echo "<script>VentanaCentrada('reportepdf?codcotizacion=".encrypt($codcotizacion)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt($tipodocumento)."', '', '', '1024', '568', 'true');</script>";
	exit;
}
####################### FUNCION ACTUALIZAR COTIZACIONES ############################

####################### FUNCION AGREGAR DETALLES COTIZACIONES ########################
public function AgregarDetallesCotizaciones()
{
	$this->p = [];
	if(empty($_POST["codcotizacion"]) or empty($_POST["codsucursal"]) or empty($_POST["tipodocumento"]))
	{
		echo "1";
		exit;
	}
    elseif(empty($_SESSION["CarritoCotizacion"]))
	{
		echo "2";
		exit;
	}

	################### SELECCIONE LOS DATOS DEL CLIENTE ######################
    $sql = "SELECT
    codcliente
    FROM clientes
    WHERE dnicliente = ?
    AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(limpiar($_POST['nrodocumento']),decrypt($_POST["codsucursal"])));
	$num = $stmt->rowCount();
	if($row = $stmt->fetch(PDO::FETCH_ASSOC))
	{
		$p[] = $row;
	}
	$codcliente = (empty($row['codcliente']) ? "0" : $row['codcliente']);
    ################### SELECCIONE LOS DATOS DEL CLIENTE ######################

    ############ CONSULTO TOTAL ACTUAL DE COTIZACION ##############
	$sql = "SELECT
	descuento,
	totalpago 
	FROM cotizaciones 
	WHERE codcotizacion = '".limpiar(decrypt($_POST["codcotizacion"]))."' 
	AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$descuentobd = $row['descuento'];
	$totalpagobd = $row['totalpago'];
	############ CONSULTO TOTAL ACTUAL DE COTIZACION ##############

    $this->dbh->beginTransaction();
    $detalle = $_SESSION["CarritoCotizacion"];
	for($i=0;$i<count($detalle);$i++){

	$sql = "SELECT codcotizacion, codproducto 
	FROM detallecotizaciones 
	WHERE codcotizacion = '".limpiar(decrypt($_POST['codcotizacion']))."' 
	AND codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."' 
	AND idproducto = '".limpiar($detalle[$i]['id'])."' 
	AND codproducto = '".limpiar($detalle[$i]['txtCodigo'])."'";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num == 0)
	{
        ################### REGISTRO DETALLES DE COTIZACION ####################
        $query = "INSERT INTO detallecotizaciones values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
        $stmt = $this->dbh->prepare($query);
        $stmt->bindParam(1, $codcotizacion);
        $stmt->bindParam(2, $idproducto);
        $stmt->bindParam(3, $codproducto);
        $stmt->bindParam(4, $producto);
	    $stmt->bindParam(5, $descripcion);
	    $stmt->bindParam(6, $opcionvendido);
	    $stmt->bindParam(7, $imei);
	    $stmt->bindParam(8, $condicion);
        $stmt->bindParam(9, $codmarca);
        $stmt->bindParam(10, $codmodelo);
        $stmt->bindParam(11, $codpresentacion);
	    $stmt->bindParam(12, $codcolor);
        $stmt->bindParam(13, $cantidad);
        $stmt->bindParam(14, $preciocompra);
        $stmt->bindParam(15, $precioventa);
        $stmt->bindParam(16, $ivaproducto);
        $stmt->bindParam(17, $descproducto);
        $stmt->bindParam(18, $valortotal);
        $stmt->bindParam(20, $totaldescuentov);
        $stmt->bindParam(21, $subtotalimpuestos);
        $stmt->bindParam(22, $valorneto);
        $stmt->bindParam(23, $valorneto2);
        $stmt->bindParam(24, $tipodetalle);
        $stmt->bindParam(25, $codsucursal);
			
		$codcotizacion   = limpiar(decrypt($_POST["codcotizacion"]));
		$idproducto      = limpiar($detalle[$i]['tipodetalle'] == "3" ? "0" : $detalle[$i]['id']);
		$codproducto     = limpiar($detalle[$i]['tipodetalle'] == "3" ? "0" : $detalle[$i]['txtCodigo']);
		$producto        = limpiar($detalle[$i]['producto']);
		$descripcion     = limpiar($detalle[$i]['tipodetalle'] == "3" || $detalle[$i]['descripcion'] == "0" ? "" : $detalle[$i]['descripcion']);
		$opcionvendido   = limpiar($detalle[$i]['opcionvendido']);
		$imei            = limpiar($detalle[$i]['tipodetalle'] == "3" || $detalle[$i]['imei'] == "0" ? "" : $detalle[$i]['imei']);
		$condicion       = limpiar($detalle[$i]['tipodetalle'] == "3" || $detalle[$i]['condicion'] == "0" ? "" : $detalle[$i]['condicion']);
		$codmarca        = limpiar($detalle[$i]['tipodetalle'] == "3" ? "0" : $detalle[$i]['codmarca']);
		$codmodelo       = limpiar($detalle[$i]['tipodetalle'] == "3" ? "0" : $detalle[$i]['codmodelo']);
		$codpresentacion = limpiar($detalle[$i]['tipodetalle'] == "3" ? "0" : $detalle[$i]['codpresentacion']);
		$codcolor        = limpiar($detalle[$i]['tipodetalle'] == "3" ? "0" : $detalle[$i]['codcolor']);
		$cantidad        = $detalle[$i]['opcionvendido'] == "2" ? number_format($detalle[$i]['cantidad'], 3, '.', '') : number_format($detalle[$i]['cantidad'], 0, '.', '');
		$preciocompra    = limpiar($detalle[$i]['precio']);
		$precioventa     = limpiar($detalle[$i]['precio2']);
		$precioconiva    = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['precio2']);
		$ivaproducto     = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
		$descproducto    = limpiar($detalle[$i]['descproducto']);
		$descuento       = $detalle[$i]['descproducto']/100;
		$valortotal      = number_format($detalle[$i]['precio2']*$detalle[$i]['cantidad'], 2, '.', '');
		$totaldescuentov = number_format($valortotal*$descuento, 2, '.', '');

		//CALCULO SUBTOTAL IMPUESTOS
		$ValorImpuesto        = 1 + ($_POST["iva"]/100);
		$RestoDescuento       = $precioconiva * $detalle[$i]['descproducto'] / 100;
		$PrecioIvaDescuento   = $precioconiva - $RestoDescuento;
		$Discriminado         = $PrecioIvaDescuento/$ValorImpuesto;
		$SubtotalDiscriminado = $PrecioIvaDescuento - $Discriminado;
	    $BaseDiscriminado     = $SubtotalDiscriminado * $detalle[$i]['cantidad'];
	    $subtotalimpuestos    = number_format($BaseDiscriminado, 2, '.', '');

	    $valorneto      = number_format($valortotal-$totaldescuentov, 2, '.', '');
		$valorneto2     = limpiar($detalle[$i]['tipodetalle'] == "3" ? "0.00" : number_format($detalle[$i]['precio']*$detalle[$i]['cantidad'], 2, '.', ''));
	    $tipodetalle    = limpiar($detalle[$i]['tipodetalle']);
		$codsucursal    = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();
		################### REGISTRO DETALLES DE COTIZACION ####################

	} else {

	  	$sql = "SELECT cantcotizacion 
	  	FROM detallecotizaciones 
	  	WHERE codcotizacion = '".limpiar(decrypt($_POST['codcotizacion']))."' 
	  	AND codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."'
	    AND idproducto = '".limpiar($detalle[$i]['id'])."' 
	  	AND codproducto = '".limpiar($detalle[$i]['txtCodigo'])."'";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		$cantidad = $row['cantcotizacion'];

	  	################### ACTUALIZO DETALLES DE COTIZACION ####################
	  	$query = "UPDATE detallecotizaciones set"
		." cantcotizacion = ?, "
		." descproducto = ?, "
		." valortotal = ?, "
		." totaldescuentov = ?, "
		." subtotalimpuestos = ?, "
		." valorneto = ?, "
		." valorneto2 = ? "
		." WHERE "
		." codcotizacion = ? AND codsucursal = ? AND idproducto = ? AND codproducto = ?;
		";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $cantcotizacion);
		$stmt->bindParam(2, $descproducto);
		$stmt->bindParam(3, $valortotal);
		$stmt->bindParam(4, $totaldescuentov);
		$stmt->bindParam(5, $subtotalimpuestos);
		$stmt->bindParam(6, $valorneto);
		$stmt->bindParam(7, $valorneto2);
		$stmt->bindParam(8, $codcotizacion);
		$stmt->bindParam(9, $codsucursal);
		$stmt->bindParam(10, $idproducto);
		$stmt->bindParam(11, $codproducto);

		$cantcotizacion   = $detalle[$i]['opcionvendido'] == "2" ? number_format($detalle[$i]['cantidad']+$cantidad, 3, '.', '') : number_format($detalle[$i]['cantidad']+$cantidad, 0, '.', '');
		$preciocompra     = limpiar($detalle[$i]['precio']);
		$precioventa      = limpiar($detalle[$i]['precio2']);
		$precioconiva     = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['precio2']);
	    $ivaproducto      = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
		$descproducto     = limpiar($detalle[$i]['descproducto']);
		$descuento        = $detalle[$i]['descproducto']/100;
		$valortotal       = number_format($detalle[$i]['precio2'] * $cantcotizacion, 2, '.', '');
		$totaldescuentov  = number_format($valortotal * $descuento, 2, '.', '');

		//CALCULO SUBTOTAL IMPUESTOS
		$ValorImpuesto        = 1 + ($_POST["iva"]/100);
		$RestoDescuento       = $precioconiva * $detalle[$i]['descproducto'] / 100;
		$PrecioIvaDescuento   = $precioconiva - $RestoDescuento;
		$Discriminado         = $PrecioIvaDescuento/$ValorImpuesto;
		$SubtotalDiscriminado = $PrecioIvaDescuento - $Discriminado;
		$BaseDiscriminado     = $SubtotalDiscriminado * $cantventa;
		$subtotalimpuestos    = number_format($BaseDiscriminado, 2, '.', '');

		$valorneto       = number_format($valortotal - $totaldescuentov, 2, '.', '');
		$valorneto2      = limpiar($detalle[$i]['tipodetalle'] == "3" ? "0.00" : number_format($detalle[$i]['precio']*$cantcotizacion, 2, '.', ''));
		$codcotizacion        = limpiar(decrypt($_POST["codcotizacion"]));
		$codsucursal     = limpiar(decrypt($_POST["codsucursal"]));
		$idproducto      = limpiar($detalle[$i]['id']);
		$codproducto     = limpiar($detalle[$i]['txtCodigo']);
		$stmt->execute();
		################### ACTUALIZO DETALLES DE COTIZACION ####################
	   }
    }    
    ####################### DESTRUYO LA VARIABLE DE SESSION #####################
	unset($_SESSION["CarritoCotizacion"]);
    $this->dbh->commit();

        ############ SUMO LOS IMPORTE DE PRODUCTOS CON IVA ##############
        $sql3 = "SELECT SUM(totaldescuentov) AS totaldescuentosi, SUM(subtotalimpuestos) AS subtotalimpuestos, SUM(valorneto-subtotalimpuestos) AS valorneto, SUM(valorneto2) AS valorneto2 FROM detallecotizaciones WHERE codcotizacion = '".limpiar(decrypt($_POST["codcotizacion"]))."' AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."' AND ivaproducto != '0.00'";
        foreach ($this->dbh->query($sql3) as $row3)
        {
     	   $this->p[] = $row3;
        }
        $subtotaldescuentosi = ($row3['totaldescuentosi']== "" ? "0.00" : $row3['totaldescuentosi']);
        $subtotalimpuestos   = ($row3['subtotalimpuestos']== "" ? "0.00" : $row3['subtotalimpuestos']);
        $subtotalivasi       = ($row3['valorneto']== "" ? "0.00" : $row3['valorneto']);
        $subtotalivasi2      = ($row3['valorneto2']== "" ? "0.00" : $row3['valorneto2']);
        ############ SUMO LOS IMPORTE DE PRODUCTOS CON IVA ##############

	    ############ SUMO LOS IMPORTE DE PRODUCTOS SIN IVA ##############
        $sql4 = "SELECT SUM(totaldescuentov) AS totaldescuentono, SUM(valorneto) AS valorneto, SUM(valorneto2) AS valorneto2 FROM detallecotizaciones WHERE codcotizacion = '".limpiar(decrypt($_POST["codcotizacion"]))."' AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."' AND ivaproducto = '0.00'";
        foreach ($this->dbh->query($sql4) as $row4)
        {
     	   $this->p[] = $row4;
        }
        $subtotaldescuentono = ($row4['totaldescuentono']== "" ? "0.00" : $row4['totaldescuentono']);
        $subtotalivano       = ($row4['valorneto']== "" ? "0.00" : $row4['valorneto']);
        $subtotalivano2      = ($row4['valorneto2']== "" ? "0.00" : $row4['valorneto2']);
        ############ SUMO LOS IMPORTE DE PRODUCTOS SIN IVA ##############

        ################### ACTUALIZO LA COTIZACION ####################
        $sql = " UPDATE cotizaciones SET "
	    ." tipodocumento = ?, "
        ." codcliente = ?, "
        ." observaciones = ?, "
        ." subtotalivasi = ?, "
        ." subtotalivano = ?, "
        ." totaliva = ?, "
        ." descontado = ?, "
        ." descuento = ?, "
        ." totaldescuento = ?, "
        ." totalpago = ?, "
        ." totalpago2= ? "
        ." WHERE "
        ." codcotizacion = ? AND codsucursal = ?;
        ";
        $stmt = $this->dbh->prepare($sql);
	    $stmt->bindParam(1, $tipodocumento);
        $stmt->bindParam(2, $codcliente);
        $stmt->bindParam(3, $observaciones);
        $stmt->bindParam(4, $subtotalivasi);
        $stmt->bindParam(5, $subtotalivano);
        $stmt->bindParam(6, $totaliva);
        $stmt->bindParam(7, $descontado);
        $stmt->bindParam(8, $descuento);
        $stmt->bindParam(9, $totaldescuento);
        $stmt->bindParam(10, $totalpago);
        $stmt->bindParam(11, $totalpago2);
        $stmt->bindParam(12, $codcotizacion);
        $stmt->bindParam(13, $codsucursal);

        $tipodocumento = limpiar($_POST["tipodocumento"]);
        $observaciones = limpiar($_POST["observaciones"]);
        $iva = $_POST["iva"]/100;
        $totaliva = number_format($subtotalimpuestos, 2, '.', '');
        $descontado = number_format($subtotaldescuentosi+$subtotaldescuentono, 2, '.', '');
        $descuento = limpiar($_POST["descuento"]+$descuentobd);
        $txtDescuento = $descuento/100;
        $total = number_format($subtotalivasi+$subtotalivano+$totaliva, 2, '.', '');
        $totaldescuento = number_format($total*$txtDescuento, 2, '.', '');
        $totalpago = number_format($total-$totaldescuento, 2, '.', '');
        $totalpago2 = number_format($subtotalivasi2+$subtotalivano2, 2, '.', '');
        $codcotizacion = limpiar(decrypt($_POST["codcotizacion"]));
        $codsucursal = limpiar(decrypt($_POST["codsucursal"]));
        $stmt->execute();
        ################### ACTUALIZO LA COTIZACION ####################
		
    echo "<span class='fa fa-check-square-o'></span> LOS DETALLES DE PRODUCTOS FUERON AGREGADOS A LA COTIZACI&Oacute;N EXITOSAMENTE <a href='reportepdf?codcotizacion=".encrypt($codcotizacion)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt($tipodocumento)."' class='on-default' data-placement='left' data-toggle='tooltip' data-original-title='Imprimir Documento' target='_black' rel='noopener noreferrer'><font color='black'><strong>IMPRIMIR REPORTE</strong></font color></a></div>";

    echo "<script>VentanaCentrada('reportepdf?codcotizacion=".encrypt($codcotizacion)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt($tipodocumento)."', '', '', '1024', '568', 'true');</script>";
	exit;
}
######################### FUNCION AGREGAR DETALLES COTIZACIONES #######################

######################## FUNCION ELIMINAR DETALLES COTIZACIONES #######################
public function EliminarDetallesCotizaciones()
{
	$this->p = [];
	if ($_SESSION["acceso"]=="administradorS") {

	############ CONSULTO TOTAL ACTUAL DE COTIZACIONES ##############
	$sql = "SELECT
	codfactura, 
	iva,
	descuento,
	totalpago 
	FROM cotizaciones 
	WHERE codcotizacion = '".limpiar(decrypt($_GET["codcotizacion"]))."' 
	AND codsucursal = '".limpiar(decrypt($_GET["codsucursal"]))."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$codfacturabd = $row['codfactura'];
	$iva = $row["iva"]/100;
	$descuento = $row["descuento"]/100;
	$totalpagobd = $row['totalpago'];
	############ CONSULTO TOTAL ACTUAL DE COTIZACIONES ##############

	$sql = "SELECT * FROM detallecotizaciones WHERE codcotizacion = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codcotizacion"]),decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();
	if($num > 1)
	{
		################## ELIMINO DETALLE DE COTIZACION ##################
		$sql = "DELETE FROM detallecotizaciones WHERE coddetallecotizacion = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$coddetallecotizacion);
		$stmt->bindParam(2,$codsucursal);
		$coddetallecotizacion = decrypt($_GET["coddetallecotizacion"]);
		$codsucursal          = decrypt($_GET["codsucursal"]);
		$stmt->execute();
		################## ELIMINO DETALLE DE COTIZACION ##################

        ############ SUMO LOS IMPORTE DE PRODUCTOS CON IVA ##############
		$sql3 = "SELECT SUM(totaldescuentov) AS totaldescuentosi, SUM(subtotalimpuestos) AS subtotalimpuestos, SUM(valorneto-subtotalimpuestos) AS valorneto, SUM(valorneto2) AS valorneto2 FROM detallecotizaciones WHERE codcotizacion = '".limpiar(decrypt($_GET["codcotizacion"]))."' AND codsucursal = '".limpiar(decrypt($_GET["codsucursal"]))."' AND ivaproducto != '0.00'";
		foreach ($this->dbh->query($sql3) as $row3)
		{
			$this->p[] = $row3;
		}
		$subtotaldescuentosi = ($row3['totaldescuentosi']== "" ? "0.00" : $row3['totaldescuentosi']);
	    $subtotalimpuestos   = ($row3['subtotalimpuestos']== "" ? "0.00" : $row3['subtotalimpuestos']);
		$subtotalivasi       = ($row3['valorneto']== "" ? "0.00" : $row3['valorneto']);
		$subtotalivasi2      = ($row3['valorneto2']== "" ? "0.00" : $row3['valorneto2']);
		############ SUMO LOS IMPORTE DE PRODUCTOS CON IVA ##############

	    ############ SUMO LOS IMPORTE DE PRODUCTOS SIN IVA ##############
		$sql4 = "SELECT SUM(totaldescuentov) AS totaldescuentono, SUM(valorneto) AS valorneto, SUM(valorneto2) AS valorneto2 FROM detallecotizaciones WHERE codcotizacion = '".limpiar(decrypt($_GET["codcotizacion"]))."' AND codsucursal = '".limpiar(decrypt($_GET["codsucursal"]))."' AND ivaproducto = '0.00'";
		foreach ($this->dbh->query($sql4) as $row4)
		{
			$this->p[] = $row4;
		}
		$subtotaldescuentono = ($row4['totaldescuentono']== "" ? "0.00" : $row4['totaldescuentono']);
		$subtotalivano       = ($row4['valorneto']== "" ? "0.00" : $row4['valorneto']);
		$subtotalivano2      = ($row4['valorneto2']== "" ? "0.00" : $row4['valorneto2']);
		############ SUMO LOS IMPORTE DE PRODUCTOS SIN IVA ##############

        ############ ACTUALIZO LOS TOTALES EN LA COTIZACION ##############
		$sql = " UPDATE cotizaciones SET "
		." subtotalivasi = ?, "
		." subtotalivano = ?, "
		." totaliva = ?, "
		." descontado = ?, "
		." totaldescuento = ?, "
		." totalpago = ?, "
		." totalpago2= ? "
		." WHERE "
		." codcotizacion = ? AND codsucursal = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $subtotalivasi);
		$stmt->bindParam(2, $subtotalivano);
		$stmt->bindParam(3, $totaliva);
		$stmt->bindParam(4, $descontado);
		$stmt->bindParam(5, $totaldescuento);
		$stmt->bindParam(6, $totalpago);
		$stmt->bindParam(7, $totalpago2);
		$stmt->bindParam(8, $codcotizacion);
		$stmt->bindParam(9, $codsucursal);

		$totaliva       = number_format($subtotalimpuestos, 2, '.', '');
		$descontado     = number_format($subtotaldescuentosi+$subtotaldescuentono, 2, '.', '');
	    $total          = number_format($subtotalivasi+$subtotalivano+$totaliva, 2, '.', '');
	    $totaldescuento = number_format($total*$descuento, 2, '.', '');
	    $totalpago      = number_format($total-$totaldescuento, 2, '.', '');
		$totalpago2     = number_format($subtotalivasi2+$subtotalivano2, 2, '.', '');
		$codcotizacion  = limpiar(decrypt($_GET["codcotizacion"]));
		$codsucursal    = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();
		############ ACTUALIZO LOS TOTALES EN LA COTIZACION ##############

		echo "1";
		exit;

	} else {
		   
		echo "2";
		exit;
	} 
			
	} else {
		
		echo "3";
		exit;
	}	
}
################### FUNCION ELIMINAR DETALLES COTIZACIONES #####################

####################### FUNCION ELIMINAR COTIZACIONES #################################
public function EliminarCotizaciones()
{
	$this->p = [];
	if ($_SESSION["acceso"]=="administradorS") {

		################## ELIMINO COTIZACION ##################
		$sql = "DELETE FROM cotizaciones WHERE codcotizacion = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codcotizacion);
		$stmt->bindParam(2,$codsucursal);
		$codcotizacion = decrypt($_GET["codcotizacion"]);
		$codsucursal   = decrypt($_GET["codsucursal"]);
		$stmt->execute();
		################## ELIMINO COTIZACION ##################

		################## ELIMINO DETALLE DE COTIZACION ##################
		$sql = "DELETE FROM detallecotizaciones WHERE codcotizacion = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codcotizacion);
		$stmt->bindParam(2,$codsucursal);
		$codcotizacion = decrypt($_GET["codcotizacion"]);
		$codsucursal   = decrypt($_GET["codsucursal"]);
		$stmt->execute();
		################## ELIMINO DETALLE DE COTIZACION ##################

		echo "1";
		exit;

	} else {

		echo "2";
		exit;
	}
}
###################### FUNCION ELIMINAR COTIZACIONES #################################

####################### FUNCION PROCESAR COTIZACIONES A VENTA #################################
public function ProcesarCotizaciones()
{
	$this->p = [];
	####################### VERIFICO ARQUEO DE CAJA #######################
	$sql = "SELECT * FROM arqueocaja 
	INNER JOIN cajas ON arqueocaja.codcaja = cajas.codcaja 
	INNER JOIN usuarios ON cajas.codigo = usuarios.codigo 
	WHERE usuarios.codigo = ? AND arqueocaja.statusarqueo = 1";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_SESSION["codigo"]));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "1";
		exit;

	} else {
		
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		$codarqueo = $row['codarqueo'];
		$codcaja   = $row['codcaja'];
		$ingreso   = ($row['ingresos']== "" ? "0.00" : $row['ingresos']);
		$credito   = ($row['creditos']== "" ? "0.00" : $row['creditos']);
		$abono    = ($row['abonos']== "" ? "0.00" : $row['abonos']);
	}
    ####################### VERIFICO ARQUEO DE CAJA #######################

   if(empty($_POST["codsucursal"]) or empty($_POST["tipodocumento"]) or empty($_POST["tipopago"]))
	{
		echo "2";
		exit;
	}
	elseif(limpiar($_POST["txtTotal"]=="") && limpiar($_POST["txtTotal"]==0) && limpiar($_POST["txtTotal"]==0.00))
	{
		echo "3";
		exit;
	}
	############ VALIDO SI LA CANTIDAD ES MAYOR QUE LA EXISTENCIA #############
	$sql = "SELECT * FROM detallecotizaciones 
	WHERE codcotizacion = '".decrypt($_POST['codcotizacion'])."' 
	AND codsucursal = '".decrypt($_POST['codsucursal'])."'";
    foreach ($this->dbh->query($sql) as $row2) {

    	if(limpiar($row2['tipodetalle'])==1){	

		    $sql = "SELECT 
		    existencia 
		    FROM productos 
		    WHERE codproducto = '".limpiar($row2['codproducto'])."' 
		    AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		    foreach ($this->dbh->query($sql) as $row)
		    {
			   $this->p[] = $row;
		    }
		
		    $existenciabd = $row['existencia'];
		    $cantidad = $row2['cantcotizacion'];

	        if ($cantidad > $existenciabd) 
	        { 
		        echo "4";
		        exit;
	        }

		} elseif(limpiar($row2['tipodetalle']) == 2){ // SI EL DETALLE ES UN COMBO

			$sql = "SELECT 
		    existencia 
		    FROM combos 
		    WHERE codcombo = '".limpiar($row2['codproducto'])."'
		    AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		    foreach ($this->dbh->query($sql) as $row)
		    {
			   $this->p[] = $row;
		    }
		
		    $existenciabd = $row['existencia'];
		    $cantidad = $row2['cantcotizacion'];

	        if ($cantidad > $existenciabd) 
	        { 
		        echo "5";
		        exit;
	        }

		    ############## VERIFICO SI EL COMBO TIENE PRODUCTO RELACIONADOS #################
		    $sql = "SELECT * FROM combosxproductos WHERE codcombo = ? AND codsucursal = ?";
			$stmt = $this->dbh->prepare($sql);
			$stmt->execute(array($row2['codproducto'],limpiar(decrypt($_POST["codsucursal"]))));
			$num = $stmt->rowCount();
	        if($num>0) {  

	        	$sql = "SELECT 
	        	combosxproductos.codcombo,
	    	    combosxproductos.idproducto,
	        	combosxproductos.codproducto,
	        	combosxproductos.cantidad,
	        	combosxproductos.codsucursal,
	        	productos.existencia
	        	FROM combosxproductos 
	        	LEFT JOIN productos ON combosxproductos.codproducto = productos.codproducto 
	        	WHERE combosxproductos.codcombo IN ('".limpiar($row2['codproducto'])."') 
	        	AND combosxproductos.codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."' 
	    	    AND productos.codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
	        	foreach ($this->dbh->query($sql) as $row)
			    { 
				    $this->p[] = $row;

				    $cantracionbd2 = $row['cantidad'];
				    $idproductobd2 = $row['idproducto'];
				    $codproductobd2 = $row['codproducto'];
				    $existenciabd2 = $row['existencia'];
			        $racion = number_format($cantracionbd2*$row2['cantcotizacion'], 2, '.', '');

			        if ($racion > $existenciabd2) 
			        { 
			        	echo "6";
			        	exit;
			        }
			    }
		    }//fin de consulta de productos de combos	
		    ############## VERIFICO SI EL COMBO TIENE PRODUCTO RELACIONADOS #################
	    }
	}
	############ VALIDO SI LA CANTIDAD ES MAYOR QUE LA EXISTENCIA #############

	################### SELECCIONE LOS DATOS DEL CLIENTE ######################
    $sql = "SELECT
    clientes.codcliente,
	clientes.tipocliente,
	clientes.documcliente,
	clientes.dnicliente,
	CONCAT(if(clientes.tipocliente='JURIDICO',clientes.razoncliente,clientes.nomcliente)) as nomcliente,
	clientes.girocliente,
	clientes.tlfcliente,
	clientes.id_ciudad,
	clientes.id_comuna,
	clientes.direccliente,
	clientes.emailcliente,
	clientes.limitecredito,
	ciudades.codciudad,
	ciudades.ciudad,
	comunas.codcomuna,
	comunas.comuna,
    IFNULL(pag.montocredito,'0.00') AS montoactual,
    IFNULL(clientes.limitecredito-pag.montocredito,clientes.limitecredito) AS creditodisponible
    FROM clientes
    LEFT JOIN ciudades ON clientes.id_ciudad = ciudades.id_ciudad 
    LEFT JOIN comunas ON clientes.id_comuna = comunas.id_comuna 
    LEFT JOIN
      (SELECT
      codcliente, montocredito       
      FROM creditosxclientes 
      WHERE codsucursal = '".limpiar($_POST['codsucursal'])."') pag ON pag.codcliente = clientes.codcliente
      WHERE clientes.dnicliente = ? 
      AND clientes.codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(limpiar($_POST['nrodocumento']),limpiar(decrypt($_POST['codsucursal']))));
	$num = $stmt->rowCount();
	if($row = $stmt->fetch(PDO::FETCH_ASSOC))
	{
		$p[] = $row;
	}
    $codcliente        = (empty($row['codcliente']) ? "0" : $row['codcliente']);
    $tipocliente       = (empty($row['tipocliente']) ? "0" : $row['tipocliente']);
    $dnicliente        = (empty($row['dnicliente']) ? "0" : $row['dnicliente']);
    $nomcliente        = (empty($row['nomcliente']) ? "0" : $row['nomcliente']);
    $girocliente       = (empty($row['girocliente']) ? "0" : $row['girocliente']);
    $emailcliente      = (empty($row['emailcliente']) ? "0" : $row['emailcliente']);
    $ciudad            = (empty($row['id_ciudad']) ? "0" : $row['ciudad']);
    $comuna            = (empty($row['id_comuna']) ? "0" : $row['comuna']);
    $direccliente      = (empty($row['direccliente']) ? "0" : $row['direccliente']);
    $limitecredito     = (empty($row['limitecredito']) ? "0.00" : $row['limitecredito']);
    $montoactual       = (empty($row['montoactual']) ? "0.00" : $row['montoactual']);
    $creditodisponible = (empty($row['creditodisponible']) ? "0.00" : $row['creditodisponible']);
    $medioabono        = (empty($_POST["formaabono"]) ? "" : $_POST["formaabono"]);
    $montoabono        = (empty($_POST["montoabono"]) ? "0.00" : $_POST["montoabono"]);
    $total             = number_format($_POST["txtTotal"]-$montoabono, 2, '.', '');
    ################### SELECCIONE LOS DATOS DEL CLIENTE ######################

    ################### VALIDO TIPO DE PAGO ES A CREDITO ######################
    if (limpiar($_POST["tipopago"]) == "CREDITO") {

    	$fechaactual = date("Y-m-d");
		$fechavence = date("Y-m-d",strtotime($_POST['fechavencecredito']));

		if ($codcliente == '0') { 

            echo "7";
            exit;

        } else if (strtotime($fechavence) < strtotime($fechaactual)) {

			echo "8";
			exit;

		} else if ($montoabono != "0.00" && $medioabono == "") {
  
            echo "9";
	        exit;

		} else if ($limitecredito != "0.00" && $total > $creditodisponible) {

            echo "10";
            exit;

        } else if($_POST["montoabono"] >= $_POST["txtTotal"]) { 

	        echo "11";
	        exit;
        }
    }
    ################### VALIDO TIPO DE PAGO ES A CREDITO ######################

    ################### VALIDO TIPO DE PAGO ES A CONTADO ######################
    if (limpiar($_POST["tipopago"]) == "CONTADO") {

   	foreach ($_POST['pagos'] as $value)
   	{
		if($value['montopagado'] == "" || $value['montopagado'] == 0.00)	
		{
		    echo "12";
		    exit;
		}
	}

	    if (isset($_POST['pagos']) && is_array($_POST['pagos'])) {

	        $formas_pago = array_column($_POST['pagos'], 'codmediopago');
	        if(count($formas_pago) != count(array_unique($formas_pago)))
	   	    {
	   		    echo "13";
				exit;
	        } 
	        else if (count($formas_pago) > 1 && $_POST["txtPagado"] > $_POST["txtTotal"])
	        {
	            echo "14";
	            exit;
	        }

        } else {

	      	if ($_POST["txtTotal"] > $_POST["txtPagado"])
	        {
	            echo "15";
	            exit;
	        }
        } 
	}
    ################### VALIDO TIPO DE PAGO ES A CONTADO ######################
	
	################# OBTENGO DATOS DE SUCURSAL #################
	$sql = " SELECT 
	cuitsucursal, 
	nroactividadsucursal,  
	inicioboleta,
	iniciofactura, 
	inicioguia, 
	inicionotaventa,
	lioren_token  
	FROM sucursales WHERE codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$cuitsucursal    = $row['cuitsucursal'];
	$nroactividad    = $row['nroactividadsucursal'];
	$inicioboleta    = $row['inicioboleta'];
	$iniciofactura   = $row['iniciofactura'];
	$inicioguia      = $row['inicioguia'];
	$inicionotaventa = $row['inicionotaventa'];
	$lioren_token    = $row['lioren_token'];
	################# OBTENGO DATOS DE SUCURSAL #################

	################ CREO CODIGO DE VENTA ####################
	$sql = "SELECT codventa FROM ventas 
	ORDER BY idventa DESC LIMIT 1";
	foreach ($this->dbh->query($sql) as $row){

		$venta = $row["codventa"];
	}
	if(empty($venta))
	{
		$codventa = "01";

	} else {

		$num         = substr($venta, 0);
        $dig         = $num + 1;
        $codigofinal = str_pad($dig, 2, "0", STR_PAD_LEFT);
        $codventa    = $codigofinal;
	}
    ################ CREO CODIGO DE VENTA ###############

	################### CREO CODIGO DE FACTURA ####################
	$tipo_documento = ($_POST['tipodocumento'] == "FACTURA_A4" ? "FACTURA" : $_POST['tipodocumento']);
	$sql = "SELECT codfactura
	FROM ventas 
	WHERE tipo = '".limpiar($tipo_documento)."'
	AND codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."' 
	ORDER BY idventa DESC LIMIT 1";
	foreach ($this->dbh->query($sql) as $row){

		$factura = $row["codfactura"];
	}
	
	if($tipo_documento == "BOLETA") {

        if(empty($factura)){ 
        	$codfactura = $inicioboleta;
        } else {
            $var = strlen("");
            $var1 = substr($factura , $var);
            $var2 = strlen($var1);
            $var3 = $var1 + 1;
            $var4 = str_pad($var3, $var2, "0", STR_PAD_LEFT);
            $codfactura = $var4;
        }
		   $codserie = limpiar($nroactividad);
		   $codautorizacion = limpiar(GenerateRandomStringg());

	} elseif($tipo_documento == "FACTURA") {

        if(empty($factura)){ 
        	$codfactura = $iniciofactura;
        } else {
            $var = strlen("");
            $var1 = substr($factura , $var);
            $var2 = strlen($var1);
            $var3 = $var1 + 1;
            $var4 = str_pad($var3, $var2, "0", STR_PAD_LEFT);
            $codfactura = $var4;
        }
		    $codserie = limpiar($nroactividad);
		    $codautorizacion = limpiar(GenerateRandomStringg());
	}
    ################### CREO CODIGO DE FACTURA ####################

	################### SELECCIONE LOS DATOS DE LA COTIZACION ######################
    $sql = "SELECT * FROM cotizaciones WHERE codcotizacion = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_POST['codcotizacion']),decrypt($_POST['codsucursal'])));
	$num = $stmt->rowCount();
	if($row = $stmt->fetch(PDO::FETCH_ASSOC))
	{
		$p[] = $row;
	}
    ################### SELECCIONE LOS DATOS DE LA COTIZACION ######################

    $fecha = date("Y-m-d H:i:s");

    ################################ REGISTRO DE VENTAS ################################
    $query = "INSERT INTO ventas values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $tipodocumento);
	$stmt->bindParam(2, $codarqueo);
	$stmt->bindParam(3, $codcaja);
	$stmt->bindParam(4, $codventa);
	$stmt->bindParam(5, $codfactura);
	$stmt->bindParam(6, $codserie);
	$stmt->bindParam(7, $codautorizacion);
	$stmt->bindParam(8, $codcliente);
	$stmt->bindParam(9, $subtotalivasi);
	$stmt->bindParam(10, $subtotalivano);
	$stmt->bindParam(11, $iva);
	$stmt->bindParam(12, $totaliva);
	$stmt->bindParam(13, $descontado);
	$stmt->bindParam(14, $descuento);
	$stmt->bindParam(15, $totaldescuento);
	$stmt->bindParam(16, $montodescuento);
	$stmt->bindParam(17, $totalpago);
	$stmt->bindParam(18, $totalpago2);
	$stmt->bindParam(19, $creditopagado);
	$stmt->bindParam(20, $tipopago);
	$stmt->bindParam(21, $formapago);
	$stmt->bindParam(22, $montopagado);
	$stmt->bindParam(23, $montodevuelto);
	$stmt->bindParam(24, $fechavencecredito);
	$stmt->bindParam(25, $fechapagado);
	$stmt->bindParam(26, $statusventa);
	$stmt->bindParam(27, $fechaventa);
	$stmt->bindParam(28, $observaciones);
	$stmt->bindParam(29, $notacredito);
	$stmt->bindParam(30, $bpsii);
	$stmt->bindParam(31, $tipo);
	$stmt->bindParam(32, $codigo);
	$stmt->bindParam(33, $codsucursal);
   
	$tipodocumento = limpiar($_POST["tipodocumento"]);
	$subtotalivasi = limpiar($row["subtotalivasi"]);
	$subtotalivano = limpiar($row["subtotalivano"]);
	$iva = limpiar($row["iva"]);
	$totaliva = limpiar($row["totaliva"]);
	$descontado = limpiar($row["descontado"]);
	$descuento = limpiar($row["descuento"]);
	$totaldescuento = limpiar($row["totaldescuento"]);
	$montodescuento = limpiar("0.00");
	$totalpago = limpiar($row["totalpago"]);
	$totalpago2 = limpiar($row["totalpago2"]);
	$creditopagado = limpiar(isset($_POST['montoabono']) ? $_POST["montoabono"] : "0.00");
	$tipopago = limpiar($_POST["tipopago"]);

	$montopagado = '0.00';
    if ($_POST['tipopago'] == 'CONTADO') {
        
        if (isset($_POST['pagos']) && is_array($_POST['pagos'])) {
            $formapago   = 'VARIOS';
            $montopagado = array_reduce($_POST['pagos'], function ($a, $o) {
                return $a + $o['montopagado'];
            });
        }
        else 
        {
            $formapago   = decrypt($_POST['codmediopago']);
            $montopagado = limpiar($_POST['montopagado']);
        }
    }
    else 
    {
      $formapago = 'CREDITO';
    }
    $montodevuelto = limpiar(isset($_POST['montodevuelto']) ? $_POST["montodevuelto"] : "0.00");

	$fechavencecredito = limpiar($_POST["tipopago"]=="CREDITO" ? date("Y-m-d",strtotime($_POST['fechavencecredito'])) : "0000-00-00");
    $fechapagado = limpiar("0000-00-00");
    $statusventa = limpiar($_POST["tipopago"]=="CONTADO" ? "PAGADA" : "PENDIENTE");
    $fechaventa = limpiar($fecha);
	$observaciones = limpiar($_POST["observaciones"]);
	$notacredito = limpiar("0");
	$bpsii = limpiar($_POST["bpsii"]);
	$tipo = ($_POST['tipodocumento'] == "FACTURA_A4" ? "FACTURA" : $_POST['tipodocumento']);
	$codigo = limpiar($row["codigo"]);
	$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
	$stmt->execute();
	################################ REGISTRO DE VENTAS ################################

	################################ REGISTRO DE FORMAS DE PAGOS EN VENTA ################################
	if(limpiar($_POST["tipopago"])=="CONTADO"){

	    $sql  = "INSERT INTO mediospagoxventas VALUES (NULL, ?, ?, ?, ?, ?, ?)";
	    foreach ($_POST['pagos'] as $pago) {
	      $stmt = $this->dbh->prepare($sql);
	      $stmt->execute([$codarqueo, $codcaja, $codventa, decrypt($pago['codmediopago']), $pago['montopagado'], $_POST['montodevuelto']]);
	    }
	}
	################################ REGISTRO DE FORMAS DE PAGOS EN VENTA ################################

	################### SELECCIONO DETALLES DE LA COTIZACION ######################
	$sql = "SELECT * FROM detallecotizaciones 
	WHERE codcotizacion = '".decrypt($_POST['codcotizacion'])."' 
	AND codsucursal = '".decrypt($_POST['codsucursal'])."'";
    foreach ($this->dbh->query($sql) as $row2)
	{
	    ############################### REGISTRO DETALLES DE VENTAS ###############################
        $query = "INSERT INTO detalleventas values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
    	$stmt = $this->dbh->prepare($query);
    	$stmt->bindParam(1, $codventa);
    	$stmt->bindParam(2, $idproducto);
    	$stmt->bindParam(3, $codproducto);
    	$stmt->bindParam(4, $producto);
	    $stmt->bindParam(5, $descripcion);
	    $stmt->bindParam(6, $opcionvendido);
	    $stmt->bindParam(7, $imei);
	    $stmt->bindParam(8, $condicion);
    	$stmt->bindParam(9, $codmarca);
    	$stmt->bindParam(10, $codmodelo);
    	$stmt->bindParam(11, $codpresentacion);
	    $stmt->bindParam(12, $codcolor);
    	$stmt->bindParam(13, $cantidad);
    	$stmt->bindParam(14, $preciocompra);
    	$stmt->bindParam(15, $precioventa);
    	$stmt->bindParam(16, $ivaproducto);
    	$stmt->bindParam(17, $descproducto);
    	$stmt->bindParam(18, $valortotal);
    	$stmt->bindParam(19, $totaldescuentov);
	    $stmt->bindParam(20, $subtotalimpuestos);
    	$stmt->bindParam(21, $valorneto);
    	$stmt->bindParam(22, $valorneto2);
    	$stmt->bindParam(23, $tipodetalle);
    	$stmt->bindParam(24, $codsucursal);

	    $idproducto = limpiar($row2['idproducto']);
    	$codproducto = limpiar($row2['codproducto']);
    	$producto = limpiar($row2['producto']);
    	$descripcion = limpiar($row2['descripcion']);
    	$imei = limpiar($row2['imei']);
    	$condicion = limpiar($row2['condicion']);
    	$codmarca = limpiar($row2['codmarca']);
    	$codmodelo = limpiar($row2['codmodelo']);
    	$codpresentacion = limpiar($row2['codpresentacion']);
    	$codcolor = limpiar($row2['codcolor']);
    	$cantidad = limpiar($row2['cantcotizacion']);
    	$preciocompra = limpiar($row2['preciocompra']);
    	$precioventa = limpiar($row2['precioventa']);
    	$precioconiva = limpiar($row2['ivaproducto'] == "0.00" ? "0.00" : $row2['precioventa']);
    	$ivaproducto = limpiar($row2['ivaproducto']);
    	$descproducto = limpiar($row2['descproducto']);
    	$descuento = $row2['descproducto']/100;
    	$valortotal = number_format($row2['valortotal'], 2, '.', '');
    	$totaldescuentov = number_format($row2['totaldescuentov'], 2, '.', '');
    	$subtotalimpuestos = number_format($row2['subtotalimpuestos'], 2, '.', '');
    	$valorneto = number_format($row2['valorneto'], 2, '.', '');
    	$valorneto2 = number_format($row2['valorneto2'], 2, '.', '');
    	$tipodetalle = limpiar($row2['tipodetalle']);
    	$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
    	$stmt->execute();
    	############################### REGISTRO DETALLES DE VENTAS ###############################
    
    	if(limpiar($row2['tipodetalle'])==1){

	        ############### VERIFICO LA EXISTENCIA DEL PRODUCTO EN ALMACEN ##################
			$sql = "SELECT existencia FROM productos WHERE codproducto = '".limpiar($row2['codproducto'])."' 
			AND codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."'";
			foreach ($this->dbh->query($sql) as $row3)
			{
				$this->p[] = $row3;
			}
			$existenciabd = $row3['existencia'];
		    ############### VERIFICO LA EXISTENCIA DEL PRODUCTO EN ALMACEN ##################

		    ##################### ACTUALIZO LA EXISTENCIA DEL ALMACEN ####################
	    	$sql = " UPDATE productos set "
	    	." existencia = ? "
	    	." WHERE "
	    	." codproducto = '".limpiar($row2['codproducto'])."' 
	    	AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."';
	    	";
	    	$stmt = $this->dbh->prepare($sql);
	    	$stmt->bindParam(1, $existencia);
	    	$cantventa  = $row2['opcionvendido'] == "2" ? number_format($row2['cantcotizacion'], 3, '.', '') : number_format($row2['cantcotizacion'], 0, '.', '');
		    $existencia = $row2['opcionvendido'] == "2" ? number_format($existenciabd-$cantventa, 3, '.', '') : number_format($existenciabd-$cantventa, 0, '.', '');
			$stmt->execute();
	    	##################### ACTUALIZO LA EXISTENCIA DEL ALMACEN ####################

	    	############### REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX ###############
	    	$query = "INSERT INTO kardex values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
	    	$stmt = $this->dbh->prepare($query);
	    	$stmt->bindParam(1, $codventa);
	    	$stmt->bindParam(2, $codcliente);
	    	$stmt->bindParam(3, $codproducto);
	    	$stmt->bindParam(4, $movimiento);
	    	$stmt->bindParam(5, $entradas);
	    	$stmt->bindParam(6, $salidas);
	    	$stmt->bindParam(7, $devolucion);
	    	$stmt->bindParam(8, $stockactual);
	    	$stmt->bindParam(9, $ivaproducto);
	    	$stmt->bindParam(10, $descproducto);
	    	$stmt->bindParam(11, $precio);
	    	$stmt->bindParam(12, $documento);
	    	$stmt->bindParam(13, $fechakardex);	
	    	$stmt->bindParam(14, $tipokardex);	
	    	$stmt->bindParam(15, $procedimiento);		
	    	$stmt->bindParam(16, $codsucursal);
		    $stmt->bindParam(17, $codigo);

	    	$codproducto   = limpiar($row2['codproducto']);
	    	$movimiento    = limpiar("SALIDAS");
		    $entradas      = $row2['opcionvendido'] == "2" ? "0.000" : "0";
		    $salidas       = $row2['opcionvendido'] == "2" ? number_format($row2['cantcotizacion'], 3, '.', '') : number_format($row2['cantcotizacion'], 0, '.', '');
		    $devolucion    = $row2['opcionvendido'] == "2" ? "0.000" : "0";
		    $stockactual   = $row2['opcionvendido'] == "2" ? number_format($existenciabd-$row2['cantcotizacion'], 3, '.', '') : number_format($existenciabd-$row2['cantcotizacion'], 0, '.', '');
	    	$ivaproducto   = limpiar($row2['ivaproducto']);
	    	$descproducto  = number_format($row2['descproducto'], 2, '.', '');
	    	$precio        = number_format($row2["precioventa"], 2, '.', '');
	    	$documento     = limpiar("VENTA: ".$codfactura);
	    	$fechakardex   = limpiar(date("Y-m-d"));	
	    	$tipokardex    = limpiar($row2['tipodetalle']);
	    	$procedimiento = limpiar("1");
	    	$codsucursal   = limpiar(decrypt($_POST["codsucursal"]));
    	    $codigo        = limpiar($_SESSION["codigo"]);
	    	$stmt->execute();
	    	############### REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX ###############

    	} elseif(limpiar($row2['tipodetalle']) == 2){ // SI EL DETALLE ES UN COMBO

		    ############## VERIFICO LA EXISTENCIA DEL COMBO EN ALMACEN #################
			$sql = "SELECT 
			existencia
			FROM combos
			WHERE codcombo = '".limpiar($row2['codproducto'])."'
			AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
			foreach ($this->dbh->query($sql) as $row)
			{
				$this->p[] = $row;
			}
			$existenciacombobd = $row['existencia'];
			############## VERIFICO LA EXISTENCIA DEL COMBO EN ALMACEN #################

		    ##################### ACTUALIZO LA EXISTENCIA DEL COMBO DEL ALMACEN ####################
			$sql = " UPDATE combos set "
				." existencia = ? "
				." WHERE "
				." codcombo = '".limpiar($row2['codproducto'])."'
		      AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."';
				";
			$stmt = $this->dbh->prepare($sql);
			$stmt->bindParam(1, $existencia);
			$cantventa  = $row2['opcionvendido'] == "2" ? number_format($row2['cantcotizacion'], 3, '.', '') : number_format($row2['cantcotizacion'], 0, '.', '');
		    $existencia = $row2['opcionvendido'] == "2" ? number_format($existenciacombobd-$cantventa, 3, '.', '') : number_format($existenciacombobd-$cantventa, 0, '.', '');
			$stmt->execute();
			##################### ACTUALIZO LA EXISTENCIA DEL COMBO DEL ALMACEN ####################

			############### REGISTRAMOS LOS DATOS DE COMBO EN KARDEX ###############
		    $query = "INSERT INTO kardex values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
			$stmt = $this->dbh->prepare($query);
			$stmt->bindParam(1, $codventa);
			$stmt->bindParam(2, $codcliente);
			$stmt->bindParam(3, $codproducto);
			$stmt->bindParam(4, $movimiento);
			$stmt->bindParam(5, $entradas);
			$stmt->bindParam(6, $salidas);
			$stmt->bindParam(7, $devolucion);
			$stmt->bindParam(8, $stockactual);
			$stmt->bindParam(9, $ivaproducto);
			$stmt->bindParam(10, $descproducto);
			$stmt->bindParam(11, $precio);
			$stmt->bindParam(12, $documento);
			$stmt->bindParam(13, $fechakardex);	
		    $stmt->bindParam(14, $tipokardex);	
	    	$stmt->bindParam(15, $procedimiento);			
			$stmt->bindParam(16, $codsucursal);
		    $stmt->bindParam(17, $codigo);

			$codproducto   = limpiar($row2['codproducto']);
			$movimiento    = limpiar("SALIDAS");
		    $entradas      = $row2['opcionvendido'] == "2" ? "0.000" : "0";
		    $salidas       = $row2['opcionvendido'] == "2" ? number_format($row2['cantcotizacion'], 3, '.', '') : number_format($row2['cantcotizacion'], 0, '.', '');
		    $devolucion    = $row2['opcionvendido'] == "2" ? "0.000" : "0";
		    $stockactual   = $row2['opcionvendido'] == "2" ? number_format($existenciacombobd-$row2['cantcotizacion'], 3, '.', '') : number_format($existenciacombobd-$row2['cantcotizacion'], 0, '.', '');
			$ivaproducto   = limpiar($row2['ivaproducto']);
			$descproducto  = number_format($row2['descproducto'], 2, '.', '');
			$precio        = number_format($row2["precioventa"], 2, '.', '');
			$documento     = limpiar("VENTA: ".$codfactura);
			$fechakardex   = limpiar(date("Y-m-d"));
		    $tipokardex    = limpiar($row2['tipodetalle']);
	    	$procedimiento = limpiar("2");
			$codsucursal   = limpiar(decrypt($_POST["codsucursal"]));
    	    $codigo        = limpiar($_SESSION["codigo"]);
			$stmt->execute();
			############### REGISTRAMOS LOS DATOS DE COMBO EN KARDEX ###############

			############## VERIFICO SI EL COMBO TIENE PRODUCTO RELACIONADOS #################
		    $sql = "SELECT * FROM combosxproductos WHERE codcombo = ? AND codsucursal = ?";
			$stmt = $this->dbh->prepare($sql);
			$stmt->execute(array($row2['codproducto'],limpiar(decrypt($_POST["codsucursal"]))));
			$num = $stmt->rowCount();
		    if($num>0) {  

		    	$sql = "SELECT 
		    	combosxproductos.codcombo,
	    	    combosxproductos.idproducto,
		    	combosxproductos.codproducto,
		    	combosxproductos.cantidad,
		    	combosxproductos.codsucursal,
		    	productos.opcionvendido,
		    	productos.existencia,
		    	productos.precioxpublico AS precioventa,
		    	productos.ivaproducto,
		    	productos.descproducto
		    	FROM combosxproductos 
		    	LEFT JOIN productos ON combosxproductos.codproducto = productos.codproducto 
		    	WHERE combosxproductos.codcombo IN ('".limpiar($row2['codproducto'])."') 
		    	AND combosxproductos.codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."' 
		    	AND productos.codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		    	foreach ($this->dbh->query($sql) as $row)
			    { 
				    $this->p[] = $row;

				    $cantracionbd2   = $row['cantidad'];
				    $idproductobd2   = $row['idproducto'];
			        $codproductobd2  = $row['codproducto'];
				    $existenciabd2   = $row['existencia'];
				    $precioventabd2  = $row['precioventa'];
				    $ivaproductobd2  = $row['ivaproducto'];
				    $descproductobd2 = $row['descproducto'];
			        $opcionvendido2  = $row['opcionvendido'];

				    ############## ACTUALIZO LOS DATOS DEL PRODUCTO #################
				    $update = "UPDATE productos set "
				    ." existencia = ? "
				    ." WHERE "
				    ." idproducto = ? AND codproducto = ? AND codsucursal = ?;
				    ";
				    $stmt = $this->dbh->prepare($update);
				    $stmt->bindParam(1, $cantidadracion);
				    $stmt->bindParam(2, $idproducto);
				    $stmt->bindParam(3, $codproducto);
		            $stmt->bindParam(4, $codsucursal);
		            
		            $racion         = $cantracionbd2*$row2['cantcotizacion'];
			        $cantidadracion = $opcionvendido2 == "2" ? number_format($existenciabd2-$racion, 3, '.', '') : number_format($existenciabd2-$racion, 0, '.', '');
		            $idproducto = limpiar($idproductobd2);
		            $codproducto = limpiar($codproductobd2);
		            $codsucursal = limpiar(decrypt($_POST["codsucursal"]));
				    $stmt->execute();
				    ############## ACTUALIZO LOS DATOS DEL PRODUCTO #################

				    ############## REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX ###################
				    $query = "INSERT INTO kardex values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
				    $stmt = $this->dbh->prepare($query);
				    $stmt->bindParam(1, $codventa);
				    $stmt->bindParam(2, $codcliente);
				    $stmt->bindParam(3, $codproducto);
				    $stmt->bindParam(4, $movimiento);
				    $stmt->bindParam(5, $entradas);
				    $stmt->bindParam(6, $salidas);
				    $stmt->bindParam(7, $devolucion);
				    $stmt->bindParam(8, $stockactual);
				    $stmt->bindParam(9, $ivaproducto);
				    $stmt->bindParam(10, $descproducto);
				    $stmt->bindParam(11, $precio);
				    $stmt->bindParam(12, $documento);
				    $stmt->bindParam(13, $fechakardex);
		            $stmt->bindParam(14, $tipokardex);
	    	        $stmt->bindParam(15, $procedimiento);	
		            $stmt->bindParam(16, $codsucursal);
		            $stmt->bindParam(17, $codigo);		

				    $codproducto   = limpiar($codproductobd2);
				    $movimiento    = limpiar("SALIDAS");
				    $entradas      = $opcionvendido2 == "2" ? "0.000" : "0";
				    $salidas       = $opcionvendido2 == "2" ? number_format($racion, 3, '.', '') : number_format($racion, 0, '.', '');
				    $devolucion    = $opcionvendido2 == "2" ? "0.000" : "0";
				    $stockactual   = $opcionvendido2 == "2" ? number_format($existenciabd2-$racion, 3, '.', '') : number_format($existenciabd2-$racion, 0, '.', '');
				    $ivaproducto   = limpiar($ivaproductobd2 == "NO" ? "0.00" : $iva);
				    $descproducto  = number_format($descproductobd2, 2, '.', '');
				    $precio        = number_format($precioventabd2, 2, '.', '');
				    $documento     = limpiar("VENTA (DETALLE DE COMBO): ".$codfactura);
				    $fechakardex   = limpiar(date("Y-m-d"));
		            $tipokardex    = limpiar("1");
	    	        $procedimiento = limpiar("2");
		            $codsucursal   = limpiar(decrypt($_POST["codsucursal"]));
    	            $codigo        = limpiar($_SESSION["codigo"]);
				    $stmt->execute();
				    ############## REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX ###################  
			    }
		    }//fin de consulta de productos de combos	
		    ############## VERIFICO SI EL COMBO TIENE PRODUCTO RELACIONADOS #################
    	
	   } else { // SI EL DETALLE ES UN SERVICIO

		    ############### REGISTRAMOS LOS DATOS DE SERVICIO EN KARDEX ###############
		    $query = "INSERT INTO kardex values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
			$stmt = $this->dbh->prepare($query);
			$stmt->bindParam(1, $codventa);
			$stmt->bindParam(2, $codcliente);
			$stmt->bindParam(3, $codproducto);
			$stmt->bindParam(4, $movimiento);
			$stmt->bindParam(5, $entradas);
			$stmt->bindParam(6, $salidas);
			$stmt->bindParam(7, $devolucion);
			$stmt->bindParam(8, $stockactual);
			$stmt->bindParam(9, $ivaproducto);
			$stmt->bindParam(10, $descproducto);
			$stmt->bindParam(11, $precio);
			$stmt->bindParam(12, $documento);
			$stmt->bindParam(13, $fechakardex);	
		    $stmt->bindParam(14, $tipokardex);
	    	$stmt->bindParam(15, $procedimiento);			
			$stmt->bindParam(16, $codsucursal);
		    $stmt->bindParam(17, $codigo);

			$codproducto   = limpiar($row2['codproducto']);
			$movimiento    = limpiar("SALIDAS");
		    $entradas      = $detalle[$i]['opcionvendido'] == "2" ? "0.000" : "0";
		    $salidas       = $detalle[$i]['opcionvendido'] == "2" ? number_format($row2['cantcotizacion'], 3, '.', '') : number_format($row2['cantcotizacion'], 0, '.', '');
		    $devolucion    = $detalle[$i]['opcionvendido'] == "2" ? "0.000" : "0";
		    $stockactual   = $detalle[$i]['opcionvendido'] == "2" ? "0.000" : "0";
			$ivaproducto   = limpiar($row2['ivaproducto'] == "(E)" ? "0.00" : $row2['ivaproducto']);
			$descproducto  = number_format($row2['descproducto'], 2, '.', '');
			$precio        = number_format($row2["precioventa"], 2, '.', '');
			$documento     = limpiar("VENTA: ".$codfactura);
			$fechakardex   = limpiar(date("Y-m-d"));
		    $tipokardex    = limpiar($row2['tipodetalle']);
	    	$procedimiento = limpiar("3");	
			$codsucursal   = limpiar(decrypt($_POST["codsucursal"]));
    	    $codigo        = limpiar($_SESSION["codigo"]);
			$stmt->execute();
			############### REGISTRAMOS LOS DATOS DE SERVICIO EN KARDEX ###############
	    }
	}
	################### SELECCIONO DETALLES DE LA COTIZACION ######################

	##################### ACTUALIZO COTIZACION A PROCESADO ####################
	$sql = "UPDATE cotizaciones set "
	." procesada = ? "
	." WHERE "
	." codcotizacion = '".limpiar(decrypt($_POST["codcotizacion"]))."' 
	AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."';
	";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $procesada);

	$procesada = limpiar("0");
	$stmt->execute();
    ##################### ACTUALIZO COTIZACION A PROCESADO ####################

	################ AGREGAMOS EL INGRESO A CONTADO ##############
    if (limpiar($_POST["tipopago"]=="CONTADO")){

		$sql = "UPDATE arqueocaja set "
		." ingresos = ? "
		." WHERE "
		." codarqueo = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $txtTotal);
		$stmt->bindParam(2, $codarqueo);

		$txtTotal = number_format($_POST["txtTotal"]+$ingreso, 2, '.', '');
		$stmt->execute();
    }
    ################ AGREGAMOS EL INGRESO A CONTADO ##############

    ################ AGREGAMOS EL INGRESO Y ABONOS A CREDITO ################
    if (limpiar($_POST["tipopago"]=="CREDITO")) {

		$sql = " UPDATE arqueocaja SET "
		." creditos = ?, "
		." abonos = ? "
		." WHERE "
		." codarqueo = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $txtTotal);
		$stmt->bindParam(2, $totalabono);
		$stmt->bindParam(3, $codarqueo);

		$TotalCredito = number_format($_POST["txtTotal"]-$_POST["montoabono"], 2, '.', '');
		$txtTotal     = number_format($TotalCredito+$credito, 2, '.', '');
		$totalabono   = number_format($_POST["montoabono"]+$abono, 2, '.', '');
		$stmt->execute(); 

		$sql = " SELECT codcliente FROM creditosxclientes WHERE codcliente = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array($codcliente,decrypt($_POST["codsucursal"])));
		$num = $stmt->rowCount();
		if($num == 0)
		{
			$query = "INSERT INTO creditosxclientes values (null, ?, ?, ?);";
			$stmt = $this->dbh->prepare($query);
			$stmt->bindParam(1, $codcliente);
			$stmt->bindParam(2, $montocredito);
			$stmt->bindParam(3, $codsucursal);

			$montocredito = number_format($_POST["txtTotal"]-$_POST["montoabono"], 2, '.', '');
			$codsucursal  = limpiar(decrypt($_POST["codsucursal"]));
			$stmt->execute();

		} else { 

			$sql = "UPDATE creditosxclientes set"
			." montocredito = ? "
			." WHERE "
			." codcliente = ? AND codsucursal = ?;
			";
			$stmt = $this->dbh->prepare($sql);
			$stmt->bindParam(1, $montocredito);
			$stmt->bindParam(2, $codcliente);
			$stmt->bindParam(3, $codsucursal);

			$montocredito = number_format($montoactual+($_POST["txtTotal"]-$_POST["montoabono"]), 2, '.', '');
			$codsucursal  = limpiar(decrypt($_POST["codsucursal"]));
			$stmt->execute();
		}

		if (limpiar($_POST["montoabono"]!="0.00" && $_POST["montoabono"]!="0" && $_POST["montoabono"]!="")) {
			
			$query = "INSERT INTO abonoscreditosventas values (null, ?, ?, ?, ?, ?, ?, ?, ?); ";
			$stmt = $this->dbh->prepare($query);
			$stmt->bindParam(1, $codarqueo);
			$stmt->bindParam(2, $codcaja);
			$stmt->bindParam(3, $codventa);
			$stmt->bindParam(4, $codcliente);
			$stmt->bindParam(5, $montoabono);
			$stmt->bindParam(6, $formaabono);
			$stmt->bindParam(7, $fechaabono);
			$stmt->bindParam(8, $codsucursal);

			$montoabono  = number_format($_POST["montoabono"], 2, '.', '');
			$formaabono  = decrypt($_POST["formaabono"]);
			$fechaabono  = limpiar($fecha);
			$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
			$stmt->execute();
		}
	}
	################ AGREGAMOS EL INGRESO Y ABONOS A CREDITO ################

    if($lioren_token != "" && $_POST["bpsii"] == 1){//verifico si existe token de lioren

    $lioren = new Lioren();
    $lioren->enviarVenta($codventa);

    $encCodVenta    = encrypt($codventa);
	$encCodSucursal = encrypt($codsucursal);
	//$encTipo      = ($tipodocumento == "FACTURA_A4" ? encrypt("FACTURA") : encrypt($tipodocumento));
	$encTipo        = encrypt($tipodocumento);
	$url            = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' ? 'https://' : 'http://').$_SERVER['HTTP_HOST']."/".$this->carpeta."/reportepdf?codventa=$encCodVenta&codsucursal=$encCodSucursal&tipo=$encTipo";

        echo "<span class='fa fa-check-square-o'></span> LA COTIZACION HA SIDO PROCESADA COMO VENTA EXITOSAMENTE <a href='$url' class='on-default' data-placement='left' data-toggle='tooltip' data-original-title='Imprimir Documento' target='_black' rel='noopener noreferrer'><font color='black'><strong>IMPRIMIR REPORTE</strong></font color></a></div>";

        echo "<script>VentanaCentrada('reportepdf?codventa=".encrypt($codventa)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt($tipodocumento)."', '', '', '1024', '568', 'true');</script>";
	   exit;

   } else {

   	    echo "<span class='fa fa-check-square-o'></span> LA COTIZACION HA SIDO PROCESADA COMO VENTA EXITOSAMENTE <a href='reportepdf?codventa=".encrypt($codventa)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt($tipodocumento)."' class='on-default' data-placement='left' data-toggle='tooltip' data-original-title='Imprimir Documento' target='_black' rel='noopener noreferrer'><font color='black'><strong>IMPRIMIR REPORTE</strong></font color></a></div>";

        echo "<script>VentanaCentrada('reportepdf?codventa=".encrypt($codventa)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt($tipodocumento)."', '', '', '1024', '568', 'true');</script>";
	    exit;
	}
}
###################### FUNCION PROCESAR COTIZACIONES A VENTAS #################################

###################### FUNCION BUSQUEDA COTIZACIONES POR FECHAS ####################
public function BuscarCotizacionesxFechas() 
{
	$this->p = [];
	$codSucursal      = isset($_GET["codsucursal"]) ? limpiar(decrypt($_GET['codsucursal'])) : '';
	$fechaDesde       = isset($_GET['desde']) ? limpiar(date("Y-m-d", strtotime($_GET['desde']))) : '';
    $fechaHasta       = isset($_GET['hasta']) ? limpiar(date("Y-m-d", strtotime($_GET['hasta']))) : '';
	$whereConditions  = [];
    $params           = [];

	$sqlBase = "SELECT
        cot.idcotizacion, cot.codcotizacion, cot.tipodocumento, cot.codfactura, cot.codcliente, 
        cot.subtotalivasi, cot.subtotalivano, cot.iva, cot.totaliva, cot.descontado,cot.descuento, 
		cot.totaldescuento, cot.totalpago, cot.totalpago2, cot.observaciones, cot.fechacotizacion, 
		cot.procesada, cot.codigo, cot.codsucursal,
		suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
		suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
		tm.moneda, tm.siglas, tm.simbolo,
		usu.dni, usu.nombres,
		cl.tipocliente, cl.documcliente, cl.dnicliente,
		CONCAT(if(cl.tipocliente='NATURAL',cl.nomcliente,cl.razoncliente)) as nomcliente,
		cl.girocliente, cl.tlfcliente, cl.id_ciudad AS id_ciudad2, cl.id_comuna AS id_comuna2, 
		cl.direccliente, cl.emailcliente, cl.limitecredito,
		doc.documento, doc2.documento AS documento2, doc3.documento AS documento3,
		pag.articulos, pag.detalles_productos
    FROM 
        cotizaciones cot LEFT JOIN sucursales suc ON cot.codsucursal = suc.codsucursal
	LEFT JOIN 
	    documentos doc ON suc.documsucursal = doc.coddocumento
	LEFT JOIN 
	    documentos AS doc2 ON suc.documencargado = doc2.coddocumento
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
	LEFT JOIN 
	    clientes cl ON cot.codcliente = cl.codcliente
	LEFT JOIN 
	    documentos AS doc3 ON cl.documcliente = doc3.coddocumento 
	LEFT JOIN 
	    usuarios usu ON cot.codigo = usu.codigo
    LEFT JOIN
        (SELECT
            dcot.codcotizacion,
            SUM(dcot.cantcotizacion) AS articulos,
            GROUP_CONCAT(
            CONCAT_WS(
               ' | ',
               dcot.cantcotizacion,
               dcot.producto,
               dcot.descripcion,
               IFNULL(mar.nommarca, ''),
               IFNULL(mode.nommodelo, ''),
               IFNULL(pres.nompresentacion, ''),
               IFNULL(col.nomcolor, '')
            )
                ORDER BY dcot.producto
                SEPARATOR '<br>'
            ) AS detalles_productos
            FROM
                detallecotizaciones dcot
            LEFT JOIN 
                marcas mar ON dcot.codmarca = mar.codmarca
		    LEFT JOIN 
		        modelos mode ON dcot.codmodelo = mode.codmodelo 
		    LEFT JOIN 
		        presentaciones pres ON dcot.codpresentacion = pres.codpresentacion
			LEFT JOIN 
			    colores col ON dcot.codcolor = col.codcolor
			WHERE dcot.codsucursal = ?
	    GROUP BY
	        dcot.codcotizacion
	    ) pag ON pag.codcotizacion = cot.codcotizacion";
    //Condicion de Sucursal
    if (!empty($codSucursal)) {
        $whereConditions[] = "cot.codsucursal = ?";
        $params[]          = $codSucursal;
    }
	//Condicion de Fechas
	if (!empty($fechaDesde) && !empty($fechaHasta)) {
	    $whereConditions[] = "DATE_FORMAT(cot.fechacotizacion,'%Y-%m-%d') BETWEEN ? AND ?";
	    $params[]          = $fechaDesde;
	    $params[]          = $fechaHasta;
	}
	$whereClause = "";
	if (!empty($whereConditions)) {
	    $whereClause = " WHERE " . implode(" AND ", $whereConditions);
	}
	$sql = $sqlBase . $whereClause . " ORDER BY cot.codcotizacion ASC";
	try {
	    $stmt = $this->dbh->prepare($sql);
        array_unshift($params, $codSucursal);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
	    if (empty($results)) {
	        echo "<div class='alert alert-danger'>";
	        echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	        echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS PARA TU BÚSQUEDA REALIZADA</center>";
	        echo "</div>";
	        exit();
	    } else {
	        return $results;
	    }
	} catch (PDOException $e) {
	    error_log("Error en BuscarCotizacionesxFechas: " . $e->getMessage());
	    echo "<div class='alert alert-danger'>";
	    echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	    echo "<center><span class='fa fa-exclamation-triangle'></span> OCURRIÓ UN ERROR AL CONSULTAR LAS COTIZACIONES.</center>";
	    echo "</div>";
	    return [];
	}
}
################### FUNCION BUSQUEDA COTIZACIONES POR FECHAS ###################

###################### FUNCION BUSCAR DETALLES COTIZACIONES POR FECHAS #########################
public function BuscarDetallesCotizacionesxFechas() 
{
    $this->p = [];
	$codSucursal         = isset($_GET["codsucursal"]) ? limpiar(decrypt($_GET['codsucursal'])) : '';
	$fechaDesde          = isset($_GET['desde']) ? limpiar(date("Y-m-d", strtotime($_GET['desde']))) : '';
    $fechaHasta          = isset($_GET['hasta']) ? limpiar(date("Y-m-d", strtotime($_GET['hasta']))) : '';
	$whereConditions     = [];
    $params              = [];

    $sqlBase = "SELECT
        dcot.idproducto, dcot.codproducto, dcot.producto, dcot.descripcion, dcot.opcionvendido,
		dcot.imei, dcot.condicion, dcot.codmarca, dcot.codmodelo, dcot.codpresentacion, dcot.codcolor, 
		dcot.preciocompra, dcot.precioventa, dcot.ivaproducto, dcot.descproducto, dcot.tipodetalle,
	    suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
		suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
		doc.documento, doc2.documento AS documento2, tm.moneda, tm.siglas, tm.simbolo,
	    mar.nommarca, mode.nommodelo, pres.nompresentacion, col.nomcolor,
        SUM(dcot.cantcotizacion) AS cantidad,
        prod.existencia AS existencia,
        com.existencia AS cantcombo
    FROM
        cotizaciones cot
    INNER JOIN
        detallecotizaciones dcot ON cot.codcotizacion = dcot.codcotizacion
    LEFT JOIN 
	    sucursales suc ON cot.codsucursal = suc.codsucursal 
	LEFT JOIN 
	    documentos doc ON suc.documsucursal = doc.coddocumento
	LEFT JOIN 
	    documentos AS doc2 ON suc.documencargado = doc2.coddocumento
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
    LEFT JOIN 
        marcas mar ON dcot.codmarca = mar.codmarca 
    LEFT JOIN
        modelos mode ON dcot.codmodelo = mode.codmodelo  
	LEFT JOIN 
	    presentaciones pres ON dcot.codpresentacion = pres.codpresentacion
    LEFT JOIN 
        colores col ON dcot.codcolor = col.codcolor  
    LEFT JOIN
        productos prod ON dcot.tipodetalle = 1 AND prod.idproducto = dcot.idproducto
    LEFT JOIN
        combos com ON dcot.tipodetalle = 2 AND com.idcombo = dcot.idproducto ";
    //Condicion de Sucursal
    if (!empty($codSucursal)) {
        $whereConditions[] = "cot.codsucursal = ?";
        $params[]          = $codSucursal;
    }
    //Condicion de Fechas
    if (!empty($fechaDesde) && !empty($fechaHasta)) {
        $whereConditions[] = "DATE_FORMAT(cot.fechacotizacion,'%Y-%m-%d') BETWEEN ? AND ?";
        $params[] = $fechaDesde;
        $params[] = $fechaHasta;
    }
    $whereClause = "";
    if (!empty($whereConditions)) {
        $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $groupByClause = " GROUP BY ";
    $groupByClause .= "dcot.idproducto, dcot.codproducto, dcot.producto, dcot.descripcion, dcot.opcionvendido,
		dcot.imei, dcot.condicion, dcot.codmarca, dcot.codmodelo, dcot.codpresentacion, dcot.codcolor, 
		dcot.preciocompra, dcot.precioventa, dcot.ivaproducto, dcot.descproducto, dcot.tipodetalle,
	    suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
		suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
		doc.documento, documento2, tm.moneda, tm.siglas, tm.simbolo,
		mar.nommarca, mode.nommodelo, pres.nompresentacion, col.nomcolor,
	    existencia,
        cantcombo";
    $sql = $sqlBase . $whereClause . $groupByClause . " ORDER BY dcot.codproducto ASC";
    try {
        $stmt = $this->dbh->prepare($sql);// Preparar y ejecutar la consulta
        $stmt->execute($params); // Pasamos todos los parámetros juntos
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($results)) {
            echo "<div class='alert alert-danger'>";
            echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
            echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS PARA TU BÚSQUEDA REALIZADA</center>";
            echo "</div>";
            exit();
        } else {
            return $results;
        }
    } catch (PDOException $e) {
        error_log("Error en BuscarDetallesCotizacionesxFechas: " . $e->getMessage());
        echo "<div class='alert alert-danger'>";
        echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
        echo "<center><span class='fa fa-exclamation-triangle'></span> OCURRIÓ UN ERROR AL CONSULTAR LOS DETALLES DE COTIZACIONES.</center>";
        echo "</div>";
        exit();
    }
}
########################### FUNCION BUSCAR DETALLES COTIZACIONES POR FECHAS ###############################

###################### FUNCION BUSCAR DETALLES COTIZACIONES POR VENDEDOR #########################
public function BuscarDetallesCotizacionesxVendedor() 
{
    $this->p = [];
	$codSucursal         = isset($_GET["codsucursal"]) ? limpiar(decrypt($_GET['codsucursal'])) : '';
	$codUsuarioBusqueda = isset($_GET['codigo']) ? limpiar(trim($_GET['codigo'])) : null;
	$fechaDesde          = isset($_GET['desde']) ? limpiar(date("Y-m-d", strtotime($_GET['desde']))) : '';
    $fechaHasta          = isset($_GET['hasta']) ? limpiar(date("Y-m-d", strtotime($_GET['hasta']))) : '';
	$whereConditions     = [];
    $params              = [];

    $sqlBase = "SELECT
        dcot.idproducto, dcot.codproducto, dcot.producto, dcot.descripcion, dcot.opcionvendido,
		dcot.imei, dcot.condicion, dcot.codmarca, dcot.codmodelo, dcot.codpresentacion, dcot.codcolor, 
		dcot.preciocompra, dcot.precioventa, dcot.ivaproducto, dcot.descproducto, dcot.tipodetalle,
	    suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
		suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
		doc.documento, doc2.documento AS documento2, tm.moneda, tm.siglas, tm.simbolo,
	    mar.nommarca, mode.nommodelo, pres.nompresentacion, col.nomcolor,
	    usu.dni, usu.nombres,
        SUM(dcot.cantcotizacion) AS cantidad,
        prod.existencia AS existencia,
        com.existencia AS cantcombo
    FROM
        cotizaciones cot
    INNER JOIN
        detallecotizaciones dcot ON cot.codcotizacion = dcot.codcotizacion
	LEFT JOIN 
	    usuarios usu ON cot.codigo = usu.codigo
    LEFT JOIN 
	    sucursales suc ON cot.codsucursal = suc.codsucursal 
	LEFT JOIN 
	    documentos doc ON suc.documsucursal = doc.coddocumento
	LEFT JOIN 
	    documentos AS doc2 ON suc.documencargado = doc2.coddocumento
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
    LEFT JOIN 
        marcas mar ON dcot.codmarca = mar.codmarca 
    LEFT JOIN
        modelos mode ON dcot.codmodelo = mode.codmodelo  
	LEFT JOIN 
	    presentaciones pres ON dcot.codpresentacion = pres.codpresentacion
    LEFT JOIN 
        colores col ON dcot.codcolor = col.codcolor  
    LEFT JOIN
        productos prod ON dcot.tipodetalle = 1 AND prod.idproducto = dcot.idproducto
    LEFT JOIN
        combos com ON dcot.tipodetalle = 2 AND com.idcombo = dcot.idproducto ";
    //Condicion de Sucursal
    if (!empty($codSucursal)) {
        $whereConditions[] = "cot.codsucursal = ?";
        $params[]          = $codSucursal;
    }
    //Condicion de Usuario
    if (!empty($codUsuarioBusqueda)) {
        $whereConditions[] = "cot.codigo = ?";
        $params[]          = $codUsuarioBusqueda;
    }
    //Condicion de Fechas
    if (!empty($fechaDesde) && !empty($fechaHasta)) {
        $whereConditions[] = "DATE_FORMAT(cot.fechacotizacion,'%Y-%m-%d') BETWEEN ? AND ?";
        $params[] = $fechaDesde;
        $params[] = $fechaHasta;
    }
    $whereClause = "";
    if (!empty($whereConditions)) {
        $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $groupByClause = " GROUP BY ";
    $groupByClause .= "dcot.idproducto, dcot.codproducto, dcot.producto, dcot.descripcion, dcot.opcionvendido,
		dcot.imei, dcot.condicion, dcot.codmarca, dcot.codmodelo, dcot.codpresentacion, dcot.codcolor, 
		dcot.preciocompra, dcot.precioventa, dcot.ivaproducto, dcot.descproducto, dcot.tipodetalle,
	    suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
		suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
		doc.documento, documento2, tm.moneda, tm.siglas, tm.simbolo,
		mar.nommarca, mode.nommodelo, pres.nompresentacion, col.nomcolor,
	    usu.dni, usu.nombres,
	    existencia,
        cantcombo";
    $sql = $sqlBase . $whereClause . $groupByClause . " ORDER BY dcot.codproducto ASC";
    try {
        $stmt = $this->dbh->prepare($sql);// Preparar y ejecutar la consulta
        $stmt->execute($params); // Pasamos todos los parámetros juntos
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($results)) {
            echo "<div class='alert alert-danger'>";
            echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
            echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS PARA TU BÚSQUEDA REALIZADA</center>";
            echo "</div>";
            exit();
        } else {
            return $results;
        }
    } catch (PDOException $e) {
        error_log("Error en BuscarDetallesCotizacionesxFechas: " . $e->getMessage());
        echo "<div class='alert alert-danger'>";
        echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
        echo "<center><span class='fa fa-exclamation-triangle'></span> OCURRIÓ UN ERROR AL CONSULTAR LOS DETALLES DE COTIZACIONES.</center>";
        echo "</div>";
        exit();
    }
}
########################### FUNCION BUSCAR DETALLES COTIZACIONES POR VENDEDOR ###############################

########################### FIN DE CLASE COTIZACIONES ############################





























############################## CLASE PREVENTAS ###################################

########################### FUNCION REGISTRAR PREVENTAS ##########################
public function RegistrarPreventas()
{
	$this->p = [];
	if(empty($_POST["codsucursal"]) or empty($_POST["txtTotal"]))
	{
		echo "1";
		exit;
	}
	elseif(empty($_SESSION["CarritoPreventa"]))
	{
		echo "2";
		exit;
	}

	############ VALIDO SI LA CANTIDAD ES MAYOR QUE LA EXISTENCIA #############
	$v = $_SESSION["CarritoPreventa"];
    for ($i = 0, $iMax = count($v); $i < $iMax; $i++) {

	    if($v[$i]['tipodetalle'] == 1){ 

	    $sql = "SELECT existencia FROM productos 
	    WHERE idproducto = '".limpiar($v[$i]['id'])."' 
	    AND codproducto = '".limpiar($v[$i]['txtCodigo'])."' 
	    AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
	    foreach ($this->dbh->query($sql) as $row)
	    {
		    $this->p[] = $row;
	    }
	
	    $existenciabd = $row['existencia'];
	    $cantidad     = $v[$i]['cantidad'];

	        if ($cantidad > $existenciabd) 
	        { 
		        echo "3";
		        exit;
	        }

		} elseif(limpiar($v[$i]['tipodetalle']) == 2){ // SI EL DETALLE ES UN COMBO

			$sql = "SELECT 
		    existencia 
		    FROM combos 
		    WHERE idcombo = '".limpiar($v[$i]['id'])."' 
	        AND codcombo = '".limpiar($v[$i]['txtCodigo'])."'
		    AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		    foreach ($this->dbh->query($sql) as $row)
		    {
			   $this->p[] = $row;
		    }
		
		    $existenciabd = $row['existencia'];
		    $cantidad     = $v[$i]['cantidad'];

	        if ($cantidad > $existenciabd) 
	        { 
		        echo "4";
		        exit;
	        }

		    $sql = "SELECT * FROM combosxproductos WHERE codcombo = ? AND codsucursal = ?";
			$stmt = $this->dbh->prepare($sql);
			$stmt->execute(array($v[$i]['txtCodigo'],limpiar(decrypt($_POST["codsucursal"]))));
			$num = $stmt->rowCount();
	        if($num>0) {  

	        	$sql = "SELECT 
	        	combosxproductos.codcombo,
	    	    combosxproductos.idproducto,
	        	combosxproductos.codproducto,
	        	combosxproductos.cantidad,
	        	combosxproductos.codsucursal,
	        	productos.existencia
	        	FROM combosxproductos 
	        	LEFT JOIN productos ON combosxproductos.codproducto = productos.codproducto 
	        	WHERE combosxproductos.codcombo IN ('".limpiar($v[$i]['txtCodigo'])."') 
	        	AND combosxproductos.codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."' 
	    	    AND productos.codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
	        	foreach ($this->dbh->query($sql) as $row)
			    { 
				    $this->p[] = $row;

				    $cantracionbd2  = $row['cantidad'];
				    $idproductobd2  = $row['idproducto'];
				    $codproductobd2 = $row['codproducto'];
				    $existenciabd2  = $row['existencia'];
			        $racion         = number_format($cantracionbd2*$v[$i]['cantidad'], 2, '.', '');

			        if ($racion > $existenciabd2) 
			        { 
			            echo "5";
			        	exit;
			        }
			    }
		    }//fin de consulta de productos de combos	
		    ############## VERIFICO SI EL COMBO TIENE PRODUCTO RELACIONADOS #################
	    }
	}
	############ VALIDO SI LA CANTIDAD ES MAYOR QUE LA EXISTENCIA #############

	################### SELECCIONE LOS DATOS DEL CLIENTE ######################
    $sql = "SELECT
    codcliente
    FROM clientes
    WHERE dnicliente = ?
    AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(limpiar($_POST['nrodocumento']),decrypt($_POST["codsucursal"])));
	$num = $stmt->rowCount();
	if($row = $stmt->fetch(PDO::FETCH_ASSOC))
	{
		$p[] = $row;
	}
	$codcliente = (empty($row['codcliente']) ? "0" : $row['codcliente']);
    ################### SELECCIONE LOS DATOS DEL CLIENTE ######################

    ################# OBTENGO DATOS DE SUCURSAL #################
	$sql = " SELECT 
	cuitsucursal, 
	nroactividadsucursal 
	FROM sucursales WHERE codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$cuitsucursal = $row['cuitsucursal'];
	$nroactividad = $row['nroactividadsucursal'];
	################# OBTENGO DATOS DE SUCURSAL #################

	################ CREO CODIGO DE PREVENTA ####################
	$sql = "SELECT codpreventa FROM preventas 
	ORDER BY idpreventa DESC LIMIT 1";
	foreach ($this->dbh->query($sql) as $row){

		$preventa=$row["codpreventa"];
	}
	if(empty($preventa))
	{
		$codpreventa = "01";

	} else {

		$num         = substr($preventa, 0);
        $dig         = $num + 1;
        $codigofinal = str_pad($dig, 2, "0", STR_PAD_LEFT);
        $codpreventa = $codigofinal;
	}
    ################ CREO CODIGO DE PREVENTA ###############

	################### CREO CODIGO DE FACTURA ####################
	$sql4 = "SELECT codfactura FROM preventas 
	WHERE codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."' 
	ORDER BY idpreventa DESC LIMIT 1";
	foreach ($this->dbh->query($sql4) as $row4){

		$factura = $row4["codfactura"];
	}
	if(empty($factura))
	{
		$codfactura = "0000001";

	} else {

		$var = strlen("");
        $var1 = substr($factura , $var);
        $var2 = strlen($var1);
        $var3 = $var1 + 1;
        $var4 = str_pad($var3, $var2, "0", STR_PAD_LEFT);
        $codfactura = $var4;
	}
    ################### CREO LOS CODIGO DE PREVENTA ####################

    ################### REGISTRO LA PREVENTA ####################
    $query = "INSERT INTO preventas values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $codpreventa);
	$stmt->bindParam(2, $codfactura);
	$stmt->bindParam(3, $codcliente);
	$stmt->bindParam(4, $subtotalivasi);
	$stmt->bindParam(5, $subtotalivano);
	$stmt->bindParam(6, $iva);
	$stmt->bindParam(7, $totaliva);
	$stmt->bindParam(8, $descontado);
	$stmt->bindParam(9, $descuento);
	$stmt->bindParam(10, $totaldescuento);
	$stmt->bindParam(11, $totalpago);
	$stmt->bindParam(12, $totalpago2);
	$stmt->bindParam(13, $observaciones);
	$stmt->bindParam(14, $fechapreventa);
	$stmt->bindParam(15, $procesada);
	$stmt->bindParam(16, $codigo);
	$stmt->bindParam(17, $codsucursal);
    
	$subtotalivasi  = limpiar($_POST["txtsubtotal"]);
	$subtotalivano  = limpiar($_POST["txtsubtotal2"]);
	$iva            = limpiar($_POST["iva"]);
	$totaliva       = limpiar($_POST["txtIva"]);
	$descontado     = limpiar($_POST["txtdescontado"]);
	$descuento      = limpiar($_POST["descuento"]);
	$totaldescuento = limpiar($_POST["txtDescuento"]);
	$totalpago      = limpiar($_POST["txtTotal"]);
	$totalpago2     = limpiar($_POST["txtTotalCompra"]);
	$observaciones  = limpiar($_POST["observaciones"]);
    $fechapreventa  = limpiar(date("Y-m-d H:i:s"));
	$procesada      = limpiar("1");
	$codigo         = limpiar($_SESSION["codigo"]);
	$codsucursal    = limpiar(decrypt($_POST["codsucursal"]));
	$stmt->execute();
	################### REGISTRO LA PREVENTA ####################
	
	$this->dbh->beginTransaction();
	$detalle = $_SESSION["CarritoPreventa"];
	for($i=0;$i<count($detalle);$i++){

	################### REGISTRO DETALLES DE PREVENTA ####################
	$query = "INSERT INTO detallepreventas values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $codpreventa);
	$stmt->bindParam(2, $idproducto);
    $stmt->bindParam(3, $codproducto);
    $stmt->bindParam(4, $producto);
	$stmt->bindParam(5, $descripcion);
    $stmt->bindParam(6, $opcionvendido);
	$stmt->bindParam(7, $imei);
	$stmt->bindParam(8, $condicion);
    $stmt->bindParam(9, $codmarca);
    $stmt->bindParam(10, $codmodelo);
    $stmt->bindParam(11, $codpresentacion);
	$stmt->bindParam(12, $codcolor);
	$stmt->bindParam(13, $cantidad);
	$stmt->bindParam(14, $preciocompra);
	$stmt->bindParam(15, $precioventa);
	$stmt->bindParam(16, $ivaproducto);
	$stmt->bindParam(17, $descproducto);
	$stmt->bindParam(18, $valortotal);
	$stmt->bindParam(19, $totaldescuentov);
	$stmt->bindParam(20, $subtotalimpuestos);
	$stmt->bindParam(21, $valorneto);
	$stmt->bindParam(22, $valorneto2);
	$stmt->bindParam(23, $tipodetalle);
	$stmt->bindParam(24, $codsucursal);

	$idproducto      = limpiar($detalle[$i]['tipodetalle'] == "3" ? "0" : $detalle[$i]['id']);
	$codproducto     = limpiar($detalle[$i]['tipodetalle'] == "3" ? "0" : $detalle[$i]['txtCodigo']);
	$producto        = limpiar($detalle[$i]['producto']);
	$descripcion     = limpiar($detalle[$i]['tipodetalle'] == "3" || $detalle[$i]['descripcion'] == "0" ? "" : $detalle[$i]['descripcion']);
	$opcionvendido   = limpiar($detalle[$i]['opcionvendido']);
	$imei            = limpiar($detalle[$i]['tipodetalle'] == "3" || $detalle[$i]['imei'] == "0" ? "" : $detalle[$i]['imei']);
	$condicion       = limpiar($detalle[$i]['tipodetalle'] == "3" || $detalle[$i]['condicion'] == "0" ? "" : $detalle[$i]['condicion']);
	$codmarca        = limpiar($detalle[$i]['tipodetalle'] == "3" ? "0" : $detalle[$i]['codmarca']);
	$codmodelo       = limpiar($detalle[$i]['tipodetalle'] == "3" ? "0" : $detalle[$i]['codmodelo']);
	$codpresentacion = limpiar($detalle[$i]['tipodetalle'] == "3" ? "0" : $detalle[$i]['codpresentacion']);
	$codcolor        = limpiar($detalle[$i]['tipodetalle'] == "3" ? "0" : $detalle[$i]['codcolor']);
	$cantidad        = $detalle[$i]['opcionvendido'] == "2" ? number_format($detalle[$i]['cantidad'], 3, '.', '') : number_format($detalle[$i]['cantidad'], 0, '.', '');
	$preciocompra    = limpiar($detalle[$i]['precio']);
	$precioventa     = limpiar($detalle[$i]['precio2']);
	$precioconiva    = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['precio2']);
	$ivaproducto     = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
	$descproducto    = limpiar($detalle[$i]['descproducto']);
	$descuento       = $detalle[$i]['descproducto']/100;
	$valortotal      = number_format($detalle[$i]['precio2']*$detalle[$i]['cantidad'], 2, '.', '');
	$totaldescuentov = number_format($valortotal*$descuento, 2, '.', '');

	//CALCULO SUBTOTAL IMPUESTOS
	$ValorImpuesto        = 1 + ($_POST["iva"]/100);
	$RestoDescuento       = $precioconiva * $detalle[$i]['descproducto'] / 100;
	$PrecioIvaDescuento   = $precioconiva - $RestoDescuento;
	$Discriminado         = $PrecioIvaDescuento/$ValorImpuesto;
	$SubtotalDiscriminado = $PrecioIvaDescuento - $Discriminado;
    $BaseDiscriminado     = $SubtotalDiscriminado * $detalle[$i]['cantidad'];
    $subtotalimpuestos    = number_format($BaseDiscriminado, 2, '.', '');

    $valorneto      = number_format($valortotal-$totaldescuentov, 2, '.', '');
	$valorneto2     = limpiar($detalle[$i]['tipodetalle'] == "3" ? "0.00" : number_format($detalle[$i]['precio']*$detalle[$i]['cantidad'], 2, '.', ''));
    $tipodetalle    = limpiar($detalle[$i]['tipodetalle']);
	$codsucursal    = limpiar(decrypt($_POST["codsucursal"]));
	$stmt->execute();
	################### REGISTRO DETALLES DE PREVENTA ####################

	if(limpiar($detalle[$i]['tipodetalle'])==1){ // SI EL DETALLE ES UN PRODUCTO

	    ################ VERIFICO LA EXISTENCIA DEL PRODUCTO EN ALMACEN ################
		$sql = "SELECT * FROM productos 
		WHERE idproducto = '".limpiar($detalle[$i]['id'])."' 
	    AND codproducto = '".limpiar($detalle[$i]['txtCodigo'])."' 
		AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		$existenciabd = $row['existencia'];
	    ################ VERIFICO LA EXISTENCIA DEL PRODUCTO EN ALMACEN ################

	    ##################### ACTUALIZO LA EXISTENCIA DEL ALMACEN ####################
		$sql = " UPDATE productos set "
		." existencia = ? "
		." WHERE "
		." idproducto = '".limpiar($detalle[$i]['id'])."' 
	    AND codproducto = '".limpiar($detalle[$i]['txtCodigo'])."' 
		AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."';
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $existencia);

		$cantventa  = $detalle[$i]['opcionvendido'] == "2" ? number_format($detalle[$i]['cantidad'], 3, '.', '') : number_format($detalle[$i]['cantidad'], 0, '.', '');
		$existencia = $detalle[$i]['opcionvendido'] == "2" ? number_format($existenciabd-$detalle[$i]['cantidad'], 3, '.', '') : number_format($existenciabd-$detalle[$i]['cantidad'], 0, '.', '');
		$stmt->execute();
	    ##################### ACTUALIZO LA EXISTENCIA DEL ALMACEN ####################
 
	    ############### REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX ###############
	    $query = "INSERT INTO kardex values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codpreventa);
		$stmt->bindParam(2, $codcliente);
		$stmt->bindParam(3, $codproducto);
		$stmt->bindParam(4, $movimiento);
		$stmt->bindParam(5, $entradas);
		$stmt->bindParam(6, $salidas);
		$stmt->bindParam(7, $devolucion);
		$stmt->bindParam(8, $stockactual);
		$stmt->bindParam(9, $ivaproducto);
		$stmt->bindParam(10, $descproducto);
		$stmt->bindParam(11, $precio);
		$stmt->bindParam(12, $documento);
		$stmt->bindParam(13, $fechakardex);	
	    $stmt->bindParam(14, $tipokardex);	
	    $stmt->bindParam(15, $procedimiento);			
		$stmt->bindParam(16, $codsucursal);
		$stmt->bindParam(17, $codigo);

		$codproducto   = limpiar($detalle[$i]['txtCodigo']);
		$movimiento    = limpiar("SALIDAS");
		$entradas      = $detalle[$i]['opcionvendido'] == "2" ? "0.000" : "0";
		$salidas       = $detalle[$i]['opcionvendido'] == "2" ? number_format($detalle[$i]['cantidad'], 3, '.', '') : number_format($detalle[$i]['cantidad'], 0, '.', '');
		$devolucion    = $detalle[$i]['opcionvendido'] == "2" ? "0.000" : "0";
		$stockactual   = $detalle[$i]['opcionvendido'] == "2" ? number_format($existenciabd-$detalle[$i]['cantidad'], 3, '.', '') : number_format($existenciabd-$detalle[$i]['cantidad'], 0, '.', '');
		$ivaproducto   = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
		$descproducto  = number_format($detalle[$i]['descproducto'], 2, '.', '');
		$precio        = number_format($detalle[$i]["precio2"], 2, '.', '');
		$documento     = limpiar("PREVENTA: ".$codfactura);
		$fechakardex   = limpiar(date("Y-m-d"));
	    $tipokardex    = limpiar($detalle[$i]['tipodetalle']);
	    $procedimiento = limpiar("1");
		$codsucursal   = limpiar(decrypt($_POST["codsucursal"]));
    	$codigo        = limpiar($_SESSION["codigo"]);
		$stmt->execute();
		############### REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX ###############
    	
    } elseif(limpiar($detalle[$i]['tipodetalle']) == 2){ // SI EL DETALLE ES UN COMBO

	    ############## VERIFICO LA EXISTENCIA DEL COMBO EN ALMACEN #################
		$sql = "SELECT 
		existencia 
		FROM combos 
		WHERE idcombo = '".limpiar($detalle[$i]['id'])."' 
	    AND codcombo = '".limpiar($detalle[$i]['txtCodigo'])."'
		AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		$existenciacombobd = $row['existencia'];
		############## VERIFICO LA EXISTENCIA DEL COMBO EN ALMACEN #################

	    ##################### ACTUALIZO LA EXISTENCIA DEL COMBO DEL ALMACEN ####################
		$sql = " UPDATE combos set "
			." existencia = ? "
			." WHERE "
			." idcombo = '".limpiar($detalle[$i]['id'])."' 
	      AND codcombo = '".limpiar($detalle[$i]['txtCodigo'])."'
	      AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."';
			";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $existencia);
		$cantventa  = $detalle[$i]['opcionvendido'] == "2" ? number_format($detalle[$i]['cantidad'], 3, '.', '') : number_format($detalle[$i]['cantidad'], 0, '.', '');
		$existencia = $detalle[$i]['opcionvendido'] == "2" ? number_format($existenciacombobd-$detalle[$i]['cantidad'], 3, '.', '') : number_format($existenciacombobd-$detalle[$i]['cantidad'], 0, '.', '');
		$stmt->execute();
		##################### ACTUALIZO LA EXISTENCIA DEL COMBO DEL ALMACEN ####################

		############### REGISTRAMOS LOS DATOS DE COMBO EN KARDEX ###############
	    $query = "INSERT INTO kardex values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codpreventa);
		$stmt->bindParam(2, $codcliente);
		$stmt->bindParam(3, $codproducto);
		$stmt->bindParam(4, $movimiento);
		$stmt->bindParam(5, $entradas);
		$stmt->bindParam(6, $salidas);
		$stmt->bindParam(7, $devolucion);
		$stmt->bindParam(8, $stockactual);
		$stmt->bindParam(9, $ivaproducto);
		$stmt->bindParam(10, $descproducto);
		$stmt->bindParam(11, $precio);
		$stmt->bindParam(12, $documento);
		$stmt->bindParam(13, $fechakardex);	
	    $stmt->bindParam(14, $tipokardex);
	    $stmt->bindParam(15, $procedimiento);			
		$stmt->bindParam(16, $codsucursal);
		$stmt->bindParam(17, $codigo);

		$codproducto  = limpiar($detalle[$i]['txtCodigo']);
		$movimiento    = limpiar("SALIDAS");
		$entradas      = $detalle[$i]['opcionvendido'] == "2" ? "0.000" : "0";
		$salidas       = $detalle[$i]['opcionvendido'] == "2" ? number_format($detalle[$i]['cantidad'], 3, '.', '') : number_format($detalle[$i]['cantidad'], 0, '.', '');
		$devolucion    = $detalle[$i]['opcionvendido'] == "2" ? "0.000" : "0";
		$stockactual   = $detalle[$i]['opcionvendido'] == "2" ? number_format($existenciacombobd-$detalle[$i]['cantidad'], 3, '.', '') : number_format($existenciacombobd-$detalle[$i]['cantidad'], 0, '.', '');
		$ivaproducto   = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
		$descproducto  = number_format($detalle[$i]['descproducto'], 2, '.', '');
		$precio        = number_format($detalle[$i]["precio2"], 2, '.', '');
		$documento     = limpiar("PREVENTA: ".$codfactura);
		$fechakardex   = limpiar(date("Y-m-d"));
	    $tipokardex    = limpiar($detalle[$i]['tipodetalle']);
	    $procedimiento = limpiar("2");	
		$codsucursal   = limpiar(decrypt($_POST["codsucursal"]));
    	$codigo        = limpiar($_SESSION["codigo"]);
		$stmt->execute();
		############### REGISTRAMOS LOS DATOS DE COMBO EN KARDEX ###############

		############## VERIFICO SI EL COMBO TIENE PRODUCTO RELACIONADOS #################
	    $sql = "SELECT * FROM combosxproductos WHERE codcombo = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array($detalle[$i]['txtCodigo'],limpiar(decrypt($_POST["codsucursal"]))));
		$num = $stmt->rowCount();
	    if($num>0) {  

	    	$sql = "SELECT 
	    	combosxproductos.codcombo,
	    	combosxproductos.idproducto,
	    	combosxproductos.codproducto,
	    	combosxproductos.cantidad,
	    	combosxproductos.codsucursal,
	    	productos.opcionvendido,
	    	productos.existencia,
	    	productos.precioxpublico AS precioventa,
	    	productos.ivaproducto,
	    	productos.descproducto
	    	FROM combosxproductos 
	    	LEFT JOIN productos ON combosxproductos.codproducto = productos.codproducto 
	    	WHERE combosxproductos.codcombo IN ('".limpiar($detalle[$i]['txtCodigo'])."') 
	    	AND combosxproductos.codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."' 
	    	AND productos.codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
	    	foreach ($this->dbh->query($sql) as $row)
		    { 
			    $this->p[] = $row;

			    $cantracionbd2   = $row['cantidad'];
			    $idproductobd2   = $row['idproducto'];
			    $codproductobd2  = $row['codproducto'];
			    $existenciabd2   = $row['existencia'];
			    $precioventabd2  = $row['precioventa'];
			    $ivaproductobd2  = $row['ivaproducto'];
			    $descproductobd2 = $row['descproducto'];
			    $opcionvendido2  = $row['opcionvendido'];

			    ############## ACTUALIZO LOS DATOS DEL PRODUCTO #################
			    $update = "UPDATE productos set "
			    ." existencia = ? "
			    ." WHERE "
			    ." idproducto = ? AND codproducto = ? AND codsucursal = ?;
			    ";
			    $stmt = $this->dbh->prepare($update);
			    $stmt->bindParam(1, $cantidadracion);
			    $stmt->bindParam(2, $idproducto);
			    $stmt->bindParam(3, $codproducto);
	            $stmt->bindParam(4, $codsucursal);

			    $racion         = $cantracionbd2*$detalle[$i]['cantidad'];
			    $cantidadracion = $opcionvendido2 == "2" ? number_format($existenciabd2-$racion, 3, '.', '') : number_format($existenciabd2-$racion, 0, '.', '');
		        $idproducto     = limpiar($idproductobd2);
		        $codproducto    = limpiar($codproductobd2);
	            $codsucursal    = limpiar(decrypt($_POST["codsucursal"]));
			    $stmt->execute();
			    ############## ACTUALIZO LOS DATOS DEL PRODUCTO #################

			    ############## REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX ###################
			    $query = "INSERT INTO kardex values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
			    $stmt = $this->dbh->prepare($query);
			    $stmt->bindParam(1, $codpreventa);
			    $stmt->bindParam(2, $codcliente);
			    $stmt->bindParam(3, $codproducto);
			    $stmt->bindParam(4, $movimiento);
			    $stmt->bindParam(5, $entradas);
			    $stmt->bindParam(6, $salidas);
			    $stmt->bindParam(7, $devolucion);
			    $stmt->bindParam(8, $stockactual);
			    $stmt->bindParam(9, $ivaproducto);
			    $stmt->bindParam(10, $descproducto);
			    $stmt->bindParam(11, $precio);
			    $stmt->bindParam(12, $documento);
			    $stmt->bindParam(13, $fechakardex);
	            $stmt->bindParam(14, $tipokardex);
	    	    $stmt->bindParam(15, $procedimiento);	
	            $stmt->bindParam(16, $codsucursal);
		        $stmt->bindParam(17, $codigo);		

			    $codproducto   = limpiar($codproductobd2);
			    $movimiento    = limpiar("SALIDAS");
			    $entradas      = $opcionvendido2 == "2" ? "0.000" : "0";
			    $salidas       = $opcionvendido2 == "2" ? number_format($racion, 3, '.', '') : number_format($racion, 0, '.', '');
			    $devolucion    = $opcionvendido2 == "2" ? "0.000" : "0";
			    $stockactual   = $opcionvendido2 == "2" ? number_format($existenciabd2-$racion, 3, '.', '') : number_format($existenciabd2-$racion, 0, '.', '');
			    $ivaproducto   = limpiar($ivaproductobd2 == "NO" ? "0.00" : $_POST["iva"]);
			    $descproducto  = number_format($descproductobd2, 2, '.', '');
			    $precio        = number_format($precioventabd2, 2, '.', '');
			    $documento     = limpiar("PREVENTA (DETALLE DE COMBO): ".$codfactura);
			    $fechakardex   = limpiar(date("Y-m-d"));
	            $tipokardex    = limpiar("1");
	    	    $procedimiento = limpiar("2");
	            $codsucursal   = limpiar(decrypt($_POST["codsucursal"]));
    	        $codigo        = limpiar($_SESSION["codigo"]);
			    $stmt->execute();
			    ############## REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX ################### 
		    }
	    }//fin de consulta de productos de combos	
	    ############## VERIFICO SI EL COMBO TIENE PRODUCTO RELACIONADOS #################
    	
    } else { // SI EL DETALLE ES UN SERVICIO

	    ############### REGISTRAMOS LOS DATOS DE SERVICIO EN KARDEX ###############
	    $query = "INSERT INTO kardex values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codpreventa);
		$stmt->bindParam(2, $codcliente);
		$stmt->bindParam(3, $codproducto);
		$stmt->bindParam(4, $movimiento);
		$stmt->bindParam(5, $entradas);
		$stmt->bindParam(6, $salidas);
		$stmt->bindParam(7, $devolucion);
		$stmt->bindParam(8, $stockactual);
		$stmt->bindParam(9, $ivaproducto);
		$stmt->bindParam(10, $descproducto);
		$stmt->bindParam(11, $precio);
		$stmt->bindParam(12, $documento);
		$stmt->bindParam(13, $fechakardex);	
	    $stmt->bindParam(14, $tipokardex);	
	    $stmt->bindParam(15, $procedimiento);			
		$stmt->bindParam(16, $codsucursal);
		$stmt->bindParam(17, $codigo);

		$codproducto   = limpiar($detalle[$i]['txtCodigo']);
		$movimiento    = limpiar("SALIDAS");
		$entradas      = $detalle[$i]['opcionvendido'] == "2" ? "0.000" : "0";
		$salidas       = $detalle[$i]['opcionvendido'] == "2" ? number_format($detalle[$i]['cantidad'], 3, '.', '') : number_format($detalle[$i]['cantidad'], 0, '.', '');
		$devolucion    = $detalle[$i]['opcionvendido'] == "2" ? "0.000" : "0";
		$stockactual   = $detalle[$i]['opcionvendido'] == "2" ? "0.000" : "0";
		$ivaproducto   = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
		$descproducto  = number_format($detalle[$i]['descproducto'], 2, '.', '');
		$precio        = number_format($detalle[$i]["precio2"], 2, '.', '');
		$documento     = limpiar("PREVENTA: ".$codfactura);
		$fechakardex   = limpiar(date("Y-m-d"));
	    $tipokardex    = limpiar($detalle[$i]['tipodetalle']);
	    $procedimiento = limpiar("3");
		$codsucursal   = limpiar(decrypt($_POST["codsucursal"]));
    	$codigo        = limpiar($_SESSION["codigo"]);
		$stmt->execute();
		############### REGISTRAMOS LOS DATOS DE SERVICIO EN KARDEX ###############
        }
    }  
    ####################### DESTRUYO LA VARIABLE DE SESSION #####################
	unset($_SESSION["CarritoPreventa"]);
    $this->dbh->commit();
		
    echo "<span class='fa fa-check-square-o'></span> LA PREVENTA DE PRODUCTOS HA SIDO REGISTRADA EXITOSAMENTE <a href='reportepdf?codpreventa=".encrypt($codpreventa)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt("TICKETPREVENTA")."' class='on-default' data-placement='left' data-toggle='tooltip' data-original-title='Imprimir Documento' target='_black' rel='noopener noreferrer'><font color='black'><strong>IMPRIMIR REPORTE</strong></font color></a></div>";

    echo "<script>VentanaCentrada('reportepdf?codpreventa=".encrypt($codpreventa)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt("TICKETPREVENTA")."', '', '', '1024', '568', 'true');</script>";
	exit;
}
########################## FUNCION REGISTRAR PREVENTAS ############################

####################### FUNCION LISTAR PREVENTAS ################################
public function ListarPreventas()
{
	$this->p = [];
	$tipoAcceso      = isset($_SESSION["acceso"]) ? limpiar($_SESSION["acceso"]) : '';
	$codSucursal     = ($tipoAcceso === 'administradorG') ? limpiar(decrypt($_GET["codsucursal"])) : limpiar($_SESSION["codsucursal"]);	
    $codigoUsuario   = isset($_SESSION["codigo"]) ? limpiar($_SESSION["codigo"]) : '';
    $whereConditions = [];
    $params          = [];

    // Lógica de filtro basada en el tipo de acceso
    if ($tipoAcceso === 'cajero' || $tipoAcceso === 'vendedor') { // Acceso Cajero
        $whereConditions[] = "pre.codigo = ?";
        $params[]          = $codigoUsuario;
        $whereConditions[] = "pre.codsucursal = ?";
        $params[]          = $codSucursal;
    } else { // // Acceso Diferente a Cajero
        $whereConditions[] = "pre.codsucursal = ?";
        $params[]          = $codSucursal;
    }
   
    $whereClause = "";
    if (!empty($whereConditions)) {
      $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $sqlBase = "SELECT
        pre.idpreventa, pre.codpreventa, pre.codfactura, pre.codcliente, pre.subtotalivasi, pre.subtotalivano, 
        pre.iva, pre.totaliva, pre.descontado, pre.descuento, pre.totaldescuento, pre.totalpago, pre.totalpago2,
		pre.observaciones, pre.fechapreventa, pre.procesada, pre.codigo, pre.codsucursal,
		suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
		suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
		tm.moneda, tm.siglas, tm.simbolo,
		usu.dni, usu.nombres,
		cl.tipocliente, cl.documcliente, cl.dnicliente,
		CONCAT(if(cl.tipocliente='NATURAL',cl.nomcliente,cl.razoncliente)) as nomcliente,
		cl.girocliente, cl.tlfcliente, cl.id_ciudad AS id_ciudad2, cl.id_comuna AS id_comuna2, 
		cl.direccliente, cl.emailcliente, cl.limitecredito,
		doc.documento, doc2.documento AS documento2, doc3.documento AS documento3,
		pag.articulos, pag.detalles_productos
    FROM 
        preventas pre LEFT JOIN sucursales suc ON pre.codsucursal = suc.codsucursal
	LEFT JOIN 
	    documentos doc ON suc.documsucursal = doc.coddocumento
	LEFT JOIN 
	    documentos AS doc2 ON suc.documencargado = doc2.coddocumento
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
	LEFT JOIN 
	    clientes cl ON pre.codcliente = cl.codcliente
	LEFT JOIN 
	    documentos AS doc3 ON cl.documcliente = doc3.coddocumento 
	LEFT JOIN 
	    usuarios usu ON pre.codigo = usu.codigo
    LEFT JOIN
        (SELECT
            dpre.codpreventa,
            SUM(dpre.cantpreventa) AS articulos,
            GROUP_CONCAT(
            CONCAT_WS(
               ' | ',
               dpre.cantpreventa,
               dpre.producto,
               dpre.descripcion,
               IFNULL(mar.nommarca, ''),
               IFNULL(mode.nommodelo, ''),
               IFNULL(pres.nompresentacion, ''),
               IFNULL(col.nomcolor, '')
            )
                ORDER BY dpre.producto
                SEPARATOR '<br>'
            ) AS detalles_productos
            FROM
                detallepreventas dpre
            LEFT JOIN 
                marcas mar ON dpre.codmarca = mar.codmarca
		    LEFT JOIN 
		        modelos mode ON dpre.codmodelo = mode.codmodelo 
		    LEFT JOIN 
		        presentaciones pres ON dpre.codpresentacion = pres.codpresentacion
			LEFT JOIN 
			    colores col ON dpre.codcolor = col.codcolor
			WHERE dpre.codsucursal = $codSucursal
	    GROUP BY
	        dpre.codpreventa
	    ) pag ON pag.codpreventa = pre.codpreventa";
    $sql = $sqlBase . $whereClause . " ORDER BY pre.fechapreventa DESC";
    try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($results)) {
            return [];
        } else {
            return $results;
        }
    } catch (PDOException $e) {
        error_log("Error en ListarPreventas: " . $e->getMessage());
        return [];
    }
}
######################### FUNCION LISTAR PREVENTAS ############################

####################### FUNCION LISTAR CLIENTES CON PREVENTAS ################################
public function ListarClientesxPreventas()
{
	$this->p = [];
	$tipoAcceso      = isset($_SESSION["acceso"]) ? limpiar($_SESSION["acceso"]) : '';
	$codSucursal     = ($tipoAcceso === 'administradorG') ? limpiar(decrypt($_GET["codsucursal"])) : limpiar($_SESSION["codsucursal"]);	
    $codigoUsuario   = isset($_SESSION["codigo"]) ? limpiar($_SESSION["codigo"]) : '';
    $whereConditions = [];
    $params          = [];

    // Lógica de filtro basada en el tipo de acceso
    if ($tipoAcceso === 'cajero' || $tipoAcceso === 'vendedor') { // Acceso Cajero
        $whereConditions[] = "pre.codigo = ?";
        $params[]          = $codigoUsuario;
        $whereConditions[] = "pre.codsucursal = ?";
        $params[]          = $codSucursal;
    } else { // // Acceso Diferente a Cajero
        $whereConditions[] = "pre.codsucursal = ?";
        $params[]          = $codSucursal;
    }
   
    $whereClause = "";
    if (!empty($whereConditions)) {
      $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $sqlBase = "SELECT
        pre.idpreventa, pre.codpreventa, pre.codfactura, pre.codcliente, pre.subtotalivasi, pre.subtotalivano, 
        pre.iva, pre.totaliva, pre.descontado, pre.descuento, pre.totaldescuento, pre.totalpago, pre.totalpago2,
		pre.observaciones, pre.fechapreventa, pre.procesada, pre.codigo, pre.codsucursal,
		suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
		suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
		tm.moneda, tm.siglas, tm.simbolo,
		usu.dni, usu.nombres,
		cl.tipocliente, cl.documcliente, cl.dnicliente,
		CONCAT(if(cl.tipocliente='NATURAL',cl.nomcliente,cl.razoncliente)) as nomcliente,
		cl.girocliente, cl.tlfcliente, cl.id_ciudad AS id_ciudad2, cl.id_comuna AS id_comuna2, 
		cl.direccliente, cl.emailcliente, cl.limitecredito,
		doc.documento, doc2.documento AS documento2, doc3.documento AS documento3,
		ciud.ciudad, com.comuna, ciud2.ciudad AS ciudad2, com2.comuna AS comuna2,
		pag.articulos, pag.detalles_productos
    FROM 
        preventas pre LEFT JOIN sucursales suc ON pre.codsucursal = suc.codsucursal
	LEFT JOIN 
	    documentos doc ON suc.documsucursal = doc.coddocumento
	LEFT JOIN 
	    documentos AS doc2 ON suc.documencargado = doc2.coddocumento
    LEFT JOIN 
        ciudades ciud ON suc.id_ciudad = ciud.id_ciudad 
    LEFT JOIN 
        comunas com ON suc.id_comuna = com.id_comuna 
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
	INNER JOIN 
	    clientes cl ON pre.codcliente = cl.codcliente
	LEFT JOIN 
	    documentos AS doc3 ON cl.documcliente = doc3.coddocumento 
	LEFT JOIN 
        ciudades ciud2 ON cl.id_ciudad = ciud2.id_ciudad 
    LEFT JOIN 
        comunas com2 ON cl.id_comuna = com.id_comuna
	LEFT JOIN 
	    usuarios usu ON pre.codigo = usu.codigo
    LEFT JOIN
        (SELECT
            dpre.codpreventa,
            SUM(dpre.cantpreventa) AS articulos,
            GROUP_CONCAT(
            CONCAT_WS(
               ' | ',
               dpre.cantpreventa,
               dpre.producto,
               dpre.descripcion,
               IFNULL(mar.nommarca, ''),
               IFNULL(mode.nommodelo, ''),
               IFNULL(pres.nompresentacion, ''),
               IFNULL(col.nomcolor, '')
            )
                ORDER BY dpre.producto
                SEPARATOR '<br>'
            ) AS detalles_productos
            FROM
                detallepreventas dpre
            LEFT JOIN 
                marcas mar ON dpre.codmarca = mar.codmarca
		    LEFT JOIN 
		        modelos mode ON dpre.codmodelo = mode.codmodelo 
		    LEFT JOIN 
		        presentaciones pres ON dpre.codpresentacion = pres.codpresentacion
			LEFT JOIN 
			    colores col ON dpre.codcolor = col.codcolor
			WHERE dpre.codsucursal = $codSucursal
	    GROUP BY
	        dpre.codpreventa
	    ) pag ON pag.codpreventa = pre.codpreventa";
    $sql = $sqlBase . $whereClause . " ORDER BY pre.fechapreventa DESC";
    try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($results)) {
            return [];
        } else {
            return $results;
        }
    } catch (PDOException $e) {
        error_log("Error en ListarClientesxPreventas: " . $e->getMessage());
        return [];
    }
}
######################### FUNCION LISTAR CLIENTES CON PREVENTAS ############################

############################ FUNCION ID PREVENTAS #################################
public function PreventasPorId()
{
    $this->p     = [];
    $codPreventa = isset($_GET["codpreventa"]) ? limpiar(decrypt($_GET["codpreventa"])) : '';
    $codSucursal = isset($_GET["codsucursal"]) ? limpiar(decrypt($_GET["codsucursal"])) : '';
    $sql = "SELECT
        pre.*,
        suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.codgiro, suc.girosucursal,
        suc.tlfsucursal, suc.correosucursal, suc.id_ciudad, suc.id_comuna, suc.direcsucursal,
        suc.nroactividadsucursal, suc.fechaautorsucursal, suc.llevacontabilidad,
        suc.documencargado, suc.dniencargado, suc.nomencargado, suc.tlfencargado,
        suc.codmoneda, suc.codmoneda2, suc.membrete,
        tm.moneda, tm.siglas, tm.simbolo,
        tm2.moneda AS moneda2, tm2.siglas AS siglas2, tm2.simbolo AS simbolo2,
        valor_cambio.montocambio,
        cl.tipocliente, cl.documcliente, cl.dnicliente,
		CONCAT(if(cl.tipocliente='NATURAL',cl.nomcliente,cl.razoncliente)) as nomcliente,
		cl.girocliente, cl.tlfcliente, cl.id_ciudad AS id_ciudad2, cl.id_comuna AS id_comuna2, 
		cl.direccliente, cl.emailcliente, cl.limitecredito,
        doc.documento, doc2.documento AS documento2, doc3.documento AS documento3,
        usu.dni, usu.nombres,
        ciud.ciudad, com.comuna, ciud2.ciudad AS ciudad2, com2.comuna AS comuna2,
        pag.articulos
    FROM 
        preventas pre LEFT JOIN sucursales suc ON pre.codsucursal = suc.codsucursal
    LEFT JOIN 
        documentos doc ON suc.documsucursal = doc.coddocumento
    LEFT JOIN 
        documentos doc2 ON suc.documencargado = doc2.coddocumento
    LEFT JOIN 
        ciudades ciud ON suc.id_ciudad = ciud.id_ciudad 
    LEFT JOIN 
        comunas com ON suc.id_comuna = com.id_comuna 
    LEFT JOIN 
        tiposmoneda tm ON suc.codmoneda = tm.codmoneda
    LEFT JOIN 
        tiposmoneda tm2 ON suc.codmoneda2 = tm2.codmoneda
    LEFT JOIN 
        clientes cl ON pre.codcliente = cl.codcliente
    LEFT JOIN 
        documentos AS doc3 ON cl.documcliente = doc3.coddocumento
    LEFT JOIN 
        ciudades ciud2 ON cl.id_ciudad = ciud2.id_ciudad 
    LEFT JOIN 
        comunas com2 ON cl.id_comuna = com.id_comuna 
    LEFT JOIN 
        usuarios usu ON pre.codigo = usu.codigo
    LEFT JOIN
        (SELECT
            dpre.codpreventa,
            SUM(dpre.cantpreventa) AS articulos
            FROM
                detallepreventas dpre
            WHERE dpre.codsucursal = :codSucursal1
        GROUP BY
            dpre.codpreventa
        ) pag ON pag.codpreventa = pre.codpreventa

    LEFT JOIN
       (SELECT
       codcambio, descripcioncambio, montocambio, codmoneda       
       FROM tiposcambio
       ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = suc.codmoneda2
    WHERE pre.codpreventa = :codPreventa AND pre.codsucursal = :codSucursal2 LIMIT 1";
    try {
        $stmt = $this->dbh->prepare($sql);
        // Asignamos los parámetros a los marcadores de posición con nombre
        $stmt->bindParam(':codPreventa', $codPreventa);
        $stmt->bindParam(':codSucursal1', $codSucursal);
        $stmt->bindParam(':codSucursal2', $codSucursal);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        if (!$row) {
            echo "<div class='alert alert-danger'>";
            echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
            echo "<center><span class='fa fa-info-circle'></span> PREVENTA NO ENCONTRADA.</center>";
            echo "</div>";
            exit();
        } else {
            $this->p[] = $row;
            return $this->p;
        }
    } catch (PDOException $e) {
        error_log("Error en PreventasPorId: " . $e->getMessage());
        echo "<div class='alert alert-danger'>";
        echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
        echo "<center><span class='fa fa-exclamation-triangle'></span> OCURRIÓ UN ERROR AL CONSULTAR LA VENTA.</center>";
        echo "</div>";
        return [];
    }
}
############################ FUNCION ID PREVENTAS #################################
	
######################## FUNCION VER DETALLES PREVENTAS ############################
public function VerDetallesPreventas()
{
	$this->p     = [];
	$codPreventa = isset($_GET["codpreventa"]) ? limpiar(decrypt($_GET["codpreventa"])) : '';
    $codSucursal = isset($_GET["codsucursal"]) ? limpiar(decrypt($_GET["codsucursal"])) : '';
    $sql = "SELECT
	dpre.*,
	ma.nommarca,
	mo.nommodelo,
	pr.nompresentacion,
	co.nomcolor
	FROM
	    detallepreventas dpre
	LEFT JOIN 
	    marcas ma ON dpre.codmarca = ma.codmarca
	LEFT JOIN 
	    modelos mo ON dpre.codmodelo = mo.codmodelo 
	LEFT JOIN 
	    presentaciones pr ON dpre.codpresentacion = pr.codpresentacion
	LEFT JOIN 
	    colores co ON dpre.codcolor = co.codcolor 
	WHERE dpre.codpreventa = ? AND dpre.codsucursal = ?";
	try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute([$codPreventa,$codSucursal]);
        $this->p = $stmt->fetchAll(PDO::FETCH_ASSOC);
        return $this->p;
    } catch (PDOException $e) {
        // Manejo de errores: registra el error y devuelve un array vacío
        error_log("Error en VerDetallesPreventas: " . $e->getMessage() . " SQL: " . $sql . " Params: " . json_encode([$codPreventa,$codSucursal]));
        return [];
    }
}
##################### FUNCION VER DETALLES PREVENTAS #########################

######################## FUNCION ACTUALIZAR PREVENTAS #######################
public function ActualizarPreventas()
{
	$this->p = [];
	if(empty($_POST["codpreventa"]) or empty($_POST["codsucursal"]))
	{
		echo "1";
		exit;
	}

	################### SELECCIONE LOS DATOS DEL CLIENTE ######################
    $sql = "SELECT
    codcliente
    FROM clientes
    WHERE dnicliente = ?
    AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(limpiar($_POST['nrodocumento']),decrypt($_POST["codsucursal"])));
	$num = $stmt->rowCount();
	if($row = $stmt->fetch(PDO::FETCH_ASSOC))
	{
		$p[] = $row;
	}
	$codcliente = (empty($row['codcliente']) ? "0" : $row['codcliente']);
    ################### SELECCIONE LOS DATOS DEL CLIENTE ######################

    for($i=0;$i<count($_POST['coddetallepreventa']);$i++){  //recorro el array
        if (!empty($_POST['coddetallepreventa'][$i])) {

	        if($_POST['cantpreventa'][$i]==0){

		        echo "2";
		        exit();
	        }
        }
    }

	$this->dbh->beginTransaction();
	for($i=0;$i<count($_POST['coddetallepreventa']);$i++){  //recorro el array
	if (!empty($_POST['coddetallepreventa'][$i])) {

	$sql = "SELECT 
	cantpreventa 
	FROM detallepreventas 
	WHERE coddetallepreventa = '".limpiar($_POST['coddetallepreventa'][$i])."' 
	AND codpreventa = '".limpiar(decrypt($_POST["codpreventa"]))."' 
	AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
		
		$cantidadbd = $row['cantpreventa'];

		if($cantidadbd != $_POST['cantpreventa'][$i]){

		if($_POST['tipodetalle'][$i] == 1){//SI EL DETALLE ES UN PRODUCTO

			############ CONSULTO LA EXISTENCIA DE PRODUCTO EN ALMACEN ############
		    $sql = "SELECT existencia 
		    FROM productos 
		    WHERE idproducto = '".limpiar($_POST['idproducto'][$i])."' 
		    AND codproducto = '".limpiar($_POST['codproducto'][$i])."' 
		    AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
			foreach ($this->dbh->query($sql) as $row)
			{
				$this->p[] = $row;
			}
			$existenciabd  = $row['existencia'];
			$cantidad      = $_POST["cantpreventa"][$i];
			$cantidadbd    = $_POST["cantpreventabd"][$i];
		    $totalpreventa = $cantidad-$cantidadbd;
			############ CONSULTO LA EXISTENCIA DE PRODUCTO EN ALMACEN ############

		    ############## ACTUALIZAMOS EXISTENCIA DEL PRODUCTO EN ALMACEN ##############
			$sql2 = " UPDATE productos set "
			." existencia = ? "
			." WHERE "
			." idproducto = '".limpiar($_POST['idproducto'][$i])."' 
		    AND codproducto = '".limpiar($_POST["codproducto"][$i])."' 
			AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."';
			";
			$stmt = $this->dbh->prepare($sql2);
			$stmt->bindParam(1, $existencia);
			$existencia = $_POST["opcionvendido"][$i] == "2" ? number_format($existenciabd-$totalpreventa, 3, '.', '') : number_format($existenciabd-$totalpreventa, 0, '.', '');
			$stmt->execute();
		    ############## ACTUALIZAMOS EXISTENCIA DEL PRODUCTO EN ALMACEN ##############

		    ############### ACTUALIZAMOS LOS DATOS DEL PRODUCTO EN KARDEX ###############
			$sql3 = " UPDATE kardex set "
			." salidas = ?, "
			." stockactual = ? "
			." WHERE "
			." codproceso = '".limpiar($_POST["codpreventa"])."' 
			AND codproducto = '".limpiar($_POST["codproducto"][$i])."' 
			AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'
			AND tipokardex = 1
			AND procedimiento = 1;
			";
			$stmt = $this->dbh->prepare($sql3);
			$stmt->bindParam(1, $salidas);
			$stmt->bindParam(2, $existencia);
			
			$salidas    = $_POST["opcionvendido"][$i] == "2" ? number_format($_POST["cantpreventa"][$i], 3, '.', '') : number_format($_POST["cantpreventa"][$i], 0, '.', '');
			$existencia = $_POST["opcionvendido"][$i] == "2" ? number_format($existenciabd-$totalpreventa, 3, '.', '') : number_format($existenciabd-$totalpreventa, 0, '.', '');
			$stmt->execute();
			############### ACTUALIZAMOS LOS DATOS DEL PRODUCTO EN KARDEX ###############

	    } elseif(limpiar($_POST['tipodetalle'][$i]) == 2){ // SI EL DETALLE ES UN COMBO

	        ############## VERIFICO LA EXISTENCIA DEL COMBO EN ALMACEN #################
	    	$sql = "SELECT 
	    	existencia 
	    	FROM combos 
	    	WHERE idcombo = '".limpiar($_POST['idproducto'][$i])."' 
		    AND codcombo = '".limpiar($_POST["codproducto"][$i])."'
	    	AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
	    	foreach ($this->dbh->query($sql) as $row)
	    	{
	    		$this->p[] = $row;
	    	}
	    	$existenciacombobd = $row['existencia'];
			$cantidad          = $_POST["cantpreventa"][$i];
			$cantidadbd        = $_POST["cantpreventabd"][$i];
		    $totalpreventa     = $cantidad-$cantidadbd;
	        ############## VERIFICO LA EXISTENCIA DEL COMBO EN ALMACEN #################

		    ##################### ACTUALIZO LA EXISTENCIA DEL COMBO DEL ALMACEN ####################
			$sql = " UPDATE combos set "
		    ." existencia = ? "
			." WHERE "
			." idcombo = '".limpiar($_POST['idproducto'][$i])."' 
		    AND codcombo = '".limpiar($_POST["codproducto"][$i])."'
		    AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."';
			";
			$stmt = $this->dbh->prepare($sql);
			$stmt->bindParam(1, $existencia);

			$existencia = $_POST["opcionvendido"][$i] == "2" ? number_format($existenciacombobd-$totalpreventa, 3, '.', '') : number_format($existenciacombobd-$totalpreventa, 0, '.', '');
			$stmt->execute();
			##################### ACTUALIZO LA EXISTENCIA DEL COMBO DEL ALMACEN ####################

			############### ACTUALIZAMOS LOS DATOS DEL COMBO EN KARDEX ###############
			$sql3 = " UPDATE kardex set "
			." salidas = ?, "
			." stockactual = ? "
			." WHERE "
			." codproceso = '".limpiar($_POST["codpreventa"])."' 
			AND codproducto = '".limpiar($_POST["codproducto"][$i])."' 
			AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'
			AND tipokardex = 2
			AND procedimiento = 2;
			";
			$stmt = $this->dbh->prepare($sql3);
			$stmt->bindParam(1, $salidas);
			$stmt->bindParam(2, $existencia);
			
 			$salidas    = $_POST["opcionvendido"][$i] == "2" ? number_format($_POST["cantpreventa"][$i], 3, '.', '') : number_format($_POST["cantpreventa"][$i], 0, '.', '');
			$existencia = $_POST["opcionvendido"][$i] == "2" ? number_format($existenciacombobd-$totalpreventa, 3, '.', '') : number_format($existenciabd-$totalpreventa, 0, '.', '');
			$stmt->execute();
			############### ACTUALIZAMOS LOS DATOS DEL COMBO EN KARDEX ###############	
	    }

		################### ACTUALIZO DETALLES DE PREVENTA ####################
		$query = "UPDATE detallepreventas set"
		." cantpreventa = ?, "
		." valortotal = ?, "
		." totaldescuentov = ?, "
	    ." subtotalimpuestos = ?, "
		." valorneto = ?, "
		." valorneto2 = ? "
		." WHERE "
		." coddetallepreventa = ? AND codpreventa = ? AND codsucursal = ?;
		";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $cantpreventa);
		$stmt->bindParam(2, $valortotal);
		$stmt->bindParam(3, $totaldescuentov);
	    $stmt->bindParam(4, $subtotalimpuestos);
		$stmt->bindParam(5, $valorneto);
		$stmt->bindParam(6, $valorneto2);
		$stmt->bindParam(7, $coddetallepreventa);
		$stmt->bindParam(8, $codpreventa);
		$stmt->bindParam(9, $codsucursal);

		$cantpreventa       = limpiar($_POST['cantpreventa'][$i]);
		$preciocompra       = limpiar($_POST['preciocompra'][$i]);
		$precioventa        = limpiar($_POST['precioventa'][$i]);
		$ivaproducto        = limpiar($_POST['ivaproducto'][$i]);
		$descuento          = $_POST['descproducto'][$i]/100;
		$valortotal         = number_format($_POST['valortotal'][$i], 2, '.', '');
		$totaldescuento     = number_format($_POST['totaldescuentov'][$i], 2, '.', '');
	    $subtotalimpuestos  = number_format($_POST['subtotalimpuestos'][$i], 0, '.', '');
		$valorneto          = number_format($_POST['valorneto'][$i], 2, '.', '');
		$valorneto2         = number_format($_POST['valorneto2'][$i], 2, '.', '');
		$coddetallepreventa = limpiar($_POST['coddetallepreventa'][$i]);
		$codpreventa        = limpiar(decrypt($_POST["codpreventa"]));
		$codsucursal        = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();
		################### ACTUALIZO DETALLES DE PREVENTA ####################


			    } else {

                    echo "";
		        }
	        }
        }
        $this->dbh->commit();

        ################### ACTUALIZO PREVENTA ####################
		$sql = " UPDATE preventas SET "
		." codcliente = ?, "
		." observaciones = ?, "
		." subtotalivasi = ?, "
		." subtotalivano = ?, "
		." totaliva = ?, "
		." descontado = ?, "
		." descuento = ?, "
		." totaldescuento = ?, "
		." totalpago = ?, "
		." totalpago2= ? "
		." WHERE "
		." codpreventa = ? AND codsucursal = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $codcliente);
		$stmt->bindParam(2, $observaciones);
		$stmt->bindParam(3, $subtotalivasi);
		$stmt->bindParam(4, $subtotalivano);
		$stmt->bindParam(5, $totaliva);
		$stmt->bindParam(6, $descontado);
		$stmt->bindParam(7, $descuento);
		$stmt->bindParam(8, $totaldescuento);
		$stmt->bindParam(9, $totalpago);
		$stmt->bindParam(10, $totalpago2);
		$stmt->bindParam(11, $codpreventa);
		$stmt->bindParam(12, $codsucursal);

		$observaciones  = limpiar($_POST["observaciones"]);
		$subtotalivasi  = number_format($_POST["txtsubtotal"], 2, '.', '');
		$subtotalivano  = number_format($_POST["txtsubtotal2"], 2, '.', '');
		$totaliva       = number_format($_POST["txtIva"], 2, '.', '');
		$descontado     = number_format($_POST["txtdescontado"], 2, '.', '');
		$descuento      = limpiar($_POST["descuento"]);
		$totaldescuento = number_format($_POST["txtDescuento"], 2, '.', '');
		$totalpago      = number_format($_POST["txtTotal"], 2, '.', '');
		$totalpago2     = number_format($_POST["txtTotalCompra"], 2, '.', '');
		$codpreventa    = limpiar(decrypt($_POST["codpreventa"]));
		$codsucursal    = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();
		################### ACTUALIZO PREVENTA ####################

	echo "<span class='fa fa-check-square-o'></span> LA PREVENTA DE PRODUCTOS HA SIDO ACTUALIZADA EXITOSAMENTE <a href='reportepdf?codpreventa=".encrypt($codpreventa)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt("TICKETPREVENTA")."' class='on-default' data-placement='left' data-toggle='tooltip' data-original-title='Imprimir Documento' target='_black' rel='noopener noreferrer'><font color='black'><strong>IMPRIMIR REPORTE</strong></font color></a></div>";

	echo "<script>VentanaCentrada('reportepdf?codpreventa=".encrypt($codpreventa)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt("TICKETPREVENTA")."', '', '', '1024', '568', 'true');</script>";
	exit;
}
####################### FUNCION ACTUALIZAR PREVENTAS ############################

####################### FUNCION AGREGAR DETALLES PREVENTAS ########################
public function AgregarDetallesPreventas()
{
	$this->p = [];
	if(empty($_POST["codpreventa"]) or empty($_POST["codsucursal"]))
	{
		echo "1";
		exit;
	}
    elseif(empty($_SESSION["CarritoPreventa"]) || $_POST["txtTotal"]=="0.00")
	{
		echo "2";
		exit;
	}

	############ VALIDO SI LA CANTIDAD ES MAYOR QUE LA EXISTENCIA #############
	$v = $_SESSION["CarritoPreventa"];
    for ($i = 0, $iMax = count($v); $i < $iMax; $i++) {

		if(limpiar($v[$i]['tipodetalle'])==1){

			$sql = "SELECT 
			existencia 
			FROM productos 
			WHERE idproducto = '".limpiar($v[$i]['id'])."' 
			AND codproducto = '".limpiar($v[$i]['txtCodigo'])."' 
			AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
			foreach ($this->dbh->query($sql) as $row)
			{
				$this->p[] = $row;
			}
			
			$existenciabd = $row['existencia'];
			$cantidad     = $v[$i]['cantidad'];

			if ($cantidad > $existenciabd) 
			{ 
				echo "3";
				exit;
			}

		} elseif(limpiar($v[$i]['tipodetalle']) == 2){ // SI EL DETALLE ES UN COMBO

			$sql = "SELECT 
		    existencia 
		    FROM combos 
		    WHERE idcombo = '".limpiar($v[$i]['id'])."' 
			AND codcombo = '".limpiar($v[$i]['txtCodigo'])."'
		    AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		    foreach ($this->dbh->query($sql) as $row)
		    {
			   $this->p[] = $row;
		    }
		
		    $existenciabd = $row['existencia'];
		    $cantidad     = $v[$i]['cantidad'];

	        if ($cantidad > $existenciabd) 
	        { 
		        echo "4";
		        exit;
	        }

		    ############## VERIFICO SI EL COMBO TIENE PRODUCTO RELACIONADOS #################
		    $sql = "SELECT * FROM combosxproductos WHERE codcombo = ? AND codsucursal = ?";
			$stmt = $this->dbh->prepare($sql);
			$stmt->execute(array($v[$i]['txtCodigo'],limpiar(decrypt($_POST["codsucursal"]))));
			$num = $stmt->rowCount();
	        if($num>0) {  

	        	$sql = "SELECT 
	        	combosxproductos.codcombo,
	    	    combosxproductos.idproducto,
	        	combosxproductos.codproducto,
	        	combosxproductos.cantidad,
	        	combosxproductos.codsucursal,
	        	productos.existencia
	        	FROM combosxproductos 
	        	LEFT JOIN productos ON combosxproductos.codproducto = productos.codproducto 
	        	WHERE combosxproductos.codcombo IN ('".limpiar($v[$i]['txtCodigo'])."') 
	        	AND combosxproductos.codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."' 
	    	    AND productos.codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
	        	foreach ($this->dbh->query($sql) as $row)
			    { 
				    $this->p[] = $row;

				    $cantracionbd2  = $row['cantidad'];
				    $idproductobd2  = $row['idproducto'];
				    $codproductobd2 = $row['codproducto'];
				    $existenciabd2  = $row['existencia'];
			        $racion         = number_format($cantracionbd2*$v[$i]['cantidad'], 2, '.', '');

			        if ($racion > $existenciabd2) 
			        { 
			        	echo "5";
			        	exit;
			        }
			    }
		    }//fin de consulta de productos de combos	
		    ############## VERIFICO SI EL COMBO TIENE PRODUCTO RELACIONADOS #################
	    }
	}
	############ VALIDO SI LA CANTIDAD ES MAYOR QUE LA EXISTENCIA #############

	################### SELECCIONE LOS DATOS DEL CLIENTE ######################
    $sql = "SELECT
    codcliente
    FROM clientes
    WHERE dnicliente = ?
    AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(limpiar($_POST['nrodocumento']),decrypt($_POST["codsucursal"])));
	$num = $stmt->rowCount();
	if($row = $stmt->fetch(PDO::FETCH_ASSOC))
	{
		$p[] = $row;
	}
	$codcliente = (empty($row['codcliente']) ? "0" : $row['codcliente']);
    ################### SELECCIONE LOS DATOS DEL CLIENTE ######################

    ############ CONSULTO TOTAL ACTUAL DE PREVENTA ##############
	$sql = "SELECT
	codfactura,
	descuento,
	totalpago 
	FROM preventas 
	WHERE codpreventa = '".limpiar(decrypt($_POST["codpreventa"]))."' 
	AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$codfacturabd = $row['codfactura'];
	$descuentobd  = $row['descuento'];
	$totalpagobd  = $row['totalpago'];
	############ CONSULTO TOTAL ACTUAL DE PREVENTA ##############
   
    $this->dbh->beginTransaction();
    $detalle = $_SESSION["CarritoPreventa"];
	for($i=0;$i<count($detalle);$i++){

	$sql = "SELECT 
	codpreventa, 
	codproducto 
	FROM detallepreventas 
	WHERE codpreventa = '".limpiar(decrypt($_POST['codpreventa']))."' 
	AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'
	AND idproducto = '".limpiar($detalle[$i]['id'])."' 
	AND codproducto = '".limpiar($detalle[$i]['txtCodigo'])."'";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num == 0)
	{
        ################### REGISTRO DETALLES DE PREVENTA ####################
        $query = "INSERT INTO detallepreventas values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codpreventa);
	    $stmt->bindParam(2, $idproducto);
	    $stmt->bindParam(3, $codproducto);
	    $stmt->bindParam(4, $producto);
	    $stmt->bindParam(5, $descripcion);
        $stmt->bindParam(6, $opcionvendido);
	    $stmt->bindParam(7, $imei);
	    $stmt->bindParam(8, $condicion);
	    $stmt->bindParam(9, $codmarca);
	    $stmt->bindParam(10, $codmodelo);
	    $stmt->bindParam(11, $codpresentacion);
	    $stmt->bindParam(12, $codcolor);
		$stmt->bindParam(13, $cantidad);
		$stmt->bindParam(14, $preciocompra);
		$stmt->bindParam(15, $precioventa);
		$stmt->bindParam(16, $ivaproducto);
		$stmt->bindParam(17, $descproducto);
		$stmt->bindParam(18, $valortotal);
		$stmt->bindParam(19, $totaldescuentov);
		$stmt->bindParam(20, $subtotalimpuestos);
		$stmt->bindParam(21, $valorneto);
		$stmt->bindParam(22, $valorneto2);
		$stmt->bindParam(23, $tipodetalle);
		$stmt->bindParam(24, $codsucursal);
			
		$codpreventa     = limpiar(decrypt($_POST["codpreventa"]));
		$idproducto      = limpiar($detalle[$i]['tipodetalle'] == "3" ? "0" : $detalle[$i]['id']);
		$codproducto     = limpiar($detalle[$i]['tipodetalle'] == "3" ? "0" : $detalle[$i]['txtCodigo']);
		$producto        = limpiar($detalle[$i]['producto']);
		$descripcion     = limpiar($detalle[$i]['tipodetalle'] == "3" || $detalle[$i]['descripcion'] == "0" ? "" : $detalle[$i]['descripcion']);
		$opcionvendido   = limpiar($detalle[$i]['opcionvendido']);
		$imei            = limpiar($detalle[$i]['tipodetalle'] == "3" || $detalle[$i]['imei'] == "0" ? "" : $detalle[$i]['imei']);
		$condicion       = limpiar($detalle[$i]['tipodetalle'] == "3" || $detalle[$i]['condicion'] == "0" ? "" : $detalle[$i]['condicion']);
		$codmarca        = limpiar($detalle[$i]['tipodetalle'] == "3" ? "0" : $detalle[$i]['codmarca']);
		$codmodelo       = limpiar($detalle[$i]['tipodetalle'] == "3" ? "0" : $detalle[$i]['codmodelo']);
		$codpresentacion = limpiar($detalle[$i]['tipodetalle'] == "3" ? "0" : $detalle[$i]['codpresentacion']);
		$codcolor        = limpiar($detalle[$i]['tipodetalle'] == "3" ? "0" : $detalle[$i]['codcolor']);
		$cantidad        = $detalle[$i]['opcionvendido'] == "2" ? number_format($detalle[$i]['cantidad'], 3, '.', '') : number_format($detalle[$i]['cantidad'], 0, '.', '');
		$preciocompra    = limpiar($detalle[$i]['precio']);
		$precioventa     = limpiar($detalle[$i]['precio2']);
		$precioconiva    = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['precio2']);
		$ivaproducto     = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
		$descproducto    = limpiar($detalle[$i]['descproducto']);
		$descuento       = $detalle[$i]['descproducto']/100;
		$valortotal      = number_format($detalle[$i]['precio2']*$detalle[$i]['cantidad'], 2, '.', '');
		$totaldescuentov = number_format($valortotal*$descuento, 2, '.', '');

		//CALCULO SUBTOTAL IMPUESTOS
		$ValorImpuesto        = 1 + ($_POST["iva"]/100);
		$RestoDescuento       = $precioconiva * $detalle[$i]['descproducto'] / 100;
		$PrecioIvaDescuento   = $precioconiva - $RestoDescuento;
		$Discriminado         = $PrecioIvaDescuento/$ValorImpuesto;
		$SubtotalDiscriminado = $PrecioIvaDescuento - $Discriminado;
	    $BaseDiscriminado     = $SubtotalDiscriminado * $detalle[$i]['cantidad'];
	    $subtotalimpuestos    = number_format($BaseDiscriminado, 2, '.', '');

	    $valorneto      = number_format($valortotal-$totaldescuentov, 2, '.', '');
		$valorneto2     = limpiar($detalle[$i]['tipodetalle'] == "3" ? "0.00" : number_format($detalle[$i]['precio']*$detalle[$i]['cantidad'], 2, '.', ''));
	    $tipodetalle    = limpiar($detalle[$i]['tipodetalle']);
		$codsucursal    = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();
		################### REGISTRO DETALLES DE PREVENTA ####################

	if(limpiar($detalle[$i]['tipodetalle'])==1){ // SI EL DETALLE ES UN PRODUCTO

		################ VERIFICO LA EXISTENCIA DEL PRODUCTO EN ALMACEN ################
		$sql = "SELECT * FROM productos 
		WHERE idproducto = '".limpiar($detalle[$i]['id'])."' 
	    AND codproducto = '".limpiar($detalle[$i]['txtCodigo'])."'
		AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		$existenciabd = $row['existencia'];
	    ################ VERIFICO LA EXISTENCIA DEL PRODUCTO EN ALMACEN ################

		##################### ACTUALIZO LA EXISTENCIA DEL ALMACEN ####################
		$sql = " UPDATE productos set "
		." existencia = ? "
		." WHERE "
		." idproducto = '".limpiar($detalle[$i]['id'])."' 
	    AND codproducto = '".limpiar($detalle[$i]['txtCodigo'])."' 
		AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."';
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $existencia);
		$cantpreventa  = $detalle[$i]['opcionvendido'] == "2" ? number_format($detalle[$i]['cantidad'], 3, '.', '') : number_format($detalle[$i]['cantidad'], 0, '.', '');
		$existencia = $detalle[$i]['opcionvendido'] == "2" ? number_format($existenciabd-$detalle[$i]['cantidad'], 3, '.', '') : number_format($existenciabd-$detalle[$i]['cantidad'], 0, '.', '');
		$stmt->execute();
	    ##################### ACTUALIZO LA EXISTENCIA DEL ALMACEN ####################

	    ############### REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX ###############
	    $query = "INSERT INTO kardex values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codpreventa);
		$stmt->bindParam(2, $codcliente);
		$stmt->bindParam(3, $codproducto);
		$stmt->bindParam(4, $movimiento);
		$stmt->bindParam(5, $entradas);
		$stmt->bindParam(6, $salidas);
		$stmt->bindParam(7, $devolucion);
		$stmt->bindParam(8, $stockactual);
		$stmt->bindParam(9, $ivaproducto);
		$stmt->bindParam(10, $descproducto);
		$stmt->bindParam(11, $precio);
		$stmt->bindParam(12, $documento);
		$stmt->bindParam(13, $fechakardex);	
	    $stmt->bindParam(14, $tipokardex);
	    $stmt->bindParam(15, $procedimiento);		
		$stmt->bindParam(16, $codsucursal);
		$stmt->bindParam(17, $codigo);

		$codproducto   = limpiar($detalle[$i]['txtCodigo']);
		$movimiento    = limpiar("SALIDAS");
		$entradas      = $detalle[$i]['opcionvendido'] == "2" ? "0.000" : "0";
		$salidas       = $detalle[$i]['opcionvendido'] == "2" ? number_format($detalle[$i]['cantidad'], 3, '.', '') : number_format($detalle[$i]['cantidad'], 0, '.', '');
		$devolucion    = $detalle[$i]['opcionvendido'] == "2" ? "0.000" : "0";
		$stockactual   = $detalle[$i]['opcionvendido'] == "2" ? number_format($existenciabd-$detalle[$i]['cantidad'], 3, '.', '') : number_format($existenciabd-$detalle[$i]['cantidad'], 0, '.', '');
		$ivaproducto   = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
		$descproducto  = number_format($detalle[$i]['descproducto'], 2, '.', '');
		$precio        = number_format($detalle[$i]["precio2"], 2, '.', '');
		$documento     = limpiar("PREVENTA: ".$codfacturabd);
		$fechakardex   = limpiar(date("Y-m-d"));
	    $tipokardex    = limpiar($detalle[$i]['tipodetalle']);
	    $procedimiento = limpiar("1");	
		$codsucursal   = limpiar(decrypt($_POST["codsucursal"]));
    	$codigo        = limpiar($_SESSION["codigo"]);
		$stmt->execute();
		############### REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX ###############

	} elseif(limpiar($detalle[$i]['tipodetalle']) == 2){ // SI EL DETALLE ES UN COMBO

	    ############## VERIFICO LA EXISTENCIA DEL COMBO EN ALMACEN #################
		$sql = "SELECT 
		existencia 
		FROM combos 
		WHERE idcombo = '".limpiar($detalle[$i]['id'])."' 
	    AND codcombo = '".limpiar($detalle[$i]['txtCodigo'])."'
		AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		$existenciacombobd = $row['existencia'];
		############## VERIFICO LA EXISTENCIA DEL COMBO EN ALMACEN #################

	    ##################### ACTUALIZO LA EXISTENCIA DEL COMBO DEL ALMACEN ####################
		$sql = " UPDATE combos set "
		." existencia = ? "
		." WHERE "
		." idcombo = '".limpiar($detalle[$i]['id'])."' 
	    AND codcombo = '".limpiar($detalle[$i]['txtCodigo'])."'
	    AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."';
	    ";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $existencia);
		$cantpreventa  = $detalle[$i]['opcionvendido'] == "2" ? number_format($detalle[$i]['cantidad'], 3, '.', '') : number_format($detalle[$i]['cantidad'], 0, '.', '');
		$existencia = $detalle[$i]['opcionvendido'] == "2" ? number_format($existenciacombobd-$detalle[$i]['cantidad'], 3, '.', '') : number_format($existenciacombobd-$detalle[$i]['cantidad'], 0, '.', '');
		$stmt->execute();
		##################### ACTUALIZO LA EXISTENCIA DEL COMBO DEL ALMACEN ####################

		############### REGISTRAMOS LOS DATOS DE COMBO EN KARDEX ###############
	    $query = "INSERT INTO kardex values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codpreventa);
		$stmt->bindParam(2, $codcliente);
		$stmt->bindParam(3, $codproducto);
		$stmt->bindParam(4, $movimiento);
		$stmt->bindParam(5, $entradas);
		$stmt->bindParam(6, $salidas);
		$stmt->bindParam(7, $devolucion);
		$stmt->bindParam(8, $stockactual);
		$stmt->bindParam(9, $ivaproducto);
		$stmt->bindParam(10, $descproducto);
		$stmt->bindParam(11, $precio);
		$stmt->bindParam(12, $documento);
		$stmt->bindParam(13, $fechakardex);	
	    $stmt->bindParam(14, $tipokardex);	
	    $stmt->bindParam(15, $procedimiento);		
		$stmt->bindParam(16, $codsucursal);
		$stmt->bindParam(17, $codigo);

		$codproducto   = limpiar($detalle[$i]['txtCodigo']);
		$movimiento    = limpiar("SALIDAS");
		$entradas      = $detalle[$i]['opcionvendido'] == "2" ? "0.000" : "0";
		$salidas       = $detalle[$i]['opcionvendido'] == "2" ? number_format($detalle[$i]['cantidad'], 3, '.', '') : number_format($detalle[$i]['cantidad'], 0, '.', '');
		$devolucion    = $detalle[$i]['opcionvendido'] == "2" ? "0.000" : "0";
		$stockactual   = $detalle[$i]['opcionvendido'] == "2" ? number_format($existenciacombobd-$detalle[$i]['cantidad'], 3, '.', '') : number_format($existenciacombobd-$detalle[$i]['cantidad'], 0, '.', '');
		$ivaproducto   = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
		$descproducto  = number_format($detalle[$i]['descproducto'], 2, '.', '');
		$precio        = number_format($detalle[$i]["precio2"], 2, '.', '');
		$documento     = limpiar("PREVENTA: ".$codfacturabd);
		$fechakardex   = limpiar(date("Y-m-d"));
	    $tipokardex    = limpiar($detalle[$i]['tipodetalle']);
	    $procedimiento = limpiar("2");
		$codsucursal   = limpiar(decrypt($_POST["codsucursal"]));
    	$codigo        = limpiar($_SESSION["codigo"]);
		$stmt->execute();
		############### REGISTRAMOS LOS DATOS DE COMBO EN KARDEX ###############

		############## VERIFICO SI EL COMBO TIENE PRODUCTO RELACIONADOS #################
	    $sql = "SELECT * FROM combosxproductos WHERE codcombo = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array($detalle[$i]['txtCodigo'],limpiar(decrypt($_POST["codsucursal"]))));
		$num = $stmt->rowCount();
	    if($num>0) {  

	    	$sql = "SELECT 
	    	combosxproductos.codcombo,
	    	combosxproductos.idproducto,
	    	combosxproductos.codproducto,
	    	combosxproductos.cantidad,
	    	combosxproductos.codsucursal,
	    	productos.opcionvendido,
	    	productos.existencia,
	    	productos.precioxpublico AS precioventa,
	    	productos.ivaproducto,
	    	productos.descproducto
	    	FROM combosxproductos 
	    	LEFT JOIN productos ON combosxproductos.codproducto = productos.codproducto 
	    	WHERE combosxproductos.codcombo IN ('".limpiar($detalle[$i]['txtCodigo'])."') 
	    	AND combosxproductos.codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."' 
	    	AND productos.codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
	    	foreach ($this->dbh->query($sql) as $row)
		    { 
			    $this->p[] = $row;

			    $cantracionbd2   = $row['cantidad'];
			    $idproductobd2   = $row['idproducto'];
			    $codproductobd2  = $row['codproducto'];
			    $existenciabd2   = $row['existencia'];
			    $precioventabd2  = $row['precioventa'];
			    $ivaproductobd2  = $row['ivaproducto'];
			    $descproductobd2 = $row['descproducto'];
			    $opcionvendido2  = $row['opcionvendido'];

			    ############## ACTUALIZO LOS DATOS DEL PRODUCTO #################
			    $update = "UPDATE productos SET"
			    ." existencia = ? "
			    ." WHERE "
			    ." idproducto = ? AND codproducto = ? AND codsucursal = ?;
			    ";
			    $stmt = $this->dbh->prepare($update);
			    $stmt->bindParam(1, $cantidadracion);
			    $stmt->bindParam(2, $idproducto);
			    $stmt->bindParam(3, $codproducto);
	            $stmt->bindParam(4, $codsucursal);

		        $racion         = $cantracionbd2*$detalle[$i]['cantidad'];
			    $cantidadracion = $opcionvendido2 == "2" ? number_format($existenciabd2-$racion, 3, '.', '') : number_format($existenciabd2-$racion, 0, '.', '');
		        $idproducto     = limpiar($idproductobd2);
		        $codproducto    = limpiar($codproductobd2);
	            $codsucursal    = limpiar(decrypt($_POST["codsucursal"]));
			    $stmt->execute();
			    ############## ACTUALIZO LOS DATOS DEL PRODUCTO #################

			    ############## REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX ###################
			    $query = "INSERT INTO kardex values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
			    $stmt = $this->dbh->prepare($query);
			    $stmt->bindParam(1, $codpreventa);
			    $stmt->bindParam(2, $codcliente);
			    $stmt->bindParam(3, $codproducto);
			    $stmt->bindParam(4, $movimiento);
			    $stmt->bindParam(5, $entradas);
			    $stmt->bindParam(6, $salidas);
			    $stmt->bindParam(7, $devolucion);
			    $stmt->bindParam(8, $stockactual);
			    $stmt->bindParam(9, $ivaproducto);
			    $stmt->bindParam(10, $descproducto);
			    $stmt->bindParam(11, $precio);
			    $stmt->bindParam(12, $documento);
			    $stmt->bindParam(13, $fechakardex);
	            $stmt->bindParam(14, $tipokardex);
	            $stmt->bindParam(15, $procedimiento);
	            $stmt->bindParam(16, $codsucursal);	
		        $stmt->bindParam(17, $codigo);	

			    $codproducto   = limpiar($codproductobd2);
			    $movimiento    = limpiar("SALIDAS");
			    $entradas      = $opcionvendido2 == "2" ? "0.000" : "0";
			    $salidas       = $opcionvendido2 == "2" ? number_format($racion, 3, '.', '') : number_format($racion, 0, '.', '');
			    $devolucion    = $opcionvendido2 == "2" ? "0.000" : "0";
			    $stockactual   = $opcionvendido2 == "2" ? number_format($existenciabd2-$racion, 3, '.', '') : number_format($existenciabd2-$racion, 0, '.', '');
			    $ivaproducto   = limpiar($ivaproductobd2 == "NO" ? "0.00" : $_POST["iva"]);
			    $descproducto  = number_format($descproductobd2, 2, '.', '');
			    $precio        = number_format($precioventabd2, 2, '.', '');
			    $documento     = limpiar("PREVENTA (DETALLE DE COMBO): ".$codfacturabd);
			    $fechakardex   = limpiar(date("Y-m-d"));
	            $tipokardex    = limpiar("1");
	            $procedimiento = limpiar("2");
	            $codsucursal   = limpiar(decrypt($_POST["codsucursal"]));
    	        $codigo        = limpiar($_SESSION["codigo"]);
			    $stmt->execute();
			    ############## REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX ###################
		    }
	    }//fin de consulta de productos de combos	
	    ############## VERIFICO SI EL COMBO TIENE PRODUCTO RELACIONADOS #################
    	
    } else { // SI EL DETALLE ES UN SERVICIO

	    ############### REGISTRAMOS LOS DATOS DE SERVICIO EN KARDEX ###############
	    $query = "INSERT INTO kardex values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codpreventa);
		$stmt->bindParam(2, $codcliente);
		$stmt->bindParam(3, $codproducto);
		$stmt->bindParam(4, $movimiento);
		$stmt->bindParam(5, $entradas);
		$stmt->bindParam(6, $salidas);
		$stmt->bindParam(7, $devolucion);
		$stmt->bindParam(8, $stockactual);
		$stmt->bindParam(9, $ivaproducto);
		$stmt->bindParam(10, $descproducto);
		$stmt->bindParam(11, $precio);
		$stmt->bindParam(12, $documento);
		$stmt->bindParam(13, $fechakardex);	
	    $stmt->bindParam(14, $tipokardex);
	    $stmt->bindParam(15, $procedimiento);		
		$stmt->bindParam(16, $codsucursal);
		$stmt->bindParam(17, $codigo);

		$codproducto   = limpiar($detalle[$i]['txtCodigo']);
		$movimiento    = limpiar("SALIDAS");
		$entradas      = $detalle[$i]['opcionvendido'] == "2" ? "0.000" : "0";
		$salidas       = $detalle[$i]['opcionvendido'] == "2" ? number_format($detalle[$i]['cantidad'], 3, '.', '') : number_format($detalle[$i]['cantidad'], 0, '.', '');
		$devolucion    = $detalle[$i]['opcionvendido'] == "2" ? "0.000" : "0";
		$stockactual   = $detalle[$i]['opcionvendido'] == "2" ? "0.000" : "0";
		$ivaproducto   = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
		$descproducto  = number_format($detalle[$i]['descproducto'], 2, '.', '');
		$precio        = number_format($detalle[$i]["precio2"], 2, '.', '');
		$documento     = limpiar("PREVENTA: ".$codfacturabd);
		$fechakardex   = limpiar(date("Y-m-d"));
	    $tipokardex    = limpiar($detalle[$i]['tipodetalle']);
	    $procedimiento = limpiar("3");	
		$codsucursal   = limpiar(decrypt($_POST["codsucursal"]));
    	$codigo        = limpiar($_SESSION["codigo"]);
		$stmt->execute();
		############### REGISTRAMOS LOS DATOS DE SERVICIO EN KARDEX ###############
    }
		
	} else {

	  	$sql = "SELECT cantpreventa 
	  	FROM detallepreventas 
	  	WHERE codpreventa = '".limpiar(decrypt($_POST['codpreventa']))."' 
	  	AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."' 
	  	AND idproducto = '".limpiar($detalle[$i]['id'])."' 
	    AND codproducto = '".limpiar($detalle[$i]['txtCodigo'])."'";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		$cantidad = $row['cantpreventa'];

	  	################### ACTUALIZO DETALLES DE COTIZACION ####################
	  	$query = "UPDATE detallepreventas set"
		." cantpreventa = ?, "
		." descproducto = ?, "
		." valortotal = ?, "
		." totaldescuentov = ?, "
		." subtotalimpuestos = ?, "
		." valorneto = ?, "
		." valorneto2 = ? "
		." WHERE "
		." codpreventa = ? AND codsucursal = ? AND idproducto = ? AND codproducto = ?;
		";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $cantpreventa);
		$stmt->bindParam(2, $descproducto);
		$stmt->bindParam(3, $valortotal);
		$stmt->bindParam(4, $totaldescuentov);
		$stmt->bindParam(5, $subtotalimpuestos);
		$stmt->bindParam(6, $valorneto);
		$stmt->bindParam(7, $valorneto2);
		$stmt->bindParam(8, $codpreventa);
		$stmt->bindParam(9, $codsucursal);
		$stmt->bindParam(10, $idproducto);
		$stmt->bindParam(11, $codproducto);

		$cantpreventa        = $detalle[$i]['opcionvendido'] == "2" ? number_format($detalle[$i]['cantidad']+$cantidad, 3, '.', '') : number_format($detalle[$i]['cantidad']+$cantidad, 0, '.', '');
		$preciocompra     = limpiar($detalle[$i]['precio']);
		$precioventa      = limpiar($detalle[$i]['precio2']);
		$precioconiva     = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['precio2']);
	    $ivaproducto      = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
		$descproducto     = limpiar($detalle[$i]['descproducto']);
		$descuento        = $detalle[$i]['descproducto']/100;
		$valortotal       = number_format($detalle[$i]['precio2'] * $cantpreventa, 2, '.', '');
		$totaldescuentov  = number_format($valortotal * $descuento, 2, '.', '');

		//CALCULO SUBTOTAL IMPUESTOS
		$ValorImpuesto        = 1 + ($_POST["iva"]/100);
		$RestoDescuento       = $precioconiva * $detalle[$i]['descproducto'] / 100;
		$PrecioIvaDescuento   = $precioconiva - $RestoDescuento;
		$Discriminado         = $PrecioIvaDescuento/$ValorImpuesto;
		$SubtotalDiscriminado = $PrecioIvaDescuento - $Discriminado;
		$BaseDiscriminado     = $SubtotalDiscriminado * $cantpreventa;
		$subtotalimpuestos    = number_format($BaseDiscriminado, 2, '.', '');

		$valorneto       = number_format($valortotal - $totaldescuentov, 2, '.', '');
		$valorneto2      = limpiar($detalle[$i]['tipodetalle'] == "3" ? "0.00" : number_format($detalle[$i]['precio']*$cantpreventa, 2, '.', ''));
		$codpreventa     = limpiar(decrypt($_POST["codpreventa"]));
		$codsucursal     = limpiar(decrypt($_POST["codsucursal"]));
		$idproducto      = limpiar($detalle[$i]['id']);
		$codproducto     = limpiar($detalle[$i]['txtCodigo']);
		$stmt->execute();
		################### ACTUALIZO DETALLES DE COTIZACION ####################

	if(limpiar($detalle[$i]['tipodetalle'])==1){ // SI EL DETALLE ES UN PRODUCTO

		################ VERIFICO LA EXISTENCIA DEL PRODUCTO EN ALMACEN ################
		$sql = "SELECT * FROM productos 
		WHERE idproducto = '".limpiar($detalle[$i]['id'])."' 
	    AND codproducto = '".limpiar($detalle[$i]['txtCodigo'])."'
		AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		$existenciabd = $row['existencia'];
	    ################ VERIFICO LA EXISTENCIA DEL PRODUCTO EN ALMACEN ################

		##################### ACTUALIZO LA EXISTENCIA DEL ALMACEN ####################
		$sql = " UPDATE productos set "
		." existencia = ? "
		." WHERE "
		." idproducto = '".limpiar($detalle[$i]['id'])."' 
	    AND codproducto = '".limpiar($detalle[$i]['txtCodigo'])."' 
		AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."';
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $existencia);
		$cantpreventa  = $_POST["opcionvendido"][$i] == "2" ? number_format($detalle[$i]['cantidad'], 3, '.', '') : number_format($detalle[$i]['cantidad'], 0, '.', '');
		$existencia = $_POST["opcionvendido"][$i] == "2" ? number_format($existenciabd-$cantpreventa, 3, '.', '') : number_format($existenciabd-$cantpreventa, 0, '.', '');
		$stmt->execute();
	    ##################### ACTUALIZO LA EXISTENCIA DEL ALMACEN ####################

	    ############### REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX ###############
	    $query = "INSERT INTO kardex values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codpreventa);
		$stmt->bindParam(2, $codcliente);
		$stmt->bindParam(3, $codproducto);
		$stmt->bindParam(4, $movimiento);
		$stmt->bindParam(5, $entradas);
		$stmt->bindParam(6, $salidas);
		$stmt->bindParam(7, $devolucion);
		$stmt->bindParam(8, $stockactual);
		$stmt->bindParam(9, $ivaproducto);
		$stmt->bindParam(10, $descproducto);
		$stmt->bindParam(11, $precio);
		$stmt->bindParam(12, $documento);
		$stmt->bindParam(13, $fechakardex);	
	    $stmt->bindParam(14, $tipokardex);	
	    $stmt->bindParam(15, $procedimiento);		
		$stmt->bindParam(16, $codsucursal);
		$stmt->bindParam(17, $codigo);

		$codproducto   = limpiar($detalle[$i]['txtCodigo']);
		$movimiento    = limpiar("SALIDAS");
		$entradas      = $detalle[$i]['opcionvendido'] == "2" ? "0.000" : "0";
		$salidas       = $detalle[$i]['opcionvendido'] == "2" ? number_format($detalle[$i]['cantidad'], 3, '.', '') : number_format($detalle[$i]['cantidad'], 0, '.', '');
		$devolucion    = $detalle[$i]['opcionvendido'] == "2" ? "0.000" : "0";
		$stockactual   = $detalle[$i]['opcionvendido'] == "2" ? number_format($existenciabd-$detalle[$i]['cantidad'], 3, '.', '') : number_format($existenciabd-$detalle[$i]['cantidad'], 0, '.', '');
		$ivaproducto   = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
		$descproducto  = number_format($detalle[$i]['descproducto'], 2, '.', '');
		$precio        = number_format($detalle[$i]["precio2"], 2, '.', '');
		$documento     = limpiar("PREVENTA: ".$codfacturabd);
		$fechakardex   = limpiar(date("Y-m-d"));
	    $tipokardex    = limpiar($detalle[$i]['tipodetalle']);
	    $procedimiento = limpiar("1");
		$codsucursal   = limpiar(decrypt($_POST["codsucursal"]));
    	$codigo        = limpiar($_SESSION["codigo"]);
		$stmt->execute();
		############### REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX ###############

	} elseif(limpiar($detalle[$i]['tipodetalle']) == 2){ // SI EL DETALLE ES UN COMBO

	    ############## VERIFICO LA EXISTENCIA DEL COMBO EN ALMACEN #################
		$sql = "SELECT 
		existencia 
		FROM combos 
		WHERE idcombo = '".limpiar($detalle[$i]['id'])."' 
	    AND codcombo = '".limpiar($detalle[$i]['txtCodigo'])."'
		AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		$existenciacombobd = $row['existencia'];
		############## VERIFICO LA EXISTENCIA DEL COMBO EN ALMACEN #################

	    ##################### ACTUALIZO LA EXISTENCIA DEL COMBO DEL ALMACEN ####################
		$sql = " UPDATE combos set "
		." existencia = ? "
		." WHERE "
		." idcombo = '".limpiar($detalle[$i]['id'])."' 
	    AND codcombo = '".limpiar($detalle[$i]['txtCodigo'])."'
	    AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."';
	    ";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $existencia);		
		$cantpreventa  = $_POST["opcionvendido"][$i] == "2" ? number_format($detalle[$i]['cantidad'], 3, '.', '') : number_format($detalle[$i]['cantidad'], 0, '.', '');
		$existencia = $_POST["opcionvendido"][$i] == "2" ? number_format($existenciacombobd-$cantpreventa, 3, '.', '') : number_format($existenciacombobd-$cantpreventa, 0, '.', '');
		$stmt->execute();
		##################### ACTUALIZO LA EXISTENCIA DEL COMBO DEL ALMACEN ####################

		############### REGISTRAMOS LOS DATOS DE COMBO EN KARDEX ###############
	    $query = "INSERT INTO kardex values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codpreventa);
		$stmt->bindParam(2, $codcliente);
		$stmt->bindParam(3, $codproducto);
		$stmt->bindParam(4, $movimiento);
		$stmt->bindParam(5, $entradas);
		$stmt->bindParam(6, $salidas);
		$stmt->bindParam(7, $devolucion);
		$stmt->bindParam(8, $stockactual);
		$stmt->bindParam(9, $ivaproducto);
		$stmt->bindParam(10, $descproducto);
		$stmt->bindParam(11, $precio);
		$stmt->bindParam(12, $documento);
		$stmt->bindParam(13, $fechakardex);	
	    $stmt->bindParam(14, $tipokardex);
	    $stmt->bindParam(15, $procedimiento);		
		$stmt->bindParam(16, $codsucursal);
		$stmt->bindParam(17, $codigo);

		$codproducto   = limpiar($detalle[$i]['txtCodigo']);
		$movimiento    = limpiar("SALIDAS");
		$entradas      = $detalle[$i]['opcionvendido'] == "2" ? "0.000" : "0";
		$salidas       = $detalle[$i]['opcionvendido'] == "2" ? number_format($detalle[$i]['cantidad'], 3, '.', '') : number_format($detalle[$i]['cantidad'], 0, '.', '');
		$devolucion    = $detalle[$i]['opcionvendido'] == "2" ? "0.000" : "0";
		$stockactual   = $detalle[$i]['opcionvendido'] == "2" ? number_format($existenciacombobd-$detalle[$i]['cantidad'], 3, '.', '') : number_format($existenciacombobd-$detalle[$i]['cantidad'], 0, '.', '');
		$ivaproducto   = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
		$descproducto  = number_format($detalle[$i]['descproducto'], 2, '.', '');
		$precio        = number_format($detalle[$i]["precio2"], 2, '.', '');
		$documento     = limpiar("PREVENTA: ".$codfacturabd);
		$fechakardex   = limpiar(date("Y-m-d"));
	    $tipokardex    = limpiar($detalle[$i]['tipodetalle']);
	    $procedimiento = limpiar("2");	
		$codsucursal   = limpiar(decrypt($_POST["codsucursal"]));
    	$codigo        = limpiar($_SESSION["codigo"]);
		$stmt->execute();
		############### REGISTRAMOS LOS DATOS DE COMBO EN KARDEX ###############

		############## VERIFICO SI EL COMBO TIENE PRODUCTO RELACIONADOS #################
	    $sql = "SELECT * FROM combosxproductos WHERE codcombo = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array($detalle[$i]['txtCodigo'],limpiar(decrypt($_POST["codsucursal"]))));
		$num = $stmt->rowCount();
	    if($num>0) {  

	    	$sql = "SELECT 
	    	combosxproductos.codcombo,
	    	combosxproductos.idproducto,
	    	combosxproductos.codproducto,
	    	combosxproductos.cantidad,
	    	combosxproductos.codsucursal,
	    	productos.opcionvendido,
	    	productos.existencia,
	    	productos.precioxpublico AS precioventa,
	    	productos.ivaproducto,
	    	productos.descproducto
	    	FROM combosxproductos 
	    	LEFT JOIN productos ON combosxproductos.codproducto = productos.codproducto 
	    	WHERE combosxproductos.codcombo IN ('".limpiar($detalle[$i]['txtCodigo'])."') 
	    	AND combosxproductos.codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."' 
	    	AND productos.codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
	    	foreach ($this->dbh->query($sql) as $row)
		    { 
			    $this->p[] = $row;

			    $cantracionbd2   = $row['cantidad'];
			    $idproductobd2   = $row['idproducto'];
			    $codproductobd2  = $row['codproducto'];
			    $existenciabd2   = $row['existencia'];
			    $precioventabd2  = $row['precioventa'];
			    $ivaproductobd2  = $row['ivaproducto'];
			    $descproductobd2 = $row['descproducto'];
			    $opcionvendido2  = $row['opcionvendido'];

			    ############## ACTUALIZO LOS DATOS DEL PRODUCTO #################
			    $update = "UPDATE productos set "
			    ." existencia = ? "
			    ." WHERE "
			    ." idproducto = ? AND codproducto = ? AND codsucursal = ?;
			    ";
			    $stmt = $this->dbh->prepare($update);
			    $stmt->bindParam(1, $cantidadracion);
			    $stmt->bindParam(2, $idproducto);
			    $stmt->bindParam(3, $codproducto);
	            $stmt->bindParam(4, $codsucursal);

		        $racion         = $cantracionbd2*$detalle[$i]['cantidad'];
			    $cantidadracion = $opcionvendido2 == "2" ? number_format($existenciabd2-$racion, 3, '.', '') : number_format($existenciabd2-$racion, 0, '.', '');
			    $idproducto = limpiar($idproductobd2);
		        $codproducto = limpiar($codproductobd2);
	            $codsucursal = limpiar(decrypt($_POST["codsucursal"]));
			    $stmt->execute();
			    ############## ACTUALIZO LOS DATOS DEL PRODUCTO #################

			    ############## REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX ###################
			    $query = "INSERT INTO kardex values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
			    $stmt = $this->dbh->prepare($query);
			    $stmt->bindParam(1, $codpreventa);
			    $stmt->bindParam(2, $codcliente);
			    $stmt->bindParam(3, $codproducto);
			    $stmt->bindParam(4, $movimiento);
			    $stmt->bindParam(5, $entradas);
			    $stmt->bindParam(6, $salidas);
			    $stmt->bindParam(7, $devolucion);
			    $stmt->bindParam(8, $stockactual);
			    $stmt->bindParam(9, $ivaproducto);
			    $stmt->bindParam(10, $descproducto);
			    $stmt->bindParam(11, $precio);
			    $stmt->bindParam(12, $documento);
			    $stmt->bindParam(13, $fechakardex);
	            $stmt->bindParam(14, $tipokardex);
	            $stmt->bindParam(15, $procedimiento);
	            $stmt->bindParam(16, $codsucursal);
		        $stmt->bindParam(17, $codigo);		

			    $codproducto   = limpiar($codproductobd2);
			    $movimiento    = limpiar("SALIDAS");
			    $entradas      = $opcionvendido2 == "2" ? "0.000" : "0";
			    $salidas       = $opcionvendido2 == "2" ? number_format($racion, 3, '.', '') : number_format($racion, 0, '.', '');
			    $devolucion    = $opcionvendido2 == "2" ? "0.000" : "0";
			    $stockactual   = $opcionvendido2 == "2" ? number_format($existenciabd2-$racion, 3, '.', '') : number_format($existenciabd2-$racion, 0, '.', '');
			    $ivaproducto   = limpiar($ivaproductobd2 == "NO" ? "0.00" : $_POST["iva"]);
			    $descproducto  = number_format($descproductobd2, 2, '.', '');
			    $precio        = number_format($precioventabd2, 2, '.', '');
			    $documento     = limpiar("PREVENTA (DETALLE DE COMBO): ".$codfacturabd);
			    $fechakardex   = limpiar(date("Y-m-d"));
	            $tipokardex    = limpiar("1");
	            $procedimiento = limpiar("2");
	            $codsucursal   = limpiar(decrypt($_POST["codsucursal"]));
    	        $codigo        = limpiar($_SESSION["codigo"]);
			    $stmt->execute();
			    ############## REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX ################### 
		    }
	    }//fin de consulta de productos de combos	
	    ############## VERIFICO SI EL COMBO TIENE PRODUCTO RELACIONADOS #################
    	
   } else { // SI EL DETALLE ES UN SERVICIO

	    ############### REGISTRAMOS LOS DATOS DE SERVICIO EN KARDEX ###############
	    $query = "INSERT INTO kardex values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $codpreventa);
		$stmt->bindParam(2, $codcliente);
		$stmt->bindParam(3, $codproducto);
		$stmt->bindParam(4, $movimiento);
		$stmt->bindParam(5, $entradas);
		$stmt->bindParam(6, $salidas);
		$stmt->bindParam(7, $devolucion);
		$stmt->bindParam(8, $stockactual);
		$stmt->bindParam(9, $ivaproducto);
		$stmt->bindParam(10, $descproducto);
		$stmt->bindParam(11, $precio);
		$stmt->bindParam(12, $documento);
		$stmt->bindParam(13, $fechakardex);	
	    $stmt->bindParam(14, $tipokardex);
	    $stmt->bindParam(15, $procedimiento);		
		$stmt->bindParam(16, $codsucursal);
		$stmt->bindParam(17, $codigo);

		$codproducto  = limpiar($detalle[$i]['txtCodigo']);
		$movimiento    = limpiar("SALIDAS");
		$entradas      = $detalle[$i]['opcionvendido'] == "2" ? "0.000" : "0";
		$salidas       = $detalle[$i]['opcionvendido'] == "2" ? number_format($detalle[$i]['cantidad'], 3, '.', '') : number_format($detalle[$i]['cantidad'], 0, '.', '');
		$devolucion    = $detalle[$i]['opcionvendido'] == "2" ? "0.000" : "0";
		$stockactual   = $detalle[$i]['opcionvendido'] == "2" ? "0.000" : "0";
		$ivaproducto   = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
		$descproducto  = number_format($detalle[$i]['descproducto'], 2, '.', '');
		$precio        = number_format($detalle[$i]["precio2"], 2, '.', '');
		$documento     = limpiar("PREVENTA: ".$codfacturabd);
		$fechakardex   = limpiar(date("Y-m-d"));
	    $tipokardex    = limpiar($detalle[$i]['tipodetalle']);
	    $procedimiento = limpiar("1");	
		$codsucursal   = limpiar(decrypt($_POST["codsucursal"]));
    	$codigo        = limpiar($_SESSION["codigo"]);
		$stmt->execute();
		############### REGISTRAMOS LOS DATOS DE SERVICIO EN KARDEX ###############

            }
	    }
    }    
    ####################### DESTRUYO LA VARIABLE DE SESSION #####################
    unset($_SESSION["CarritoPreventa"]);
    $this->dbh->commit();

    ############ SUMO LOS IMPORTE DE PRODUCTOS CON IVA ##############
	$sql3 = "SELECT SUM(totaldescuentov) AS totaldescuentosi, SUM(subtotalimpuestos) AS subtotalimpuestos, SUM(valorneto-subtotalimpuestos) AS valorneto, SUM(valorneto2) AS valorneto2 FROM detallepreventas WHERE codpreventa = '".limpiar(decrypt($_POST["codpreventa"]))."' AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."' AND ivaproducto != '0.00'";
	foreach ($this->dbh->query($sql3) as $row3)
	{
		$this->p[] = $row3;
	}
	$subtotaldescuentosi = ($row3['totaldescuentosi']== "" ? "0.00" : $row3['totaldescuentosi']);
	$subtotalimpuestos   = ($row3['subtotalimpuestos']== "" ? "0.00" : $row3['subtotalimpuestos']);
	$subtotalivasi       = ($row3['valorneto']== "" ? "0.00" : $row3['valorneto']);
	$subtotalivasi2      = ($row3['valorneto2']== "" ? "0.00" : $row3['valorneto2']);
	############ SUMO LOS IMPORTE DE PRODUCTOS CON IVA ##############

	############ SUMO LOS IMPORTE DE PRODUCTOS SIN IVA ##############
	$sql4 = "SELECT SUM(totaldescuentov) AS totaldescuentono, SUM(valorneto) AS valorneto, SUM(valorneto2) AS valorneto2 FROM detallepreventas WHERE codpreventa = '".limpiar(decrypt($_POST["codpreventa"]))."' AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."' AND ivaproducto = '0.00'";
	foreach ($this->dbh->query($sql4) as $row4)
	{
		$this->p[] = $row4;
	}
	$subtotaldescuentono = ($row4['totaldescuentono']== "" ? "0.00" : $row4['totaldescuentono']);
	$subtotalivano       = ($row4['valorneto']== "" ? "0.00" : $row4['valorneto']);
	$subtotalivano2      = ($row4['valorneto2']== "" ? "0.00" : $row4['valorneto2']);
	############ SUMO LOS IMPORTE DE PRODUCTOS SIN IVA ##############

    ############ ACTUALIZO LOS TOTALES EN LA PREVENTA ##############
	$sql = " UPDATE preventas SET "
	." codcliente = ?, "
	." observaciones = ?, "
	." subtotalivasi = ?, "
	." subtotalivano = ?, "
	." totaliva = ?, "
	." descontado = ?, "
	." descuento = ?, "
	." totaldescuento = ?, "
	." totalpago = ?, "
	." totalpago2= ? "
	." WHERE "
	." codpreventa = ? AND codsucursal = ?;
	";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $codcliente);
	$stmt->bindParam(2, $observaciones);
	$stmt->bindParam(3, $subtotalivasi);
	$stmt->bindParam(4, $subtotalivano);
	$stmt->bindParam(5, $totaliva);
	$stmt->bindParam(6, $descontado);
	$stmt->bindParam(7, $descuento);
	$stmt->bindParam(8, $totaldescuento);
	$stmt->bindParam(9, $totalpago);
	$stmt->bindParam(10, $totalpago2);
	$stmt->bindParam(11, $codpreventa);
	$stmt->bindParam(12, $codsucursal);

	$observaciones  = limpiar($_POST["observaciones"]);
	$iva            = $_POST["iva"]/100;
	$totaliva       = number_format($subtotalimpuestos, 2, '.', '');
    $descontado     = number_format($subtotaldescuentosi+$subtotaldescuentono, 2, '.', '');
    $descuento      = limpiar($_POST["descuento"]+$descuentobd);
    $txtDescuento   = $descuento/100;
    $total          = number_format($subtotalivasi+$subtotalivano+$totaliva, 2, '.', '');
    $totaldescuento = number_format($total*$txtDescuento, 2, '.', '');
    $totalpago      = number_format($total-$totaldescuento, 2, '.', '');
    $totalpago2     = number_format($subtotalivasi2+$subtotalivano2, 2, '.', '');
	$codpreventa    = limpiar(decrypt($_POST["codpreventa"]));
	$codsucursal    = limpiar(decrypt($_POST["codsucursal"]));
	$stmt->execute();
	############ ACTUALIZO LOS TOTALES EN LA PREVENTA ##############

    echo "<span class='fa fa-check-square-o'></span> LOS DETALLES DE PRODUCTOS FUERON AGREGADOS A LA PREVENTA EXITOSAMENTE <a href='reportepdf?codpreventa=".encrypt($codpreventa)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt("TICKETPREVENTA")."' class='on-default' data-placement='left' data-toggle='tooltip' data-original-title='Imprimir Documento' target='_black' rel='noopener noreferrer'><font color='black'><strong>IMPRIMIR REPORTE</strong></font color></a></div>";

    echo "<script>VentanaCentrada('reportepdf?codpreventa=".encrypt($codpreventa)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt("TICKETPREVENTA")."', '', '', '1024', '568', 'true');</script>";
	exit;
}
######################### FUNCION AGREGAR DETALLES PREVENTAS #######################

######################## FUNCION ELIMINAR DETALLES PREVENTAS #######################
public function EliminarDetallesPreventas()
{
	$this->p = [];
	if ($_SESSION["acceso"]=="administradorS") {

    ############ CONSULTO DATOS DE PREVENTAS ##############
	$sql = "SELECT * FROM preventas 
	WHERE codpreventa = '".limpiar(decrypt($_GET["codpreventa"]))."' 
	AND codsucursal = '".limpiar(decrypt($_GET["codsucursal"]))."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$codfacturabd = $row['codfactura'];
	$clientebd    = $row['codcliente'];
	$ivabd        = $row['iva'];
	$iva          = $row["iva"]/100;
	$descuento    = $row["descuento"]/100;
	$totalpagobd  = $row['totalpago'];
	############ CONSULTO DATOS DE PREVENTAS ##############

	$sql = "SELECT * FROM detallepreventas WHERE codpreventa = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_GET["codpreventa"]),decrypt($_GET["codsucursal"])));
	$num = $stmt->rowCount();
	if($num > 1)
	{
		$sql = "SELECT codproducto, opcionvendido, cantpreventa, precioventa, ivaproducto, descproducto, tipodetalle FROM detallepreventas WHERE coddetallepreventa = ? and codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array(decrypt($_GET["coddetallepreventa"]),decrypt($_GET["codsucursal"])));
		$num = $stmt->rowCount();

		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$p[] = $row;
		}
		$codproductobd    = $row['codproducto'];
		$opcionvendidobd  = $row['opcionvendido'];
		$cantidadbd       = $row['cantpreventa'];
		$precioventabd    = $row['precioventa'];
		$ivaproductobd    = $row['ivaproducto'];
		$descproductobd   = $row['descproducto'];
		$tipodetallebd    = $row['tipodetalle'];

		if(limpiar($tipodetallebd) == 1){// SSI EL DETALLE ES UN PRODCUTO

			############ OBTENGO LA EXISTENCIA DE PRODUCTO EN ALMACEN #############
			$sql2 = "SELECT existencia FROM productos WHERE codproducto = ? AND codsucursal = ?";
			$stmt = $this->dbh->prepare($sql2);
			$stmt->execute(array($codproductobd,decrypt($_GET["codsucursal"])));
			$num = $stmt->rowCount();

			if($row = $stmt->fetch(PDO::FETCH_ASSOC))
			{
				$p[] = $row;
			}
			$existenciabd = $row['existencia'];
			############ OBTENGO LA EXISTENCIA DE PRODUCTO EN ALMACEN #############

			############ ACTUALIZAMOS LA EXISTENCIA DE PRODUCTO EN ALMACEN #############
			$sql = "UPDATE productos SET "
			." existencia = ? "
			." WHERE "
			." codproducto = ? AND codsucursal = ?;
			";
			$stmt = $this->dbh->prepare($sql);
			$stmt->bindParam(1, $existencia);
			$stmt->bindParam(2, $codproducto);
			$stmt->bindParam(3, $codsucursal);

			$existencia  = $opcionvendidobd == "2" ? number_format($existenciabd+$cantidadbd, 3, '.', '') : number_format($existenciabd+$cantidadbd, 0, '.', '');
			$codproducto = limpiar($codproductobd);
			$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
			$stmt->execute();
			############ ACTUALIZAMOS LA EXISTENCIA DE PRODUCTO EN ALMACEN #############

			########## REGISTRAMOS LOS DATOS DEL PRODUCTO ELIMINADO EN KARDEX ##########
			$query = "INSERT INTO kardex values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
			$stmt = $this->dbh->prepare($query);
			$stmt->bindParam(1, $codpreventa);
			$stmt->bindParam(2, $codresponsable);
			$stmt->bindParam(3, $codproducto);
			$stmt->bindParam(4, $movimiento);
			$stmt->bindParam(5, $entradas);
			$stmt->bindParam(6, $salidas);
			$stmt->bindParam(7, $devolucion);
			$stmt->bindParam(8, $stockactual);
			$stmt->bindParam(9, $ivaproducto);
			$stmt->bindParam(10, $descproducto);
			$stmt->bindParam(11, $precio);
			$stmt->bindParam(12, $documento);
			$stmt->bindParam(13, $fechakardex);	
			$stmt->bindParam(14, $tipokardex);
	        $stmt->bindParam(15, $procedimiento);	
			$stmt->bindParam(16, $codsucursal);
		    $stmt->bindParam(17, $codigo);

			$codpreventa    = limpiar(decrypt($_GET["codpreventa"]));
			$codresponsable = limpiar($clientebd);
			$codproducto    = limpiar($codproductobd);
			$movimiento     = limpiar("DEVOLUCION");
		    $entradas       = $opcionvendidobd == "2" ? "0.000" : "0";
		    $salidas        = $opcionvendidobd == "2" ? "0.000" : "0";
		    $devolucion     = $opcionvendidobd == "2" ? number_format($cantidadbd, 3, '.', '') : number_format($cantidadbd, 0, '.', '');
		    $stockactual    = $opcionvendidobd == "2" ? number_format($existenciabd+$cantidadbd, 3, '.', '') : number_format($existenciabd+$cantidadbd, 0, '.', '');
			$ivaproducto    = limpiar($ivaproductobd);
			$descproducto   = number_format($descproductobd, 2, '.', '');
			$precio         = number_format($precioventabd, 2, '.', '');
			$documento      = limpiar("DEVOLUCION PREVENTA: ".$codfacturabd);
			$fechakardex    = limpiar(date("Y-m-d"));
			$tipokardex     = limpiar($tipodetallebd);
	        $procedimiento  = limpiar("1");
			$codsucursal    = limpiar(decrypt($_GET["codsucursal"]));
    	    $codigo         = limpiar($_SESSION["codigo"]);
			$stmt->execute();
			########## REGISTRAMOS LOS DATOS DEL PRODUCTO ELIMINADO EN KARDEX ##########

		} elseif(limpiar($tipodetallebd) == 2){ // SI EL DETALLE ES UN COMBO

			############## VERIFICO LA EXISTENCIA DEL COMBO EN ALMACEN #################
			$sql2 = "SELECT existencia FROM combos WHERE codcombo = ? AND codsucursal = ?";
			$stmt = $this->dbh->prepare($sql2);
			$stmt->execute(array($codproductobd,decrypt($_GET["codsucursal"])));
			$num = $stmt->rowCount();

			if($row = $stmt->fetch(PDO::FETCH_ASSOC))
			{
				$p[] = $row;
			}
			$existenciacombobd = $row['existencia'];
			############## VERIFICO LA EXISTENCIA DEL COMBO EN ALMACEN #################	

			########### ACTUALIZAMOS LA EXISTENCIA DE COMBO EN ALMACEN #############
			$sql = "UPDATE combos SET "
			." existencia = ? "
			." WHERE "
			." codcombo = ? AND codsucursal = ?;
			";
			$stmt = $this->dbh->prepare($sql);
			$stmt->bindParam(1, $existencia);
			$stmt->bindParam(2, $codproducto);	
			$stmt->bindParam(3, $codsucursal);	

			$existencia  = $opcionvendidobd == "2" ? number_format($existenciacombobd+$cantidadbd, 3, '.', '') : number_format($existenciabd+$cantidadbd, 0, '.', '');
			$codproducto = limpiar($codproductobd);
			$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
			$stmt->execute();
			########### ACTUALIZAMOS LA EXISTENCIA DE COMBO EN ALMACEN #############

			########## REGISTRAMOS LOS DATOS DEL PRODUCTO ELIMINADO EN KARDEX ##########
			$query = "INSERT INTO kardex values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
			$stmt = $this->dbh->prepare($query);
			$stmt->bindParam(1, $codpreventa);
			$stmt->bindParam(2, $codresponsable);
			$stmt->bindParam(3, $codproducto);
			$stmt->bindParam(4, $movimiento);
			$stmt->bindParam(5, $entradas);
			$stmt->bindParam(6, $salidas);
			$stmt->bindParam(7, $devolucion);
			$stmt->bindParam(8, $stockactual);
			$stmt->bindParam(9, $ivaproducto);
			$stmt->bindParam(10, $descproducto);
			$stmt->bindParam(11, $precio);
			$stmt->bindParam(12, $documento);
			$stmt->bindParam(13, $fechakardex);	
			$stmt->bindParam(14, $tipokardex);
	        $stmt->bindParam(15, $procedimiento);	
			$stmt->bindParam(16, $codsucursal);
		    $stmt->bindParam(17, $codigo);

			$codpreventa    = limpiar(decrypt($_GET["codpreventa"]));
			$codresponsable = limpiar($clientebd);
			$codproducto    = limpiar($codproductobd);
			$movimiento     = limpiar("DEVOLUCION");
		    $entradas       = $opcionvendidobd == "2" ? "0.000" : "0";
		    $salidas        = $opcionvendidobd == "2" ? "0.000" : "0";
		    $devolucion     = $opcionvendidobd == "2" ? number_format($cantidadbd, 3, '.', '') : number_format($cantidadbd, 0, '.', '');
		    $stockactual    = $opcionvendidobd == "2" ? number_format($existenciacombobd+$cantidadbd, 3, '.', '') : number_format($existenciacombobd+$cantidadbd, 0, '.', '');
			$ivaproducto    = limpiar($ivaproductobd);
			$descproducto   = number_format($descproductobd, 2, '.', '');
			$precio         = limpiar($precioventabd, 2, '.', '');
			$documento      = limpiar("DEVOLUCION PREVENTA: ".$codfacturabd);
			$fechakardex    = limpiar(date("Y-m-d"));
			$tipokardex     = limpiar($tipodetallebd);
	        $procedimiento  = limpiar("2");
			$codsucursal    = limpiar(decrypt($_GET["codsucursal"]));
    	    $codigo         = limpiar($_SESSION["codigo"]);
			$stmt->execute();
			########## REGISTRAMOS LOS DATOS DEL PRODUCTO ELIMINADO EN KARDEX ##########

			############## VERIFICO SI EL COMBO TIENE PRODUCTO RELACIONADOS #################
		    $sql = "SELECT * FROM combosxproductos WHERE codcombo = ? AND codsucursal = ?";
			$stmt = $this->dbh->prepare($sql);
			$stmt->execute(array(limpiar($codproductobd),decrypt($_GET["codsucursal"])));
			$num = $stmt->rowCount();
	        if($num>0) {  

	        	$sql = "SELECT 
	        	combosxproductos.codcombo,
	    	    combosxproductos.idproducto,
	        	combosxproductos.codproducto,
	        	combosxproductos.cantidad,
	        	combosxproductos.codsucursal,
	        	productos.opcionvendido,
	        	productos.existencia,
	        	productos.precioxpublico AS precioventa,
	        	productos.ivaproducto,
	        	productos.descproducto
		    	FROM combosxproductos 
	        	LEFT JOIN productos ON combosxproductos.codproducto = productos.codproducto 
	        	WHERE combosxproductos.codcombo IN ('".limpiar($codproductobd)."') 
	        	AND combosxproductos.codsucursal = '".limpiar(decrypt($_GET['codsucursal']))."' 
		    	AND productos.codsucursal = '".limpiar(decrypt($_GET['codsucursal']))."'";
	        	foreach ($this->dbh->query($sql) as $row)
			    { 
				    $this->p[] = $row;

				    $cantracionbd2   = $row['cantidad'];
					$idproductobd2   = $row['idproducto'];
			        $codproductobd2  = $row['codproducto'];
					$existenciabd2   = $row['existencia'];
					$precioventabd2  = $row['precioventa'];
					$ivaproductobd2  = $row['ivaproducto'];
					$descproductobd2 = $row['descproducto'];
				    $opcionvendido2  = $row['opcionvendido'];

					############## ACTUALIZO LOS DATOS DEL PRODUCTO #################
					$update = "UPDATE productos set "
				    ." existencia = ? "
				    ." WHERE "
				    ." idproducto = ? AND codproducto = ? AND codsucursal = ?;
				    ";
				    $stmt = $this->dbh->prepare($update);
				    $stmt->bindParam(1, $cantidadracion);
				    $stmt->bindParam(2, $idproducto);
				    $stmt->bindParam(3, $codproducto);
		            $stmt->bindParam(4, $codsucursal);

					$racion         = $cantracionbd2*$cantidadbd;
				    $cantidadracion = $opcionvendido2 == "2" ? number_format($existenciabd2+$racion, 3, '.', '') : number_format($existenciabd2+$racion, 0, '.', '');
		            $idproducto     = limpiar($idproductobd2);
		            $codproducto    = limpiar($codproductobd2);
					$codsucursal    = limpiar(decrypt($_GET["codsucursal"]));
					$stmt->execute();
				    ############## ACTUALIZO LOS DATOS DEL PRODUCTO #################

					########## REGISTRAMOS LOS DATOS DEL PRODUCTO ELIMINADO EN KARDEX ##########
					$query = "INSERT INTO kardex values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
					$stmt = $this->dbh->prepare($query);
					$stmt->bindParam(1, $codpreventa);
					$stmt->bindParam(2, $codresponsable);
					$stmt->bindParam(3, $codproducto);
					$stmt->bindParam(4, $movimiento);
					$stmt->bindParam(5, $entradas);
					$stmt->bindParam(6, $salidas);
					$stmt->bindParam(7, $devolucion);
					$stmt->bindParam(8, $stockactual);
					$stmt->bindParam(9, $ivaproducto);
					$stmt->bindParam(10, $descproducto);
					$stmt->bindParam(11, $precio);
					$stmt->bindParam(12, $documento);
					$stmt->bindParam(13, $fechakardex);	
					$stmt->bindParam(14, $tipokardex);
	                $stmt->bindParam(15, $procedimiento);	
					$stmt->bindParam(16, $codsucursal);
		            $stmt->bindParam(17, $codigo);

					$codpreventa    = limpiar(decrypt($_GET["codpreventa"]));
					$codresponsable = limpiar($clientebd);
					$codproducto    = limpiar($codproductobd2);
					$movimiento     = limpiar("DEVOLUCION");
			        $entradas       = $opcionvendido2 == "2" ? "0.000" : "0";
			        $salidas        = $opcionvendido2 == "2" ? "0.000" : "0";
			        $salidas        = $opcionvendido2 == "2" ? number_format($racion, 3, '.', '') : number_format($racion, 0, '.', '');
			        $stockactual    = $opcionvendido2 == "2" ? number_format($existenciabd2+$racion, 3, '.', '') : number_format($existenciabd2+$racion, 0, '.', '');
					$ivaproducto    = limpiar($ivaproductobd2 == "SI" ? $ivabd : "0.00");
					$descproducto   = number_format($descproductobd2, 2, '.', '');
					$precio         = number_format($precioventabd2, 2, '.', '');
					$documento      = limpiar("DEVOLUCION PREVENTA (DETALLE DE COMBO): ".$codfacturabd);
					$fechakardex    = limpiar(date("Y-m-d"));
					$tipokardex     = limpiar("1");
	                $procedimiento  = limpiar("2");
					$codsucursal    = limpiar(decrypt($_GET["codsucursal"]));
    	            $codigo         = limpiar($_SESSION["codigo"]);
					$stmt->execute();
				    ########## REGISTRAMOS LOS DATOS DEL PRODUCTO ELIMINADO EN KARDEX ##########   
			    }
		    }//fin de consulta de productos en combos	
		    ############## VERIFICO SI EL COMBO TIENE PRODUCTO RELACIONADOS #################

		} else { // SI EL DETALLE ES UN SERVICIO

			########## REGISTRAMOS LOS DATOS DEL SERVICIO ELIMINADO EN KARDEX ##########
			$query = "INSERT INTO kardex values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
			$stmt = $this->dbh->prepare($query);
			$stmt->bindParam(1, $codpreventa);
			$stmt->bindParam(2, $codresponsable);
			$stmt->bindParam(3, $codproducto);
			$stmt->bindParam(4, $movimiento);
			$stmt->bindParam(5, $entradas);
			$stmt->bindParam(6, $salidas);
			$stmt->bindParam(7, $devolucion);
			$stmt->bindParam(8, $stockactual);
			$stmt->bindParam(9, $ivaproducto);
			$stmt->bindParam(10, $descproducto);
			$stmt->bindParam(11, $precio);
			$stmt->bindParam(12, $documento);
			$stmt->bindParam(13, $fechakardex);	
			$stmt->bindParam(14, $tipokardex);	
	        $stmt->bindParam(15, $procedimiento);
			$stmt->bindParam(16, $codsucursal);
		    $stmt->bindParam(17, $codigo);

			$codpreventa    = limpiar(decrypt($_GET["codpreventa"]));
			$codresponsable = limpiar($clientebd);
		    $codproducto    = limpiar($codproductobd);
			$movimiento     = limpiar("DEVOLUCION");
		    $entradas       = $opcionvendidobd == "2" ? "0.000" : "0";
		    $salidas        = $opcionvendidobd == "2" ? "0.000" : "0";
		    $devolucion     = $opcionvendidobd == "2" ? number_format($cantidadbd, 3, '.', '') : number_format($cantidadbd, 0, '.', '');
		    $stockactual    = $opcionvendidobd == "2" ? "0.000" : "0";
			$ivaproducto    = limpiar($ivaproductobd);
			$descproducto   = number_format($descproductobd, 2, '.', '');
			$precio         = number_format($precioventabd, 2, '.', '');
			$documento      = limpiar("DEVOLUCION PREVENTA: ".$codfacturabd);
			$fechakardex    = limpiar(date("Y-m-d"));
			$tipokardex     = limpiar($tipodetallebd);
	        $procedimiento  = limpiar("3");
			$codsucursal    = limpiar(decrypt($_GET["codsucursal"]));
    	    $codigo         = limpiar($_SESSION["codigo"]);
			$stmt->execute();
			########## REGISTRAMOS LOS DATOS DEL SERVICIO ELIMINADO EN KARDEX ##########
		}
	   
		################## ELIMINO DETALLE DE PREVENTA ##################
		$sql = "DELETE FROM detallepreventas WHERE coddetallepreventa = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$coddetallepreventa);
		$stmt->bindParam(2,$codsucursal);
		$coddetallepreventa = decrypt($_GET["coddetallepreventa"]);
		$codsucursal        = decrypt($_GET["codsucursal"]);
		$stmt->execute();
		################## ELIMINO DETALLE DE PREVENTA ##################

        ############ SUMO LOS IMPORTE DE PRODUCTOS CON IVA ##############
		$sql3 = "SELECT SUM(totaldescuentov) AS totaldescuentosi, SUM(subtotalimpuestos) AS subtotalimpuestos, SUM(valorneto-subtotalimpuestos) AS valorneto, SUM(valorneto2) AS valorneto2 FROM detallepreventas WHERE codpreventa = '".limpiar(decrypt($_GET["codpreventa"]))."' AND codsucursal = '".limpiar(decrypt($_GET["codsucursal"]))."' AND ivaproducto != '0.00'";
		foreach ($this->dbh->query($sql3) as $row3)
		{
			$this->p[] = $row3;
		}
		$subtotaldescuentosi = ($row3['totaldescuentosi']== "" ? "0.00" : $row3['totaldescuentosi']);
	    $subtotalimpuestos   = ($row3['subtotalimpuestos']== "" ? "0.00" : $row3['subtotalimpuestos']);
		$subtotalivasi       = ($row3['valorneto']== "" ? "0.00" : $row3['valorneto']);
		$subtotalivasi2      = ($row3['valorneto2']== "" ? "0.00" : $row3['valorneto2']);
		############ SUMO LOS IMPORTE DE PRODUCTOS CON IVA ##############

	    ############ SUMO LOS IMPORTE DE PRODUCTOS SIN IVA ##############
		$sql4 = "SELECT SUM(totaldescuentov) AS totaldescuentono, SUM(valorneto) AS valorneto, SUM(valorneto2) AS valorneto2 FROM detallepreventas WHERE codpreventa = '".limpiar(decrypt($_GET["codpreventa"]))."' AND codsucursal = '".limpiar(decrypt($_GET["codsucursal"]))."' AND ivaproducto = '0.00'";
		foreach ($this->dbh->query($sql4) as $row4)
		{
			$this->p[] = $row4;
		}
		$subtotaldescuentono = ($row4['totaldescuentono']== "" ? "0.00" : $row4['totaldescuentono']);
		$subtotalivano       = ($row4['valorneto']== "" ? "0.00" : $row4['valorneto']);
		$subtotalivano2      = ($row4['valorneto2']== "" ? "0.00" : $row4['valorneto2']);
		############ SUMO LOS IMPORTE DE PRODUCTOS SIN IVA ##############

        ################### ACTUALIZO LA PREVENTA ####################
		$sql = " UPDATE preventas SET "
		." subtotalivasi = ?, "
		." subtotalivano = ?, "
		." totaliva = ?, "
		." descontado = ?, "
		." totaldescuento = ?, "
		." totalpago = ?, "
		." totalpago2= ? "
		." WHERE "
		." codpreventa = ? AND codsucursal = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $subtotalivasi);
		$stmt->bindParam(2, $subtotalivano);
		$stmt->bindParam(3, $totaliva);
		$stmt->bindParam(4, $descontado);
		$stmt->bindParam(5, $totaldescuento);
		$stmt->bindParam(6, $totalpago);
		$stmt->bindParam(7, $totalpago2);
		$stmt->bindParam(8, $codpreventa);
		$stmt->bindParam(9, $codsucursal);

		$totaliva       = number_format($subtotalimpuestos, 2, '.', '');
		$descontado     = number_format($subtotaldescuentosi+$subtotaldescuentono, 2, '.', '');
	    $total          = number_format($subtotalivasi+$subtotalivano+$totaliva, 2, '.', '');
	    $totaldescuento = number_format($total*$descuento, 2, '.', '');
	    $totalpago      = number_format($total-$totaldescuento, 2, '.', '');
		$totalpago2     = number_format($subtotalivasi2+$subtotalivano2, 2, '.', '');
		$codpreventa    = limpiar(decrypt($_GET["codpreventa"]));
		$codsucursal    = limpiar(decrypt($_GET["codsucursal"]));
		$stmt->execute();
		################### ACTUALIZO LA PREVENTA ####################

		echo "1";
		exit;

	} else {
		   
		echo "2";
		exit;
	} 
			
	} else {
		
		echo "3";
		exit;
	}	
}
################### FUNCION ELIMINAR DETALLES PREVENTAS #####################

####################### FUNCION ELIMINAR PREVENTAS #################################
public function EliminarPreventas()
{
	$this->p = [];
	if ($_SESSION["acceso"]=="administradorS") {

    ############ CONSULTO DATOS DE TRASPASO ##############
	$sql = "SELECT * FROM preventas WHERE codpreventa = '".limpiar(decrypt($_GET["codpreventa"]))."' AND codsucursal = '".limpiar(decrypt($_GET["codsucursal"]))."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$codfacturabd = $row['codfactura'];
	$clientebd = $row['codcliente'];
	$totalpagobd = $row['totalpago'];
	############ CONSULTO DATOS DE TRASPASO ##############

    $sql = "SELECT * FROM detallepreventas 
    WHERE codpreventa = '".limpiar(decrypt($_GET["codpreventa"]))."' 
    AND codsucursal = '".limpiar(decrypt($_GET["codsucursal"]))."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;

		$codproductobd  = $row['codproducto'];
		$opcionvendidobd= $row['opcionvendido'];
		$cantidadbd     = $row['cantpreventa'];
		$precioventabd  = $row['precioventa'];
		$ivaproductobd  = $row['ivaproducto'];
		$descproductobd = $row['descproducto'];
		$tipodetallebd  = $row['tipodetalle'];

		if(limpiar($tipodetallebd) == 1){// SSI EL DETALLE ES UN PRODCUTO

			############ OBTENGO LA EXISTENCIA DE PRODUCTO EN ALMACEN #############
			$sql2 = "SELECT existencia FROM productos WHERE codproducto = ? AND codsucursal = ?";
			$stmt = $this->dbh->prepare($sql2);
			$stmt->execute(array($codproductobd,decrypt($_GET["codsucursal"])));
			$num = $stmt->rowCount();

			if($row = $stmt->fetch(PDO::FETCH_ASSOC))
			{
				$p[] = $row;
			}
			$existenciabd = $row['existencia'];
			############ OBTENGO LA EXISTENCIA DE PRODUCTO EN ALMACEN #############

			############ ACTUALIZAMOS LA EXISTENCIA DE PRODUCTO EN ALMACEN #############
			$sql = "UPDATE productos SET "
			." existencia = ? "
			." WHERE "
			." codproducto = ? AND codsucursal = ?;
			";
			$stmt = $this->dbh->prepare($sql);
			$stmt->bindParam(1, $existencia);
			$stmt->bindParam(2, $codproducto);
			$stmt->bindParam(3, $codsucursal);

			$existencia  = $opcionvendidobd == "2" ? number_format($existenciabd+$cantidadbd, 3, '.', '') : number_format($existenciabd+$cantidadbd, 0, '.', '');
			$codproducto = limpiar($codproductobd);
			$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
			$stmt->execute();
			############ ACTUALIZAMOS LA EXISTENCIA DE PRODUCTO EN ALMACEN #############

			########## REGISTRAMOS LOS DATOS DEL PRODUCTO ELIMINADO EN KARDEX ##########
			$query = "INSERT INTO kardex values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
			$stmt = $this->dbh->prepare($query);
			$stmt->bindParam(1, $codpreventa);
			$stmt->bindParam(2, $codresponsable);
			$stmt->bindParam(3, $codproducto);
			$stmt->bindParam(4, $movimiento);
			$stmt->bindParam(5, $entradas);
			$stmt->bindParam(6, $salidas);
			$stmt->bindParam(7, $devolucion);
			$stmt->bindParam(8, $stockactual);
			$stmt->bindParam(9, $ivaproducto);
			$stmt->bindParam(10, $descproducto);
			$stmt->bindParam(11, $precio);
			$stmt->bindParam(12, $documento);
			$stmt->bindParam(13, $fechakardex);	
			$stmt->bindParam(14, $tipokardex);	
	        $stmt->bindParam(15, $procedimiento);
			$stmt->bindParam(16, $codsucursal);
		    $stmt->bindParam(17, $codigo);

			$codpreventa    = limpiar(decrypt($_GET["codpreventa"]));
			$codresponsable = limpiar($clientebd);
			$codproducto    = limpiar($codproductobd);
			$movimiento     = limpiar("DEVOLUCION");
		    $entradas       = $opcionvendidobd == "2" ? "0.000" : "0";
		    $salidas        = $opcionvendidobd == "2" ? "0.000" : "0";
		    $devolucion     = $opcionvendidobd == "2" ? number_format($cantidadbd, 3, '.', '') : number_format($cantidadbd, 0, '.', '');
		    $stockactual    = $opcionvendidobd == "2" ? number_format($existenciabd+$cantidadbd, 3, '.', '') : number_format($existenciabd+$cantidadbd, 0, '.', '');
			$ivaproducto    = limpiar($ivaproductobd);
			$descproducto   = number_format($descproductobd, 2, '.', '');
			$precio         = number_format($precioventabd, 2, '.', '');
			$documento      = limpiar("DEVOLUCION PREVENTA: ".$codfacturabd);
			$fechakardex    = limpiar(date("Y-m-d"));
			$tipokardex     = limpiar($tipodetallebd);
	        $procedimiento  = limpiar("1");
			$codsucursal    = limpiar(decrypt($_GET["codsucursal"]));
    	    $codigo         = limpiar($_SESSION["codigo"]);
			$stmt->execute();
			########## REGISTRAMOS LOS DATOS DEL PRODUCTO ELIMINADO EN KARDEX ##########

		} elseif(limpiar($tipodetallebd) == 2){ // SI EL DETALLE ES UN COMBO

			############## VERIFICO LA EXISTENCIA DEL COMBO EN ALMACEN #################
			$sql2 = "SELECT existencia FROM combos WHERE codcombo = ? AND codsucursal = ?";
			$stmt = $this->dbh->prepare($sql2);
			$stmt->execute(array($codproductobd,decrypt($_GET["codsucursal"])));
			$num = $stmt->rowCount();

			if($row = $stmt->fetch(PDO::FETCH_ASSOC))
			{
				$p[] = $row;
			}
			$existenciacombobd = $row['existencia'];
			############## VERIFICO LA EXISTENCIA DEL COMBO EN ALMACEN #################	

			########### ACTUALIZAMOS LA EXISTENCIA DE COMBO EN ALMACEN #############
			$sql = "UPDATE combos SET "
			." existencia = ? "
			." WHERE "
			." codcombo = ? AND codsucursal = ?;
			";
			$stmt = $this->dbh->prepare($sql);
			$stmt->bindParam(1, $existencia);
			$stmt->bindParam(2, $codproducto);	
			$stmt->bindParam(3, $codsucursal);	

			$existencia  = $opcionvendidobd == "2" ? number_format($existenciacombobd+$cantidadbd, 3, '.', '') : number_format($existenciabd+$cantidadbd, 0, '.', '');
			$codproducto = limpiar($codproductobd);
			$codsucursal = limpiar(decrypt($_GET["codsucursal"]));
			$stmt->execute();
			########### ACTUALIZAMOS LA EXISTENCIA DE COMBO EN ALMACEN #############

			########## REGISTRAMOS LOS DATOS DEL PRODUCTO ELIMINADO EN KARDEX ##########
			$query = "INSERT INTO kardex values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
			$stmt = $this->dbh->prepare($query);
			$stmt->bindParam(1, $codpreventa);
			$stmt->bindParam(2, $codresponsable);
			$stmt->bindParam(3, $codproducto);
			$stmt->bindParam(4, $movimiento);
			$stmt->bindParam(5, $entradas);
			$stmt->bindParam(6, $salidas);
			$stmt->bindParam(7, $devolucion);
			$stmt->bindParam(8, $stockactual);
			$stmt->bindParam(9, $ivaproducto);
			$stmt->bindParam(10, $descproducto);
			$stmt->bindParam(11, $precio);
			$stmt->bindParam(12, $documento);
			$stmt->bindParam(13, $fechakardex);	
			$stmt->bindParam(14, $tipokardex);	
	        $stmt->bindParam(15, $procedimiento);	
			$stmt->bindParam(16, $codsucursal);
		    $stmt->bindParam(17, $codigo);

			$codpreventa    = limpiar(decrypt($_GET["codpreventa"]));
			$codresponsable = limpiar($clientebd);
			$codproducto    = limpiar($codproductobd);
			$movimiento     = limpiar("DEVOLUCION");
		    $entradas       = $opcionvendidobd == "2" ? "0.000" : "0";
		    $salidas        = $opcionvendidobd == "2" ? "0.000" : "0";
		    $devolucion     = $opcionvendidobd == "2" ? number_format($cantidadbd, 3, '.', '') : number_format($cantidadbd, 0, '.', '');
		    $stockactual    = $opcionvendidobd == "2" ? number_format($existenciacombobd+$cantidadbd, 3, '.', '') : number_format($existenciacombobd+$cantidadbd, 0, '.', '');
			$ivaproducto    = limpiar($ivaproductobd);
			$descproducto   = number_format($descproductobd, 2, '.', '');
			$precio         = limpiar($precioventabd, 2, '.', '');
			$documento      = limpiar("DEVOLUCION PREVENTA: ".$codfacturabd);
			$fechakardex    = limpiar(date("Y-m-d"));
			$tipokardex     = limpiar($tipodetallebd);
	        $procedimiento  = limpiar("2");
			$codsucursal    = limpiar(decrypt($_GET["codsucursal"]));
    	    $codigo         = limpiar($_SESSION["codigo"]);
			$stmt->execute();
			########## REGISTRAMOS LOS DATOS DEL PRODUCTO ELIMINADO EN KARDEX ##########

			############## VERIFICO SI EL COMBO TIENE PRODUCTO RELACIONADOS #################
		    $sql = "SELECT * FROM combosxproductos WHERE codcombo = ? AND codsucursal = ?";
			$stmt = $this->dbh->prepare($sql);
			$stmt->execute(array(limpiar($codproductobd),decrypt($_GET["codsucursal"])));
			$num = $stmt->rowCount();
	        if($num>0) {  

	        	$sql = "SELECT 
	        	combosxproductos.codcombo,
	    	    combosxproductos.idproducto,
	        	combosxproductos.codproducto,
	        	combosxproductos.cantidad,
	        	combosxproductos.codsucursal,
	        	productos.opcionvendido,
	        	productos.existencia,
	        	productos.precioxpublico AS precioventa,
	        	productos.ivaproducto,
	        	productos.descproducto
		    	FROM combosxproductos 
	        	LEFT JOIN productos ON combosxproductos.codproducto = productos.codproducto 
	        	WHERE combosxproductos.codcombo IN ('".limpiar($codproductobd)."') 
	        	AND combosxproductos.codsucursal = '".limpiar(decrypt($_GET['codsucursal']))."' 
		    	AND productos.codsucursal = '".limpiar(decrypt($_GET['codsucursal']))."'";
	        	foreach ($this->dbh->query($sql) as $row)
			    { 
				   $this->p[] = $row;

				    $cantracionbd2   = $row['cantidad'];
				    $idproductobd2   = $row['idproducto'];
			        $codproductobd2  = $row['codproducto'];
				    $existenciabd2   = $row['existencia'];
				    $precioventabd2  = $row['precioventa'];
				    $ivaproductobd2  = $row['ivaproducto'];
				    $descproductobd2 = $row['descproducto'];
				    $opcionvendido2  = $row['opcionvendido'];

				    ############## ACTUALIZO LOS DATOS DEL PRODUCTO #################
				    $update = "UPDATE productos set "
				    ." existencia = ? "
				    ." WHERE "
				    ." idproducto = ? AND codproducto = ? AND codsucursal = ?;
				    ";
				    $stmt = $this->dbh->prepare($update);
				    $stmt->bindParam(1, $cantidadracion);
				    $stmt->bindParam(2, $idproducto);
				    $stmt->bindParam(3, $codproducto);
		            $stmt->bindParam(4, $codsucursal);

		            $racion         = $cantracionbd2*$cantidadbd;
				    $cantidadracion = $opcionvendido2 == "2" ? number_format($existenciabd2+$racion, 3, '.', '') : number_format($existenciabd2+$racion, 0, '.', '');
		            $idproducto     = limpiar($idproductobd2);
		            $codproducto    = limpiar($codproductobd2);
		            $codsucursal    = limpiar(decrypt($_GET["codsucursal"]));
				    $stmt->execute();
				    ############## ACTUALIZO LOS DATOS DEL PRODUCTO #################

				    ########## REGISTRAMOS LOS DATOS DEL PRODUCTO ELIMINADO EN KARDEX ##########
				    $query = "INSERT INTO kardex values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
				    $stmt = $this->dbh->prepare($query);
				    $stmt->bindParam(1, $codpreventa);
				    $stmt->bindParam(2, $codresponsable);
				    $stmt->bindParam(3, $codproducto);
				    $stmt->bindParam(4, $movimiento);
				    $stmt->bindParam(5, $entradas);
				    $stmt->bindParam(6, $salidas);
				    $stmt->bindParam(7, $devolucion);
				    $stmt->bindParam(8, $stockactual);
				    $stmt->bindParam(9, $ivaproducto);
				    $stmt->bindParam(10, $descproducto);
				    $stmt->bindParam(11, $precio);
				    $stmt->bindParam(12, $documento);
				    $stmt->bindParam(13, $fechakardex);	
				    $stmt->bindParam(14, $tipokardex);	
	                $stmt->bindParam(15, $procedimiento);	
				    $stmt->bindParam(16, $codsucursal);
		            $stmt->bindParam(17, $codigo);

				    $codpreventa    = limpiar(decrypt($_GET["codpreventa"]));
				    $codresponsable = limpiar($clientebd);
			        $codproducto    = limpiar($codproductobd2);
				    $movimiento     = limpiar("DEVOLUCION");
			        $entradas       = $opcionvendido2 == "2" ? "0.000" : "0";
			        $salidas        = $opcionvendido2 == "2" ? "0.000" : "0";
			        $salidas        = $opcionvendido2 == "2" ? number_format($racion, 3, '.', '') : number_format($racion, 0, '.', '');
			        $stockactual    = $opcionvendido2 == "2" ? number_format($existenciabd2+$racion, 3, '.', '') : number_format($existenciabd2+$racion, 0, '.', '');
				    $ivaproducto    = limpiar($ivaproductobd2 == "SI" ? $ivabd : "0.00");
				    $descproducto   = number_format($descproductobd2, 2, '.', '');
				    $precio         = number_format($precioventabd2, 2, '.', '');
				    $documento      = limpiar("DEVOLUCION PREVENTA (DETALLE DE COMBO): ".$codfacturabd);
				    $fechakardex    = limpiar(date("Y-m-d"));
				    $tipokardex     = limpiar("1");
	                $procedimiento  = limpiar("2");
				    $codsucursal    = limpiar(decrypt($_GET["codsucursal"]));
    	            $codigo         = limpiar($_SESSION["codigo"]);
				    $stmt->execute();
			        ########## REGISTRAMOS LOS DATOS DEL PRODUCTO ELIMINADO EN KARDEX ##########
			    }
		    }//fin de consulta de productos en combos	
		    ############## VERIFICO SI EL COMBO TIENE PRODUCTO RELACIONADOS #################

	    } else { // SI EL DETALLE ES UN SERVICIO

	    	########## REGISTRAMOS LOS DATOS DEL SERVICIO ELIMINADO EN KARDEX ##########
			$query = "INSERT INTO kardex values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
			$stmt = $this->dbh->prepare($query);
			$stmt->bindParam(1, $codpreventa);
			$stmt->bindParam(2, $codresponsable);
			$stmt->bindParam(3, $codproducto);
			$stmt->bindParam(4, $movimiento);
			$stmt->bindParam(5, $entradas);
			$stmt->bindParam(6, $salidas);
			$stmt->bindParam(7, $devolucion);
			$stmt->bindParam(8, $stockactual);
			$stmt->bindParam(9, $ivaproducto);
			$stmt->bindParam(10, $descproducto);
			$stmt->bindParam(11, $precio);
			$stmt->bindParam(12, $documento);
			$stmt->bindParam(13, $fechakardex);	
			$stmt->bindParam(14, $tipokardex);		
	        $stmt->bindParam(15, $procedimiento);
			$stmt->bindParam(16, $codsucursal);
		    $stmt->bindParam(17, $codigo);

			$codpreventa    = limpiar(decrypt($_GET["codpreventa"]));
			$codresponsable = limpiar($clientebd);
		    $codproducto    = limpiar($codproductobd);
			$movimiento     = limpiar("DEVOLUCION");
		    $entradas       = $opcionvendidobd == "2" ? "0.000" : "0";
		    $salidas        = $opcionvendidobd == "2" ? "0.000" : "0";
		    $devolucion     = $opcionvendidobd == "2" ? number_format($cantidadbd, 3, '.', '') : number_format($cantidadbd, 0, '.', '');
		    $stockactual    = $opcionvendidobd == "2" ? "0.000" : "0";
			$ivaproducto    = limpiar($ivaproductobd);
			$descproducto   = number_format($descproductobd, 2, '.', '');
			$precio         = number_format($precioventabd, 2, '.', '');
			$documento      = limpiar("DEVOLUCION PREVENTA: ".$codfacturabd);
			$fechakardex    = limpiar(date("Y-m-d"));
			$tipokardex     = limpiar($tipodetallebd);
	        $procedimiento  = limpiar("3");
			$codsucursal    = limpiar(decrypt($_GET["codsucursal"]));
    	    $codigo         = limpiar($_SESSION["codigo"]);
			$stmt->execute();
			########## REGISTRAMOS LOS DATOS DEL SERVICIO ELIMINADO EN KARDEX ##########
	    }
	}

		################## ELIMINO PREVENTA ##################
	    $sql = "DELETE FROM preventas WHERE codpreventa = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codpreventa);
		$stmt->bindParam(2,$codsucursal);
		$codpreventa = decrypt($_GET["codpreventa"]);
		$codsucursal = decrypt($_GET["codsucursal"]);
		$stmt->execute();
		################## ELIMINO PREVENTA ##################

		################## ELIMINO DETALLE DE PREVENTA ##################
		$sql = "DELETE FROM detallepreventas WHERE codpreventa = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1,$codpreventa);
		$stmt->bindParam(2,$codsucursal);
		$codpreventa = decrypt($_GET["codpreventa"]);
		$codsucursal = decrypt($_GET["codsucursal"]);
		$stmt->execute();
		################## ELIMINO DETALLE DE PREVENTA ##################

		echo "1";
		exit;

	} else {

		echo "2";
		exit;
	}
}
###################### FUNCION ELIMINAR PREVENTAS #################################

####################### FUNCION PROCESAR PREVENTAS A VENTA #################################
public function ProcesarPreventas()
{
	$this->p = [];
	####################### VERIFICO ARQUEO DE CAJA #######################
	$sql = "SELECT * FROM arqueocaja 
	INNER JOIN cajas ON arqueocaja.codcaja = cajas.codcaja 
	INNER JOIN usuarios ON cajas.codigo = usuarios.codigo 
	WHERE usuarios.codigo = ? AND arqueocaja.statusarqueo = 1";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array($_SESSION["codigo"]));
	$num = $stmt->rowCount();
	if($num==0)
	{
		echo "1";
		exit;

	} else {
		
		if($row = $stmt->fetch(PDO::FETCH_ASSOC))
		{
			$this->p[] = $row;
		}
		$codarqueo = $row['codarqueo'];
		$codcaja = $row['codcaja'];
		$ingreso = ($row['ingresos']== "" ? "0.00" : $row['ingresos']);
		$credito = ($row['creditos']== "" ? "0.00" : $row['creditos']);
		$abono = ($row['abonos']== "" ? "0.00" : $row['abonos']);
	}
    ####################### VERIFICO ARQUEO DE CAJA #######################

   if(empty($_POST["codsucursal"]) or empty($_POST["tipodocumento"]) or empty($_POST["tipopago"]))
	{
		echo "2";
		exit;
	}
	elseif(limpiar($_POST["txtTotal"]=="") && limpiar($_POST["txtTotal"]==0) && limpiar($_POST["txtTotal"]==0.00))
	{
		echo "3";
		exit;
	}

	################### SELECCIONE LOS DATOS DEL CLIENTE ######################
    $sql = "SELECT
    clientes.codcliente,
	clientes.tipocliente,
	clientes.documcliente,
	clientes.dnicliente,
	CONCAT(if(clientes.tipocliente='JURIDICO',clientes.razoncliente,clientes.nomcliente)) as nomcliente,
	clientes.girocliente,
	clientes.tlfcliente,
	clientes.id_ciudad,
	clientes.id_comuna,
	clientes.direccliente,
	clientes.emailcliente,
	clientes.limitecredito,
	ciudades.codciudad,
	ciudades.ciudad,
	comunas.codcomuna,
	comunas.comuna,
    IFNULL(pag.montocredito,'0.00') AS montoactual,
    IFNULL(clientes.limitecredito-pag.montocredito,clientes.limitecredito) AS creditodisponible
    FROM clientes
    LEFT JOIN ciudades ON clientes.id_ciudad = ciudades.id_ciudad 
    LEFT JOIN comunas ON clientes.id_comuna = comunas.id_comuna 
    LEFT JOIN
       (SELECT
       codcliente, montocredito       
       FROM creditosxclientes 
       WHERE codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."') pag ON pag.codcliente = clientes.codcliente
       WHERE clientes.dnicliente = ? 
       AND clientes.codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(limpiar($_POST['nrodocumento']),limpiar(decrypt($_POST['codsucursal']))));
	$num = $stmt->rowCount();
	if($row = $stmt->fetch(PDO::FETCH_ASSOC))
	{
		$p[] = $row;
	}
    $codcliente        = (empty($row['codcliente']) ? "0" : $row['codcliente']);
    $tipocliente       = (empty($row['tipocliente']) ? "0" : $row['tipocliente']);
    $dnicliente        = (empty($row['dnicliente']) ? "0" : $row['dnicliente']);
    $nomcliente        = (empty($row['nomcliente']) ? "0" : $row['nomcliente']);
    $girocliente       = (empty($row['girocliente']) ? "0" : $row['girocliente']);
    $emailcliente      = (empty($row['emailcliente']) ? "0" : $row['emailcliente']);
    $ciudad            = (empty($row['id_ciudad']) ? "0" : $row['ciudad']);
    $comuna            = (empty($row['id_comuna']) ? "0" : $row['comuna']);
    $direccliente      = (empty($row['direccliente']) ? "0" : $row['direccliente']);
    $limitecredito     = (empty($row['limitecredito']) ? "0.00" : $row['limitecredito']);
    $montoactual       = (empty($row['montoactual']) ? "0.00" : $row['montoactual']);
    $creditodisponible = (empty($row['creditodisponible']) ? "0.00" : $row['creditodisponible']);
    $medioabono        = (empty($_POST["formaabono"]) ? "" : $_POST["formaabono"]);
    $montoabono        = (empty($_POST["montoabono"]) ? "0.00" : $_POST["montoabono"]);
    $total             = number_format($_POST["txtTotal"]-$montoabono, 2, '.', '');
    ################### SELECCIONE LOS DATOS DEL CLIENTE ######################

   ################### VALIDO TIPO DE PAGO ES A CREDITO ######################
   if (limpiar($_POST["tipopago"]) == "CREDITO") {

    	$fechaactual = date("Y-m-d");
		$fechavence = date("Y-m-d",strtotime($_POST['fechavencecredito']));

		if ($codcliente == '0') { 

            echo "4";
            exit;

        } else if (strtotime($fechavence) < strtotime($fechaactual)) {

			echo "5";
			exit;

		} else if ($montoabono != "0.00" && $medioabono == "") {
  
            echo "6";
	        exit;

		} else if ($limitecredito != "0.00" && $total > $creditodisponible) {

            echo "7";
            exit;

        } else if($_POST["montoabono"] >= $_POST["txtTotal"]) { 

	        echo "8";
	        exit;
        }
   }
   ################### VALIDO TIPO DE PAGO ES A CREDITO ######################

   ################### VALIDO TIPO DE PAGO ES A CONTADO ######################
   if (limpiar($_POST["tipopago"]) == "CONTADO") {

   	foreach ($_POST['pagos'] as $value)
   	{
		if($value['montopagado'] == "" || $value['montopagado'] == 0.00)	
	    {
		    echo "9";
		    exit;
		}
	}

	    if (isset($_POST['pagos']) && is_array($_POST['pagos'])) {

	    	$formas_pago = array_column($_POST['pagos'], 'codmediopago');
	        if(count($formas_pago) != count(array_unique($formas_pago)))
	   	    {
	   		    echo "10";
				exit;
	        } 
	        else if (count($formas_pago) > 1 && $_POST["txtPagado"] > $_POST["txtTotal"])
	        {
	            echo "11";
	            exit;
	        }

        } else {

	      	if ($_POST["txtTotal"] > $_POST["txtPagado"])
	        {
	            echo "12";
	            exit;
	        }
        } 
	}
    ################### VALIDO TIPO DE PAGO ES A CONTADO ######################

	################# OBTENGO DATOS DE SUCURSAL #################
	$sql = " SELECT 
	cuitsucursal, 
	nroactividadsucursal,  
	inicioboleta,
	iniciofactura, 
	inicioguia, 
	inicionotaventa,
	lioren_token  
	FROM sucursales WHERE codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$cuitsucursal    = $row['cuitsucursal'];
	$nroactividad    = $row['nroactividadsucursal'];
	$inicioboleta    = $row['inicioboleta'];
	$iniciofactura   = $row['iniciofactura'];
	$inicioguia      = $row['inicioguia'];
	$inicionotaventa = $row['inicionotaventa'];
	$lioren_token    = $row['lioren_token'];
	################# OBTENGO DATOS DE SUCURSAL #################

	################ CREO CODIGO DE VENTA ####################
	$sql = "SELECT codventa FROM ventas 
	ORDER BY idventa DESC LIMIT 1";
	foreach ($this->dbh->query($sql) as $row){

		$venta=$row["codventa"];
	}
	if(empty($venta))
	{
		$codventa = "01";

	} else {

		$num         = substr($venta, 0);
        $dig         = $num + 1;
        $codigofinal = str_pad($dig, 2, "0", STR_PAD_LEFT);
        $codventa    = $codigofinal;
	}
    ################ CREO CODIGO DE VENTA ###############

    ################### CREO CODIGO DE FACTURA ####################
	$tipo_documento = ($_POST['tipodocumento'] == "FACTURA_A4" ? "FACTURA" : $_POST['tipodocumento']);
	$sql = "SELECT codfactura
	FROM ventas 
	WHERE tipo = '".limpiar($tipo_documento)."'
	AND codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."' 
	ORDER BY idventa DESC LIMIT 1";
	foreach ($this->dbh->query($sql) as $row){

		$factura=$row["codfactura"];
	}
	
	if($tipo_documento == "BOLETA") {

        if(empty($factura)){ 
        	$codfactura = $inicioboleta;
        } else {
            $var = strlen("");
            $var1 = substr($factura , $var);
            $var2 = strlen($var1);
            $var3 = $var1 + 1;
            $var4 = str_pad($var3, $var2, "0", STR_PAD_LEFT);
            $codfactura = $var4;
        }
		    $codserie = limpiar($nroactividad);
		    $codautorizacion = limpiar(GenerateRandomStringg());

	} elseif($tipo_documento == "FACTURA") {

        if(empty($factura)){ 
        	$codfactura = $iniciofactura;
        } else {
            $var = strlen("");
            $var1 = substr($factura , $var);
            $var2 = strlen($var1);
            $var3 = $var1 + 1;
            $var4 = str_pad($var3, $var2, "0", STR_PAD_LEFT);
            $codfactura = $var4;
        }
		    $codserie = limpiar($nroactividad);
		    $codautorizacion = limpiar(GenerateRandomStringg());
	}
     ################### CREO CODIGO DE FACTURA ####################

	################### SELECCIONE LOS DATOS DE LA preventa ######################
    $sql = "SELECT * FROM preventas WHERE codpreventa = ? AND codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(decrypt($_POST['codpreventa']),decrypt($_POST['codsucursal'])));
	$num = $stmt->rowCount();
	if($row = $stmt->fetch(PDO::FETCH_ASSOC))
	{
		$p[] = $row;
	}
    ################### SELECCIONE LOS DATOS DE LA preventa ######################

    $fecha = date("Y-m-d H:i:s");

    ################### REGISTRO LA VENTA ####################
    $query = "INSERT INTO ventas values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $tipodocumento);
	$stmt->bindParam(2, $codarqueo);
	$stmt->bindParam(3, $codcaja);
	$stmt->bindParam(4, $codventa);
	$stmt->bindParam(5, $codfactura);
	$stmt->bindParam(6, $codserie);
	$stmt->bindParam(7, $codautorizacion);
	$stmt->bindParam(8, $codcliente);
	$stmt->bindParam(9, $subtotalivasi);
	$stmt->bindParam(10, $subtotalivano);
	$stmt->bindParam(11, $iva);
	$stmt->bindParam(12, $totaliva);
	$stmt->bindParam(13, $descontado);
	$stmt->bindParam(14, $descuento);
	$stmt->bindParam(15, $totaldescuento);
	$stmt->bindParam(16, $montodescuento);
	$stmt->bindParam(17, $totalpago);
	$stmt->bindParam(18, $totalpago2);
	$stmt->bindParam(19, $creditopagado);
	$stmt->bindParam(20, $tipopago);
	$stmt->bindParam(21, $formapago);
	$stmt->bindParam(22, $montopagado);
	$stmt->bindParam(23, $montodevuelto);
	$stmt->bindParam(24, $fechavencecredito);
	$stmt->bindParam(25, $fechapagado);
	$stmt->bindParam(26, $statusventa);
	$stmt->bindParam(27, $fechaventa);
	$stmt->bindParam(28, $observaciones);
	$stmt->bindParam(29, $notacredito);
	$stmt->bindParam(30, $bpsii);
	$stmt->bindParam(31, $tipo);
	$stmt->bindParam(32, $codigo);
	$stmt->bindParam(33, $codsucursal);
   
	$tipodocumento  = limpiar($_POST["tipodocumento"]);
	$subtotalivasi  = limpiar($row["subtotalivasi"]);
	$subtotalivano  = limpiar($row["subtotalivano"]);
	$iva            = limpiar($row["iva"]);
	$totaliva       = limpiar($row["totaliva"]);
	$descontado     = limpiar($row["descontado"]);
	$descuento      = limpiar($row["descuento"]);
	$totaldescuento = limpiar($row["totaldescuento"]);
	$montodescuento = limpiar("0.00");
	$totalpago      = limpiar($row["totalpago"]);
	$totalpago2     = limpiar($row["totalpago2"]);
	$creditopagado  = limpiar(isset($_POST['montoabono']) ? $_POST["montoabono"] : "0.00");
	$tipopago       = limpiar($_POST["tipopago"]);

	$montopagado    = '0.00';
    if ($_POST['tipopago'] == 'CONTADO') {
        
        if (isset($_POST['pagos']) && is_array($_POST['pagos'])) {
	        $formapago   = 'VARIOS';
	        $montopagado = array_reduce($_POST['pagos'], function ($a, $o) {
	            return $a + $o['montopagado'];
	        });
        }
        else 
        {
            $formapago   = decrypt($_POST['codmediopago']);
            $montopagado = limpiar($_POST['montopagado']);
        }
    }
    else 
    {
        $formapago = 'CREDITO';
    }
    $montodevuelto = limpiar(isset($_POST['montodevuelto']) ? $_POST["montodevuelto"] : "0.00");

	$fechavencecredito = limpiar($_POST["tipopago"]=="CREDITO" ? date("Y-m-d",strtotime($_POST['fechavencecredito'])) : "0000-00-00");
    $fechapagado       = limpiar("0000-00-00");
    $statusventa       = limpiar($_POST["tipopago"]=="CONTADO" ? "PAGADA" : "PENDIENTE");
    $fechaventa        = limpiar($fecha);
	$observaciones     = limpiar($_POST["observaciones"]);
	$notacredito       = limpiar("0");
	$bpsii             = limpiar($_POST["bpsii"]);
	$tipo              = ($_POST['tipodocumento'] == "FACTURA_A4" ? "FACTURA" : $_POST['tipodocumento']);
	$codigo            = limpiar($row["codigo"]);
	$codsucursal       = limpiar(decrypt($_POST["codsucursal"]));
	$stmt->execute();
	################### REGISTRO LA VENTA ####################

	################################ REGISTRO DE FORMAS DE PAGOS EN VENTA ################################
	if(limpiar($_POST["tipopago"])=="CONTADO"){

	    $sql = "INSERT INTO mediospagoxventas VALUES (NULL, ?, ?, ?, ?, ?, ?)";
	    foreach ($_POST['pagos'] as $pago) {
	       $stmt = $this->dbh->prepare($sql);
	       $stmt->execute([$codarqueo, $codcaja, $codventa, decrypt($pago['codmediopago']), $pago['montopagado'], $_POST['montodevuelto']]);
	    }
	}
	################################ REGISTRO DE FORMAS DE PAGOS EN VENTA ################################

	################### SELECCIONO DETALLES DE PREVENTA ######################
	$sql = "SELECT * FROM detallepreventas 
	WHERE codpreventa = '".decrypt($_POST['codpreventa'])."' 
	AND codsucursal = '".decrypt($_POST['codsucursal'])."'";
    foreach ($this->dbh->query($sql) as $row2)
	{
	    ################### REGISTRO DETALLES DE VENTA ####################
        $query = "INSERT INTO detalleventas values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
    	$stmt = $this->dbh->prepare($query);
    	$stmt->bindParam(1, $codventa);
    	$stmt->bindParam(2, $idproducto);
    	$stmt->bindParam(3, $codproducto);
    	$stmt->bindParam(4, $producto);
	    $stmt->bindParam(5, $descripcion);
	    $stmt->bindParam(6, $opcionvendido);
	    $stmt->bindParam(7, $imei);
	    $stmt->bindParam(8, $condicion);
    	$stmt->bindParam(9, $codmarca);
    	$stmt->bindParam(10, $codmodelo);
    	$stmt->bindParam(11, $codpresentacion);
	    $stmt->bindParam(12, $codcolor);
    	$stmt->bindParam(13, $cantidad);
    	$stmt->bindParam(14, $preciocompra);
    	$stmt->bindParam(15, $precioventa);
    	$stmt->bindParam(16, $ivaproducto);
    	$stmt->bindParam(17, $descproducto);
    	$stmt->bindParam(18, $valortotal);
    	$stmt->bindParam(19, $totaldescuentov);
	    $stmt->bindParam(20, $subtotalimpuestos);
    	$stmt->bindParam(21, $valorneto);
    	$stmt->bindParam(22, $valorneto2);
    	$stmt->bindParam(23, $tipodetalle);
    	$stmt->bindParam(24, $codsucursal);

	    $idproducto        = limpiar($row2['idproducto']);
    	$codproducto       = strip_tags($row2['codproducto']);
    	$producto          = strip_tags($row2['producto']);
		$descripcion       = limpiar($row2['descripcion']);
		$opcionvendido     = limpiar($row2['opcionvendido']);
		$imei              = limpiar($row2['imei']);
		$condicion         = limpiar($row2['condicion']);
    	$codmarca          = strip_tags($row2['codmarca']);
    	$codmodelo         = strip_tags($row2['codmodelo']);
    	$codpresentacion   = strip_tags($row2['codpresentacion']);
    	$codcolor          = strip_tags($row2['codcolor']);
    	$cantidad          = limpiar($row2['cantpreventa']);
    	$preciocompra      = limpiar($row2['preciocompra']);
    	$precioventa       = limpiar($row2['precioventa']);
    	$ivaproducto       = limpiar($row2['ivaproducto']);
    	$descproducto      = limpiar($row2['descproducto']);
    	$descuento         = $row2['descproducto']/100;
    	$valortotal        = number_format($row2['valortotal'], 2, '.', '');
    	$totaldescuentov   = number_format($row2['totaldescuentov'], 2, '.', '');
    	$subtotalimpuestos = number_format($row2['subtotalimpuestos'], 2, '.', '');
    	$valorneto         = number_format($row2['valorneto'], 2, '.', '');
    	$valorneto2        = number_format($row2['valorneto2'], 2, '.', '');
    	$tipodetalle       = limpiar($row2['tipodetalle']);
    	$codsucursal       = limpiar(decrypt($_POST["codsucursal"]));
    	$stmt->execute();
    	################### REGISTRO DETALLES DE VENTA ####################
	}

	##################### ACTUALIZO PREVENTA A PROCESADO ####################
	$sql = "UPDATE preventas set "
	." procesada = ? "
	." WHERE "
	." codpreventa = '".limpiar(decrypt($_POST["codpreventa"]))."' 
	AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."';
	";
	$stmt = $this->dbh->prepare($sql);
	$stmt->bindParam(1, $procesada);

	$procesada = limpiar("0");
	$stmt->execute();
    ##################### ACTUALIZO PREVENTA A PROCESADO ####################

	################ AGREGAMOS EL INGRESO A CONTADO ##############
    if (limpiar($_POST["tipopago"]=="CONTADO")){

		$sql = "UPDATE arqueocaja set "
		." ingresos = ? "
		." WHERE "
		." codarqueo = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $txtTotal);
		$stmt->bindParam(2, $codarqueo);

		$txtTotal = number_format($_POST["txtTotal"]+$ingreso, 2, '.', '');
		$stmt->execute();
    }
    ################ AGREGAMOS EL INGRESO A CONTADO ##############

    ################ AGREGAMOS EL INGRESO Y ABONOS A CREDITO ################
    if (limpiar($_POST["tipopago"]=="CREDITO")) {

		$sql = " UPDATE arqueocaja SET "
		." creditos = ?, "
		." abonos = ? "
		." WHERE "
		." codarqueo = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $txtTotal);
		$stmt->bindParam(2, $totalabono);
		$stmt->bindParam(3, $codarqueo);

		$TotalCredito = number_format($_POST["txtTotal"]-$_POST["montoabono"], 2, '.', '');
		$txtTotal     = number_format($TotalCredito+$credito, 2, '.', '');
		$totalabono   = number_format($_POST["montoabono"]+$abono, 2, '.', '');
		$stmt->execute(); 

		$sql = " SELECT codcliente FROM creditosxclientes WHERE codcliente = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array($codcliente,decrypt($_POST["codsucursal"])));
		$num = $stmt->rowCount();
		if($num == 0)
		{
			$query = "INSERT INTO creditosxclientes values (null, ?, ?, ?);";
			$stmt = $this->dbh->prepare($query);
			$stmt->bindParam(1, $codcliente);
			$stmt->bindParam(2, $montocredito);
			$stmt->bindParam(3, $codsucursal);

			$montocredito = number_format($_POST["txtTotal"]-$_POST["montoabono"], 2, '.', '');
			$codsucursal  = limpiar(decrypt($_POST["codsucursal"]));
			$stmt->execute();

		} else { 

			$sql = "UPDATE creditosxclientes set"
			." montocredito = ? "
			." WHERE "
			." codcliente = ? AND codsucursal = ?;
			";
			$stmt = $this->dbh->prepare($sql);
			$stmt->bindParam(1, $montocredito);
			$stmt->bindParam(2, $codcliente);
			$stmt->bindParam(3, $codsucursal);

			$montocredito = number_format($montoactual+($_POST["txtTotal"]-$_POST["montoabono"]), 2, '.', '');
			$codsucursal  = limpiar(decrypt($_POST["codsucursal"]));
			$stmt->execute();
		}

		if (limpiar($_POST["montoabono"]!="0.00" && $_POST["montoabono"]!="0" && $_POST["montoabono"]!="")) {
			
			$query = "INSERT INTO abonoscreditosventas values (null, ?, ?, ?, ?, ?, ?, ?, ?); ";
			$stmt = $this->dbh->prepare($query);
			$stmt->bindParam(1, $codarqueo);
			$stmt->bindParam(2, $codcaja);
			$stmt->bindParam(3, $codventa);
			$stmt->bindParam(4, $codcliente);
			$stmt->bindParam(5, $montoabono);
			$stmt->bindParam(6, $formaabono);
			$stmt->bindParam(7, $fechaabono);
			$stmt->bindParam(8, $codsucursal);

			$montoabono  = number_format($_POST["montoabono"], 2, '.', '');
			$formaabono  = decrypt($_POST["formaabono"]);
			$fechaabono  = limpiar($fecha);
			$codsucursal = limpiar(decrypt($_POST["codsucursal"]));
			$stmt->execute();
		}
	}
	################ AGREGAMOS EL INGRESO Y ABONOS A CREDITO ################

    if($lioren_token != "" && $_POST["bpsii"] == 1){//verifico si existe token de lioren

    $lioren = new Lioren();
    $lioren->enviarVenta($codventa);

    $encCodVenta    = encrypt($codventa);
	$encCodSucursal = encrypt($codsucursal);
	//$encTipo      = ($tipodocumento == "FACTURA_A4" ? encrypt("FACTURA") : encrypt($tipodocumento));
	$encTipo        = encrypt($tipodocumento);
	$url            = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' ? 'https://' : 'http://').$_SERVER['HTTP_HOST']."/".$this->carpeta."/reportepdf?codventa=$encCodVenta&codsucursal=$encCodSucursal&tipo=$encTipo";

        echo "<span class='fa fa-check-square-o'></span> LA PREVENTA HA SIDO PROCESADA COMO VENTA EXITOSAMENTE <a href='$url' class='on-default' data-placement='left' data-toggle='tooltip' data-original-title='Imprimir Documento' target='_black' rel='noopener noreferrer'><font color='black'><strong>IMPRIMIR REPORTE</strong></font color></a></div>";

        echo "<script>VentanaCentrada('reportepdf?codventa=".encrypt($codventa)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt($tipodocumento)."', '', '', '1024', '568', 'true');</script>";
	    exit;

   } else {

   	    echo "<span class='fa fa-check-square-o'></span> LA PREVENTA HA SIDO PROCESADA COMO VENTA EXITOSAMENTE <a href='reportepdf?codventa=".encrypt($codventa)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt($tipodocumento)."' class='on-default' data-placement='left' data-toggle='tooltip' data-original-title='Imprimir Documento' target='_black' rel='noopener noreferrer'><font color='black'><strong>IMPRIMIR REPORTE</strong></font color></a></div>";

        echo "<script>VentanaCentrada('reportepdf?codventa=".encrypt($codventa)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt($tipodocumento)."', '', '', '1024', '568', 'true');</script>";
	    exit;
	}
}
###################### FUNCION PROCESAR PREVENTAS A VENTAS #################################

###################### FUNCION BUSQUEDA PREVENTAS POR FECHAS ####################
public function BuscarPreventasxFechas() 
{
	$this->p = [];
	$codSucursal      = isset($_GET["codsucursal"]) ? limpiar(decrypt($_GET['codsucursal'])) : '';
	$fechaDesde       = isset($_GET['desde']) ? limpiar(date("Y-m-d", strtotime($_GET['desde']))) : '';
    $fechaHasta       = isset($_GET['hasta']) ? limpiar(date("Y-m-d", strtotime($_GET['hasta']))) : '';
	$whereConditions  = [];
    $params           = [];

	$sqlBase = "SELECT
        pre.idpreventa, pre.codpreventa, pre.codfactura, pre.codcliente, pre.subtotalivasi, pre.subtotalivano, 
        pre.iva, pre.totaliva, pre.descontado, pre.descuento, pre.totaldescuento, pre.totalpago, pre.totalpago2,
		pre.observaciones, pre.fechapreventa, pre.procesada, pre.codigo, pre.codsucursal,
		suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
		suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
		tm.moneda, tm.siglas, tm.simbolo,
		usu.dni, usu.nombres,
		cl.tipocliente, cl.documcliente, cl.dnicliente,
		CONCAT(if(cl.tipocliente='NATURAL',cl.nomcliente,cl.razoncliente)) as nomcliente,
		cl.girocliente, cl.tlfcliente, cl.id_ciudad AS id_ciudad2, cl.id_comuna AS id_comuna2, 
		cl.direccliente, cl.emailcliente, cl.limitecredito,
		doc.documento, doc2.documento AS documento2, doc3.documento AS documento3,
		pag.articulos, pag.detalles_productos
    FROM 
        preventas pre LEFT JOIN sucursales suc ON pre.codsucursal = suc.codsucursal
	LEFT JOIN 
	    documentos doc ON suc.documsucursal = doc.coddocumento
	LEFT JOIN 
	    documentos AS doc2 ON suc.documencargado = doc2.coddocumento
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
	LEFT JOIN 
	    clientes cl ON pre.codcliente = cl.codcliente
	LEFT JOIN 
	    documentos AS doc3 ON cl.documcliente = doc3.coddocumento 
	LEFT JOIN 
	    usuarios usu ON pre.codigo = usu.codigo
    LEFT JOIN
        (SELECT
            dpre.codpreventa,
            SUM(dpre.cantpreventa) AS articulos,
            GROUP_CONCAT(
            CONCAT_WS(
               ' | ',
               dpre.cantpreventa,
               dpre.producto,
               dpre.descripcion,
               IFNULL(mar.nommarca, ''),
               IFNULL(mode.nommodelo, ''),
               IFNULL(pres.nompresentacion, ''),
               IFNULL(col.nomcolor, '')
            )
                ORDER BY dpre.producto
                SEPARATOR '<br>'
            ) AS detalles_productos
            FROM
                detallepreventas dpre
            LEFT JOIN 
                marcas mar ON dpre.codmarca = mar.codmarca
		    LEFT JOIN 
		        modelos mode ON dpre.codmodelo = mode.codmodelo 
		    LEFT JOIN 
		        presentaciones pres ON dpre.codpresentacion = pres.codpresentacion
			LEFT JOIN 
			    colores col ON dpre.codcolor = col.codcolor
			WHERE dpre.codsucursal = ?
	    GROUP BY
	        dpre.codpreventa
	    ) pag ON pag.codpreventa = pre.codpreventa";
    //Condicion de Sucursal
    if (!empty($codSucursal)) {
        $whereConditions[] = "pre.codsucursal = ?";
        $params[]          = $codSucursal;
    }
	//Condicion de Fechas
	if (!empty($fechaDesde) && !empty($fechaHasta)) {
	    $whereConditions[] = "DATE_FORMAT(pre.fechapreventa,'%Y-%m-%d') BETWEEN ? AND ?";
	    $params[]          = $fechaDesde;
	    $params[]          = $fechaHasta;
	}
	$whereClause = "";
	if (!empty($whereConditions)) {
	    $whereClause = " WHERE " . implode(" AND ", $whereConditions);
	}
	$sql = $sqlBase . $whereClause . " ORDER BY pre.codpreventa ASC";
	try {
	    $stmt = $this->dbh->prepare($sql);
        array_unshift($params, $codSucursal);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
	    if (empty($results)) {
	        echo "<div class='alert alert-danger'>";
	        echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	        echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS PARA TU BÚSQUEDA REALIZADA</center>";
	        echo "</div>";
	        exit();
	    } else {
	        return $results;
	    }
	} catch (PDOException $e) {
	    error_log("Error en BuscarPreventasxFechas: " . $e->getMessage());
	    echo "<div class='alert alert-danger'>";
	    echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	    echo "<center><span class='fa fa-exclamation-triangle'></span> OCURRIÓ UN ERROR AL CONSULTAR LAS PREVENTAS.</center>";
	    echo "</div>";
	    return [];
	}
}
################### FUNCION BUSQUEDA PREVENTAS POR FECHAS ###################

###################### FUNCION BUSQUEDA PREVENTAS POR VENDEDOR ####################
public function BuscarPreventasxVendedor() 
{
	$this->p = [];
	$codSucursal      = isset($_GET["codsucursal"]) ? limpiar(decrypt($_GET['codsucursal'])) : '';
	$codUsuarioBusqueda = isset($_GET['codigo']) ? limpiar(trim($_GET['codigo'])) : null;
	$fechaDesde       = isset($_GET['desde']) ? limpiar(date("Y-m-d", strtotime($_GET['desde']))) : '';
    $fechaHasta       = isset($_GET['hasta']) ? limpiar(date("Y-m-d", strtotime($_GET['hasta']))) : '';
	$whereConditions  = [];
    $params           = [];

	$sqlBase = "SELECT
        pre.idpreventa, pre.codpreventa, pre.codfactura, pre.codcliente, pre.subtotalivasi, pre.subtotalivano, 
        pre.iva, pre.totaliva, pre.descontado, pre.descuento, pre.totaldescuento, pre.totalpago, pre.totalpago2,
		pre.observaciones, pre.fechapreventa, pre.procesada, pre.codigo, pre.codsucursal,
		suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
		suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
		tm.moneda, tm.siglas, tm.simbolo,
		usu.dni, usu.nombres,
		cl.tipocliente, cl.documcliente, cl.dnicliente,
		CONCAT(if(cl.tipocliente='NATURAL',cl.nomcliente,cl.razoncliente)) as nomcliente,
		cl.girocliente, cl.tlfcliente, cl.id_ciudad AS id_ciudad2, cl.id_comuna AS id_comuna2, 
		cl.direccliente, cl.emailcliente, cl.limitecredito,
		doc.documento, doc2.documento AS documento2, doc3.documento AS documento3,
		pag.articulos, pag.detalles_productos
    FROM 
        preventas pre LEFT JOIN sucursales suc ON pre.codsucursal = suc.codsucursal
	LEFT JOIN 
	    documentos doc ON suc.documsucursal = doc.coddocumento
	LEFT JOIN 
	    documentos AS doc2 ON suc.documencargado = doc2.coddocumento
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
	LEFT JOIN 
	    clientes cl ON pre.codcliente = cl.codcliente
	LEFT JOIN 
	    documentos AS doc3 ON cl.documcliente = doc3.coddocumento 
	LEFT JOIN 
	    usuarios usu ON pre.codigo = usu.codigo
    LEFT JOIN
        (SELECT
            dpre.codpreventa,
            SUM(dpre.cantpreventa) AS articulos,
            GROUP_CONCAT(
            CONCAT_WS(
               ' | ',
               dpre.cantpreventa,
               dpre.producto,
               dpre.descripcion,
               IFNULL(mar.nommarca, ''),
               IFNULL(mode.nommodelo, ''),
               IFNULL(pres.nompresentacion, ''),
               IFNULL(col.nomcolor, '')
            )
                ORDER BY dpre.producto
                SEPARATOR '<br>'
            ) AS detalles_productos
            FROM
                detallepreventas dpre
            LEFT JOIN 
                marcas mar ON dpre.codmarca = mar.codmarca
		    LEFT JOIN 
		        modelos mode ON dpre.codmodelo = mode.codmodelo 
		    LEFT JOIN 
		        presentaciones pres ON dpre.codpresentacion = pres.codpresentacion
			LEFT JOIN 
			    colores col ON dpre.codcolor = col.codcolor
			WHERE dpre.codsucursal = ?
	    GROUP BY
	        dpre.codpreventa
	    ) pag ON pag.codpreventa = pre.codpreventa";
    //Condicion de Sucursal
    if (!empty($codSucursal)) {
        $whereConditions[] = "pre.codsucursal = ?";
        $params[]          = $codSucursal;
    }
    //Condicion de Usuario
    if (!empty($codUsuarioBusqueda)) {
        $whereConditions[] = "pre.codigo = ?";
        $params[]          = $codUsuarioBusqueda;
    }
	//Condicion de Fechas
	if (!empty($fechaDesde) && !empty($fechaHasta)) {
	    $whereConditions[] = "DATE_FORMAT(pre.fechapreventa,'%Y-%m-%d') BETWEEN ? AND ?";
	    $params[]          = $fechaDesde;
	    $params[]          = $fechaHasta;
	}
	$whereClause = "";
	if (!empty($whereConditions)) {
	    $whereClause = " WHERE " . implode(" AND ", $whereConditions);
	}
	$sql = $sqlBase . $whereClause . " ORDER BY pre.codpreventa ASC";
	try {
	    $stmt = $this->dbh->prepare($sql);
        array_unshift($params, $codSucursal);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
	    if (empty($results)) {
	        echo "<div class='alert alert-danger'>";
	        echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	        echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS PARA TU BÚSQUEDA REALIZADA</center>";
	        echo "</div>";
	        exit();
	    } else {
	        return $results;
	    }
	} catch (PDOException $e) {
	    error_log("Error en BuscarPreventasxVendedor: " . $e->getMessage());
	    echo "<div class='alert alert-danger'>";
	    echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
	    echo "<center><span class='fa fa-exclamation-triangle'></span> OCURRIÓ UN ERROR AL CONSULTAR LAS PREVENTAS.</center>";
	    echo "</div>";
	    return [];
	}
}
################### FUNCION BUSQUEDA PREVENTAS POR VENDEDOR ###################

###################### FUNCION BUSCAR DETALLES PREVENTAS POR FECHAS #########################
public function BuscarDetallesPreventasxFechas() 
{
    $this->p = [];
	$codSucursal         = isset($_GET["codsucursal"]) ? limpiar(decrypt($_GET['codsucursal'])) : '';
	$fechaDesde          = isset($_GET['desde']) ? limpiar(date("Y-m-d", strtotime($_GET['desde']))) : '';
    $fechaHasta          = isset($_GET['hasta']) ? limpiar(date("Y-m-d", strtotime($_GET['hasta']))) : '';
	$whereConditions     = [];
    $params              = [];

    $sqlBase = "SELECT
        dpre.idproducto, dpre.codproducto, dpre.producto, dpre.descripcion, dpre.opcionvendido,
		dpre.imei, dpre.condicion, dpre.codmarca, dpre.codmodelo, dpre.codpresentacion,
		dpre.codcolor, dpre.precioventa, dpre.ivaproducto, dpre.descproducto, dpre.tipodetalle,
	    suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
		suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
		doc.documento, doc2.documento AS documento2, tm.moneda, tm.siglas, tm.simbolo,
	    mar.nommarca, mode.nommodelo, pres.nompresentacion, col.nomcolor,
        SUM(dpre.cantpreventa) AS cantidad,
        prod.existencia AS existencia,
        com.existencia AS cantcombo
    FROM
        preventas pre
    INNER JOIN
        detallepreventas dpre ON pre.codpreventa = dpre.codpreventa
    LEFT JOIN 
	    sucursales suc ON pre.codsucursal = suc.codsucursal 
	LEFT JOIN 
	    documentos doc ON suc.documsucursal = doc.coddocumento
	LEFT JOIN 
	    documentos AS doc2 ON suc.documencargado = doc2.coddocumento
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
    LEFT JOIN 
        marcas mar ON dpre.codmarca = mar.codmarca 
    LEFT JOIN
        modelos mode ON dpre.codmodelo = mode.codmodelo  
	LEFT JOIN 
	    presentaciones pres ON dpre.codpresentacion = pres.codpresentacion
    LEFT JOIN 
        colores col ON dpre.codcolor = col.codcolor  
    LEFT JOIN
        productos prod ON dpre.tipodetalle = 1 AND prod.idproducto = dpre.idproducto
    LEFT JOIN
        combos com ON dpre.tipodetalle = 2 AND com.idcombo = dpre.idproducto ";
    //Condicion de Sucursal
    if (!empty($codSucursal)) {
        $whereConditions[] = "pre.codsucursal = ?";
        $params[]          = $codSucursal;
    }
    //Condicion de Fechas
    if (!empty($fechaDesde) && !empty($fechaHasta)) {
        $whereConditions[] = "DATE_FORMAT(pre.fechapreventa,'%Y-%m-%d') BETWEEN ? AND ?";
        $params[] = $fechaDesde;
        $params[] = $fechaHasta;
    }
    $whereClause = "";
    if (!empty($whereConditions)) {
        $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $groupByClause = " GROUP BY ";
    $groupByClause .= "dpre.idproducto, dpre.codproducto, dpre.producto, dpre.descripcion, dpre.opcionvendido,
		dpre.imei, dpre.condicion, dpre.codmarca, dpre.codmodelo, dpre.codpresentacion,
		dpre.codcolor, dpre.precioventa, dpre.ivaproducto, dpre.descproducto, dpre.tipodetalle,
	    suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
		suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
		doc.documento, documento2, tm.moneda, tm.siglas, tm.simbolo,
		mar.nommarca, mode.nommodelo, pres.nompresentacion, col.nomcolor,
	    existencia,
        cantcombo";
    $sql = $sqlBase . $whereClause . $groupByClause . " ORDER BY dpre.codproducto ASC";
    try {
        $stmt = $this->dbh->prepare($sql);// Preparar y ejecutar la consulta
        $stmt->execute($params); // Pasamos todos los parámetros juntos
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($results)) {
            echo "<div class='alert alert-danger'>";
            echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
            echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS PARA TU BÚSQUEDA REALIZADA</center>";
            echo "</div>";
            exit();
        } else {
            return $results;
        }
    } catch (PDOException $e) {
        error_log("Error en BuscarDetallesPreventasxFechas: " . $e->getMessage());
        echo "<div class='alert alert-danger'>";
        echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
        echo "<center><span class='fa fa-exclamation-triangle'></span> OCURRIÓ UN ERROR AL CONSULTAR LOS DETALLES DE PREVENTAS.</center>";
        echo "</div>";
        exit();
    }
}
########################### FUNCION BUSCAR DETALLES PREVENTAS POR FECHAS ###############################

###################### FUNCION BUSCAR DETALLES PREVENTAS POR VENDEDOR #########################
public function BuscarDetallesPreventasxVendedor() 
{
    $this->p = [];
	$codSucursal         = isset($_GET["codsucursal"]) ? limpiar(decrypt($_GET['codsucursal'])) : '';
	$codUsuarioBusqueda = isset($_GET['codigo']) ? limpiar(trim($_GET['codigo'])) : null;
	$fechaDesde          = isset($_GET['desde']) ? limpiar(date("Y-m-d", strtotime($_GET['desde']))) : '';
    $fechaHasta          = isset($_GET['hasta']) ? limpiar(date("Y-m-d", strtotime($_GET['hasta']))) : '';
	$whereConditions     = [];
    $params              = [];

    $sqlBase = "SELECT
        dpre.idproducto, dpre.codproducto, dpre.producto, dpre.descripcion, dpre.opcionvendido,
		dpre.imei, dpre.condicion, dpre.codmarca, dpre.codmodelo, dpre.codpresentacion,
		dpre.codcolor, dpre.precioventa, dpre.ivaproducto, dpre.descproducto, dpre.tipodetalle,
	    suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
		suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
		doc.documento, doc2.documento AS documento2, tm.moneda, tm.siglas, tm.simbolo,
	    mar.nommarca, mode.nommodelo, pres.nompresentacion, col.nomcolor,
	    usu.dni, usu.nombres,
        SUM(dpre.cantpreventa) AS cantidad,
        prod.existencia AS existencia,
        com.existencia AS cantcombo
    FROM
        preventas pre
    INNER JOIN
        detallepreventas dpre ON pre.codpreventa = dpre.codpreventa
	LEFT JOIN 
	    usuarios usu ON pre.codigo = usu.codigo
    LEFT JOIN 
	    sucursales suc ON pre.codsucursal = suc.codsucursal 
	LEFT JOIN 
	    documentos doc ON suc.documsucursal = doc.coddocumento
	LEFT JOIN 
	    documentos AS doc2 ON suc.documencargado = doc2.coddocumento
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
    LEFT JOIN 
        marcas mar ON dpre.codmarca = mar.codmarca 
    LEFT JOIN
        modelos mode ON dpre.codmodelo = mode.codmodelo  
	LEFT JOIN 
	    presentaciones pres ON dpre.codpresentacion = pres.codpresentacion
    LEFT JOIN 
        colores col ON dpre.codcolor = col.codcolor  
    LEFT JOIN
        productos prod ON dpre.tipodetalle = 1 AND prod.idproducto = dpre.idproducto
    LEFT JOIN
        combos com ON dpre.tipodetalle = 2 AND com.idcombo = dpre.idproducto ";
    //Condicion de Sucursal
    if (!empty($codSucursal)) {
        $whereConditions[] = "pre.codsucursal = ?";
        $params[]          = $codSucursal;
    }
    //Condicion de Usuario
    if (!empty($codUsuarioBusqueda)) {
        $whereConditions[] = "pre.codigo = ?";
        $params[]          = $codUsuarioBusqueda;
    }
    //Condicion de Fechas
    if (!empty($fechaDesde) && !empty($fechaHasta)) {
        $whereConditions[] = "DATE_FORMAT(pre.fechapreventa,'%Y-%m-%d') BETWEEN ? AND ?";
        $params[] = $fechaDesde;
        $params[] = $fechaHasta;
    }
    $whereClause = "";
    if (!empty($whereConditions)) {
        $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $groupByClause = " GROUP BY ";
    $groupByClause .= "dpre.idproducto, dpre.codproducto, dpre.producto, dpre.descripcion, dpre.opcionvendido,
		dpre.imei, dpre.condicion, dpre.codmarca, dpre.codmodelo, dpre.codpresentacion,
		dpre.codcolor, dpre.precioventa, dpre.ivaproducto, dpre.descproducto, dpre.tipodetalle,
	    suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
		suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
		doc.documento, documento2, tm.moneda, tm.siglas, tm.simbolo,
		mar.nommarca, mode.nommodelo, pres.nompresentacion, col.nomcolor,
	    usu.dni, usu.nombres,
	    existencia,
        cantcombo";
    $sql = $sqlBase . $whereClause . $groupByClause . " ORDER BY dpre.codproducto ASC";
    try {
        $stmt = $this->dbh->prepare($sql);// Preparar y ejecutar la consulta
        $stmt->execute($params); // Pasamos todos los parámetros juntos
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($results)) {
            echo "<div class='alert alert-danger'>";
            echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
            echo "<center><span class='fa fa-info-circle'></span> NO SE ENCONTRARON RESULTADOS PARA TU BÚSQUEDA REALIZADA</center>";
            echo "</div>";
            exit();
        } else {
            return $results;
        }
    } catch (PDOException $e) {
        error_log("Error en BuscarDetallesPreventasxVendedor: " . $e->getMessage());
        echo "<div class='alert alert-danger'>";
        echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
        echo "<center><span class='fa fa-exclamation-triangle'></span> OCURRIÓ UN ERROR AL CONSULTAR LOS DETALLES DE PREVENTAS.</center>";
        echo "</div>";
        exit();
    }
}
########################### FUNCION BUSCAR DETALLES PREVENTAS POR VENDEDOR ###############################

########################### FIN DE CLASE PREVENTAS ############################




























############################## CLASE GUIA DE DESPACHOS ###################################

########################### FUNCION REGISTRAR DESPACHOS ##########################
public function RegistrarDespachos()
{
	$this->p = [];
	if(empty($_POST["codsucursal"]) or empty($_POST["txtTotal"]))
	{
		echo "1";
		exit;
	}
	elseif(empty($_SESSION["CarritoDespacho"]))
	{
		echo "2";
		exit;
	}

	############ VALIDO SI LA CANTIDAD ES MAYOR QUE LA EXISTENCIA #############
	$v = $_SESSION["CarritoDespacho"];
    for ($i = 0, $iMax = count($v); $i < $iMax; $i++) {

	    if($v[$i]['tipodetalle'] == 1 && $_POST["inventarios"] == 1){ 

		    $sql = "SELECT existencia FROM productos 
		    WHERE idproducto = '".limpiar($v[$i]['id'])."' 
	        AND codproducto = '".limpiar($v[$i]['txtCodigo'])."'  
		    AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		    foreach ($this->dbh->query($sql) as $row)
		    {
			   $this->p[] = $row;
		    }
		
		    $existenciabd = $row['existencia'];
		    $cantidad = $v[$i]['cantidad'];

	        if ($cantidad > $existenciabd) 
	        { 
		        echo "3";
		        exit;
	        }

		} elseif(limpiar($v[$i]['tipodetalle']) == 2 && $_POST["inventarios"] == 1){ // SI EL DETALLE ES UN COMBO

			$sql = "SELECT 
		    existencia 
		    FROM combos 
		    WHERE idcombo = '".limpiar($v[$i]['id'])."' 
	        AND codcombo = '".limpiar($v[$i]['txtCodigo'])."'
		    AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		    foreach ($this->dbh->query($sql) as $row)
		    {
			   $this->p[] = $row;
		    }
		
		    $existenciabd = $row['existencia'];
		    $cantidad = $v[$i]['cantidad'];

	        if ($cantidad > $existenciabd) 
	        { 
		        echo "4";
		        exit;
	        }

		    ############## VERIFICO SI EL COMBO TIENE PRODUCTO RELACIONADOS #################
		    $sql = "SELECT * FROM combosxproductos WHERE codcombo = ? AND codsucursal = ?";
			$stmt = $this->dbh->prepare($sql);
			$stmt->execute(array($v[$i]['txtCodigo'],limpiar($_POST["codsucursal"])));
			$num = $stmt->rowCount();
	        if($num>0) {  

	        	$sql = "SELECT 
	        	combosxproductos.codcombo,
	    	    combosxproductos.idproducto,
	        	combosxproductos.codproducto,
	        	combosxproductos.cantidad,
	        	combosxproductos.codsucursal,
	        	productos.existencia
	        	FROM combosxproductos 
	        	LEFT JOIN productos ON combosxproductos.codproducto = productos.codproducto 
	        	WHERE combosxproductos.codcombo IN ('".limpiar($v[$i]['txtCodigo'])."') 
	        	AND combosxproductos.codsucursal = '".limpiar($_POST['codsucursal'])."' 
	    	    AND productos.codsucursal = '".limpiar($_POST['codsucursal'])."'";
	        	foreach ($this->dbh->query($sql) as $row)
			    { 
				    $this->p[] = $row;

				    $cantracionbd2  = $row['cantidad'];
				    $idproductobd2  = $row['idproducto'];
				    $codproductobd2 = $row['codproducto'];
				    $existenciabd2  = $row['existencia'];
			        $racion         = number_format($cantracionbd2*$v[$i]['cantidad'], 2, '.', '');

			        if ($racion > $existenciabd2) 
			        { 
			        	echo "5";
			        	exit;
			        }
			    }
		    }//fin de consulta de productos de combos	
		    ############## VERIFICO SI EL COMBO TIENE PRODUCTO RELACIONADOS #################
	    }
	}
	############ VALIDO SI LA CANTIDAD ES MAYOR QUE LA EXISTENCIA #############

	################### SELECCIONE LOS DATOS DEL CLIENTE ######################
    $sql = "SELECT
    clientes.codcliente,
	clientes.tipocliente,
	clientes.documcliente,
	clientes.dnicliente,
	CONCAT(if(clientes.tipocliente='JURIDICO',clientes.razoncliente,clientes.nomcliente)) as nomcliente,
	clientes.girocliente,
	clientes.tlfcliente,
	clientes.id_ciudad,
	clientes.id_comuna,
	clientes.direccliente,
	clientes.emailcliente,
	clientes.limitecredito,
	ciudades.codciudad,
	ciudades.ciudad,
	comunas.codcomuna,
	comunas.comuna
    FROM clientes
    LEFT JOIN ciudades ON clientes.id_ciudad = ciudades.id_ciudad 
    LEFT JOIN comunas ON clientes.id_comuna = comunas.id_comuna 
    WHERE clientes.dnicliente = ? 
    AND clientes.codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(limpiar($_POST['nrodocumento']),limpiar(decrypt($_POST["codsucursal"]))));
	$num = $stmt->rowCount();
	if($row = $stmt->fetch(PDO::FETCH_ASSOC))
	{
		$p[] = $row;
	}
    $codcliente    = (empty($row['codcliente']) ? "0" : $row['codcliente']);
    $tipocliente   = (empty($row['tipocliente']) ? "0" : $row['tipocliente']);
    $dnicliente    = (empty($row['dnicliente']) ? "0" : $row['dnicliente']);
    $nomcliente    = (empty($row['nomcliente']) ? "0" : $row['nomcliente']);
    $girocliente   = (empty($row['girocliente']) ? "0" : $row['girocliente']);
    $emailcliente  = (empty($row['emailcliente']) ? "0" : $row['emailcliente']);
    $ciudad        = (empty($row['id_ciudad']) ? "0" : $row['ciudad']);
    $comuna        = (empty($row['id_comuna']) ? "0" : $row['comuna']);
    $direccliente  = (empty($row['direccliente']) ? "0" : $row['direccliente']);
    $limitecredito = (empty($row['limitecredito']) ? "0.00" : $row['limitecredito']);
    ################### SELECCIONE LOS DATOS DEL CLIENTE ######################

    ################# OBTENGO DATOS DE SUCURSAL #################
	$sql = " SELECT 
	codsucursal, 
	nroactividadsucursal, 
	inicioguia,
	lioren_token
	FROM sucursales WHERE codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$nroactividad = $row['nroactividadsucursal'];
	$inicioguia   = $row['inicioguia'];
	$lioren_token = $row['lioren_token'];
	################# OBTENGO DATOS DE SUCURSAL #################

	################ CREO CODIGO DE DESPACHO ####################
	$stmt = $this->dbh->prepare("SELECT MAX(CAST(coddespacho AS UNSIGNED)) AS ultimo_despacho 
		                        FROM despachos");
    
    $stmt->execute();
    // Obtener el resultado de la consulta
    $row = $stmt->fetch(PDO::FETCH_ASSOC);
	// Obtener el último código de venta y extraer la parte numérica
	$ultimoDespacho = $row['ultimo_despacho'];
	// Generar el nuevo código de venta (ajusta el formato según tus necesidades)
	$coddespacho    = (empty($ultimoDespacho) ? "1" : $ultimoDespacho + 1);
	$fecha          = date("Y-m-d H:i:s");
    ################ CREO CODIGO DE DESPACHO ###############

	################### CREO CODIGO DE FACTURA ####################
	$sql4 = "SELECT codfactura FROM despachos 
	WHERE codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."' 
	ORDER BY iddespacho DESC LIMIT 1";
	foreach ($this->dbh->query($sql4) as $row4){

		$factura = $row4["codfactura"];
	}
	if(empty($factura))
	{
		$codfactura      = $inicioguia;
	    $codserie        = limpiar($nroactividad);
	    $codautorizacion = limpiar(GenerateRandomStringg());

	} else {

		$var             = strlen("");
        $var1            = substr($factura, $var);
        $var2            = strlen($var1);
        $var3            = $var1 + 1;
        $var4            = str_pad($var3, $var2, "0", STR_PAD_LEFT);
        $codfactura      = $var4;
        $codserie        = limpiar($nroactividad);
        $codautorizacion = limpiar(GenerateRandomStringg());
	}
    ################### CREO LOS CODIGO DE FACTURA ####################

    $query = "INSERT INTO despachos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $coddespacho);
	$stmt->bindParam(2, $tipodocumento);
	$stmt->bindParam(3, $codfactura);
	$stmt->bindParam(4, $codserie);
	$stmt->bindParam(5, $codautorizacion);
	$stmt->bindParam(6, $codcliente);
	$stmt->bindParam(7, $tipodespacho);
	$stmt->bindParam(8, $subtotalivasi);
	$stmt->bindParam(9, $subtotalivano);
	$stmt->bindParam(10, $iva);
	$stmt->bindParam(11, $totaliva);
	$stmt->bindParam(12, $descontado);
	$stmt->bindParam(13, $descuento);
	$stmt->bindParam(14, $totaldescuento);
	$stmt->bindParam(15, $totalpago);
	$stmt->bindParam(16, $totalpago2);
	$stmt->bindParam(17, $observaciones);
	$stmt->bindParam(18, $fechadespacho);
	$stmt->bindParam(19, $statusdespacho);
	$stmt->bindParam(20, $bpsii);
	$stmt->bindParam(21, $inventarios);
	$stmt->bindParam(22, $procesada);
	$stmt->bindParam(23, $codigo);
	$stmt->bindParam(24, $codsucursal);
   
	$tipodocumento  = limpiar($_POST["tipodocumento"]);
	$codcliente     = limpiar($_POST["codcliente"]);
	$tipodespacho   = limpiar($_POST["tipodespacho"]);
	$subtotalivasi  = limpiar($_POST["txtsubtotal"]);
	$subtotalivano  = limpiar($_POST["txtsubtotal2"]);
	$iva            = limpiar($_POST["iva"]);
	$totaliva       = limpiar($_POST["txtIva"]);
	$descontado     = limpiar($_POST["txtdescontado"]);
	$descuento      = limpiar($_POST["descuento"]);
	$totaldescuento = limpiar($_POST["txtDescuento"]);
	$totalpago      = limpiar($_POST["txtTotal"]);
	$totalpago2     = limpiar($_POST["txtTotalCompra"]);
	$observaciones  = limpiar($_POST["observaciones"]);
    $fechadespacho  = limpiar(date("Y-m-d H:i:s"));
	$statusdespacho = limpiar("1");
	$bpsii          = limpiar($_POST["bpsii"]);
	$inventarios    = limpiar($_POST["inventarios"]);
	$procesada      = limpiar($_POST["tipodespacho"] == '5' ? '1' : '0');
	$codigo         = limpiar($_SESSION["codigo"]);
	$codsucursal    = limpiar(decrypt($_POST["codsucursal"]));
	$stmt->execute();
	
	$this->dbh->beginTransaction();
	$detalle = $_SESSION["CarritoDespacho"];
	for($i=0;$i<count($detalle);$i++){

	$query = "INSERT INTO detalledespachos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
	$stmt = $this->dbh->prepare($query);
	$stmt->bindParam(1, $coddespacho);
	$stmt->bindParam(2, $idproducto);
    $stmt->bindParam(3, $codproducto);
    $stmt->bindParam(4, $producto);
	$stmt->bindParam(5, $descripcion);
    $stmt->bindParam(6, $opcionvendido);
	$stmt->bindParam(7, $imei);
	$stmt->bindParam(8, $condicion);
    $stmt->bindParam(9, $codmarca);
    $stmt->bindParam(10, $codmodelo);
    $stmt->bindParam(11, $codpresentacion);
	$stmt->bindParam(12, $codcolor);
	$stmt->bindParam(13, $cantidad);
	$stmt->bindParam(14, $preciocompra);
	$stmt->bindParam(15, $precioventa);
	$stmt->bindParam(16, $ivaproducto);
	$stmt->bindParam(17, $descproducto);
	$stmt->bindParam(18, $valortotal);
	$stmt->bindParam(19, $totaldescuentov);
	$stmt->bindParam(20, $subtotalimpuestos);
	$stmt->bindParam(21, $valorneto);
	$stmt->bindParam(22, $valorneto2);
	$stmt->bindParam(23, $tipodetalle);
	$stmt->bindParam(24, $codsucursal);
		
    $idproducto      = limpiar($detalle[$i]['tipodetalle'] == "3" ? "0" : $detalle[$i]['id']);
	$codproducto     = limpiar($detalle[$i]['tipodetalle'] == "3" ? "0" : $detalle[$i]['txtCodigo']);
	$producto        = limpiar($detalle[$i]['producto']);
	$descripcion     = limpiar($detalle[$i]['tipodetalle'] == "3" || $detalle[$i]['descripcion'] == "0" ? "" : $detalle[$i]['descripcion']);
	$opcionvendido   = limpiar($detalle[$i]['opcionvendido']);
	$imei            = limpiar($detalle[$i]['tipodetalle'] == "3" || $detalle[$i]['imei'] == "0" ? "" : $detalle[$i]['imei']);
	$condicion       = limpiar($detalle[$i]['tipodetalle'] == "3" || $detalle[$i]['condicion'] == "0" ? "" : $detalle[$i]['condicion']);
	$codmarca        = limpiar($detalle[$i]['tipodetalle'] == "3" ? "0" : $detalle[$i]['codmarca']);
	$codmodelo       = limpiar($detalle[$i]['tipodetalle'] == "3" ? "0" : $detalle[$i]['codmodelo']);
	$codpresentacion = limpiar($detalle[$i]['tipodetalle'] == "3" ? "0" : $detalle[$i]['codpresentacion']);
	$codcolor        = limpiar($detalle[$i]['tipodetalle'] == "3" ? "0" : $detalle[$i]['codcolor']);
	$cantidad        = $detalle[$i]['opcionvendido'] == "2" ? number_format($detalle[$i]['cantidad'], 3, '.', '') : number_format($detalle[$i]['cantidad'], 0, '.', '');
	$preciocompra    = limpiar($detalle[$i]['precio']);
	$precioventa     = limpiar($detalle[$i]['precio2']);
	$precioconiva    = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['precio2']);
	$ivaproducto     = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
	$descproducto    = limpiar($detalle[$i]['descproducto']);
	$descuento       = $detalle[$i]['descproducto']/100;
	$valortotal      = number_format($detalle[$i]['precio2']*$detalle[$i]['cantidad'], 2, '.', '');
	$totaldescuentov = number_format($valortotal*$descuento, 2, '.', '');

	//CALCULO SUBTOTAL IMPUESTOS
	$ValorImpuesto        = 1 + ($_POST["iva"]/100);
	$RestoDescuento       = $precioconiva * $detalle[$i]['descproducto'] / 100;
	$PrecioIvaDescuento   = $precioconiva - $RestoDescuento;
	$Discriminado         = $PrecioIvaDescuento/$ValorImpuesto;
	$SubtotalDiscriminado = $PrecioIvaDescuento - $Discriminado;
    $BaseDiscriminado     = $SubtotalDiscriminado * $detalle[$i]['cantidad'];
    $subtotalimpuestos    = number_format($BaseDiscriminado, 2, '.', '');

    $valorneto      = number_format($valortotal-$totaldescuentov, 2, '.', '');
	$valorneto2     = limpiar($detalle[$i]['tipodetalle'] == "3" ? "0.00" : number_format($detalle[$i]['precio']*$detalle[$i]['cantidad'], 2, '.', ''));
    $tipodetalle    = limpiar($detalle[$i]['tipodetalle']);
	$codsucursal    = limpiar(decrypt($_POST["codsucursal"]));
	$stmt->execute();

	if(limpiar($detalle[$i]['tipodetalle'])==1 && $_POST["inventarios"] == 1){ // SI EL DETALLE ES UN PRODUCTO

	    ################ VERIFICO LA EXISTENCIA DEL PRODUCTO EN ALMACEN ################
		$sql = "SELECT * FROM productos 
		WHERE idproducto = '".limpiar($detalle[$i]['id'])."' 
	    AND codproducto = '".limpiar($detalle[$i]['txtCodigo'])."' 
		AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		$existenciabd = $row['existencia'];
	    ############### VERIFICO LA EXISTENCIA DEL PRODUCTO EN ALMACEN ################

	    ##################### ACTUALIZO LA EXISTENCIA DEL ALMACEN ####################
		$sql = " UPDATE productos set "
		." existencia = ? "
		." WHERE "
		." idproducto = '".limpiar($detalle[$i]['id'])."' 
	    AND codproducto = '".limpiar($detalle[$i]['txtCodigo'])."' 
		AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."';
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $existencia);

		$cantventa  = $detalle[$i]['opcionvendido'] == "2" ? number_format($detalle[$i]['cantidad'], 3, '.', '') : number_format($detalle[$i]['cantidad'], 0, '.', '');
		$existencia = $detalle[$i]['opcionvendido'] == "2" ? number_format($existenciabd-$detalle[$i]['cantidad'], 3, '.', '') : number_format($existenciabd-$detalle[$i]['cantidad'], 0, '.', '');
		$stmt->execute();
	    ##################### ACTUALIZO LA EXISTENCIA DEL ALMACEN ####################

	    ############### REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX ###############
	    $query = "INSERT INTO kardex values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $coddespacho);
		$stmt->bindParam(2, $codcliente);
		$stmt->bindParam(3, $codproducto);
		$stmt->bindParam(4, $movimiento);
		$stmt->bindParam(5, $entradas);
		$stmt->bindParam(6, $salidas);
		$stmt->bindParam(7, $devolucion);
		$stmt->bindParam(8, $stockactual);
		$stmt->bindParam(9, $ivaproducto);
		$stmt->bindParam(10, $descproducto);
		$stmt->bindParam(11, $precio);
		$stmt->bindParam(12, $documento);
		$stmt->bindParam(13, $fechakardex);	
	    $stmt->bindParam(14, $tipokardex);	
	    $stmt->bindParam(15, $procedimiento);			
		$stmt->bindParam(16, $codsucursal);
		$stmt->bindParam(17, $codigo);

		$codcliente    = limpiar($_POST["codcliente"] == 0 ? "0" : $_POST["codcliente"]);
		$codproducto   = limpiar($detalle[$i]['txtCodigo']);
		$movimiento    = limpiar("SALIDAS");
		$entradas      = $detalle[$i]['opcionvendido'] == "2" ? "0.000" : "0";
		$salidas       = $detalle[$i]['opcionvendido'] == "2" ? number_format($detalle[$i]['cantidad'], 3, '.', '') : number_format($detalle[$i]['cantidad'], 0, '.', '');
		$devolucion    = $detalle[$i]['opcionvendido'] == "2" ? "0.000" : "0";
		$stockactual   = $detalle[$i]['opcionvendido'] == "2" ? number_format($existenciabd-$detalle[$i]['cantidad'], 3, '.', '') : number_format($existenciabd-$detalle[$i]['cantidad'], 0, '.', '');
		$ivaproducto   = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
		$descproducto  = number_format($detalle[$i]['descproducto'], 2, '.', '');
		$precio        = number_format($detalle[$i]["precio2"], 2, '.', '');
		$documento     = limpiar("DESPACHO: ".$coddespacho);
		$fechakardex   = limpiar(date("Y-m-d"));
	    $tipokardex    = limpiar($detalle[$i]['tipodetalle']);
	    $procedimiento = limpiar("1");
		$codsucursal   = limpiar(decrypt($_POST["codsucursal"]));
    	$codigo        = limpiar($_SESSION["codigo"]);
		$stmt->execute();
		############### REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX ###############
    	
    } elseif(limpiar($detalle[$i]['tipodetalle']) == 2 && $_POST["inventarios"] == 1){ // SI EL DETALLE ES UN COMBO

	    ############## VERIFICO LA EXISTENCIA DEL COMBO EN ALMACEN #################
		$sql = "SELECT 
		existencia 
		FROM combos 
		WHERE idcombo = '".limpiar($detalle[$i]['id'])."' 
	    AND codcombo = '".limpiar($detalle[$i]['txtCodigo'])."'
		AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		$existenciacombobd = $row['existencia'];
		############## VERIFICO LA EXISTENCIA DEL COMBO EN ALMACEN #################

	    ##################### ACTUALIZO LA EXISTENCIA DEL COMBO DEL ALMACEN ####################
		$sql = " UPDATE combos set "
			." existencia = ? "
			." WHERE "
			." idcombo = '".limpiar($detalle[$i]['id'])."' 
	      AND codcombo = '".limpiar($detalle[$i]['txtCodigo'])."'
	      AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."';
			";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $existencia);
		$cantventa  = $detalle[$i]['opcionvendido'] == "2" ? number_format($detalle[$i]['cantidad'], 3, '.', '') : number_format($detalle[$i]['cantidad'], 0, '.', '');
		$existencia = $detalle[$i]['opcionvendido'] == "2" ? number_format($existenciacombobd-$detalle[$i]['cantidad'], 3, '.', '') : number_format($existenciacombobd-$detalle[$i]['cantidad'], 0, '.', '');
		$stmt->execute();
		##################### ACTUALIZO LA EXISTENCIA DEL COMBO DEL ALMACEN ####################

		############### REGISTRAMOS LOS DATOS DE COMBO EN KARDEX ###############
	    $query = "INSERT INTO kardex values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $coddespacho);
		$stmt->bindParam(2, $codcliente);
		$stmt->bindParam(3, $codproducto);
		$stmt->bindParam(4, $movimiento);
		$stmt->bindParam(5, $entradas);
		$stmt->bindParam(6, $salidas);
		$stmt->bindParam(7, $devolucion);
		$stmt->bindParam(8, $stockactual);
		$stmt->bindParam(9, $ivaproducto);
		$stmt->bindParam(10, $descproducto);
		$stmt->bindParam(11, $precio);
		$stmt->bindParam(12, $documento);
		$stmt->bindParam(13, $fechakardex);	
	    $stmt->bindParam(14, $tipokardex);
	    $stmt->bindParam(15, $procedimiento);			
		$stmt->bindParam(16, $codsucursal);
		$stmt->bindParam(17, $codigo);

		$codcliente    = limpiar($_POST["codcliente"] == 0 ? "0" : $_POST["codcliente"]);
		$codproducto   = limpiar($detalle[$i]['txtCodigo']);
		$movimiento    = limpiar("SALIDAS");
		$entradas      = $detalle[$i]['opcionvendido'] == "2" ? "0.000" : "0";
		$salidas       = $detalle[$i]['opcionvendido'] == "2" ? number_format($detalle[$i]['cantidad'], 3, '.', '') : number_format($detalle[$i]['cantidad'], 0, '.', '');
		$devolucion    = $detalle[$i]['opcionvendido'] == "2" ? "0.000" : "0";
		$devolucion    = $detalle[$i]['opcionvendido'] == "2" ? number_format($existenciacombobd-$detalle[$i]['cantidad'], 3, '.', '') : number_format($existenciacombobd-$detalle[$i]['cantidad'], 0, '.', '');
		$ivaproducto   = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
		$descproducto  = number_format($detalle[$i]['descproducto'], 2, '.', '');
		$precio        = number_format($detalle[$i]["precio2"], 2, '.', '');
		$documento     = limpiar("DESPACHO: ".$coddespacho);
		$fechakardex   = limpiar(date("Y-m-d"));
	    $tipokardex    = limpiar($detalle[$i]['tipodetalle']);
	    $procedimiento = limpiar("2");	
		$codsucursal   = limpiar(decrypt($_POST["codsucursal"]));
		$codigo        = limpiar($_SESSION["codigo"]);
		$stmt->execute();
		############### REGISTRAMOS LOS DATOS DE COMBO EN KARDEX ###############

		############## VERIFICO SI EL COMBO TIENE PRODUCTO RELACIONADOS #################
	    $sql = "SELECT * FROM combosxproductos WHERE codcombo = ? AND codsucursal = ?";
		$stmt = $this->dbh->prepare($sql);
		$stmt->execute(array($detalle[$i]['txtCodigo'],limpiar($_POST["codsucursal"])));
		$num = $stmt->rowCount();
	    if($num>0) {  

	    	$sql = "SELECT 
	    	combosxproductos.codcombo,
	    	combosxproductos.idproducto,
	    	combosxproductos.codproducto,
	    	combosxproductos.cantidad,
	    	combosxproductos.codsucursal,
	    	productos.opcionvendido,
	    	productos.existencia,
	    	productos.precioxpublico AS precioventa,
	    	productos.ivaproducto,
	    	productos.descproducto
	    	FROM combosxproductos 
	    	LEFT JOIN productos ON combosxproductos.codproducto = productos.codproducto 
	    	WHERE combosxproductos.codcombo IN ('".limpiar($detalle[$i]['txtCodigo'])."') 
	    	AND combosxproductos.codsucursal = '".limpiar($_POST['codsucursal'])."' 
	    	AND productos.codsucursal = '".limpiar($_POST['codsucursal'])."'";
	    	foreach ($this->dbh->query($sql) as $row)
		    { 
			    $this->p[] = $row;

			    $cantracionbd2   = $row['cantidad'];
			    $idproductobd2   = $row['idproducto'];
			    $codproductobd2  = $row['codproducto'];
			    $existenciabd2   = $row['existencia'];
			    $precioventabd2  = $row['precioventa'];
			    $ivaproductobd2  = $row['ivaproducto'];
			    $descproductobd2 = $row['descproducto'];
			    $opcionvendido2  = $row['opcionvendido'];

			    ############## ACTUALIZO LOS DATOS DEL PRODUCTO #################
			    $update = "UPDATE productos set "
			    ." existencia = ? "
			    ." WHERE "
			    ." idproducto = ? AND codproducto = ? AND codsucursal = ?;
			    ";
			    $stmt = $this->dbh->prepare($update);
			    $stmt->bindParam(1, $cantidadracion);
			    $stmt->bindParam(2, $idproducto);
			    $stmt->bindParam(3, $codproducto);
	            $stmt->bindParam(4, $codsucursal);

			    $racion         = $cantracionbd2*$detalle[$i]['cantidad'];
			    $cantidadracion = $opcionvendido2 == "2" ? number_format($existenciabd2-$racion, 3, '.', '') : number_format($existenciabd2-$racion, 0, '.', '');
			    $idproducto     = limpiar($idproductobd2);
		        $codproducto    = limpiar($codproductobd2);
	            $codsucursal    = limpiar(decrypt($_POST["codsucursal"]));
			    $stmt->execute();
			    ############## ACTUALIZO LOS DATOS DEL PRODUCTO #################

			    ############## REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX ###################
			    $query = "INSERT INTO kardex values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
			    $stmt = $this->dbh->prepare($query);
			    $stmt->bindParam(1, $coddespacho);
			    $stmt->bindParam(2, $codcliente);
			    $stmt->bindParam(3, $codproducto);
			    $stmt->bindParam(4, $movimiento);
			    $stmt->bindParam(5, $entradas);
			    $stmt->bindParam(6, $salidas);
			    $stmt->bindParam(7, $devolucion);
			    $stmt->bindParam(8, $stockactual);
			    $stmt->bindParam(9, $ivaproducto);
			    $stmt->bindParam(10, $descproducto);
			    $stmt->bindParam(11, $precio);
			    $stmt->bindParam(12, $documento);
			    $stmt->bindParam(13, $fechakardex);
	            $stmt->bindParam(14, $tipokardex);
	    	    $stmt->bindParam(15, $procedimiento);	
	            $stmt->bindParam(16, $codsucursal);
		        $stmt->bindParam(17, $codigo);		

			    $codcliente    = limpiar($_POST["codcliente"] == 0 ? "0" : $_POST["codcliente"]);
			    $codproducto   = limpiar($codproductobd2);
			    $movimiento    = limpiar("SALIDAS");
		        $entradas      = $opcionvendido2 == "2" ? "0.000" : "0";
		        $salidas       = $opcionvendido2 == "2" ? number_format($racion, 3, '.', '') : number_format($racion, 0, '.', '');
		        $devolucion    = $opcionvendido2 == "2" ? "0.000" : "0";
			    $stockactual   = $opcionvendido2 == "2" ? number_format($existenciabd2-$racion, 3, '.', '') : number_format($existenciabd2-$racion, 0, '.', '');
			    $ivaproducto   = limpiar($ivaproductobd2 == "NO" ? "0.00" : $_POST["iva"]);
			    $descproducto  = number_format($descproductobd2, 2, '.', '');
			    $precio        = number_format($precioventabd2, 2, '.', '');
			    $documento     = limpiar("(DETALLE DE COMBO) DESPACHO: ".$coddespacho);
			    $fechakardex   = limpiar(date("Y-m-d"));
	            $tipokardex    = limpiar("1");
	    	    $procedimiento = limpiar("2");
	            $codsucursal   = limpiar(decrypt($_POST["codsucursal"]));
    	        $codigo        = limpiar($_SESSION["codigo"]);
			    $stmt->execute();
			    ############## REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX ###################			    
		   }
	   }//fin de consulta de productos de combos	
	   ############## VERIFICO SI EL COMBO TIENE PRODUCTO RELACIONADOS #################
    	
   } elseif(limpiar($detalle[$i]['tipodetalle']) == 3 && $_POST["inventarios"] == 1){// SI EL DETALLE ES UN SERVICIO

	    ############### REGISTRAMOS LOS DATOS DE SERVICIO EN KARDEX ###############
	    $query = "INSERT INTO kardex values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $coddespacho);
		$stmt->bindParam(2, $codcliente);
		$stmt->bindParam(3, $codproducto);
		$stmt->bindParam(4, $movimiento);
		$stmt->bindParam(5, $entradas);
		$stmt->bindParam(6, $salidas);
		$stmt->bindParam(7, $devolucion);
		$stmt->bindParam(8, $stockactual);
		$stmt->bindParam(9, $ivaproducto);
		$stmt->bindParam(10, $descproducto);
		$stmt->bindParam(11, $precio);
		$stmt->bindParam(12, $documento);
		$stmt->bindParam(13, $fechakardex);	
	    $stmt->bindParam(14, $tipokardex);	
	    $stmt->bindParam(15, $procedimiento);			
		$stmt->bindParam(16, $codsucursal);
		$stmt->bindParam(17, $codigo);

		$codcliente    = limpiar($_POST["codcliente"] == 0 ? "0" : $_POST["codcliente"]);
		$codproducto   = limpiar($detalle[$i]['txtCodigo']);
		$movimiento    = limpiar("SALIDAS");
		$entradas      = $detalle[$i]['opcionvendido'] == "2" ? "0.000" : "0";
		$salidas       = $detalle[$i]['opcionvendido'] == "2" ? number_format($detalle[$i]['cantidad'], 3, '.', '') : number_format($detalle[$i]['cantidad'], 0, '.', '');
		$devolucion    = $detalle[$i]['opcionvendido'] == "2" ? "0.000" : "0";
		$stockactual   = $detalle[$i]['opcionvendido'] == "2" ? "0.000" : "0";
		$ivaproducto   = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
		$descproducto  = number_format($detalle[$i]['descproducto'], 2, '.', '');
		$precio        = number_format($detalle[$i]["precio2"], 2, '.', '');
		$documento     = limpiar("DESPACHO: ".$coddespacho);
		$fechakardex   = limpiar(date("Y-m-d"));
	    $tipokardex    = limpiar($detalle[$i]['tipodetalle']);
	    $procedimiento = limpiar("3");
		$codsucursal   = limpiar(decrypt($_POST["codsucursal"]));
    	$codigo        = limpiar($_SESSION["codigo"]);
		$stmt->execute();
		############### REGISTRAMOS LOS DATOS DE SERVICIO EN KARDEX ###############
        }
    }
        
    ####################### DESTRUYO LA VARIABLE DE SESSION #####################
	unset($_SESSION["CarritoDespacho"]);
    $this->dbh->commit();
		
    if($lioren_token != "" && $_POST["bpsii"] == 1){//verifico si existe token de lioren

    $lioren = new Lioren();
    $lioren->enviarDespacho($coddespacho);

    $encCodDespacho = encrypt($coddespacho);
	$encCodSucursal = encrypt($codsucursal);
	$encTipo        = encrypt($tipodocumento);
	$url            = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . "/" . $this->carpeta .
			"/reportepdf?coddespacho=$encCodDespacho&codsucursal=$encCodSucursal&tipo=$encTipo";

        echo "<span class='fa fa-check-square-o'></span> EL DESPACHO DE PRODUCTOS HA SIDO REGISTRADO EXITOSAMENTE <a href='$url' class='on-default' data-placement='left' data-toggle='tooltip' data-original-title='Imprimir Documento' target='_black' rel='noopener noreferrer'><font color='black'><strong>IMPRIMIR REPORTE</strong></font color></a></div>";

        echo "<script>window.open('reportepdf?coddespacho=".encrypt($coddespacho)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt($tipodocumento)."', '_blank');</script>";
	    exit;

    } else {

    	echo "<span class='fa fa-check-square-o'></span> EL DESPACHO DE PRODUCTOS HA SIDO REGISTRADO EXITOSAMENTE <a href='reportepdf?coddespacho=".encrypt($coddespacho)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt($tipodocumento)."' class='on-default' data-placement='left' data-toggle='tooltip' data-original-title='Imprimir Documento' target='_black' rel='noopener noreferrer'><font color='black'><strong>IMPRIMIR REPORTE</strong></font color></a></div>";

        echo "<script>VentanaCentrada('reportepdf?coddespacho=".encrypt($coddespacho)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt($tipodocumento)."', '', '', '1024', '568', 'true');</script>";
	    exit;
	}
}
########################## FUNCION REGISTRAR DESPACHOS ############################

####################### FUNCION LISTAR DESPACHOS ################################
public function ListarDespachos()
{
	$this->p = [];
	$tipoAcceso      = isset($_SESSION["acceso"]) ? limpiar($_SESSION["acceso"]) : '';
	$codSucursal     = ($tipoAcceso === 'administradorG') ? limpiar(decrypt($_GET["codsucursal"])) : limpiar($_SESSION["codsucursal"]);	
    $codigoUsuario   = isset($_SESSION["codigo"]) ? limpiar($_SESSION["codigo"]) : '';
    $whereConditions = [];
    $params          = [];

    // Lógica de filtro basada en el tipo de acceso
    if ($tipoAcceso === 'cajero' || $tipoAcceso === 'vendedor') { // Acceso Cajero
        $whereConditions[] = "desp.codigo = ?";
        $params[]          = $codigoUsuario;
        $whereConditions[] = "desp.codsucursal = ?";
        $params[]          = $codSucursal;
    } else { // // Acceso Diferente a Cajero
        $whereConditions[] = "desp.codsucursal = ?";
        $params[]          = $codSucursal;
    }
   
    $whereClause = "";
    if (!empty($whereConditions)) {
      $whereClause = " WHERE " . implode(" AND ", $whereConditions);
    }
    $sqlBase = "SELECT
        desp.iddespacho, desp.coddespacho, desp.tipodocumento, desp.codfactura, desp.codcliente, desp.tipodespacho,  
		desp.subtotalivasi, desp.subtotalivano, desp.iva, desp.totaliva, desp.descontado, desp.descuento, desp.totaldescuento,
		desp.totalpago, desp.totalpago2, desp.observaciones, desp.fechadespacho, desp.statusdespacho, desp.bpsii,
		desp.inventarios, desp.procesada, desp.codsucursal,
		suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.documencargado,
		suc.dniencargado, suc.nomencargado, suc.codmoneda, suc.codmoneda2,
		tm.moneda, tm.siglas, tm.simbolo,
		usu.dni, usu.nombres,
		cl.tipocliente, cl.documcliente, cl.dnicliente,
		CONCAT(if(cl.tipocliente='NATURAL',cl.nomcliente,cl.razoncliente)) as nomcliente,
		cl.girocliente, cl.tlfcliente, cl.id_ciudad AS id_ciudad2, cl.id_comuna AS id_comuna2, 
		cl.direccliente, cl.emailcliente, cl.limitecredito,
		doc.documento, doc2.documento AS documento2, doc3.documento AS documento3,
		pag.articulos, pag.detalles_productos
    FROM 
        despachos desp LEFT JOIN sucursales suc ON desp.codsucursal = suc.codsucursal
	LEFT JOIN 
	    documentos doc ON suc.documsucursal = doc.coddocumento
	LEFT JOIN 
	    documentos AS doc2 ON suc.documencargado = doc2.coddocumento
	LEFT JOIN 
	    tiposmoneda tm ON suc.codmoneda = tm.codmoneda
	LEFT JOIN 
	    clientes cl ON desp.codcliente = cl.codcliente
	LEFT JOIN 
	    documentos AS doc3 ON cl.documcliente = doc3.coddocumento 
	LEFT JOIN 
	    usuarios usu ON desp.codigo = usu.codigo
    LEFT JOIN
        (SELECT
            ddesp.coddespacho,
            SUM(ddesp.cantdespacho) AS articulos,
            GROUP_CONCAT(
            CONCAT_WS(
               ' | ',
               ddesp.cantdespacho,
               ddesp.producto,
               ddesp.descripcion,
               IFNULL(mar.nommarca, ''),
               IFNULL(mode.nommodelo, ''),
               IFNULL(pres.nompresentacion, ''),
               IFNULL(col.nomcolor, '')
            )
                ORDER BY ddesp.producto
                SEPARATOR '<br>'
            ) AS detalles_productos
            FROM
                detalledespachos ddesp
            LEFT JOIN 
                marcas mar ON ddesp.codmarca = mar.codmarca
		    LEFT JOIN 
		        modelos mode ON ddesp.codmodelo = mode.codmodelo 
		    LEFT JOIN 
		        presentaciones pres ON ddesp.codpresentacion = pres.codpresentacion
			LEFT JOIN 
			    colores col ON ddesp.codcolor = col.codcolor
			WHERE ddesp.codsucursal = $codSucursal
	    GROUP BY
	        ddesp.coddespacho
	    ) pag ON pag.coddespacho = desp.coddespacho";
    $sql = $sqlBase . $whereClause . " ORDER BY desp.fechadespacho DESC";
    try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute($params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($results)) {
            return [];
        } else {
            return $results;
        }
    } catch (PDOException $e) {
        error_log("Error en ListarDespachos: " . $e->getMessage());
        return [];
    }
}
######################### FUNCION LISTAR DESPACHOS ############################

############################ FUNCION ID DESPACHOS #################################
public function DespachosPorId()
{
    $this->p     = [];
    $codDespacho = isset($_GET["coddespacho"]) ? limpiar(decrypt($_GET["coddespacho"])) : '';
    $codSucursal = isset($_GET["codsucursal"]) ? limpiar(decrypt($_GET["codsucursal"])) : '';
    $sql = "SELECT
        desp.*,
        suc.documsucursal, suc.cuitsucursal, suc.nomsucursal, suc.codgiro, suc.girosucursal,
        suc.tlfsucursal, suc.correosucursal, suc.id_ciudad, suc.id_comuna, suc.direcsucursal,
        suc.nroactividadsucursal, suc.fechaautorsucursal, suc.llevacontabilidad,
        suc.documencargado, suc.dniencargado, suc.nomencargado, suc.tlfencargado,
        suc.codmoneda, suc.codmoneda2, suc.membrete,
        tm.moneda, tm.siglas, tm.simbolo,
        tm2.moneda AS moneda2, tm2.siglas AS siglas2, tm2.simbolo AS simbolo2,
        valor_cambio.montocambio,
        cl.tipocliente, cl.documcliente, cl.dnicliente,
		CONCAT(if(cl.tipocliente='NATURAL',cl.nomcliente,cl.razoncliente)) as nomcliente,
		cl.girocliente, cl.tlfcliente, cl.id_ciudad AS id_ciudad2, cl.id_comuna AS id_comuna2, 
		cl.direccliente, cl.emailcliente, cl.limitecredito,
        doc.documento, doc2.documento AS documento2, doc3.documento AS documento3,
        usu.dni, usu.nombres,
        ciud.ciudad, com.comuna, ciud2.ciudad AS ciudad2, com2.comuna AS comuna2,
        pag.articulos
    FROM 
        despachos desp LEFT JOIN sucursales suc ON desp.codsucursal = suc.codsucursal
    LEFT JOIN 
        documentos doc ON suc.documsucursal = doc.coddocumento
    LEFT JOIN 
        documentos doc2 ON suc.documencargado = doc2.coddocumento
    LEFT JOIN 
        ciudades ciud ON suc.id_ciudad = ciud.id_ciudad 
    LEFT JOIN 
        comunas com ON suc.id_comuna = com.id_comuna 
    LEFT JOIN 
        tiposmoneda tm ON suc.codmoneda = tm.codmoneda
    LEFT JOIN 
        tiposmoneda tm2 ON suc.codmoneda2 = tm2.codmoneda
    LEFT JOIN 
        clientes cl ON desp.codcliente = cl.codcliente
    LEFT JOIN 
        documentos AS doc3 ON cl.documcliente = doc3.coddocumento
    LEFT JOIN 
        ciudades ciud2 ON cl.id_ciudad = ciud2.id_ciudad 
    LEFT JOIN 
        comunas com2 ON cl.id_comuna = com.id_comuna 
    LEFT JOIN 
        usuarios usu ON desp.codigo = usu.codigo
    LEFT JOIN
        (SELECT
            ddesp.coddespacho,
            SUM(ddesp.cantdespacho) AS articulos
            FROM
                detalledespachos ddesp
            WHERE ddesp.codsucursal = :codSucursal1
        GROUP BY
            ddesp.coddespacho
        ) pag ON pag.coddespacho = desp.coddespacho

    LEFT JOIN
       (SELECT
       codcambio, descripcioncambio, montocambio, codmoneda       
       FROM tiposcambio
       ORDER BY codcambio DESC LIMIT 1) valor_cambio ON valor_cambio.codmoneda = suc.codmoneda2
    WHERE desp.coddespacho = :codDespacho AND desp.codsucursal = :codSucursal2 LIMIT 1";
    try {
        $stmt = $this->dbh->prepare($sql);
        // Asignamos los parámetros a los marcadores de posición con nombre
        $stmt->bindParam(':codDespacho', $codDespacho);
        $stmt->bindParam(':codSucursal1', $codSucursal);
        $stmt->bindParam(':codSucursal2', $codSucursal);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        if (!$row) {
            echo "<div class='alert alert-danger'>";
            echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
            echo "<center><span class='fa fa-info-circle'></span> DESPACHO NO ENCONTRADA.</center>";
            echo "</div>";
            exit();
        } else {
            $this->p[] = $row;
            return $this->p;
        }
    } catch (PDOException $e) {
        error_log("Error en DespachosPorId: " . $e->getMessage());
        echo "<div class='alert alert-danger'>";
        echo "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>";
        echo "<center><span class='fa fa-exclamation-triangle'></span> OCURRIÓ UN ERROR AL CONSULTAR EL DESPACHO.</center>";
        echo "</div>";
        return [];
    }
}
############################ FUNCION ID DESPACHOS #################################

######################## FUNCION VER DETALLES DESPACHOS ############################
public function VerDetallesDespachos()
{
	$this->p     = [];
	$codDespacho = isset($_GET["coddespacho"]) ? limpiar(decrypt($_GET["coddespacho"])) : '';
    $codSucursal = isset($_GET["codsucursal"]) ? limpiar(decrypt($_GET["codsucursal"])) : '';
    $sql = "SELECT
	ddesp.*,
	ma.nommarca,
	mo.nommodelo,
	pr.nompresentacion,
	co.nomcolor
	FROM
	    detalledespachos ddesp
	LEFT JOIN 
	    marcas ma ON ddesp.codmarca = ma.codmarca
	LEFT JOIN 
	    modelos mo ON ddesp.codmodelo = mo.codmodelo 
	LEFT JOIN 
	    presentaciones pr ON ddesp.codpresentacion = pr.codpresentacion
	LEFT JOIN 
	    colores co ON ddesp.codcolor = co.codcolor 
	WHERE ddesp.coddespacho = ? AND ddesp.codsucursal = ?";
	try {
        $stmt = $this->dbh->prepare($sql);
        $stmt->execute([$codDespacho,$codSucursal]);
        $this->p = $stmt->fetchAll(PDO::FETCH_ASSOC);
        return $this->p;
    } catch (PDOException $e) {
        // Manejo de errores: registra el error y devuelve un array vacío
        error_log("Error en VerDetallesDespachos: " . $e->getMessage() . " SQL: " . $sql . " Params: " . json_encode([$codDespacho,$codSucursal]));
        return [];
    }
}
##################### FUNCION VER DETALLES DESPACHOS #########################

######################## FUNCION ACTUALIZAR DESPACHOS #######################
public function ActualizarDespachos()
{
	$this->p = [];
	if(empty($_POST["coddespacho"]) or empty($_POST["codsucursal"]))
	{
		echo "1";
		exit;
	}

	################### SELECCIONE LOS DATOS DEL CLIENTE ######################
    $sql = "SELECT
    clientes.codcliente,
	clientes.tipocliente,
	clientes.documcliente,
	clientes.dnicliente,
	CONCAT(if(clientes.tipocliente='JURIDICO',clientes.razoncliente,clientes.nomcliente)) as nomcliente,
	clientes.girocliente,
	clientes.tlfcliente,
	clientes.id_ciudad,
	clientes.id_comuna,
	clientes.direccliente,
	clientes.emailcliente,
	clientes.limitecredito,
	ciudades.codciudad,
	ciudades.ciudad,
	comunas.codcomuna,
	comunas.comuna
    FROM clientes
    LEFT JOIN ciudades ON clientes.id_ciudad = ciudades.id_ciudad 
    LEFT JOIN comunas ON clientes.id_comuna = comunas.id_comuna 
    WHERE clientes.dnicliente = ? 
    AND clientes.codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(limpiar($_POST['nrodocumento']),limpiar(decrypt($_POST["codsucursal"]))));
	$num = $stmt->rowCount();
	if($row = $stmt->fetch(PDO::FETCH_ASSOC))
	{
		$p[] = $row;
	}
    $codcliente    = (empty($row['codcliente']) ? "0" : $row['codcliente']);
    $tipocliente   = (empty($row['tipocliente']) ? "0" : $row['tipocliente']);
    $dnicliente    = (empty($row['dnicliente']) ? "0" : $row['dnicliente']);
    $nomcliente    = (empty($row['nomcliente']) ? "0" : $row['nomcliente']);
    $girocliente   = (empty($row['girocliente']) ? "0" : $row['girocliente']);
    $emailcliente  = (empty($row['emailcliente']) ? "0" : $row['emailcliente']);
    $ciudad        = (empty($row['id_ciudad']) ? "0" : $row['ciudad']);
    $comuna        = (empty($row['id_comuna']) ? "0" : $row['comuna']);
    $direccliente  = (empty($row['direccliente']) ? "0" : $row['direccliente']);
    $limitecredito = (empty($row['limitecredito']) ? "0.00" : $row['limitecredito']);
    ################### SELECCIONE LOS DATOS DEL CLIENTE ######################

	for($i=0;$i<count($_POST['coddetalledespacho']);$i++){  //recorro el array
        if (!empty($_POST['coddetalledespacho'][$i])) {

	        if($_POST['cantdespacho'][$i]==0){

		        echo "2";
		        exit();
	        }
        }
    }

	$this->dbh->beginTransaction();
	for($i=0;$i<count($_POST['coddetalledespacho']);$i++){  //recorro el array
	if (!empty($_POST['coddetalledespacho'][$i])) {

	$sql = "SELECT 
	cantdespacho 
	FROM detalledespachos 
	WHERE coddetalledespacho = '".limpiar($_POST['coddetalledespacho'][$i])."' 
	AND coddespacho = '".limpiar(decrypt($_POST["coddespacho"]))."' 
	AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
		
		$cantidadbd = $row['cantdespacho'];

		if($cantidadbd != $_POST['cantdespacho'][$i]){

		if($_POST['tipodetalle'][$i] == 1 && $_POST["inventarios"] == 1){//SI EL DETALLE ES UN PRODUCTO

			############ CONSULTO LA EXISTENCIA DE PRODUCTO EN ALMACEN ############
		    $sql = "SELECT 
		    existencia 
		    FROM productos 
		    WHERE idproducto = '".limpiar($_POST['idproducto'][$i])."' 
		    AND codproducto = '".limpiar($_POST['codproducto'][$i])."' 
		    AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
			foreach ($this->dbh->query($sql) as $row)
			{
				$this->p[] = $row;
			}
			$existenciabd  = $row['existencia'];
			$cantidad      = $_POST["cantdespacho"][$i];
			$cantidadbd    = $_POST["cantdespachobd"][$i];
		    $totaldespacho = $cantidad-$cantidadbd;
			############ CONSULTO LA EXISTENCIA DE PRODUCTO EN ALMACEN ############

		    ############## ACTUALIZAMOS EXISTENCIA DEL PRODUCTO EN ALMACEN ##############
			$sql2 = "UPDATE productos set "
			." existencia = ? "
			." WHERE "
			." idproducto = '".limpiar($_POST['idproducto'][$i])."' 
		    AND codproducto = '".limpiar($_POST["codproducto"][$i])."' 
			AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."';
			";
			$stmt = $this->dbh->prepare($sql2);
			$stmt->bindParam(1, $existencia);
			$existencia = $_POST["opcionvendido"][$i] == "2" ? number_format($existenciabd-$totaldespacho, 3, '.', '') : number_format($existenciabd-$totaldespacho, 0, '.', '');
			$stmt->execute();
		    ############## ACTUALIZAMOS EXISTENCIA DEL PRODUCTO EN ALMACEN ##############

		    ############### ACTUALIZAMOS LOS DATOS DEL PRODUCTO EN KARDEX ###############
			$sql3 = " UPDATE kardex set "
			." salidas = ?, "
			." stockactual = ? "
			." WHERE "
			." codproceso = '".limpiar($_POST["coddespacho"])."' 
			AND codproducto = '".limpiar($_POST["codproducto"][$i])."' 
			AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'
			AND tipokardex = 1
			AND procedimiento = 1;
			";
			$stmt = $this->dbh->prepare($sql3);
			$stmt->bindParam(1, $salidas);
			$stmt->bindParam(2, $existencia);
			
			$salidas    = $_POST["opcionvendido"][$i] == "2" ? number_format($_POST["cantdespacho"][$i], 3, '.', '') : number_format($_POST["cantdespacho"][$i], 0, '.', '');
			$existencia = $_POST["opcionvendido"][$i] == "2" ? number_format($existenciabd-$totaldespacho, 3, '.', '') : number_format($existenciabd-$totaldespacho, 0, '.', '');
			$stmt->execute();
			############### ACTUALIZAMOS LOS DATOS DEL PRODUCTO EN KARDEX ###############

	   } elseif(limpiar($_POST['tipodetalle'][$i]) == 2 && $_POST["inventarios"] == 1){ // SI EL DETALLE ES UN COMBO

	        ############## VERIFICO LA EXISTENCIA DEL COMBO EN ALMACEN #################
	    	$sql = "SELECT 
	    	existencia 
	    	FROM combos 
	    	WHERE idcombo = '".limpiar($_POST['idproducto'][$i])."' 
		    AND codcombo = '".limpiar($_POST["codproducto"][$i])."'
	    	AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
	    	foreach ($this->dbh->query($sql) as $row)
	    	{
	    		$this->p[] = $row;
	    	}
	    	$existenciacombobd = $row['existencia'];
			$cantidad          = $_POST["cantdespacho"][$i];
			$cantidadbd        = $_POST["cantdespachobd"][$i];
		    $totaldespacho     = $cantidad-$cantidadbd;
	        ############## VERIFICO LA EXISTENCIA DEL COMBO EN ALMACEN #################

		    ##################### ACTUALIZO LA EXISTENCIA DEL COMBO DEL ALMACEN ####################
			$sql = " UPDATE combos set "
			." existencia = ? "
		    ." WHERE "
			." idcombo = '".limpiar($_POST['idproducto'][$i])."' 
		    AND codcombo = '".limpiar($_POST["codproducto"][$i])."'
		    AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."';
		    ";
			$stmt = $this->dbh->prepare($sql);
			$stmt->bindParam(1, $existencia);

			$existencia = $_POST["opcionvendido"][$i] == "2" ? number_format($existenciacombobd-$totaldespacho, 3, '.', '') : number_format($existenciabd-$totaldespacho, 0, '.', '');
			$stmt->execute();
			##################### ACTUALIZO LA EXISTENCIA DEL COMBO DEL ALMACEN ####################

			############### ACTUALIZAMOS LOS DATOS DEL COMBO EN KARDEX ###############
			$sql3 = " UPDATE kardex set "
			." salidas = ?, "
			." stockactual = ? "
			." WHERE "
			." codproceso = '".limpiar($_POST["coddespacho"])."' 
			AND codproducto = '".limpiar($_POST["codproducto"][$i])."' 
			AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'
			AND tipokardex = 2
			AND procedimiento = 2;
			";
			$stmt = $this->dbh->prepare($sql3);
			$stmt->bindParam(1, $salidas);
			$stmt->bindParam(2, $existencia);
			
			$salidas    = $_POST["opcionvendido"][$i] == "2" ? number_format($_POST["cantdespacho"][$i], 3, '.', '') : number_format($_POST["cantdespacho"][$i], 0, '.', '');
			$existencia = $_POST["opcionvendido"][$i] == "2" ? number_format($existenciacombobd-$totaldespacho, 3, '.', '') : number_format($existenciabd-$totaldespacho, 0, '.', '');
			$stmt->execute();
			############### ACTUALIZAMOS LOS DATOS DEL COMBO EN KARDEX ###############	
	   
	    } elseif(limpiar($_POST['tipodetalle'][$i]) == 3 && $_POST["inventarios"] == 1){ // SI EL DETALLE ES UN COMBO

	    	############### ACTUALIZAMOS LOS DATOS DEL SERVICIO EN KARDEX ###############
			$sql3 = " UPDATE kardex set "
			." salidas = ?, "
			." stockactual = ? "
			." WHERE "
			." codproceso = '".limpiar($_POST["coddespacho"])."' 
			AND codproducto = '".limpiar($_POST["codproducto"][$i])."' 
			AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'
			AND procedimiento = 3;
			";
			$stmt = $this->dbh->prepare($sql3);
			$stmt->bindParam(1, $salidas);
			$stmt->bindParam(2, $existencia);
			
			$salidas     = $_POST["opcionvendido"][$i] == "2" ? number_format($_POST["cantdespacho"][$i], 3, '.', '') : number_format($_POST["cantdespacho"][$i], 0, '.', '');
			$stockactual = $_POST["opcionvendido"][$i] == "2" ? "0.000" : "0";
			$stmt->execute();
			############### ACTUALIZAMOS LOS DATOS DEL SERVICIO EN KARDEX ###############	
	    }

		$query = "UPDATE detalledespachos set"
		." cantdespacho = ?, "
		." valortotal = ?, "
		." totaldescuentov = ?, "
	    ." subtotalimpuestos = ?, "
		." valorneto = ?, "
		." valorneto2 = ? "
		." WHERE "
		." coddetalledespacho = ? AND coddespacho = ? AND codsucursal = ?;
		";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $cantdespacho);
		$stmt->bindParam(2, $valortotal);
		$stmt->bindParam(3, $totaldescuentov);
	    $stmt->bindParam(4, $subtotalimpuestos);
		$stmt->bindParam(5, $valorneto);
		$stmt->bindParam(6, $valorneto2);
		$stmt->bindParam(7, $coddetalledespacho);
		$stmt->bindParam(8, $coddespacho);
		$stmt->bindParam(9, $codsucursal);

		$cantdespacho       = limpiar($_POST['cantdespacho'][$i]);
		$preciocompra       = limpiar($_POST['preciocompra'][$i]);
		$precioventa        = limpiar($_POST['precioventa'][$i]);
		$ivaproducto        = limpiar($_POST['ivaproducto'][$i]);
		$descuento          = $_POST['descproducto'][$i]/100;
		$valortotal         = number_format($_POST['valortotal'][$i], 2, '.', '');
		$totaldescuento     = number_format($_POST['totaldescuentov'][$i], 2, '.', '');
	    $subtotalimpuestos  = number_format($_POST['subtotalimpuestos'][$i], 0, '.', '');
		$valorneto          = number_format($_POST['valorneto'][$i], 2, '.', '');
		$valorneto2         = number_format($_POST['valorneto2'][$i], 2, '.', '');
		$coddetalledespacho = limpiar($_POST['coddetalledespacho'][$i]);
		$coddespacho        = limpiar(decrypt($_POST["coddespacho"]));
		$codsucursal        = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();

		} else {

                    echo "";
		        }
	        }
        }
        $this->dbh->commit();

        ############ ACTUALIZO LOS TOTALES EN DESPACHO ##############
		$sql = " UPDATE despachos SET "
		." codcliente = ?, "
		." tipodespacho = ?, "
		." subtotalivasi = ?, "
		." subtotalivano = ?, "
		." totaliva = ?, "
		." descontado = ?, "
		." descuento = ?, "
		." totaldescuento = ?, "
		." totalpago = ?, "
		." totalpago2= ?, "
		." observaciones = ? "
		." WHERE "
		." coddespacho = ? AND codsucursal = ?;
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $codcliente);
		$stmt->bindParam(2, $tipodespacho);
		$stmt->bindParam(3, $subtotalivasi);
		$stmt->bindParam(4, $subtotalivano);
		$stmt->bindParam(5, $totaliva);
		$stmt->bindParam(6, $descontado);
		$stmt->bindParam(7, $descuento);
		$stmt->bindParam(8, $totaldescuento);
		$stmt->bindParam(9, $totalpago);
		$stmt->bindParam(10, $totalpago2);
		$stmt->bindParam(11, $observaciones);
		$stmt->bindParam(12, $coddespacho);
		$stmt->bindParam(13, $codsucursal);

        $tipodocumento  = limpiar($_POST["tipodocumento"]);
        $tipodespacho   = limpiar($_POST["tipodespacho"]);
		$subtotalivasi  = number_format($_POST["txtsubtotal"], 2, '.', '');
		$subtotalivano  = number_format($_POST["txtsubtotal2"], 2, '.', '');
		$totaliva       = number_format($_POST["txtIva"], 2, '.', '');
		$descontado     = number_format($_POST["txtdescontado"], 2, '.', '');
		$descuento      = limpiar($_POST["descuento"]);
		$totaldescuento = number_format($_POST["txtDescuento"], 2, '.', '');
		$totalpago      = number_format($_POST["txtTotal"], 2, '.', '');
		$totalpago2     = number_format($_POST["txtTotalCompra"], 2, '.', '');
		$observaciones  = limpiar($_POST["observaciones"]);
		$coddespacho    = limpiar(decrypt($_POST["coddespacho"]));
		$codsucursal    = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();
		############ ACTUALIZO LOS TOTALES EN DESPACHO ##############

    echo "<span class='fa fa-check-square-o'></span> EL DESPACHO DE PRODUCTOS HA SIDO ACTUALIZADO EXITOSAMENTE <a href='reportepdf?coddespacho=".encrypt($coddespacho)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt($tipodocumento)."' class='on-default' data-placement='left' data-toggle='tooltip' data-original-title='Imprimir Documento' target='_black' rel='noopener noreferrer'><font color='black'><strong>IMPRIMIR REPORTE</strong></font color></a></div>";

    echo "<script>VentanaCentrada('reportepdf?coddespacho=".encrypt($coddespacho)."&codsucursal=".encrypt($codsucursal)."&tipo=".encrypt($tipodocumento)."', '', '', '1024', '568', 'true');</script>";
	exit;
}
####################### FUNCION ACTUALIZAR DESPACHOS ############################

####################### FUNCION AGREGAR DETALLES DESPACHOS ########################
public function AgregarDetallesDespachos()
{
	$this->p = [];
	if(empty($_POST["coddespacho"]) or empty($_POST["codsucursal"]))
	{
		echo "1";
		exit;
	}
    elseif(empty($_SESSION["CarritoDespacho"]) || $_POST["txtTotal"]=="0.00")
	{
		echo "2";
		exit;
	}

	############ VALIDO SI LA CANTIDAD ES MAYOR QUE LA EXISTENCIA #############
	$v = $_SESSION["CarritoDespacho"];
    for ($i = 0, $iMax = count($v); $i < $iMax; $i++) {

		if(limpiar($v[$i]['tipodetalle']) == 1 && $_POST["inventarios"] == 1){

			$sql = "SELECT 
			existencia
			FROM productos 
			WHERE idproducto = '".limpiar($v[$i]['id'])."' 
			AND codproducto = '".limpiar($v[$i]['txtCodigo'])."' 
			AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
			foreach ($this->dbh->query($sql) as $row)
			{
				$this->p[] = $row;
			}
			
			$existenciabd = $row['existencia'];
			$cantidad     = $v[$i]['cantidad'];

			if ($cantidad > $existenciabd) 
			{ 
				echo "3";
				exit;
			}

		} elseif(limpiar($v[$i]['tipodetalle']) == 2 && $_POST["inventarios"] == 1){ // SI EL DETALLE ES UN COMBO

			$sql = "SELECT 
		    existencia 
		    FROM combos 
		    WHERE idcombo = '".limpiar($v[$i]['id'])."' 
			AND codcombo = '".limpiar($v[$i]['txtCodigo'])."'
		    AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		    foreach ($this->dbh->query($sql) as $row)
		    {
			   $this->p[] = $row;
		    }
		
		    $existenciabd = $row['existencia'];
		    $cantidad     = $v[$i]['cantidad'];

	        if ($cantidad > $existenciabd) 
	        { 
		        echo "4";
		        exit;
	        }

		    ############## VERIFICO SI EL COMBO TIENE PRODUCTO RELACIONADOS #################
		    $sql = "SELECT * FROM combosxproductos WHERE codcombo = ? AND codsucursal = ?";
			$stmt = $this->dbh->prepare($sql);
			$stmt->execute(array($v[$i]['txtCodigo'],limpiar(decrypt($_POST["codsucursal"]))));
			$num = $stmt->rowCount();
	        if($num>0) {  

	        	$sql = "SELECT 
	        	combosxproductos.codcombo,
	    	    combosxproductos.idproducto,
	        	combosxproductos.codproducto,
	        	combosxproductos.cantidad,
	        	combosxproductos.codsucursal,
	        	productos.existencia
	        	FROM combosxproductos 
	        	LEFT JOIN productos ON combosxproductos.codproducto = productos.codproducto 
	        	WHERE combosxproductos.codcombo IN ('".limpiar($v[$i]['txtCodigo'])."') 
	        	AND combosxproductos.codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."' 
	    	    AND productos.codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
	        	foreach ($this->dbh->query($sql) as $row)
			    { 
				    $this->p[] = $row;

				    $cantracionbd2  = $row['cantidad'];
				    $idproductobd2  = $row['idproducto'];
				    $codproductobd2 = $row['codproducto'];
				    $existenciabd2  = $row['existencia'];
			        $racion         = number_format($cantracionbd2*$v[$i]['cantidad'], 2, '.', '');

			        if ($racion > $existenciabd2) 
			        { 
			        	echo "5";
			        	exit;
			        }
			    }
		    }//fin de consulta de productos de combos	
		    ############## VERIFICO SI EL COMBO TIENE PRODUCTO RELACIONADOS #################
	    }
	}
	############ VALIDO SI LA CANTIDAD ES MAYOR QUE LA EXISTENCIA #############

	################### SELECCIONE LOS DATOS DEL CLIENTE ######################
    $sql = "SELECT
    clientes.codcliente,
	clientes.tipocliente,
	clientes.documcliente,
	clientes.dnicliente,
	CONCAT(if(clientes.tipocliente='JURIDICO',clientes.razoncliente,clientes.nomcliente)) as nomcliente,
	clientes.girocliente,
	clientes.tlfcliente,
	clientes.id_ciudad,
	clientes.id_comuna,
	clientes.direccliente,
	clientes.emailcliente,
	clientes.limitecredito,
	ciudades.codciudad,
	ciudades.ciudad,
	comunas.codcomuna,
	comunas.comuna
    FROM clientes
    LEFT JOIN ciudades ON clientes.id_ciudad = ciudades.id_ciudad 
    LEFT JOIN comunas ON clientes.id_comuna = comunas.id_comuna 
    WHERE clientes.dnicliente = ? 
    AND clientes.codsucursal = ?";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute(array(limpiar($_POST['nrodocumento']),limpiar(decrypt($_POST["codsucursal"]))));
	$num = $stmt->rowCount();
	if($row = $stmt->fetch(PDO::FETCH_ASSOC))
	{
		$p[] = $row;
	}
    $codcliente    = (empty($row['codcliente']) ? "0" : $row['codcliente']);
    $tipocliente   = (empty($row['tipocliente']) ? "0" : $row['tipocliente']);
    $dnicliente    = (empty($row['dnicliente']) ? "0" : $row['dnicliente']);
    $nomcliente    = (empty($row['nomcliente']) ? "0" : $row['nomcliente']);
    $girocliente   = (empty($row['girocliente']) ? "0" : $row['girocliente']);
    $emailcliente  = (empty($row['emailcliente']) ? "0" : $row['emailcliente']);
    $ciudad        = (empty($row['id_ciudad']) ? "0" : $row['ciudad']);
    $comuna        = (empty($row['id_comuna']) ? "0" : $row['comuna']);
    $direccliente  = (empty($row['direccliente']) ? "0" : $row['direccliente']);
    $limitecredito = (empty($row['limitecredito']) ? "0.00" : $row['limitecredito']);
    ################### SELECCIONE LOS DATOS DEL CLIENTE ######################

	############ CONSULTO TOTAL ACTUAL DE DESPACHO ##############
	$sql = "SELECT
	codfactura,
	descuento,
	totalpago 
	FROM despachos 
	WHERE coddespacho = '".limpiar(decrypt($_POST["coddespacho"]))."' 
	AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
	foreach ($this->dbh->query($sql) as $row)
	{
		$this->p[] = $row;
	}
	$codfacturabd = $row['codfactura'];
	$descuentobd  = $row['descuento'];
	$totalpagobd  = $row['totalpago'];
	############ CONSULTO TOTAL ACTUAL DE DESPACHO ##############

    $this->dbh->beginTransaction();
    $detalle = $_SESSION["CarritoDespacho"];
	for($i=0;$i<count($detalle);$i++){

	$sql = "SELECT 
	coddespacho, 
	codproducto 
	FROM detalledespachos 
	WHERE coddespacho = '".limpiar(decrypt($_POST['coddespacho']))."' 
	AND codsucursal = '".limpiar(decrypt($_POST['codsucursal']))."' 
	AND idproducto = '".limpiar($detalle[$i]['id'])."' 
	AND codproducto = '".limpiar($detalle[$i]['txtCodigo'])."'";
	$stmt = $this->dbh->prepare($sql);
	$stmt->execute();
	$num = $stmt->rowCount();
	if($num == 0)
	{
        $query = "INSERT INTO detalledespachos values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ¿); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $coddespacho);
	    $stmt->bindParam(2, $idproducto);
	    $stmt->bindParam(3, $codproducto);
	    $stmt->bindParam(4, $producto);
	    $stmt->bindParam(5, $descripcion);
        $stmt->bindParam(6, $opcionvendido);
	    $stmt->bindParam(7, $imei);
	    $stmt->bindParam(8, $condicion);
	    $stmt->bindParam(9, $codmarca);
	    $stmt->bindParam(10, $codmodelo);
	    $stmt->bindParam(11, $codpresentacion);
	    $stmt->bindParam(12, $codcolor);
		$stmt->bindParam(13, $cantidad);
		$stmt->bindParam(14, $preciocompra);
		$stmt->bindParam(15, $precioventa);
		$stmt->bindParam(16, $ivaproducto);
		$stmt->bindParam(17, $descproducto);
		$stmt->bindParam(18, $valortotal);
		$stmt->bindParam(19, $totaldescuentov);
		$stmt->bindParam(20, $subtotalimpuestos);
		$stmt->bindParam(21, $valorneto);
		$stmt->bindParam(22, $valorneto2);
		$stmt->bindParam(23, $tipodetalle);
		$stmt->bindParam(24, $codsucursal);
			
		$coddespacho = limpiar($_POST["coddespacho"]);
		$idproducto      = limpiar($detalle[$i]['tipodetalle'] == "3" ? "0" : $detalle[$i]['id']);
		$codproducto     = limpiar($detalle[$i]['tipodetalle'] == "3" ? "0" : $detalle[$i]['txtCodigo']);
		$producto        = limpiar($detalle[$i]['producto']);
		$descripcion     = limpiar($detalle[$i]['tipodetalle'] == "3" || $detalle[$i]['descripcion'] == "0" ? "" : $detalle[$i]['descripcion']);
		$opcionvendido   = limpiar($detalle[$i]['opcionvendido']);
		$imei            = limpiar($detalle[$i]['tipodetalle'] == "3" || $detalle[$i]['imei'] == "0" ? "" : $detalle[$i]['imei']);
		$condicion       = limpiar($detalle[$i]['tipodetalle'] == "3" || $detalle[$i]['condicion'] == "0" ? "" : $detalle[$i]['condicion']);
		$codmarca        = limpiar($detalle[$i]['tipodetalle'] == "3" ? "0" : $detalle[$i]['codmarca']);
		$codmodelo       = limpiar($detalle[$i]['tipodetalle'] == "3" ? "0" : $detalle[$i]['codmodelo']);
		$codpresentacion = limpiar($detalle[$i]['tipodetalle'] == "3" ? "0" : $detalle[$i]['codpresentacion']);
		$codcolor        = limpiar($detalle[$i]['tipodetalle'] == "3" ? "0" : $detalle[$i]['codcolor']);
		$cantidad        = $detalle[$i]['opcionvendido'] == "2" ? number_format($detalle[$i]['cantidad'], 3, '.', '') : number_format($detalle[$i]['cantidad'], 0, '.', '');
		$preciocompra    = limpiar($detalle[$i]['precio']);
		$precioventa     = limpiar($detalle[$i]['precio2']);
		$precioconiva    = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['precio2']);
		$ivaproducto     = limpiar($detalle[$i]['ivaproducto'] == "(E)" ? "0.00" : $detalle[$i]['ivaproducto']);
		$descproducto    = limpiar($detalle[$i]['descproducto']);
		$descuento       = $detalle[$i]['descproducto']/100;
		$valortotal      = number_format($detalle[$i]['precio2']*$detalle[$i]['cantidad'], 2, '.', '');
		$totaldescuentov = number_format($valortotal*$descuento, 2, '.', '');

		//CALCULO SUBTOTAL IMPUESTOS
		$ValorImpuesto        = 1 + ($_POST["iva"]/100);
		$RestoDescuento       = $precioconiva * $detalle[$i]['descproducto'] / 100;
		$PrecioIvaDescuento   = $precioconiva - $RestoDescuento;
		$Discriminado         = $PrecioIvaDescuento/$ValorImpuesto;
		$SubtotalDiscriminado = $PrecioIvaDescuento - $Discriminado;
	    $BaseDiscriminado     = $SubtotalDiscriminado * $detalle[$i]['cantidad'];
	    $subtotalimpuestos    = number_format($BaseDiscriminado, 2, '.', '');

	    $valorneto      = number_format($valortotal-$totaldescuentov, 2, '.', '');
		$valorneto2     = limpiar($detalle[$i]['tipodetalle'] == "3" ? "0.00" : number_format($detalle[$i]['precio']*$detalle[$i]['cantidad'], 2, '.', ''));
	    $tipodetalle    = limpiar($detalle[$i]['tipodetalle']);
		$codsucursal    = limpiar(decrypt($_POST["codsucursal"]));
		$stmt->execute();

	if(limpiar($detalle[$i]['tipodetalle']) == 1 && $_POST["inventarios"] == 1){ // SI EL DETALLE ES UN PRODUCTO

		################ VERIFICO LA EXISTENCIA DEL PRODUCTO EN ALMACEN ################
		$sql = "SELECT * FROM productos 
		WHERE idproducto = '".limpiar($detalle[$i]['id'])."' 
	    AND codproducto = '".limpiar($detalle[$i]['txtCodigo'])."'
		AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."'";
		foreach ($this->dbh->query($sql) as $row)
		{
			$this->p[] = $row;
		}
		$existenciabd = $row['existencia'];
	    ################ VERIFICO LA EXISTENCIA DEL PRODUCTO EN ALMACEN ################

		##################### ACTUALIZO LA EXISTENCIA DEL ALMACEN ####################
		$sql = " UPDATE productos set "
		." existencia = ? "
		." WHERE "
		." idproducto = '".limpiar($detalle[$i]['id'])."' 
	    AND codproducto = '".limpiar($detalle[$i]['txtCodigo'])."' 
		AND codsucursal = '".limpiar(decrypt($_POST["codsucursal"]))."';
		";
		$stmt = $this->dbh->prepare($sql);
		$stmt->bindParam(1, $existencia);
		$cantdespacho  = $detalle[$i]['opcionvendido'] == "2" ? number_format($detalle[$i]['cantidad'], 3, '.', '') : number_format($detalle[$i]['cantidad'], 0, '.', '');
		$existencia = $detalle[$i]['opcionvendido'] == "2" ? number_format($existenciabd-$detalle[$i]['cantidad'], 3, '.', '') : number_format($existenciabd-$detalle[$i]['cantidad'], 0, '.', '');
		$stmt->execute();
	    ##################### ACTUALIZO LA EXISTENCIA DEL ALMACEN ####################

	    ############### REGISTRAMOS LOS DATOS DE PRODUCTOS EN KARDEX ###############
	    $query = "INSERT INTO kardex values (null, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); ";
		$stmt = $this->dbh->prepare($query);
		$stmt->bindParam(1, $coddespacho);
		$stmt->bindParam(2, $codcliente);
		$stmt->bindParam(3, $codproducto);
		$stmt->bindParam(4, $movimiento);
		$stmt->bindParam(5, $entradas);
		$stmt->bindParam(6, $salidas);
		$stmt->bindParam(7, $devolucion);
		$stmt->bindParam(8, $stockactual);
		$stmt->bindParam(9, $ivaproducto);
		$stmt->bindParam(10, $descproducto);
		$stmt->bindParam(11, $precio);
		$stmt->bindParam(12, $documento);
		$stmt->bindParam(13, $fechakardex);	
	    $stmt->bindParam(14, $tipokardex);
	    $stmt->bindParam(15, $procedimiento);		
		$stmt->bindParam(16, $codsucursal);
		$stmt->bindParam(17, $codigo);

		$codcliente    = limpiar($_POST["codcliente"] == 0 ? "0" : $_POST["codcliente"]);
		$codproducto   = limpiar($detalle[$i]['txtCodigo']);
		$movimiento    = limpiar("SALIDAS");
		$entradas      = $detalle[$i]['opcionvendido'] == "2" ? "0.000" : "0";
		$salidas       = $detalle[$i]['opcionvendido'] == "2" ? number_format($detalle[$i]['cantidad'], 3, '.', '') : number_format($detalle[$i]['cantidad'], 0, '.', '');
		$devolucion    = $detalle[