<?php
// Carga las dependencias necesarias
require_once __DIR__ . '/../vendor/autoload.php';
require_once __DIR__ . '/funciones_basicas.php';
require_once 'timezones_class.php';

// Carga las variables de entorno desde el archivo .env
$dotenv = Dotenv\Dotenv::createUnsafeImmutable(__DIR__.'/../');
$dotenv->safeLoad();

use Illuminate\Database\Capsule\Manager as Capsule;

// Configuración de la zona horaria y localización
date_default_timezone_set('America/Santiago');
setlocale(LC_ALL, 'es_VE.UTF-8', 'es_VE', 'esp');

// Configuración de la conexión Laravel Eloquent (mantenida por si la necesitas)
$capsule = new Capsule();
$capsule->addConnection([
    'driver'    => 'mysql',
    'host'      => $_ENV['DB_HOST'],
    'database'  => $_ENV['DB_DATABASE'],
    'username'  => $_ENV['DB_USERNAME'],
    'password'  => $_ENV['DB_PASSWORD'],
    'charset'   => 'utf8',
    'collation' => 'utf8_unicode_ci',
    'prefix'    => '',
]);
$capsule->setAsGlobal();

// ---

## Clase de Conexión a la Base de Datos (Patrón Singleton)
class Db
{
    // dbh debe ser privado para asegurar que solo se gestione internamente
    private $dbh;
    // Para el patrón Singleton
    private static $instance = null;

    // El constructor es privado (evita instanciación directa)
    private function __construct()
    {
        $dbHost     = $_ENV['DB_HOST'] ?? 'localhost';
        $dbUsername = $_ENV['DB_USERNAME'] ?? 'setecchilepos_minimarketdonche';
        $dbPassword = $_ENV['DB_PASSWORD'] ?? 'ngI7sMTi34ro';
        $dbName     = $_ENV['DB_DATABASE'] ?? 'setecchilepos_minimarketdonche';

        $arrOptions = [
            PDO::ATTR_EMULATE_PREPARES   => false,
            PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
            PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES 'utf8'",
        ];

        try {
            $this->dbh = new PDO(
                "mysql:host={$dbHost};dbname={$dbName}",
                $dbUsername,
                $dbPassword,
                $arrOptions
            );
        } catch (PDOException $e) {
            // Manejo de errores de conexión. En producción, solo registra el error.
            error_log("Error de conexión a la base de datos: " . $e->getMessage());
            die('Failed to connect with MySQL. Please try again later.');
        }
    }

    // El método estático que devuelve la única instancia de la conexión
    public static function getInstance(): PDO
    {
        if (self::$instance === null) {
            self::$instance = new self(); // Llama al constructor privado
        }
        return self::$instance->dbh; // Retorna el objeto PDO
    }

    // Métodos para prevenir la clonación y deserialización
    private function __clone() {}

    public function __wakeup()
    {
        throw new Exception("Cannot unserialize a singleton.");
    }
}