<?php
// Iniciar la sesión si no está iniciada.
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Limpiar todas las variables de sesión
$_SESSION = array();

// Destruir la cookie de sesión si existe
if (isset($_COOKIE[session_name()])) {
    // Obtener los parámetros de la cookie para asegurar que se borre correctamente
    // Mantener los mismos path, domain, secure y httponly es crucial
    $params = session_get_cookie_params();
    setcookie(
        session_name(), // Nombre de la cookie de sesión (ej. PHPSESSID)
        '',             // Vaciar su valor
        time() - 42000, // Establecer una fecha de expiración en el pasado
        $params["path"],
        $params["domain"],
        $params["secure"],
        $params["httponly"]
    );
}

// Finalmente, destruir la sesión en el servidor
session_destroy();

// Redirigir al usuario al index de forma segura y eficiente
header("Location: index");
exit(); // Es fundamental para asegurar que el script se detenga aquí y no se envíe ningún otro output.
?>