<?php
require_once('class/class.php');
$accesos = ['administradorG', 'administradorS', 'secretaria', 'cajero', 'vendedor'];
validarAccesos($accesos) or die();

###################### DETALLE DE IMPUESTO ######################
$imp           = new Login();
$imp           = $imp->ImpuestosPorId();
$NomImpuesto   = (empty($imp) ? "Impuesto" : $imp[0]['nomimpuesto']);
$ValorImpuesto = (empty($imp) ? "0.00" : $imp[0]['valorimpuesto']);
###################### DETALLE DE IMPUESTO ######################
    
$tra = new Login();

############################# MUESTRO JSON PARA CLIENTES ############################
if (isset($_GET['CargaClientes']) && isset($_GET['tipobusqueda']) && isset($_GET['search_criterio'])) {

    $tipobusqueda    = limpiar($_GET['tipobusqueda']);
    $search_criterio = limpiar($_GET['search_criterio']);

    $reg = $tra->BusquedaClientes();

    $data = array();
    if (!empty($reg)) {
        $a = 1;
        foreach ($reg as $cliente) {

            #################### DETALLE DE ACCIONES ####################
            $acciones = '
            <span class="text-success" style="cursor: pointer;" data-toggle="modal" data-target="#myModalDetalle" title="Ver" onClick="VerCliente(\''.encrypt($cliente["codcliente"]).'\')"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-eye"><path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"></path><circle cx="12" cy="12" r="3"></circle></svg></span>

            <span class="text-info" style="cursor: pointer;" data-toggle="modal" data-target="#myModalCliente" title="Editar" onClick="UpdateCliente(\''.encrypt($cliente["codcliente"]).'\',\''.$cliente["tipocliente"].'\',\''.$documcliente = ($cliente["documcliente"] == 0 ? "" : $cliente["documcliente"]).'\',\''.$cliente["dnicliente"].'\',\''.$cliente["nomcliente"].'\',\''.$cliente["razoncliente"].'\',\''.$cliente["girocliente"].'\',\''.$cliente["tlfcliente"].'\',\''.$cliente['id_ciudad'].'\',\''.$cliente['ciudad'].'\',\''.$cliente['id_comuna'].'\',\''.$cliente['comuna'].'\',\''.$cliente["direccliente"].'\',\''.$cliente["emailcliente"].'\',\''.number_format($cliente['limitecredito'], 0, '.', '.').'\',\''.encrypt($cliente["codsucursal"]).'\',\'update\');  
            CargaTipoCliente(\''.$cliente["tipocliente"].'\');"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-edit"><path d="M11 4H4a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2v-7"></path><path d="M18.5 2.5a2.121 2.121 0 0 1 3 3L12 15l-4 1 1-4 9.5-9.5z"></path></svg></span>

            <span class="text-danger" style="cursor: pointer;" title="Eliminar" onClick="EliminarCliente(\''.encrypt($cliente["codcliente"]).'\',\''.encrypt($cliente["codsucursal"]).'\',\''.encrypt("CLIENTES").'\')"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-trash-2 icon"><polyline points="3 6 5 6 21 6"></polyline><path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"></path><line x1="10" y1="11" x2="10" y2="17"></line><line x1="14" y1="11" x2="14" y2="17"></line></svg></span>
            ';
            #################### DETALLE DE ACCIONES ####################

            $data[] = array(
                $a++,
                $cliente['tipocliente'], // Código como primer elemento para DataTables sorting
                $documento = ($cliente['documcliente'] == '0' ? "DOCUMENTO" : $cliente['documento'])." ".$cliente['dnicliente'],
                $tipocliente = ($cliente['tipocliente'] == 'NATURAL' ? $cliente['nomcliente'] : $cliente['razoncliente']),
                $tlfcliente = ($cliente['tlfcliente'] == '' ? "***********" : $cliente['tlfcliente']),
                $emailcliente = ($cliente['emailcliente'] == '' ? "***********" : $cliente['emailcliente']),
                $acciones
            );
        }

        $results = array(
            "draw" => isset($_GET['draw']) ? intval($_GET['draw']) : 1,
            "recordsTotal" => count($reg),
            "recordsFiltered" => count($reg),
            "data" => $data
        );

        header('Content-Type: application/json');
        echo json_encode($results);
        exit();

    } else {
        $results = array(
            "draw" => isset($_GET['draw']) ? intval($_GET['draw']) : 1,
            "recordsTotal" => 0,
            "recordsFiltered" => 0,
            "data" => []
        );
        header('Content-Type: application/json');
        echo json_encode($results);
        exit();
    }
############################# MUESTRO JSON PARA CLIENTES ############################


############################# MUESTRO JSON PARA PRODUCTOS ############################
} elseif (isset($_GET['CargaProductos']) && isset($_GET['tipobusqueda']) && isset($_GET['search_criterio']) && isset($_GET['familias']) && isset($_GET['marcas'])) {

    $tipobusqueda    = limpiar($_GET['tipobusqueda']);
    $search_criterio = limpiar($_GET['search_criterio']);
    $familia         = limpiar($_GET['familias']);
    $marca           = limpiar($_GET['marcas']);

    $reg = $tra->BusquedaProductosPorOpcion();

    $data = array();
    if (!empty($reg)) {
        foreach ($reg as $producto) {
            $monedaxmenor     = (empty($producto['montocambio']) ? "0.00" : number_format($producto['precioxmenor'] / $producto['montocambio'], 0, '.', '.'));
            $monedaxmayor     = (empty($producto['montocambio']) ? "0.00" : number_format($producto['precioxmayor'] / $producto['montocambio'], 0, '.', '.'));
            $monedaxpublico   = (empty($producto['montocambio']) ? "0.00" : number_format($producto['precioxpublico'] / $producto['montocambio'], 0, '.', '.'));
            $simbolo          = ($producto['simbolo'] == "" ? "" : "<strong>".$producto['simbolo']."</strong>");
            $simbolo2         = ($producto['simbolo2'] == "" ? "" : $producto['simbolo2']);

            #################### DETALLE DE FOTOS ####################
            $foto_url = '';
            if (file_exists("fotos/productos/".$producto["codsucursal"]."/".$producto["codproducto"].".jpg")){
                $foto_url = '<img src="fotos/productos/'.$producto["codsucursal"].'/'.$producto["codproducto"].'.jpg?" class="rounded-circle" style="margin:0px;" width="60" height="60" data-placement="left" title="Ver" data-original-title="" data-href="#" data-toggle="modal" data-target="#myModalImg" data-backdrop="static" data-keyboard="false" onClick="VerFoto(\''.encrypt($producto["codproducto"]).'\',\''.encrypt($producto["codsucursal"]).'\')">';

            } // ... (otros formatos de imagen) ...
            elseif (file_exists("fotos/productos/".$producto["codsucursal"]."/".$producto["codproducto"].".jpeg")){
                $foto_url = '<img src="fotos/productos/'.$producto["codsucursal"].'/'.$producto["codproducto"].'.jpeg?" class="rounded-circle" style="margin:0px;" width="60" height="60" data-placement="left" title="Ver" data-original-title="" data-href="#" data-toggle="modal" data-target="#myModalImg" data-backdrop="static" data-keyboard="false" onClick="VerFoto(\''.encrypt($producto["codproducto"]).'\',\''.encrypt($producto["codsucursal"]).'\')">';

            } // ... (otros formatos de imagen) ...
            elseif (file_exists("fotos/productos/".$producto["codsucursal"]."/".$producto["codproducto"].".png")){
                $foto_url = '<img src="fotos/productos/'.$producto["codsucursal"].'/'.$producto["codproducto"].'.png?" class="rounded-circle" style="margin:0px;" width="60" height="60" data-placement="left" title="Ver" data-original-title="" data-href="#" data-toggle="modal" data-target="#myModalImg" data-backdrop="static" data-keyboard="false" onClick="VerFoto(\''.encrypt($producto["codproducto"]).'\',\''.encrypt($producto["codsucursal"]).'\')">';
            } // ... (otros formatos de imagen) ...
            else {
                $foto_url = '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-image"><rect x="3" y="3" width="18" height="18" rx="2" ry="2"></rect><circle cx="8.5" cy="8.5" r="1.5"></circle><polyline points="21 15 16 10 5 21"></polyline></svg>';
                //$foto_url = '';
            }
            #################### DETALLE DE FOTOS ####################

            #################### DETALLE DE STOCK ####################
            $stock_badge = '';
            if($producto['existencia'] <= $producto['stockoptimo'] && $producto['existencia'] > $producto['stockmedio']){
                $stock_badge = "<abbr title='STOCK OPTIMO'><span class='badge badge-success font-12'>".number_format($producto['existencia'], 0, '.', '.')."</span></abbr>";
            } // ... (otros estados de stock) ...

            elseif($producto['existencia'] <= $producto['stockmedio'] && $producto['existencia'] > $producto['stockminimo']){
                
                $stock_badge = "<abbr title='STOCK MEDIO'><span class='badge badge-warning font-12'>".number_format($producto['existencia'], 0, '.', '.')."</span></abbr>";
            } // ... (otros estados de stock) ...

            elseif($producto['existencia'] <= $producto['stockminimo']){
                
                $stock_badge = "<abbr title='STOCK MINIMO'><span class='badge badge-danger font-12'>".number_format($producto['existencia'], 0, '.', '.')."</span></abbr>";
            } // ... (otros estados de stock) ...
            else {
                $stock_badge = number_format($producto['existencia'], 0, '.', '.');
            }
            #################### DETALLE DE STOCK ####################

            #################### DETALLE DE FECHAS ####################
            $fecha_actual     = date("Y-m-d");
            $fecha_optima     = $producto['fechaoptimo'];
            $fecha_media      = $producto['fechamedio'];
            $fecha_minima     = $producto['fechaminimo'];

            $nombre_fecha     = "";
            $color_fecha      = "******";
            if($fecha_optima != '0000-00-00' && $fecha_actual <= $fecha_optima){
            $nombre_fecha = "OPTIMA";
                $color_fecha  = "<abbr title='FECHA OPTIMA'><span class='badge badge-success font-12'>".$fecha_optima."</span></abbr>";
            } else if($fecha_media != '0000-00-00' && $fecha_actual <= $fecha_media){
                $nombre_fecha = "MEDIA";
                $color_fecha  = "<abbr title='FECHA MEDIA'><span class='badge badge-warning font-12'>".$fecha_media."</span></abbr>";
            } else if($fecha_minima != '0000-00-00' && $fecha_actual >= $fecha_minima){
                $nombre_fecha = "MINIMA";
                $color_fecha  = "<abbr title='FECHA MINIMA'><span class='badge badge-danger font-12'>".$fecha_minima."</span></abbr>";
            }
            #################### DETALLE DE FECHAS ####################

            #################### DETALLE DE ACCIONES ####################            
            $acciones = '
            <span class="text-success" style="cursor: pointer;" data-toggle="modal" data-target="#myModal" title="Ver" onClick="VerProducto(\''.encrypt($producto["codproducto"]).'\',\''.encrypt($producto["codsucursal"]).'\')"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-eye"><path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"></path><circle cx="12" cy="12" r="3"></circle></svg></span>';

            if($_SESSION['acceso']=="administradorS" || $_SESSION["acceso"]=="secretaria"){
            $acciones .= ' <div class="btn-group">
                    <span class="text-info" style="cursor: pointer;" data-toggle="dropdown" aria-haspopup="true" aria-expanded="true" style="border-radius:20px 20px 20px 20px;"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-edit"><path d="M11 4H4a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2v-7"></path><path d="M18.5 2.5a2.121 2.121 0 0 1 3 3L12 15l-4 1 1-4 9.5-9.5z"></path></svg></span>
                    <div class="dropdown-menu dropdown-menu-left" style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(164px, 35px, 0px);border-radius:15px 15px 15px 15px;">
                    <a class="dropdown-item" href="#" data-toggle="tooltip" data-placement="bottom" onClick="UpdateProducto(\''.encrypt($producto["codproducto"]).'\',\''.encrypt($producto["codsucursal"]).'\',1)" title="Editar"><span class="fa fa-pencil text-dark"></span> Producto #1</a>
                    <a class="dropdown-item" href="#" data-toggle="tooltip" data-placement="bottom" onClick="UpdateProducto(\''.encrypt($producto["codproducto"]).'\',\''.encrypt($producto["codsucursal"]).'\',2)" title="Editar"><span class="fa fa-pencil text-dark"></span> Producto #2</a>
                </div>
            </div>

            <span class="text-dark" style="cursor: pointer;" data-toggle="modal" data-target="#myModalEtiqueta" title="Etiquetas" onClick="EtiquetaProducto(\''.encrypt($producto["codproducto"]).'\',\''.encrypt($producto["codsucursal"]).'\',\''.$codigobarra = ($producto["codigobarra"] == "" ? $producto["codproducto"] : $producto["codigobarra"]).'\',\''.$producto["producto"].'\',\''.number_format($producto['precioxpublico'], 0, '.', '.').'\')"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-copy"><rect x="9" y="9" width="13" height="13" rx="2" ry="2"></rect><path d="M5 15H4a2 2 0 0 1-2-2V4a2 2 0 0 1 2-2h9a2 2 0 0 1 2 2v1"></path></svg></span>

            <span class="text-danger" style="cursor: pointer;" title="Eliminar" onClick="EliminarProducto(\''.encrypt($producto["codproducto"]).'\',\''.encrypt($producto["codsucursal"]).'\',2,\''.encrypt("PRODUCTOS").'\')"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-trash-2 icon"><polyline points="3 6 5 6 21 6"></polyline><path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"></path><line x1="10" y1="11" x2="10" y2="17"></line><line x1="14" y1="11" x2="14" y2="17"></line></svg></span>';
            } 
            #################### DETALLE DE ACCIONES ####################

            $data[] = array(
                $producto['codproducto'], // Código como primer elemento para DataTables sorting
                $foto_url,
                $producto['codproducto'],
                $producto['producto'],
                $stock_badge, // Elimina las etiquetas HTML para la búsqueda y ordenamiento
                $color_fecha,
                ($producto['fechaelaboracion'] == '' || $producto['fechaelaboracion'] == '0000-00-00' ? "*****" : date("d-m-Y",strtotime($producto['fechaelaboracion']))),
                ($producto['codmarca'] == '0' ? "*****" : $producto['nommarca']),
                ($producto['codmodelo'] == '0' ? "*****" : $producto['nommodelo']),
                "<small class='text-dark alert-link font-12'>
                COMPRA: ".$preciocompra = ($_SESSION['acceso'] == "administradorS" ? $simbolo.number_format($producto['preciocompra'], 0, '.', '.') : $simbolo."0.00")."<br>
                MAYORISTA: ".$simbolo.number_format($producto['precioxmayor'], 0, '.', '.')."<br>
                MINORISTA: ".$simbolo.number_format($producto['precioxmenor'], 0, '.', '.')."<br>
                PÚBLICO: ".$simbolo.number_format($producto['precioxpublico'], 0, '.', '.')."<br>
                </small>", // Sin el símbolo aquí
                ($producto['ivaproducto'] != '0' ? " (".number_format($ValorImpuesto, 0, '.', '.')."%)" : "(E)"),
                $simbolo.number_format($producto['descproducto'], 0, '.', '.'),
                ($producto['codigobarra'] == "" ? "*********" : $producto['codigobarra']),
                $acciones
            );
        }

        $results = array(
            "draw" => isset($_GET['draw']) ? intval($_GET['draw']) : 1,
            "recordsTotal" => count($reg),
            "recordsFiltered" => count($reg),
            "data" => $data
        );

        header('Content-Type: application/json');
        echo json_encode($results);
        exit();

    } else {
        $results = array(
            "draw" => isset($_GET['draw']) ? intval($_GET['draw']) : 1,
            "recordsTotal" => 0,
            "recordsFiltered" => 0,
            "data" => []
        );
        header('Content-Type: application/json');
        echo json_encode($results);
        exit();
    }
    ############################# MUESTRO JSON PARA PRODUCTOS ############################


############################# MUESTRO JSON PARA COMPRAS ############################
} elseif (isset($_GET['CargaCompras']) && isset($_GET['tipobusqueda']) && isset($_GET['search_criterio']) && isset($_GET['desde']) && isset($_GET['hasta'])) {

    $tipobusqueda    = limpiar($_GET['tipobusqueda']);
    $search_criterio = limpiar($_GET['search_criterio']);
    $desde           = limpiar($_GET['desde']);
    $hasta           = limpiar($_GET['hasta']);

    $reg = $tra->BusquedaCompras();

    $data = array();
    if (!empty($reg)) {

        $a = 1;
        foreach ($reg as $compra) {
            $simbolo        = ($compra['simbolo'] == "" ? "" : "<strong>".$compra['simbolo']."</strong>");

            #################### ESTADO DE VENTA ####################
            $estado = '';
            if($compra["statuscompra"] == 'PAGADA') { 
            $estado = "<span class='badge badge-info font-12 alert-link'><i class='fa fa-check'></i> ".$compra["statuscompra"]."</span>"; 
            } elseif($compra['fechavencecredito'] >= date("Y-m-d") && $compra['fechapagado'] == "0000-00-00" && $compra["statuscompra"] == 'PENDIENTE') { 
            $estado = "<span class='badge badge-success font-12 alert-link'><i class='fa fa-exclamation-triangle'></i> CRÉDITO</span>"; 
            } elseif($compra['fechavencecredito'] < date("Y-m-d") && $compra['fechapagado'] == "0000-00-00" && $compra['statuscompra'] == "PENDIENTE"){ 
            $estado = "<span class='badge badge-danger font-12 alert-link'><i class='fa fa-times'></i> CRÉDITO<br>VENCIDO </span>";
            } else { 
            $estado = "<span class='badge badge-warning font-12 alert-link text-white'><i class='fa fa-exclamation-circle'></i> ".$compra["statuscompra"]."</span>"; 
            }
            #################### ESTADO DE VENTA ####################

            // #################### DETALLE DE ACCIONES ####################
            $acciones = '
            <span class="text-success" style="cursor: pointer;" data-toggle="modal" data-target="#myModalDetalle" title="Ver" onClick="VerCompra(\''.encrypt($compra["codcompra"]).'\',\''.encrypt($compra["codsucursal"]).'\',1)"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-eye"><path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"></path><circle cx="12" cy="12" r="3"></circle></svg></span>';

            if ($_SESSION['acceso'] == "administradorS" || $_SESSION["acceso"] == "secretaria") {
                $acciones .= ' <span class="text-info" style="cursor: pointer;" title="Editar" onClick="UpdateCompra(\''.encrypt($compra["codcompra"]).'\',\''.encrypt($compra["codsucursal"]).'\',\''.encrypt("U").'\',\''.encrypt("1").'\');"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-edit"><path d="M11 4H4a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2v-7"></path><path d="M18.5 2.5a2.121 2.121 0 0 1 3 3L12 15l-4 1 1-4 9.5-9.5z"></path></svg></span>

                <span class="text-warning" style="cursor: pointer;" title="Agregar" onClick="AgregaDetalleCompra(\''.encrypt($compra["codcompra"]).'\',\''.encrypt($compra["codsucursal"]).'\',\''.encrypt("A").'\',\''.encrypt("1").'\');"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-file-plus"><path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"></path><polyline points="14 2 14 8 20 8"></polyline><line x1="12" y1="18" x2="12" y2="12"></line><line x1="9" y1="15" x2="15" y2="15"></line></svg></span>

                <span class="text-danger" style="cursor: pointer;" title="Eliminar" onClick="EliminarCompra(\''.encrypt($compra["codcompra"]).'\',\''.encrypt($compra["codproveedor"]).'\',\''.encrypt($compra["codsucursal"]).'\',\''."P".'\',\''.encrypt("COMPRAS").'\')"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-trash-2 icon"><polyline points="3 6 5 6 21 6"></polyline><path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"></path><line x1="10" y1="11" x2="10" y2="17"></line><line x1="14" y1="11" x2="14" y2="17"></line></svg></span>';
            }

            $acciones .= '<span class="text-default" style="cursor: pointer;" title="Imprimir Documento" ';
            $acciones .= 'onClick="VentanaCentrada(\'reportepdf?codcompra='.encrypt($compra["codcompra"]).'&codsucursal='.encrypt($compra['codsucursal']).'&tipo='.encrypt("FACTURACOMPRA").'\', \'\', \'\', \'1024\', \'568\', \'true\');">';
            $acciones .= '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-printer"><polyline points="6 9 6 2 18 2 18 9"></polyline><path d="M6 18H4a2 2 0 0 1-2-2v-5a2 2 0 0 1 2-2h16a2 2 0 0 1 2 2v5a2 2 0 0 1-2 2h-2"></path><rect x="6" y="14" width="12" height="8"></rect></svg></span>
            ';
            // #################### FIN DETALLE DE ACCIONES ####################
           
            $data[] = array(
                $a++, // Código como primer elemento para DataTables sorting
                "<span class='text-dark alert-link'> FACTURA</span><br><span class='text-danger alert-link'> Nº: ".$compra['codfactura']."</span>",
                "<span class='text-dark alert-link'>Nº ".$documproveedor = ($compra['documproveedor'] == '0' ? "DOCUMENTO" : $compra['documento3']).": ".$compra['cuitproveedor']."</span><br> ".$compra['nomproveedor'],
                $compra['articulos'],
                $simbolo.number_format($compra['descontado']+$compra['totaldescuento'], 0, '.', '.'), // Sin el símbolo aquí
                $simbolo.number_format($compra['subtotalivasi']+$compra['subtotalivano'], 0, '.', '.'), // Sin el símbolo aquí
                $simbolo.number_format($compra['totaliva'], 0, '.', '.')."<sup>".number_format($compra['iva'], 0, '.', '.')."%</sup>", // Sin el símbolo aquí
                $simbolo.number_format($compra['totalpago']+$compra["gastoenvio"], 0, '.', '.'), // Sin el símbolo aquí
                nl2br($estado),
                date("d/m/Y",strtotime($compra['fechaemision'])),
                $acciones
            );
        }

        $results = array(
            "draw" => isset($_GET['draw']) ? intval($_GET['draw']) : 1,
            "recordsTotal" => count($reg),
            "recordsFiltered" => count($reg),
            "data" => $data
        );

        header('Content-Type: application/json');
        echo json_encode($results);
        exit();

    } else {
        $results = array(
            "draw" => isset($_GET['draw']) ? intval($_GET['draw']) : 1,
            "recordsTotal" => 0,
            "recordsFiltered" => 0,
            "data" => []
        );
        header('Content-Type: application/json');
        echo json_encode($results);
        exit();
    }
    ############################# MUESTRO JSON PARA COMPRAS ############################


############################# MUESTRO JSON PARA CUENTAS X PAGAR ############################
} elseif (isset($_GET['CargaCuentasxPagar']) && isset($_GET['tipobusqueda']) && isset($_GET['search_criterio']) && isset($_GET['desde']) && isset($_GET['hasta'])) {

    $tipobusqueda    = limpiar($_GET['tipobusqueda']);
    $search_criterio = limpiar($_GET['search_criterio']);
    $desde           = limpiar($_GET['desde']);
    $hasta           = limpiar($_GET['hasta']);

    $reg = $tra->BusquedaCuentasxPagar();

    $data = array();
    if (!empty($reg)) {

        $a = 1;
        foreach ($reg as $compra) {
            $simbolo        = ($compra['simbolo'] == "" ? "" : "<strong>".$compra['simbolo']."</strong>");

            #################### ESTADO DE COMPRA ####################
            $estado = '';
            if($compra["statuscompra"] == 'PAGADA') { 
            $estado = "<span class='badge badge-info font-12 alert-link'><i class='fa fa-check'></i> ".$compra["statuscompra"]."</span>"; 
            } elseif($compra['fechavencecredito'] >= date("Y-m-d") && $compra['fechapagado'] == "0000-00-00" && $compra["statuscompra"] == 'PENDIENTE') { 
            $estado = "<span class='badge badge-success font-12 alert-link'><i class='fa fa-exclamation-triangle'></i> CRÉDITO</span>"; 
            } elseif($compra['fechavencecredito'] < date("Y-m-d") && $compra['fechapagado'] == "0000-00-00" && $compra['statuscompra'] == "PENDIENTE"){ 
            $estado = "<span class='badge badge-danger font-12 alert-link'><i class='fa fa-times'></i> CRÉDITO<br>VENCIDO </span>"; 
            } else { 
            $estado = "<span class='badge badge-warning font-12 alert-link text-white'><i class='fa fa-exclamation-circle'></i> ".$compra["statuscompra"]."</span>"; 
            }
            #################### ESTADO DE COMPRA ####################

            // #################### DETALLE DE ACCIONES ####################
            $acciones = '
            <span class="text-success" style="cursor: pointer;" data-toggle="modal" data-target="#myModalDetalle" title="Ver" onClick="VerCompra(\''.encrypt($compra["codcompra"]).'\',\''.encrypt($compra["codsucursal"]).'\',2)"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-eye"><path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"></path><circle cx="12" cy="12" r="3"></circle></svg></span>';

            if ($_SESSION['acceso'] == "administradorS" || $_SESSION["acceso"] == "secretaria") {
                $acciones .= ' <span class="text-info" style="cursor: pointer;" title="Editar" onClick="UpdateCompra(\''.encrypt($compra["codcompra"]).'\',\''.encrypt($compra["codsucursal"]).'\',\''.encrypt("U").'\',\''.encrypt("2").'\');"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-edit"><path d="M11 4H4a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2v-7"></path><path d="M18.5 2.5a2.121 2.121 0 0 1 3 3L12 15l-4 1 1-4 9.5-9.5z"></path></svg></span>

                <span class="text-warning" style="cursor: pointer;" title="Agregar" onClick="AgregaDetalleCompra(\''.encrypt($compra["codcompra"]).'\',\''.encrypt($compra["codsucursal"]).'\',\''.encrypt("A").'\',\''.encrypt("2").'\');"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-file-plus"><path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"></path><polyline points="14 2 14 8 20 8"></polyline><line x1="12" y1="18" x2="12" y2="12"></line><line x1="9" y1="15" x2="15" y2="15"></line></svg></span>';
            }

            if (($_SESSION['acceso'] == "administradorS" || $_SESSION["acceso"] == "secretaria") && $compra['statuscompra'] != "PAGADA") {
                $acciones .= ' <span class="text-primary" style="cursor: pointer;" data-toggle="modal" data-target="#ModalAbonosCompra" title="Abonar" onClick="AbonoCreditoCompra(
                \''.encrypt($compra["codcompra"]).'\',
                \''.$compra["codfactura"].'\',
                \''.encrypt($compra["codsucursal"]).'\',
                \''.encrypt($compra["codproveedor"]).'\',
                \''.$documproveedor = ($compra["documproveedor"] == 0 ? "" : $compra["documento3"].": ".$compra["cuitproveedor"]).'\',
                \''.$compra["nomproveedor"].'\',
                \''.number_format($compra["totalpago"]+$compra["gastoenvio"], 2, '.', '').'\',
                \''.date("d-m-Y",strtotime($compra['fechaemision'])).'\',
                \''.number_format($compra["totalpago"]+$compra["gastoenvio"]-$compra['creditopagado'], 2, '.', '').'\',
                \''.number_format($compra['creditopagado'], 2, '.', '').'\');"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-credit-card"><rect x="1" y="4" width="22" height="16" rx="2" ry="2"></rect><line x1="1" y1="10" x2="23" y2="10"></line></svg></span>';
            }

            $acciones .= ' <span class="text-danger" style="cursor: pointer;" title="Eliminar" onClick="EliminarCompra(\''.encrypt($compra["codcompra"]).'\',\''.encrypt($compra["codproveedor"]).'\',\''.encrypt($compra["codsucursal"]).'\',\''."D".'\',\''.encrypt("COMPRAS").'\')"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-trash-2 icon"><polyline points="3 6 5 6 21 6"></polyline><path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"></path><line x1="10" y1="11" x2="10" y2="17"></line><line x1="14" y1="11" x2="14" y2="17"></line></svg></span>';

            $acciones .= ' <span class="text-default" style="cursor: pointer;" title="Ticket Abonos" ';
            $acciones .= 'onClick="VentanaCentrada(\'reportepdf?codcompra='.encrypt($compra["codcompra"]).'&codsucursal='.encrypt($compra['codsucursal']).'&tipo='.encrypt("TICKETCOMPRA").'\', \'\', \'\', \'1024\', \'568\', \'true\');">';
            $acciones .= '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-folder-plus"><path d="M22 19a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h5l2 3h9a2 2 0 0 1 2 2z"></path><line x1="12" y1="11" x2="12" y2="17"></line><line x1="9" y1="14" x2="15" y2="14"></line></svg></span>';

            $acciones .= ' <span class="text-default" style="cursor: pointer;" title="Imprimir FACTURA" ';
            $acciones .= 'onClick="VentanaCentrada(\'reportepdf?codcompra='.encrypt($compra["codcompra"]).'&codsucursal='.encrypt($compra['codsucursal']).'&tipo='.encrypt("FACTURACOMPRA").'\', \'\', \'\', \'1024\', \'568\', \'true\');">';
            $acciones .= '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-printer"><polyline points="6 9 6 2 18 2 18 9"></polyline><path d="M6 18H4a2 2 0 0 1-2-2v-5a2 2 0 0 1 2-2h16a2 2 0 0 1 2 2v5a2 2 0 0 1-2 2h-2"></path><rect x="6" y="14" width="12" height="8"></rect></svg></span>
            ';
            // #################### FIN DETALLE DE ACCIONES ####################
           
            $data[] = array(
                $a++, // Código como primer elemento para DataTables sorting
                "<span class='text-dark alert-link'>FACTURA</span><br><span class='text-danger alert-link'> Nº: ".$compra['codfactura']."</span>",
                "<span class='text-dark alert-link'>Nº ".$documproveedor = ($compra['documproveedor'] == '0' ? "DOCUMENTO" : $compra['documento3']).": ".$compra['cuitproveedor']."</span><br> ".$compra['nomproveedor'],
                $simbolo.number_format($compra['totalpago']+$compra['gastoenvio'], 0, '.', '.'), // Sin el símbolo aquí
                $simbolo.number_format($compra['creditopagado'], 0, '.', '.'), // Sin el símbolo aquí
                $simbolo.number_format($compra['totalpago']+$compra['gastoenvio']-$compra['creditopagado'], 0, '.', '.'), // Sin el símbolo aquí
                nl2br($estado), // Sin el símbolo aquí
                date("d/m/Y",strtotime($compra['fechaemision'])), // Sin el símbolo aquí
                date("d/m/Y",strtotime($compra['fechavencecredito'])),
                $acciones
            );
        }

        $results = array(
            "draw" => isset($_GET['draw']) ? intval($_GET['draw']) : 1,
            "recordsTotal" => count($reg),
            "recordsFiltered" => count($reg),
            "data" => $data
        );

        header('Content-Type: application/json');
        echo json_encode($results);
        exit();

    } else {
        $results = array(
            "draw" => isset($_GET['draw']) ? intval($_GET['draw']) : 1,
            "recordsTotal" => 0,
            "recordsFiltered" => 0,
            "data" => []
        );
        header('Content-Type: application/json');
        echo json_encode($results);
        exit();
    }
    ############################# MUESTRO JSON PARA CUENTAS X PAGAR ############################


############################# MUESTRO JSON PARA COTIZACIONES ############################
} elseif (isset($_GET['CargaCotizaciones']) && isset($_GET['tipobusqueda']) && isset($_GET['search_criterio']) && isset($_GET['desde']) && isset($_GET['hasta'])) {

    $tipobusqueda    = limpiar($_GET['tipobusqueda']);
    $search_criterio = limpiar($_GET['search_criterio']);
    $desde           = limpiar($_GET['desde']);
    $hasta           = limpiar($_GET['hasta']);

    $reg = $tra->BusquedaCotizaciones();

    $data = array();
    if (!empty($reg)) {

        $a = 1;
        foreach ($reg as $cotizacion) {
            $simbolo        = ($cotizacion['simbolo'] == "" ? "" : "<strong>".$cotizacion['simbolo']."</strong>");

            #################### DATOS DE CLIENTE ####################
            $datos_cliente = '';
            if ($cotizacion['codcliente'] == '0'){
            $datos_cliente = "<span class='text-dark alert-link'>CONSUMIDOR FINAL</span>";
            } else {
            $datos_cliente = "<span class='text-dark alert-link'>Nº ".$documcliente = ($cotizacion['documcliente'] == '0' ? "DOCUMENTO" : $cotizacion['documento3']).": ".$cotizacion['dnicliente']."</span><br> ".$cotizacion['nomcliente'];
            }
            #################### DATOS DE CLIENTE ####################

            #################### ESTADO DE VENTA ####################
            $estado = '';
            if($cotizacion['procesada'] == 1){
            $estado = "<span class='badge badge-success font-12 alert-link'><i class='fa fa-info'></i> PENDIENTE</span>";
            } elseif($cotizacion['procesada'] == 2){
            $estado = "<span class='badge badge-info font-12 alert-link'><i class='fa fa-check'></i> PROCESADA</span>"; 
            }
            #################### ESTADO DE VENTA ####################

            #################### FECHA DE VENTA ####################
            $fecha_actual     = date("Y-m-d");
            $fecha_cotizacion = date("d/m/Y",strtotime($cotizacion['fechacotizacion']))."<br><span class='text-dark alert-link'>".date("H:i:s",strtotime($cotizacion['fechacotizacion']))."</span>";
            #################### FECHA DE VENTA ####################

            // #################### DETALLE DE ACCIONES ####################
            $acciones = '
            <span class="text-success" style="cursor: pointer;" data-toggle="modal" data-target="#myModalDetalle" title="Ver" onClick="VerCotizacion(\''.encrypt($cotizacion["codcotizacion"]).'\',\''.encrypt($cotizacion["codsucursal"]).'\')"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-eye"><path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"></path><circle cx="12" cy="12" r="3"></circle></svg></span>';

            if (($_SESSION['acceso'] == "administradorS" || $_SESSION["acceso"] == "secretaria" || $_SESSION["acceso"] == "cajero") && $cotizacion["procesada"] == 1) {
                $acciones .= ' <span class="text-info" style="cursor: pointer;" title="Editar" onClick="UpdateCotizacion(\''.encrypt($cotizacion["codcotizacion"]).'\',\''.encrypt($cotizacion["codsucursal"]).'\',\''.encrypt("U").'\');"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-edit"><path d="M11 4H4a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2v-7"></path><path d="M18.5 2.5a2.121 2.121 0 0 1 3 3L12 15l-4 1 1-4 9.5-9.5z"></path></svg></span>

                <span class="text-warning" style="cursor: pointer;" title="Agregar" onClick="AgregaDetalleCotizacion(\''.encrypt($cotizacion["codcotizacion"]).'\',\''.encrypt($cotizacion["codsucursal"]).'\',\''.encrypt("A").'\');"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-file-plus"><path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"></path><polyline points="14 2 14 8 20 8"></polyline><line x1="12" y1="18" x2="12" y2="12"></line><line x1="9" y1="15" x2="15" y2="15"></line></svg></span>';

                if($_SESSION['acceso'] == "administradorS" && $cotizacion["procesada"] == 1 || $cotizacion["codigo"] == $_SESSION['codigo'] && $cotizacion["procesada"] == 1){
                $acciones .= ' <span class="text-danger" style="cursor: pointer;" title="Eliminar" onClick="EliminarCotizacion(\''.encrypt($cotizacion["codcotizacion"]).'\',\''.encrypt($cotizacion["codsucursal"]).'\',\''.encrypt("COTIZACIONES").'\')"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-trash-2 icon"><polyline points="3 6 5 6 21 6"></polyline><path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"></path><line x1="10" y1="11" x2="10" y2="17"></line><line x1="14" y1="11" x2="14" y2="17"></line></svg></span>';
                }
            }

            if (($_SESSION['acceso'] == "administradorS" || $_SESSION["acceso"] == "cajero") && $cotizacion["procesada"] == 1) {
                $acciones .= ' <span class="text-primary" style="cursor: pointer;" data-toggle="modal" data-target="#myModal" title="Procesar Cotizacion" onClick="ProcesaCotizacion(
                \''.encrypt($cotizacion["codcotizacion"]).'\',
                \''.encrypt($cotizacion["codsucursal"]).'\',
                \''.$cotizacion["codcliente"].'\',
                \''.$dnicliente = ($cotizacion['codcliente'] == '0' ? "0" : $cotizacion['dnicliente']).'\',
                \''.$nomcliente = ($cotizacion['codcliente'] == '0' ? "CONSUMIDOR FINAL" : $documento = ($cotizacion['documcliente'] == '0' ? "DOCUMENTO" : $cotizacion['documento']).": ".$cotizacion['dnicliente'].": ".$cotizacion['nomcliente']).'\',
                \''.$nomcliente2 = ($cotizacion['codcliente'] == '0' ? "CONSUMIDOR FINAL" : $cotizacion['nomcliente']).'\',
                \''.number_format($cotizacion['codcliente'] == '0' ? "0.00" : $cotizacion["limitecredito"], 2, '.', '').'\',
                \''.number_format($cotizacion["totalpago"], 2, '.', '').'\');"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-server"><rect x="2" y="2" width="20" height="8" rx="2" ry="2"></rect><rect x="2" y="14" width="20" height="8" rx="2" ry="2"></rect><line x1="6" y1="6" x2="6.01" y2="6"></line><line x1="6" y1="18" x2="6.01" y2="18"></line></svg></span>';
            }

            $acciones .= ' <span class="text-default" style="cursor: pointer;" title="Imprimir Documento" ';
            $acciones .= 'onClick="VentanaCentrada(\'reportepdf?codcotizacion='.encrypt($cotizacion["codcotizacion"]).'&codsucursal='.encrypt($cotizacion['codsucursal']).'&tipo='.encrypt($cotizacion['tipodocumento']).'\', \'\', \'\', \'1024\', \'568\', \'true\');">';
            $acciones .= '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-printer"><polyline points="6 9 6 2 18 2 18 9"></polyline><path d="M6 18H4a2 2 0 0 1-2-2v-5a2 2 0 0 1 2-2h16a2 2 0 0 1 2 2v5a2 2 0 0 1-2 2h-2"></path><rect x="6" y="14" width="12" height="8"></rect></svg></span>
            ';
            // #################### FIN DETALLE DE ACCIONES ####################
           
            $data[] = array(
                $a++, // Código como primer elemento para DataTables sorting
                "<span class='text-danger alert-link'> Nº: ".$cotizacion['codfactura']."</span>",
                $datos_cliente,
                $cotizacion['articulos'],
                $simbolo.number_format($cotizacion['descontado']+$cotizacion['totaldescuento'], 0, '.', '.'), // Sin el símbolo aquí
                $simbolo.number_format($cotizacion['subtotalivasi']+$cotizacion['subtotalivano'], 0, '.', '.'), // Sin el símbolo aquí
                $simbolo.number_format($cotizacion['totaliva'], 0, '.', '.')."<sup>".number_format($cotizacion['iva'], 0, '.', '.')."%</sup>",
                $simbolo.number_format($cotizacion['totalpago'], 0, '.', '.'), // Sin el símbolo aquí
                nl2br($estado),
                $fecha_cotizacion,
                $acciones
            );
        }

        $results = array(
            "draw" => isset($_GET['draw']) ? intval($_GET['draw']) : 1,
            "recordsTotal" => count($reg),
            "recordsFiltered" => count($reg),
            "data" => $data
        );

        header('Content-Type: application/json');
        echo json_encode($results);
        exit();

    } else {
        $results = array(
            "draw" => isset($_GET['draw']) ? intval($_GET['draw']) : 1,
            "recordsTotal" => 0,
            "recordsFiltered" => 0,
            "data" => []
        );
        header('Content-Type: application/json');
        echo json_encode($results);
        exit();
    }
    ############################# MUESTRO JSON PARA COTIZACIONES ############################



############################# MUESTRO JSON PARA VENTAS ############################
} elseif (isset($_GET['CargaVentas']) && isset($_GET['tipobusqueda']) && isset($_GET['search_criterio']) && isset($_GET['desde']) && isset($_GET['hasta'])) {

    $tipobusqueda    = limpiar($_GET['tipobusqueda']);
    $search_criterio = limpiar($_GET['search_criterio']);
    $desde           = limpiar($_GET['desde']);
    $hasta           = limpiar($_GET['hasta']);

    $reg = $tra->BusquedaVentas();

    $data = array();
    if (!empty($reg)) {

        $a = 1;
        foreach ($reg as $venta) {
            $simbolo        = ($venta['simbolo'] == "" ? "" : "<strong>".$venta['simbolo']."</strong>");
            $tipo_documento = ($venta['tipodocumento'] == 'FACTURA_A4' ? "FACTURA" : $venta['tipodocumento']);

            #################### DATOS DE CLIENTE ####################
            $datos_cliente = '';
            if ($venta['codcliente'] == '0'){
            $datos_cliente = "<span class='text-dark alert-link'>CONSUMIDOR FINAL</span>";
            } else {
            $datos_cliente = "<span class='text-dark alert-link'>Nº ".$documcliente = ($venta['documcliente'] == '0' ? "DOCUMENTO" : $venta['documento3']).": ".$venta['dnicliente']."</span><br> ".$venta['nomcliente'];
            }
            #################### DATOS DE CLIENTE ####################

            #################### ESTADO DE VENTA ####################
            $estado = '';
            if($venta["statusventa"] == 'PAGADA') { 
            $estado = "<span class='badge badge-info font-12 alert-link'><i class='fa fa-check'></i> ".$venta["statusventa"]."</span>"; 
            } elseif($venta['fechavencecredito'] >= date("Y-m-d") && $venta['fechapagado'] == "0000-00-00" && $venta["statusventa"] == 'PENDIENTE') { 
            $estado = "<span class='badge badge-success font-12 alert-link'><i class='fa fa-exclamation-triangle'></i> CRÉDITO</span>"; 
            } elseif($venta['fechavencecredito'] < date("Y-m-d") && $venta['fechapagado'] == "0000-00-00" && $venta['statusventa'] == "PENDIENTE"){ 
            $estado = "<span class='badge badge-danger font-12 alert-link'><i class='fa fa-times'></i> CRÉDITO<br>VENCIDO </span>";
            } else { 
            $estado = "<span class='badge badge-warning font-12 alert-link text-white'><i class='fa fa-exclamation-circle'></i> ".nl2br($venta["statusventa"])."</span>"; 
            }
            #################### ESTADO DE VENTA ####################

            #################### FECHA DE VENTA ####################
            $fecha_actual  = date("Y-m-d");
            $fecha_venta   = date("d/m/Y",strtotime($venta['fechaventa']))."<br><span class='text-dark alert-link'>".date("H:i:s",strtotime($venta['fechaventa']))."</span>";
            #################### FECHA DE VENTA ####################

            // #################### DETALLE DE ACCIONES ####################
            $acciones = '
            <span class="text-success" style="cursor: pointer;" data-toggle="modal" data-target="#myModalDetalle" title="Ver" onClick="VerVenta(\''.encrypt($venta["codventa"]).'\',\''.encrypt($venta["codsucursal"]).'\')"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-eye"><path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"></path><circle cx="12" cy="12" r="3"></circle></svg></span>';

            if (($_SESSION['acceso'] == "administradorS" || $venta["codigo"] == $_SESSION['codigo']) && $venta['notacredito'] == 0) {
                $acciones .= ' <span class="text-info" style="cursor: pointer;" title="Editar" onClick="UpdateVenta(\''.encrypt($venta["codventa"]).'\',\''.encrypt($venta["codsucursal"]).'\',\''.encrypt("U").'\');"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-edit"><path d="M11 4H4a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2v-7"></path><path d="M18.5 2.5a2.121 2.121 0 0 1 3 3L12 15l-4 1 1-4 9.5-9.5z"></path></svg></span>';

                if($venta['statusarqueo'] == 1){
                $acciones .= ' <span class="text-danger" style="cursor: pointer;" title="Eliminar" onClick="EliminarVenta(\''.encrypt($venta["codventa"]).'\',\''.encrypt($venta["codcliente"]).'\',\''.encrypt($venta["codsucursal"]).'\',\''.encrypt("VENTAS").'\')"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-trash-2 icon"><polyline points="3 6 5 6 21 6"></polyline><path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"></path><line x1="10" y1="11" x2="10" y2="17"></line><line x1="14" y1="11" x2="14" y2="17"></line></svg></span>';
                }
            }

            $acciones .= ' <span class="text-default" style="cursor: pointer;" title="Imprimir '.$tipo_documento.'" ';
            $acciones .= 'onClick="VentanaCentrada(\'reportepdf?codventa='.encrypt($venta["codventa"]).'&codsucursal='.encrypt($venta['codsucursal']).'&tipo='.encrypt($venta['tipodocumento']).'\', \'\', \'\', \'1024\', \'568\', \'true\');">';
            $acciones .= '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-printer"><polyline points="6 9 6 2 18 2 18 9"></polyline><path d="M6 18H4a2 2 0 0 1-2-2v-5a2 2 0 0 1 2-2h16a2 2 0 0 1 2 2v5a2 2 0 0 1-2 2h-2"></path><rect x="6" y="14" width="12" height="8"></rect></svg></span>
            ';
            // #################### FIN DETALLE DE ACCIONES ####################
           
            $data[] = array(
                $a++, // Código como primer elemento para DataTables sorting
                "<span class='text-dark alert-link'>".$tipo_documento."</span><br><span class='text-danger alert-link'> Nº: ".$venta['codfactura']."</span>",
                "<span class='text-dark alert-link'>Nº DOCUMENTO: ".$venta['dni']."</span><br> ".$venta['nombres'],
                $datos_cliente,
                $simbolo.number_format($venta['descontado']+$venta['totaldescuento'], 0, '.', '.'), // Sin el símbolo aquí
                $simbolo.number_format($venta['subtotalivasi']+$venta['subtotalivano'], 0, '.', '.'), // Sin el símbolo aquí
                $simbolo.number_format($venta['totaliva'], 0, '.', '.')."<sup>".number_format($venta['iva'], 0, '.', '.')."%</sup>", // Sin el símbolo aquí
                $simbolo.number_format($venta['totalpago'], 0, '.', '.'), // Sin el símbolo aquí
                nl2br($estado),
                $fecha_venta,
                $acciones
            );
        }

        $results = array(
            "draw" => isset($_GET['draw']) ? intval($_GET['draw']) : 1,
            "recordsTotal" => count($reg),
            "recordsFiltered" => count($reg),
            "data" => $data
        );

        header('Content-Type: application/json');
        echo json_encode($results);
        exit();

    } else {
        $results = array(
            "draw" => isset($_GET['draw']) ? intval($_GET['draw']) : 1,
            "recordsTotal" => 0,
            "recordsFiltered" => 0,
            "data" => []
        );
        header('Content-Type: application/json');
        echo json_encode($results);
        exit();
    }
    ############################# MUESTRO JSON PARA VENTAS ############################



############################# MUESTRO JSON PARA VENTAS DIARIAS ############################
} elseif (isset($_GET['CargaVentasDiarias'])){

    $reg = $tra->BuscarVentasDiarias();

    $data = array();
    if (!empty($reg)) {

        $a = 1;
        foreach ($reg as $venta) {
            $simbolo          = ($venta['simbolo'] == "" ? "" : "<strong>".$venta['simbolo']."</strong>");
            $tipo_documento = ($venta['tipodocumento'] == 'FACTURA_A4' ? "FACTURA" : $venta['tipodocumento']);

            #################### DATOS DE CLIENTE ####################
            $datos_cliente = '';
            if ($venta['codcliente'] == '0'){
            $datos_cliente = "<span class='text-dark alert-link'>CONSUMIDOR FINAL</span>";
            } else {
            $datos_cliente = "<span class='text-dark alert-link'>Nº ".$documcliente = ($venta['documcliente'] == '0' ? "DOCUMENTO" : $venta['documento3']).": ".$venta['dnicliente']."</span><br> ".$venta['nomcliente'];
            }
            #################### DATOS DE CLIENTE ####################

            #################### ESTADO DE VENTA ####################
            $estado = '';
            if($venta["statusventa"] == 'PAGADA') { 
            $estado = "<span class='badge badge-info font-12 alert-link'><i class='fa fa-check'></i> ".$venta["statusventa"]."</span>"; 
            } elseif($venta['fechavencecredito'] >= date("Y-m-d") && $venta['fechapagado'] == "0000-00-00" && $venta["statusventa"] == 'PENDIENTE') { 
            $estado = "<span class='badge badge-success font-12 alert-link'><i class='fa fa-exclamation-triangle'></i> CRÉDITO</span>"; 
            } elseif($venta['fechavencecredito'] < date("Y-m-d") && $venta['fechapagado'] == "0000-00-00" && $venta['statusventa'] == "PENDIENTE"){ 
            $estado = "<span class='badge badge-danger font-12 alert-link'><i class='fa fa-times'></i> CRÉDITO<br>VENCIDO </span>";
            } else { 
            $estado = "<span class='badge badge-warning font-12 alert-link text-white'><i class='fa fa-exclamation-circle'></i> ".nl2br($venta["statusventa"])."</span>"; 
            }
            #################### ESTADO DE VENTA ####################

            #################### FECHA DE VENTA ####################
            $fecha_actual  = date("Y-m-d");
            $fecha_venta   = date("d/m/Y",strtotime($venta['fechaventa']))."<br><span class='text-dark alert-link'>".date("H:i:s",strtotime($venta['fechaventa']))."</span>";
            #################### FECHA DE VENTA ####################

            // #################### DETALLE DE ACCIONES ####################
            $acciones = '
            <span class="text-success" style="cursor: pointer;" data-toggle="modal" data-target="#myModalDetalle" title="Ver" onClick="VerVenta(\''.encrypt($venta["codventa"]).'\',\''.encrypt($venta["codsucursal"]).'\')"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-eye"><path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"></path><circle cx="12" cy="12" r="3"></circle></svg></span>';

            $acciones .= ' <span class="text-default" style="cursor: pointer;" title="Imprimir '.$tipo_documento.'" ';
            $acciones .= 'onClick="VentanaCentrada(\'reportepdf?codventa='.encrypt($venta["codventa"]).'&codsucursal='.encrypt($venta['codsucursal']).'&tipo='.encrypt($venta['tipodocumento']).'\', \'\', \'\', \'1024\', \'568\', \'true\');">';
            $acciones .= '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-printer"><polyline points="6 9 6 2 18 2 18 9"></polyline><path d="M6 18H4a2 2 0 0 1-2-2v-5a2 2 0 0 1 2-2h16a2 2 0 0 1 2 2v5a2 2 0 0 1-2 2h-2"></path><rect x="6" y="14" width="12" height="8"></rect></svg></span>
            ';
            // #################### FIN DETALLE DE ACCIONES ####################
           
            $data[] = array(
                $a++, // Código como primer elemento para DataTables sorting
                "<span class='text-dark alert-link'>".$tipo_documento."</span><br><span class='text-danger alert-link'> Nº: ".$venta['codfactura']."</span>",
                "<span class='text-dark alert-link'>Nº DOCUMENTO: ".$venta['dni']."</span><br> ".$venta['nombres'],
                $datos_cliente,
                $simbolo.number_format($venta['descontado']+$venta['totaldescuento'], 0, '.', '.'), // Sin el símbolo aquí
                $simbolo.number_format($venta['subtotalivasi']+$venta['subtotalivano'], 0, '.', '.'), // Sin el símbolo aquí
                $simbolo.number_format($venta['totaliva'], 0, '.', '.')."<sup>".number_format($venta['iva'], 0, '.', '.')."%</sup>", // Sin el símbolo aquí
                $simbolo.number_format($venta['totalpago'], 0, '.', '.'), // Sin el símbolo aquí
                nl2br($estado),
                $fecha_venta,
                $acciones
            );
        }

        $results = array(
            "draw" => isset($_GET['draw']) ? intval($_GET['draw']) : 1,
            "recordsTotal" => count($reg),
            "recordsFiltered" => count($reg),
            "data" => $data
        );

        header('Content-Type: application/json');
        echo json_encode($results);
        exit();

    } else {
        $results = array(
            "draw" => isset($_GET['draw']) ? intval($_GET['draw']) : 1,
            "recordsTotal" => 0,
            "recordsFiltered" => 0,
            "data" => []
        );
        header('Content-Type: application/json');
        echo json_encode($results);
        exit();
    }
    ############################# MUESTRO JSON PARA VENTAS DIARIAS ############################


############################# MUESTRO JSON PARA CUENTAS X COBRAR ############################
} elseif (isset($_GET['CargaCreditos']) && isset($_GET['tipobusqueda']) && isset($_GET['search_criterio']) && isset($_GET['desde']) && isset($_GET['hasta'])) {

    $tipobusqueda    = limpiar($_GET['tipobusqueda']);
    $search_criterio = limpiar($_GET['search_criterio']);
    $desde           = limpiar($_GET['desde']);
    $hasta           = limpiar($_GET['hasta']);

    $reg = $tra->BusquedaCreditos();

    $data = array();
    if (!empty($reg)) {

        $a = 1;
        foreach ($reg as $credito) {
            $simbolo        = ($credito['simbolo'] == "" ? "" : "<strong>".$credito['simbolo']."</strong>");
            $tipo_documento = ($credito['tipodocumento'] == "FACTURA_A4" ? "FACTURA" : $credito['tipodocumento']);

            #################### ESTADO DE VENTA ####################
            $estado = '';
            if($credito["statusventa"] == 'PAGADA') { 
            $estado = "<span class='badge badge-info font-12 alert-link'><i class='fa fa-check'></i> ".$credito["statusventa"]."</span>"; 
            } elseif($credito['fechavencecredito'] >= date("Y-m-d") && $credito['fechapagado'] == "0000-00-00" && $credito["statusventa"] == 'PENDIENTE') { 
            $estado = "<span class='badge badge-success font-12 alert-link'><i class='fa fa-exclamation-triangle'></i> CRÉDITO</span>"; 
            } elseif($credito['fechavencecredito'] < date("Y-m-d") && $credito['fechapagado'] == "0000-00-00" && $credito['statusventa'] == "PENDIENTE"){ 
            $estado = "<span class='badge badge-danger font-12 alert-link'><i class='fa fa-times'></i> CRÉDITO<br>VENCIDO </span>"; 
            }else { 
            $estado = "<span class='badge badge-warning font-12 alert-link text-white'><i class='fa fa-exclamation-circle'></i> ".nl2br($credito["statusventa"])."</span>"; 
            }
            #################### ESTADO DE VENTA ####################

            #################### DIAS VENCIDOS ####################
            $dias_vencidos = '';
            if($credito['fechavencecredito'] == '0000-00-00' || $credito['fechavencecredito'] != '0000-00-00' && $credito['fechapagado'] != "0000-00-00"){ 
            $dias_vencidos = "0"; 
            } elseif($credito['fechavencecredito'] >= date("Y-m-d") && $credito['fechapagado'] == "0000-00-00"){ 
            $dias_vencidos = "0"; 
            } elseif($credito['fechavencecredito'] < date("Y-m-d") && $credito['fechapagado'] == "0000-00-00"){ 
            $dias_vencidos = Dias_Transcurridos(date("Y-m-d"),$credito['fechavencecredito']); 
            } elseif($credito['fechavencecredito'] < date("Y-m-d") && $credito['fechapagado'] != "0000-00-00") { 
            $dias_vencidos = Dias_Transcurridos($credito['fechapagado'],$credito['fechavencecredito']); 
            }
            #################### DIAS VENCIDOS ####################

            #################### FECHA DE VENTA ####################
            $fecha_actual  = date("Y-m-d");
            $fecha_venta   = date("d/m/Y",strtotime($credito['fechaventa']))."<br><span class='text-dark alert-link'>".date("H:i:s",strtotime($credito['fechaventa']))."</span>";
            #################### FECHA DE VENTA ####################

            // #################### DETALLE DE ACCIONES ####################
            $acciones = '
            <span class="text-success" style="cursor: pointer;" data-toggle="modal" data-target="#myModalDetalle" title="Ver" onClick="VerCredito(\''.encrypt($credito["codventa"]).'\',\''.encrypt($credito["codsucursal"]).'\')"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-eye"><path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"></path><circle cx="12" cy="12" r="3"></circle></svg></span>';

            if (($_SESSION['acceso'] == "administradorS" || $_SESSION["acceso"] == "secretaria" || $_SESSION["acceso"] == "cajero") && $credito['statusventa'] != "PAGADA" && $credito['notacredito'] == "0") {
                $acciones .= ' <span class="text-primary" style="cursor: pointer;" data-toggle="modal" data-target="#myModalPago" title="Abonar" onClick="AbonoCreditoVenta(
                \''.encrypt($credito["codsucursal"]).'\',
                \''.$credito["codcliente"].'\',
                \''.encrypt($credito["codventa"]).'\',
                \''.$dnicliente = ($credito["documcliente"] == 0 ? "" : $credito["documento3"].": ".$credito["dnicliente"]." ".$credito["nomcliente"]).'\',
                \''.$credito["codfactura"].'\',
                \''.number_format($credito["totalpago"], 0, '.', '').'\',
                \''.date("d/m/Y H:i:s",strtotime($credito['fechaventa'])).'\',
                \''.number_format($credito["totalpago"]-$credito['creditopagado'], 0, '.', '').'\',
                \''.number_format($credito['creditopagado'], 0, '.', '').'\');"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-credit-card"><rect x="1" y="4" width="22" height="16" rx="2" ry="2"></rect><line x1="1" y1="10" x2="23" y2="10"></line></svg></span>';
            }

            $acciones .= ' <span class="text-default" style="cursor: pointer;" title="Ticket Abonos" ';
            $acciones .= 'onClick="VentanaCentrada(\'reportepdf?codventa='.encrypt($credito["codventa"]).'&codsucursal='.encrypt($credito['codsucursal']).'&tipo='.encrypt("TICKETCREDITO").'\', \'\', \'\', \'1024\', \'568\', \'true\');">';
            $acciones .= '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-folder-plus"><path d="M22 19a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h5l2 3h9a2 2 0 0 1 2 2z"></path><line x1="12" y1="11" x2="12" y2="17"></line><line x1="9" y1="14" x2="15" y2="14"></line></svg></span>';

            $acciones .= ' <span class="text-default" style="cursor: pointer;" title="Imprimir Documento" ';
            $acciones .= 'onClick="VentanaCentrada(\'reportepdf?codventa='.encrypt($credito["codventa"]).'&codsucursal='.encrypt($credito['codsucursal']).'&tipo='.encrypt($credito['tipodocumento']).'\', \'\', \'\', \'1024\', \'568\', \'true\');">';
            $acciones .= '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-printer"><polyline points="6 9 6 2 18 2 18 9"></polyline><path d="M6 18H4a2 2 0 0 1-2-2v-5a2 2 0 0 1 2-2h16a2 2 0 0 1 2 2v5a2 2 0 0 1-2 2h-2"></path><rect x="6" y="14" width="12" height="8"></rect></svg></span>
            ';
            // #################### FIN DETALLE DE ACCIONES ####################
           
            $data[] = array(
                $a++, // Código como primer elemento para DataTables sorting
                "<span class='text-dark alert-link'>".$tipo_documento."</span><br><span class='text-danger alert-link'> Nº: ".$credito['codfactura']."</span>",
                "<span class='text-dark alert-link'>Nº ".$documcliente = ($credito['documcliente'] == '0' ? "DOCUMENTO" : $credito['documento3']).": ".$credito['dnicliente']."</span><br> ".$credito['nomcliente'],
                $simbolo.number_format($credito['totalpago'], 0, '.', '.'), // Sin el símbolo aquí
                $simbolo.number_format($credito['creditopagado'], 0, '.', '.'), // Sin el símbolo aquí
                $simbolo.number_format($credito['totalpago']-$credito['creditopagado'], 0, '.', '.'), // Sin el símbolo aquí
                nl2br($estado),
                $dias_vencidos,
                $fecha_venta,
                $acciones
            );
        }

        $results = array(
            "draw" => isset($_GET['draw']) ? intval($_GET['draw']) : 1,
            "recordsTotal" => count($reg),
            "recordsFiltered" => count($reg),
            "data" => $data
        );

        header('Content-Type: application/json');
        echo json_encode($results);
        exit();

    } else {
        $results = array(
            "draw" => isset($_GET['draw']) ? intval($_GET['draw']) : 1,
            "recordsTotal" => 0,
            "recordsFiltered" => 0,
            "data" => []
        );
        header('Content-Type: application/json');
        echo json_encode($results);
        exit();
    }
    ############################# MUESTRO JSON PARA CUENTAS X COBRAR ############################

} else {
    // Si no se reciben los parámetros esperados, podrías devolver un error JSON
    header('Content-Type: application/json');
    echo json_encode(array("error" => "Parámetros incorrectos"));
    exit();
}
?>